package com.prof18.feedflow.shared.ui.utils

import androidx.compose.runtime.Composable
import androidx.compose.runtime.ProvidableCompositionLocal
import androidx.compose.runtime.staticCompositionLocalOf
import androidx.compose.ui.text.intl.Locale
import cafe.adriel.lyricist.LanguageTag
import cafe.adriel.lyricist.Lyricist
import cafe.adriel.lyricist.ProvideStrings
import cafe.adriel.lyricist.rememberStrings
import com.prof18.feedflow.i18n.EnFeedFlowStrings
import com.prof18.feedflow.i18n.FeedFlowStrings
import com.prof18.feedflow.i18n.feedFlowStrings

public val LocalFeedFlowStrings: ProvidableCompositionLocal<FeedFlowStrings> =
    staticCompositionLocalOf { EnFeedFlowStrings }

@Composable
public fun rememberFeedFlowStrings(
    defaultLanguageTag: LanguageTag = "en",
    currentLanguageTag: LanguageTag = Locale.current.toLanguageTag(),
): Lyricist<FeedFlowStrings> =
    rememberStrings(feedFlowStrings, defaultLanguageTag, currentLanguageTag)

@Composable
public fun ProvideFeedFlowStrings(
    lyricist: Lyricist<FeedFlowStrings>,
    content: @Composable () -> Unit,
) {
    ProvideStrings(lyricist, LocalFeedFlowStrings, content)
}
