package com.prof18.feedflow.shared.ui.accounts.icons

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

private var _Dropbox: ImageVector? = null

val Dropbox: ImageVector
    get() {
        if (_Dropbox != null) {
            return _Dropbox!!
        }
        _Dropbox = ImageVector.Builder(
            name = "Dropbox",
            defaultWidth = 32.dp,
            defaultHeight = 32.dp,
            viewportWidth = 32f,
            viewportHeight = 32f,
        ).apply {
            path(
                fill = SolidColor(Color.Black),
                fillAlpha = 1.0f,
                stroke = null,
                strokeAlpha = 1.0f,
                strokeLineWidth = 1.0f,
                strokeLineCap = StrokeCap.Butt,
                strokeLineJoin = StrokeJoin.Miter,
                strokeLineMiter = 1.0f,
                pathFillType = PathFillType.NonZero,
            ) {
                moveTo(11.78125f, 4.46875f)
                lineTo(11.15625f, 4.875f)
                lineTo(4.46875f, 9.1875f)
                lineTo(3.25f, 9.96875f)
                lineTo(4.40625f, 10.84375f)
                lineTo(7.90625f, 13.5f)
                lineTo(4.40625f, 16.15625f)
                lineTo(3.1875f, 17.0625f)
                lineTo(4.5f, 17.8125f)
                lineTo(8.125f, 19.9375f)
                lineTo(8.125f, 23.28125f)
                lineTo(8.5625f, 23.5625f)
                lineTo(15.4375f, 28.09375f)
                lineTo(16f, 28.46875f)
                lineTo(16.5625f, 28.09375f)
                lineTo(23.4375f, 23.625f)
                lineTo(23.875f, 23.3125f)
                lineTo(23.875f, 19.96875f)
                lineTo(27.5f, 17.8125f)
                lineTo(28.71875f, 17.09375f)
                lineTo(27.65625f, 16.1875f)
                lineTo(24.3125f, 13.34375f)
                lineTo(27.625f, 10.625f)
                lineTo(28.71875f, 9.75f)
                lineTo(27.53125f, 9f)
                lineTo(21.03125f, 4.875f)
                lineTo(20.40625f, 4.5f)
                lineTo(19.84375f, 4.96875f)
                lineTo(16f, 8.125f)
                lineTo(12.34375f, 4.96875f)
                close()
                moveTo(20.59375f, 6.9375f)
                lineTo(25.3125f, 9.96875f)
                lineTo(22.65625f, 12.125f)
                lineTo(17.75f, 9.28125f)
                close()
                moveTo(11.59375f, 6.96875f)
                lineTo(14.34375f, 9.3125f)
                lineTo(9.625f, 12.3125f)
                lineTo(6.71875f, 10.09375f)
                close()
                moveTo(16f, 10.625f)
                lineTo(20.8125f, 13.375f)
                lineTo(16f, 16.375f)
                lineTo(11.46875f, 13.53125f)
                close()
                moveTo(22.65625f, 14.5625f)
                lineTo(25.28125f, 16.8125f)
                lineTo(22.46875f, 18.5f)
                curveTo(22.3789f, 18.5391f, 22.293f, 18.5938f, 22.2188f, 18.6563f)
                lineTo(20.46875f, 19.6875f)
                lineTo(17.75f, 17.625f)
                close()
                moveTo(9.625f, 14.71875f)
                lineTo(14.25f, 17.625f)
                lineTo(11.625f, 19.6875f)
                lineTo(6.78125f, 16.84375f)
                close()
                moveTo(16.03125f, 18.8125f)
                lineTo(19.78125f, 21.6875f)
                lineTo(20.34375f, 22.09375f)
                lineTo(20.90625f, 21.75f)
                lineTo(21.875f, 21.15625f)
                lineTo(21.875f, 22.21875f)
                lineTo(16f, 26.0625f)
                lineTo(10.125f, 22.1875f)
                lineTo(10.125f, 21.125f)
                lineTo(11.1875f, 21.75f)
                lineTo(11.78125f, 22.09375f)
                lineTo(12.3125f, 21.6875f)
                close()
            }
        }.build()
        return _Dropbox!!
    }
