import 'package:drift/drift.dart';
import 'package:drift/native.dart';
import 'package:flexify/database/database.dart';
import 'package:flexify/main.dart';
import 'package:flexify/plan/plan_state.dart';
import 'package:flexify/plan/plans_list.dart';
import 'package:flexify/settings/settings_state.dart';
import 'package:flexify/timer/timer_state.dart';
import 'package:flutter/material.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:provider/provider.dart';

import 'mock_tests.dart';

void main() async {
  await mockTests();

  testWidgets('PlanList', (WidgetTester tester) async {
    db = AppDatabase(NativeDatabase.memory());
    await db.planExercises.deleteAll();
    await db.plans.deleteAll();
    final planId = await db.plans.insertOne(
      PlansCompanion.insert(
        id: Value(1),
        days: 'Monday',
      ),
    );

    await db.planExercises.insertOne(
      PlanExercisesCompanion.insert(
        planId: planId,
        exercise: 'Bench press',
        enabled: true,
      ),
    );
    final settings = await (db.settings.select()..limit(1)).getSingle();
    final scroll = ScrollController();
    await tester.pumpWidget(
      MultiProvider(
        providers: [
          ChangeNotifierProvider(create: (context) => SettingsState(settings)),
          ChangeNotifierProvider(create: (context) => TimerState()),
          ChangeNotifierProvider(create: (context) => PlanState()),
        ],
        child: MaterialApp(
          home: Scaffold(
            body: PlansList(
              scroll: scroll,
              plans: [
                Plan(
                  days: "Monday",
                  id: planId,
                  sequence: 2,
                ),
              ],
              onSelect: (value) {},
              selected: const {},
              navKey: GlobalKey(),
              search: '',
            ),
          ),
        ),
      ),
    );

    await tester.pumpAndSettle();

    expect(find.text('Bench press'), findsOne);

    await db.close();
  });
}
