// dart format width=80
import 'package:drift/internal/versioned_schema.dart' as i0;
import 'package:drift/drift.dart' as i1;
import 'package:drift/drift.dart'; // ignore_for_file: type=lint,unused_import

// GENERATED BY drift_dev, DO NOT MODIFY.
final class Schema2 extends i0.VersionedSchema {
  Schema2({required super.database}) : super(version: 2);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
  ];
  late final Shape0 plans = Shape0(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_1,
          _column_2,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape1 gymSets = Shape1(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_3,
          _column_4,
          _column_5,
          _column_6,
          _column_7,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape0 extends i0.VersionedTable {
  Shape0({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get exercises =>
      columnsByName['exercises']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get days =>
      columnsByName['days']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<int> _column_0(String aliasedName) =>
    i1.GeneratedColumn<int>('id', aliasedName, false,
        hasAutoIncrement: true,
        type: i1.DriftSqlType.int,
        defaultConstraints:
            i1.GeneratedColumn.constraintIsAlways('PRIMARY KEY AUTOINCREMENT'));
i1.GeneratedColumn<String> _column_1(String aliasedName) =>
    i1.GeneratedColumn<String>('exercises', aliasedName, false,
        type: i1.DriftSqlType.string);
i1.GeneratedColumn<String> _column_2(String aliasedName) =>
    i1.GeneratedColumn<String>('days', aliasedName, false,
        type: i1.DriftSqlType.string);

class Shape1 extends i0.VersionedTable {
  Shape1({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<double> get reps =>
      columnsByName['reps']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get weight =>
      columnsByName['weight']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<String> get unit =>
      columnsByName['unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get created =>
      columnsByName['created']! as i1.GeneratedColumn<DateTime>;
}

i1.GeneratedColumn<String> _column_3(String aliasedName) =>
    i1.GeneratedColumn<String>('name', aliasedName, false,
        type: i1.DriftSqlType.string);
i1.GeneratedColumn<double> _column_4(String aliasedName) =>
    i1.GeneratedColumn<double>('reps', aliasedName, false,
        type: i1.DriftSqlType.double);
i1.GeneratedColumn<double> _column_5(String aliasedName) =>
    i1.GeneratedColumn<double>('weight', aliasedName, false,
        type: i1.DriftSqlType.double);
i1.GeneratedColumn<String> _column_6(String aliasedName) =>
    i1.GeneratedColumn<String>('unit', aliasedName, false,
        type: i1.DriftSqlType.string);
i1.GeneratedColumn<DateTime> _column_7(String aliasedName) =>
    i1.GeneratedColumn<DateTime>('created', aliasedName, false,
        type: i1.DriftSqlType.dateTime);

final class Schema3 extends i0.VersionedSchema {
  Schema3({required super.database}) : super(version: 3);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
  ];
  late final Shape2 plans = Shape2(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_8,
          _column_1,
          _column_2,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape1 gymSets = Shape1(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_3,
          _column_4,
          _column_5,
          _column_6,
          _column_7,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape2 extends i0.VersionedTable {
  Shape2({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get sequence =>
      columnsByName['sequence']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get exercises =>
      columnsByName['exercises']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get days =>
      columnsByName['days']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<int> _column_8(String aliasedName) =>
    i1.GeneratedColumn<int>('sequence', aliasedName, true,
        type: i1.DriftSqlType.int);

final class Schema4 extends i0.VersionedSchema {
  Schema4({required super.database}) : super(version: 4);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_8,
          _column_1,
          _column_2,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape1 gymSets = Shape1(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_3,
          _column_4,
          _column_5,
          _column_6,
          _column_7,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape3 extends i0.VersionedTable {
  Shape3({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get sequence =>
      columnsByName['sequence']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get exercises =>
      columnsByName['exercises']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get days =>
      columnsByName['days']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get title =>
      columnsByName['title']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_9(String aliasedName) =>
    i1.GeneratedColumn<String>('title', aliasedName, true,
        type: i1.DriftSqlType.string);

final class Schema5 extends i0.VersionedSchema {
  Schema5({required super.database}) : super(version: 5);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_8,
          _column_1,
          _column_2,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape4 gymSets = Shape4(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_3,
          _column_4,
          _column_5,
          _column_6,
          _column_7,
          _column_10,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape4 extends i0.VersionedTable {
  Shape4({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<double> get reps =>
      columnsByName['reps']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get weight =>
      columnsByName['weight']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<String> get unit =>
      columnsByName['unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get created =>
      columnsByName['created']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<bool> get hidden =>
      columnsByName['hidden']! as i1.GeneratedColumn<bool>;
}

i1.GeneratedColumn<bool> _column_10(String aliasedName) =>
    i1.GeneratedColumn<bool>('hidden', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints:
            i1.GeneratedColumn.constraintIsAlways('CHECK ("hidden" IN (0, 1))'),
        defaultValue: const Constant(false));

final class Schema6 extends i0.VersionedSchema {
  Schema6({required super.database}) : super(version: 6);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_8,
          _column_1,
          _column_2,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape5 gymSets = Shape5(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_3,
          _column_4,
          _column_5,
          _column_6,
          _column_7,
          _column_10,
          _column_11,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape5 extends i0.VersionedTable {
  Shape5({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<double> get reps =>
      columnsByName['reps']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get weight =>
      columnsByName['weight']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<String> get unit =>
      columnsByName['unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get created =>
      columnsByName['created']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<bool> get hidden =>
      columnsByName['hidden']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<double> get bodyWeight =>
      columnsByName['body_weight']! as i1.GeneratedColumn<double>;
}

i1.GeneratedColumn<double> _column_11(String aliasedName) =>
    i1.GeneratedColumn<double>('body_weight', aliasedName, false,
        type: i1.DriftSqlType.double, defaultValue: const Constant(0.0));

final class Schema7 extends i0.VersionedSchema {
  Schema7({required super.database}) : super(version: 7);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_8,
          _column_1,
          _column_2,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape5 gymSets = Shape5(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_3,
          _column_4,
          _column_5,
          _column_6,
          _column_7,
          _column_10,
          _column_11,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

final class Schema8 extends i0.VersionedSchema {
  Schema8({required super.database}) : super(version: 8);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_8,
          _column_1,
          _column_2,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape6 gymSets = Shape6(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_3,
          _column_4,
          _column_5,
          _column_6,
          _column_7,
          _column_10,
          _column_11,
          _column_12,
          _column_13,
          _column_14,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape6 extends i0.VersionedTable {
  Shape6({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<double> get reps =>
      columnsByName['reps']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get weight =>
      columnsByName['weight']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<String> get unit =>
      columnsByName['unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get created =>
      columnsByName['created']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<bool> get hidden =>
      columnsByName['hidden']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<double> get bodyWeight =>
      columnsByName['body_weight']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get duration =>
      columnsByName['duration']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get distance =>
      columnsByName['distance']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<bool> get cardio =>
      columnsByName['cardio']! as i1.GeneratedColumn<bool>;
}

i1.GeneratedColumn<double> _column_12(String aliasedName) =>
    i1.GeneratedColumn<double>('duration', aliasedName, false,
        type: i1.DriftSqlType.double, defaultValue: const Constant(0.0));
i1.GeneratedColumn<double> _column_13(String aliasedName) =>
    i1.GeneratedColumn<double>('distance', aliasedName, false,
        type: i1.DriftSqlType.double, defaultValue: const Constant(0.0));
i1.GeneratedColumn<bool> _column_14(String aliasedName) =>
    i1.GeneratedColumn<bool>('cardio', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints:
            i1.GeneratedColumn.constraintIsAlways('CHECK ("cardio" IN (0, 1))'),
        defaultValue: const Constant(false));

final class Schema10 extends i0.VersionedSchema {
  Schema10({required super.database}) : super(version: 10);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_8,
          _column_1,
          _column_2,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape7 gymSets = Shape7(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_3,
          _column_4,
          _column_5,
          _column_6,
          _column_7,
          _column_10,
          _column_11,
          _column_12,
          _column_13,
          _column_14,
          _column_15,
          _column_16,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape7 extends i0.VersionedTable {
  Shape7({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<double> get reps =>
      columnsByName['reps']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get weight =>
      columnsByName['weight']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<String> get unit =>
      columnsByName['unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get created =>
      columnsByName['created']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<bool> get hidden =>
      columnsByName['hidden']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<double> get bodyWeight =>
      columnsByName['body_weight']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get duration =>
      columnsByName['duration']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get distance =>
      columnsByName['distance']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<bool> get cardio =>
      columnsByName['cardio']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get restMs =>
      columnsByName['rest_ms']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_15(String aliasedName) =>
    i1.GeneratedColumn<int>('rest_ms', aliasedName, false,
        type: i1.DriftSqlType.int,
        defaultValue:
            Constant(const Duration(minutes: 3, seconds: 30).inMilliseconds));
i1.GeneratedColumn<int> _column_16(String aliasedName) =>
    i1.GeneratedColumn<int>('max_sets', aliasedName, false,
        type: i1.DriftSqlType.int, defaultValue: const Constant(3));

final class Schema11 extends i0.VersionedSchema {
  Schema11({required super.database}) : super(version: 11);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_8,
          _column_1,
          _column_2,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape8 gymSets = Shape8(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_3,
          _column_4,
          _column_5,
          _column_6,
          _column_7,
          _column_10,
          _column_11,
          _column_12,
          _column_13,
          _column_14,
          _column_15,
          _column_16,
          _column_17,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape8 extends i0.VersionedTable {
  Shape8({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<double> get reps =>
      columnsByName['reps']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get weight =>
      columnsByName['weight']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<String> get unit =>
      columnsByName['unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get created =>
      columnsByName['created']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<bool> get hidden =>
      columnsByName['hidden']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<double> get bodyWeight =>
      columnsByName['body_weight']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get duration =>
      columnsByName['duration']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get distance =>
      columnsByName['distance']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<bool> get cardio =>
      columnsByName['cardio']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get restMs =>
      columnsByName['rest_ms']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get incline =>
      columnsByName['incline']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_17(String aliasedName) =>
    i1.GeneratedColumn<int>('incline', aliasedName, true,
        type: i1.DriftSqlType.int);

final class Schema12 extends i0.VersionedSchema {
  Schema12({required super.database}) : super(version: 12);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_8,
          _column_1,
          _column_2,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape8 gymSets = Shape8(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_3,
          _column_4,
          _column_5,
          _column_6,
          _column_7,
          _column_10,
          _column_11,
          _column_12,
          _column_13,
          _column_14,
          _column_15,
          _column_16,
          _column_17,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

final class Schema13 extends i0.VersionedSchema {
  Schema13({required super.database}) : super(version: 13);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_8,
          _column_1,
          _column_2,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape8 gymSets = Shape8(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_3,
          _column_4,
          _column_5,
          _column_6,
          _column_7,
          _column_10,
          _column_11,
          _column_12,
          _column_13,
          _column_14,
          _column_18,
          _column_16,
          _column_17,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

i1.GeneratedColumn<int> _column_18(String aliasedName) =>
    i1.GeneratedColumn<int>('rest_ms', aliasedName, true,
        type: i1.DriftSqlType.int);

final class Schema14 extends i0.VersionedSchema {
  Schema14({required super.database}) : super(version: 14);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_8,
          _column_1,
          _column_2,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape8 gymSets = Shape8(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_3,
          _column_4,
          _column_5,
          _column_6,
          _column_7,
          _column_10,
          _column_11,
          _column_12,
          _column_13,
          _column_14,
          _column_18,
          _column_19,
          _column_17,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

i1.GeneratedColumn<int> _column_19(String aliasedName) =>
    i1.GeneratedColumn<int>('max_sets', aliasedName, true,
        type: i1.DriftSqlType.int);

final class Schema15 extends i0.VersionedSchema {
  Schema15({required super.database}) : super(version: 15);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_8,
          _column_1,
          _column_2,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape8 gymSets = Shape8(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_3,
          _column_4,
          _column_5,
          _column_6,
          _column_7,
          _column_10,
          _column_11,
          _column_12,
          _column_13,
          _column_14,
          _column_18,
          _column_19,
          _column_17,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

final class Schema16 extends i0.VersionedSchema {
  Schema16({required super.database}) : super(version: 16);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_8,
          _column_1,
          _column_2,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape8 gymSets = Shape8(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_3,
          _column_4,
          _column_5,
          _column_6,
          _column_7,
          _column_10,
          _column_11,
          _column_12,
          _column_13,
          _column_14,
          _column_18,
          _column_19,
          _column_17,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape9 settings = Shape9(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_20,
          _column_21,
          _column_22,
          _column_23,
          _column_24,
          _column_25,
          _column_26,
          _column_27,
          _column_28,
          _column_29,
          _column_30,
          _column_31,
          _column_32,
          _column_33,
          _column_34,
          _column_35,
          _column_36,
          _column_37,
          _column_38,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape9 extends i0.VersionedTable {
  Shape9({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get themeMode =>
      columnsByName['theme_mode']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get planTrailing =>
      columnsByName['plan_trailing']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get longDateFormat =>
      columnsByName['long_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get shortDateFormat =>
      columnsByName['short_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get timerDuration =>
      columnsByName['timer_duration']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get vibrate =>
      columnsByName['vibrate']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get restTimers =>
      columnsByName['rest_timers']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showUnits =>
      columnsByName['show_units']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get systemColors =>
      columnsByName['system_colors']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get explainedPermissions =>
      columnsByName['explained_permissions']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get hideTimerTab =>
      columnsByName['hide_timer_tab']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get hideHistoryTab =>
      columnsByName['hide_history_tab']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get curveLines =>
      columnsByName['curve_lines']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get hideWeight =>
      columnsByName['hide_weight']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get groupHistory =>
      columnsByName['group_history']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get alarmSound =>
      columnsByName['alarm_sound']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get cardioUnit =>
      columnsByName['cardio_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get strengthUnit =>
      columnsByName['strength_unit']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_20(String aliasedName) =>
    i1.GeneratedColumn<String>('theme_mode', aliasedName, false,
        type: i1.DriftSqlType.string);
i1.GeneratedColumn<String> _column_21(String aliasedName) =>
    i1.GeneratedColumn<String>('plan_trailing', aliasedName, false,
        type: i1.DriftSqlType.string);
i1.GeneratedColumn<String> _column_22(String aliasedName) =>
    i1.GeneratedColumn<String>('long_date_format', aliasedName, false,
        type: i1.DriftSqlType.string);
i1.GeneratedColumn<String> _column_23(String aliasedName) =>
    i1.GeneratedColumn<String>('short_date_format', aliasedName, false,
        type: i1.DriftSqlType.string);
i1.GeneratedColumn<int> _column_24(String aliasedName) =>
    i1.GeneratedColumn<int>('timer_duration', aliasedName, false,
        type: i1.DriftSqlType.int);
i1.GeneratedColumn<int> _column_25(String aliasedName) =>
    i1.GeneratedColumn<int>('max_sets', aliasedName, false,
        type: i1.DriftSqlType.int);
i1.GeneratedColumn<bool> _column_26(String aliasedName) =>
    i1.GeneratedColumn<bool>('vibrate', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("vibrate" IN (0, 1))'));
i1.GeneratedColumn<bool> _column_27(String aliasedName) =>
    i1.GeneratedColumn<bool>('rest_timers', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("rest_timers" IN (0, 1))'));
i1.GeneratedColumn<bool> _column_28(String aliasedName) =>
    i1.GeneratedColumn<bool>('show_units', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("show_units" IN (0, 1))'));
i1.GeneratedColumn<bool> _column_29(String aliasedName) =>
    i1.GeneratedColumn<bool>('system_colors', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("system_colors" IN (0, 1))'));
i1.GeneratedColumn<bool> _column_30(String aliasedName) =>
    i1.GeneratedColumn<bool>('explained_permissions', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("explained_permissions" IN (0, 1))'));
i1.GeneratedColumn<bool> _column_31(String aliasedName) =>
    i1.GeneratedColumn<bool>('hide_timer_tab', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("hide_timer_tab" IN (0, 1))'));
i1.GeneratedColumn<bool> _column_32(String aliasedName) =>
    i1.GeneratedColumn<bool>('hide_history_tab', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("hide_history_tab" IN (0, 1))'));
i1.GeneratedColumn<bool> _column_33(String aliasedName) =>
    i1.GeneratedColumn<bool>('curve_lines', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("curve_lines" IN (0, 1))'));
i1.GeneratedColumn<bool> _column_34(String aliasedName) =>
    i1.GeneratedColumn<bool>('hide_weight', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("hide_weight" IN (0, 1))'));
i1.GeneratedColumn<bool> _column_35(String aliasedName) =>
    i1.GeneratedColumn<bool>('group_history', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("group_history" IN (0, 1))'));
i1.GeneratedColumn<String> _column_36(String aliasedName) =>
    i1.GeneratedColumn<String>('alarm_sound', aliasedName, false,
        type: i1.DriftSqlType.string);
i1.GeneratedColumn<String> _column_37(String aliasedName) =>
    i1.GeneratedColumn<String>('cardio_unit', aliasedName, false,
        type: i1.DriftSqlType.string);
i1.GeneratedColumn<String> _column_38(String aliasedName) =>
    i1.GeneratedColumn<String>('strength_unit', aliasedName, false,
        type: i1.DriftSqlType.string);

final class Schema17 extends i0.VersionedSchema {
  Schema17({required super.database}) : super(version: 17);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_8,
          _column_1,
          _column_2,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape10 gymSets = Shape10(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_3,
          _column_4,
          _column_5,
          _column_6,
          _column_7,
          _column_10,
          _column_11,
          _column_12,
          _column_13,
          _column_14,
          _column_18,
          _column_19,
          _column_17,
          _column_39,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape9 settings = Shape9(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_20,
          _column_21,
          _column_22,
          _column_23,
          _column_24,
          _column_25,
          _column_26,
          _column_27,
          _column_28,
          _column_29,
          _column_30,
          _column_31,
          _column_32,
          _column_33,
          _column_34,
          _column_35,
          _column_36,
          _column_37,
          _column_38,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape10 extends i0.VersionedTable {
  Shape10({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<double> get reps =>
      columnsByName['reps']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get weight =>
      columnsByName['weight']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<String> get unit =>
      columnsByName['unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get created =>
      columnsByName['created']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<bool> get hidden =>
      columnsByName['hidden']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<double> get bodyWeight =>
      columnsByName['body_weight']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get duration =>
      columnsByName['duration']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get distance =>
      columnsByName['distance']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<bool> get cardio =>
      columnsByName['cardio']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get restMs =>
      columnsByName['rest_ms']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get incline =>
      columnsByName['incline']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get planId =>
      columnsByName['plan_id']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_39(String aliasedName) =>
    i1.GeneratedColumn<int>('plan_id', aliasedName, true,
        type: i1.DriftSqlType.int);

final class Schema18 extends i0.VersionedSchema {
  Schema18({required super.database}) : super(version: 18);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_8,
          _column_1,
          _column_2,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape11 gymSets = Shape11(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_3,
          _column_4,
          _column_5,
          _column_6,
          _column_7,
          _column_10,
          _column_11,
          _column_12,
          _column_13,
          _column_14,
          _column_18,
          _column_17,
          _column_39,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape9 settings = Shape9(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_20,
          _column_21,
          _column_22,
          _column_23,
          _column_24,
          _column_25,
          _column_26,
          _column_27,
          _column_28,
          _column_29,
          _column_30,
          _column_31,
          _column_32,
          _column_33,
          _column_34,
          _column_35,
          _column_36,
          _column_37,
          _column_38,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape12 planExercises = Shape12(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_0,
          _column_40,
          _column_41,
          _column_42,
          _column_19,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape11 extends i0.VersionedTable {
  Shape11({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<double> get reps =>
      columnsByName['reps']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get weight =>
      columnsByName['weight']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<String> get unit =>
      columnsByName['unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get created =>
      columnsByName['created']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<bool> get hidden =>
      columnsByName['hidden']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<double> get bodyWeight =>
      columnsByName['body_weight']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get duration =>
      columnsByName['duration']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get distance =>
      columnsByName['distance']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<bool> get cardio =>
      columnsByName['cardio']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get restMs =>
      columnsByName['rest_ms']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get incline =>
      columnsByName['incline']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get planId =>
      columnsByName['plan_id']! as i1.GeneratedColumn<int>;
}

class Shape12 extends i0.VersionedTable {
  Shape12({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get planId =>
      columnsByName['plan_id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get exercise =>
      columnsByName['exercise']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get enabled =>
      columnsByName['enabled']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_40(String aliasedName) =>
    i1.GeneratedColumn<int>('plan_id', aliasedName, false,
        type: i1.DriftSqlType.int,
        defaultConstraints:
            i1.GeneratedColumn.constraintIsAlways('REFERENCES plans (id)'));
i1.GeneratedColumn<String> _column_41(String aliasedName) =>
    i1.GeneratedColumn<String>('exercise', aliasedName, false,
        type: i1.DriftSqlType.string,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'REFERENCES gym_sets (name)'));
i1.GeneratedColumn<bool> _column_42(String aliasedName) =>
    i1.GeneratedColumn<bool>('enabled', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("enabled" IN (0, 1))'));

final class Schema19 extends i0.VersionedSchema {
  Schema19({required super.database}) : super(version: 19);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape13 gymSets = Shape13(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape14 settings = Shape14(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_37,
          _column_33,
          _column_30,
          _column_35,
          _column_32,
          _column_31,
          _column_34,
          _column_0,
          _column_22,
          _column_25,
          _column_21,
          _column_27,
          _column_23,
          _column_44,
          _column_28,
          _column_38,
          _column_29,
          _column_20,
          _column_24,
          _column_26,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape12 planExercises = Shape12(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape13 extends i0.VersionedTable {
  Shape13({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<double> get bodyWeight =>
      columnsByName['body_weight']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<bool> get cardio =>
      columnsByName['cardio']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<DateTime> get created =>
      columnsByName['created']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<double> get distance =>
      columnsByName['distance']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get duration =>
      columnsByName['duration']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<bool> get hidden =>
      columnsByName['hidden']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get image =>
      columnsByName['image']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get incline =>
      columnsByName['incline']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get planId =>
      columnsByName['plan_id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<double> get reps =>
      columnsByName['reps']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<int> get restMs =>
      columnsByName['rest_ms']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get unit =>
      columnsByName['unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<double> get weight =>
      columnsByName['weight']! as i1.GeneratedColumn<double>;
}

i1.GeneratedColumn<String> _column_43(String aliasedName) =>
    i1.GeneratedColumn<String>('image', aliasedName, true,
        type: i1.DriftSqlType.string);

class Shape14 extends i0.VersionedTable {
  Shape14({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get alarmSound =>
      columnsByName['alarm_sound']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get cardioUnit =>
      columnsByName['cardio_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get curveLines =>
      columnsByName['curve_lines']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get explainedPermissions =>
      columnsByName['explained_permissions']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get groupHistory =>
      columnsByName['group_history']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get hideHistoryTab =>
      columnsByName['hide_history_tab']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get hideTimerTab =>
      columnsByName['hide_timer_tab']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get hideWeight =>
      columnsByName['hide_weight']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get longDateFormat =>
      columnsByName['long_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get planTrailing =>
      columnsByName['plan_trailing']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get restTimers =>
      columnsByName['rest_timers']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get shortDateFormat =>
      columnsByName['short_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get showImages =>
      columnsByName['show_images']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showUnits =>
      columnsByName['show_units']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get strengthUnit =>
      columnsByName['strength_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get systemColors =>
      columnsByName['system_colors']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get themeMode =>
      columnsByName['theme_mode']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get timerDuration =>
      columnsByName['timer_duration']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get vibrate =>
      columnsByName['vibrate']! as i1.GeneratedColumn<bool>;
}

i1.GeneratedColumn<bool> _column_44(String aliasedName) =>
    i1.GeneratedColumn<bool>('show_images', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("show_images" IN (0, 1))'),
        defaultValue: const Constant(true));

final class Schema20 extends i0.VersionedSchema {
  Schema20({required super.database}) : super(version: 20);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape15 gymSets = Shape15(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
          _column_45,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape14 settings = Shape14(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_37,
          _column_33,
          _column_30,
          _column_35,
          _column_32,
          _column_31,
          _column_34,
          _column_0,
          _column_22,
          _column_25,
          _column_21,
          _column_27,
          _column_23,
          _column_44,
          _column_28,
          _column_38,
          _column_29,
          _column_20,
          _column_24,
          _column_26,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape12 planExercises = Shape12(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape15 extends i0.VersionedTable {
  Shape15({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<double> get bodyWeight =>
      columnsByName['body_weight']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<bool> get cardio =>
      columnsByName['cardio']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<DateTime> get created =>
      columnsByName['created']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<double> get distance =>
      columnsByName['distance']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get duration =>
      columnsByName['duration']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<bool> get hidden =>
      columnsByName['hidden']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get image =>
      columnsByName['image']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get incline =>
      columnsByName['incline']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get planId =>
      columnsByName['plan_id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<double> get reps =>
      columnsByName['reps']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<int> get restMs =>
      columnsByName['rest_ms']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get unit =>
      columnsByName['unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<double> get weight =>
      columnsByName['weight']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<String> get category =>
      columnsByName['category']! as i1.GeneratedColumn<String>;
}

i1.GeneratedColumn<String> _column_45(String aliasedName) =>
    i1.GeneratedColumn<String>('category', aliasedName, true,
        type: i1.DriftSqlType.string);

final class Schema21 extends i0.VersionedSchema {
  Schema21({required super.database}) : super(version: 21);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape15 gymSets = Shape15(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_45,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape16 settings = Shape16(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_37,
          _column_33,
          _column_30,
          _column_35,
          _column_32,
          _column_31,
          _column_34,
          _column_0,
          _column_22,
          _column_25,
          _column_21,
          _column_27,
          _column_23,
          _column_44,
          _column_28,
          _column_38,
          _column_29,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape17 planExercises = Shape17(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape16 extends i0.VersionedTable {
  Shape16({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get alarmSound =>
      columnsByName['alarm_sound']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get cardioUnit =>
      columnsByName['cardio_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get curveLines =>
      columnsByName['curve_lines']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get explainedPermissions =>
      columnsByName['explained_permissions']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get groupHistory =>
      columnsByName['group_history']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get hideHistoryTab =>
      columnsByName['hide_history_tab']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get hideTimerTab =>
      columnsByName['hide_timer_tab']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get hideWeight =>
      columnsByName['hide_weight']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get longDateFormat =>
      columnsByName['long_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get planTrailing =>
      columnsByName['plan_trailing']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get restTimers =>
      columnsByName['rest_timers']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get shortDateFormat =>
      columnsByName['short_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get showImages =>
      columnsByName['show_images']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showUnits =>
      columnsByName['show_units']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get strengthUnit =>
      columnsByName['strength_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get systemColors =>
      columnsByName['system_colors']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get themeMode =>
      columnsByName['theme_mode']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get timerDuration =>
      columnsByName['timer_duration']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get vibrate =>
      columnsByName['vibrate']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get warmupSets =>
      columnsByName['warmup_sets']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_46(String aliasedName) =>
    i1.GeneratedColumn<int>('warmup_sets', aliasedName, true,
        type: i1.DriftSqlType.int);

class Shape17 extends i0.VersionedTable {
  Shape17({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<bool> get enabled =>
      columnsByName['enabled']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get exercise =>
      columnsByName['exercise']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get planId =>
      columnsByName['plan_id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get warmupSets =>
      columnsByName['warmup_sets']! as i1.GeneratedColumn<int>;
}

final class Schema22 extends i0.VersionedSchema {
  Schema22({required super.database}) : super(version: 22);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape15 gymSets = Shape15(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_45,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape18 settings = Shape18(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_37,
          _column_33,
          _column_30,
          _column_35,
          _column_32,
          _column_31,
          _column_34,
          _column_0,
          _column_22,
          _column_25,
          _column_21,
          _column_27,
          _column_23,
          _column_44,
          _column_28,
          _column_38,
          _column_29,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
          _column_47,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape17 planExercises = Shape17(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape18 extends i0.VersionedTable {
  Shape18({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get alarmSound =>
      columnsByName['alarm_sound']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get cardioUnit =>
      columnsByName['cardio_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get curveLines =>
      columnsByName['curve_lines']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get explainedPermissions =>
      columnsByName['explained_permissions']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get groupHistory =>
      columnsByName['group_history']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get hideHistoryTab =>
      columnsByName['hide_history_tab']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get hideTimerTab =>
      columnsByName['hide_timer_tab']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get hideWeight =>
      columnsByName['hide_weight']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get longDateFormat =>
      columnsByName['long_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get planTrailing =>
      columnsByName['plan_trailing']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get restTimers =>
      columnsByName['rest_timers']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get shortDateFormat =>
      columnsByName['short_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get showImages =>
      columnsByName['show_images']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showUnits =>
      columnsByName['show_units']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get strengthUnit =>
      columnsByName['strength_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get systemColors =>
      columnsByName['system_colors']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get themeMode =>
      columnsByName['theme_mode']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get timerDuration =>
      columnsByName['timer_duration']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get vibrate =>
      columnsByName['vibrate']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get warmupSets =>
      columnsByName['warmup_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get repEstimation =>
      columnsByName['rep_estimation']! as i1.GeneratedColumn<bool>;
}

i1.GeneratedColumn<bool> _column_47(String aliasedName) =>
    i1.GeneratedColumn<bool>('rep_estimation', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("rep_estimation" IN (0, 1))'),
        defaultValue: const Constant(true));

final class Schema23 extends i0.VersionedSchema {
  Schema23({required super.database}) : super(version: 23);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape15 gymSets = Shape15(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_45,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape19 settings = Shape19(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_37,
          _column_33,
          _column_30,
          _column_35,
          _column_32,
          _column_31,
          _column_34,
          _column_0,
          _column_22,
          _column_25,
          _column_21,
          _column_27,
          _column_23,
          _column_44,
          _column_28,
          _column_38,
          _column_29,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
          _column_47,
          _column_48,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape17 planExercises = Shape17(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape19 extends i0.VersionedTable {
  Shape19({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get alarmSound =>
      columnsByName['alarm_sound']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get cardioUnit =>
      columnsByName['cardio_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get curveLines =>
      columnsByName['curve_lines']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get explainedPermissions =>
      columnsByName['explained_permissions']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get groupHistory =>
      columnsByName['group_history']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get hideHistoryTab =>
      columnsByName['hide_history_tab']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get hideTimerTab =>
      columnsByName['hide_timer_tab']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get hideWeight =>
      columnsByName['hide_weight']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get longDateFormat =>
      columnsByName['long_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get planTrailing =>
      columnsByName['plan_trailing']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get restTimers =>
      columnsByName['rest_timers']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get shortDateFormat =>
      columnsByName['short_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get showImages =>
      columnsByName['show_images']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showUnits =>
      columnsByName['show_units']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get strengthUnit =>
      columnsByName['strength_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get systemColors =>
      columnsByName['system_colors']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get themeMode =>
      columnsByName['theme_mode']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get timerDuration =>
      columnsByName['timer_duration']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get vibrate =>
      columnsByName['vibrate']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get warmupSets =>
      columnsByName['warmup_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get repEstimation =>
      columnsByName['rep_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get durationEstimation =>
      columnsByName['duration_estimation']! as i1.GeneratedColumn<bool>;
}

i1.GeneratedColumn<bool> _column_48(String aliasedName) =>
    i1.GeneratedColumn<bool>('duration_estimation', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("duration_estimation" IN (0, 1))'),
        defaultValue: const Constant(true));

final class Schema24 extends i0.VersionedSchema {
  Schema24({required super.database}) : super(version: 24);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape15 gymSets = Shape15(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_45,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape20 settings = Shape20(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_37,
          _column_33,
          _column_48,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_21,
          _column_47,
          _column_27,
          _column_23,
          _column_49,
          _column_50,
          _column_44,
          _column_51,
          _column_28,
          _column_38,
          _column_29,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape17 planExercises = Shape17(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape20 extends i0.VersionedTable {
  Shape20({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get alarmSound =>
      columnsByName['alarm_sound']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get cardioUnit =>
      columnsByName['cardio_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get curveLines =>
      columnsByName['curve_lines']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get durationEstimation =>
      columnsByName['duration_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get explainedPermissions =>
      columnsByName['explained_permissions']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get groupHistory =>
      columnsByName['group_history']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get longDateFormat =>
      columnsByName['long_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get planTrailing =>
      columnsByName['plan_trailing']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get repEstimation =>
      columnsByName['rep_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get restTimers =>
      columnsByName['rest_timers']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get shortDateFormat =>
      columnsByName['short_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get showBodyWeight =>
      columnsByName['show_body_weight']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showHistoryTab =>
      columnsByName['show_history_tab']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showImages =>
      columnsByName['show_images']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showTimerTab =>
      columnsByName['show_timer_tab']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showUnits =>
      columnsByName['show_units']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get strengthUnit =>
      columnsByName['strength_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get systemColors =>
      columnsByName['system_colors']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get themeMode =>
      columnsByName['theme_mode']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get timerDuration =>
      columnsByName['timer_duration']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get vibrate =>
      columnsByName['vibrate']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get warmupSets =>
      columnsByName['warmup_sets']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<bool> _column_49(String aliasedName) =>
    i1.GeneratedColumn<bool>('show_body_weight', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("show_body_weight" IN (0, 1))'),
        defaultValue: const Constant(true));
i1.GeneratedColumn<bool> _column_50(String aliasedName) =>
    i1.GeneratedColumn<bool>('show_history_tab', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("show_history_tab" IN (0, 1))'),
        defaultValue: const Constant(true));
i1.GeneratedColumn<bool> _column_51(String aliasedName) =>
    i1.GeneratedColumn<bool>('show_timer_tab', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("show_timer_tab" IN (0, 1))'),
        defaultValue: const Constant(true));

final class Schema25 extends i0.VersionedSchema {
  Schema25({required super.database}) : super(version: 25);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape15 gymSets = Shape15(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_45,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape21 settings = Shape21(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_52,
          _column_37,
          _column_33,
          _column_48,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_21,
          _column_47,
          _column_27,
          _column_23,
          _column_49,
          _column_50,
          _column_44,
          _column_51,
          _column_28,
          _column_38,
          _column_29,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape17 planExercises = Shape17(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape21 extends i0.VersionedTable {
  Shape21({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get alarmSound =>
      columnsByName['alarm_sound']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get automaticBackups =>
      columnsByName['automatic_backups']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get cardioUnit =>
      columnsByName['cardio_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get curveLines =>
      columnsByName['curve_lines']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get durationEstimation =>
      columnsByName['duration_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get explainedPermissions =>
      columnsByName['explained_permissions']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get groupHistory =>
      columnsByName['group_history']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get longDateFormat =>
      columnsByName['long_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get planTrailing =>
      columnsByName['plan_trailing']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get repEstimation =>
      columnsByName['rep_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get restTimers =>
      columnsByName['rest_timers']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get shortDateFormat =>
      columnsByName['short_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get showBodyWeight =>
      columnsByName['show_body_weight']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showHistoryTab =>
      columnsByName['show_history_tab']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showImages =>
      columnsByName['show_images']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showTimerTab =>
      columnsByName['show_timer_tab']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showUnits =>
      columnsByName['show_units']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get strengthUnit =>
      columnsByName['strength_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get systemColors =>
      columnsByName['system_colors']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get themeMode =>
      columnsByName['theme_mode']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get timerDuration =>
      columnsByName['timer_duration']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get vibrate =>
      columnsByName['vibrate']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get warmupSets =>
      columnsByName['warmup_sets']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<bool> _column_52(String aliasedName) =>
    i1.GeneratedColumn<bool>('automatic_backups', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("automatic_backups" IN (0, 1))'),
        defaultValue: const Constant(false));

final class Schema26 extends i0.VersionedSchema {
  Schema26({required super.database}) : super(version: 26);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape15 gymSets = Shape15(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_45,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape22 settings = Shape22(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_52,
          _column_53,
          _column_37,
          _column_33,
          _column_48,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_21,
          _column_47,
          _column_27,
          _column_23,
          _column_49,
          _column_50,
          _column_44,
          _column_51,
          _column_28,
          _column_38,
          _column_29,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape17 planExercises = Shape17(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape22 extends i0.VersionedTable {
  Shape22({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get alarmSound =>
      columnsByName['alarm_sound']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get automaticBackups =>
      columnsByName['automatic_backups']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get backupPath =>
      columnsByName['backup_path']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get cardioUnit =>
      columnsByName['cardio_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get curveLines =>
      columnsByName['curve_lines']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get durationEstimation =>
      columnsByName['duration_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get explainedPermissions =>
      columnsByName['explained_permissions']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get groupHistory =>
      columnsByName['group_history']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get longDateFormat =>
      columnsByName['long_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get planTrailing =>
      columnsByName['plan_trailing']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get repEstimation =>
      columnsByName['rep_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get restTimers =>
      columnsByName['rest_timers']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get shortDateFormat =>
      columnsByName['short_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get showBodyWeight =>
      columnsByName['show_body_weight']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showHistoryTab =>
      columnsByName['show_history_tab']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showImages =>
      columnsByName['show_images']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showTimerTab =>
      columnsByName['show_timer_tab']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showUnits =>
      columnsByName['show_units']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get strengthUnit =>
      columnsByName['strength_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get systemColors =>
      columnsByName['system_colors']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get themeMode =>
      columnsByName['theme_mode']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get timerDuration =>
      columnsByName['timer_duration']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get vibrate =>
      columnsByName['vibrate']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get warmupSets =>
      columnsByName['warmup_sets']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<String> _column_53(String aliasedName) =>
    i1.GeneratedColumn<String>('backup_path', aliasedName, true,
        type: i1.DriftSqlType.string);

final class Schema27 extends i0.VersionedSchema {
  Schema27({required super.database}) : super(version: 27);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape15 gymSets = Shape15(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_45,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape23 settings = Shape23(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_52,
          _column_53,
          _column_37,
          _column_33,
          _column_48,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_21,
          _column_47,
          _column_27,
          _column_23,
          _column_49,
          _column_44,
          _column_28,
          _column_38,
          _column_29,
          _column_54,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape17 planExercises = Shape17(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape23 extends i0.VersionedTable {
  Shape23({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get alarmSound =>
      columnsByName['alarm_sound']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get automaticBackups =>
      columnsByName['automatic_backups']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get backupPath =>
      columnsByName['backup_path']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get cardioUnit =>
      columnsByName['cardio_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get curveLines =>
      columnsByName['curve_lines']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get durationEstimation =>
      columnsByName['duration_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get explainedPermissions =>
      columnsByName['explained_permissions']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get groupHistory =>
      columnsByName['group_history']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get longDateFormat =>
      columnsByName['long_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get planTrailing =>
      columnsByName['plan_trailing']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get repEstimation =>
      columnsByName['rep_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get restTimers =>
      columnsByName['rest_timers']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get shortDateFormat =>
      columnsByName['short_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get showBodyWeight =>
      columnsByName['show_body_weight']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showImages =>
      columnsByName['show_images']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showUnits =>
      columnsByName['show_units']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get strengthUnit =>
      columnsByName['strength_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get systemColors =>
      columnsByName['system_colors']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get tabs =>
      columnsByName['tabs']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get themeMode =>
      columnsByName['theme_mode']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get timerDuration =>
      columnsByName['timer_duration']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get vibrate =>
      columnsByName['vibrate']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get warmupSets =>
      columnsByName['warmup_sets']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<String> _column_54(String aliasedName) =>
    i1.GeneratedColumn<String>('tabs', aliasedName, false,
        type: i1.DriftSqlType.string,
        defaultValue:
            const Constant("HistoryPage,PlansPage,GraphsPage,TimerPage"));

final class Schema28 extends i0.VersionedSchema {
  Schema28({required super.database}) : super(version: 28);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape15 gymSets = Shape15(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_45,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape24 settings = Shape24(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_52,
          _column_53,
          _column_37,
          _column_33,
          _column_48,
          _column_55,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_21,
          _column_47,
          _column_27,
          _column_23,
          _column_49,
          _column_44,
          _column_28,
          _column_38,
          _column_29,
          _column_54,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape17 planExercises = Shape17(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape24 extends i0.VersionedTable {
  Shape24({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get alarmSound =>
      columnsByName['alarm_sound']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get automaticBackups =>
      columnsByName['automatic_backups']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get backupPath =>
      columnsByName['backup_path']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get cardioUnit =>
      columnsByName['cardio_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get curveLines =>
      columnsByName['curve_lines']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get durationEstimation =>
      columnsByName['duration_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get enableSound =>
      columnsByName['enable_sound']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get explainedPermissions =>
      columnsByName['explained_permissions']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get groupHistory =>
      columnsByName['group_history']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get longDateFormat =>
      columnsByName['long_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get planTrailing =>
      columnsByName['plan_trailing']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get repEstimation =>
      columnsByName['rep_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get restTimers =>
      columnsByName['rest_timers']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get shortDateFormat =>
      columnsByName['short_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get showBodyWeight =>
      columnsByName['show_body_weight']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showImages =>
      columnsByName['show_images']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showUnits =>
      columnsByName['show_units']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get strengthUnit =>
      columnsByName['strength_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get systemColors =>
      columnsByName['system_colors']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get tabs =>
      columnsByName['tabs']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get themeMode =>
      columnsByName['theme_mode']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get timerDuration =>
      columnsByName['timer_duration']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get vibrate =>
      columnsByName['vibrate']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get warmupSets =>
      columnsByName['warmup_sets']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<bool> _column_55(String aliasedName) =>
    i1.GeneratedColumn<bool>('enable_sound', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("enable_sound" IN (0, 1))'),
        defaultValue: const Constant(true));

final class Schema29 extends i0.VersionedSchema {
  Schema29({required super.database}) : super(version: 29);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape15 gymSets = Shape15(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_45,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape24 settings = Shape24(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_52,
          _column_53,
          _column_37,
          _column_33,
          _column_48,
          _column_55,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_21,
          _column_47,
          _column_27,
          _column_23,
          _column_49,
          _column_44,
          _column_28,
          _column_38,
          _column_29,
          _column_54,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape17 planExercises = Shape17(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

final class Schema30 extends i0.VersionedSchema {
  Schema30({required super.database}) : super(version: 30);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape15 gymSets = Shape15(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_45,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape24 settings = Shape24(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_52,
          _column_53,
          _column_37,
          _column_33,
          _column_48,
          _column_55,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_21,
          _column_47,
          _column_27,
          _column_23,
          _column_49,
          _column_44,
          _column_28,
          _column_38,
          _column_29,
          _column_54,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape17 planExercises = Shape17(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

final class Schema31 extends i0.VersionedSchema {
  Schema31({required super.database}) : super(version: 31);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape15 gymSets = Shape15(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_45,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape24 settings = Shape24(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_52,
          _column_53,
          _column_37,
          _column_33,
          _column_48,
          _column_55,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_21,
          _column_47,
          _column_27,
          _column_23,
          _column_49,
          _column_44,
          _column_28,
          _column_38,
          _column_29,
          _column_54,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape25 planExercises = Shape25(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_56,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape25 extends i0.VersionedTable {
  Shape25({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<bool> get enabled =>
      columnsByName['enabled']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get timers =>
      columnsByName['timers']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get exercise =>
      columnsByName['exercise']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get planId =>
      columnsByName['plan_id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get warmupSets =>
      columnsByName['warmup_sets']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<bool> _column_56(String aliasedName) =>
    i1.GeneratedColumn<bool>('timers', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints:
            i1.GeneratedColumn.constraintIsAlways('CHECK ("timers" IN (0, 1))'),
        defaultValue: const Constant(true));

final class Schema32 extends i0.VersionedSchema {
  Schema32({required super.database}) : super(version: 32);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape15 gymSets = Shape15(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_45,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape24 settings = Shape24(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_52,
          _column_53,
          _column_37,
          _column_33,
          _column_48,
          _column_55,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_21,
          _column_47,
          _column_27,
          _column_23,
          _column_49,
          _column_44,
          _column_28,
          _column_38,
          _column_29,
          _column_54,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape25 planExercises = Shape25(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_56,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

final class Schema33 extends i0.VersionedSchema {
  Schema33({required super.database}) : super(version: 33);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape15 gymSets = Shape15(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_45,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape26 settings = Shape26(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_52,
          _column_53,
          _column_37,
          _column_33,
          _column_48,
          _column_55,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_57,
          _column_21,
          _column_47,
          _column_27,
          _column_23,
          _column_49,
          _column_44,
          _column_28,
          _column_38,
          _column_29,
          _column_54,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape25 planExercises = Shape25(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_56,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape26 extends i0.VersionedTable {
  Shape26({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get alarmSound =>
      columnsByName['alarm_sound']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get automaticBackups =>
      columnsByName['automatic_backups']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get backupPath =>
      columnsByName['backup_path']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get cardioUnit =>
      columnsByName['cardio_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get curveLines =>
      columnsByName['curve_lines']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get durationEstimation =>
      columnsByName['duration_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get enableSound =>
      columnsByName['enable_sound']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get explainedPermissions =>
      columnsByName['explained_permissions']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get groupHistory =>
      columnsByName['group_history']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get longDateFormat =>
      columnsByName['long_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get peekGraph =>
      columnsByName['peek_graph']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get planTrailing =>
      columnsByName['plan_trailing']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get repEstimation =>
      columnsByName['rep_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get restTimers =>
      columnsByName['rest_timers']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get shortDateFormat =>
      columnsByName['short_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get showBodyWeight =>
      columnsByName['show_body_weight']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showImages =>
      columnsByName['show_images']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showUnits =>
      columnsByName['show_units']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get strengthUnit =>
      columnsByName['strength_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get systemColors =>
      columnsByName['system_colors']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get tabs =>
      columnsByName['tabs']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get themeMode =>
      columnsByName['theme_mode']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get timerDuration =>
      columnsByName['timer_duration']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get vibrate =>
      columnsByName['vibrate']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get warmupSets =>
      columnsByName['warmup_sets']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<bool> _column_57(String aliasedName) =>
    i1.GeneratedColumn<bool>('peek_graph', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("peek_graph" IN (0, 1))'),
        defaultValue: const Constant(false));

final class Schema34 extends i0.VersionedSchema {
  Schema34({required super.database}) : super(version: 34);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape15 gymSets = Shape15(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_45,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape27 settings = Shape27(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_52,
          _column_53,
          _column_37,
          _column_33,
          _column_48,
          _column_55,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_57,
          _column_21,
          _column_47,
          _column_27,
          _column_23,
          _column_49,
          _column_44,
          _column_28,
          _column_38,
          _column_29,
          _column_54,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
          _column_58,
          _column_59,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape25 planExercises = Shape25(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_56,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape27 extends i0.VersionedTable {
  Shape27({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get alarmSound =>
      columnsByName['alarm_sound']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get automaticBackups =>
      columnsByName['automatic_backups']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get backupPath =>
      columnsByName['backup_path']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get cardioUnit =>
      columnsByName['cardio_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get curveLines =>
      columnsByName['curve_lines']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get durationEstimation =>
      columnsByName['duration_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get enableSound =>
      columnsByName['enable_sound']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get explainedPermissions =>
      columnsByName['explained_permissions']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get groupHistory =>
      columnsByName['group_history']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get longDateFormat =>
      columnsByName['long_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get peekGraph =>
      columnsByName['peek_graph']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get planTrailing =>
      columnsByName['plan_trailing']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get repEstimation =>
      columnsByName['rep_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get restTimers =>
      columnsByName['rest_timers']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get shortDateFormat =>
      columnsByName['short_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get showBodyWeight =>
      columnsByName['show_body_weight']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showImages =>
      columnsByName['show_images']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showUnits =>
      columnsByName['show_units']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get strengthUnit =>
      columnsByName['strength_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get systemColors =>
      columnsByName['system_colors']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get tabs =>
      columnsByName['tabs']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get themeMode =>
      columnsByName['theme_mode']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get timerDuration =>
      columnsByName['timer_duration']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get vibrate =>
      columnsByName['vibrate']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get warmupSets =>
      columnsByName['warmup_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<double> get curveSmoothness =>
      columnsByName['curve_smoothness']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<bool> get notifications =>
      columnsByName['notifications']! as i1.GeneratedColumn<bool>;
}

i1.GeneratedColumn<double> _column_58(String aliasedName) =>
    i1.GeneratedColumn<double>('curve_smoothness', aliasedName, true,
        type: i1.DriftSqlType.double);
i1.GeneratedColumn<bool> _column_59(String aliasedName) =>
    i1.GeneratedColumn<bool>('notifications', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("notifications" IN (0, 1))'),
        defaultValue: const Constant(true));

final class Schema35 extends i0.VersionedSchema {
  Schema35({required super.database}) : super(version: 35);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape15 gymSets = Shape15(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_45,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape27 settings = Shape27(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_52,
          _column_53,
          _column_37,
          _column_33,
          _column_48,
          _column_55,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_57,
          _column_21,
          _column_47,
          _column_27,
          _column_23,
          _column_49,
          _column_44,
          _column_28,
          _column_38,
          _column_29,
          _column_54,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
          _column_58,
          _column_59,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape25 planExercises = Shape25(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_56,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

final class Schema36 extends i0.VersionedSchema {
  Schema36({required super.database}) : super(version: 36);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape15 gymSets = Shape15(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_45,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape28 settings = Shape28(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_52,
          _column_53,
          _column_37,
          _column_33,
          _column_58,
          _column_48,
          _column_55,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_59,
          _column_57,
          _column_21,
          _column_47,
          _column_27,
          _column_23,
          _column_49,
          _column_60,
          _column_44,
          _column_28,
          _column_38,
          _column_29,
          _column_54,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape25 planExercises = Shape25(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_56,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape28 extends i0.VersionedTable {
  Shape28({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get alarmSound =>
      columnsByName['alarm_sound']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get automaticBackups =>
      columnsByName['automatic_backups']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get backupPath =>
      columnsByName['backup_path']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get cardioUnit =>
      columnsByName['cardio_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get curveLines =>
      columnsByName['curve_lines']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<double> get curveSmoothness =>
      columnsByName['curve_smoothness']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<bool> get durationEstimation =>
      columnsByName['duration_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get enableSound =>
      columnsByName['enable_sound']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get explainedPermissions =>
      columnsByName['explained_permissions']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get groupHistory =>
      columnsByName['group_history']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get longDateFormat =>
      columnsByName['long_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get notifications =>
      columnsByName['notifications']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get peekGraph =>
      columnsByName['peek_graph']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get planTrailing =>
      columnsByName['plan_trailing']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get repEstimation =>
      columnsByName['rep_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get restTimers =>
      columnsByName['rest_timers']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get shortDateFormat =>
      columnsByName['short_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get showBodyWeight =>
      columnsByName['show_body_weight']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showCategories =>
      columnsByName['show_categories']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showImages =>
      columnsByName['show_images']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showUnits =>
      columnsByName['show_units']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get strengthUnit =>
      columnsByName['strength_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get systemColors =>
      columnsByName['system_colors']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get tabs =>
      columnsByName['tabs']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get themeMode =>
      columnsByName['theme_mode']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get timerDuration =>
      columnsByName['timer_duration']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get vibrate =>
      columnsByName['vibrate']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get warmupSets =>
      columnsByName['warmup_sets']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<bool> _column_60(String aliasedName) =>
    i1.GeneratedColumn<bool>('show_categories', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("show_categories" IN (0, 1))'),
        defaultValue: const Constant(true));

final class Schema37 extends i0.VersionedSchema {
  Schema37({required super.database}) : super(version: 37);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape15 gymSets = Shape15(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_11,
          _column_14,
          _column_45,
          _column_7,
          _column_13,
          _column_12,
          _column_10,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape29 settings = Shape29(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_52,
          _column_53,
          _column_37,
          _column_33,
          _column_58,
          _column_48,
          _column_55,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_59,
          _column_57,
          _column_21,
          _column_47,
          _column_27,
          _column_23,
          _column_49,
          _column_60,
          _column_44,
          _column_61,
          _column_28,
          _column_38,
          _column_29,
          _column_54,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape25 planExercises = Shape25(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_56,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape29 extends i0.VersionedTable {
  Shape29({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get alarmSound =>
      columnsByName['alarm_sound']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get automaticBackups =>
      columnsByName['automatic_backups']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get backupPath =>
      columnsByName['backup_path']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get cardioUnit =>
      columnsByName['cardio_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get curveLines =>
      columnsByName['curve_lines']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<double> get curveSmoothness =>
      columnsByName['curve_smoothness']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<bool> get durationEstimation =>
      columnsByName['duration_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get enableSound =>
      columnsByName['enable_sound']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get explainedPermissions =>
      columnsByName['explained_permissions']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get groupHistory =>
      columnsByName['group_history']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get longDateFormat =>
      columnsByName['long_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get notifications =>
      columnsByName['notifications']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get peekGraph =>
      columnsByName['peek_graph']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get planTrailing =>
      columnsByName['plan_trailing']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get repEstimation =>
      columnsByName['rep_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get restTimers =>
      columnsByName['rest_timers']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get shortDateFormat =>
      columnsByName['short_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get showBodyWeight =>
      columnsByName['show_body_weight']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showCategories =>
      columnsByName['show_categories']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showImages =>
      columnsByName['show_images']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showNotes =>
      columnsByName['show_notes']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showUnits =>
      columnsByName['show_units']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get strengthUnit =>
      columnsByName['strength_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get systemColors =>
      columnsByName['system_colors']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get tabs =>
      columnsByName['tabs']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get themeMode =>
      columnsByName['theme_mode']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get timerDuration =>
      columnsByName['timer_duration']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get vibrate =>
      columnsByName['vibrate']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get warmupSets =>
      columnsByName['warmup_sets']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<bool> _column_61(String aliasedName) =>
    i1.GeneratedColumn<bool>('show_notes', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("show_notes" IN (0, 1))'),
        defaultValue: const Constant(true));

final class Schema38 extends i0.VersionedSchema {
  Schema38({required super.database}) : super(version: 38);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape30 gymSets = Shape30(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_62,
          _column_63,
          _column_45,
          _column_7,
          _column_64,
          _column_65,
          _column_66,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_67,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape29 settings = Shape29(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_68,
          _column_53,
          _column_37,
          _column_33,
          _column_58,
          _column_69,
          _column_70,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_71,
          _column_72,
          _column_21,
          _column_73,
          _column_27,
          _column_23,
          _column_74,
          _column_75,
          _column_76,
          _column_77,
          _column_28,
          _column_38,
          _column_29,
          _column_78,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape25 planExercises = Shape25(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_79,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape30 extends i0.VersionedTable {
  Shape30({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<double> get bodyWeight =>
      columnsByName['body_weight']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<bool> get cardio =>
      columnsByName['cardio']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get category =>
      columnsByName['category']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<DateTime> get created =>
      columnsByName['created']! as i1.GeneratedColumn<DateTime>;
  i1.GeneratedColumn<double> get distance =>
      columnsByName['distance']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<double> get duration =>
      columnsByName['duration']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<bool> get hidden =>
      columnsByName['hidden']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get image =>
      columnsByName['image']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get incline =>
      columnsByName['incline']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get name =>
      columnsByName['name']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get notes =>
      columnsByName['notes']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get planId =>
      columnsByName['plan_id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<double> get reps =>
      columnsByName['reps']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<int> get restMs =>
      columnsByName['rest_ms']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get unit =>
      columnsByName['unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<double> get weight =>
      columnsByName['weight']! as i1.GeneratedColumn<double>;
}

i1.GeneratedColumn<double> _column_62(String aliasedName) =>
    i1.GeneratedColumn<double>('body_weight', aliasedName, false,
        type: i1.DriftSqlType.double,
        defaultValue: const CustomExpression('0.0'));
i1.GeneratedColumn<bool> _column_63(String aliasedName) =>
    i1.GeneratedColumn<bool>('cardio', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints:
            i1.GeneratedColumn.constraintIsAlways('CHECK ("cardio" IN (0, 1))'),
        defaultValue: const CustomExpression('0'));
i1.GeneratedColumn<double> _column_64(String aliasedName) =>
    i1.GeneratedColumn<double>('distance', aliasedName, false,
        type: i1.DriftSqlType.double,
        defaultValue: const CustomExpression('0.0'));
i1.GeneratedColumn<double> _column_65(String aliasedName) =>
    i1.GeneratedColumn<double>('duration', aliasedName, false,
        type: i1.DriftSqlType.double,
        defaultValue: const CustomExpression('0.0'));
i1.GeneratedColumn<bool> _column_66(String aliasedName) =>
    i1.GeneratedColumn<bool>('hidden', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints:
            i1.GeneratedColumn.constraintIsAlways('CHECK ("hidden" IN (0, 1))'),
        defaultValue: const CustomExpression('0'));
i1.GeneratedColumn<String> _column_67(String aliasedName) =>
    i1.GeneratedColumn<String>('notes', aliasedName, true,
        type: i1.DriftSqlType.string);
i1.GeneratedColumn<bool> _column_68(String aliasedName) =>
    i1.GeneratedColumn<bool>('automatic_backups', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("automatic_backups" IN (0, 1))'),
        defaultValue: const CustomExpression('0'));
i1.GeneratedColumn<bool> _column_69(String aliasedName) =>
    i1.GeneratedColumn<bool>('duration_estimation', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("duration_estimation" IN (0, 1))'),
        defaultValue: const CustomExpression('1'));
i1.GeneratedColumn<bool> _column_70(String aliasedName) =>
    i1.GeneratedColumn<bool>('enable_sound', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("enable_sound" IN (0, 1))'),
        defaultValue: const CustomExpression('1'));
i1.GeneratedColumn<bool> _column_71(String aliasedName) =>
    i1.GeneratedColumn<bool>('notifications', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("notifications" IN (0, 1))'),
        defaultValue: const CustomExpression('1'));
i1.GeneratedColumn<bool> _column_72(String aliasedName) =>
    i1.GeneratedColumn<bool>('peek_graph', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("peek_graph" IN (0, 1))'),
        defaultValue: const CustomExpression('0'));
i1.GeneratedColumn<bool> _column_73(String aliasedName) =>
    i1.GeneratedColumn<bool>('rep_estimation', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("rep_estimation" IN (0, 1))'),
        defaultValue: const CustomExpression('1'));
i1.GeneratedColumn<bool> _column_74(String aliasedName) =>
    i1.GeneratedColumn<bool>('show_body_weight', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("show_body_weight" IN (0, 1))'),
        defaultValue: const CustomExpression('1'));
i1.GeneratedColumn<bool> _column_75(String aliasedName) =>
    i1.GeneratedColumn<bool>('show_categories', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("show_categories" IN (0, 1))'),
        defaultValue: const CustomExpression('1'));
i1.GeneratedColumn<bool> _column_76(String aliasedName) =>
    i1.GeneratedColumn<bool>('show_images', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("show_images" IN (0, 1))'),
        defaultValue: const CustomExpression('1'));
i1.GeneratedColumn<bool> _column_77(String aliasedName) =>
    i1.GeneratedColumn<bool>('show_notes', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("show_notes" IN (0, 1))'),
        defaultValue: const CustomExpression('1'));
i1.GeneratedColumn<String> _column_78(String aliasedName) =>
    i1.GeneratedColumn<String>('tabs', aliasedName, false,
        type: i1.DriftSqlType.string,
        defaultValue: const CustomExpression(
            '\'HistoryPage,PlansPage,GraphsPage,TimerPage\''));
i1.GeneratedColumn<bool> _column_79(String aliasedName) =>
    i1.GeneratedColumn<bool>('timers', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints:
            i1.GeneratedColumn.constraintIsAlways('CHECK ("timers" IN (0, 1))'),
        defaultValue: const CustomExpression('1'));

final class Schema39 extends i0.VersionedSchema {
  Schema39({required super.database}) : super(version: 39);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape30 gymSets = Shape30(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_62,
          _column_63,
          _column_45,
          _column_7,
          _column_64,
          _column_65,
          _column_66,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_67,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape31 settings = Shape31(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_68,
          _column_53,
          _column_37,
          _column_33,
          _column_58,
          _column_69,
          _column_70,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_71,
          _column_72,
          _column_21,
          _column_73,
          _column_27,
          _column_23,
          _column_74,
          _column_75,
          _column_76,
          _column_77,
          _column_80,
          _column_28,
          _column_38,
          _column_29,
          _column_78,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape25 planExercises = Shape25(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_79,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape31 extends i0.VersionedTable {
  Shape31({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get alarmSound =>
      columnsByName['alarm_sound']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get automaticBackups =>
      columnsByName['automatic_backups']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get backupPath =>
      columnsByName['backup_path']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get cardioUnit =>
      columnsByName['cardio_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get curveLines =>
      columnsByName['curve_lines']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<double> get curveSmoothness =>
      columnsByName['curve_smoothness']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<bool> get durationEstimation =>
      columnsByName['duration_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get enableSound =>
      columnsByName['enable_sound']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get explainedPermissions =>
      columnsByName['explained_permissions']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get groupHistory =>
      columnsByName['group_history']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get longDateFormat =>
      columnsByName['long_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get notifications =>
      columnsByName['notifications']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get peekGraph =>
      columnsByName['peek_graph']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get planTrailing =>
      columnsByName['plan_trailing']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get repEstimation =>
      columnsByName['rep_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get restTimers =>
      columnsByName['rest_timers']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get shortDateFormat =>
      columnsByName['short_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get showBodyWeight =>
      columnsByName['show_body_weight']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showCategories =>
      columnsByName['show_categories']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showImages =>
      columnsByName['show_images']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showNotes =>
      columnsByName['show_notes']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showGlobalProgress =>
      columnsByName['show_global_progress']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showUnits =>
      columnsByName['show_units']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get strengthUnit =>
      columnsByName['strength_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get systemColors =>
      columnsByName['system_colors']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get tabs =>
      columnsByName['tabs']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get themeMode =>
      columnsByName['theme_mode']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get timerDuration =>
      columnsByName['timer_duration']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get vibrate =>
      columnsByName['vibrate']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get warmupSets =>
      columnsByName['warmup_sets']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<bool> _column_80(String aliasedName) =>
    i1.GeneratedColumn<bool>('show_global_progress', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("show_global_progress" IN (0, 1))'),
        defaultValue: const CustomExpression('1'));

final class Schema40 extends i0.VersionedSchema {
  Schema40({required super.database}) : super(version: 40);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
    metadata,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape30 gymSets = Shape30(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_62,
          _column_63,
          _column_45,
          _column_7,
          _column_64,
          _column_65,
          _column_66,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_67,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape31 settings = Shape31(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_68,
          _column_53,
          _column_37,
          _column_33,
          _column_58,
          _column_69,
          _column_70,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_71,
          _column_72,
          _column_21,
          _column_73,
          _column_27,
          _column_23,
          _column_74,
          _column_75,
          _column_76,
          _column_77,
          _column_80,
          _column_28,
          _column_38,
          _column_29,
          _column_78,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape25 planExercises = Shape25(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_79,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape32 metadata = Shape32(
      source: i0.VersionedTable(
        entityName: 'metadata',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_81,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape32 extends i0.VersionedTable {
  Shape32({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<int> get buildNumber =>
      columnsByName['build_number']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_81(String aliasedName) =>
    i1.GeneratedColumn<int>('build_number', aliasedName, false,
        type: i1.DriftSqlType.int);

final class Schema41 extends i0.VersionedSchema {
  Schema41({required super.database}) : super(version: 41);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
    metadata,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape30 gymSets = Shape30(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_62,
          _column_63,
          _column_45,
          _column_7,
          _column_64,
          _column_65,
          _column_66,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_67,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape31 settings = Shape31(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_68,
          _column_53,
          _column_37,
          _column_33,
          _column_58,
          _column_69,
          _column_70,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_71,
          _column_72,
          _column_21,
          _column_73,
          _column_27,
          _column_23,
          _column_74,
          _column_75,
          _column_76,
          _column_77,
          _column_80,
          _column_28,
          _column_38,
          _column_29,
          _column_78,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape25 planExercises = Shape25(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_79,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape32 metadata = Shape32(
      source: i0.VersionedTable(
        entityName: 'metadata',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_81,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

final class Schema42 extends i0.VersionedSchema {
  Schema42({required super.database}) : super(version: 42);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
    metadata,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape30 gymSets = Shape30(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_62,
          _column_63,
          _column_45,
          _column_7,
          _column_64,
          _column_65,
          _column_66,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_67,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape31 settings = Shape31(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_68,
          _column_53,
          _column_37,
          _column_33,
          _column_58,
          _column_69,
          _column_70,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_71,
          _column_72,
          _column_21,
          _column_82,
          _column_27,
          _column_23,
          _column_74,
          _column_75,
          _column_76,
          _column_77,
          _column_80,
          _column_28,
          _column_38,
          _column_29,
          _column_78,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape25 planExercises = Shape25(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_79,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape32 metadata = Shape32(
      source: i0.VersionedTable(
        entityName: 'metadata',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_81,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

i1.GeneratedColumn<bool> _column_82(String aliasedName) =>
    i1.GeneratedColumn<bool>('rep_estimation', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("rep_estimation" IN (0, 1))'),
        defaultValue: const CustomExpression('0'));

final class Schema43 extends i0.VersionedSchema {
  Schema43({required super.database}) : super(version: 43);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
    metadata,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape30 gymSets = Shape30(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_62,
          _column_63,
          _column_45,
          _column_7,
          _column_64,
          _column_65,
          _column_66,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_67,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape33 settings = Shape33(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_68,
          _column_53,
          _column_37,
          _column_33,
          _column_58,
          _column_69,
          _column_70,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_71,
          _column_72,
          _column_21,
          _column_82,
          _column_27,
          _column_23,
          _column_74,
          _column_75,
          _column_76,
          _column_77,
          _column_80,
          _column_28,
          _column_38,
          _column_29,
          _column_78,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
          _column_83,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape25 planExercises = Shape25(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_79,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape32 metadata = Shape32(
      source: i0.VersionedTable(
        entityName: 'metadata',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_81,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape33 extends i0.VersionedTable {
  Shape33({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get alarmSound =>
      columnsByName['alarm_sound']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get automaticBackups =>
      columnsByName['automatic_backups']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get backupPath =>
      columnsByName['backup_path']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get cardioUnit =>
      columnsByName['cardio_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get curveLines =>
      columnsByName['curve_lines']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<double> get curveSmoothness =>
      columnsByName['curve_smoothness']! as i1.GeneratedColumn<double>;
  i1.GeneratedColumn<bool> get durationEstimation =>
      columnsByName['duration_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get enableSound =>
      columnsByName['enable_sound']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get explainedPermissions =>
      columnsByName['explained_permissions']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get groupHistory =>
      columnsByName['group_history']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get longDateFormat =>
      columnsByName['long_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get notifications =>
      columnsByName['notifications']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get peekGraph =>
      columnsByName['peek_graph']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get planTrailing =>
      columnsByName['plan_trailing']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get repEstimation =>
      columnsByName['rep_estimation']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get restTimers =>
      columnsByName['rest_timers']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get shortDateFormat =>
      columnsByName['short_date_format']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get showBodyWeight =>
      columnsByName['show_body_weight']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showCategories =>
      columnsByName['show_categories']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showImages =>
      columnsByName['show_images']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showNotes =>
      columnsByName['show_notes']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showGlobalProgress =>
      columnsByName['show_global_progress']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get showUnits =>
      columnsByName['show_units']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get strengthUnit =>
      columnsByName['strength_unit']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<bool> get systemColors =>
      columnsByName['system_colors']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get tabs =>
      columnsByName['tabs']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<String> get themeMode =>
      columnsByName['theme_mode']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get timerDuration =>
      columnsByName['timer_duration']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get vibrate =>
      columnsByName['vibrate']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<int> get warmupSets =>
      columnsByName['warmup_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<bool> get scrollableTabs =>
      columnsByName['scrollable_tabs']! as i1.GeneratedColumn<bool>;
}

i1.GeneratedColumn<bool> _column_83(String aliasedName) =>
    i1.GeneratedColumn<bool>('scrollable_tabs', aliasedName, false,
        type: i1.DriftSqlType.bool,
        defaultConstraints: i1.GeneratedColumn.constraintIsAlways(
            'CHECK ("scrollable_tabs" IN (0, 1))'),
        defaultValue: const CustomExpression('1'));

final class Schema44 extends i0.VersionedSchema {
  Schema44({required super.database}) : super(version: 44);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
    metadata,
  ];
  late final Shape3 plans = Shape3(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_1,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape30 gymSets = Shape30(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_62,
          _column_63,
          _column_45,
          _column_7,
          _column_64,
          _column_65,
          _column_66,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_67,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape33 settings = Shape33(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_68,
          _column_53,
          _column_37,
          _column_33,
          _column_58,
          _column_69,
          _column_70,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_71,
          _column_72,
          _column_21,
          _column_82,
          _column_27,
          _column_23,
          _column_74,
          _column_75,
          _column_76,
          _column_77,
          _column_80,
          _column_28,
          _column_38,
          _column_29,
          _column_78,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
          _column_83,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape25 planExercises = Shape25(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_79,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape32 metadata = Shape32(
      source: i0.VersionedTable(
        entityName: 'metadata',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_81,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

final class Schema45 extends i0.VersionedSchema {
  Schema45({required super.database}) : super(version: 45);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
    metadata,
  ];
  late final Shape34 plans = Shape34(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape30 gymSets = Shape30(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_62,
          _column_63,
          _column_45,
          _column_7,
          _column_64,
          _column_65,
          _column_66,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_67,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape33 settings = Shape33(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_68,
          _column_53,
          _column_37,
          _column_33,
          _column_58,
          _column_69,
          _column_70,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_71,
          _column_72,
          _column_21,
          _column_82,
          _column_27,
          _column_23,
          _column_74,
          _column_75,
          _column_76,
          _column_77,
          _column_80,
          _column_28,
          _column_38,
          _column_29,
          _column_78,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
          _column_83,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape25 planExercises = Shape25(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_79,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape32 metadata = Shape32(
      source: i0.VersionedTable(
        entityName: 'metadata',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_81,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape34 extends i0.VersionedTable {
  Shape34({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<String> get days =>
      columnsByName['days']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get sequence =>
      columnsByName['sequence']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<String> get title =>
      columnsByName['title']! as i1.GeneratedColumn<String>;
}

final class Schema46 extends i0.VersionedSchema {
  Schema46({required super.database}) : super(version: 46);
  @override
  late final List<i1.DatabaseSchemaEntity> entities = [
    plans,
    gymSets,
    settings,
    planExercises,
    metadata,
  ];
  late final Shape34 plans = Shape34(
      source: i0.VersionedTable(
        entityName: 'plans',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_2,
          _column_0,
          _column_8,
          _column_9,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape30 gymSets = Shape30(
      source: i0.VersionedTable(
        entityName: 'gym_sets',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_62,
          _column_63,
          _column_45,
          _column_7,
          _column_64,
          _column_65,
          _column_66,
          _column_0,
          _column_43,
          _column_17,
          _column_3,
          _column_67,
          _column_39,
          _column_4,
          _column_18,
          _column_6,
          _column_5,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape33 settings = Shape33(
      source: i0.VersionedTable(
        entityName: 'settings',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_36,
          _column_68,
          _column_53,
          _column_37,
          _column_33,
          _column_58,
          _column_69,
          _column_70,
          _column_30,
          _column_35,
          _column_0,
          _column_22,
          _column_25,
          _column_71,
          _column_72,
          _column_21,
          _column_82,
          _column_27,
          _column_23,
          _column_74,
          _column_75,
          _column_76,
          _column_77,
          _column_80,
          _column_28,
          _column_38,
          _column_29,
          _column_78,
          _column_20,
          _column_24,
          _column_26,
          _column_46,
          _column_83,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape35 planExercises = Shape35(
      source: i0.VersionedTable(
        entityName: 'plan_exercises',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_42,
          _column_79,
          _column_41,
          _column_0,
          _column_19,
          _column_40,
          _column_46,
          _column_84,
        ],
        attachedDatabase: database,
      ),
      alias: null);
  late final Shape32 metadata = Shape32(
      source: i0.VersionedTable(
        entityName: 'metadata',
        withoutRowId: false,
        isStrict: false,
        tableConstraints: [],
        columns: [
          _column_81,
        ],
        attachedDatabase: database,
      ),
      alias: null);
}

class Shape35 extends i0.VersionedTable {
  Shape35({required super.source, required super.alias}) : super.aliased();
  i1.GeneratedColumn<bool> get enabled =>
      columnsByName['enabled']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<bool> get timers =>
      columnsByName['timers']! as i1.GeneratedColumn<bool>;
  i1.GeneratedColumn<String> get exercise =>
      columnsByName['exercise']! as i1.GeneratedColumn<String>;
  i1.GeneratedColumn<int> get id =>
      columnsByName['id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get maxSets =>
      columnsByName['max_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get planId =>
      columnsByName['plan_id']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get warmupSets =>
      columnsByName['warmup_sets']! as i1.GeneratedColumn<int>;
  i1.GeneratedColumn<int> get sequence =>
      columnsByName['sequence']! as i1.GeneratedColumn<int>;
}

i1.GeneratedColumn<int> _column_84(String aliasedName) =>
    i1.GeneratedColumn<int>('sequence', aliasedName, false,
        type: i1.DriftSqlType.int, defaultValue: const CustomExpression('0'));
i0.MigrationStepWithVersion migrationSteps({
  required Future<void> Function(i1.Migrator m, Schema2 schema) from1To2,
  required Future<void> Function(i1.Migrator m, Schema3 schema) from2To3,
  required Future<void> Function(i1.Migrator m, Schema4 schema) from3To4,
  required Future<void> Function(i1.Migrator m, Schema5 schema) from4To5,
  required Future<void> Function(i1.Migrator m, Schema6 schema) from5To6,
  required Future<void> Function(i1.Migrator m, Schema7 schema) from6To7,
  required Future<void> Function(i1.Migrator m, Schema8 schema) from7To8,
  required Future<void> Function(i1.Migrator m, Schema10 schema) from8To10,
  required Future<void> Function(i1.Migrator m, Schema11 schema) from10To11,
  required Future<void> Function(i1.Migrator m, Schema12 schema) from11To12,
  required Future<void> Function(i1.Migrator m, Schema13 schema) from12To13,
  required Future<void> Function(i1.Migrator m, Schema14 schema) from13To14,
  required Future<void> Function(i1.Migrator m, Schema15 schema) from14To15,
  required Future<void> Function(i1.Migrator m, Schema16 schema) from15To16,
  required Future<void> Function(i1.Migrator m, Schema17 schema) from16To17,
  required Future<void> Function(i1.Migrator m, Schema18 schema) from17To18,
  required Future<void> Function(i1.Migrator m, Schema19 schema) from18To19,
  required Future<void> Function(i1.Migrator m, Schema20 schema) from19To20,
  required Future<void> Function(i1.Migrator m, Schema21 schema) from20To21,
  required Future<void> Function(i1.Migrator m, Schema22 schema) from21To22,
  required Future<void> Function(i1.Migrator m, Schema23 schema) from22To23,
  required Future<void> Function(i1.Migrator m, Schema24 schema) from23To24,
  required Future<void> Function(i1.Migrator m, Schema25 schema) from24To25,
  required Future<void> Function(i1.Migrator m, Schema26 schema) from25To26,
  required Future<void> Function(i1.Migrator m, Schema27 schema) from26To27,
  required Future<void> Function(i1.Migrator m, Schema28 schema) from27To28,
  required Future<void> Function(i1.Migrator m, Schema29 schema) from28To29,
  required Future<void> Function(i1.Migrator m, Schema30 schema) from29To30,
  required Future<void> Function(i1.Migrator m, Schema31 schema) from30To31,
  required Future<void> Function(i1.Migrator m, Schema32 schema) from31To32,
  required Future<void> Function(i1.Migrator m, Schema33 schema) from32To33,
  required Future<void> Function(i1.Migrator m, Schema34 schema) from33To34,
  required Future<void> Function(i1.Migrator m, Schema35 schema) from34To35,
  required Future<void> Function(i1.Migrator m, Schema36 schema) from35To36,
  required Future<void> Function(i1.Migrator m, Schema37 schema) from36To37,
  required Future<void> Function(i1.Migrator m, Schema38 schema) from37To38,
  required Future<void> Function(i1.Migrator m, Schema39 schema) from38To39,
  required Future<void> Function(i1.Migrator m, Schema40 schema) from39To40,
  required Future<void> Function(i1.Migrator m, Schema41 schema) from40To41,
  required Future<void> Function(i1.Migrator m, Schema42 schema) from41To42,
  required Future<void> Function(i1.Migrator m, Schema43 schema) from42To43,
  required Future<void> Function(i1.Migrator m, Schema44 schema) from43To44,
  required Future<void> Function(i1.Migrator m, Schema45 schema) from44To45,
  required Future<void> Function(i1.Migrator m, Schema46 schema) from45To46,
}) {
  return (currentVersion, database) async {
    switch (currentVersion) {
      case 1:
        final schema = Schema2(database: database);
        final migrator = i1.Migrator(database, schema);
        await from1To2(migrator, schema);
        return 2;
      case 2:
        final schema = Schema3(database: database);
        final migrator = i1.Migrator(database, schema);
        await from2To3(migrator, schema);
        return 3;
      case 3:
        final schema = Schema4(database: database);
        final migrator = i1.Migrator(database, schema);
        await from3To4(migrator, schema);
        return 4;
      case 4:
        final schema = Schema5(database: database);
        final migrator = i1.Migrator(database, schema);
        await from4To5(migrator, schema);
        return 5;
      case 5:
        final schema = Schema6(database: database);
        final migrator = i1.Migrator(database, schema);
        await from5To6(migrator, schema);
        return 6;
      case 6:
        final schema = Schema7(database: database);
        final migrator = i1.Migrator(database, schema);
        await from6To7(migrator, schema);
        return 7;
      case 7:
        final schema = Schema8(database: database);
        final migrator = i1.Migrator(database, schema);
        await from7To8(migrator, schema);
        return 8;
      case 8:
        final schema = Schema10(database: database);
        final migrator = i1.Migrator(database, schema);
        await from8To10(migrator, schema);
        return 10;
      case 10:
        final schema = Schema11(database: database);
        final migrator = i1.Migrator(database, schema);
        await from10To11(migrator, schema);
        return 11;
      case 11:
        final schema = Schema12(database: database);
        final migrator = i1.Migrator(database, schema);
        await from11To12(migrator, schema);
        return 12;
      case 12:
        final schema = Schema13(database: database);
        final migrator = i1.Migrator(database, schema);
        await from12To13(migrator, schema);
        return 13;
      case 13:
        final schema = Schema14(database: database);
        final migrator = i1.Migrator(database, schema);
        await from13To14(migrator, schema);
        return 14;
      case 14:
        final schema = Schema15(database: database);
        final migrator = i1.Migrator(database, schema);
        await from14To15(migrator, schema);
        return 15;
      case 15:
        final schema = Schema16(database: database);
        final migrator = i1.Migrator(database, schema);
        await from15To16(migrator, schema);
        return 16;
      case 16:
        final schema = Schema17(database: database);
        final migrator = i1.Migrator(database, schema);
        await from16To17(migrator, schema);
        return 17;
      case 17:
        final schema = Schema18(database: database);
        final migrator = i1.Migrator(database, schema);
        await from17To18(migrator, schema);
        return 18;
      case 18:
        final schema = Schema19(database: database);
        final migrator = i1.Migrator(database, schema);
        await from18To19(migrator, schema);
        return 19;
      case 19:
        final schema = Schema20(database: database);
        final migrator = i1.Migrator(database, schema);
        await from19To20(migrator, schema);
        return 20;
      case 20:
        final schema = Schema21(database: database);
        final migrator = i1.Migrator(database, schema);
        await from20To21(migrator, schema);
        return 21;
      case 21:
        final schema = Schema22(database: database);
        final migrator = i1.Migrator(database, schema);
        await from21To22(migrator, schema);
        return 22;
      case 22:
        final schema = Schema23(database: database);
        final migrator = i1.Migrator(database, schema);
        await from22To23(migrator, schema);
        return 23;
      case 23:
        final schema = Schema24(database: database);
        final migrator = i1.Migrator(database, schema);
        await from23To24(migrator, schema);
        return 24;
      case 24:
        final schema = Schema25(database: database);
        final migrator = i1.Migrator(database, schema);
        await from24To25(migrator, schema);
        return 25;
      case 25:
        final schema = Schema26(database: database);
        final migrator = i1.Migrator(database, schema);
        await from25To26(migrator, schema);
        return 26;
      case 26:
        final schema = Schema27(database: database);
        final migrator = i1.Migrator(database, schema);
        await from26To27(migrator, schema);
        return 27;
      case 27:
        final schema = Schema28(database: database);
        final migrator = i1.Migrator(database, schema);
        await from27To28(migrator, schema);
        return 28;
      case 28:
        final schema = Schema29(database: database);
        final migrator = i1.Migrator(database, schema);
        await from28To29(migrator, schema);
        return 29;
      case 29:
        final schema = Schema30(database: database);
        final migrator = i1.Migrator(database, schema);
        await from29To30(migrator, schema);
        return 30;
      case 30:
        final schema = Schema31(database: database);
        final migrator = i1.Migrator(database, schema);
        await from30To31(migrator, schema);
        return 31;
      case 31:
        final schema = Schema32(database: database);
        final migrator = i1.Migrator(database, schema);
        await from31To32(migrator, schema);
        return 32;
      case 32:
        final schema = Schema33(database: database);
        final migrator = i1.Migrator(database, schema);
        await from32To33(migrator, schema);
        return 33;
      case 33:
        final schema = Schema34(database: database);
        final migrator = i1.Migrator(database, schema);
        await from33To34(migrator, schema);
        return 34;
      case 34:
        final schema = Schema35(database: database);
        final migrator = i1.Migrator(database, schema);
        await from34To35(migrator, schema);
        return 35;
      case 35:
        final schema = Schema36(database: database);
        final migrator = i1.Migrator(database, schema);
        await from35To36(migrator, schema);
        return 36;
      case 36:
        final schema = Schema37(database: database);
        final migrator = i1.Migrator(database, schema);
        await from36To37(migrator, schema);
        return 37;
      case 37:
        final schema = Schema38(database: database);
        final migrator = i1.Migrator(database, schema);
        await from37To38(migrator, schema);
        return 38;
      case 38:
        final schema = Schema39(database: database);
        final migrator = i1.Migrator(database, schema);
        await from38To39(migrator, schema);
        return 39;
      case 39:
        final schema = Schema40(database: database);
        final migrator = i1.Migrator(database, schema);
        await from39To40(migrator, schema);
        return 40;
      case 40:
        final schema = Schema41(database: database);
        final migrator = i1.Migrator(database, schema);
        await from40To41(migrator, schema);
        return 41;
      case 41:
        final schema = Schema42(database: database);
        final migrator = i1.Migrator(database, schema);
        await from41To42(migrator, schema);
        return 42;
      case 42:
        final schema = Schema43(database: database);
        final migrator = i1.Migrator(database, schema);
        await from42To43(migrator, schema);
        return 43;
      case 43:
        final schema = Schema44(database: database);
        final migrator = i1.Migrator(database, schema);
        await from43To44(migrator, schema);
        return 44;
      case 44:
        final schema = Schema45(database: database);
        final migrator = i1.Migrator(database, schema);
        await from44To45(migrator, schema);
        return 45;
      case 45:
        final schema = Schema46(database: database);
        final migrator = i1.Migrator(database, schema);
        await from45To46(migrator, schema);
        return 46;
      default:
        throw ArgumentError.value('Unknown migration from $currentVersion');
    }
  };
}

i1.OnUpgrade stepByStep({
  required Future<void> Function(i1.Migrator m, Schema2 schema) from1To2,
  required Future<void> Function(i1.Migrator m, Schema3 schema) from2To3,
  required Future<void> Function(i1.Migrator m, Schema4 schema) from3To4,
  required Future<void> Function(i1.Migrator m, Schema5 schema) from4To5,
  required Future<void> Function(i1.Migrator m, Schema6 schema) from5To6,
  required Future<void> Function(i1.Migrator m, Schema7 schema) from6To7,
  required Future<void> Function(i1.Migrator m, Schema8 schema) from7To8,
  required Future<void> Function(i1.Migrator m, Schema10 schema) from8To10,
  required Future<void> Function(i1.Migrator m, Schema11 schema) from10To11,
  required Future<void> Function(i1.Migrator m, Schema12 schema) from11To12,
  required Future<void> Function(i1.Migrator m, Schema13 schema) from12To13,
  required Future<void> Function(i1.Migrator m, Schema14 schema) from13To14,
  required Future<void> Function(i1.Migrator m, Schema15 schema) from14To15,
  required Future<void> Function(i1.Migrator m, Schema16 schema) from15To16,
  required Future<void> Function(i1.Migrator m, Schema17 schema) from16To17,
  required Future<void> Function(i1.Migrator m, Schema18 schema) from17To18,
  required Future<void> Function(i1.Migrator m, Schema19 schema) from18To19,
  required Future<void> Function(i1.Migrator m, Schema20 schema) from19To20,
  required Future<void> Function(i1.Migrator m, Schema21 schema) from20To21,
  required Future<void> Function(i1.Migrator m, Schema22 schema) from21To22,
  required Future<void> Function(i1.Migrator m, Schema23 schema) from22To23,
  required Future<void> Function(i1.Migrator m, Schema24 schema) from23To24,
  required Future<void> Function(i1.Migrator m, Schema25 schema) from24To25,
  required Future<void> Function(i1.Migrator m, Schema26 schema) from25To26,
  required Future<void> Function(i1.Migrator m, Schema27 schema) from26To27,
  required Future<void> Function(i1.Migrator m, Schema28 schema) from27To28,
  required Future<void> Function(i1.Migrator m, Schema29 schema) from28To29,
  required Future<void> Function(i1.Migrator m, Schema30 schema) from29To30,
  required Future<void> Function(i1.Migrator m, Schema31 schema) from30To31,
  required Future<void> Function(i1.Migrator m, Schema32 schema) from31To32,
  required Future<void> Function(i1.Migrator m, Schema33 schema) from32To33,
  required Future<void> Function(i1.Migrator m, Schema34 schema) from33To34,
  required Future<void> Function(i1.Migrator m, Schema35 schema) from34To35,
  required Future<void> Function(i1.Migrator m, Schema36 schema) from35To36,
  required Future<void> Function(i1.Migrator m, Schema37 schema) from36To37,
  required Future<void> Function(i1.Migrator m, Schema38 schema) from37To38,
  required Future<void> Function(i1.Migrator m, Schema39 schema) from38To39,
  required Future<void> Function(i1.Migrator m, Schema40 schema) from39To40,
  required Future<void> Function(i1.Migrator m, Schema41 schema) from40To41,
  required Future<void> Function(i1.Migrator m, Schema42 schema) from41To42,
  required Future<void> Function(i1.Migrator m, Schema43 schema) from42To43,
  required Future<void> Function(i1.Migrator m, Schema44 schema) from43To44,
  required Future<void> Function(i1.Migrator m, Schema45 schema) from44To45,
  required Future<void> Function(i1.Migrator m, Schema46 schema) from45To46,
}) =>
    i0.VersionedSchema.stepByStepHelper(
        step: migrationSteps(
      from1To2: from1To2,
      from2To3: from2To3,
      from3To4: from3To4,
      from4To5: from4To5,
      from5To6: from5To6,
      from6To7: from6To7,
      from7To8: from7To8,
      from8To10: from8To10,
      from10To11: from10To11,
      from11To12: from11To12,
      from12To13: from12To13,
      from13To14: from13To14,
      from14To15: from14To15,
      from15To16: from15To16,
      from16To17: from16To17,
      from17To18: from17To18,
      from18To19: from18To19,
      from19To20: from19To20,
      from20To21: from20To21,
      from21To22: from21To22,
      from22To23: from22To23,
      from23To24: from23To24,
      from24To25: from24To25,
      from25To26: from25To26,
      from26To27: from26To27,
      from27To28: from27To28,
      from28To29: from28To29,
      from29To30: from29To30,
      from30To31: from30To31,
      from31To32: from31To32,
      from32To33: from32To33,
      from33To34: from33To34,
      from34To35: from34To35,
      from35To36: from35To36,
      from36To37: from36To37,
      from37To38: from37To38,
      from38To39: from38To39,
      from39To40: from39To40,
      from40To41: from40To41,
      from41To42: from41To42,
      from42To43: from42To43,
      from43To44: from43To44,
      from44To45: from44To45,
      from45To46: from45To46,
    ));
