// Standard constants exposed by the Win32 API.

// *** NOTE: This file contains constants that we have chosen not to document,
// mostly because their function is obvious, or because they are documented in
// the public Microsoft Windows documentation online.

// Contributors are invited and encouraged to submit comments for these
// constants from the open source Microsoft documentation, such as
// https://github.com/MicrosoftDocs/win32. Please move documented constants to
// `constants.dart` as appropriate to ensure they are picked up by `dartdoc`.

// ignore_for_file: camel_case_types, constant_identifier_names
// ignore_for_file: non_constant_identifier_names

// Do not document anything in this library.
/// @nodoc
library;

import 'dart:ffi';

import 'package:ffi/ffi.dart';

import 'constants.dart';
import 'enums.g.dart';
import 'macros.dart';

// -----------------------------------------------------------------------------
// Error constants
// -----------------------------------------------------------------------------

const ERROR_SEM_OWNER_DIED = 105;

const ERROR_SEM_USER_LIMIT = 106;

const ERROR_DISK_CHANGE = 107;

const ERROR_DRIVE_LOCKED = 108;

const ERROR_BROKEN_PIPE = 109;

const ERROR_OPEN_FAILED = 110;

const ERROR_BUFFER_OVERFLOW = 111;

const ERROR_DISK_FULL = 112;

const ERROR_NO_MORE_SEARCH_HANDLES = 113;

const ERROR_INVALID_TARGET_HANDLE = 114;

const ERROR_INVALID_CATEGORY = 117;

const ERROR_INVALID_VERIFY_SWITCH = 118;

const ERROR_BAD_DRIVER_LEVEL = 119;

const ERROR_CALL_NOT_IMPLEMENTED = 120;

const ERROR_SEM_TIMEOUT = 121;

const ERROR_INSUFFICIENT_BUFFER = 122;

const ERROR_INVALID_NAME = 123;

const ERROR_INVALID_LEVEL = 124;

const ERROR_NO_VOLUME_LABEL = 125;

const ERROR_MOD_NOT_FOUND = 126;

const ERROR_PROC_NOT_FOUND = 127;

const ERROR_WAIT_NO_CHILDREN = 128;

const ERROR_CHILD_NOT_COMPLETE = 129;

const ERROR_DIRECT_ACCESS_HANDLE = 130;

const ERROR_NEGATIVE_SEEK = 131;

const ERROR_SEEK_ON_DEVICE = 132;

const ERROR_IS_JOIN_TARGET = 133;

const ERROR_IS_JOINED = 134;

const ERROR_IS_SUBSTED = 135;

const ERROR_NOT_JOINED = 136;

const ERROR_NOT_SUBSTED = 137;

const ERROR_JOIN_TO_JOIN = 138;

const ERROR_SUBST_TO_SUBST = 139;

const ERROR_JOIN_TO_SUBST = 140;

const ERROR_SUBST_TO_JOIN = 141;

const ERROR_BUSY_DRIVE = 142;

const ERROR_SAME_DRIVE = 143;

const ERROR_DIR_NOT_ROOT = 144;

const ERROR_DIR_NOT_EMPTY = 145;

const ERROR_IS_SUBST_PATH = 146;

const ERROR_IS_JOIN_PATH = 147;

const ERROR_PATH_BUSY = 148;

const ERROR_IS_SUBST_TARGET = 149;

const ERROR_SYSTEM_TRACE = 150;

const ERROR_INVALID_EVENT_COUNT = 151;

const ERROR_TOO_MANY_MUXWAITERS = 152;

const ERROR_INVALID_LIST_FORMAT = 153;

const ERROR_LABEL_TOO_LONG = 154;

const ERROR_TOO_MANY_TCBS = 155;

const ERROR_SIGNAL_REFUSED = 156;

const ERROR_DISCARDED = 157;

const ERROR_NOT_LOCKED = 158;

const ERROR_BAD_THREADID_ADDR = 159;

const ERROR_BAD_ARGUMENTS = 160;

const ERROR_BAD_PATHNAME = 161;

const ERROR_SIGNAL_PENDING = 162;

const ERROR_MAX_THRDS_REACHED = 164;

const ERROR_LOCK_FAILED = 167;

const ERROR_BUSY = 170;

const ERROR_DEVICE_SUPPORT_IN_PROGRESS = 171;

const ERROR_CANCEL_VIOLATION = 173;

const ERROR_ATOMIC_LOCKS_NOT_SUPPORTED = 174;

const ERROR_INVALID_SEGMENT_NUMBER = 180;

const ERROR_INVALID_ORDINAL = 182;

const ERROR_ALREADY_EXISTS = 183;

const ERROR_INVALID_FLAG_NUMBER = 186;

const ERROR_SEM_NOT_FOUND = 187;

const ERROR_INVALID_STARTING_CODESEG = 188;

const ERROR_INVALID_STACKSEG = 189;

const ERROR_INVALID_MODULETYPE = 190;

const ERROR_INVALID_EXE_SIGNATURE = 191;

const ERROR_EXE_MARKED_INVALID = 192;

const ERROR_BAD_EXE_FORMAT = 193;

const ERROR_ITERATED_DATA_EXCEEDS_64k = 194;

const ERROR_INVALID_MINALLOCSIZE = 195;

const ERROR_DYNLINK_FROM_INVALID_RING = 196;

const ERROR_IOPL_NOT_ENABLED = 197;

const ERROR_INVALID_SEGDPL = 198;

const ERROR_AUTODATASEG_EXCEEDS_64k = 199;

const ERROR_MORE_DATA = 234;

const ERROR_NO_MORE_ITEMS = 259;

const ERROR_INVALID_FLAGS = 1004;

const ERROR_CANCELLED = 1223;

const ERROR_NOT_FOUND = 1168;

const ERROR_REVISION_MISMATCH = 1306;

const ERROR_NO_SUCH_LOGON_SESSION = 1312;

const ERROR_BAD_USERNAME = 2202;

const APPMODEL_ERROR_NO_PACKAGE = 15700;

const APPMODEL_ERROR_PACKAGE_RUNTIME_CORRUPT = 15701;

const APPMODEL_ERROR_PACKAGE_IDENTITY_CORRUPT = 15702;

const APPMODEL_ERROR_NO_APPLICATION = 15703;

const APPMODEL_ERROR_DYNAMIC_PROPERTY_READ_FAILED = 15704;

const APPMODEL_ERROR_DYNAMIC_PROPERTY_INVALID = 15705;

const APPMODEL_ERROR_PACKAGE_NOT_AVAILABLE = 15706;

const APPMODEL_ERROR_NO_MUTABLE_DIRECTORY = 15707;

// -----------------------------------------------------------------------------
// HID constants
// -----------------------------------------------------------------------------
const HID_USAGE_PAGE_UNDEFINED = 0x00;
const HID_USAGE_PAGE_GENERIC = 0x01;
const HID_USAGE_PAGE_SIMULATION = 0x02;
const HID_USAGE_PAGE_VR = 0x03;
const HID_USAGE_PAGE_SPORT = 0x04;
const HID_USAGE_PAGE_GAME = 0x05;
const HID_USAGE_PAGE_GENERIC_DEVICE = 0x06;
const HID_USAGE_PAGE_KEYBOARD = 0x07;
const HID_USAGE_PAGE_LED = 0x08;
const HID_USAGE_PAGE_BUTTON = 0x09;
const HID_USAGE_PAGE_ORDINAL = 0x0A;
const HID_USAGE_PAGE_TELEPHONY = 0x0B;
const HID_USAGE_PAGE_CONSUMER = 0x0C;
const HID_USAGE_PAGE_DIGITIZER = 0x0D;
const HID_USAGE_PAGE_HAPTICS = 0x0E;
const HID_USAGE_PAGE_PID = 0x0F;
const HID_USAGE_PAGE_UNICODE = 0x10;
const HID_USAGE_PAGE_ALPHANUMERIC = 0x14;
const HID_USAGE_PAGE_SENSOR = 0x20;
const HID_USAGE_PAGE_LIGHTING_ILLUMINATION = 0x59;
const HID_USAGE_PAGE_BARCODE_SCANNER = 0x8C;
const HID_USAGE_PAGE_WEIGHING_DEVICE = 0x8D;
const HID_USAGE_PAGE_MAGNETIC_STRIPE_READER = 0x8E;
const HID_USAGE_PAGE_CAMERA_CONTROL = 0x90;
const HID_USAGE_PAGE_ARCADE = 0x91;

const HID_USAGE_GENERIC_POINTER = 0x01;
const HID_USAGE_GENERIC_MOUSE = 0x02;
const HID_USAGE_GENERIC_JOYSTICK = 0x04;
const HID_USAGE_GENERIC_GAMEPAD = 0x05;
const HID_USAGE_GENERIC_KEYBOARD = 0x06;
const HID_USAGE_GENERIC_KEYPAD = 0x07;
const HID_USAGE_GENERIC_MULTI_AXIS_CONTROLLER = 0x08;
const HID_USAGE_GENERIC_TABLET_PC_SYSTEM_CTL = 0x09;
const HID_USAGE_GENERIC_PORTABLE_DEVICE_CONTROL = 0x0D;
const HID_USAGE_GENERIC_INTERACTIVE_CONTROL = 0x0E;
const HID_USAGE_GENERIC_COUNTED_BUFFER = 0x3A;
const HID_USAGE_GENERIC_SYSTEM_CTL = 0x80;
const HID_USAGE_GENERIC_X = 0x30;
const HID_USAGE_GENERIC_Y = 0x31;
const HID_USAGE_GENERIC_Z = 0x32;
const HID_USAGE_GENERIC_RX = 0x33;
const HID_USAGE_GENERIC_RY = 0x34;
const HID_USAGE_GENERIC_RZ = 0x35;
const HID_USAGE_GENERIC_SLIDER = 0x36;
const HID_USAGE_GENERIC_DIAL = 0x37;
const HID_USAGE_GENERIC_WHEEL = 0x38;
const HID_USAGE_GENERIC_HATSWITCH = 0x39;
const HID_USAGE_GENERIC_BYTE_COUNT = 0x3B;
const HID_USAGE_GENERIC_MOTION_WAKEUP = 0x3C;
const HID_USAGE_GENERIC_START = 0x3D;
const HID_USAGE_GENERIC_SELECT = 0x3E;
const HID_USAGE_GENERIC_VX = 0x40;
const HID_USAGE_GENERIC_VY = 0x41;
const HID_USAGE_GENERIC_VZ = 0x42;
const HID_USAGE_GENERIC_VBRX = 0x43;
const HID_USAGE_GENERIC_VBRY = 0x44;
const HID_USAGE_GENERIC_VBRZ = 0x45;
const HID_USAGE_GENERIC_VNO = 0x46;
const HID_USAGE_GENERIC_FEATURE_NOTIFICATION = 0x47;
const HID_USAGE_GENERIC_RESOLUTION_MULTIPLIER = 0x48;
const HID_USAGE_GENERIC_SYSCTL_POWER = 0x81;
const HID_USAGE_GENERIC_SYSCTL_SLEEP = 0x82;
const HID_USAGE_GENERIC_SYSCTL_WAKE = 0x83;
const HID_USAGE_GENERIC_SYSCTL_CONTEXT_MENU = 0x84;
const HID_USAGE_GENERIC_SYSCTL_MAIN_MENU = 0x85;
const HID_USAGE_GENERIC_SYSCTL_APP_MENU = 0x86;
const HID_USAGE_GENERIC_SYSCTL_HELP_MENU = 0x87;
const HID_USAGE_GENERIC_SYSCTL_MENU_EXIT = 0x88;
const HID_USAGE_GENERIC_SYSCTL_MENU_SELECT = 0x89;
const HID_USAGE_GENERIC_SYSCTL_MENU_RIGHT = 0x8A;
const HID_USAGE_GENERIC_SYSCTL_MENU_LEFT = 0x8B;
const HID_USAGE_GENERIC_SYSCTL_MENU_UP = 0x8C;
const HID_USAGE_GENERIC_SYSCTL_MENU_DOWN = 0x8D;
const HID_USAGE_GENERIC_SYSCTL_COLD_RESTART = 0x8E;
const HID_USAGE_GENERIC_SYSCTL_WARM_RESTART = 0x8F;
const HID_USAGE_GENERIC_DPAD_UP = 0x90;
const HID_USAGE_GENERIC_DPAD_DOWN = 0x91;
const HID_USAGE_GENERIC_DPAD_RIGHT = 0x92;
const HID_USAGE_GENERIC_DPAD_LEFT = 0x93;
const HID_USAGE_GENERIC_SYSCTL_FN = 0x97;
const HID_USAGE_GENERIC_SYSCTL_FN_LOCK = 0x98;
const HID_USAGE_GENERIC_SYSCTL_FN_LOCK_INDICATOR = 0x99;
const HID_USAGE_GENERIC_SYSCTL_DISMISS_NOTIFICATION = 0x9A;
const HID_USAGE_GENERIC_SYSCTL_DOCK = 0xA0;
const HID_USAGE_GENERIC_SYSCTL_UNDOCK = 0xA1;
const HID_USAGE_GENERIC_SYSCTL_SETUP = 0xA2;
const HID_USAGE_GENERIC_SYSCTL_SYS_BREAK = 0xA3;
const HID_USAGE_GENERIC_SYSCTL_SYS_DBG_BREAK = 0xA4;
const HID_USAGE_GENERIC_SYSCTL_APP_BREAK = 0xA5;
const HID_USAGE_GENERIC_SYSCTL_APP_DBG_BREAK = 0xA6;
const HID_USAGE_GENERIC_SYSCTL_MUTE = 0xA7;
const HID_USAGE_GENERIC_SYSCTL_HIBERNATE = 0xA8;
const HID_USAGE_GENERIC_SYSCTL_DISP_INVERT = 0xB0;
const HID_USAGE_GENERIC_SYSCTL_DISP_INTERNAL = 0xB1;
const HID_USAGE_GENERIC_SYSCTL_DISP_EXTERNAL = 0xB2;
const HID_USAGE_GENERIC_SYSCTL_DISP_BOTH = 0xB3;
const HID_USAGE_GENERIC_SYSCTL_DISP_DUAL = 0xB4;
const HID_USAGE_GENERIC_SYSCTL_DISP_TOGGLE = 0xB5;
const HID_USAGE_GENERIC_SYSCTL_DISP_SWAP = 0xB6;
const HID_USAGE_GENERIC_SYSCTL_DISP_AUTOSCALE = 0xB7;
const HID_USAGE_GENERIC_SYSTEM_DISPLAY_ROTATION_LOCK_BUTTON = 0xC9;
const HID_USAGE_GENERIC_SYSTEM_DISPLAY_ROTATION_LOCK_SLIDER_SWITCH = 0xCA;
const HID_USAGE_GENERIC_CONTROL_ENABLE = 0xCB;

const HID_USAGE_KEYBOARD_NOEVENT = 0x00;
const HID_USAGE_KEYBOARD_ROLLOVER = 0x01;
const HID_USAGE_KEYBOARD_POSTFAIL = 0x02;
const HID_USAGE_KEYBOARD_UNDEFINED = 0x03;
const HID_USAGE_KEYBOARD_aA = 0x04;
const HID_USAGE_KEYBOARD_zZ = 0x1D;
const HID_USAGE_KEYBOARD_ONE = 0x1E;
const HID_USAGE_KEYBOARD_ZERO = 0x27;
const HID_USAGE_KEYBOARD_LCTRL = 0xE0;
const HID_USAGE_KEYBOARD_LSHFT = 0xE1;
const HID_USAGE_KEYBOARD_LALT = 0xE2;
const HID_USAGE_KEYBOARD_LGUI = 0xE3;
const HID_USAGE_KEYBOARD_RCTRL = 0xE4;
const HID_USAGE_KEYBOARD_RSHFT = 0xE5;
const HID_USAGE_KEYBOARD_RALT = 0xE6;
const HID_USAGE_KEYBOARD_RGUI = 0xE7;
const HID_USAGE_KEYBOARD_SCROLL_LOCK = 0x47;
const HID_USAGE_KEYBOARD_NUM_LOCK = 0x53;
const HID_USAGE_KEYBOARD_CAPS_LOCK = 0x39;
const HID_USAGE_KEYBOARD_F1 = 0x3A;
const HID_USAGE_KEYBOARD_F2 = 0x3B;
const HID_USAGE_KEYBOARD_F3 = 0x3C;
const HID_USAGE_KEYBOARD_F4 = 0x3D;
const HID_USAGE_KEYBOARD_F5 = 0x3E;
const HID_USAGE_KEYBOARD_F6 = 0x3F;
const HID_USAGE_KEYBOARD_F7 = 0x40;
const HID_USAGE_KEYBOARD_F8 = 0x41;
const HID_USAGE_KEYBOARD_F9 = 0x42;
const HID_USAGE_KEYBOARD_F10 = 0x43;
const HID_USAGE_KEYBOARD_F11 = 0x44;
const HID_USAGE_KEYBOARD_F12 = 0x45;
const HID_USAGE_KEYBOARD_F13 = 0x68;
const HID_USAGE_KEYBOARD_F14 = 0x69;
const HID_USAGE_KEYBOARD_F15 = 0x6A;
const HID_USAGE_KEYBOARD_F16 = 0x6B;
const HID_USAGE_KEYBOARD_F17 = 0x6C;
const HID_USAGE_KEYBOARD_F18 = 0x6D;
const HID_USAGE_KEYBOARD_F19 = 0x6E;
const HID_USAGE_KEYBOARD_F20 = 0x6F;
const HID_USAGE_KEYBOARD_F21 = 0x70;
const HID_USAGE_KEYBOARD_F22 = 0x71;
const HID_USAGE_KEYBOARD_F23 = 0x72;
const HID_USAGE_KEYBOARD_F24 = 0x73;
const HID_USAGE_KEYBOARD_RETURN = 0x28;
const HID_USAGE_KEYBOARD_ESCAPE = 0x29;
const HID_USAGE_KEYBOARD_DELETE = 0x2A;
const HID_USAGE_KEYBOARD_PRINT_SCREEN = 0x46;
const HID_USAGE_KEYBOARD_DELETE_FORWARD = 0x4C;

// -----------------------------------------------------------------------------
// WindowMessage constants
// -----------------------------------------------------------------------------
const WM_CTLCOLORMSGBOX = 0x0132;
const WM_CTLCOLOREDIT = 0x0133;
const WM_CTLCOLORLISTBOX = 0x0134;
const WM_CTLCOLORBTN = 0x0135;
const WM_CTLCOLORDLG = 0x0136;
const WM_CTLCOLORSCROLLBAR = 0x0137;
const WM_CTLCOLORSTATIC = 0x0138;
const MN_GETHMENU = 0x01E1;

const int FVIRTKEY = TRUE;

const FNOINVERT = 0x02;

const FSHIFT = 0x04;

const FCONTROL = 0x08;

const FALT = 0x10;

const LF_FACESIZE = 32;
const LF_FULLFACESIZE = 64;
const HWND_DESKTOP = 0;

// -----------------------------------------------------------------------------
// System-wide parameters
// -----------------------------------------------------------------------------
const SPI_GETSHOWSOUNDS = 0x0038;

const SPI_SETSHOWSOUNDS = 0x0039;

const SPI_GETSTICKYKEYS = 0x003A;

const SPI_SETSTICKYKEYS = 0x003B;

const SPI_GETACCESSTIMEOUT = 0x003C;

const SPI_SETACCESSTIMEOUT = 0x003D;

const SPI_GETSERIALKEYS = 0x003E;

const SPI_SETSERIALKEYS = 0x003F;

const SPI_GETSOUNDSENTRY = 0x0040;

const SPI_SETSOUNDSENTRY = 0x0041;

const SPI_GETSNAPTODEFBUTTON = 0x005F;

const SPI_SETSNAPTODEFBUTTON = 0x0060;

const SPI_GETMOUSEHOVERWIDTH = 0x0062;

const SPI_SETMOUSEHOVERWIDTH = 0x0063;

const SPI_GETMOUSEHOVERHEIGHT = 0x0064;

const SPI_SETMOUSEHOVERHEIGHT = 0x0065;

const SPI_GETMOUSEHOVERTIME = 0x0066;

const SPI_SETMOUSEHOVERTIME = 0x0067;

const SPI_GETWHEELSCROLLLINES = 0x0068;

const SPI_SETWHEELSCROLLLINES = 0x0069;

const SPI_GETMENUSHOWDELAY = 0x006A;

const SPI_SETMENUSHOWDELAY = 0x006B;
const SPI_GETWHEELSCROLLCHARS = 0x006C;

const SPI_SETWHEELSCROLLCHARS = 0x006D;

const SPI_GETSHOWIMEUI = 0x006E;

const SPI_SETSHOWIMEUI = 0x006F;

const SPI_GETMOUSESPEED = 0x0070;

const SPI_SETMOUSESPEED = 0x0071;

const SPI_GETSCREENSAVERRUNNING = 0x0072;

const SPI_GETDESKWALLPAPER = 0x0073;

const SPI_GETAUDIODESCRIPTION = 0x0074;

const SPI_SETAUDIODESCRIPTION = 0x0075;

const SPI_GETSCREENSAVESECURE = 0x0076;

const SPI_SETSCREENSAVESECURE = 0x0077;

const SPI_GETHUNGAPPTIMEOUT = 0x0078;

const SPI_SETHUNGAPPTIMEOUT = 0x0079;

const SPI_GETWAITTOKILLTIMEOUT = 0x007A;

const SPI_SETWAITTOKILLTIMEOUT = 0x007B;

const SPI_GETWAITTOKILLSERVICETIMEOUT = 0x007C;

const SPI_SETWAITTOKILLSERVICETIMEOUT = 0x007D;

const SPI_GETMOUSEDOCKTHRESHOLD = 0x007E;

const SPI_SETMOUSEDOCKTHRESHOLD = 0x007F;

const SPI_GETPENDOCKTHRESHOLD = 0x0080;

const SPI_SETPENDOCKTHRESHOLD = 0x0081;

const SPI_GETWINARRANGING = 0x0082;

const SPI_SETWINARRANGING = 0x0083;

const SPI_GETMOUSEDRAGOUTTHRESHOLD = 0x0084;

const SPI_SETMOUSEDRAGOUTTHRESHOLD = 0x0085;

const SPI_GETPENDRAGOUTTHRESHOLD = 0x0086;

const SPI_SETPENDRAGOUTTHRESHOLD = 0x0087;

const SPI_GETMOUSESIDEMOVETHRESHOLD = 0x0088;

const SPI_SETMOUSESIDEMOVETHRESHOLD = 0x0089;

const SPI_GETPENSIDEMOVETHRESHOLD = 0x008A;

const SPI_SETPENSIDEMOVETHRESHOLD = 0x008B;

const SPI_GETDRAGFROMMAXIMIZE = 0x008C;

const SPI_SETDRAGFROMMAXIMIZE = 0x008D;

const SPI_GETSNAPSIZING = 0x008E;

const SPI_SETSNAPSIZING = 0x008F;

const SPI_GETDOCKMOVING = 0x0090;

const SPI_SETDOCKMOVING = 0x0091;

// Menu flags
const MF_INSERT = 0x00000000;

const MF_CHANGE = 0x00000080;

const MF_APPEND = 0x00000100;

const MF_DELETE = 0x00000200;

const MF_REMOVE = 0x00001000;

const MF_USECHECKBITMAPS = 0x00000200;

const MF_DEFAULT = 0x00001000;

const MF_SYSMENU = 0x00002000;

const MF_HELP = 0x00004000;

const MF_RIGHTJUSTIFY = 0x00004000;

const MF_MOUSESELECT = 0x00008000;

const MF_END = 0x00000080;

const ANSI_CHARSET = 0;

const DEFAULT_CHARSET = 1;

const SYMBOL_CHARSET = 2;

const SHIFTJIS_CHARSET = 128;

const HANGEUL_CHARSET = 129;

const HANGUL_CHARSET = 129;

const GB2312_CHARSET = 134;

const CHINESEBIG5_CHARSET = 136;

const OEM_CHARSET = 255;

const JOHAB_CHARSET = 130;

const HEBREW_CHARSET = 177;

const ARABIC_CHARSET = 178;

const GREEK_CHARSET = 161;

const TURKISH_CHARSET = 162;

const VIETNAMESE_CHARSET = 163;

const THAI_CHARSET = 222;

const EASTEUROPE_CHARSET = 238;

const RUSSIAN_CHARSET = 204;

// Common Dialog window strings
const LBSELCHSTRING = 'commdlg_LBSelChangedNotify';
const SHAREVISTRING = 'commdlg_ShareViolation';
const FILEOKSTRING = 'commdlg_FileNameOK';
const COLOROKSTRING = 'commdlg_ColorOK';
const SETRGBSTRING = 'commdlg_SetRGBColor';
const HELPMSGSTRING = 'commdlg_help';
const FINDMSGSTRING = 'commdlg_FindReplace';

// Stock logical objects
const WHITE_BRUSH = 0;

const LTGRAY_BRUSH = 1;

const GRAY_BRUSH = 2;

const DKGRAY_BRUSH = 3;

const BLACK_BRUSH = 4;

const NULL_BRUSH = 5;

const int HOLLOW_BRUSH = NULL_BRUSH;

const WHITE_PEN = 6;

const BLACK_PEN = 7;

const NULL_PEN = 8;

const OEM_FIXED_FONT = 10;

const ANSI_FIXED_FONT = 11;

const ANSI_VAR_FONT = 12;

const SYSTEM_FONT = 13;

const DEVICE_DEFAULT_FONT = 14;

const DEFAULT_PALETTE = 15;

const SYSTEM_FIXED_FONT = 16;

// Background modes

const TRANSPARENT = 1;

const OPAQUE = 2;

const BKMODE_LAST = 2;

// DIB color table identifiers
const DIB_RGB_COLORS = 0;

const DIB_PAL_COLORS = 1;

// GetDeviceCaps capabilities
const DT_PLOTTER = 0;
const DT_RASDISPLAY = 1;
const DT_RASPRINTER = 2;
const DT_RASCAMERA = 3;
const DT_CHARSTREAM = 4;
const DT_METAFILE = 5;
const DT_DISPFILE = 6;
const CC_NONE = 0;
const CC_CIRCLES = 1;
const CC_PIE = 2;
const CC_CHORD = 4;
const CC_ELLIPSES = 8;
const CC_WIDE = 16;
const CC_STYLED = 32;
const CC_WIDESTYLED = 64;
const CC_INTERIORS = 128;
const CC_ROUNDRECT = 256;
const LC_NONE = 0;
const LC_POLYLINE = 2;
const LC_MARKER = 4;
const LC_POLYMARKER = 8;
const LC_WIDE = 16;
const LC_STYLED = 32;
const LC_WIDESTYLED = 64;
const LC_INTERIORS = 128;
const PC_NONE = 0;
const PC_POLYGON = 1;
const PC_RECTANGLE = 2;
const PC_WINDPOLYGON = 4;
const PC_TRAPEZOID = 4;
const PC_SCANLINE = 8;
const PC_WIDE = 16;
const PC_STYLED = 32;
const PC_WIDESTYLED = 64;
const PC_INTERIORS = 128;
const PC_POLYPOLYGON = 256;
const PC_PATHS = 512;
const CP_NONE = 0;
const CP_RECTANGLE = 1;
const CP_REGION = 2;
const TC_OP_CHARACTER = 0x00000001;
const TC_OP_STROKE = 0x00000002;
const TC_CP_STROKE = 0x00000004;
const TC_CR_90 = 0x00000008;
const TC_CR_ANY = 0x00000010;
const TC_SF_X_YINDEP = 0x00000020;
const TC_SA_DOUBLE = 0x00000040;
const TC_SA_INTEGER = 0x00000080;
const TC_SA_CONTIN = 0x00000100;
const TC_EA_DOUBLE = 0x00000200;
const TC_IA_ABLE = 0x00000400;
const TC_UA_ABLE = 0x00000800;
const TC_SO_ABLE = 0x00001000;
const TC_RA_ABLE = 0x00002000;
const TC_VA_ABLE = 0x00004000;
const TC_RESERVED = 0x00008000;
const TC_SCROLLBLT = 0x00010000;
const RC_NONE = 0;
const RC_BITBLT = 1;
const RC_BANDING = 2;
const RC_SCALING = 4;
const RC_BITMAP64 = 8;
const RC_GDI20_OUTPUT = 0x0010;
const RC_GDI20_STATE = 0x0020;
const RC_SAVEBITMAP = 0x0040;
const RC_DI_BITMAP = 0x0080;
const RC_PALETTE = 0x0100;
const RC_DIBTODEV = 0x0200;
const RC_BIGFONT = 0x0400;
const RC_STRETCHBLT = 0x0800;
const RC_FLOODFILL = 0x1000;
const RC_STRETCHDIB = 0x2000;
const RC_OP_DX_OUTPUT = 0x4000;
const RC_DEVBITS = 0x8000;
const SB_NONE = 0x00000000;
const SB_CONST_ALPHA = 0x00000001;
const SB_PIXEL_ALPHA = 0x00000002;
const SB_PREMULT_ALPHA = 0x00000004;
const SB_GRAD_RECT = 0x00000010;
const SB_GRAD_TRI = 0x00000020;
const CM_NONE = 0x00000000;
const CM_DEVICE_ICM = 0x00000001;
const CM_GAMMA_RAMP = 0x00000002;
const CM_CMYK_COLOR = 0x00000004;

/* Ternary raster operations */
const SRCCOPY = 0x00CC0020;

const SRCPAINT = 0x00EE0086;

const SRCAND = 0x008800C6;

const SRCINVERT = 0x00660046;

const SRCERASE = 0x00440328;

const NOTSRCCOPY = 0x00330008;

const NOTSRCERASE = 0x001100A6;

const MERGECOPY = 0x00C000CA;

const MERGEPAINT = 0x00BB0226;

const PATCOPY = 0x00F00021;

const PATPAINT = 0x00FB0A09;

const PATINVERT = 0x005A0049;

const DSTINVERT = 0x00550009;

const BLACKNESS = 0x00000042;

const WHITENESS = 0x00FF0062;

const NOMIRRORBITMAP = 0x80000000;

const CAPTUREBLT = 0x40000000;

// Dialog box command IDs
const IDOK = 1;

const IDCANCEL = 2;

const IDABORT = 3;

const IDRETRY = 4;

const IDIGNORE = 5;

const IDYES = 6;

const IDNO = 7;

const IDCLOSE = 8;

const IDHELP = 9;

const IDTRYAGAIN = 10;

const IDCONTINUE = 11;

// MessageBox flags
const IDTIMEOUT = 32000;

// Virtual keys
const VK_LBUTTON = 0x01;

const VK_RBUTTON = 0x02;

const VK_CANCEL = 0x03;

const VK_MBUTTON = 0x04;

const VK_XBUTTON1 = 0x05;

const VK_XBUTTON2 = 0x06;

const VK_BACK = 0x08;

const VK_TAB = 0x09;

const VK_CLEAR = 0x0C;

const VK_RETURN = 0x0D;

const VK_SHIFT = 0x10;

const VK_CONTROL = 0x11;

const VK_MENU = 0x12;

const VK_PAUSE = 0x13;

const VK_CAPITAL = 0x14;

const VK_KANA = 0x15;

const VK_HANGEUL = 0x15;

const VK_HANGUL = 0x15;

const VK_JUNJA = 0x17;

const VK_FINAL = 0x18;

const VK_HANJA = 0x19;

const VK_KANJI = 0x19;

const VK_ESCAPE = 0x1B;

const VK_CONVERT = 0x1C;

const VK_NONCONVERT = 0x1D;

const VK_ACCEPT = 0x1E;

const VK_MODECHANGE = 0x1F;

const VK_SPACE = 0x20;

const VK_PRIOR = 0x21;

const VK_NEXT = 0x22;

const VK_END = 0x23;

const VK_HOME = 0x24;

const VK_LEFT = 0x25;

const VK_UP = 0x26;

const VK_RIGHT = 0x27;

const VK_DOWN = 0x28;

const VK_SELECT = 0x29;

const VK_PRINT = 0x2A;

const VK_EXECUTE = 0x2B;

const VK_SNAPSHOT = 0x2C;

const VK_INSERT = 0x2D;

const VK_DELETE = 0x2E;

const VK_HELP = 0x2F;

const VK_LWIN = 0x5B;

const VK_RWIN = 0x5C;

const VK_APPS = 0x5D;

const VK_SLEEP = 0x5F;

const VK_NUMPAD0 = 0x60;

const VK_NUMPAD1 = 0x61;

const VK_NUMPAD2 = 0x62;

const VK_NUMPAD3 = 0x63;

const VK_NUMPAD4 = 0x64;

const VK_NUMPAD5 = 0x65;

const VK_NUMPAD6 = 0x66;

const VK_NUMPAD7 = 0x67;

const VK_NUMPAD8 = 0x68;

const VK_NUMPAD9 = 0x69;

const VK_MULTIPLY = 0x6A;

const VK_ADD = 0x6B;

const VK_SEPARATOR = 0x6C;

const VK_SUBTRACT = 0x6D;

const VK_DECIMAL = 0x6E;

const VK_DIVIDE = 0x6F;

const VK_F1 = 0x70;

const VK_F2 = 0x71;

const VK_F3 = 0x72;

const VK_F4 = 0x73;

const VK_F5 = 0x74;

const VK_F6 = 0x75;

const VK_F7 = 0x76;

const VK_F8 = 0x77;

const VK_F9 = 0x78;

const VK_F10 = 0x79;

const VK_F11 = 0x7A;

const VK_F12 = 0x7B;

const VK_F13 = 0x7C;

const VK_F14 = 0x7D;

const VK_F15 = 0x7E;

const VK_F16 = 0x7F;

const VK_F17 = 0x80;

const VK_F18 = 0x81;

const VK_F19 = 0x82;

const VK_F20 = 0x83;

const VK_F21 = 0x84;

const VK_F22 = 0x85;

const VK_F23 = 0x86;

const VK_F24 = 0x87;

const VK_NUMLOCK = 0x90;

const VK_SCROLL = 0x91;

const VK_LSHIFT = 0xA0;

const VK_RSHIFT = 0xA1;

const VK_LCONTROL = 0xA2;

const VK_RCONTROL = 0xA3;

const VK_LMENU = 0xA4;

const VK_RMENU = 0xA5;

const VK_BROWSER_BACK = 0xA6;

const VK_BROWSER_FORWARD = 0xA7;

const VK_BROWSER_REFRESH = 0xA8;

const VK_BROWSER_STOP = 0xA9;

const VK_BROWSER_SEARCH = 0xAA;

const VK_BROWSER_FAVORITES = 0xAB;

const VK_BROWSER_HOME = 0xAC;

const VK_VOLUME_MUTE = 0xAD;

const VK_VOLUME_DOWN = 0xAE;

const VK_VOLUME_UP = 0xAF;

const VK_MEDIA_NEXT_TRACK = 0xB0;

const VK_MEDIA_PREV_TRACK = 0xB1;

const VK_MEDIA_STOP = 0xB2;

const VK_MEDIA_PLAY_PAUSE = 0xB3;

const VK_LAUNCH_MAIL = 0xB4;

const VK_LAUNCH_MEDIA_SELECT = 0xB5;

const VK_LAUNCH_APP1 = 0xB6;

const VK_LAUNCH_APP2 = 0xB7;

const VK_OEM_1 = 0xBA;

const VK_OEM_PLUS = 0xBB;

const VK_OEM_COMMA = 0xBC;

const VK_OEM_MINUS = 0xBD;

const VK_OEM_PERIOD = 0xBE;

const VK_OEM_2 = 0xBF;

const VK_OEM_3 = 0xC0;

const VK_OEM_4 = 0xDB;

const VK_OEM_5 = 0xDC;

const VK_OEM_6 = 0xDD;

const VK_OEM_7 = 0xDE;

const VK_OEM_8 = 0xDF;

const VK_OEM_AX = 0xE1;

const VK_OEM_102 = 0xE2;

const VK_ICO_HELP = 0xE3;

const VK_ICO_00 = 0xE4;

const VK_PROCESSKEY = 0xE5;

const VK_ICO_CLEAR = 0xE6;

const VK_PACKET = 0xE7;

// Hook codes
const HC_ACTION = 0;

// Input types
const INPUT_MOUSE = 0;

const INPUT_KEYBOARD = 1;

const INPUT_HARDWARE = 2;

// Keyboard and mouse events

const KEYEVENTF_EXTENDEDKEY = 0x0001;

const KEYEVENTF_KEYUP = 0x0002;

const KEYEVENTF_UNICODE = 0x0004;

const KEYEVENTF_SCANCODE = 0x0008;

const MOUSEEVENTF_MOVE = 0x0001;

const MOUSEEVENTF_LEFTDOWN = 0x0002;

const MOUSEEVENTF_LEFTUP = 0x0004;

const MOUSEEVENTF_RIGHTDOWN = 0x0008;

const MOUSEEVENTF_RIGHTUP = 0x0010;

const MOUSEEVENTF_MIDDLEDOWN = 0x0020;

const MOUSEEVENTF_MIDDLEUP = 0x0040;

const MOUSEEVENTF_XDOWN = 0x0080;

const MOUSEEVENTF_XUP = 0x0100;

const MOUSEEVENTF_WHEEL = 0x0800;

const MOUSEEVENTF_HWHEEL = 0x01000;

const MOUSEEVENTF_MOVE_NOCOALESCE = 0x2000;

const MOUSEEVENTF_VIRTUALDESK = 0x4000;

const MOUSEEVENTF_ABSOLUTE = 0x8000;

// Classic Folder IDs
const CSIDL_DESKTOP = 0x0000;
const CSIDL_INTERNET = 0x0001;
const CSIDL_PROGRAMS = 0x0002;
const CSIDL_CONTROLS = 0x0003;
const CSIDL_PRINTERS = 0x0004;
const CSIDL_PERSONAL = 0x0005;
const CSIDL_FAVORITES = 0x0006;
const CSIDL_STARTUP = 0x0007;
const CSIDL_RECENT = 0x0008;
const CSIDL_SENDTO = 0x0009;
const CSIDL_BITBUCKET = 0x000a;
const CSIDL_STARTMENU = 0x000b;
const int CSIDL_MYDOCUMENTS = CSIDL_PERSONAL;
const CSIDL_MYMUSIC = 0x000d;
const CSIDL_MYVIDEO = 0x000e;
const CSIDL_DESKTOPDIRECTORY = 0x0010;
const CSIDL_DRIVES = 0x0011;
const CSIDL_NETWORK = 0x0012;
const CSIDL_NETHOOD = 0x0013;
const CSIDL_FONTS = 0x0014;
const CSIDL_TEMPLATES = 0x0015;
const CSIDL_COMMON_STARTMENU = 0x0016;
const CSIDL_COMMON_PROGRAMS = 0X0017;
const CSIDL_COMMON_STARTUP = 0x0018;
const CSIDL_COMMON_DESKTOPDIRECTORY = 0x0019;
const CSIDL_APPDATA = 0x001a;
const CSIDL_PRINTHOOD = 0x001b;
const CSIDL_LOCAL_APPDATA = 0x001c;
const CSIDL_ALTSTARTUP = 0x001d;
const CSIDL_COMMON_ALTSTARTUP = 0x001e;
const CSIDL_COMMON_FAVORITES = 0x001f;
const CSIDL_INTERNET_CACHE = 0x0020;
const CSIDL_COOKIES = 0x0021;
const CSIDL_HISTORY = 0x0022;
const CSIDL_COMMON_APPDATA = 0x0023;
const CSIDL_WINDOWS = 0x0024;
const CSIDL_SYSTEM = 0x0025;
const CSIDL_PROGRAM_FILES = 0x0026;
const CSIDL_MYPICTURES = 0x0027;
const CSIDL_PROFILE = 0x0028;
const CSIDL_SYSTEMX86 = 0x0029;
const CSIDL_PROGRAM_FILESX86 = 0x002a;
const CSIDL_PROGRAM_FILES_COMMON = 0x002b;
const CSIDL_PROGRAM_FILES_COMMONX86 = 0x002c;
const CSIDL_COMMON_TEMPLATES = 0x002d;
const CSIDL_COMMON_DOCUMENTS = 0x002e;
const CSIDL_COMMON_ADMINTOOLS = 0x002f;
const CSIDL_ADMINTOOLS = 0x0030;
const CSIDL_CONNECTIONS = 0x0031;
const CSIDL_COMMON_MUSIC = 0x0035;
const CSIDL_COMMON_PICTURES = 0x0036;
const CSIDL_COMMON_VIDEO = 0x0037;
const CSIDL_RESOURCES = 0x0038;
const CSIDL_RESOURCES_LOCALIZED = 0x0039;
const CSIDL_COMMON_OEM_LINKS = 0x003a;
const CSIDL_CDBURN_AREA = 0x003b;
const CSIDL_COMPUTERSNEARME = 0x003d;
const CSIDL_FLAG_CREATE = 0x8000;
const CSIDL_FLAG_DONT_VERIFY = 0x4000;
const CSIDL_FLAG_DONT_UNEXPAND = 0x2000;
const CSIDL_FLAG_NO_ALIAS = 0x1000;
const CSIDL_FLAG_PER_USER_INIT = 0x0800;
const CSIDL_FLAG_MASK = 0xFF00;

// Version info constants

const FILE_VER_GET_LOCALISED = 0x01;

const FILE_VER_GET_NEUTRAL = 0x02;

const FILE_VER_GET_PREFETCHED = 0x04;

const VFFF_ISSHAREDFILE = 0x0001;

const VIFF_FORCEINSTALL = 0x0001;

const VIFF_DONTDELETEOLD = 0x0002;

// Process constants
const PROCESS_TERMINATE = 0x0001;

const PROCESS_CREATE_THREAD = 0x0002;

const PROCESS_SET_SESSIONID = 0x0004;

const PROCESS_VM_OPERATION = 0x0008;

const PROCESS_VM_READ = 0x0010;

const PROCESS_VM_WRITE = 0x0020;

const PROCESS_DUP_HANDLE = 0x0040;

const PROCESS_CREATE_PROCESS = 0x0080;

const PROCESS_SET_QUOTA = 0x0100;

const PROCESS_SET_INFORMATION = 0x0200;

const PROCESS_QUERY_INFORMATION = 0x0400;

const PROCESS_SUSPEND_RESUME = 0x0800;

const PROCESS_QUERY_LIMITED_INFORMATION = 0x1000;

const PROCESS_SET_LIMITED_INFORMATION = 0x2000;

const int PROCESS_ALL_ACCESS = STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0xFFFF;

const PROC_THREAD_ATTRIBUTE_NUMBER = 0x0000FFFF;
const PROC_THREAD_ATTRIBUTE_THREAD = 0x00010000;
const PROC_THREAD_ATTRIBUTE_INPUT = 0x00020000;
const PROC_THREAD_ATTRIBUTE_ADDITIVE = 0x00040000;
const int PROC_THREAD_ATTRIBUTE_PSEUDOCONSOLE =
    (ProcThreadAttributePseudoConsole & PROC_THREAD_ATTRIBUTE_NUMBER) |
    PROC_THREAD_ATTRIBUTE_INPUT;

// Common Control send messages
const int UDM_SETRANGE = WM_USER + 101;
const int UDM_GETRANGE = WM_USER + 102;
const int UDM_SETPOS = WM_USER + 103;
const int UDM_GETPOS = WM_USER + 104;
const int UDM_SETBUDDY = WM_USER + 105;
const int UDM_GETBUDDY = WM_USER + 106;
const int UDM_SETACCEL = WM_USER + 107;
const int UDM_GETACCEL = WM_USER + 108;
const int UDM_SETBASE = WM_USER + 109;
const int UDM_GETBASE = WM_USER + 110;
const int UDM_SETRANGE32 = WM_USER + 111;
const int UDM_GETRANGE32 = WM_USER + 112;
const int UDM_SETUNICODEFORMAT = CCM_SETUNICODEFORMAT;
const int UDM_GETUNICODEFORMAT = CCM_GETUNICODEFORMAT;
const int UDM_SETPOS32 = WM_USER + 113;
const int UDM_GETPOS32 = WM_USER + 114;
const CCM_FIRST = 0x2000;
const int CCM_SETUNICODEFORMAT = CCM_FIRST + 5;
const int CCM_GETUNICODEFORMAT = CCM_FIRST + 6;

// Version constants
const VER_MINORVERSION = 0x0000001;

const VER_MAJORVERSION = 0x0000002;

const VER_BUILDNUMBER = 0x0000004;

const VER_PLATFORMID = 0x0000008;

const VER_SERVICEPACKMINOR = 0x0000010;

const VER_SERVICEPACKMAJOR = 0x0000020;

const VER_SUITENAME = 0x0000040;

const VER_PRODUCT_TYPE = 0x0000080;

const VER_NT_WORKSTATION = 0x0000001;
const VER_NT_DOMAIN_CONTROLLER = 0x0000002;
const VER_NT_SERVER = 0x0000003;

// Process dwCreationFlags info
const DEBUG_PROCESS = 0x00000001;

const DEBUG_ONLY_THIS_PROCESS = 0x00000002;

const CREATE_SUSPENDED = 0x00000004;

const DETACHED_PROCESS = 0x00000008;

const CREATE_NEW_CONSOLE = 0x00000010;

const NORMAL_PRIORITY_CLASS = 0x00000020;

const IDLE_PRIORITY_CLASS = 0x00000040;

const HIGH_PRIORITY_CLASS = 0x00000080;

const REALTIME_PRIORITY_CLASS = 0x00000100;

const CREATE_NEW_PROCESS_GROUP = 0x00000200;

const CREATE_UNICODE_ENVIRONMENT = 0x00000400;

const CREATE_SEPARATE_WOW_VDM = 0x00000800;

const CREATE_SHARED_WOW_VDM = 0x00001000;

const CREATE_FORCEDOS = 0x00002000;

const BELOW_NORMAL_PRIORITY_CLASS = 0x00004000;

const ABOVE_NORMAL_PRIORITY_CLASS = 0x00008000;

const INHERIT_PARENT_AFFINITY = 0x00010000;

const INHERIT_CALLER_PRIORITY = 0x00020000;

const CREATE_PROTECTED_PROCESS = 0x00040000;

const EXTENDED_STARTUPINFO_PRESENT = 0x00080000;

const PROCESS_MODE_BACKGROUND_BEGIN = 0x00100000;

const PROCESS_MODE_BACKGROUND_END = 0x00200000;

const CREATE_SECURE_PROCESS = 0x00400000;

const CREATE_BREAKAWAY_FROM_JOB = 0x01000000;

const CREATE_PRESERVE_CODE_AUTHZ_LEVEL = 0x02000000;

const CREATE_DEFAULT_ERROR_MODE = 0x04000000;

const CREATE_NO_WINDOW = 0x08000000;

const PROFILE_USER = 0x10000000;

const PROFILE_KERNEL = 0x20000000;

const PROFILE_SERVER = 0x40000000;

const CREATE_IGNORE_SYSTEM_DEFAULT = 0x80000000;

// Registry keys
const HKEY_CLASSES_ROOT = 0x80000000;
const HKEY_CURRENT_USER = 0x80000001;
const HKEY_LOCAL_MACHINE = 0x80000002;
const HKEY_USERS = 0x80000003;
const HKEY_PERFORMANCE_DATA = 0x80000004;
const HKEY_PERFORMANCE_TEXT = 0x80000050;
const HKEY_PERFORMANCE_NLSTEXT = 0x80000060;
const HKEY_CURRENT_CONFIG = 0x80000005;
const HKEY_DYN_DATA = 0x80000006;
const HKEY_CURRENT_USER_LOCAL_SETTINGS = 0x80000007;

const RRF_RT_REG_NONE = 0x00000001;

const RRF_RT_REG_SZ = 0x00000002;

const RRF_RT_REG_EXPAND_SZ = 0x00000004;

const RRF_RT_REG_BINARY = 0x00000008;

const RRF_RT_REG_DWORD = 0x00000010;

const RRF_RT_REG_MULTI_SZ = 0x00000020;

const RRF_RT_REG_QWORD = 0x00000040;

const int RRF_RT_DWORD = RRF_RT_REG_BINARY | RRF_RT_REG_DWORD;

const int RRF_RT_QWORD = RRF_RT_REG_BINARY | RRF_RT_REG_QWORD;

const RRF_RT_ANY = 0x0000ffff;

const RRF_SUBKEY_WOW6464KEY = 0x00010000;

const RRF_SUBKEY_WOW6432KEY = 0x00020000;

const RRF_WOW64_MASK = 0x00030000;

const RRF_NOEXPAND = 0x10000000;

const RRF_ZEROONFAILURE = 0x20000000;

// -----------------------------------------------------------------------------
// Display device constants that are used but not documented
// -----------------------------------------------------------------------------

const DISPLAY_DEVICE_ATTACHED_TO_DESKTOP = 0x00000001;

const DISPLAY_DEVICE_ATTACHED = 0x00000002;

const DISPLAY_DEVICE_MULTI_DRIVER = 0x00000002;

const DISPLAY_DEVICE_ACC_DRIVER = 0x00000040;

const DISPLAY_DEVICE_UNSAFE_MODES_ON = 0x00080000;

const DISPLAY_DEVICE_TS_COMPATIBLE = 0x00200000;

const DISPLAY_DEVICE_RDPUDD = 0x01000000;

const DISPLAY_DEVICE_REMOTE = 0x04000000;

const DISPLAY_DEVICE_DISCONNECT = 0x02000000;

// -----------------------------------------------------------------------------
// Gamepad constants
// -----------------------------------------------------------------------------

const XINPUT_DEVTYPE_GAMEPAD = 0x01;

const XINPUT_DEVSUBTYPE_UNKNOWN = 0x00;

const XINPUT_DEVSUBTYPE_GAMEPAD = 0x01;

const XINPUT_DEVSUBTYPE_WHEEL = 0x02;

const XINPUT_DEVSUBTYPE_ARCADE_STICK = 0x03;

const XINPUT_DEVSUBTYPE_FLIGHT_STICK = 0x04;

const XINPUT_DEVSUBTYPE_DANCE_PAD = 0x05;

const XINPUT_DEVSUBTYPE_GUITAR = 0x06;

const XINPUT_DEVSUBTYPE_GUITAR_ALTERNATE = 0x07;

const XINPUT_DEVSUBTYPE_DRUM_KIT = 0x08;

const XINPUT_DEVSUBTYPE_GUITAR_BASS = 0x0B;

const XINPUT_DEVSUBTYPE_ARCADE_PAD = 0x13;

const XINPUT_CAPS_VOICE_SUPPORTED = 0x0004;

const XINPUT_CAPS_FFB_SUPPORTED = 0x0001;

const XINPUT_CAPS_WIRELESS = 0x0002;

const XINPUT_CAPS_PMD_SUPPORTED = 0x0008;

const XINPUT_CAPS_NO_NAVIGATION = 0x0010;

const XINPUT_GAMEPAD_DPAD_UP = 0x0001;

const XINPUT_GAMEPAD_DPAD_DOWN = 0x0002;

const XINPUT_GAMEPAD_DPAD_LEFT = 0x0004;

const XINPUT_GAMEPAD_DPAD_RIGHT = 0x0008;

const XINPUT_GAMEPAD_START = 0x0010;

const XINPUT_GAMEPAD_BACK = 0x0020;

const XINPUT_GAMEPAD_LEFT_THUMB = 0x0040;

const XINPUT_GAMEPAD_RIGHT_THUMB = 0x0080;

const XINPUT_GAMEPAD_LEFT_SHOULDER = 0x0100;

const XINPUT_GAMEPAD_RIGHT_SHOULDER = 0x0200;

const XINPUT_GAMEPAD_A = 0x1000;

const XINPUT_GAMEPAD_B = 0x2000;

const XINPUT_GAMEPAD_X = 0x4000;

const XINPUT_GAMEPAD_Y = 0x8000;

const XINPUT_GAMEPAD_LEFT_THUMB_DEADZONE = 7849;

const XINPUT_GAMEPAD_RIGHT_THUMB_DEADZONE = 8689;

const XINPUT_GAMEPAD_TRIGGER_THRESHOLD = 30;

const XINPUT_FLAG_GAMEPAD = 0x00000001;

const BATTERY_DEVTYPE_GAMEPAD = 0x00;

const BATTERY_DEVTYPE_HEADSET = 0x01;

const BATTERY_TYPE_DISCONNECTED = 0x00;

const BATTERY_TYPE_WIRED = 0x01;

const BATTERY_TYPE_ALKALINE = 0x02;

const BATTERY_TYPE_NIMH = 0x03;

const BATTERY_TYPE_UNKNOWN = 0xFF;

const BATTERY_LEVEL_EMPTY = 0x00;

const BATTERY_LEVEL_LOW = 0x01;

const BATTERY_LEVEL_MEDIUM = 0x02;

const BATTERY_LEVEL_FULL = 0x03;

const XUSER_MAX_COUNT = 4;

const VK_PAD_A = 0x5800;

const VK_PAD_B = 0x5801;

const VK_PAD_X = 0x5802;

const VK_PAD_Y = 0x5803;

const VK_PAD_RSHOULDER = 0x5804;

const VK_PAD_LSHOULDER = 0x5805;

const VK_PAD_LTRIGGER = 0x5806;

const VK_PAD_RTRIGGER = 0x5807;

const VK_PAD_DPAD_UP = 0x5810;

const VK_PAD_DPAD_DOWN = 0x5811;

const VK_PAD_DPAD_LEFT = 0x5812;

const VK_PAD_DPAD_RIGHT = 0x5813;

const VK_PAD_START = 0x5814;

const VK_PAD_BACK = 0x5815;

const VK_PAD_LTHUMB_PRESS = 0x5816;

const VK_PAD_RTHUMB_PRESS = 0x5817;

const VK_PAD_LTHUMB_UP = 0x5820;

const VK_PAD_LTHUMB_DOWN = 0x5821;

const VK_PAD_LTHUMB_RIGHT = 0x5822;

const VK_PAD_LTHUMB_LEFT = 0x5823;

const VK_PAD_LTHUMB_UPLEFT = 0x5824;

const VK_PAD_LTHUMB_UPRIGHT = 0x5825;

const VK_PAD_LTHUMB_DOWNRIGHT = 0x5826;

const VK_PAD_LTHUMB_DOWNLEFT = 0x5827;

const VK_PAD_RTHUMB_UP = 0x5830;

const VK_PAD_RTHUMB_DOWN = 0x5831;

const VK_PAD_RTHUMB_RIGHT = 0x5832;

const VK_PAD_RTHUMB_LEFT = 0x5833;

const VK_PAD_RTHUMB_UPLEFT = 0x5834;

const VK_PAD_RTHUMB_UPRIGHT = 0x5835;

const VK_PAD_RTHUMB_DOWNRIGHT = 0x5836;

const VK_PAD_RTHUMB_DOWNLEFT = 0x5837;

const XINPUT_KEYSTROKE_KEYDOWN = 0x0001;

const XINPUT_KEYSTROKE_KEYUP = 0x0002;

const XINPUT_KEYSTROKE_REPEAT = 0x0004;

// -----------------------------------------------------------------------------
// Console constants
// -----------------------------------------------------------------------------

// Handles
const INVALID_HANDLE_VALUE = -1;
const ATTACH_PARENT_PROCESS = -1;

// -----------------------------------------------------------------------------
// Monitor APIs
// -----------------------------------------------------------------------------

const MC_CAPS_NONE = 0x00000000;
const MC_CAPS_MONITOR_TECHNOLOGY_TYPE = 0x00000001;
const MC_CAPS_BRIGHTNESS = 0x00000002;
const MC_CAPS_CONTRAST = 0x00000004;
const MC_CAPS_COLOR_TEMPERATURE = 0x00000008;
const MC_CAPS_RED_GREEN_BLUE_GAIN = 0x00000010;
const MC_CAPS_RED_GREEN_BLUE_DRIVE = 0x00000020;
const MC_CAPS_DEGAUSS = 0x00000040;
const MC_CAPS_DISPLAY_AREA_POSITION = 0x00000080;
const MC_CAPS_DISPLAY_AREA_SIZE = 0x00000100;
const MC_CAPS_RESTORE_FACTORY_DEFAULTS = 0x00000400;
const MC_CAPS_RESTORE_FACTORY_COLOR_DEFAULTS = 0x00000800;
const MC_RESTORE_FACTORY_DEFAULTS_ENABLES_MONITOR_SETTINGS = 0x00001000;
const MC_SUPPORTED_COLOR_TEMPERATURE_NONE = 0x00000000;
const MC_SUPPORTED_COLOR_TEMPERATURE_4000K = 0x00000001;
const MC_SUPPORTED_COLOR_TEMPERATURE_5000K = 0x00000002;
const MC_SUPPORTED_COLOR_TEMPERATURE_6500K = 0x00000004;
const MC_SUPPORTED_COLOR_TEMPERATURE_7500K = 0x00000008;
const MC_SUPPORTED_COLOR_TEMPERATURE_8200K = 0x00000010;
const MC_SUPPORTED_COLOR_TEMPERATURE_9300K = 0x00000020;
const MC_SUPPORTED_COLOR_TEMPERATURE_10000K = 0x00000040;
const MC_SUPPORTED_COLOR_TEMPERATURE_11500K = 0x00000080;

// *** COM CONSTANTS ***
final int CO_E_NOTINITIALIZED = 0x800401F0.toSigned(32);
final int CO_E_ALREADYINITIALIZED = 0x800401F1.toSigned(32);
final int CO_E_CANTDETERMINECLASS = 0x800401F2.toSigned(32);
final int CO_E_CLASSSTRING = 0x800401F3.toSigned(32);
final int CO_E_IIDSTRING = 0x800401F4.toSigned(32);
final int CO_E_APPNOTFOUND = 0x800401F5.toSigned(32);
final int CO_E_APPSINGLEUSE = 0x800401F6.toSigned(32);
final int CO_E_ERRORINAPP = 0x800401F7.toSigned(32);
final int CO_E_DLLNOTFOUND = 0x800401F8.toSigned(32);
final int CO_E_ERRORINDLL = 0x800401F9.toSigned(32);
final int CO_E_WRONGOSFORAPP = 0x800401FA.toSigned(32);
final int CO_E_OBJNOTREG = 0x800401FB.toSigned(32);
final int CO_E_OBJISREG = 0x800401FC.toSigned(32);
final int CO_E_OBJNOTCONNECTED = 0x800401FD.toSigned(32);
final int CO_E_APPDIDNTREG = 0x800401FE.toSigned(32);
final int CLASS_E_NOAGGREGATION = 0x80040110.toSigned(32);
final int CLASS_E_CLASSNOTAVAILABLE = 0x80040111.toSigned(32);
final int CLASS_E_NOTLICENSED = 0x80040112.toSigned(32);
final int RPC_E_CHANGED_MODE = 0x80010106.toSigned(32);
final int RPC_E_TOO_LATE = 0x80010119.toSigned(32);
final int REGDB_E_CLASSNOTREG = 0x80040154.toSigned(32);
final int REGDB_E_IIDNOTREG = 0x80040155.toSigned(32);

// Smartcard errors
const int SCARD_S_SUCCESS = NO_ERROR;
final int SCARD_E_CANCELLED = 0x80100002.toSigned(32);
final int SCARD_E_INVALID_HANDLE = 0x80100003.toSigned(32);
final int SCARD_E_INVALID_PARAMETER = 0x80100004.toSigned(32);
final int SCARD_E_INVALID_TARGET = 0x80100005.toSigned(32);
final int SCARD_E_NO_MEMORY = 0x80100006.toSigned(32);
final int SCARD_F_WAITED_TOO_LONG = 0x80100007.toSigned(32);
final int SCARD_E_INSUFFICIENT_BUFFER = 0x80100008.toSigned(32);
final int SCARD_E_UNKNOWN_READER = 0x80100009.toSigned(32);
final int SCARD_E_TIMEOUT = 0x8010000A.toSigned(32);
final int SCARD_E_SHARING_VIOLATION = 0x8010000B.toSigned(32);
final int SCARD_E_NO_SMARTCARD = 0x8010000C.toSigned(32);
final int SCARD_E_UNKNOWN_CARD = 0x8010000D.toSigned(32);
final int SCARD_E_CANT_DISPOSE = 0x8010000E.toSigned(32);
final int SCARD_E_PROTO_MISMATCH = 0x8010000F.toSigned(32);
final int SCARD_E_NOT_READY = 0x80100010.toSigned(32);
final int SCARD_E_INVALID_VALUE = 0x80100011.toSigned(32);
final int SCARD_E_SYSTEM_CANCELLED = 0x80100012.toSigned(32);
final int SCARD_F_COMM_ERROR = 0x80100013.toSigned(32);
final int SCARD_F_UNKNOWN_ERROR = 0x80100014.toSigned(32);
final int SCARD_E_INVALID_ATR = 0x80100015.toSigned(32);
final int SCARD_E_NOT_TRANSACTED = 0x80100016.toSigned(32);
final int SCARD_E_READER_UNAVAILABLE = 0x80100017.toSigned(32);
final int SCARD_P_SHUTDOWN = 0x80100018.toSigned(32);
final int SCARD_E_PCI_TOO_SMALL = 0x80100019.toSigned(32);
final int SCARD_E_READER_UNSUPPORTED = 0x8010001A.toSigned(32);
final int SCARD_E_DUPLICATE_READER = 0x8010001B.toSigned(32);
final int SCARD_E_CARD_UNSUPPORTED = 0x8010001C.toSigned(32);
final int SCARD_E_NO_SERVICE = 0x8010001D.toSigned(32);
final int SCARD_E_SERVICE_STOPPED = 0x8010001E.toSigned(32);
final int SCARD_E_UNEXPECTED = 0x8010001F.toSigned(32);
final int SCARD_E_ICC_INSTALLATION = 0x80100020.toSigned(32);
final int SCARD_E_ICC_CREATEORDER = 0x80100021.toSigned(32);
final int SCARD_E_UNSUPPORTED_FEATURE = 0x80100022.toSigned(32);
final int SCARD_E_DIR_NOT_FOUND = 0x80100023.toSigned(32);
final int SCARD_E_FILE_NOT_FOUND = 0x80100024.toSigned(32);
final int SCARD_E_NO_DIR = 0x80100025.toSigned(32);
final int SCARD_E_NO_FILE = 0x80100026.toSigned(32);
final int SCARD_E_NO_ACCESS = 0x80100027.toSigned(32);
final int SCARD_E_WRITE_TOO_MANY = 0x80100028.toSigned(32);
final int SCARD_E_BAD_SEEK = 0x80100029.toSigned(32);
final int SCARD_E_INVALID_CHV = 0x8010002A.toSigned(32);
final int SCARD_E_UNKNOWN_RES_MNG = 0x8010002B.toSigned(32);
final int SCARD_E_NO_SUCH_CERTIFICATE = 0x8010002C.toSigned(32);
final int SCARD_E_CERTIFICATE_UNAVAILABLE = 0x8010002D.toSigned(32);
final int SCARD_E_NO_READERS_AVAILABLE = 0x8010002E.toSigned(32);
final int SCARD_E_COMM_DATA_LOST = 0x8010002F.toSigned(32);
final int SCARD_E_NO_KEY_CONTAINER = 0x80100030.toSigned(32);
final int SCARD_E_SERVER_TOO_BUSY = 0x80100031.toSigned(32);
final int SCARD_E_PIN_CACHE_EXPIRED = 0x80100032.toSigned(32);
final int SCARD_E_NO_PIN_CACHE = 0x80100033.toSigned(32);
final int SCARD_E_READ_ONLY_CARD = 0x80100034.toSigned(32);
final int SCARD_W_UNSUPPORTED_CARD = 0x80100065.toSigned(32);
final int SCARD_W_UNRESPONSIVE_CARD = 0x80100066.toSigned(32);
final int SCARD_W_UNPOWERED_CARD = 0x80100067.toSigned(32);
final int SCARD_W_RESET_CARD = 0x80100068.toSigned(32);
final int SCARD_W_REMOVED_CARD = 0x80100069.toSigned(32);
final int SCARD_W_SECURITY_VIOLATION = 0x8010006A.toSigned(32);
final int SCARD_W_WRONG_CHV = 0x8010006B.toSigned(32);
final int SCARD_W_CHV_BLOCKED = 0x8010006C.toSigned(32);
final int SCARD_W_EOF = 0x8010006D.toSigned(32);
final int SCARD_W_CANCELLED_BY_USER = 0x8010006E.toSigned(32);
final int SCARD_W_CARD_NOT_AUTHENTICATED = 0x8010006F.toSigned(32);
final int SCARD_W_CACHE_ITEM_NOT_FOUND = 0x80100070.toSigned(32);
final int SCARD_W_CACHE_ITEM_STALE = 0x80100071.toSigned(32);
final int SCARD_W_CACHE_ITEM_TOO_BIG = 0x80100072.toSigned(32);

const CLSCTX_INPROC_SERVER16 = 0x8;

const CLSCTX_INPROC_HANDLER16 = 0x20;

const CLSCTX_RESERVED1 = 0x40;

const CLSCTX_RESERVED2 = 0x80;

const CLSCTX_RESERVED3 = 0x100;

const CLSCTX_RESERVED4 = 0x200;

const CLSCTX_NO_CODE_DOWNLOAD = 0x400;

const CLSCTX_RESERVED5 = 0x800;

const CLSCTX_NO_CUSTOM_MARSHAL = 0x1000;

const CLSCTX_ENABLE_CODE_DOWNLOAD = 0x2000;

const CLSCTX_NO_FAILURE_LOG = 0x4000;

const CLSCTX_DISABLE_AAA = 0x8000;

const CLSCTX_ENABLE_AAA = 0x10000;

const CLSCTX_FROM_DEFAULT_CONTEXT = 0x20000;

const CLSCTX_ACTIVATE_X86_SERVER = 0x40000;

const int CLSCTX_ACTIVATE_32_BIT_SERVER = CLSCTX_ACTIVATE_X86_SERVER;

const CLSCTX_ACTIVATE_64_BIT_SERVER = 0x80000;

const CLSCTX_ENABLE_CLOAKING = 0x100000;

const CLSCTX_APPCONTAINER = 0x400000;

const CLSCTX_ACTIVATE_AAA_AS_IU = 0x800000;

const CLSCTX_RESERVED6 = 0x1000000;

const CLSCTX_ACTIVATE_ARM32_SERVER = 0x2000000;

const CLSCTX_PS_DLL = 0x80000000;

// RPC authentication
const RPC_C_AUTHN_LEVEL_DEFAULT = 0;

const RPC_C_AUTHN_LEVEL_NONE = 1;

const RPC_C_AUTHN_LEVEL_CONNECT = 2;

const RPC_C_AUTHN_LEVEL_CALL = 3;

const RPC_C_AUTHN_LEVEL_PKT = 4;

const RPC_C_AUTHN_LEVEL_PKT_INTEGRITY = 5;

const RPC_C_AUTHN_LEVEL_PKT_PRIVACY = 6;

const RPC_C_IMP_LEVEL_DEFAULT = 0;

const RPC_C_IMP_LEVEL_ANONYMOUS = 1;

const RPC_C_IMP_LEVEL_IDENTIFY = 2;

const RPC_C_IMP_LEVEL_IMPERSONATE = 3;

const RPC_C_IMP_LEVEL_DELEGATE = 4;

const RPC_C_AUTHN_NONE = 0;
const RPC_C_AUTHN_DCE_PRIVATE = 1;
const RPC_C_AUTHN_DCE_PUBLIC = 2;
const RPC_C_AUTHN_DEC_PUBLIC = 4;
const RPC_C_AUTHN_GSS_NEGOTIATE = 9;
const RPC_C_AUTHN_WINNT = 10;
const RPC_C_AUTHN_GSS_SCHANNEL = 14;
const RPC_C_AUTHN_GSS_KERBEROS = 16;
const RPC_C_AUTHN_DPA = 17;
const RPC_C_AUTHN_MSN = 18;
const RPC_C_AUTHZ_NONE = 0;
const RPC_C_AUTHZ_NAME = 1;
const RPC_C_AUTHZ_DCE = 2;
const RPC_C_AUTHZ_DEFAULT = 0xffffffff;

// Known folder flags
const KF_FLAG_DEFAULT = 0x00000000;

const KF_FLAG_FORCE_APP_DATA_REDIRECTION = 0x00080000;

const KF_FLAG_RETURN_FILTER_REDIRECTION_TARGET = 0x00040000;

const KF_FLAG_FORCE_PACKAGE_REDIRECTION = 0x00020000;

const KF_FLAG_NO_PACKAGE_REDIRECTION = 0x00010000;

const KF_FLAG_FORCE_APPCONTAINER_REDIRECTION = 0x00020000;

const KF_FLAG_NO_APPCONTAINER_REDIRECTION = 0x00010000;

const KF_FLAG_CREATE = 0x00008000;

const KF_FLAG_DONT_VERIFY = 0x00004000;

const KF_FLAG_DONT_UNEXPAND = 0x00002000;

const KF_FLAG_NO_ALIAS = 0x00001000;

const KF_FLAG_INIT = 0x00000800;

const KF_FLAG_DEFAULT_PATH = 0x00000400;

const KF_FLAG_NOT_PARENT_RELATIVE = 0x00000200;

const KF_FLAG_SIMPLE_IDLIST = 0x00000100;

const KF_FLAG_ALIAS_ONLY = -2147483648;

// Init common controls bitflag
const ICC_LISTVIEW_CLASSES = 0x00000001;

const ICC_TREEVIEW_CLASSES = 0x00000002;

const ICC_BAR_CLASSES = 0x00000004;

const ICC_TAB_CLASSES = 0x00000008;

const ICC_UPDOWN_CLASS = 0x00000010;

const ICC_PROGRESS_CLASS = 0x00000020;

const ICC_HOTKEY_CLASS = 0x00000040;

const ICC_ANIMATE_CLASS = 0x00000080;

const ICC_WIN95_CLASSES = 0x000000FF;

const ICC_DATE_CLASSES = 0x00000100;

const ICC_USEREX_CLASSES = 0x00000200;

const ICC_COOL_CLASSES = 0x00000400;

const ICC_INTERNET_CLASSES = 0x00000800;

const ICC_PAGESCROLLER_CLASS = 0x00001000;

const ICC_NATIVEFNTCTL_CLASS = 0x00002000;

const ICC_STANDARD_CLASSES = 0x00004000;

const ICC_LINK_CLASS = 0x00008000;

// File access types
const FILE_READ_DATA = 0x0001;

const FILE_LIST_DIRECTORY = 0x0001;

const FILE_WRITE_DATA = 0x0002;

const FILE_ADD_FILE = 0x0002;

const FILE_APPEND_DATA = 0x0004;

const FILE_ADD_SUBDIRECTORY = 0x0004;

const FILE_CREATE_PIPE_INSTANCE = 0x0004;

const FILE_READ_EA = 0x0008;

const FILE_WRITE_EA = 0x0010;

const FILE_EXECUTE = 0x0020;

const FILE_TRAVERSE = 0x0020;

const FILE_DELETE_CHILD = 0x0040;

const FILE_READ_ATTRIBUTES = 0x0080;

const FILE_WRITE_ATTRIBUTES = 0x0100;

const int FILE_ALL_ACCESS = STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x1FF;

const int FILE_GENERIC_READ =
    STANDARD_RIGHTS_READ |
    FILE_READ_DATA |
    FILE_READ_ATTRIBUTES |
    FILE_READ_EA |
    SYNCHRONIZE;

const int FILE_GENERIC_WRITE =
    STANDARD_RIGHTS_WRITE |
    FILE_WRITE_DATA |
    FILE_WRITE_ATTRIBUTES |
    FILE_WRITE_EA |
    FILE_APPEND_DATA |
    SYNCHRONIZE;

const int FILE_GENERIC_EXECUTE =
    STANDARD_RIGHTS_EXECUTE | FILE_READ_ATTRIBUTES | FILE_EXECUTE | SYNCHRONIZE;

const FILE_SHARE_READ = 0x00000001;

const FILE_SHARE_WRITE = 0x00000002;

const FILE_SHARE_DELETE = 0x00000004;

const FILE_ATTRIBUTE_READONLY = 0x00000001;

const FILE_ATTRIBUTE_HIDDEN = 0x00000002;

const FILE_ATTRIBUTE_SYSTEM = 0x00000004;

const FILE_ATTRIBUTE_DIRECTORY = 0x00000010;

const FILE_ATTRIBUTE_ARCHIVE = 0x00000020;

const FILE_ATTRIBUTE_DEVICE = 0x00000040;

const FILE_ATTRIBUTE_NORMAL = 0x00000080;

const FILE_ATTRIBUTE_TEMPORARY = 0x00000100;

const FILE_ATTRIBUTE_SPARSE_FILE = 0x00000200;

const FILE_ATTRIBUTE_REPARSE_POINT = 0x00000400;

const FILE_ATTRIBUTE_COMPRESSED = 0x00000800;

const FILE_ATTRIBUTE_OFFLINE = 0x00001000;

const FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = 0x00002000;

const FILE_ATTRIBUTE_ENCRYPTED = 0x00004000;

const FILE_ATTRIBUTE_INTEGRITY_STREAM = 0x00008000;

const FILE_ATTRIBUTE_VIRTUAL = 0x00010000;

const FILE_ATTRIBUTE_NO_SCRUB_DATA = 0x00020000;

const FILE_ATTRIBUTE_EA = 0x00040000;

const FILE_ATTRIBUTE_PINNED = 0x00080000;

const FILE_ATTRIBUTE_UNPINNED = 0x00100000;

const FILE_ATTRIBUTE_RECALL_ON_OPEN = 0x00040000;

const FILE_ATTRIBUTE_RECALL_ON_DATA_ACCESS = 0x00400000;

const TREE_CONNECT_ATTRIBUTE_PRIVACY = 0x00004000;
const TREE_CONNECT_ATTRIBUTE_INTEGRITY = 0x00008000;
const TREE_CONNECT_ATTRIBUTE_GLOBAL = 0x00000004;
const TREE_CONNECT_ATTRIBUTE_PINNED = 0x00000002;

const FILE_ATTRIBUTE_STRICTLY_SEQUENTIAL = 0x20000000;

const FILE_NOTIFY_CHANGE_FILE_NAME = 0x00000001;

const FILE_NOTIFY_CHANGE_DIR_NAME = 0x00000002;

const FILE_NOTIFY_CHANGE_ATTRIBUTES = 0x00000004;

const FILE_NOTIFY_CHANGE_SIZE = 0x00000008;

const FILE_NOTIFY_CHANGE_LAST_WRITE = 0x00000010;

const FILE_NOTIFY_CHANGE_LAST_ACCESS = 0x00000020;

const FILE_NOTIFY_CHANGE_CREATION = 0x00000040;

const FILE_NOTIFY_CHANGE_SECURITY = 0x00000100;

const FILE_ACTION_ADDED = 0x00000001;

const FILE_ACTION_REMOVED = 0x00000002;

const FILE_ACTION_MODIFIED = 0x00000003;

const FILE_ACTION_RENAMED_OLD_NAME = 0x00000004;

const FILE_ACTION_RENAMED_NEW_NAME = 0x00000005;

const MAILSLOT_NO_MESSAGE = -1;
const MAILSLOT_WAIT_FOREVER = -1;

// Task dialog icons.
//
// In the Windows header files, these are defined in the following format:
//   #define TD_WARNING_ICON         MAKEINTRESOURCEW(-1)
final TD_WARNING_ICON = Pointer<Utf16>.fromAddress(0xFFFF);
final TD_ERROR_ICON = Pointer<Utf16>.fromAddress(0xFFFE);
final TD_INFORMATION_ICON = Pointer<Utf16>.fromAddress(0xFFFD);
final TD_SHIELD_ICON = Pointer<Utf16>.fromAddress(0xFFFC);

// MIDI-specific return codes
const _MIDIERR_BASE = 64;
const int MIDIERR_UNPREPARED = _MIDIERR_BASE + 0;
const int MIDIERR_STILLPLAYING = _MIDIERR_BASE + 1;
const int MIDIERR_NOMAP = _MIDIERR_BASE + 2;
const int MIDIERR_NOTREADY = _MIDIERR_BASE + 3;
const int MIDIERR_NODEVICE = _MIDIERR_BASE + 4;
const int MIDIERR_INVALIDSETUP = _MIDIERR_BASE + 5;
const int MIDIERR_BADOPENMODE = _MIDIERR_BASE + 6;
const int MIDIERR_DONT_CONTINUE = _MIDIERR_BASE + 7;
const int MIDIERR_LASTERROR = _MIDIERR_BASE + 7;

// Multimedia constants
const _MMSYSERR_BASE = 0;
const MMSYSERR_NOERROR = 0;
const int MMSYSERR_ERROR = _MMSYSERR_BASE + 1;
const int MMSYSERR_BADDEVICEID = _MMSYSERR_BASE + 2;
const int MMSYSERR_NOTENABLED = _MMSYSERR_BASE + 3;
const int MMSYSERR_ALLOCATED = _MMSYSERR_BASE + 4;
const int MMSYSERR_INVALHANDLE = _MMSYSERR_BASE + 5;
const int MMSYSERR_NODRIVER = _MMSYSERR_BASE + 6;
const int MMSYSERR_NOMEM = _MMSYSERR_BASE + 7;
const int MMSYSERR_NOTSUPPORTED = _MMSYSERR_BASE + 8;
const int MMSYSERR_BADERRNUM = _MMSYSERR_BASE + 9;
const int MMSYSERR_INVALFLAG = _MMSYSERR_BASE + 10;
const int MMSYSERR_INVALPARAM = _MMSYSERR_BASE + 11;
const int MMSYSERR_HANDLEBUSY = _MMSYSERR_BASE + 12;
const int MMSYSERR_INVALIDALIAS = _MMSYSERR_BASE + 13;
const int MMSYSERR_BADDB = _MMSYSERR_BASE + 14;
const int MMSYSERR_KEYNOTFOUND = _MMSYSERR_BASE + 15;
const int MMSYSERR_READERROR = _MMSYSERR_BASE + 16;
const int MMSYSERR_WRITEERROR = _MMSYSERR_BASE + 17;
const int MMSYSERR_DELETEERROR = _MMSYSERR_BASE + 18;
const int MMSYSERR_VALNOTFOUND = _MMSYSERR_BASE + 19;
const int MMSYSERR_NODRIVERCB = _MMSYSERR_BASE + 20;
const int MMSYSERR_MOREDATA = _MMSYSERR_BASE + 21;
const int MMSYSERR_LASTERROR = _MMSYSERR_BASE + 21;

const SHERB_NOCONFIRMATION = 0x00000001;
const SHERB_NOPROGRESSUI = 0x00000002;
const SHERB_NOSOUND = 0x00000004;

// Folder IDs
const FOLDERID_NetworkFolder = '{D20BEEC4-5CA8-4905-AE3B-BF251EA09B53}';
const FOLDERID_ComputerFolder = '{0AC0837C-BBF8-452A-850D-79D08E667CA7}';
const FOLDERID_InternetFolder = '{4D9F7874-4E0C-4904-967B-40B0D20C3E4B}';
const FOLDERID_ControlPanelFolder = '{82A74AEB-AEB4-465C-A014-D097EE346D63}';
const FOLDERID_PrintersFolder = '{76FC4E2D-D6AD-4519-A663-37BD56068185}';
const FOLDERID_SyncManagerFolder = '{43668BF8-C14E-49B2-97C9-747784D784B7}';
const FOLDERID_SyncSetupFolder = '{0F214138-B1D3-4a90-BBA9-27CBC0C5389A}';
const FOLDERID_ConflictFolder = '{4bfefb45-347d-4006-a5be-ac0cb0567192}';
const FOLDERID_SyncResultsFolder = '{289a9a43-be44-4057-a41b-587a76d7e7f9}';
const FOLDERID_RecycleBinFolder = '{B7534046-3ECB-4C18-BE4E-64CD4CB7D6AC}';
const FOLDERID_ConnectionsFolder = '{6F0CD92B-2E97-45D1-88FF-B0D186B8DEDD}';
const FOLDERID_Fonts = '{FD228CB7-AE11-4AE3-864C-16F3910AB8FE}';
const FOLDERID_Desktop = '{B4BFCC3A-DB2C-424C-B029-7FE99A87C641}';
const FOLDERID_Startup = '{B97D20BB-F46A-4C97-BA10-5E3608430854}';
const FOLDERID_Programs = '{A77F5D77-2E2B-44C3-A6A2-ABA601054A51}';
const FOLDERID_StartMenu = '{625B53C3-AB48-4EC1-BA1F-A1EF4146FC19}';
const FOLDERID_Recent = '{AE50C081-EBD2-438A-8655-8A092E34987A}';
const FOLDERID_SendTo = '{8983036C-27C0-404B-8F08-102D10DCFD74}';
const FOLDERID_Documents = '{FDD39AD0-238F-46AF-ADB4-6C85480369C7}';
const FOLDERID_Favorites = '{1777F761-68AD-4D8A-87BD-30B759FA33DD}';
const FOLDERID_NetHood = '{C5ABBF53-E17F-4121-8900-86626FC2C973}';
const FOLDERID_PrintHood = '{9274BD8D-CFD1-41C3-B35E-B13F55A758F4}';
const FOLDERID_Templates = '{A63293E8-664E-48DB-A079-DF759E0509F7}';
const FOLDERID_CommonStartup = '{82A5EA35-D9CD-47C5-9629-E15D2F714E6E}';
const FOLDERID_CommonPrograms = '{0139D44E-6AFE-49F2-8690-3DAFCAE6FFB8}';
const FOLDERID_CommonStartMenu = '{A4115719-D62E-491D-AA7C-E74B8BE3B067}';
const FOLDERID_PublicDesktop = '{C4AA340D-F20F-4863-AFEF-F87EF2E6BA25}';
const FOLDERID_ProgramData = '{62AB5D82-FDC1-4DC3-A9DD-070D1D495D97}';
const FOLDERID_CommonTemplates = '{B94237E7-57AC-4347-9151-B08C6C32D1F7}';
const FOLDERID_PublicDocuments = '{ED4824AF-DCE4-45A8-81E2-FC7965083634}';
const FOLDERID_RoamingAppData = '{3EB685DB-65F9-4CF6-A03A-E3EF65729F3D}';
const FOLDERID_LocalAppData = '{F1B32785-6FBA-4FCF-9D55-7B8E7F157091}';
const FOLDERID_LocalAppDataLow = '{A520A1A4-1780-4FF6-BD18-167343C5AF16}';
const FOLDERID_InternetCache = '{352481E8-33BE-4251-BA85-6007CAEDCF9D}';
const FOLDERID_Cookies = '{2B0F765D-C0E9-4171-908E-08A611B84FF6}';
const FOLDERID_History = '{D9DC8A3B-B784-432E-A781-5A1130A75963}';
const FOLDERID_System = '{1AC14E77-02E7-4E5D-B744-2EB1AE5198B7}';
const FOLDERID_SystemX86 = '{D65231B0-B2F1-4857-A4CE-A8E7C6EA7D27}';
const FOLDERID_Windows = '{F38BF404-1D43-42F2-9305-67DE0B28FC23}';
const FOLDERID_Profile = '{5E6C858F-0E22-4760-9AFE-EA3317B67173}';
const FOLDERID_Pictures = '{33E28130-4E1E-4676-835A-98395C3BC3BB}';
const FOLDERID_ProgramFilesX86 = '{7C5A40EF-A0FB-4BFC-874A-C0F2E0B9FA8E}';
const FOLDERID_ProgramFilesCommonX86 = '{DE974D24-D9C6-4D3E-BF91-F4455120B917}';
const FOLDERID_ProgramFilesX64 = '{6D809377-6AF0-444b-8957-A3773F02200E}';
const FOLDERID_ProgramFilesCommonX64 = '{6365D5A7-0F0D-45e5-87F6-0DA56B6A4F7D}';
const FOLDERID_ProgramFiles = '{905e63b6-c1bf-494e-b29c-65b732d3d21a}';
const FOLDERID_ProgramFilesCommon = '{F7F1ED05-9F6D-47A2-AAAE-29D317C6F066}';
const FOLDERID_UserProgramFiles = '{5cd7aee2-2219-4a67-b85d-6c9ce15660cb}';
const FOLDERID_UserProgramFilesCommon =
    '{bcbd3057-ca5c-4622-b42d-bc56db0ae516}';
const FOLDERID_AdminTools = '{724EF170-A42D-4FEF-9F26-B60E846FBA4F}';
const FOLDERID_CommonAdminTools = '{D0384E7D-BAC3-4797-8F14-CBA229B392B5}';
const FOLDERID_Music = '{4BD8D571-6D19-48D3-BE97-422220080E43}';
const FOLDERID_Videos = '{18989B1D-99B5-455B-841C-AB7C74E4DDFC}';
const FOLDERID_Ringtones = '{C870044B-F49E-4126-A9C3-B52A1FF411E8}';
const FOLDERID_PublicPictures = '{B6EBFB86-6907-413C-9AF7-4FC2ABF07CC5}';
const FOLDERID_PublicMusic = '{3214FAB5-9757-4298-BB61-92A9DEAA44FF}';
const FOLDERID_PublicVideos = '{2400183A-6185-49FB-A2D8-4A392A602BA3}';
const FOLDERID_PublicRingtones = '{E555AB60-153B-4D17-9F04-A5FE99FC15EC}';
const FOLDERID_ResourceDir = '{8AD10C31-2ADB-4296-A8F7-E4701232C972}';
const FOLDERID_LocalizedResourcesDir = '{2A00375E-224C-49DE-B8D1-440DF7EF3DDC}';
const FOLDERID_CommonOEMLinks = '{C1BAE2D0-10DF-4334-BEDD-7AA20B227A9D}';
const FOLDERID_CDBurning = '{9E52AB10-F80D-49DF-ACB8-4330F5687855}';
const FOLDERID_UserProfiles = '{0762D272-C50A-4BB0-A382-697DCD729B80}';
const FOLDERID_Playlists = '{DE92C1C7-837F-4F69-A3BB-86E631204A23}';
const FOLDERID_SamplePlaylists = '{15CA69B3-30EE-49C1-ACE1-6B5EC372AFB5}';
const FOLDERID_SampleMusic = '{B250C668-F57D-4EE1-A63C-290EE7D1AA1F}';
const FOLDERID_SamplePictures = '{C4900540-2379-4C75-844B-64E6FAF8716B}';
const FOLDERID_SampleVideos = '{859EAD94-2E85-48AD-A71A-0969CB56A6CD}';
const FOLDERID_PhotoAlbums = '{69D2CF90-FC33-4FB7-9A0C-EBB0F0FCB43C}';
const FOLDERID_Public = '{DFDF76A2-C82A-4D63-906A-5644AC457385}';
const FOLDERID_ChangeRemovePrograms = '{df7266ac-9274-4867-8d55-3bd661de872d}';
const FOLDERID_AppUpdates = '{a305ce99-f527-492b-8b1a-7e76fa98d6e4}';
const FOLDERID_AddNewPrograms = '{de61d971-5ebc-4f02-a3a9-6c82895e5c04}';
const FOLDERID_Downloads = '{374DE290-123F-4565-9164-39C4925E467B}';
const FOLDERID_PublicDownloads = '{3D644C9B-1FB8-4f30-9B45-F670235F79C0}';
const FOLDERID_SavedSearches = '{7d1d3a04-debb-4115-95cf-2f29da2920da}';
const FOLDERID_QuickLaunch = '{52a4f021-7b75-48a9-9f6b-4b87a210bc8f}';
const FOLDERID_Contacts = '{56784854-C6CB-462b-8169-88E350ACB882}';
const FOLDERID_SidebarParts = '{A75D362E-50FC-4fb7-AC2C-A8BEAA314493}';
const FOLDERID_SidebarDefaultParts = '{7B396E54-9EC5-4300-BE0A-2482EBAE1A26}';
const FOLDERID_PublicGameTasks = '{DEBF2536-E1A8-4c59-B6A2-414586476AEA}';
const FOLDERID_GameTasks = '{054FAE61-4DD8-4787-80B6-090220C4B700}';
const FOLDERID_SavedGames = '{4C5C32FF-BB9D-43b0-B5B4-2D72E54EAAA4}';
const FOLDERID_Games = '{CAC52C1A-B53D-4edc-92D7-6B2E8AC19434}';
const FOLDERID_SEARCH_MAPI = '{98ec0e18-2098-4d44-8644-66979315a281}';
const FOLDERID_SEARCH_CSC = '{ee32e446-31ca-4aba-814f-a5ebd2fd6d5e}';
const FOLDERID_Links = '{bfb9d5e0-c6a9-404c-b2b2-ae6db6af4968}';
const FOLDERID_UsersFiles = '{f3ce0f7c-4901-4acc-8648-d5d44b04ef8f}';
const FOLDERID_UsersLibraries = '{A302545D-DEFF-464b-ABE8-61C8648D939B}';
const FOLDERID_SearchHome = '{190337d1-b8ca-4121-a639-6d472d16972a}';
const FOLDERID_OriginalImages = '{2C36C0AA-5812-4b87-BFD0-4CD0DFB19B39}';
const FOLDERID_DocumentsLibrary = '{7b0db17d-9cd2-4a93-9733-46cc89022e7c}';
const FOLDERID_MusicLibrary = '{2112AB0A-C86A-4ffe-A368-0DE96E47012E}';
const FOLDERID_PicturesLibrary = '{A990AE9F-A03B-4e80-94BC-9912D7504104}';
const FOLDERID_VideosLibrary = '{491E922F-5643-4af4-A7EB-4E7A138D8174}';
const FOLDERID_RecordedTVLibrary = '{1A6FDBA2-F42D-4358-A798-B74D745926C5}';
const FOLDERID_HomeGroup = '{52528A6B-B9E3-4add-B60D-588C2DBA842D}';
const FOLDERID_HomeGroupCurrentUser = '{9B74B6A3-0DFD-4f11-9E78-5F7800F2E772}';
const FOLDERID_DeviceMetadataStore = '{5CE4A5E9-E4EB-479D-B89F-130C02886155}';
const FOLDERID_Libraries = '{1B3EA5DC-B587-4786-B4EF-BD1DC332AEAE}';
const FOLDERID_PublicLibraries = '{48daf80b-e6cf-4f4e-b800-0e69d84ee384}';
const FOLDERID_UserPinned = '{9e3995ab-1f9c-4f13-b827-48b24b6c7174}';
const FOLDERID_ImplicitAppShortcuts = '{bcb5256f-79f6-4cee-b725-dc34e402fd46}';
const FOLDERID_AccountPictures = '{008ca0b1-55b4-4c56-b8a8-4de4b299d3be}';
const FOLDERID_PublicUserTiles = '{0482af6c-08f1-4c34-8c90-e17ec98b1e17}';
const FOLDERID_AppsFolder = '{1e87508d-89c2-42f0-8a7e-645a0f50ca58}';
const FOLDERID_StartMenuAllPrograms = '{F26305EF-6948-40B9-B255-81453D09C785}';
const FOLDERID_CommonStartMenuPlaces = '{A440879F-87A0-4F7D-B700-0207B966194A}';
const FOLDERID_ApplicationShortcuts = '{A3918781-E5F2-4890-B3D9-A7E54332328C}';
const FOLDERID_RoamingTiles = '{00BCFC5A-ED94-4e48-96A1-3F6217F21990}';
const FOLDERID_RoamedTileImages = '{AAA8D5A5-F1D6-4259-BAA8-78E7EF60835E}';
const FOLDERID_Screenshots = '{b7bede81-df94-4682-a7d8-57a52620b86f}';
const FOLDERID_CameraRoll = '{AB5FB87B-7CE2-4F83-915D-550846C9537B}';
const FOLDERID_SkyDrive = '{A52BBA46-E9E1-435f-B3D9-28DAA648C0F6}';
const FOLDERID_OneDrive = '{A52BBA46-E9E1-435f-B3D9-28DAA648C0F6}';
const FOLDERID_SkyDriveDocuments = '{24D89E24-2F19-4534-9DDE-6A6671FBB8FE}';
const FOLDERID_SkyDrivePictures = '{339719B5-8C47-4894-94C2-D8F77ADD44A6}';
const FOLDERID_SkyDriveMusic = '{C3F2459E-80D6-45DC-BFEF-1F769F2BE730}';
const FOLDERID_SkyDriveCameraRoll = '{767E6811-49CB-4273-87C2-20F355E1085B}';
const FOLDERID_SearchHistory = '{0D4C3DB6-03A3-462F-A0E6-08924C41B5D4}';
const FOLDERID_SearchTemplates = '{7E636BFE-DFA9-4D5E-B456-D7B39851D8A9}';
const FOLDERID_CameraRollLibrary = '{2B20DF75-1EDA-4039-8097-38798227D5B7}';
const FOLDERID_SavedPictures = '{3B193882-D3AD-4eab-965A-69829D1FB59F}';
const FOLDERID_SavedPicturesLibrary = '{E25B5812-BE88-4bd9-94B0-29233477B6C3}';
const FOLDERID_RetailDemo = '{12D4C69E-24AD-4923-BE19-31321C43A767}';
const FOLDERID_Device = '{1C2AC1DC-4358-4B6C-9733-AF21156576F0}';
const FOLDERID_DevelopmentFiles = '{DBE8E08E-3053-4BBC-B183-2A7B2B191E59}';
const FOLDERID_Objects3D = '{31C0DD25-9439-4F12-BF41-7FF4EDA38722}';
const FOLDERID_AppCaptures = '{EDC0FE71-98D8-4F4A-B920-C8DC133CB165}';
const FOLDERID_LocalDocuments = '{f42ee2d3-909f-4907-8871-4c22fc0bf756}';
const FOLDERID_LocalPictures = '0ddd015d-b06c-45d5-8c4c-f59713854639 }';
const FOLDERID_LocalVideos = '{35286a68-3c57-41a1-bbb1-0eae73d76c95}';
const FOLDERID_LocalMusic = '{a0c69a99-21c8-4671-8703-7934162fcf1d}';
const FOLDERID_LocalDownloads = '{7d83ee9b-2244-4e70-b1f5-5393042af1e4}';
const FOLDERID_RecordedCalls = '{2f8b40c2-83ed-48ee-b383-a1f157ec6f9a}';
const FOLDERID_AllAppMods = '{7ad67899-66af-43ba-9156-6aad42e6c596}';
const FOLDERID_CurrentAppMods = '{3db40b20-2a30-4dbe-917e-771dd21dd099}';
const FOLDERID_AppDataDesktop = '{B2C5E279-7ADD-439F-B28C-C41FE1BBF672}';
const FOLDERID_AppDataDocuments = '{7BE16610-1F7F-44AC-BFF0-83E15F2FFCA1}';
const FOLDERID_AppDataFavorites = '{7CFBEFBC-DE1F-45AA-B843-A542AC536CC9}';
const FOLDERID_AppDataProgramData = '{559D40A3-A036-40FA-AF61-84CB430A4D34}';

// -----------------------------------------------------------------------------
// Device classes
// -----------------------------------------------------------------------------

const GUID_DEVCLASS_1394 = '{6bdd1fc1-810f-11d0-bec7-08002be2092f}';
const GUID_DEVCLASS_1394DEBUG = '{66f250d6-7801-4a64-b139-eea80a450b24}';
const GUID_DEVCLASS_61883 = '{7ebefbc0-3200-11d2-b4c2-00a0c9697d07}';
const GUID_DEVCLASS_ADAPTER = '{4d36e964-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_APMSUPPORT = '{d45b1c18-c8fa-11d1-9f77-0000f805f530}';
const GUID_DEVCLASS_AVC = '{c06ff265-ae09-48f0-812c-16753d7cba83}';
const GUID_DEVCLASS_BATTERY = '{72631e54-78a4-11d0-bcf7-00aa00b7b32a}';
const GUID_DEVCLASS_BIOMETRIC = '{53d29ef7-377c-4d14-864b-eb3a85769359}';
const GUID_DEVCLASS_BLUETOOTH = '{e0cbf06c-cd8b-4647-bb8a-263b43f0f974}';
const GUID_DEVCLASS_CAMERA = '{ca3e7ab9-b4c3-4ae6-8251-579ef933890f}';
const GUID_DEVCLASS_CDROM = '{4d36e965-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_COMPUTEACCELERATOR =
    '{f01a9d53-3ff6-48d2-9f97-c8a7004be10c}';
const GUID_DEVCLASS_COMPUTER = '{4d36e966-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_DECODER = '{6bdd1fc2-810f-11d0-bec7-08002be2092f}';
const GUID_DEVCLASS_DISKDRIVE = '{4d36e967-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_DISPLAY = '{4d36e968-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_DOT4 = '{48721b56-6795-11d2-b1a8-0080c72e74a2}';
const GUID_DEVCLASS_DOT4PRINT = '{49ce6ac8-6f86-11d2-b1e5-0080c72e74a2}';
const GUID_DEVCLASS_EHSTORAGESILO = '{9da2b80f-f89f-4a49-a5c2-511b085b9e8a}';
const GUID_DEVCLASS_ENUM1394 = '{c459df55-db08-11d1-b009-00a0c9081ff6}';
const GUID_DEVCLASS_EXTENSION = '{e2f84ce7-8efa-411c-aa69-97454ca4cb57}';
const GUID_DEVCLASS_FDC = '{4d36e969-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_FIRMWARE = '{f2e7dd72-6468-4e36-b6f1-6488f42c1b52}';
const GUID_DEVCLASS_FLOPPYDISK = '{4d36e980-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_GPS = '{6bdd1fc3-810f-11d0-bec7-08002be2092f}';
const GUID_DEVCLASS_HDC = '{4d36e96a-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_HIDCLASS = '{745a17a0-74d3-11d0-b6fe-00a0c90f57da}';
const GUID_DEVCLASS_HOLOGRAPHIC = '{d612553d-06b1-49ca-8938-e39ef80eb16f}';
const GUID_DEVCLASS_IMAGE = '{6bdd1fc6-810f-11d0-bec7-08002be2092f}';
const GUID_DEVCLASS_INFINIBAND = '{30ef7132-d858-4a0c-ac24-b9028a5cca3f}';
const GUID_DEVCLASS_INFRARED = '{6bdd1fc5-810f-11d0-bec7-08002be2092f}';
const GUID_DEVCLASS_KEYBOARD = '{4d36e96b-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_LEGACYDRIVER = '{8ecc055d-047f-11d1-a537-0000f8753ed1}';
const GUID_DEVCLASS_MEDIA = '{4d36e96c-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_MEDIUM_CHANGER = '{ce5939ae-ebde-11d0-b181-0000f8753ec4}';
const GUID_DEVCLASS_MEMORY = '{5099944a-f6b9-4057-a056-8c550228544c}';
const GUID_DEVCLASS_MODEM = '{4d36e96d-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_MONITOR = '{4d36e96e-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_MOUSE = '{4d36e96f-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_MTD = '{4d36e970-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_MULTIFUNCTION = '{4d36e971-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_MULTIPORTSERIAL = '{50906cb8-ba12-11d1-bf5d-0000f805f530}';
const GUID_DEVCLASS_NET = '{4d36e972-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_NETCLIENT = '{4d36e973-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_NETDRIVER = '{87ef9ad1-8f70-49ee-b215-ab1fcadcbe3c}';
const GUID_DEVCLASS_NETSERVICE = '{4d36e974-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_NETTRANS = '{4d36e975-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_NETUIO = '{78912bc1-cb8e-4b28-a329-f322ebadbe0f}';
const GUID_DEVCLASS_NODRIVER = '{4d36e976-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_PCMCIA = '{4d36e977-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_PNPPRINTERS = '{4658ee7e-f050-11d1-b6bd-00c04fa372a7}';
const GUID_DEVCLASS_PORTS = '{4d36e978-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_PRINTER = '{4d36e979-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_PRINTERUPGRADE = '{4d36e97a-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_PRINTQUEUE = '{1ed2bbf9-11f0-4084-b21f-ad83a8e6dcdc}';
const GUID_DEVCLASS_PROCESSOR = '{50127dc3-0f36-415e-a6cc-4cb3be910B65}';
const GUID_DEVCLASS_SBP2 = '{d48179be-ec20-11d1-b6b8-00c04fa372a7}';
const GUID_DEVCLASS_SCMDISK = '{53966cb1-4d46-4166-bf23-c522403cd495}';
const GUID_DEVCLASS_SCMVOLUME = '{53ccb149-e543-4c84-b6e0-bce4f6b7e806}';
const GUID_DEVCLASS_SCSIADAPTER = '{4d36e97b-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_SECURITYACCELERATOR =
    '{268c95a1-edfe-11d3-95c3-0010dc4050a5}';
const GUID_DEVCLASS_SENSOR = '{5175d334-c371-4806-b3ba-71fd53c9258d}';
const GUID_DEVCLASS_SIDESHOW = '{997b5d8d-c442-4f2e-baf3-9c8e671e9e21}';
const GUID_DEVCLASS_SMARTCARDREADER = '{50dd5230-ba8a-11d1-bf5d-0000f805f530}';
const GUID_DEVCLASS_SMRDISK = '{53487c23-680f-4585-acc3-1f10d6777e82}';
const GUID_DEVCLASS_SMRVOLUME = '{53b3cf03-8f5a-4788-91b6-d19ed9fcccbf}';
const GUID_DEVCLASS_SOFTWARECOMPONENT =
    '{5c4c3332-344d-483c-8739-259e934c9cc8}';
const GUID_DEVCLASS_SOUND = '{4d36e97c-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_SYSTEM = '{4d36e97d-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_TAPEDRIVE = '{6d807884-7d21-11cf-801c-08002be10318}';
const GUID_DEVCLASS_UNKNOWN = '{4d36e97e-e325-11ce-bfc1-08002be10318}';
const GUID_DEVCLASS_UCM = '{e6f1aa1c-7f3b-4473-b2e8-c97d8ac71d53}';
const GUID_DEVCLASS_USB = '{36fc9e60-c465-11cf-8056-444553540000}';
const GUID_DEVCLASS_VOLUME = '{71a27cdd-812a-11d0-bec7-08002be2092f}';
const GUID_DEVCLASS_VOLUMESNAPSHOT = '{533c5b84-ec70-11d2-9505-00c04f79deaf}';
const GUID_DEVCLASS_WCEUSBS = '{25dbce51-6c8f-4a72-8a6d-b54c2b4fc835}';
const GUID_DEVCLASS_WPD = '{eec5ad98-8080-425f-922a-dabf3de3f69a}';

// -----------------------------------------------------------------------------
// Device interface classes
// -----------------------------------------------------------------------------

const GUID_DEVINTERFACE_BRIGHTNESS = '{FDE5BBA4-B3F9-46FB-BDAA-0728CE3100B4}';
const GUID_DEVINTERFACE_CDCHANGER = '{53F56312-B6BF-11D0-94F2-00A0C91EFB8B}';
const GUID_DEVINTERFACE_CDROM = '{53F56308-B6BF-11D0-94F2-00A0C91EFB8B}';
const GUID_DEVINTERFACE_COMPORT = '{86E0D1E0-8089-11D0-9CE4-08003E301F73}';
const GUID_DEVINTERFACE_DISK = '{53F56307-B6BF-11D0-94F2-00A0C91EFB8B}';
const GUID_DEVINTERFACE_DISPLAY_ADAPTER =
    '{5B45201D-F2F2-4F3B-85BB-30FF1F953599}';
const GUID_DEVINTERFACE_FLOPPY = '{53F56311-B6BF-11D0-94F2-00A0C91EFB8B}';
const GUID_DEVINTERFACE_HID = '{4D1E55B2-F16F-11CF-88CB-001111000030}';
const GUID_DEVINTERFACE_I2C = '{2564AA4F-DDDB-4495-B497-6AD4A84163D7}';
const GUID_DEVINTERFACE_IMAGE = '{6BDD1FC6-810F-11D0-BEC7-08002BE2092F}';
const GUID_DEVINTERFACE_KEYBOARD = '{884B96C3-56EF-11D1-BC8C-00A0C91405DD}';
const GUID_DEVINTERFACE_MEDIUMCHANGER =
    '{53F56310-B6BF-11D0-94F2-00A0C91EFB8B}';
const GUID_DEVINTERFACE_MODEM = '{2C7089AA-2E0E-11D1-B114-00C04FC2AAE4}';
const GUID_DEVINTERFACE_MONITOR = '{E6F07B5F-EE97-4a90-B076-33F57BF4EAA7}';
const GUID_DEVINTERFACE_MOUSE = '{378DE44C-56EF-11D1-BC8C-00A0C91405DD}';
const GUID_DEVINTERFACE_NET = '{CAC88484-7515-4C03-82E6-71A87ABAC361}';
const GUID_DEVINTERFACE_OPM = '{BF4672DE-6B4E-4BE4-A325-68A91EA49C09}';
const GUID_DEVINTERFACE_PARALLEL = '{97F76EF0-F883-11D0-AF1F-0000F800845C}';
const GUID_DEVINTERFACE_PARCLASS = '{811FC6A5-F728-11D0-A537-0000F8753ED1}';
const GUID_DEVINTERFACE_PARTITION = '{53F5630A-B6BF-11D0-94F2-00A0C91EFB8B}';
const GUID_DEVINTERFACE_SERENUM_BUS_ENUMERATOR =
    '{4D36E978-E325-11CE-BFC1-08002BE10318}';
const GUID_DEVINTERFACE_STORAGEPORT = '{2ACCFE60-C130-11D2-B082-00A0C91EFB8B}';
const GUID_DEVINTERFACE_TAPE = '{53F5630B-B6BF-11D0-94F2-00A0C91EFB8B}';
const GUID_DEVINTERFACE_USB_DEVICE = '{A5DCBF10-6530-11D2-901F-00C04FB951ED}';
const GUID_DEVINTERFACE_USB_HOST_CONTROLLER =
    '{3ABF6F2D-71C4-462A-8A92-1E6861E6AF27}';
const GUID_DEVINTERFACE_USB_HUB = '{F18A0E88-C30C-11D0-8815-00A0C906BED8}';
const GUID_DEVINTERFACE_VIDEO_OUTPUT_ARRIVAL =
    '{1AD9E4F0-F88D-4360-BAB9-4C2D55E564CD}';
const GUID_DEVINTERFACE_VOLUME = '{53F5630D-B6BF-11D0-94F2-00A0C91EFB8B}';
const GUID_DEVINTERFACE_WPD = '{6AC27878-A6FA-4155-BA85-F98F491D4F33}';
const GUID_DEVINTERFACE_WPD_PRIVATE = '{BA0C718F-4DED-49B7-BDD3-FABE28661211}';
const GUID_DEVINTERFACE_WRITEONCEDISK =
    '{53F5630C-B6BF-11D0-94F2-00A0C91EFB8B}';

// *** Kernel constants ***

// memory management
const PAGE_GRAPHICS_NOACCESS = 0x0800;

const PAGE_GRAPHICS_READONLY = 0x1000;

const PAGE_GRAPHICS_READWRITE = 0x2000;

const PAGE_GRAPHICS_EXECUTE = 0x4000;

const PAGE_GRAPHICS_EXECUTE_READ = 0x8000;

const PAGE_GRAPHICS_EXECUTE_READWRITE = 0x10000;

const PAGE_GRAPHICS_COHERENT = 0x20000;

const PAGE_REVERT_TO_FILE_MAP = 0x80000000;

// Memory constants
const MEM_ROTATE = 0x00800000;
const MEM_DIFFERENT_IMAGE_BASE_OK = 0x00800000;
const MEM_4MB_PAGES = 0x80000000;
const int MEM_64K_PAGES = MEM_LARGE_PAGES | MEM_PHYSICAL;

// Processor architectures
const PROCESSOR_ARCHITECTURE_INTEL = 0;

const PROCESSOR_ARCHITECTURE_MIPS = 1;

const PROCESSOR_ARCHITECTURE_ALPHA = 2;

const PROCESSOR_ARCHITECTURE_PPC = 3;

const PROCESSOR_ARCHITECTURE_SHX = 4;

const PROCESSOR_ARCHITECTURE_ARM = 5;

const PROCESSOR_ARCHITECTURE_IA64 = 6;

const PROCESSOR_ARCHITECTURE_ALPHA64 = 7;

const PROCESSOR_ARCHITECTURE_MSIL = 8;

const PROCESSOR_ARCHITECTURE_AMD64 = 9;

const PROCESSOR_ARCHITECTURE_IA32_ON_WIN64 = 10;

const PROCESSOR_ARCHITECTURE_NEUTRAL = 11;

const PROCESSOR_ARCHITECTURE_ARM64 = 12;

const PROCESSOR_ARCHITECTURE_ARM32_ON_WIN64 = 13;

const PROCESSOR_ARCHITECTURE_IA32_ON_ARM64 = 14;

const PROCESSOR_ARCHITECTURE_UNKNOWN = 0xFFFF;

// Machine architectures
const IMAGE_FILE_MACHINE_UNKNOWN = 0;

const IMAGE_FILE_MACHINE_TARGET_HOST = 0x0001;

const IMAGE_FILE_MACHINE_I386 = 0x014c;

const IMAGE_FILE_MACHINE_R3000 = 0x0162;

const IMAGE_FILE_MACHINE_R4000 = 0x0166;

const IMAGE_FILE_MACHINE_R10000 = 0x0168;

const IMAGE_FILE_MACHINE_WCEMIPSV2 = 0x0169;

const IMAGE_FILE_MACHINE_ALPHA = 0x0184;

const IMAGE_FILE_MACHINE_SH3 = 0x01a2;

const IMAGE_FILE_MACHINE_SH3DSP = 0x01a3;

const IMAGE_FILE_MACHINE_SH3E = 0x01a4;

const IMAGE_FILE_MACHINE_SH4 = 0x01a6;

const IMAGE_FILE_MACHINE_SH5 = 0x01a8;

const IMAGE_FILE_MACHINE_ARM = 0x01c0;

const IMAGE_FILE_MACHINE_THUMB = 0x01c2;

const IMAGE_FILE_MACHINE_ARMNT = 0x01c4;

const IMAGE_FILE_MACHINE_AM33 = 0x01d3;

const IMAGE_FILE_MACHINE_POWERPC = 0x01F0;

const IMAGE_FILE_MACHINE_POWERPCFP = 0x01f1;

const IMAGE_FILE_MACHINE_IA64 = 0x0200;

const IMAGE_FILE_MACHINE_MIPS16 = 0x0266;

const IMAGE_FILE_MACHINE_ALPHA64 = 0x0284;

const IMAGE_FILE_MACHINE_MIPSFPU = 0x0366;

const IMAGE_FILE_MACHINE_MIPSFPU16 = 0x0466;

const int IMAGE_FILE_MACHINE_AXP64 = IMAGE_FILE_MACHINE_ALPHA64;

const IMAGE_FILE_MACHINE_TRICORE = 0x0520;

const IMAGE_FILE_MACHINE_CEF = 0x0CEF;

const IMAGE_FILE_MACHINE_EBC = 0x0EBC;

const IMAGE_FILE_MACHINE_AMD64 = 0x8664;

const IMAGE_FILE_MACHINE_M32R = 0x9041;

const IMAGE_FILE_MACHINE_ARM64 = 0xAA64;

const IMAGE_FILE_MACHINE_CEE = 0xC0EE;

// DISPID constants
const DISPID_UNKNOWN = -1;
const DISPID_VALUE = 0;
const DISPID_PROPERTYPUT = -3;
const DISPID_NEWENUM = -4;
const DISPID_EVALUATE = -5;
const DISPID_CONSTRUCTOR = -6;
const DISPID_DESTRUCTOR = -7;
const DISPID_COLLECT = -8;

// Bluetooth constants
const BLUETOOTH_MAX_NAME_SIZE = 248;
const BLUETOOTH_MAX_PASSKEY_SIZE = 16;
const int BLUETOOTH_MAX_PASSKEY_BUFFER_SIZE = BLUETOOTH_MAX_PASSKEY_SIZE + 1;
const BLUETOOTH_MAX_SERVICE_NAME_SIZE = 256;
const BLUETOOTH_DEVICE_NAME_SIZE = 256;
const BTH_MAX_PIN_SIZE = 16;
const BTH_LINK_KEY_LENGTH = 16;

/// {@category enum}
@Deprecated('No replacement')
class WBEM_TIMEOUT_TYPE {
  @Deprecated('Use WBEM_NO_WAIT instead')
  static const WBEM_NO_WAIT = 0;

  @Deprecated('Use WBEM_INFINITE instead')
  static const WBEM_INFINITE = 0xffffffff;
}

const WBEM_NO_WAIT = 0;
const WBEM_INFINITE = 0xffffffff;

const PRODUCT_UNDEFINED = 0x00000000;

const PRODUCT_ESSENTIALBUSINESS_SERVER_MGMT = 0x0000003B;

const PRODUCT_ESSENTIALBUSINESS_SERVER_ADDL = 0x0000003C;

const PRODUCT_ESSENTIALBUSINESS_SERVER_MGMTSVC = 0x0000003D;

const PRODUCT_ESSENTIALBUSINESS_SERVER_ADDLSVC = 0x0000003E;

const PRODUCT_SMALLBUSINESS_SERVER_PREMIUM_CORE = 0x0000003F;

const PRODUCT_CLUSTER_SERVER_V = 0x00000040;

const PRODUCT_STARTER_E = 0x00000042;

const PRODUCT_HOME_BASIC_E = 0x00000043;

const PRODUCT_HOME_PREMIUM_E = 0x00000044;

const PRODUCT_PROFESSIONAL_E = 0x00000045;

const PRODUCT_ENTERPRISE_E = 0x00000046;

const PRODUCT_ULTIMATE_E = 0x00000047;

const PRODUCT_ENTERPRISE_EVALUATION = 0x00000048;

const PRODUCT_MULTIPOINT_STANDARD_SERVER = 0x0000004C;

const PRODUCT_MULTIPOINT_PREMIUM_SERVER = 0x0000004D;

const PRODUCT_STANDARD_EVALUATION_SERVER = 0x0000004F;

const PRODUCT_DATACENTER_EVALUATION_SERVER = 0x00000050;

const PRODUCT_ENTERPRISE_N_EVALUATION = 0x00000054;

const PRODUCT_STORAGE_WORKGROUP_EVALUATION_SERVER = 0x0000005F;

const PRODUCT_STORAGE_STANDARD_EVALUATION_SERVER = 0x00000060;

const PRODUCT_CORE_N = 0x00000062;

const PRODUCT_CORE_COUNTRYSPECIFIC = 0x00000063;

const PRODUCT_CORE_SINGLELANGUAGE = 0x00000064;

const PRODUCT_CORE = 0x00000065;

const PRODUCT_PROFESSIONAL_WMC = 0x00000067;

const PRODUCT_EDUCATION = 0x00000079;

const PRODUCT_EDUCATION_N = 0x0000007A;

const PRODUCT_IOTUAP = 0x0000007B;

const PRODUCT_ENTERPRISE_S = 0x0000007D;

const PRODUCT_ENTERPRISE_S_N = 0x0000007E;

const PRODUCT_ENTERPRISE_S_EVALUATION = 0x00000081;

const PRODUCT_ENTERPRISE_S_N_EVALUATION = 0x00000082;

const PRODUCT_DATACENTER_A_SERVER_CORE = 0x00000091;

const PRODUCT_STANDARD_A_SERVER_CORE = 0x00000092;

const PRODUCT_PRO_WORKSTATION = 0x000000A1;

const PRODUCT_PRO_WORKSTATION_N = 0x000000A2;

const PRODUCT_ANDROMEDA = 0x000000B8;

const PRODUCT_XBOX_NATIVEOS = 0x000000C1;

const PRODUCT_ULTIMATE = 0x00000001;

const PRODUCT_HOME_BASIC = 0x00000002;

const PRODUCT_HOME_PREMIUM = 0x00000003;

const PRODUCT_ENTERPRISE = 0x00000004;

const PRODUCT_HOME_BASIC_N = 0x00000005;

const PRODUCT_BUSINESS = 0x00000006;

const PRODUCT_STANDARD_SERVER = 0x00000007;

const PRODUCT_DATACENTER_SERVER = 0x00000008;

const PRODUCT_SMALLBUSINESS_SERVER = 0x00000009;

const PRODUCT_ENTERPRISE_SERVER = 0x0000000A;

const PRODUCT_STARTER = 0x0000000B;

const PRODUCT_DATACENTER_SERVER_CORE = 0x0000000C;

const PRODUCT_STANDARD_SERVER_CORE = 0x0000000D;

const PRODUCT_ENTERPRISE_SERVER_CORE = 0x0000000E;

const PRODUCT_ENTERPRISE_SERVER_IA64 = 0x0000000F;

const PRODUCT_BUSINESS_N = 0x00000010;

const PRODUCT_WEB_SERVER = 0x00000011;

const PRODUCT_CLUSTER_SERVER = 0x00000012;

const PRODUCT_HOME_SERVER = 0x00000013;

const PRODUCT_STORAGE_EXPRESS_SERVER = 0x00000014;

const PRODUCT_STORAGE_STANDARD_SERVER = 0x00000015;

const PRODUCT_STORAGE_WORKGROUP_SERVER = 0x00000016;

const PRODUCT_STORAGE_ENTERPRISE_SERVER = 0x00000017;

const PRODUCT_SERVER_FOR_SMALLBUSINESS = 0x00000018;

const PRODUCT_SMALLBUSINESS_SERVER_PREMIUM = 0x00000019;

const PRODUCT_HOME_PREMIUM_N = 0x0000001A;

const PRODUCT_ENTERPRISE_N = 0x0000001B;

const PRODUCT_ULTIMATE_N = 0x0000001C;

const PRODUCT_WEB_SERVER_CORE = 0x0000001D;

const PRODUCT_MEDIUMBUSINESS_SERVER_MANAGEMENT = 0x0000001E;

const PRODUCT_MEDIUMBUSINESS_SERVER_SECURITY = 0x0000001F;

const PRODUCT_MEDIUMBUSINESS_SERVER_MESSAGING = 0x00000020;

const PRODUCT_SERVER_FOUNDATION = 0x00000021;

const PRODUCT_HOME_PREMIUM_SERVER = 0x00000022;

const PRODUCT_SERVER_FOR_SMALLBUSINESS_V = 0x00000023;

const PRODUCT_STANDARD_SERVER_V = 0x00000024;

const PRODUCT_DATACENTER_SERVER_V = 0x00000025;

const PRODUCT_ENTERPRISE_SERVER_V = 0x00000026;

const PRODUCT_DATACENTER_SERVER_CORE_V = 0x00000027;

const PRODUCT_STANDARD_SERVER_CORE_V = 0x00000028;

const PRODUCT_ENTERPRISE_SERVER_CORE_V = 0x00000029;

const PRODUCT_HYPERV = 0x0000002A;

const PRODUCT_STORAGE_EXPRESS_SERVER_CORE = 0x0000002B;

const PRODUCT_STORAGE_STANDARD_SERVER_CORE = 0x0000002C;

const PRODUCT_STORAGE_WORKGROUP_SERVER_CORE = 0x0000002D;

const PRODUCT_STORAGE_ENTERPRISE_SERVER_CORE = 0x0000002E;

const PRODUCT_STARTER_N = 0x0000002F;

const PRODUCT_PROFESSIONAL = 0x00000030;

const PRODUCT_PROFESSIONAL_N = 0x00000031;

const PRODUCT_SB_SOLUTION_SERVER = 0x00000032;

const PRODUCT_SERVER_FOR_SB_SOLUTIONS = 0x00000033;

const PRODUCT_STANDARD_SERVER_SOLUTIONS = 0x00000034;

const PRODUCT_STANDARD_SERVER_SOLUTIONS_CORE = 0x00000035;

const PRODUCT_SB_SOLUTION_SERVER_EM = 0x00000036;

const PRODUCT_SERVER_FOR_SB_SOLUTIONS_EM = 0x00000037;

const PRODUCT_SOLUTION_EMBEDDEDSERVER = 0x00000038;

const PRODUCT_SOLUTION_EMBEDDEDSERVER_CORE = 0x00000039;
const PRODUCT_PROFESSIONAL_EMBEDDED = 0x0000003A;
const PRODUCT_EMBEDDED_AUTOMOTIVE = 0x00000055;
const PRODUCT_EMBEDDED_INDUSTRY_A = 0x00000056;
const PRODUCT_THINPC = 0x00000057;
const PRODUCT_EMBEDDED_A = 0x00000058;
const PRODUCT_EMBEDDED_INDUSTRY = 0x00000059;
const PRODUCT_EMBEDDED_E = 0x0000005A;
const PRODUCT_EMBEDDED_INDUSTRY_E = 0x0000005B;
const PRODUCT_EMBEDDED_INDUSTRY_A_E = 0x0000005C;
const PRODUCT_CORE_ARM = 0x00000061;
const PRODUCT_EMBEDDED_INDUSTRY_EVAL = 0x00000069;
const PRODUCT_EMBEDDED_INDUSTRY_E_EVAL = 0x0000006A;
const PRODUCT_EMBEDDED_EVAL = 0x0000006B;
const PRODUCT_EMBEDDED_E_EVAL = 0x0000006C;
const PRODUCT_NANO_SERVER = 0x0000006D;
const PRODUCT_CLOUD_STORAGE_SERVER = 0x0000006E;
const PRODUCT_CORE_CONNECTED = 0x0000006F;
const PRODUCT_PROFESSIONAL_STUDENT = 0x00000070;
const PRODUCT_CORE_CONNECTED_N = 0x00000071;
const PRODUCT_PROFESSIONAL_STUDENT_N = 0x00000072;
const PRODUCT_CORE_CONNECTED_SINGLELANGUAGE = 0x00000073;
const PRODUCT_CORE_CONNECTED_COUNTRYSPECIFIC = 0x00000074;
const PRODUCT_CONNECTED_CAR = 0x00000075;
const PRODUCT_INDUSTRY_HANDHELD = 0x00000076;
const PRODUCT_PPI_PRO = 0x00000077;
const PRODUCT_ARM64_SERVER = 0x00000078;
const PRODUCT_CLOUD_HOST_INFRASTRUCTURE_SERVER = 0x0000007C;
const PRODUCT_PROFESSIONAL_S = 0x0000007F;
const PRODUCT_PROFESSIONAL_S_N = 0x00000080;
const PRODUCT_HOLOGRAPHIC = 0x00000087;
const PRODUCT_HOLOGRAPHIC_BUSINESS = 0x00000088;
const PRODUCT_PRO_SINGLE_LANGUAGE = 0x0000008A;
const PRODUCT_PRO_CHINA = 0x0000008B;
const PRODUCT_ENTERPRISE_SUBSCRIPTION = 0x0000008C;
const PRODUCT_ENTERPRISE_SUBSCRIPTION_N = 0x0000008D;
const PRODUCT_DATACENTER_NANO_SERVER = 0x0000008F;
const PRODUCT_STANDARD_NANO_SERVER = 0x00000090;
const PRODUCT_DATACENTER_WS_SERVER_CORE = 0x00000093;
const PRODUCT_STANDARD_WS_SERVER_CORE = 0x00000094;
const PRODUCT_UTILITY_VM = 0x00000095;
const PRODUCT_DATACENTER_EVALUATION_SERVER_CORE = 0x0000009F;
const PRODUCT_STANDARD_EVALUATION_SERVER_CORE = 0x000000A0;
const PRODUCT_PRO_FOR_EDUCATION = 0x000000A4;
const PRODUCT_PRO_FOR_EDUCATION_N = 0x000000A5;
const PRODUCT_AZURE_SERVER_CORE = 0x000000A8;
const PRODUCT_AZURE_NANO_SERVER = 0x000000A9;
const PRODUCT_ENTERPRISEG = 0x000000AB;
const PRODUCT_ENTERPRISEGN = 0x000000AC;
const PRODUCT_SERVERRDSH = 0x000000AF;
const PRODUCT_CLOUD = 0x000000B2;
const PRODUCT_CLOUDN = 0x000000B3;
const PRODUCT_HUBOS = 0x000000B4;
const PRODUCT_ONECOREUPDATEOS = 0x000000B6;
const PRODUCT_CLOUDE = 0x000000B7;
const PRODUCT_IOTOS = 0x000000B9;
const PRODUCT_CLOUDEN = 0x000000BA;
const PRODUCT_IOTEDGEOS = 0x000000BB;
const PRODUCT_IOTENTERPRISE = 0x000000BC;
const PRODUCT_LITE = 0x000000BD;
const PRODUCT_IOTENTERPRISES = 0x000000BF;
const PRODUCT_XBOX_SYSTEMOS = 0x000000C0;
const PRODUCT_XBOX_GAMEOS = 0x000000C2;
const PRODUCT_XBOX_ERAOS = 0x000000C3;
const PRODUCT_XBOX_DURANGOHOSTOS = 0x000000C4;
const PRODUCT_XBOX_SCARLETTHOSTOS = 0x000000C5;
const PRODUCT_UNLICENSED = 0xABCDABCD;

const CRED_PRESERVE_CREDENTIAL_BLOB = 0x1;

const CRED_FLAGS_PROMPT_NOW = 0x2;

const CRED_FLAGS_USERNAME_TARGET = 0x4;

const CRED_TYPE_GENERIC = 0x1;

const CRED_TYPE_DOMAIN_PASSWORD = 0x2;

const CRED_TYPE_DOMAIN_CERTIFICATE = 0x3;

const CRED_TYPE_DOMAIN_VISIBLE_PASSWORD = 0x4;

const CRED_TYPE_GENERIC_CERTIFICATE = 0x5;

const CRED_TYPE_DOMAIN_EXTENDED = 0x6;

const CRED_TYPE_MAXIMUM = 0x7;

const int CRED_TYPE_MAXIMUM_EX = CRED_TYPE_MAXIMUM + 1000;

const CRED_PERSIST_SESSION = 0x1;

const CRED_PERSIST_LOCAL_MACHINE = 0x2;

const CRED_PERSIST_ENTERPRISE = 0x3;

const LIST_MODULES_32BIT = 0x01;

const LIST_MODULES_64BIT = 0x02;

const LIST_MODULES_ALL = 0x03;

const LIST_MODULES_DEFAULT = 0x0;

// -----------------------------------------------------------------------------
// Multimedia constants
// -----------------------------------------------------------------------------
const MCI_OPEN = 0x0803;
const MCI_CLOSE = 0x0804;
const MCI_ESCAPE = 0x0805;
const MCI_PLAY = 0x0806;
const MCI_SEEK = 0x0807;
const MCI_STOP = 0x0808;
const MCI_PAUSE = 0x0809;
const MCI_INFO = 0x080A;
const MCI_GETDEVCAPS = 0x080B;
const MCI_SPIN = 0x080C;
const MCI_SET = 0x080D;
const MCI_STEP = 0x080E;
const MCI_RECORD = 0x080F;
const MCI_SYSINFO = 0x0810;
const MCI_BREAK = 0x0811;
const MCI_SAVE = 0x0813;
const MCI_STATUS = 0x0814;
const MCI_CUE = 0x0830;
const MCI_REALIZE = 0x0840;
const MCI_WINDOW = 0x0841;
const MCI_PUT = 0x0842;
const MCI_WHERE = 0x0843;
const MCI_FREEZE = 0x0844;
const MCI_UNFREEZE = 0x0845;
const MCI_LOAD = 0x0850;
const MCI_CUT = 0x0851;
const MCI_COPY = 0x0852;
const MCI_PASTE = 0x0853;
const MCI_UPDATE = 0x0854;
const MCI_RESUME = 0x0855;
const MCI_DELETE = 0x0856;
const MCI_NOTIFY = 0x00000001;
const MCI_WAIT = 0x00000002;
const MCI_FROM = 0x00000004;
const MCI_TO = 0x00000008;
const MCI_TRACK = 0x00000010;
const MCI_OPEN_SHAREABLE = 0x00000100;
const MCI_OPEN_ELEMENT = 0x00000200;
const MCI_OPEN_ALIAS = 0x00000400;
const MCI_OPEN_ELEMENT_ID = 0x00000800;
const MCI_OPEN_TYPE_ID = 0x00001000;
const MCI_OPEN_TYPE = 0x00002000;
const MCI_SEEK_TO_START = 0x00000100;
const MCI_SEEK_TO_END = 0x00000200;
const MCI_STATUS_ITEM = 0x00000100;
const MCI_STATUS_START = 0x00000200;
const MCI_STATUS_LENGTH = 0x00000001;
const MCI_STATUS_POSITION = 0x00000002;
const MCI_STATUS_NUMBER_OF_TRACKS = 0x00000003;
const MCI_STATUS_MODE = 0x00000004;
const MCI_STATUS_MEDIA_PRESENT = 0x00000005;
const MCI_STATUS_TIME_FORMAT = 0x00000006;
const MCI_STATUS_READY = 0x00000007;
const MCI_STATUS_CURRENT_TRACK = 0x00000008;
const MCI_INFO_PRODUCT = 0x00000100;
const MCI_INFO_FILE = 0x00000200;
const MCI_INFO_MEDIA_UPC = 0x00000400;
const MCI_INFO_MEDIA_IDENTITY = 0x00000800;
const MCI_INFO_NAME = 0x00001000;
const MCI_INFO_COPYRIGHT = 0x00002000;
const MCI_SEQ_STATUS_TEMPO = 0x00004002;
const MCI_SEQ_STATUS_PORT = 0x00004003;
const MCI_SEQ_STATUS_SLAVE = 0x00004007;
const MCI_SEQ_STATUS_MASTER = 0x00004008;
const MCI_SEQ_STATUS_OFFSET = 0x00004009;
const MCI_SEQ_STATUS_DIVTYPE = 0x0000400A;
const MCI_SEQ_STATUS_NAME = 0x0000400B;
const MCI_SEQ_STATUS_COPYRIGHT = 0x0000400C;
const MCIERR_BASE = 256;
const int MCIERR_INVALID_DEVICE_ID = MCIERR_BASE + 1;
const int MCIERR_UNRECOGNIZED_KEYWORD = MCIERR_BASE + 3;
const int MCIERR_UNRECOGNIZED_COMMAND = MCIERR_BASE + 5;
const int MCIERR_HARDWARE = MCIERR_BASE + 6;
const int MCIERR_INVALID_DEVICE_NAME = MCIERR_BASE + 7;
const int MCIERR_OUT_OF_MEMORY = MCIERR_BASE + 8;
const int MCIERR_DEVICE_OPEN = MCIERR_BASE + 9;
const int MCIERR_CANNOT_LOAD_DRIVER = MCIERR_BASE + 10;
const int MCIERR_MISSING_COMMAND_STRING = MCIERR_BASE + 11;
const int MCIERR_PARAM_OVERFLOW = MCIERR_BASE + 12;
const int MCIERR_MISSING_STRING_ARGUMENT = MCIERR_BASE + 13;
const int MCIERR_BAD_INTEGER = MCIERR_BASE + 14;
const int MCIERR_PARSER_INTERNAL = MCIERR_BASE + 15;
const int MCIERR_DRIVER_INTERNAL = MCIERR_BASE + 16;
const int MCIERR_MISSING_PARAMETER = MCIERR_BASE + 17;
const int MCIERR_UNSUPPORTED_FUNCTION = MCIERR_BASE + 18;
const int MCIERR_FILE_NOT_FOUND = MCIERR_BASE + 19;
const int MCIERR_DEVICE_NOT_READY = MCIERR_BASE + 20;
const int MCIERR_INTERNAL = MCIERR_BASE + 21;
const int MCIERR_DRIVER = MCIERR_BASE + 22;
const int MCIERR_CANNOT_USE_ALL = MCIERR_BASE + 23;
const int MCIERR_MULTIPLE = MCIERR_BASE + 24;
const int MCIERR_EXTENSION_NOT_FOUND = MCIERR_BASE + 25;
const int MCIERR_OUTOFRANGE = MCIERR_BASE + 26;
const int MCIERR_FLAGS_NOT_COMPATIBLE = MCIERR_BASE + 28;
const int MCIERR_FILE_NOT_SAVED = MCIERR_BASE + 30;
const int MCIERR_DEVICE_TYPE_REQUIRED = MCIERR_BASE + 31;
const int MCIERR_DEVICE_LOCKED = MCIERR_BASE + 32;
const int MCIERR_DUPLICATE_ALIAS = MCIERR_BASE + 33;
const int MCIERR_BAD_CONSTANT = MCIERR_BASE + 34;
const int MCIERR_MUST_USE_SHAREABLE = MCIERR_BASE + 35;
const int MCIERR_MISSING_DEVICE_NAME = MCIERR_BASE + 36;
const int MCIERR_BAD_TIME_FORMAT = MCIERR_BASE + 37;
const int MCIERR_NO_CLOSING_QUOTE = MCIERR_BASE + 38;
const int MCIERR_DUPLICATE_FLAGS = MCIERR_BASE + 39;
const int MCIERR_INVALID_FILE = MCIERR_BASE + 40;
const int MCIERR_NULL_PARAMETER_BLOCK = MCIERR_BASE + 41;
const int MCIERR_UNNAMED_RESOURCE = MCIERR_BASE + 42;
const int MCIERR_NEW_REQUIRES_ALIAS = MCIERR_BASE + 43;
const int MCIERR_NOTIFY_ON_AUTO_OPEN = MCIERR_BASE + 44;
const int MCIERR_NO_ELEMENT_ALLOWED = MCIERR_BASE + 45;
const int MCIERR_NONAPPLICABLE_FUNCTION = MCIERR_BASE + 46;
const int MCIERR_ILLEGAL_FOR_AUTO_OPEN = MCIERR_BASE + 47;
const int MCIERR_FILENAME_REQUIRED = MCIERR_BASE + 48;
const int MCIERR_EXTRA_CHARACTERS = MCIERR_BASE + 49;
const int MCIERR_DEVICE_NOT_INSTALLED = MCIERR_BASE + 50;
const int MCIERR_GET_CD = MCIERR_BASE + 51;
const int MCIERR_SET_CD = MCIERR_BASE + 52;
const int MCIERR_SET_DRIVE = MCIERR_BASE + 53;
const int MCIERR_DEVICE_LENGTH = MCIERR_BASE + 54;
const int MCIERR_DEVICE_ORD_LENGTH = MCIERR_BASE + 55;
const int MCIERR_NO_INTEGER = MCIERR_BASE + 56;
const int MCIERR_WAVE_OUTPUTSINUSE = MCIERR_BASE + 64;
const int MCIERR_WAVE_SETOUTPUTINUSE = MCIERR_BASE + 65;
const int MCIERR_WAVE_INPUTSINUSE = MCIERR_BASE + 66;
const int MCIERR_WAVE_SETINPUTINUSE = MCIERR_BASE + 67;
const int MCIERR_WAVE_OUTPUTUNSPECIFIED = MCIERR_BASE + 68;
const int MCIERR_WAVE_INPUTUNSPECIFIED = MCIERR_BASE + 69;
const int MCIERR_WAVE_OUTPUTSUNSUITABLE = MCIERR_BASE + 70;
const int MCIERR_WAVE_SETOUTPUTUNSUITABLE = MCIERR_BASE + 71;
const int MCIERR_WAVE_INPUTSUNSUITABLE = MCIERR_BASE + 72;
const int MCIERR_WAVE_SETINPUTUNSUITABLE = MCIERR_BASE + 73;
const int MCIERR_SEQ_DIV_INCOMPATIBLE = MCIERR_BASE + 80;
const int MCIERR_SEQ_PORT_INUSE = MCIERR_BASE + 81;
const int MCIERR_SEQ_PORT_NONEXISTENT = MCIERR_BASE + 82;
const int MCIERR_SEQ_PORT_MAPNODEVICE = MCIERR_BASE + 83;
const int MCIERR_SEQ_PORT_MISCERROR = MCIERR_BASE + 84;
const int MCIERR_SEQ_TIMER = MCIERR_BASE + 85;
const int MCIERR_SEQ_PORTUNSPECIFIED = MCIERR_BASE + 86;
const int MCIERR_SEQ_NOMIDIPRESENT = MCIERR_BASE + 87;
const int MCIERR_NO_WINDOW = MCIERR_BASE + 90;
const int MCIERR_CREATEWINDOW = MCIERR_BASE + 91;
const int MCIERR_FILE_READ = MCIERR_BASE + 92;
const int MCIERR_FILE_WRITE = MCIERR_BASE + 93;
const int MCIERR_NO_IDENTITY = MCIERR_BASE + 94;
const int MCIERR_CUSTOM_DRIVER_BASE = MCIERR_BASE + 256;
const MIDI_MAPPER = -1;

// IOCTL codes

const FILE_DEVICE_CD_ROM = 0x00000002;

const FILE_DEVICE_DISK = 0x00000007;

const FILE_DEVICE_DVD = 0x00000033;

const FILE_DEVICE_TAPE = 0x0000001f;

const FILE_DEVICE_BEEP = 0x00000001;
const FILE_DEVICE_CD_ROM_FILE_SYSTEM = 0x00000003;
const FILE_DEVICE_CONTROLLER = 0x00000004;
const FILE_DEVICE_DATALINK = 0x00000005;
const FILE_DEVICE_DFS = 0x00000006;
const FILE_DEVICE_DISK_FILE_SYSTEM = 0x00000008;
const FILE_DEVICE_FILE_SYSTEM = 0x00000009;
const FILE_DEVICE_INPORT_PORT = 0x0000000a;
const FILE_DEVICE_KEYBOARD = 0x0000000b;
const FILE_DEVICE_MAILSLOT = 0x0000000c;
const FILE_DEVICE_MIDI_IN = 0x0000000d;
const FILE_DEVICE_MIDI_OUT = 0x0000000e;
const FILE_DEVICE_MOUSE = 0x0000000f;
const FILE_DEVICE_MULTI_UNC_PROVIDER = 0x00000010;
const FILE_DEVICE_NAMED_PIPE = 0x00000011;
const FILE_DEVICE_NETWORK = 0x00000012;
const FILE_DEVICE_NETWORK_BROWSER = 0x00000013;
const FILE_DEVICE_NETWORK_FILE_SYSTEM = 0x00000014;
const FILE_DEVICE_NULL = 0x00000015;
const FILE_DEVICE_PARALLEL_PORT = 0x00000016;
const FILE_DEVICE_PHYSICAL_NETCARD = 0x00000017;
const FILE_DEVICE_PRINTER = 0x00000018;
const FILE_DEVICE_SCANNER = 0x00000019;
const FILE_DEVICE_SERIAL_MOUSE_PORT = 0x0000001a;
const FILE_DEVICE_SERIAL_PORT = 0x0000001b;
const FILE_DEVICE_SCREEN = 0x0000001c;
const FILE_DEVICE_SOUND = 0x0000001d;
const FILE_DEVICE_STREAMS = 0x0000001e;
const FILE_DEVICE_TAPE_FILE_SYSTEM = 0x00000020;
const FILE_DEVICE_TRANSPORT = 0x00000021;
const FILE_DEVICE_UNKNOWN = 0x00000022;
const FILE_DEVICE_VIDEO = 0x00000023;
const FILE_DEVICE_VIRTUAL_DISK = 0x00000024;
const FILE_DEVICE_WAVE_IN = 0x00000025;
const FILE_DEVICE_WAVE_OUT = 0x00000026;
const FILE_DEVICE_8042_PORT = 0x00000027;
const FILE_DEVICE_NETWORK_REDIRECTOR = 0x00000028;
const FILE_DEVICE_BATTERY = 0x00000029;
const FILE_DEVICE_BUS_EXTENDER = 0x0000002a;
const FILE_DEVICE_MODEM = 0x0000002b;
const FILE_DEVICE_VDM = 0x0000002c;
const FILE_DEVICE_MASS_STORAGE = 0x0000002d;
const FILE_DEVICE_SMB = 0x0000002e;
const FILE_DEVICE_KS = 0x0000002f;
const FILE_DEVICE_CHANGER = 0x00000030;
const FILE_DEVICE_SMARTCARD = 0x00000031;
const FILE_DEVICE_ACPI = 0x00000032;
const FILE_DEVICE_FULLSCREEN_VIDEO = 0x00000034;
const FILE_DEVICE_DFS_FILE_SYSTEM = 0x00000035;
const FILE_DEVICE_DFS_VOLUME = 0x00000036;
const FILE_DEVICE_SERENUM = 0x00000037;
const FILE_DEVICE_TERMSRV = 0x00000038;
const FILE_DEVICE_KSEC = 0x00000039;
const FILE_DEVICE_FIPS = 0x0000003A;
const FILE_DEVICE_INFINIBAND = 0x0000003B;
const FILE_DEVICE_VMBUS = 0x0000003E;
const FILE_DEVICE_CRYPT_PROVIDER = 0x0000003F;
const FILE_DEVICE_WPD = 0x00000040;
const FILE_DEVICE_BLUETOOTH = 0x00000041;
const FILE_DEVICE_MT_COMPOSITE = 0x00000042;
const FILE_DEVICE_MT_TRANSPORT = 0x00000043;
const FILE_DEVICE_BIOMETRIC = 0x00000044;
const FILE_DEVICE_PMI = 0x00000045;
const FILE_DEVICE_EHSTOR = 0x00000046;
const FILE_DEVICE_DEVAPI = 0x00000047;
const FILE_DEVICE_GPIO = 0x00000048;
const FILE_DEVICE_USBEX = 0x00000049;
const FILE_DEVICE_CONSOLE = 0x00000050;
const FILE_DEVICE_NFP = 0x00000051;
const FILE_DEVICE_SYSENV = 0x00000052;
const FILE_DEVICE_VIRTUAL_BLOCK = 0x00000053;
const FILE_DEVICE_POINT_OF_SERVICE = 0x00000054;
const FILE_DEVICE_STORAGE_REPLICATION = 0x00000055;
const FILE_DEVICE_TRUST_ENV = 0x00000056;
const FILE_DEVICE_UCM = 0x00000057;
const FILE_DEVICE_UCMTCPCI = 0x00000058;
const FILE_DEVICE_PERSISTENT_MEMORY = 0x00000059;
const FILE_DEVICE_NVDIMM = 0x0000005a;
const FILE_DEVICE_HOLOGRAPHIC = 0x0000005b;
const FILE_DEVICE_SDFXHCI = 0x0000005c;
const FILE_DEVICE_UCMUCSI = 0x0000005d;

const METHOD_BUFFERED = 0;
const METHOD_IN_DIRECT = 1;
const METHOD_OUT_DIRECT = 2;
const METHOD_NEITHER = 3;

const FILE_ANY_ACCESS = 0;
const int FILE_SPECIAL_ACCESS = FILE_ANY_ACCESS;
const FILE_READ_ACCESS = 0x0001;
const FILE_WRITE_ACCESS = 0x0002;

const int IOCTL_DISK_BASE = FILE_DEVICE_DISK;
final int IOCTL_DISK_GET_DRIVE_GEOMETRY = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0000,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_DISK_GET_PARTITION_INFO = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0001,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_DISK_SET_PARTITION_INFO = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0002,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_DISK_GET_DRIVE_LAYOUT = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0003,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_DISK_SET_DRIVE_LAYOUT = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0004,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_DISK_VERIFY = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0005,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_DISK_FORMAT_TRACKS = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0006,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_DISK_REASSIGN_BLOCKS = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0007,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_DISK_PERFORMANCE = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0008,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_DISK_IS_WRITABLE = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0009,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_DISK_LOGGING = CTL_CODE(
  IOCTL_DISK_BASE,
  0x000a,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_DISK_FORMAT_TRACKS_EX = CTL_CODE(
  IOCTL_DISK_BASE,
  0x000b,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_DISK_HISTOGRAM_STRUCTURE = CTL_CODE(
  IOCTL_DISK_BASE,
  0x000c,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_DISK_HISTOGRAM_DATA = CTL_CODE(
  IOCTL_DISK_BASE,
  0x000d,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_DISK_HISTOGRAM_RESET = CTL_CODE(
  IOCTL_DISK_BASE,
  0x000e,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_DISK_REQUEST_STRUCTURE = CTL_CODE(
  IOCTL_DISK_BASE,
  0x000f,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_DISK_REQUEST_DATA = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0010,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_DISK_PERFORMANCE_OFF = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0018,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_DISK_CONTROLLER_NUMBER = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0011,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int SMART_GET_VERSION = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0020,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int SMART_SEND_DRIVE_COMMAND = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0021,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int SMART_RCV_DRIVE_DATA = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0022,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_DISK_GET_PARTITION_INFO_EX = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0012,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_DISK_SET_PARTITION_INFO_EX = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0013,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_DISK_GET_DRIVE_LAYOUT_EX = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0014,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_DISK_SET_DRIVE_LAYOUT_EX = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0015,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_DISK_CREATE_DISK = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0016,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_DISK_GET_LENGTH_INFO = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0017,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_DISK_GET_DRIVE_GEOMETRY_EX = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0028,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_DISK_REASSIGN_BLOCKS_EX = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0029,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_DISK_UPDATE_DRIVE_SIZE = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0032,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_DISK_GROW_PARTITION = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0034,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_DISK_GET_CACHE_INFORMATION = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0035,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_DISK_SET_CACHE_INFORMATION = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0036,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int OBSOLETE_DISK_GET_WRITE_CACHE_STATE = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0037,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_DISK_DELETE_DRIVE_LAYOUT = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0040,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_DISK_UPDATE_PROPERTIES = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0050,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_DISK_FORMAT_DRIVE = CTL_CODE(
  IOCTL_DISK_BASE,
  0x00f3,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_DISK_SENSE_DEVICE = CTL_CODE(
  IOCTL_DISK_BASE,
  0x00f8,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_DISK_CHECK_VERIFY = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0200,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_DISK_MEDIA_REMOVAL = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0201,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_DISK_EJECT_MEDIA = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0202,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_DISK_LOAD_MEDIA = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0203,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_DISK_RESERVE = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0204,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_DISK_RELEASE = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0205,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_DISK_FIND_NEW_DEVICES = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0206,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_DISK_GET_MEDIA_TYPES = CTL_CODE(
  IOCTL_DISK_BASE,
  0x0300,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);

const IOCTL_VOLUME_BASE = 0x00000056;

final int IOCTL_VOLUME_GET_VOLUME_DISK_EXTENTS = CTL_CODE(
  IOCTL_VOLUME_BASE,
  0,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);

final int FSCTL_REQUEST_OPLOCK_LEVEL_1 = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  0,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_REQUEST_OPLOCK_LEVEL_2 = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  1,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_REQUEST_BATCH_OPLOCK = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  2,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_OPLOCK_BREAK_ACKNOWLEDGE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  3,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_OPBATCH_ACK_CLOSE_PENDING = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  4,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_OPLOCK_BREAK_NOTIFY = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  5,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_LOCK_VOLUME = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  6,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_UNLOCK_VOLUME = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  7,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_DISMOUNT_VOLUME = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  8,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_IS_VOLUME_MOUNTED = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  10,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_IS_PATHNAME_VALID = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  11,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_MARK_VOLUME_DIRTY = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  12,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_QUERY_RETRIEVAL_POINTERS = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  14,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_GET_COMPRESSION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  15,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SET_COMPRESSION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  16,
  METHOD_BUFFERED,
  FILE_READ_DATA | FILE_WRITE_DATA,
);
final int FSCTL_SET_BOOTLOADER_ACCESSED = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  19,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_MARK_AS_SYSTEM_HIVE = FSCTL_SET_BOOTLOADER_ACCESSED;
final int FSCTL_OPLOCK_BREAK_ACK_NO_2 = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  20,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_INVALIDATE_VOLUMES = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  21,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_QUERY_FAT_BPB = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  22,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_REQUEST_FILTER_OPLOCK = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  23,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_FILESYSTEM_GET_STATISTICS = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  24,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_GET_NTFS_VOLUME_DATA = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  25,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_GET_NTFS_FILE_RECORD = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  26,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_GET_VOLUME_BITMAP = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  27,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_GET_RETRIEVAL_POINTERS = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  28,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_MOVE_FILE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  29,
  METHOD_BUFFERED,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_IS_VOLUME_DIRTY = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  30,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_ALLOW_EXTENDED_DASD_IO = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  32,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_FIND_FILES_BY_SID = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  35,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_SET_OBJECT_ID = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  38,
  METHOD_BUFFERED,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_GET_OBJECT_ID = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  39,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_DELETE_OBJECT_ID = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  40,
  METHOD_BUFFERED,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_SET_REPARSE_POINT = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  41,
  METHOD_BUFFERED,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_GET_REPARSE_POINT = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  42,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_DELETE_REPARSE_POINT = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  43,
  METHOD_BUFFERED,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_ENUM_USN_DATA = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  44,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_SECURITY_ID_CHECK = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  45,
  METHOD_NEITHER,
  FILE_READ_DATA,
);
final int FSCTL_READ_USN_JOURNAL = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  46,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_SET_OBJECT_ID_EXTENDED = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  47,
  METHOD_BUFFERED,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_CREATE_OR_GET_OBJECT_ID = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  48,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SET_SPARSE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  49,
  METHOD_BUFFERED,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_SET_ZERO_DATA = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  50,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_QUERY_ALLOCATED_RANGES = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  51,
  METHOD_NEITHER,
  FILE_READ_DATA,
);
final int FSCTL_ENABLE_UPGRADE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  52,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_SET_ENCRYPTION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  53,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_ENCRYPTION_FSCTL_IO = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  54,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_WRITE_RAW_ENCRYPTED = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  55,
  METHOD_NEITHER,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_READ_RAW_ENCRYPTED = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  56,
  METHOD_NEITHER,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_CREATE_USN_JOURNAL = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  57,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_READ_FILE_USN_DATA = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  58,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_WRITE_USN_CLOSE_RECORD = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  59,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_EXTEND_VOLUME = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  60,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_QUERY_USN_JOURNAL = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  61,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_DELETE_USN_JOURNAL = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  62,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_MARK_HANDLE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  63,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SIS_COPYFILE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  64,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SIS_LINK_FILES = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  65,
  METHOD_BUFFERED,
  FILE_READ_DATA | FILE_WRITE_DATA,
);
final int FSCTL_RECALL_FILE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  69,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_READ_FROM_PLEX = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  71,
  METHOD_OUT_DIRECT,
  FILE_READ_DATA,
);
final int FSCTL_FILE_PREFETCH = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  72,
  METHOD_BUFFERED,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_MAKE_MEDIA_COMPATIBLE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  76,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_SET_DEFECT_MANAGEMENT = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  77,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_QUERY_SPARING_INFO = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  78,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_QUERY_ON_DISK_VOLUME_INFO = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  79,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SET_VOLUME_COMPRESSION_STATE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  80,
  METHOD_BUFFERED,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_TXFS_MODIFY_RM = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  81,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_TXFS_QUERY_RM_INFORMATION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  82,
  METHOD_BUFFERED,
  FILE_READ_DATA,
);
final int FSCTL_TXFS_ROLLFORWARD_REDO = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  84,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_TXFS_ROLLFORWARD_UNDO = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  85,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_TXFS_START_RM = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  86,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_TXFS_SHUTDOWN_RM = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  87,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_TXFS_READ_BACKUP_INFORMATION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  88,
  METHOD_BUFFERED,
  FILE_READ_DATA,
);
final int FSCTL_TXFS_WRITE_BACKUP_INFORMATION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  89,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_TXFS_CREATE_SECONDARY_RM = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  90,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_TXFS_GET_METADATA_INFO = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  91,
  METHOD_BUFFERED,
  FILE_READ_DATA,
);
final int FSCTL_TXFS_GET_TRANSACTED_VERSION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  92,
  METHOD_BUFFERED,
  FILE_READ_DATA,
);
final int FSCTL_TXFS_SAVEPOINT_INFORMATION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  94,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_TXFS_CREATE_MINIVERSION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  95,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_TXFS_TRANSACTION_ACTIVE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  99,
  METHOD_BUFFERED,
  FILE_READ_DATA,
);
final int FSCTL_SET_ZERO_ON_DEALLOCATION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  101,
  METHOD_BUFFERED,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_SET_REPAIR = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  102,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_GET_REPAIR = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  103,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_WAIT_FOR_REPAIR = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  104,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_INITIATE_REPAIR = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  106,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_CSC_INTERNAL = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  107,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_SHRINK_VOLUME = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  108,
  METHOD_BUFFERED,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_SET_SHORT_NAME_BEHAVIOR = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  109,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_DFSR_SET_GHOST_HANDLE_STATE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  110,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_TXFS_LIST_TRANSACTION_LOCKED_FILES = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  120,
  METHOD_BUFFERED,
  FILE_READ_DATA,
);
final int FSCTL_TXFS_LIST_TRANSACTIONS = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  121,
  METHOD_BUFFERED,
  FILE_READ_DATA,
);
final int FSCTL_QUERY_PAGEFILE_ENCRYPTION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  122,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_RESET_VOLUME_ALLOCATION_HINTS = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  123,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_QUERY_DEPENDENT_VOLUME = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  124,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SD_GLOBAL_CHANGE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  125,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_TXFS_READ_BACKUP_INFORMATION2 = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  126,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_LOOKUP_STREAM_FROM_CLUSTER = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  127,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_TXFS_WRITE_BACKUP_INFORMATION2 = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  128,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_FILE_TYPE_NOTIFICATION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  129,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_FILE_LEVEL_TRIM = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  130,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_GET_BOOT_AREA_INFO = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  140,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_GET_RETRIEVAL_POINTER_BASE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  141,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SET_PERSISTENT_VOLUME_STATE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  142,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_QUERY_PERSISTENT_VOLUME_STATE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  143,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_REQUEST_OPLOCK = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  144,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_CSV_TUNNEL_REQUEST = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  145,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_IS_CSV_FILE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  146,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_QUERY_FILE_SYSTEM_RECOGNITION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  147,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_CSV_GET_VOLUME_PATH_NAME = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  148,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_CSV_GET_VOLUME_NAME_FOR_VOLUME_MOUNT_POINT = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  149,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_CSV_GET_VOLUME_PATH_NAMES_FOR_VOLUME_NAME = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  150,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_IS_FILE_ON_CSV_VOLUME = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  151,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_CORRUPTION_HANDLING = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  152,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_OFFLOAD_READ = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  153,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int FSCTL_OFFLOAD_WRITE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  154,
  METHOD_BUFFERED,
  FILE_WRITE_ACCESS,
);
final int FSCTL_CSV_INTERNAL = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  155,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SET_PURGE_FAILURE_MODE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  156,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_QUERY_FILE_LAYOUT = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  157,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_IS_VOLUME_OWNED_BYCSVFS = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  158,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_GET_INTEGRITY_INFORMATION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  159,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SET_INTEGRITY_INFORMATION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  160,
  METHOD_BUFFERED,
  FILE_READ_DATA | FILE_WRITE_DATA,
);
final int FSCTL_QUERY_FILE_REGIONS = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  161,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_RKF_INTERNAL = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  171,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_SCRUB_DATA = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  172,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_REPAIR_COPIES = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  173,
  METHOD_BUFFERED,
  FILE_READ_DATA | FILE_WRITE_DATA,
);
final int FSCTL_DISABLE_LOCAL_BUFFERING = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  174,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_CSV_MGMT_LOCK = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  175,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_CSV_QUERY_DOWN_LEVEL_FILE_SYSTEM_CHARACTERISTICS = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  176,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_ADVANCE_FILE_ID = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  177,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_CSV_SYNC_TUNNEL_REQUEST = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  178,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_CSV_QUERY_VETO_FILE_DIRECT_IO = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  179,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_WRITE_USN_REASON = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  180,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_CSV_CONTROL = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  181,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_GET_REFS_VOLUME_DATA = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  182,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_CSV_H_BREAKING_SYNC_TUNNEL_REQUEST = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  185,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_QUERY_STORAGE_CLASSES = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  187,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_QUERY_REGION_INFO = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  188,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_USN_TRACK_MODIFIED_RANGES = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  189,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_QUERY_SHARED_VIRTUAL_DISK_SUPPORT = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  192,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SVHDX_SYNC_TUNNEL_REQUEST = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  193,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SVHDX_SET_INITIATOR_INFORMATION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  194,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SET_EXTERNAL_BACKING = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  195,
  METHOD_BUFFERED,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_GET_EXTERNAL_BACKING = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  196,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_DELETE_EXTERNAL_BACKING = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  197,
  METHOD_BUFFERED,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_ENUM_EXTERNAL_BACKING = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  198,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_ENUM_OVERLAY = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  199,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_ADD_OVERLAY = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  204,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_REMOVE_OVERLAY = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  205,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_UPDATE_OVERLAY = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  206,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_SHUFFLE_FILE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  208,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int FSCTL_DUPLICATE_EXTENTS_TO_FILE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  209,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_SPARSE_OVERALLOCATE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  211,
  METHOD_BUFFERED,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_STORAGE_QOS_CONTROL = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  212,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_INITIATE_FILE_METADATA_OPTIMIZATION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  215,
  METHOD_BUFFERED,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_QUERY_FILE_METADATA_OPTIMIZATION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  216,
  METHOD_BUFFERED,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_SVHDX_ASYNC_TUNNEL_REQUEST = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  217,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_GET_WOF_VERSION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  218,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_HCS_SYNC_TUNNEL_REQUEST = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  219,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_HCS_ASYNC_TUNNEL_REQUEST = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  220,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_QUERY_EXTENT_READ_CACHE_INFO = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  221,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_QUERY_REFS_VOLUME_COUNTER_INFO = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  222,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_CLEAN_VOLUME_METADATA = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  223,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SET_INTEGRITY_INFORMATION_EX = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  224,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SUSPEND_OVERLAY = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  225,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_VIRTUAL_STORAGE_QUERY_PROPERTY = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  226,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_FILESYSTEM_GET_STATISTICS_EX = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  227,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_QUERY_VOLUME_CONTAINER_STATE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  228,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SET_LAYER_ROOT = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  229,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_QUERY_DIRECT_ACCESS_EXTENTS = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  230,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_NOTIFY_STORAGE_SPACE_ALLOCATION = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  231,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SSDI_STORAGE_REQUEST = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  232,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_QUERY_DIRECT_IMAGE_ORIGINAL_BASE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  233,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_READ_UNPRIVILEGED_USN_JOURNAL = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  234,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_GHOST_FILE_EXTENTS = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  235,
  METHOD_BUFFERED,
  FILE_WRITE_ACCESS,
);
final int FSCTL_QUERY_GHOSTED_FILE_EXTENTS = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  236,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_UNMAP_SPACE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  237,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_HCS_SYNC_NO_WRITE_TUNNEL_REQUEST = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  238,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_STREAMS_QUERY_PARAMETERS = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  241,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_STREAMS_ASSOCIATE_ID = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  242,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_STREAMS_QUERY_ID = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  243,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_GET_RETRIEVAL_POINTERS_AND_REFCOUNT = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  244,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_QUERY_VOLUME_NUMA_INFO = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  245,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_REFS_DEALLOCATE_RANGES = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  246,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_QUERY_REFS_SMR_VOLUME_INFO = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  247,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SET_REFS_SMR_VOLUME_GC_PARAMETERS = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  248,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SET_REFS_FILE_STRICTLY_SEQUENTIAL = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  249,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_DUPLICATE_EXTENTS_TO_FILE_EX = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  250,
  METHOD_BUFFERED,
  FILE_WRITE_DATA,
);
final int FSCTL_QUERY_BAD_RANGES = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  251,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SET_DAX_ALLOC_ALIGNMENT_HINT = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  252,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_DELETE_CORRUPTED_REFS_CONTAINER = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  253,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SCRUB_UNDISCOVERABLE_ID = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  254,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_NOTIFY_DATA_CHANGE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  255,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_START_VIRTUALIZATION_INSTANCE_EX = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  256,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_ENCRYPTION_KEY_CONTROL = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  257,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_VIRTUAL_STORAGE_SET_BEHAVIOR = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  258,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_SET_REPARSE_POINT_EX = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  259,
  METHOD_BUFFERED,
  FILE_SPECIAL_ACCESS,
);
final int FSCTL_REARRANGE_FILE = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  264,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int FSCTL_VIRTUAL_STORAGE_PASSTHROUGH = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  265,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int FSCTL_GET_RETRIEVAL_POINTER_COUNT = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  266,
  METHOD_NEITHER,
  FILE_ANY_ACCESS,
);
final int FSCTL_ENABLE_PER_IO_FLAGS = CTL_CODE(
  FILE_DEVICE_FILE_SYSTEM,
  267,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);

const int IOCTL_STORAGE_BASE = FILE_DEVICE_MASS_STORAGE;

final int IOCTL_STORAGE_CHECK_VERIFY = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0200,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_STORAGE_CHECK_VERIFY2 = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0200,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_MEDIA_REMOVAL = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0201,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_STORAGE_EJECT_MEDIA = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0202,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_STORAGE_LOAD_MEDIA = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0203,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_STORAGE_LOAD_MEDIA2 = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0203,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_RESERVE = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0204,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_STORAGE_RELEASE = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0205,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_STORAGE_FIND_NEW_DEVICES = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0206,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_STORAGE_EJECTION_CONTROL = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0250,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_MCN_CONTROL = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0251,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_GET_MEDIA_TYPES = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0300,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_GET_MEDIA_TYPES_EX = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0301,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_GET_MEDIA_SERIAL_NUMBER = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0304,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_GET_HOTPLUG_INFO = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0305,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_SET_HOTPLUG_INFO = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0306,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_STORAGE_RESET_BUS = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0400,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_STORAGE_RESET_DEVICE = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0401,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_STORAGE_BREAK_RESERVATION = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0405,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_STORAGE_PERSISTENT_RESERVE_IN = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0406,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_STORAGE_PERSISTENT_RESERVE_OUT = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0407,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_STORAGE_GET_DEVICE_NUMBER = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0420,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_GET_DEVICE_NUMBER_EX = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0421,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_PREDICT_FAILURE = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0440,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_FAILURE_PREDICTION_CONFIG = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0441,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_GET_COUNTERS = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x442,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_READ_CAPACITY = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0450,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_STORAGE_GET_DEVICE_TELEMETRY = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0470,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_STORAGE_DEVICE_TELEMETRY_NOTIFY = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0471,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_STORAGE_DEVICE_TELEMETRY_QUERY_CAPS = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0472,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_STORAGE_GET_DEVICE_TELEMETRY_RAW = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0473,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_STORAGE_SET_TEMPERATURE_THRESHOLD = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0480,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_STORAGE_PROTOCOL_COMMAND = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x04F0,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_STORAGE_QUERY_PROPERTY = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0500,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_MANAGE_DATA_SET_ATTRIBUTES = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0501,
  METHOD_BUFFERED,
  FILE_WRITE_ACCESS,
);
final int IOCTL_STORAGE_GET_LB_PROVISIONING_MAP_RESOURCES = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0502,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_STORAGE_SET_PROPERTY = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0503,
  METHOD_BUFFERED,
  FILE_WRITE_ACCESS,
);
final int IOCTL_STORAGE_REINITIALIZE_MEDIA = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0590,
  METHOD_BUFFERED,
  FILE_WRITE_ACCESS,
);
final int IOCTL_STORAGE_GET_BC_PROPERTIES = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0600,
  METHOD_BUFFERED,
  FILE_READ_ACCESS,
);
final int IOCTL_STORAGE_ALLOCATE_BC_STREAM = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0601,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_STORAGE_FREE_BC_STREAM = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0602,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_STORAGE_CHECK_PRIORITY_HINT_SUPPORT = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0620,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_START_DATA_INTEGRITY_CHECK = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0621,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_STORAGE_STOP_DATA_INTEGRITY_CHECK = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0622,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int OBSOLETE_IOCTL_STORAGE_RESET_BUS = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0400,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int OBSOLETE_IOCTL_STORAGE_RESET_DEVICE = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0401,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_STORAGE_FIRMWARE_GET_INFO = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0700,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_FIRMWARE_DOWNLOAD = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0701,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_STORAGE_FIRMWARE_ACTIVATE = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0702,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_STORAGE_ENABLE_IDLE_POWER = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0720,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_GET_IDLE_POWERUP_REASON = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0721,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_POWER_ACTIVE = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0722,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_POWER_IDLE = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0723,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_EVENT_NOTIFICATION = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0724,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_DEVICE_POWER_CAP = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0725,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_RPMB_COMMAND = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0726,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_ATTRIBUTE_MANAGEMENT = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0727,
  METHOD_BUFFERED,
  FILE_READ_ACCESS | FILE_WRITE_ACCESS,
);
final int IOCTL_STORAGE_DIAGNOSTIC = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0728,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_GET_PHYSICAL_ELEMENT_STATUS = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0729,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_REMOVE_ELEMENT_AND_TRUNCATE = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0730,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);
final int IOCTL_STORAGE_GET_DEVICE_INTERNAL_LOG = CTL_CODE(
  IOCTL_STORAGE_BASE,
  0x0731,
  METHOD_BUFFERED,
  FILE_ANY_ACCESS,
);

// -----------------------------------------------------------------------------
// Wave format constants
// -----------------------------------------------------------------------------
const WAVE_FORMAT_UNKNOWN = 0x0000;
const WAVE_FORMAT_PCM = 0x0001;
const WAVE_FORMAT_ADPCM = 0x0002;
const WAVE_FORMAT_IEEE_FLOAT = 0x0003;
const WAVE_FORMAT_EXTENSIBLE = 0xFFFE;

const SC_MANAGER_ALL_ACCESS = 983103;
const SC_MANAGER_CONNECT = 1;
const SC_MANAGER_ENUMERATE_SERVICE = 4;

const SERVICE_ALL_ACCESS = 983551;
const SERVICE_ENUMERATE_DEPENDENTS = 8;
const SERVICE_STOP = 32;
const SERVICE_QUERY_STATUS = 4;
const SERVICE_START = 16;

const SERVICE_CONTROL_STOP = 1;

const DRIVE_UNKNOWN = 0;
const DRIVE_NO_ROOT_DIR = 1;
const DRIVE_REMOVABLE = 2;
const DRIVE_FIXED = 3;
const DRIVE_REMOTE = 4;
const DRIVE_CDROM = 5;
const DRIVE_RAMDISK = 6;

/// {@category enum}
class PROC_THREAD_ATTRIBUTE_NUM {
  @Deprecated('Use ProcThreadAttributeParentProcess instead')
  static const ProcThreadAttributeParentProcess = 0;
  @Deprecated('Use ProcThreadAttributeHandleList instead')
  static const ProcThreadAttributeHandleList = 2;
  @Deprecated('Use ProcThreadAttributeGroupAffinity instead')
  static const ProcThreadAttributeGroupAffinity = 3;
  @Deprecated('Use ProcThreadAttributePreferredNode instead')
  static const ProcThreadAttributePreferredNode = 4;
  @Deprecated('Use ProcThreadAttributeIdealProcessor instead')
  static const ProcThreadAttributeIdealProcessor = 5;
  @Deprecated('Use ProcThreadAttributeUmsThread instead')
  static const ProcThreadAttributeUmsThread = 6;
  @Deprecated('Use ProcThreadAttributeMitigationPolicy instead')
  static const ProcThreadAttributeMitigationPolicy = 7;
  @Deprecated('Use ProcThreadAttributeSecurityCapabilities instead')
  static const ProcThreadAttributeSecurityCapabilities = 9;
  @Deprecated('Use ProcThreadAttributeJobList instead')
  static const ProcThreadAttributeJobList = 13;
  @Deprecated('Use ProcThreadAttributeChildProcessPolicy instead')
  static const ProcThreadAttributeChildProcessPolicy = 14;
  @Deprecated('Use ProcThreadAttributeAllApplicationPackagesPolicy instead')
  static const ProcThreadAttributeAllApplicationPackagesPolicy = 15;
  @Deprecated('Use ProcThreadAttributeWin32kFilter instead')
  static const ProcThreadAttributeWin32kFilter = 16;
  @Deprecated('Use ProcThreadAttributeSafeOpenPromptOriginClaim instead')
  static const ProcThreadAttributeSafeOpenPromptOriginClaim = 17;
  @Deprecated('Use ProcThreadAttributeDesktopAppPolicy instead')
  static const ProcThreadAttributeDesktopAppPolicy = 18;
  @Deprecated('Use ProcThreadAttributePseudoConsole instead')
  static const ProcThreadAttributePseudoConsole = 22;
}

/// {@category enum}
class TASKDIALOG_FLAGS {
  @Deprecated('Use int TDF_ENABLE_HYPERLINKS instead')
  static const TDF_ENABLE_HYPERLINKS = 0x0001;
  @Deprecated('Use int TDF_USE_HICON_MAIN instead')
  static const TDF_USE_HICON_MAIN = 0x0002;
  @Deprecated('Use int TDF_USE_HICON_FOOTER instead')
  static const TDF_USE_HICON_FOOTER = 0x0004;
  @Deprecated('Use int TDF_ALLOW_DIALOG_CANCELLATION instead')
  static const TDF_ALLOW_DIALOG_CANCELLATION = 0x0008;
  @Deprecated('Use int TDF_USE_COMMAND_LINKS instead')
  static const TDF_USE_COMMAND_LINKS = 0x0010;
  @Deprecated('Use int TDF_USE_COMMAND_LINKS_NO_ICON instead')
  static const TDF_USE_COMMAND_LINKS_NO_ICON = 0x0020;
  @Deprecated('Use int TDF_EXPAND_FOOTER_AREA instead')
  static const TDF_EXPAND_FOOTER_AREA = 0x0040;
  @Deprecated('Use int TDF_EXPANDED_BY_DEFAULT instead')
  static const TDF_EXPANDED_BY_DEFAULT = 0x0080;
  @Deprecated('Use int TDF_VERIFICATION_FLAG_CHECKED instead')
  static const TDF_VERIFICATION_FLAG_CHECKED = 0x0100;
  @Deprecated('Use int TDF_SHOW_PROGRESS_BAR instead')
  static const TDF_SHOW_PROGRESS_BAR = 0x0200;
  @Deprecated('Use int TDF_SHOW_MARQUEE_PROGRESS_BAR instead')
  static const TDF_SHOW_MARQUEE_PROGRESS_BAR = 0x0400;
  @Deprecated('Use int TDF_CALLBACK_TIMER instead')
  static const TDF_CALLBACK_TIMER = 0x0800;
  @Deprecated('Use int TDF_POSITION_RELATIVE_TO_WINDOW instead')
  static const TDF_POSITION_RELATIVE_TO_WINDOW = 0x1000;
  @Deprecated('Use int TDF_RTL_LAYOUT instead')
  static const TDF_RTL_LAYOUT = 0x2000;
  @Deprecated('Use int TDF_NO_DEFAULT_RADIO_BUTTON instead')
  static const TDF_NO_DEFAULT_RADIO_BUTTON = 0x4000;
  @Deprecated('Use int TDF_CAN_BE_MINIMIZED instead')
  static const TDF_CAN_BE_MINIMIZED = 0x8000;
  @Deprecated('Use int TDF_NO_SET_FOREGROUND instead')
  static const TDF_NO_SET_FOREGROUND = 0x00010000;
  @Deprecated('Use int TDF_SIZE_TO_CONTENT instead')
  static const TDF_SIZE_TO_CONTENT = 0x01000000;
}

/// {@category enum}
class TASKDIALOG_COMMON_BUTTON_FLAGS {
  @Deprecated('Use int TDCBF_OK_BUTTON instead')
  static const TDCBF_OK_BUTTON = 0x0001;
  @Deprecated('Use int TDCBF_YES_BUTTON instead')
  static const TDCBF_YES_BUTTON = 0x0002;
  @Deprecated('Use int TDCBF_NO_BUTTON instead')
  static const TDCBF_NO_BUTTON = 0x0004;
  @Deprecated('Use int TDCBF_CANCEL_BUTTON instead')
  static const TDCBF_CANCEL_BUTTON = 0x0008;
  @Deprecated('Use int TDCBF_RETRY_BUTTON instead')
  static const TDCBF_RETRY_BUTTON = 0x0010;
  @Deprecated('Use int TDCBF_CLOSE_BUTTON instead')
  static const TDCBF_CLOSE_BUTTON = 0x0020;
}

/// {@category enum}
class THEMESIZE {
  @Deprecated('Use int TS_MIN instead')
  static const TS_MIN = 0;
  @Deprecated('Use int TS_TRUE instead')
  static const TS_TRUE = 1;
  @Deprecated('Use int TS_DRAW instead')
  static const TS_DRAW = 2;
}

/// {@category enum}
class WINDOWPARTS {
  @Deprecated('Use int WP_CAPTION instead')
  static const WP_CAPTION = 1;
  @Deprecated('Use int WP_SMALLCAPTION instead')
  static const WP_SMALLCAPTION = 2;
  @Deprecated('Use int WP_MINCAPTION instead')
  static const WP_MINCAPTION = 3;
  @Deprecated('Use int WP_SMALLMINCAPTION instead')
  static const WP_SMALLMINCAPTION = 4;
  @Deprecated('Use int WP_MAXCAPTION instead')
  static const WP_MAXCAPTION = 5;
  @Deprecated('Use int WP_SMALLMAXCAPTION instead')
  static const WP_SMALLMAXCAPTION = 6;
  @Deprecated('Use int WP_FRAMELEFT instead')
  static const WP_FRAMELEFT = 7;
  @Deprecated('Use int WP_FRAMERIGHT instead')
  static const WP_FRAMERIGHT = 8;
  @Deprecated('Use int WP_FRAMEBOTTOM instead')
  static const WP_FRAMEBOTTOM = 9;
  @Deprecated('Use int WP_SMALLFRAMELEFT instead')
  static const WP_SMALLFRAMELEFT = 10;
  @Deprecated('Use int WP_SMALLFRAMERIGHT instead')
  static const WP_SMALLFRAMERIGHT = 11;
  @Deprecated('Use int WP_SMALLFRAMEBOTTOM instead')
  static const WP_SMALLFRAMEBOTTOM = 12;
  @Deprecated('Use int WP_SYSBUTTON instead')
  static const WP_SYSBUTTON = 13;
  @Deprecated('Use int WP_MDISYSBUTTON instead')
  static const WP_MDISYSBUTTON = 14;
  @Deprecated('Use int WP_MINBUTTON instead')
  static const WP_MINBUTTON = 15;
  @Deprecated('Use int WP_MDIMINBUTTON instead')
  static const WP_MDIMINBUTTON = 16;
  @Deprecated('Use int WP_MAXBUTTON instead')
  static const WP_MAXBUTTON = 17;
  @Deprecated('Use int WP_CLOSEBUTTON instead')
  static const WP_CLOSEBUTTON = 18;
  @Deprecated('Use int WP_SMALLCLOSEBUTTON instead')
  static const WP_SMALLCLOSEBUTTON = 19;
  @Deprecated('Use int WP_MDICLOSEBUTTON instead')
  static const WP_MDICLOSEBUTTON = 20;
  @Deprecated('Use int WP_RESTOREBUTTON instead')
  static const WP_RESTOREBUTTON = 21;
  @Deprecated('Use int WP_MDIRESTOREBUTTON instead')
  static const WP_MDIRESTOREBUTTON = 22;
  @Deprecated('Use int WP_HELPBUTTON instead')
  static const WP_HELPBUTTON = 23;
  @Deprecated('Use int WP_MDIHELPBUTTON instead')
  static const WP_MDIHELPBUTTON = 24;
  @Deprecated('Use int WP_HORZSCROLL instead')
  static const WP_HORZSCROLL = 25;
  @Deprecated('Use int WP_HORZTHUMB instead')
  static const WP_HORZTHUMB = 26;
  @Deprecated('Use int WP_VERTSCROLL instead')
  static const WP_VERTSCROLL = 27;
  @Deprecated('Use int WP_VERTTHUMB instead')
  static const WP_VERTTHUMB = 28;
  @Deprecated('Use int WP_DIALOG instead')
  static const WP_DIALOG = 29;
  @Deprecated('Use int WP_CAPTIONSIZINGTEMPLATE instead')
  static const WP_CAPTIONSIZINGTEMPLATE = 30;
  @Deprecated('Use int WP_SMALLCAPTIONSIZINGTEMPLATE instead')
  static const WP_SMALLCAPTIONSIZINGTEMPLATE = 31;
  @Deprecated('Use int WP_FRAMELEFTSIZINGTEMPLATE instead')
  static const WP_FRAMELEFTSIZINGTEMPLATE = 32;
  @Deprecated('Use int WP_SMALLFRAMELEFTSIZINGTEMPLATE instead')
  static const WP_SMALLFRAMELEFTSIZINGTEMPLATE = 33;
  @Deprecated('Use int WP_FRAMERIGHTSIZINGTEMPLATE instead')
  static const WP_FRAMERIGHTSIZINGTEMPLATE = 34;
  @Deprecated('Use int WP_SMALLFRAMERIGHTSIZINGTEMPLATE instead')
  static const WP_SMALLFRAMERIGHTSIZINGTEMPLATE = 35;
  @Deprecated('Use int WP_FRAMEBOTTOMSIZINGTEMPLATE instead')
  static const WP_FRAMEBOTTOMSIZINGTEMPLATE = 36;
  @Deprecated('Use int WP_SMALLFRAMEBOTTOMSIZINGTEMPLATE instead')
  static const WP_SMALLFRAMEBOTTOMSIZINGTEMPLATE = 37;
  @Deprecated('Use int WP_FRAME instead')
  static const WP_FRAME = 38;
  @Deprecated('Use int WP_BORDER instead')
  static const WP_BORDER = 39;
}

/// {@category enum}
class FRAMESTATES {
  @Deprecated('Use int FS_ACTIVE instead')
  static const FS_ACTIVE = 1;
  @Deprecated('Use int FS_INACTIVE instead')
  static const FS_INACTIVE = 2;
}

/// {@category enum}
class CAPTIONSTATES {
  @Deprecated('Use int CS_ACTIVE instead')
  static const CS_ACTIVE = 1;
  @Deprecated('Use int CS_INACTIVE instead')
  static const CS_INACTIVE = 2;
  @Deprecated('Use int CS_DISABLED instead')
  static const CS_DISABLED = 3;
}

/// {@category enum}
class MAXCAPTIONSTATES {
  @Deprecated('Use int MXCS_ACTIVE instead')
  static const MXCS_ACTIVE = 1;
  @Deprecated('Use int MXCS_INACTIVE instead')
  static const MXCS_INACTIVE = 2;
  @Deprecated('Use int MXCS_DISABLED instead')
  static const MXCS_DISABLED = 3;
}

/// {@category enum}
class MINCAPTIONSTATES {
  @Deprecated('Use int MNCS_ACTIVE instead')
  static const MNCS_ACTIVE = 1;
  @Deprecated('Use int MNCS_INACTIVE instead')
  static const MNCS_INACTIVE = 2;
  @Deprecated('Use int MNCS_DISABLED instead')
  static const MNCS_DISABLED = 3;
}

/// {@category enum}
class HORZSCROLLSTATES {
  @Deprecated('Use int HSS_NORMAL instead')
  static const HSS_NORMAL = 1;
  @Deprecated('Use int HSS_HOT instead')
  static const HSS_HOT = 2;
  @Deprecated('Use int HSS_PUSHED instead')
  static const HSS_PUSHED = 3;
  @Deprecated('Use int HSS_DISABLED instead')
  static const HSS_DISABLED = 4;
}

/// {@category enum}
class HORZTHUMBSTATES {
  @Deprecated('Use int HTS_NORMAL instead')
  static const HTS_NORMAL = 1;
  @Deprecated('Use int HTS_HOT instead')
  static const HTS_HOT = 2;
  @Deprecated('Use int HTS_PUSHED instead')
  static const HTS_PUSHED = 3;
  @Deprecated('Use int HTS_DISABLED instead')
  static const HTS_DISABLED = 4;
}

/// {@category enum}
class VERTSCROLLSTATES {
  @Deprecated('Use int VSS_NORMAL instead')
  static const VSS_NORMAL = 1;
  @Deprecated('Use int VSS_HOT instead')
  static const VSS_HOT = 2;
  @Deprecated('Use int VSS_PUSHED instead')
  static const VSS_PUSHED = 3;
  @Deprecated('Use int VSS_DISABLED instead')
  static const VSS_DISABLED = 4;
}

/// {@category enum}
class VERTTHUMBSTATES {
  @Deprecated('Use int VTS_NORMAL instead')
  static const VTS_NORMAL = 1;
  @Deprecated('Use int VTS_HOT instead')
  static const VTS_HOT = 2;
  @Deprecated('Use int VTS_PUSHED instead')
  static const VTS_PUSHED = 3;
  @Deprecated('Use int VTS_DISABLED instead')
  static const VTS_DISABLED = 4;
}

/// {@category enum}
class SYSBUTTONSTATES {
  @Deprecated('Use int SBS_NORMAL instead')
  static const SBS_NORMAL = 1;
  @Deprecated('Use int SBS_HOT instead')
  static const SBS_HOT = 2;
  @Deprecated('Use int SBS_PUSHED instead')
  static const SBS_PUSHED = 3;
  @Deprecated('Use int SBS_DISABLED instead')
  static const SBS_DISABLED = 4;
}

/// {@category enum}
class MINBUTTONSTATES {
  @Deprecated('Use int MINBS_NORMAL instead')
  static const MINBS_NORMAL = 1;
  @Deprecated('Use int MINBS_HOT instead')
  static const MINBS_HOT = 2;
  @Deprecated('Use int MINBS_PUSHED instead')
  static const MINBS_PUSHED = 3;
  @Deprecated('Use int MINBS_DISABLED instead')
  static const MINBS_DISABLED = 4;
}

/// {@category enum}
class MAXBUTTONSTATES {
  @Deprecated('Use int MAXBS_NORMAL instead')
  static const MAXBS_NORMAL = 1;
  @Deprecated('Use int MAXBS_HOT instead')
  static const MAXBS_HOT = 2;
  @Deprecated('Use int MAXBS_PUSHED instead')
  static const MAXBS_PUSHED = 3;
  @Deprecated('Use int MAXBS_DISABLED instead')
  static const MAXBS_DISABLED = 4;
}

/// {@category enum}
class RESTOREBUTTONSTATES {
  @Deprecated('Use int RBS_NORMAL instead')
  static const RBS_NORMAL = 1;
  @Deprecated('Use int RBS_HOT instead')
  static const RBS_HOT = 2;
  @Deprecated('Use int RBS_PUSHED instead')
  static const RBS_PUSHED = 3;
  @Deprecated('Use int RBS_DISABLED instead')
  static const RBS_DISABLED = 4;
}

/// {@category enum}
class HELPBUTTONSTATES {
  @Deprecated('Use int HBS_NORMAL instead')
  static const HBS_NORMAL = 1;
  @Deprecated('Use int HBS_HOT instead')
  static const HBS_HOT = 2;
  @Deprecated('Use int HBS_PUSHED instead')
  static const HBS_PUSHED = 3;
  @Deprecated('Use int HBS_DISABLED instead')
  static const HBS_DISABLED = 4;
}

/// {@category enum}
class CLOSEBUTTONSTATES {
  @Deprecated('Use int CBS_NORMAL instead')
  static const CBS_NORMAL = 1;
  @Deprecated('Use int CBS_HOT instead')
  static const CBS_HOT = 2;
  @Deprecated('Use int CBS_PUSHED instead')
  static const CBS_PUSHED = 3;
  @Deprecated('Use int CBS_DISABLED instead')
  static const CBS_DISABLED = 4;
}

/// {@category enum}
class SMALLCLOSEBUTTONSTATES {
  @Deprecated('Use int SCBS_NORMAL instead')
  static const SCBS_NORMAL = 1;
  @Deprecated('Use int SCBS_HOT instead')
  static const SCBS_HOT = 2;
  @Deprecated('Use int SCBS_PUSHED instead')
  static const SCBS_PUSHED = 3;
  @Deprecated('Use int SCBS_DISABLED instead')
  static const SCBS_DISABLED = 4;
}

/// {@category enum}
class FRAMEBOTTOMSTATES {
  @Deprecated('Use int FRB_ACTIVE instead')
  static const FRB_ACTIVE = 1;
  @Deprecated('Use int FRB_INACTIVE instead')
  static const FRB_INACTIVE = 2;
}

/// {@category enum}
class FRAMELEFTSTATES {
  @Deprecated('Use int FRL_ACTIVE instead')
  static const FRL_ACTIVE = 1;
  @Deprecated('Use int FRL_INACTIVE instead')
  static const FRL_INACTIVE = 2;
}

/// {@category enum}
class FRAMERIGHTSTATES {
  @Deprecated('Use int FRR_ACTIVE instead')
  static const FRR_ACTIVE = 1;
  @Deprecated('Use int FRR_INACTIVE instead')
  static const FRR_INACTIVE = 2;
}

/// {@category enum}
class SMALLCAPTIONSTATES {
  @Deprecated('Use int SCS_ACTIVE instead')
  static const SCS_ACTIVE = 1;
  @Deprecated('Use int SCS_INACTIVE instead')
  static const SCS_INACTIVE = 2;
  @Deprecated('Use int SCS_DISABLED instead')
  static const SCS_DISABLED = 3;
}

/// {@category enum}
class SMALLFRAMEBOTTOMSTATES {
  @Deprecated('Use int SFRB_ACTIVE instead')
  static const SFRB_ACTIVE = 1;
  @Deprecated('Use int SFRB_INACTIVE instead')
  static const SFRB_INACTIVE = 2;
}

/// {@category enum}
class SMALLFRAMELEFTSTATES {
  @Deprecated('Use int SFRL_ACTIVE instead')
  static const SFRL_ACTIVE = 1;
  @Deprecated('Use int SFRL_INACTIVE instead')
  static const SFRL_INACTIVE = 2;
}

/// {@category enum}
class SMALLFRAMERIGHTSTATES {
  @Deprecated('Use int SFRR_ACTIVE instead')
  static const SFRR_ACTIVE = 1;
  @Deprecated('Use int SFRR_INACTIVE instead')
  static const SFRR_INACTIVE = 2;
}

/// {@category enum}
class MDICLOSEBUTTONSTATES {
  @Deprecated('Use int MDCL_NORMAL instead')
  static const MDCL_NORMAL = 1;
  @Deprecated('Use int MDCL_HOT instead')
  static const MDCL_HOT = 2;
  @Deprecated('Use int MDCL_PUSHED instead')
  static const MDCL_PUSHED = 3;
  @Deprecated('Use int MDCL_DISABLED instead')
  static const MDCL_DISABLED = 4;
}

/// {@category enum}
class MDIMINBUTTONSTATES {
  @Deprecated('Use int MDMI_NORMAL instead')
  static const MDMI_NORMAL = 1;
  @Deprecated('Use int MDMI_HOT instead')
  static const MDMI_HOT = 2;
  @Deprecated('Use int MDMI_PUSHED instead')
  static const MDMI_PUSHED = 3;
  @Deprecated('Use int MDMI_DISABLED instead')
  static const MDMI_DISABLED = 4;
}

/// {@category enum}
class MDIRESTOREBUTTONSTATES {
  @Deprecated('Use int MDRE_NORMAL instead')
  static const MDRE_NORMAL = 1;
  @Deprecated('Use int MDRE_HOT instead')
  static const MDRE_HOT = 2;
  @Deprecated('Use int MDRE_PUSHED instead')
  static const MDRE_PUSHED = 3;
  @Deprecated('Use int MDRE_DISABLED instead')
  static const MDRE_DISABLED = 4;
}

/// {@category enum}
class POWER_INFORMATION_LEVEL {
  @Deprecated('Use SystemPowerPolicyAc instead')
  static const SystemPowerPolicyAc = 0;
  @Deprecated('Use SystemPowerPolicyDc instead')
  static const SystemPowerPolicyDc = 1;
  @Deprecated('Use VerifySystemPolicyAc instead')
  static const VerifySystemPolicyAc = 2;
  @Deprecated('Use VerifySystemPolicyDc instead')
  static const VerifySystemPolicyDc = 3;
  @Deprecated('Use SystemPowerCapabilities instead')
  static const SystemPowerCapabilities = 4;
  @Deprecated('Use SystemBatteryState instead')
  static const SystemBatteryState = 5;
  @Deprecated('Use SystemPowerStateHandler instead')
  static const SystemPowerStateHandler = 6;
  @Deprecated('Use ProcessorStateHandler instead')
  static const ProcessorStateHandler = 7;
  @Deprecated('Use SystemPowerPolicyCurrent instead')
  static const SystemPowerPolicyCurrent = 8;
  @Deprecated('Use AdministratorPowerPolicy instead')
  static const AdministratorPowerPolicy = 9;
  @Deprecated('Use SystemReserveHiberFile instead')
  static const SystemReserveHiberFile = 10;
  @Deprecated('Use ProcessorInformation instead')
  static const ProcessorInformation = 11;
  @Deprecated('Use SystemPowerInformation instead')
  static const SystemPowerInformation = 12;
  @Deprecated('Use ProcessorStateHandler2 instead')
  static const ProcessorStateHandler2 = 13;
  @Deprecated('Use LastWakeTime instead')
  static const LastWakeTime = 14;
  @Deprecated('Use LastSleepTime instead')
  static const LastSleepTime = 15;
  @Deprecated('Use SystemExecutionState instead')
  static const SystemExecutionState = 16;
  @Deprecated('Use SystemPowerStateNotifyHandler instead')
  static const SystemPowerStateNotifyHandler = 17;
  @Deprecated('Use ProcessorPowerPolicyAc instead')
  static const ProcessorPowerPolicyAc = 18;
  @Deprecated('Use ProcessorPowerPolicyDc instead')
  static const ProcessorPowerPolicyDc = 19;
  @Deprecated('Use VerifyProcessorPowerPolicyAc instead')
  static const VerifyProcessorPowerPolicyAc = 20;
  @Deprecated('Use VerifyProcessorPowerPolicyDc instead')
  static const VerifyProcessorPowerPolicyDc = 21;
  @Deprecated('Use ProcessorPowerPolicyCurrent instead')
  static const ProcessorPowerPolicyCurrent = 22;
  @Deprecated('Use SystemPowerStateLogging instead')
  static const SystemPowerStateLogging = 23;
  @Deprecated('Use SystemPowerLoggingEntry instead')
  static const SystemPowerLoggingEntry = 24;
  @Deprecated('Use SetPowerSettingValue instead')
  static const SetPowerSettingValue = 25;
  @Deprecated('Use NotifyUserPowerSetting instead')
  static const NotifyUserPowerSetting = 26;
  @Deprecated('Use PowerInformationLevelUnused0 instead')
  static const PowerInformationLevelUnused0 = 27;
  @Deprecated('Use SystemMonitorHiberBootPowerOff instead')
  static const SystemMonitorHiberBootPowerOff = 28;
  @Deprecated('Use SystemVideoState instead')
  static const SystemVideoState = 29;
  @Deprecated('Use TraceApplicationPowerMessage instead')
  static const TraceApplicationPowerMessage = 30;
  @Deprecated('Use TraceApplicationPowerMessageEnd instead')
  static const TraceApplicationPowerMessageEnd = 31;
  @Deprecated('Use ProcessorPerfStates instead')
  static const ProcessorPerfStates = 32;
  @Deprecated('Use ProcessorIdleStates instead')
  static const ProcessorIdleStates = 33;
  @Deprecated('Use ProcessorCap instead')
  static const ProcessorCap = 34;
  @Deprecated('Use SystemWakeSource instead')
  static const SystemWakeSource = 35;
  @Deprecated('Use SystemHiberFileInformation instead')
  static const SystemHiberFileInformation = 36;
  @Deprecated('Use TraceServicePowerMessage instead')
  static const TraceServicePowerMessage = 37;
  @Deprecated('Use ProcessorLoad instead')
  static const ProcessorLoad = 38;
  @Deprecated('Use PowerShutdownNotification instead')
  static const PowerShutdownNotification = 39;
  @Deprecated('Use MonitorCapabilities instead')
  static const MonitorCapabilities = 40;
  @Deprecated('Use SessionPowerInit instead')
  static const SessionPowerInit = 41;
  @Deprecated('Use SessionDisplayState instead')
  static const SessionDisplayState = 42;
  @Deprecated('Use PowerRequestCreate instead')
  static const PowerRequestCreate = 43;
  @Deprecated('Use PowerRequestAction instead')
  static const PowerRequestAction = 44;
  @Deprecated('Use GetPowerRequestList instead')
  static const GetPowerRequestList = 45;
  @Deprecated('Use ProcessorInformationEx instead')
  static const ProcessorInformationEx = 46;
  @Deprecated('Use NotifyUserModeLegacyPowerEvent instead')
  static const NotifyUserModeLegacyPowerEvent = 47;
  @Deprecated('Use GroupPark instead')
  static const GroupPark = 48;
  @Deprecated('Use ProcessorIdleDomains instead')
  static const ProcessorIdleDomains = 49;
  @Deprecated('Use WakeTimerList instead')
  static const WakeTimerList = 50;
  @Deprecated('Use SystemHiberFileSize instead')
  static const SystemHiberFileSize = 51;
  @Deprecated('Use ProcessorIdleStatesHv instead')
  static const ProcessorIdleStatesHv = 52;
  @Deprecated('Use ProcessorPerfStatesHv instead')
  static const ProcessorPerfStatesHv = 53;
  @Deprecated('Use ProcessorPerfCapHv instead')
  static const ProcessorPerfCapHv = 54;
  @Deprecated('Use ProcessorSetIdle instead')
  static const ProcessorSetIdle = 55;
  @Deprecated('Use LogicalProcessorIdling instead')
  static const LogicalProcessorIdling = 56;
  @Deprecated('Use UserPresence instead')
  static const UserPresence = 57;
  @Deprecated('Use PowerSettingNotificationName instead')
  static const PowerSettingNotificationName = 58;
  @Deprecated('Use GetPowerSettingValue instead')
  static const GetPowerSettingValue = 59;
  @Deprecated('Use IdleResiliency instead')
  static const IdleResiliency = 60;
  @Deprecated('Use SessionRITState instead')
  static const SessionRITState = 61;
  @Deprecated('Use SessionConnectNotification instead')
  static const SessionConnectNotification = 62;
  @Deprecated('Use SessionPowerCleanup instead')
  static const SessionPowerCleanup = 63;
  @Deprecated('Use SessionLockState instead')
  static const SessionLockState = 64;
  @Deprecated('Use SystemHiberbootState instead')
  static const SystemHiberbootState = 65;
  @Deprecated('Use PlatformInformation instead')
  static const PlatformInformation = 66;
  @Deprecated('Use PdcInvocation instead')
  static const PdcInvocation = 67;
  @Deprecated('Use MonitorInvocation instead')
  static const MonitorInvocation = 68;
  @Deprecated('Use FirmwareTableInformationRegistered instead')
  static const FirmwareTableInformationRegistered = 69;
  @Deprecated('Use SetShutdownSelectedTime instead')
  static const SetShutdownSelectedTime = 70;
  @Deprecated('Use SuspendResumeInvocation instead')
  static const SuspendResumeInvocation = 71;
  @Deprecated('Use PlmPowerRequestCreate instead')
  static const PlmPowerRequestCreate = 72;
  @Deprecated('Use ScreenOff instead')
  static const ScreenOff = 73;
  @Deprecated('Use CsDeviceNotification instead')
  static const CsDeviceNotification = 74;
  @Deprecated('Use PlatformRole instead')
  static const PlatformRole = 75;
  @Deprecated('Use LastResumePerformance instead')
  static const LastResumePerformance = 76;
  @Deprecated('Use DisplayBurst instead')
  static const DisplayBurst = 77;
  @Deprecated('Use ExitLatencySamplingPercentage instead')
  static const ExitLatencySamplingPercentage = 78;
  @Deprecated('Use RegisterSpmPowerSettings instead')
  static const RegisterSpmPowerSettings = 79;
  @Deprecated('Use PlatformIdleStates instead')
  static const PlatformIdleStates = 80;
  @Deprecated('Use ProcessorIdleVeto instead')
  static const ProcessorIdleVeto = 81;
  @Deprecated('Use PlatformIdleVeto instead')
  static const PlatformIdleVeto = 82;
  @Deprecated('Use SystemBatteryStatePrecise instead')
  static const SystemBatteryStatePrecise = 83;
  @Deprecated('Use ThermalEvent instead')
  static const ThermalEvent = 84;
  @Deprecated('Use PowerRequestActionInternal instead')
  static const PowerRequestActionInternal = 85;
  @Deprecated('Use BatteryDeviceState instead')
  static const BatteryDeviceState = 86;
  @Deprecated('Use PowerInformationInternal instead')
  static const PowerInformationInternal = 87;
  @Deprecated('Use ThermalStandby instead')
  static const ThermalStandby = 88;
  @Deprecated('Use SystemHiberFileType instead')
  static const SystemHiberFileType = 89;
  @Deprecated('Use PhysicalPowerButtonPress instead')
  static const PhysicalPowerButtonPress = 90;
  @Deprecated('Use QueryPotentialDripsConstraint instead')
  static const QueryPotentialDripsConstraint = 91;
  @Deprecated('Use EnergyTrackerCreate instead')
  static const EnergyTrackerCreate = 92;
  @Deprecated('Use EnergyTrackerQuery instead')
  static const EnergyTrackerQuery = 93;
  @Deprecated('Use UpdateBlackBoxRecorder instead')
  static const UpdateBlackBoxRecorder = 94;
  @Deprecated('Use SessionAllowExternalDmaDevices instead')
  static const SessionAllowExternalDmaDevices = 95;
  @Deprecated('Use PowerInformationLevelMaximum instead')
  static const PowerInformationLevelMaximum = 96;
}

/// {@category enum}
class FFFP_MODE {
  @Deprecated('Use FFFP_EXACTMATCH instead')
  static const FFFP_EXACTMATCH = 0;
  @Deprecated('Use FFFP_NEARESTPARENTMATCH instead')
  static const int FFFP_NEARESTPARENTMATCH = FFFP_EXACTMATCH + 1;
}

/// {@category enum}
class FDAP {
  @Deprecated('Use FDAP_BOTTOM instead')
  static const FDAP_BOTTOM = 0;
  @Deprecated('Use FDAP_TOP instead')
  static const FDAP_TOP = 1;
}

/// {@category enum}
class KF_CATEGORY {
  @Deprecated('Use KF_CATEGORY_VIRTUAL instead')
  static const KF_CATEGORY_VIRTUAL = 1;
  @Deprecated('Use KF_CATEGORY_FIXED instead')
  static const KF_CATEGORY_FIXED = 2;
  @Deprecated('Use KF_CATEGORY_COMMON instead')
  static const KF_CATEGORY_COMMON = 3;
  @Deprecated('Use KF_CATEGORY_PERUSER instead')
  static const KF_CATEGORY_PERUSER = 4;
}

/// {@category enum}
class KF_DEFINITION_FLAGS {
  @Deprecated('Use KFDF_LOCAL_REDIRECT_ONLY instead')
  static const KFDF_LOCAL_REDIRECT_ONLY = 0x2;
  @Deprecated('Use KFDF_ROAMABLE instead')
  static const KFDF_ROAMABLE = 0x4;
  @Deprecated('Use KFDF_PRECREATE instead')
  static const KFDF_PRECREATE = 0x8;
  @Deprecated('Use KFDF_STREAM instead')
  static const KFDF_STREAM = 0x10;
  @Deprecated('Use KFDF_PUBLISHEXPANDEDPATH instead')
  static const KFDF_PUBLISHEXPANDEDPATH = 0x20;
  @Deprecated('Use KFDF_NO_REDIRECT_UI instead')
  static const KFDF_NO_REDIRECT_UI = 0x4;
}

/// {@category enum}
class KF_REDIRECT_FLAGS {
  @Deprecated('Use KF_REDIRECT_USER_EXCLUSIVE instead')
  static const KF_REDIRECT_USER_EXCLUSIVE = 0x1;
  @Deprecated('Use KF_REDIRECT_COPY_SOURCE_DACL instead')
  static const KF_REDIRECT_COPY_SOURCE_DACL = 0x2;
  @Deprecated('Use KF_REDIRECT_OWNER_USER instead')
  static const KF_REDIRECT_OWNER_USER = 0x4;
  @Deprecated('Use KF_REDIRECT_SET_OWNER_EXPLICIT instead')
  static const KF_REDIRECT_SET_OWNER_EXPLICIT = 0x8;
  @Deprecated('Use KF_REDIRECT_CHECK_ONLY instead')
  static const KF_REDIRECT_CHECK_ONLY = 0x10;
  @Deprecated('Use KF_REDIRECT_WITH_UI instead')
  static const KF_REDIRECT_WITH_UI = 0x20;
  @Deprecated('Use KF_REDIRECT_UNPIN instead')
  static const KF_REDIRECT_UNPIN = 0x40;
  @Deprecated('Use KF_REDIRECT_PIN instead')
  static const KF_REDIRECT_PIN = 0x80;
  @Deprecated('Use KF_REDIRECT_COPY_CONTENTS instead')
  static const KF_REDIRECT_COPY_CONTENTS = 0x200;
  @Deprecated('Use KF_REDIRECT_DEL_SOURCE_CONTENTS instead')
  static const KF_REDIRECT_DEL_SOURCE_CONTENTS = 0x400;
  @Deprecated('Use KF_REDIRECT_EXCLUDE_ALL_KNOWN_SUBFOLDERS instead')
  static const KF_REDIRECT_EXCLUDE_ALL_KNOWN_SUBFOLDERS = 0x800;
}

/// Specifies a type of computer name.
///
/// {@category enum}
class COMPUTER_NAME_FORMAT {
  @Deprecated('Use ComputerNameNetBIOS instead')
  static const ComputerNameNetBIOS = 0;
  @Deprecated('Use ComputerNameDnsHostname instead')
  static const ComputerNameDnsHostname = 1;
  @Deprecated('Use ComputerNameDnsDomain instead')
  static const ComputerNameDnsDomain = 2;
  @Deprecated('Use ComputerNameDnsFullyQualified instead')
  static const ComputerNameDnsFullyQualified = 3;
  @Deprecated('Use ComputerNamePhysicalNetBIOS instead')
  static const ComputerNamePhysicalNetBIOS = 4;
  @Deprecated('Use ComputerNamePhysicalDnsHostname instead')
  static const ComputerNamePhysicalDnsHostname = 5;
  @Deprecated('Use ComputerNamePhysicalDnsDomain instead')
  static const ComputerNamePhysicalDnsDomain = 6;
  @Deprecated('Use ComputerNamePhysicalDnsFullyQualified instead')
  static const ComputerNamePhysicalDnsFullyQualified = 7;
  @Deprecated('Use ComputerNameMax instead')
  static const ComputerNameMax = 8;
}

/// {@category enum}
class KF_REDIRECTION_CAPABILITIES {
  @Deprecated('Use KF_REDIRECTION_CAPABILITIES_ALLOW_ALL instead')
  static const KF_REDIRECTION_CAPABILITIES_ALLOW_ALL = 0xff;
  @Deprecated('Use KF_REDIRECTION_CAPABILITIES_REDIRECTABLE instead')
  static const KF_REDIRECTION_CAPABILITIES_REDIRECTABLE = 0x1;
  @Deprecated('Use KF_REDIRECTION_CAPABILITIES_DENY_ALL instead')
  static const KF_REDIRECTION_CAPABILITIES_DENY_ALL = 0xfff00;
  @Deprecated('Use KF_REDIRECTION_CAPABILITIES_DENY_POLICY_REDIRECTED instead')
  static const KF_REDIRECTION_CAPABILITIES_DENY_POLICY_REDIRECTED = 0x100;
  @Deprecated('Use KF_REDIRECTION_CAPABILITIES_DENY_POLICY instead')
  static const KF_REDIRECTION_CAPABILITIES_DENY_POLICY = 0x200;
  @Deprecated('Use KF_REDIRECTION_CAPABILITIES_DENY_PERMISSIONS instead')
  static const KF_REDIRECTION_CAPABILITIES_DENY_PERMISSIONS = 0x400;
}

/// {@category enum}
class SIGDN {
  @Deprecated('Use SIGDN_NORMALDISPLAY instead')
  static const SIGDN_NORMALDISPLAY = 0;
  @Deprecated('Use SIGDN_PARENTRELATIVEPARSING instead')
  static const SIGDN_PARENTRELATIVEPARSING = 0x80018001;
  @Deprecated('Use SIGDN_DESKTOPABSOLUTEPARSING instead')
  static const SIGDN_DESKTOPABSOLUTEPARSING = 0x80028000;
  @Deprecated('Use SIGDN_PARENTRELATIVEEDITING instead')
  static const SIGDN_PARENTRELATIVEEDITING = 0x80031001;
  @Deprecated('Use SIGDN_DESKTOPABSOLUTEEDITING instead')
  static const SIGDN_DESKTOPABSOLUTEEDITING = 0x8004c000;
  @Deprecated('Use SIGDN_FILESYSPATH instead')
  static const SIGDN_FILESYSPATH = 0x80058000;
  @Deprecated('Use SIGDN_URL instead')
  static const SIGDN_URL = 0x80068000;
  @Deprecated('Use SIGDN_PARENTRELATIVEFORADDRESSBAR instead')
  static const SIGDN_PARENTRELATIVEFORADDRESSBAR = 0x8007c001;
  @Deprecated('Use SIGDN_PARENTRELATIVE instead')
  static const SIGDN_PARENTRELATIVE = 0x80080001;
  @Deprecated('Use SIGDN_PARENTRELATIVEFORUI instead')
  static const SIGDN_PARENTRELATIVEFORUI = 0x8009400;
}

/// {@category enum}
class EOLE_AUTHENTICATION_CAPABILITIES {
  @Deprecated('Use EOAC_NONE instead')
  static const EOAC_NONE = 0;
  @Deprecated('Use EOAC_MUTUAL_AUTH instead')
  static const EOAC_MUTUAL_AUTH = 0x1;
  @Deprecated('Use EOAC_STATIC_CLOAKING instead')
  static const EOAC_STATIC_CLOAKING = 0x20;
  @Deprecated('Use EOAC_DYNAMIC_CLOAKING instead')
  static const EOAC_DYNAMIC_CLOAKING = 0x40;
  @Deprecated('Use EOAC_ANY_AUTHORITY instead')
  static const EOAC_ANY_AUTHORITY = 0x80;
  @Deprecated('Use EOAC_MAKE_FULLSIC instead')
  static const EOAC_MAKE_FULLSIC = 0x100;
  @Deprecated('Use EOAC_DEFAULT instead')
  static const EOAC_DEFAULT = 0x800;
  @Deprecated('Use EOAC_SECURE_REFS instead')
  static const EOAC_SECURE_REFS = 0x2;
  @Deprecated('Use EOAC_ACCESS_CONTROL instead')
  static const EOAC_ACCESS_CONTROL = 0x4;
  @Deprecated('Use EOAC_APPID instead')
  static const EOAC_APPID = 0x8;
  @Deprecated('Use EOAC_DYNAMIC instead')
  static const EOAC_DYNAMIC = 0x10;
  @Deprecated('Use EOAC_REQUIRE_FULLSIC instead')
  static const EOAC_REQUIRE_FULLSIC = 0x200;
  @Deprecated('Use EOAC_AUTO_IMPERSONATE instead')
  static const EOAC_AUTO_IMPERSONATE = 0x400;
  @Deprecated('Use EOAC_DISABLE_AAA instead')
  static const EOAC_DISABLE_AAA = 0x1000;
  @Deprecated('Use EOAC_NO_CUSTOM_MARSHAL instead')
  static const EOAC_NO_CUSTOM_MARSHAL = 0x2000;
  @Deprecated('Use EOAC_RESERVED1 instead')
  static const EOAC_RESERVED1 = 0x4000;
}

/// {@category enum}
class WBEM_GENERIC_FLAG_TYPE {
  @Deprecated('Use WBEM_FLAG_RETURN_IMMEDIATELY instead')
  static const WBEM_FLAG_RETURN_IMMEDIATELY = 0x10;
  @Deprecated('Use WBEM_FLAG_RETURN_WBEM_COMPLETE instead')
  static const WBEM_FLAG_RETURN_WBEM_COMPLETE = 0;
  @Deprecated('Use WBEM_FLAG_BIDIRECTIONAL instead')
  static const WBEM_FLAG_BIDIRECTIONAL = 0;
  @Deprecated('Use WBEM_FLAG_FORWARD_ONLY instead')
  static const WBEM_FLAG_FORWARD_ONLY = 0x20;
  @Deprecated('Use WBEM_FLAG_NO_ERROR_OBJECT instead')
  static const WBEM_FLAG_NO_ERROR_OBJECT = 0x40;
  @Deprecated('Use WBEM_FLAG_RETURN_ERROR_OBJECT instead')
  static const WBEM_FLAG_RETURN_ERROR_OBJECT = 0;
  @Deprecated('Use WBEM_FLAG_SEND_STATUS instead')
  static const WBEM_FLAG_SEND_STATUS = 0x80;
  @Deprecated('Use WBEM_FLAG_DONT_SEND_STATUS instead')
  static const WBEM_FLAG_DONT_SEND_STATUS = 0;
  @Deprecated('Use WBEM_FLAG_ENSURE_LOCATABLE instead')
  static const WBEM_FLAG_ENSURE_LOCATABLE = 0x100;
  @Deprecated('Use WBEM_FLAG_DIRECT_READ instead')
  static const WBEM_FLAG_DIRECT_READ = 0x200;
  @Deprecated('Use WBEM_FLAG_SEND_ONLY_SELECTED instead')
  static const WBEM_FLAG_SEND_ONLY_SELECTED = 0;
  @Deprecated('Use WBEM_RETURN_WHEN_COMPLETE instead')
  static const WBEM_RETURN_WHEN_COMPLETE = 0;
  @Deprecated('Use WBEM_RETURN_IMMEDIATELY instead')
  static const WBEM_RETURN_IMMEDIATELY = 0x10;
  @Deprecated('Use WBEM_MASK_RESERVED_FLAGS instead')
  static const WBEM_MASK_RESERVED_FLAGS = 0x1f000;
  @Deprecated('Use WBEM_FLAG_USE_AMENDED_QUALIFIERS instead')
  static const WBEM_FLAG_USE_AMENDED_QUALIFIERS = 0x20000;
  @Deprecated('Use WBEM_FLAG_STRONG_VALIDATION instead')
  static const WBEM_FLAG_STRONG_VALIDATION = 0x100000;
}

/// {@category enum}
class WBEM_REFRESHER_FLAGS {
  @Deprecated('Use WBEM_FLAG_REFRESH_AUTO_RECONNECT instead')
  static const WBEM_FLAG_REFRESH_AUTO_RECONNECT = 0;
  @Deprecated('Use WBEM_FLAG_REFRESH_NO_AUTO_RECONNECT instead')
  static const WBEM_FLAG_REFRESH_NO_AUTO_RECONNECT = 1;
}

/// {@category enum}
class NLM_CONNECTIVITY {
  @Deprecated('Use NLM_CONNECTIVITY_DISCONNECTED instead')
  static const NLM_CONNECTIVITY_DISCONNECTED = 0;
  @Deprecated('Use NLM_CONNECTIVITY_IPV4_NOTRAFFIC instead')
  static const NLM_CONNECTIVITY_IPV4_NOTRAFFIC = 0x1;
  @Deprecated('Use NLM_CONNECTIVITY_IPV6_NOTRAFFIC instead')
  static const NLM_CONNECTIVITY_IPV6_NOTRAFFIC = 0x2;
  @Deprecated('Use NLM_CONNECTIVITY_IPV4_SUBNET instead')
  static const NLM_CONNECTIVITY_IPV4_SUBNET = 0x10;
  @Deprecated('Use NLM_CONNECTIVITY_IPV4_LOCALNETWORK instead')
  static const NLM_CONNECTIVITY_IPV4_LOCALNETWORK = 0x20;
  @Deprecated('Use NLM_CONNECTIVITY_IPV4_INTERNET instead')
  static const NLM_CONNECTIVITY_IPV4_INTERNET = 0x40;
  @Deprecated('Use NLM_CONNECTIVITY_IPV6_SUBNET instead')
  static const NLM_CONNECTIVITY_IPV6_SUBNET = 0x100;
  @Deprecated('Use NLM_CONNECTIVITY_IPV6_LOCALNETWORK instead')
  static const NLM_CONNECTIVITY_IPV6_LOCALNETWORK = 0x200;
  @Deprecated('Use NLM_CONNECTIVITY_IPV6_INTERNET instead')
  static const NLM_CONNECTIVITY_IPV6_INTERNET = 0x400;
}

/// {@category enum}
class NLM_ENUM_NETWORK {
  @Deprecated('Use NLM_ENUM_NETWORK_CONNECTED instead')
  static const NLM_ENUM_NETWORK_CONNECTED = 0x1;
  @Deprecated('Use NLM_ENUM_NETWORK_DISCONNECTED instead')
  static const NLM_ENUM_NETWORK_DISCONNECTED = 0x2;
  @Deprecated('Use NLM_ENUM_NETWORK_ALL instead')
  static const NLM_ENUM_NETWORK_ALL = 0x3;
}

const ProcThreadAttributeParentProcess = 0;

const ProcThreadAttributeHandleList = 2;

const ProcThreadAttributeGroupAffinity = 3;

const ProcThreadAttributePreferredNode = 4;

const ProcThreadAttributeIdealProcessor = 5;

const ProcThreadAttributeUmsThread = 6;

const ProcThreadAttributeMitigationPolicy = 7;

const ProcThreadAttributeSecurityCapabilities = 9;

const ProcThreadAttributeJobList = 13;

const ProcThreadAttributeChildProcessPolicy = 14;

const ProcThreadAttributeAllApplicationPackagesPolicy = 15;

const ProcThreadAttributeWin32kFilter = 16;

const ProcThreadAttributeSafeOpenPromptOriginClaim = 17;

const ProcThreadAttributeDesktopAppPolicy = 18;

const ProcThreadAttributePseudoConsole = 22;

const TDF_ENABLE_HYPERLINKS = 0x0001;

const TDF_USE_HICON_MAIN = 0x0002;

const TDF_USE_HICON_FOOTER = 0x0004;

const TDF_ALLOW_DIALOG_CANCELLATION = 0x0008;

const TDF_USE_COMMAND_LINKS = 0x0010;

const TDF_USE_COMMAND_LINKS_NO_ICON = 0x0020;

const TDF_EXPAND_FOOTER_AREA = 0x0040;

const TDF_EXPANDED_BY_DEFAULT = 0x0080;

const TDF_VERIFICATION_FLAG_CHECKED = 0x0100;

const TDF_SHOW_PROGRESS_BAR = 0x0200;

const TDF_SHOW_MARQUEE_PROGRESS_BAR = 0x0400;

const TDF_CALLBACK_TIMER = 0x0800;

const TDF_POSITION_RELATIVE_TO_WINDOW = 0x1000;

const TDF_RTL_LAYOUT = 0x2000;

const TDF_NO_DEFAULT_RADIO_BUTTON = 0x4000;

const TDF_CAN_BE_MINIMIZED = 0x8000;

const TDF_NO_SET_FOREGROUND = 0x00010000;

const TDF_SIZE_TO_CONTENT = 0x01000000;

const TDCBF_OK_BUTTON = 0x0001;

const TDCBF_YES_BUTTON = 0x0002;

const TDCBF_NO_BUTTON = 0x0004;

const TDCBF_CANCEL_BUTTON = 0x0008;

const TDCBF_RETRY_BUTTON = 0x0010;

const TDCBF_CLOSE_BUTTON = 0x0020;

const TS_MIN = 0;

const TS_TRUE = 1;

const TS_DRAW = 2;

const WP_CAPTION = 1;

const WP_SMALLCAPTION = 2;

const WP_MINCAPTION = 3;

const WP_SMALLMINCAPTION = 4;

const WP_MAXCAPTION = 5;

const WP_SMALLMAXCAPTION = 6;

const WP_FRAMELEFT = 7;

const WP_FRAMERIGHT = 8;

const WP_FRAMEBOTTOM = 9;

const WP_SMALLFRAMELEFT = 10;

const WP_SMALLFRAMERIGHT = 11;

const WP_SMALLFRAMEBOTTOM = 12;

const WP_SYSBUTTON = 13;

const WP_MDISYSBUTTON = 14;

const WP_MINBUTTON = 15;

const WP_MDIMINBUTTON = 16;

const WP_MAXBUTTON = 17;

const WP_CLOSEBUTTON = 18;

const WP_SMALLCLOSEBUTTON = 19;

const WP_MDICLOSEBUTTON = 20;

const WP_RESTOREBUTTON = 21;

const WP_MDIRESTOREBUTTON = 22;

const WP_HELPBUTTON = 23;

const WP_MDIHELPBUTTON = 24;

const WP_HORZSCROLL = 25;

const WP_HORZTHUMB = 26;

const WP_VERTSCROLL = 27;

const WP_VERTTHUMB = 28;

const WP_DIALOG = 29;

const WP_CAPTIONSIZINGTEMPLATE = 30;

const WP_SMALLCAPTIONSIZINGTEMPLATE = 31;

const WP_FRAMELEFTSIZINGTEMPLATE = 32;

const WP_SMALLFRAMELEFTSIZINGTEMPLATE = 33;

const WP_FRAMERIGHTSIZINGTEMPLATE = 34;

const WP_SMALLFRAMERIGHTSIZINGTEMPLATE = 35;

const WP_FRAMEBOTTOMSIZINGTEMPLATE = 36;

const WP_SMALLFRAMEBOTTOMSIZINGTEMPLATE = 37;

const WP_FRAME = 38;

const WP_BORDER = 39;

const FS_ACTIVE = 1;

const FS_INACTIVE = 2;

const CS_ACTIVE = 1;

const CS_INACTIVE = 2;

const CS_DISABLED = 3;

const MXCS_ACTIVE = 1;

const MXCS_INACTIVE = 2;

const MXCS_DISABLED = 3;

const MNCS_ACTIVE = 1;

const MNCS_INACTIVE = 2;

const MNCS_DISABLED = 3;

const HSS_NORMAL = 1;

const HSS_HOT = 2;

const HSS_PUSHED = 3;

const HSS_DISABLED = 4;

const HTS_NORMAL = 1;

const HTS_HOT = 2;

const HTS_PUSHED = 3;

const HTS_DISABLED = 4;

const VSS_NORMAL = 1;

const VSS_HOT = 2;

const VSS_PUSHED = 3;

const VSS_DISABLED = 4;

const VTS_NORMAL = 1;

const VTS_HOT = 2;

const VTS_PUSHED = 3;

const VTS_DISABLED = 4;

const SBS_NORMAL = 1;

const SBS_HOT = 2;

const SBS_PUSHED = 3;

const SBS_DISABLED = 4;

const MINBS_NORMAL = 1;

const MINBS_HOT = 2;

const MINBS_PUSHED = 3;

const MINBS_DISABLED = 4;

const MAXBS_NORMAL = 1;

const MAXBS_HOT = 2;

const MAXBS_PUSHED = 3;

const MAXBS_DISABLED = 4;

const RBS_NORMAL = 1;

const RBS_HOT = 2;

const RBS_PUSHED = 3;

const RBS_DISABLED = 4;

const HBS_NORMAL = 1;

const HBS_HOT = 2;

const HBS_PUSHED = 3;

const HBS_DISABLED = 4;

const CBS_NORMAL = 1;

const CBS_HOT = 2;

const CBS_PUSHED = 3;

const CBS_DISABLED = 4;

const SCBS_NORMAL = 1;

const SCBS_HOT = 2;

const SCBS_PUSHED = 3;

const SCBS_DISABLED = 4;

const FRB_ACTIVE = 1;

const FRB_INACTIVE = 2;

const FRL_ACTIVE = 1;

const FRL_INACTIVE = 2;

const FRR_ACTIVE = 1;

const FRR_INACTIVE = 2;

const SCS_ACTIVE = 1;

const SCS_INACTIVE = 2;

const SCS_DISABLED = 3;

const SFRB_ACTIVE = 1;

const SFRB_INACTIVE = 2;

const SFRL_ACTIVE = 1;

const SFRL_INACTIVE = 2;

const SFRR_ACTIVE = 1;

const SFRR_INACTIVE = 2;

const MDCL_NORMAL = 1;

const MDCL_HOT = 2;

const MDCL_PUSHED = 3;

const MDCL_DISABLED = 4;

const MDMI_NORMAL = 1;

const MDMI_HOT = 2;

const MDMI_PUSHED = 3;

const MDMI_DISABLED = 4;

const MDRE_NORMAL = 1;

const MDRE_HOT = 2;

const MDRE_PUSHED = 3;

const MDRE_DISABLED = 4;

const SystemPowerPolicyAc = 0;

const SystemPowerPolicyDc = 1;

const VerifySystemPolicyAc = 2;

const VerifySystemPolicyDc = 3;

const SystemPowerCapabilities = 4;

const SystemBatteryState = 5;

const SystemPowerStateHandler = 6;

const ProcessorStateHandler = 7;

const SystemPowerPolicyCurrent = 8;

const AdministratorPowerPolicy = 9;

const SystemReserveHiberFile = 10;

const ProcessorInformation = 11;

const SystemPowerInformation = 12;

const ProcessorStateHandler2 = 13;

const LastWakeTime = 14;

const LastSleepTime = 15;

const SystemExecutionState = 16;

const SystemPowerStateNotifyHandler = 17;

const ProcessorPowerPolicyAc = 18;

const ProcessorPowerPolicyDc = 19;

const VerifyProcessorPowerPolicyAc = 20;

const VerifyProcessorPowerPolicyDc = 21;

const ProcessorPowerPolicyCurrent = 22;

const SystemPowerStateLogging = 23;

const SystemPowerLoggingEntry = 24;

const SetPowerSettingValue = 25;

const NotifyUserPowerSetting = 26;

const PowerInformationLevelUnused0 = 27;

const SystemMonitorHiberBootPowerOff = 28;

const SystemVideoState = 29;

const TraceApplicationPowerMessage = 30;

const TraceApplicationPowerMessageEnd = 31;

const ProcessorPerfStates = 32;

const ProcessorIdleStates = 33;

const ProcessorCap = 34;

const SystemWakeSource = 35;

const SystemHiberFileInformation = 36;

const TraceServicePowerMessage = 37;

const ProcessorLoad = 38;

const PowerShutdownNotification = 39;

const MonitorCapabilities = 40;

const SessionPowerInit = 41;

const SessionDisplayState = 42;

const PowerRequestCreate = 43;

const PowerRequestAction = 44;

const GetPowerRequestList = 45;

const ProcessorInformationEx = 46;

const NotifyUserModeLegacyPowerEvent = 47;

const GroupPark = 48;

const ProcessorIdleDomains = 49;

const WakeTimerList = 50;

const SystemHiberFileSize = 51;

const ProcessorIdleStatesHv = 52;

const ProcessorPerfStatesHv = 53;

const ProcessorPerfCapHv = 54;

const ProcessorSetIdle = 55;

const LogicalProcessorIdling = 56;

const UserPresence = 57;

const PowerSettingNotificationName = 58;

const GetPowerSettingValue = 59;

const IdleResiliency = 60;

const SessionRITState = 61;

const SessionConnectNotification = 62;

const SessionPowerCleanup = 63;

const SessionLockState = 64;

const SystemHiberbootState = 65;

const PlatformInformation = 66;

const PdcInvocation = 67;

const MonitorInvocation = 68;

const FirmwareTableInformationRegistered = 69;

const SetShutdownSelectedTime = 70;

const SuspendResumeInvocation = 71;

const PlmPowerRequestCreate = 72;

const ScreenOff = 73;

const CsDeviceNotification = 74;

const PlatformRole = 75;

const LastResumePerformance = 76;

const DisplayBurst = 77;

const ExitLatencySamplingPercentage = 78;

const RegisterSpmPowerSettings = 79;

const PlatformIdleStates = 80;

const ProcessorIdleVeto = 81;

const PlatformIdleVeto = 82;

const SystemBatteryStatePrecise = 83;

const ThermalEvent = 84;

const PowerRequestActionInternal = 85;

const BatteryDeviceState = 86;

const PowerInformationInternal = 87;

const ThermalStandby = 88;

const SystemHiberFileType = 89;

const PhysicalPowerButtonPress = 90;

const QueryPotentialDripsConstraint = 91;

const EnergyTrackerCreate = 92;

const EnergyTrackerQuery = 93;

const UpdateBlackBoxRecorder = 94;

const SessionAllowExternalDmaDevices = 95;

const PowerInformationLevelMaximum = 96;

const FFFP_EXACTMATCH = 0;

const int FFFP_NEARESTPARENTMATCH = FFFP_EXACTMATCH + 1;

const FDAP_BOTTOM = 0;

const FDAP_TOP = 1;

const KF_CATEGORY_VIRTUAL = 1;

const KF_CATEGORY_FIXED = 2;

const KF_CATEGORY_COMMON = 3;

const KF_CATEGORY_PERUSER = 4;

const KFDF_LOCAL_REDIRECT_ONLY = 0x2;

const KFDF_ROAMABLE = 0x4;

const KFDF_PRECREATE = 0x8;

const KFDF_STREAM = 0x10;

const KFDF_PUBLISHEXPANDEDPATH = 0x20;

const KFDF_NO_REDIRECT_UI = 0x4;

const KF_REDIRECT_USER_EXCLUSIVE = 0x1;

const KF_REDIRECT_COPY_SOURCE_DACL = 0x2;

const KF_REDIRECT_OWNER_USER = 0x4;

const KF_REDIRECT_SET_OWNER_EXPLICIT = 0x8;

const KF_REDIRECT_CHECK_ONLY = 0x10;

const KF_REDIRECT_WITH_UI = 0x20;

const KF_REDIRECT_UNPIN = 0x40;

const KF_REDIRECT_PIN = 0x80;

const KF_REDIRECT_COPY_CONTENTS = 0x200;

const KF_REDIRECT_DEL_SOURCE_CONTENTS = 0x400;

const KF_REDIRECT_EXCLUDE_ALL_KNOWN_SUBFOLDERS = 0x800;

const ComputerNameNetBIOS = 0;

const ComputerNameDnsHostname = 1;

const ComputerNameDnsDomain = 2;

const ComputerNameDnsFullyQualified = 3;

const ComputerNamePhysicalNetBIOS = 4;

const ComputerNamePhysicalDnsHostname = 5;

const ComputerNamePhysicalDnsDomain = 6;

const ComputerNamePhysicalDnsFullyQualified = 7;

const ComputerNameMax = 8;

const KF_REDIRECTION_CAPABILITIES_ALLOW_ALL = 0xff;

const KF_REDIRECTION_CAPABILITIES_REDIRECTABLE = 0x1;

const KF_REDIRECTION_CAPABILITIES_DENY_ALL = 0xfff00;

const KF_REDIRECTION_CAPABILITIES_DENY_POLICY_REDIRECTED = 0x100;

const KF_REDIRECTION_CAPABILITIES_DENY_POLICY = 0x200;

const KF_REDIRECTION_CAPABILITIES_DENY_PERMISSIONS = 0x400;

const SIGDN_NORMALDISPLAY = 0;

const SIGDN_PARENTRELATIVEPARSING = 0x80018001;

const SIGDN_DESKTOPABSOLUTEPARSING = 0x80028000;

const SIGDN_PARENTRELATIVEEDITING = 0x80031001;

const SIGDN_DESKTOPABSOLUTEEDITING = 0x8004c000;

const SIGDN_FILESYSPATH = 0x80058000;

const SIGDN_URL = 0x80068000;

const SIGDN_PARENTRELATIVEFORADDRESSBAR = 0x8007c001;

const SIGDN_PARENTRELATIVE = 0x80080001;

const SIGDN_PARENTRELATIVEFORUI = 0x8009400;

const EOAC_NONE = 0;

const EOAC_MUTUAL_AUTH = 0x1;

const EOAC_STATIC_CLOAKING = 0x20;

const EOAC_DYNAMIC_CLOAKING = 0x40;

const EOAC_ANY_AUTHORITY = 0x80;

const EOAC_MAKE_FULLSIC = 0x100;

const EOAC_DEFAULT = 0x800;

const EOAC_SECURE_REFS = 0x2;

const EOAC_ACCESS_CONTROL = 0x4;

const EOAC_APPID = 0x8;

const EOAC_DYNAMIC = 0x10;

const EOAC_REQUIRE_FULLSIC = 0x200;

const EOAC_AUTO_IMPERSONATE = 0x400;

const EOAC_DISABLE_AAA = 0x1000;

const EOAC_NO_CUSTOM_MARSHAL = 0x2000;

const EOAC_RESERVED1 = 0x4000;

const WBEM_FLAG_RETURN_IMMEDIATELY = 0x10;

const WBEM_FLAG_RETURN_WBEM_COMPLETE = 0;

const WBEM_FLAG_BIDIRECTIONAL = 0;

const WBEM_FLAG_FORWARD_ONLY = 0x20;

const WBEM_FLAG_NO_ERROR_OBJECT = 0x40;

const WBEM_FLAG_RETURN_ERROR_OBJECT = 0;

const WBEM_FLAG_SEND_STATUS = 0x80;

const WBEM_FLAG_DONT_SEND_STATUS = 0;

const WBEM_FLAG_ENSURE_LOCATABLE = 0x100;

const WBEM_FLAG_DIRECT_READ = 0x200;

const WBEM_FLAG_SEND_ONLY_SELECTED = 0;

const WBEM_RETURN_WHEN_COMPLETE = 0;

const WBEM_RETURN_IMMEDIATELY = 0x10;

const WBEM_MASK_RESERVED_FLAGS = 0x1f000;

const WBEM_FLAG_USE_AMENDED_QUALIFIERS = 0x20000;

const WBEM_FLAG_STRONG_VALIDATION = 0x100000;

const WBEM_FLAG_REFRESH_AUTO_RECONNECT = 0;

const WBEM_FLAG_REFRESH_NO_AUTO_RECONNECT = 1;

const NLM_CONNECTIVITY_DISCONNECTED = 0;

const NLM_CONNECTIVITY_IPV4_NOTRAFFIC = 0x1;

const NLM_CONNECTIVITY_IPV6_NOTRAFFIC = 0x2;

const NLM_CONNECTIVITY_IPV4_SUBNET = 0x10;

const NLM_CONNECTIVITY_IPV4_LOCALNETWORK = 0x20;

const NLM_CONNECTIVITY_IPV4_INTERNET = 0x40;

const NLM_CONNECTIVITY_IPV6_SUBNET = 0x100;

const NLM_CONNECTIVITY_IPV6_LOCALNETWORK = 0x200;

const NLM_CONNECTIVITY_IPV6_INTERNET = 0x400;

const NLM_ENUM_NETWORK_CONNECTED = 0x1;

const NLM_ENUM_NETWORK_DISCONNECTED = 0x2;

const NLM_ENUM_NETWORK_ALL = 0x3;

const KLF_REORDER = 8;

const KLF_RESET = 1073741824;

const KLF_SETFORPROCESS = 256;

const KLF_SHIFTLOCK = 65536;

const KLF_ACTIVATE = 1;

const KLF_NOTELLSHELL = 128;

const KLF_REPLACELANG = 16;

const KLF_SUBSTITUTE_OK = 2;

const FADF_AUTO = 1;

const FADF_STATIC = 2;

const FADF_EMBEDDED = 4;

const FADF_FIXEDSIZE = 16;

const FADF_RECORD = 32;

const FADF_HAVEIID = 64;

const FADF_HAVEVARTYPE = 128;

const FADF_BSTR = 256;

const FADF_UNKNOWN = 512;

const FADF_DISPATCH = 1024;

const FADF_VARIANT = 2048;

const FADF_RESERVED = 61448;

/// Your Internet connection for outgoing connections to the Internet.
const APPX_CAPABILITY_INTERNET_CLIENT = 1;

/// Your Internet connection, including incoming unsolicited connections from
/// the Internet – the app can send information to or from your computer
/// through a firewall.
const APPX_CAPABILITY_INTERNET_CLIENT_SERVER = 2;

/// A home or work network – the app can send information to or from your
/// computer and other computers on the same network.
const APPX_CAPABILITY_PRIVATE_NETWORK_CLIENT_SERVER = APPX_CAPABILITIES(4);

/// Your documents library, including the capability to add, change, or delete
/// files.
const APPX_CAPABILITY_DOCUMENTS_LIBRARY = 8;

/// Your pictures library, including the capability to add, change, or delete
/// files.
const APPX_CAPABILITY_PICTURES_LIBRARY = 16;

/// Your videos library, including the capability to add, change, or delete
/// files.
const APPX_CAPABILITY_VIDEOS_LIBRARY = 32;

/// Your music library and playlists, including the capability to add, change,
/// or delete files.
const APPX_CAPABILITY_MUSIC_LIBRARY = 64;

/// Your Windows credentials, for access to a corporate intranet.
const APPX_CAPABILITY_ENTERPRISE_AUTHENTICATION = APPX_CAPABILITIES(128);

/// Software and hardware certificates or a smart card – used to identify you
/// in the app.
const APPX_CAPABILITY_SHARED_USER_CERTIFICATES = APPX_CAPABILITIES(256);

/// Removable storage, such as an external hard drive or USB flash drive, or
/// MTP portable device, including the capability to add, change, or delete
/// specific files.
const APPX_CAPABILITY_REMOVABLE_STORAGE = 512;

const APPX_CAPABILITY_APPOINTMENTS = 1024;

const APPX_CAPABILITY_CONTACTS = 2048;

const APPX_CAPABILITY_CLASS_DEFAULT = 0;

const APPX_CAPABILITY_CLASS_GENERAL = 1;

const APPX_CAPABILITY_CLASS_RESTRICTED = 2;

const APPX_CAPABILITY_CLASS_WINDOWS = 4;

const APPX_CAPABILITY_CLASS_ALL = 7;

const APPX_CAPABILITY_CLASS_CUSTOM = 8;

/// No compression.
const APPX_COMPRESSION_OPTION_NONE = 0;

/// Normal compression.
const APPX_COMPRESSION_OPTION_NORMAL = 1;

/// Maximum compression.
const APPX_COMPRESSION_OPTION_MAXIMUM = 2;

/// Fast compression.
const APPX_COMPRESSION_OPTION_FAST = 3;

/// Super-fast compression.
const APPX_COMPRESSION_OPTION_SUPERFAST = 4;

/// The package manifest.
const APPX_FOOTPRINT_FILE_TYPE_MANIFEST = 0;

/// The package block map.
const APPX_FOOTPRINT_FILE_TYPE_BLOCKMAP = 1;

/// The package signature.
const APPX_FOOTPRINT_FILE_TYPE_SIGNATURE = 2;

/// The code signing catalog file used for code integrity checks.
const APPX_FOOTPRINT_FILE_TYPE_CODEINTEGRITY = APPX_FOOTPRINT_FILE_TYPE(3);

/// The content group map used for streaming install.
const APPX_FOOTPRINT_FILE_TYPE_CONTENTGROUPMAP = APPX_FOOTPRINT_FILE_TYPE(4);

/// The x86 processor architecture.
const APPX_PACKAGE_ARCHITECTURE_X86 = 0;

/// The ARM processor architecture.
const APPX_PACKAGE_ARCHITECTURE_ARM = 5;

/// The x64 processor architecture.
const APPX_PACKAGE_ARCHITECTURE_X64 = 9;

/// Any processor architecture.
const APPX_PACKAGE_ARCHITECTURE_NEUTRAL = APPX_PACKAGE_ARCHITECTURE(11);

/// The 64-bit ARM processor architecture.
const APPX_PACKAGE_ARCHITECTURE_ARM64 = 12;

/// The associated audio stream should use the default audio ducking behavior.
const AUDIO_DUCKING_OPTIONS_DEFAULT = 0;

/// The associated audio stream should not cause other streams to be ducked.
const AUDIO_DUCKING_OPTIONS_DO_NOT_DUCK_OTHER_STREAMS = AUDIO_DUCKING_OPTIONS(
  1,
);

/// Other audio stream.
const AudioCategory_Other = 0;

/// Media that will only stream when the app is in the foreground.
const AudioCategory_ForegroundOnlyMedia = 1;

/// Real-time communications, such as VOIP or chat.
const AudioCategory_Communications = 3;

/// Alert sounds.
const AudioCategory_Alerts = 4;

/// Sound effects.
const AudioCategory_SoundEffects = 5;

/// Game sound effects.
const AudioCategory_GameEffects = 6;

/// Background audio for games.
const AudioCategory_GameMedia = 7;

/// Game chat audio.
const AudioCategory_GameChat = 8;

/// Speech.
const AudioCategory_Speech = 9;

/// Stream that includes audio with dialog.
const AudioCategory_Movie = 10;

/// Stream that includes audio without dialog.
const AudioCategory_Media = 11;

/// Media is audio captured with the intent of capturing voice sources located
/// in the ‘far field’.
const AudioCategory_FarFieldSpeech = 12;

/// Media is captured audio that requires consistent speech processing for the
/// captured audio stream across all Windows devices.
const AudioCategory_UniformSpeech = 13;

/// Media is audio captured with the intent of enabling dictation or typing by
/// voice.
const AudioCategory_VoiceTyping = 14;

const MITMProtectionNotRequired = 0;

const MITMProtectionRequired = 1;

const MITMProtectionNotRequiredBonding = AUTHENTICATION_REQUIREMENTS(2);

const MITMProtectionRequiredBonding = 3;

const MITMProtectionNotRequiredGeneralBonding = AUTHENTICATION_REQUIREMENTS(4);

const MITMProtectionRequiredGeneralBonding = AUTHENTICATION_REQUIREMENTS(5);

const MITMProtectionNotDefined = 255;

/// The audio session is inactive.
const AudioSessionStateInactive = 0;

/// The audio session is active.
const AudioSessionStateActive = 1;

/// The audio session has expired.
const AudioSessionStateExpired = 2;

const BSF_ALLOWSFW = 128;

const BSF_FLUSHDISK = 4;

const BSF_FORCEIFHUNG = 32;

const BSF_IGNORECURRENTTASK = 2;

const BSF_NOHANG = 8;

const BSF_NOTIMEOUTIFNOTHUNG = 64;

const BSF_POSTMESSAGE = 16;

const BSF_QUERY = 1;

const BSF_SENDNOTIFYMESSAGE = 256;

const BSF_LUID = 1024;

const BSF_RETURNHDESK = 512;

const BSM_ALLCOMPONENTS = 0;

const BSM_ALLDESKTOPS = 16;

const BSM_APPLICATIONS = 8;

const BS_INDEXED = 4;

const BS_MONOPATTERN = 9;

/// The characteristic value has additional properties that describe how it
/// can be used, or how it can be accessed.
const CharacteristicExtendedProperties = BTH_LE_GATT_DESCRIPTOR_TYPE(0);

/// The characteristic value contains a UTF-8 string of variable size that is
/// a user textual description.
const CharacteristicUserDescription = 1;

/// The characteristic value may be configured by the client.
const ClientCharacteristicConfiguration = BTH_LE_GATT_DESCRIPTOR_TYPE(2);

/// The characteristic value may be configured for the server.
const ServerCharacteristicConfiguration = BTH_LE_GATT_DESCRIPTOR_TYPE(3);

/// The format of the characteristic value.
const CharacteristicFormat = 4;

/// The format of an aggregated characteristic value.
const CharacteristicAggregateFormat = 5;

/// The characteristic value is customized.
const CustomDescriptor = 6;

/// The characteristic value has changed.
const CharacteristicValueChangedEvent = 0;

const CC_FASTCALL = 0;

const CC_CDECL = 1;

const CC_MSCPASCAL = 2;

const CC_PASCAL = 2;

const CC_MACPASCAL = 3;

const CC_STDCALL = 4;

const CC_FPFASTCALL = 5;

const CC_SYSCALL = 6;

const CC_MPWCDECL = 7;

const CC_MPWPASCAL = 8;

const CC_MAX = 9;

const MDITILE_SKIPDISABLED = 2;

const MDITILE_ZORDER = 4;

const CDCS_INACTIVE = 0;

const CDCS_ENABLED = 1;

const CDCS_VISIBLE = 2;

const CDCS_ENABLEDVISIBLE = 3;

const CDS_FULLSCREEN = 4;

const CDS_GLOBAL = 8;

const CDS_NORESET = 268435456;

const CDS_RESET = 1073741824;

const CDS_SET_PRIMARY = 16;

const CDS_TEST = 2;

const CDS_UPDATEREGISTRY = 1;

const CDS_VIDEOPARAMETERS = 32;

const CDS_ENABLE_UNSAFE_MODES = 256;

const CDS_DISABLE_UNSAFE_MODES = 512;

const CDS_RESET_EX = 536870912;

const X509_ASN_ENCODING = 1;

const PKCS_7_ASN_ENCODING = 65536;

const MSGFLT_ADD = 1;

const MSGFLT_REMOVE = 2;

const BOLD_FONTTYPE = 256;

const ITALIC_FONTTYPE = 512;

const PRINTER_FONTTYPE = 16384;

const REGULAR_FONTTYPE = 1024;

const SCREEN_FONTTYPE = 8192;

const SIMULATED_FONTTYPE = 32768;

const CE_BREAK = 16;

const CE_FRAME = 8;

const CE_OVERRUN = 2;

const CE_RXOVER = 1;

const CE_RXPARITY = 4;

const CF_MAX = 18;

const CLSCTX_ALLOW_LOWER_TRUST_REGISTRATION = 67108864;

const CLSCTX_SERVER = 21;

const STOPBITS_10 = 1;

const STOPBITS_15 = 2;

const STOPBITS_20 = 4;

const PARITY_NONE = 256;

const PARITY_ODD = 512;

const PARITY_EVEN = 1024;

const PARITY_MARK = 2048;

const PARITY_SPACE = 4096;

const EV_BREAK = 64;

const EV_CTS = 8;

const EV_DSR = 16;

const EV_ERR = 128;

const EV_EVENT1 = 2048;

const EV_EVENT2 = 4096;

const EV_PERR = 512;

const EV_RING = 256;

const EV_RLSD = 32;

const EV_RX80FULL = 1024;

const EV_RXCHAR = 1;

const EV_RXFLAG = 2;

const EV_TXEMPTY = 4;

const ENABLE_AUTO_POSITION = 256;

const CREATE_EVENT_INITIAL_SET = 2;

const CREATE_EVENT_MANUAL_RESET = 1;

const CRED_FLAGS_PASSWORD_FOR_CERT = 1;

const CRED_FLAGS_OWF_CRED_BLOB = 8;

const CRED_FLAGS_REQUIRE_CONFIRMATION = 16;

const CRED_FLAGS_WILDCARD_MATCH = 32;

const CRED_FLAGS_VSM_PROTECTED = 64;

const CRED_FLAGS_NGC_CERT = 128;

const CRED_FLAGS_VALID_FLAGS = 61695;

const CRED_FLAGS_VALID_INPUT_FLAGS = 61599;

const CRED_PERSIST_NONE = 0;

const CURSOR_SHOWING = 1;

const CURSOR_SUPPRESSED = 2;

const CWP_ALL = 0;

const CWP_SKIPINVISIBLE = 1;

const CWP_SKIPDISABLED = 2;

const CWP_SKIPTRANSPARENT = 4;

const DDD_RAW_TARGET_PATH = 1;

const DDD_REMOVE_DEFINITION = 2;

const DDD_EXACT_MATCH_ON_REMOVE = 4;

const DDD_NO_BROADCAST_SYSTEM = 8;

const DDD_LUID_BROADCAST_DRIVE = 16;

const DESKTOP_DELETE = 65536;

const DESKTOP_READ_CONTROL = 131072;

const DESKTOP_WRITE_DAC = 262144;

const DESKTOP_WRITE_OWNER = 524288;

const DESKTOP_SYNCHRONIZE = 1048576;

const DESKTOP_READOBJECTS = 1;

const DESKTOP_CREATEWINDOW = 2;

const DESKTOP_CREATEMENU = 4;

const DESKTOP_HOOKCONTROL = 8;

const DESKTOP_JOURNALRECORD = 16;

const DESKTOP_JOURNALPLAYBACK = 32;

const DESKTOP_ENUMERATE = 64;

const DESKTOP_WRITEOBJECTS = 128;

const DESKTOP_SWITCHDESKTOP = 256;

const DF_ALLOWOTHERACCOUNTHOOK = 1;

const DBT_DEVTYP_DEVICEINTERFACE = 5;

const DBT_DEVTYP_HANDLE = 6;

const DBT_DEVTYP_OEM = 0;

const DBT_DEVTYP_PORT = 3;

const DBT_DEVTYP_VOLUME = 2;

const DEVICE_SCALE_FACTOR_INVALID = 0;

/// 100%.
const SCALE_100_PERCENT = 100;

/// 120%.
const SCALE_120_PERCENT = 120;

const SCALE_125_PERCENT = 125;

/// 140%.
const SCALE_140_PERCENT = 140;

/// 150%.
const SCALE_150_PERCENT = 150;

/// 160%.
const SCALE_160_PERCENT = 160;

const SCALE_175_PERCENT = 175;

/// 180%.
const SCALE_180_PERCENT = 180;

const SCALE_200_PERCENT = 200;

/// 225%.
const SCALE_225_PERCENT = 225;

const SCALE_250_PERCENT = 250;

const SCALE_300_PERCENT = 300;

const SCALE_350_PERCENT = 350;

const SCALE_400_PERCENT = 400;

const SCALE_450_PERCENT = 450;

const SCALE_500_PERCENT = 500;

const DEVICE_STATE_ACTIVE = 1;

const DEVICE_STATE_DISABLED = 2;

const DEVICE_STATE_NOTPRESENT = 4;

const DEVICE_STATE_UNPLUGGED = 8;

const DMCOLLATE_FALSE = 0;

const DMCOLLATE_TRUE = 1;

const DMCOLOR_MONOCHROME = 1;

const DMCOLOR_COLOR = 2;

const DMDFO_DEFAULT = 0;

const DMDFO_STRETCH = 1;

const DMDFO_CENTER = 2;

const DMDO_DEFAULT = 0;

const DMDO_90 = 1;

const DMDO_180 = 2;

const DMDO_270 = 3;

const DMDUP_SIMPLEX = 1;

const DMDUP_VERTICAL = 2;

const DMDUP_HORIZONTAL = 3;

const DM_SPECVERSION = 1025;

const DM_ORIENTATION = 1;

const DM_PAPERSIZE = 2;

const DM_PAPERLENGTH = 4;

const DM_PAPERWIDTH = 8;

const DM_SCALE = 16;

const DM_POSITION = 32;

const DM_NUP = 64;

const DM_DISPLAYORIENTATION = 128;

const DM_COPIES = 256;

const DM_DEFAULTSOURCE = 512;

const DM_PRINTQUALITY = 1024;

const DM_COLOR = 2048;

const DM_DUPLEX = 4096;

const DM_YRESOLUTION = 8192;

const DM_TTOPTION = 16384;

const DM_COLLATE = 32768;

const DM_FORMNAME = 65536;

const DM_LOGPIXELS = 131072;

const DM_BITSPERPEL = 262144;

const DM_PELSWIDTH = 524288;

const DM_PELSHEIGHT = 1048576;

const DM_DISPLAYFLAGS = 2097152;

const DM_DISPLAYFREQUENCY = 4194304;

const DM_ICMMETHOD = 8388608;

const DM_ICMINTENT = 16777216;

const DM_MEDIATYPE = 33554432;

const DM_DITHERTYPE = 67108864;

const DM_PANNINGWIDTH = 134217728;

const DM_PANNINGHEIGHT = 268435456;

const DM_DISPLAYFIXEDOUTPUT = 536870912;

const DM_INTERLACED = 2;

const DM_UPDATE = 1;

const DM_COPY = 2;

const DM_PROMPT = 4;

const DM_MODIFY = 8;

const DM_IN_BUFFER = 8;

const DM_IN_PROMPT = 4;

const DM_OUT_BUFFER = 2;

const DM_OUT_DEFAULT = 1;

const DMTT_BITMAP = 1;

const DMTT_DOWNLOAD = 2;

const DMTT_SUBDEV = 3;

const DMTT_DOWNLOAD_OUTLINE = 4;

const DFCS_CAPTIONCLOSE = 0;

const DFCS_CAPTIONMIN = 1;

const DFCS_CAPTIONMAX = 2;

const DFCS_CAPTIONRESTORE = 3;

const DFCS_CAPTIONHELP = 4;

const DFCS_MENUARROW = 0;

const DFCS_MENUCHECK = 1;

const DFCS_MENUBULLET = 2;

const DFCS_MENUARROWRIGHT = 4;

const DFCS_SCROLLUP = 0;

const DFCS_SCROLLDOWN = 1;

const DFCS_SCROLLLEFT = 2;

const DFCS_SCROLLRIGHT = 3;

const DFCS_SCROLLCOMBOBOX = 5;

const DFCS_SCROLLSIZEGRIP = 8;

const DFCS_SCROLLSIZEGRIPRIGHT = 16;

const DFCS_BUTTONCHECK = 0;

const DFCS_BUTTONRADIOIMAGE = 1;

const DFCS_BUTTONRADIOMASK = 2;

const DFCS_BUTTONRADIO = 4;

const DFCS_BUTTON3STATE = 8;

const DFCS_BUTTONPUSH = 16;

const DFCS_INACTIVE = 256;

const DFCS_PUSHED = 512;

const DFCS_CHECKED = 1024;

const DFCS_TRANSPARENT = 2048;

const DFCS_HOT = 4096;

const DFCS_ADJUSTRECT = 8192;

const DFCS_FLAT = 16384;

const DFCS_MONO = 32768;

const DFC_CAPTION = 1;

const DFC_MENU = 2;

const DFC_SCROLL = 3;

const DFC_BUTTON = 4;

const DFC_POPUPMENU = 5;

/// Specifies the source name of the display device.
const DISPLAYCONFIG_DEVICE_INFO_GET_SOURCE_NAME =
    DISPLAYCONFIG_DEVICE_INFO_TYPE(1);

/// Specifies information about the monitor.
const DISPLAYCONFIG_DEVICE_INFO_GET_TARGET_NAME =
    DISPLAYCONFIG_DEVICE_INFO_TYPE(2);

/// Specifies information about the preferred mode of a monitor.
const DISPLAYCONFIG_DEVICE_INFO_GET_TARGET_PREFERRED_MODE =
    DISPLAYCONFIG_DEVICE_INFO_TYPE(3);

/// Specifies the graphics adapter name.
const DISPLAYCONFIG_DEVICE_INFO_GET_ADAPTER_NAME =
    DISPLAYCONFIG_DEVICE_INFO_TYPE(4);

/// Specifies how to set the monitor.
const DISPLAYCONFIG_DEVICE_INFO_SET_TARGET_PERSISTENCE =
    DISPLAYCONFIG_DEVICE_INFO_TYPE(5);

/// Specifies how to set the base output technology for a given target ID.
const DISPLAYCONFIG_DEVICE_INFO_GET_TARGET_BASE_TYPE =
    DISPLAYCONFIG_DEVICE_INFO_TYPE(6);

/// Specifies the state of virtual mode support.
const DISPLAYCONFIG_DEVICE_INFO_GET_SUPPORT_VIRTUAL_RESOLUTION =
    DISPLAYCONFIG_DEVICE_INFO_TYPE(7);

/// Specifies how to set the state of virtual mode support.
const DISPLAYCONFIG_DEVICE_INFO_SET_SUPPORT_VIRTUAL_RESOLUTION =
    DISPLAYCONFIG_DEVICE_INFO_TYPE(8);

const DISPLAYCONFIG_DEVICE_INFO_GET_ADVANCED_COLOR_INFO =
    DISPLAYCONFIG_DEVICE_INFO_TYPE(9);

const DISPLAYCONFIG_DEVICE_INFO_SET_ADVANCED_COLOR_STATE =
    DISPLAYCONFIG_DEVICE_INFO_TYPE(10);

/// Specifies the current SDR white level for an HDR monitor.
const DISPLAYCONFIG_DEVICE_INFO_GET_SDR_WHITE_LEVEL =
    DISPLAYCONFIG_DEVICE_INFO_TYPE(11);

const DISPLAYCONFIG_DEVICE_INFO_GET_MONITOR_SPECIALIZATION =
    DISPLAYCONFIG_DEVICE_INFO_TYPE(12);

const DISPLAYCONFIG_DEVICE_INFO_SET_MONITOR_SPECIALIZATION =
    DISPLAYCONFIG_DEVICE_INFO_TYPE(13);

/// Indicates that the <a
/// href="https://docs.microsoft.com/windows/desktop/api/wingdi/ns-wingdi-displayconfig_mode_info">DISPLAYCONFIG_MODE_INFO</a>
/// structure contains source mode information.
const DISPLAYCONFIG_MODE_INFO_TYPE_SOURCE = DISPLAYCONFIG_MODE_INFO_TYPE(1);

/// Indicates that the <a
/// href="https://docs.microsoft.com/windows/desktop/api/wingdi/ns-wingdi-displayconfig_mode_info">DISPLAYCONFIG_MODE_INFO</a>
/// structure contains target mode information.
const DISPLAYCONFIG_MODE_INFO_TYPE_TARGET = DISPLAYCONFIG_MODE_INFO_TYPE(2);

/// Indicates that the <a
/// href="https://docs.microsoft.com/windows/desktop/api/wingdi/ns-wingdi-displayconfig_mode_info">DISPLAYCONFIG_MODE_INFO</a>
/// structure contains a valid <a
/// href="https://docs.microsoft.com/windows/desktop/api/wingdi/ns-wingdi-displayconfig_desktop_image_info">DISPLAYCONFIG_DESKTOP_IMAGE_INFO</a>
/// structure.
const DISPLAYCONFIG_MODE_INFO_TYPE_DESKTOP_IMAGE = DISPLAYCONFIG_MODE_INFO_TYPE(
  3,
);

/// Indicates 8 BPP format.
const DISPLAYCONFIG_PIXELFORMAT_8BPP = 1;

/// Indicates 16 BPP format.
const DISPLAYCONFIG_PIXELFORMAT_16BPP = 2;

/// Indicates 24 BPP format.
const DISPLAYCONFIG_PIXELFORMAT_24BPP = 3;

/// Indicates 32 BPP format.
const DISPLAYCONFIG_PIXELFORMAT_32BPP = 4;

/// Indicates that the current display is not an 8, 16, 24, or 32 BPP GDI
/// desktop mode.
const DISPLAYCONFIG_PIXELFORMAT_NONGDI = 5;

/// Indicates that rotation is 0 degrees—landscape mode.
const DISPLAYCONFIG_ROTATION_IDENTITY = 1;

/// Indicates that rotation is 90 degrees clockwise—portrait mode.
const DISPLAYCONFIG_ROTATION_ROTATE90 = 2;

/// Indicates that rotation is 180 degrees clockwise—inverted landscape mode.
const DISPLAYCONFIG_ROTATION_ROTATE180 = 3;

/// Indicates that rotation is 270 degrees clockwise—inverted portrait mode.
const DISPLAYCONFIG_ROTATION_ROTATE270 = 4;

/// Indicates the identity transformation; the source content is presented
/// with no change.
const DISPLAYCONFIG_SCALING_IDENTITY = 1;

/// Indicates the centering transformation; the source content is presented
/// unscaled, centered with respect to the spatial resolution of the target
/// mode.
const DISPLAYCONFIG_SCALING_CENTERED = 2;

/// Indicates the content is scaled to fit the path's target.
const DISPLAYCONFIG_SCALING_STRETCHED = 3;

/// Indicates the aspect-ratio centering transformation.
const DISPLAYCONFIG_SCALING_ASPECTRATIOCENTEREDMAX = DISPLAYCONFIG_SCALING(4);

/// Indicates that the caller requests a custom scaling that the caller cannot
/// describe with any of the other DISPLAYCONFIG_SCALING_XXX values.
const DISPLAYCONFIG_SCALING_CUSTOM = 5;

/// Indicates that the caller does not have any preference for the scaling.
const DISPLAYCONFIG_SCALING_PREFERRED = 128;

/// Indicates that scan-line ordering of the output is unspecified.
const DISPLAYCONFIG_SCANLINE_ORDERING_UNSPECIFIED =
    DISPLAYCONFIG_SCANLINE_ORDERING(0);

/// Indicates that the output is a progressive image.
const DISPLAYCONFIG_SCANLINE_ORDERING_PROGRESSIVE =
    DISPLAYCONFIG_SCANLINE_ORDERING(1);

/// Indicates that the output is an interlaced image that is created beginning
/// with the upper field.
const DISPLAYCONFIG_SCANLINE_ORDERING_INTERLACED =
    DISPLAYCONFIG_SCANLINE_ORDERING(2);

/// Indicates that the output is an interlaced image that is created beginning
/// with the upper field.
const DISPLAYCONFIG_SCANLINE_ORDERING_INTERLACED_UPPERFIELDFIRST =
    DISPLAYCONFIG_SCANLINE_ORDERING(2);

/// Indicates that the output is an interlaced image that is created beginning
/// with the lower field.
const DISPLAYCONFIG_SCANLINE_ORDERING_INTERLACED_LOWERFIELDFIRST =
    DISPLAYCONFIG_SCANLINE_ORDERING(3);

/// Indicates a connector that is not one of the types that is indicated by
/// the following enumerators in this enumeration.
const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_OTHER =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(-1);

/// Indicates an HD15 (VGA) connector.
const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_HD15 =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(0);

/// Indicates an S-video connector.
const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_SVIDEO =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(1);

/// Indicates a composite video connector group.
const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_COMPOSITE_VIDEO =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(2);

/// Indicates a component video connector group.
const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_COMPONENT_VIDEO =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(3);

/// Indicates a Digital Video Interface (DVI) connector.
const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_DVI =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(4);

/// Indicates a High-Definition Multimedia Interface (HDMI) connector.
const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_HDMI =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(5);

/// Indicates a Low Voltage Differential Swing (LVDS) connector.
const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_LVDS =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(6);

/// Indicates a Japanese D connector.
const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_D_JPN =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(8);

/// Indicates an SDI connector.
const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_SDI =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(9);

/// Indicates an external display port, which is a display port that connects
/// externally to a display device.
const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_DISPLAYPORT_EXTERNAL =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(10);

/// Indicates an embedded display port that connects internally to a display
/// device.
const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_DISPLAYPORT_EMBEDDED =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(11);

/// Indicates an external Unified Display Interface (UDI), which is a UDI that
/// connects externally to a display device.
const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_UDI_EXTERNAL =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(12);

/// Indicates an embedded UDI that connects internally to a display device.
const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_UDI_EMBEDDED =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(13);

/// Indicates a dongle cable that supports standard definition television
/// (SDTV).
const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_SDTVDONGLE =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(14);

/// Indicates that the VidPN target is a Miracast wireless display device.
const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_MIRACAST =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(15);

const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_INDIRECT_WIRED =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(16);

const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_INDIRECT_VIRTUAL =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(17);

const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_DISPLAYPORT_USB_TUNNEL =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(18);

/// Indicates that the video output device connects internally to a display
/// device (for example, the internal connection in a laptop computer).
const DISPLAYCONFIG_OUTPUT_TECHNOLOGY_INTERNAL =
    DISPLAYCONFIG_VIDEO_OUTPUT_TECHNOLOGY(-2147483648);

const DISP_CHANGE_SUCCESSFUL = 0;

const DISP_CHANGE_RESTART = 1;

const DISP_CHANGE_FAILED = DISP_CHANGE(-1);

const DISP_CHANGE_BADMODE = DISP_CHANGE(-2);

const DISP_CHANGE_NOTUPDATED = DISP_CHANGE(-3);

const DISP_CHANGE_BADFLAGS = DISP_CHANGE(-4);

const DISP_CHANGE_BADPARAM = DISP_CHANGE(-5);

const DISP_CHANGE_BADDUALVIEW = DISP_CHANGE(-6);

const BST_CHECKED = 1;

const BST_INDETERMINATE = 2;

const BST_UNCHECKED = 0;

const DOT11_AUTH_ALGO_80211_OPEN = 1;

const DOT11_AUTH_ALGO_80211_SHARED_KEY = 2;

const DOT11_AUTH_ALGO_WPA = 3;

const DOT11_AUTH_ALGO_WPA_PSK = 4;

const DOT11_AUTH_ALGO_WPA_NONE = 5;

const DOT11_AUTH_ALGO_RSNA = 6;

const DOT11_AUTH_ALGO_RSNA_PSK = 7;

const DOT11_AUTH_ALGO_WPA3 = 8;

const DOT11_AUTH_ALGO_WPA3_ENT_192 = 8;

const DOT11_AUTH_ALGO_WPA3_SAE = 9;

const DOT11_AUTH_ALGO_OWE = 10;

const DOT11_AUTH_ALGO_WPA3_ENT = 11;

const DOT11_AUTH_ALGO_IHV_START = DOT11_AUTH_ALGORITHM(-2147483648);

const DOT11_AUTH_ALGO_IHV_END = DOT11_AUTH_ALGORITHM(-1);

const dot11_BSS_type_infrastructure = 1;

const dot11_BSS_type_independent = 2;

const dot11_BSS_type_any = 3;

const DOT11_CIPHER_ALGO_NONE = 0;

const DOT11_CIPHER_ALGO_WEP40 = 1;

const DOT11_CIPHER_ALGO_TKIP = 2;

const DOT11_CIPHER_ALGO_CCMP = 4;

const DOT11_CIPHER_ALGO_WEP104 = 5;

const DOT11_CIPHER_ALGO_BIP = 6;

const DOT11_CIPHER_ALGO_GCMP = 8;

const DOT11_CIPHER_ALGO_GCMP_256 = 9;

const DOT11_CIPHER_ALGO_CCMP_256 = 10;

const DOT11_CIPHER_ALGO_BIP_GMAC_128 = 11;

const DOT11_CIPHER_ALGO_BIP_GMAC_256 = 12;

const DOT11_CIPHER_ALGO_BIP_CMAC_256 = 13;

const DOT11_CIPHER_ALGO_WPA_USE_GROUP = 256;

const DOT11_CIPHER_ALGO_RSN_USE_GROUP = 256;

const DOT11_CIPHER_ALGO_WEP = 257;

const DOT11_CIPHER_ALGO_IHV_START = DOT11_CIPHER_ALGORITHM(-2147483648);

const DOT11_CIPHER_ALGO_IHV_END = DOT11_CIPHER_ALGORITHM(-1);

const dot11_phy_type_unknown = 0;

const dot11_phy_type_any = 0;

const dot11_phy_type_fhss = 1;

const dot11_phy_type_dsss = 2;

const dot11_phy_type_irbaseband = 3;

const dot11_phy_type_ofdm = 4;

const dot11_phy_type_hrdsss = 5;

const dot11_phy_type_erp = 6;

const dot11_phy_type_ht = 7;

const dot11_phy_type_vht = 8;

const dot11_phy_type_dmg = 9;

const dot11_phy_type_he = 10;

const dot11_phy_type_eht = 11;

const dot11_phy_type_IHV_start = DOT11_PHY_TYPE(-2147483648);

const dot11_phy_type_IHV_end = DOT11_PHY_TYPE(-1);

/// The radio state is unknown.
const dot11_radio_state_unknown = 0;

/// The radio is on.
const dot11_radio_state_on = 1;

/// The radio is off.
const dot11_radio_state_off = 2;

const BDR_RAISEDOUTER = 1;

const BDR_SUNKENOUTER = 2;

const BDR_RAISEDINNER = 4;

const BDR_SUNKENINNER = 8;

const BDR_OUTER = 3;

const BDR_INNER = 12;

const BDR_RAISED = 5;

const BDR_SUNKEN = 10;

const EDGE_RAISED = 5;

const EDGE_SUNKEN = 10;

const EDGE_ETCHED = 6;

const EDGE_BUMP = 9;

const DST_COMPLEX = 0;

const DST_TEXT = 1;

const DST_PREFIXTEXT = 2;

const DST_ICON = 3;

const DST_BITMAP = 4;

const DSS_NORMAL = 0;

const DSS_UNION = 16;

const DSS_DISABLED = 32;

const DSS_MONO = 128;

const DSS_HIDEPREFIX = 512;

const DSS_PREFIXONLY = 1024;

const DSS_RIGHT = 32768;

const DC_ACTIVE = 1;

const DC_BUTTONS = 4096;

const DC_GRADIENT = 32;

const DC_ICON = 4;

const DC_INBUTTON = 16;

const DC_SMALLCAP = 2;

const DC_TEXT = 8;

const BF_ADJUST = 8192;

const BF_BOTTOM = 8;

const BF_BOTTOMLEFT = 9;

const BF_BOTTOMRIGHT = 12;

const BF_DIAGONAL = 16;

const BF_DIAGONAL_ENDBOTTOMLEFT = 25;

const BF_DIAGONAL_ENDBOTTOMRIGHT = 28;

const BF_DIAGONAL_ENDTOPLEFT = 19;

const BF_DIAGONAL_ENDTOPRIGHT = 22;

const BF_FLAT = 16384;

const BF_LEFT = 1;

const BF_MIDDLE = 2048;

const BF_MONO = 32768;

const BF_RECT = 15;

const BF_RIGHT = 4;

const BF_SOFT = 4096;

const BF_TOP = 2;

const BF_TOPLEFT = 3;

const BF_TOPRIGHT = 6;

const DTPB_WINDOWDC = 1;

const DTPB_USECTLCOLORSTATIC = 2;

const DTPB_USEERASEBKGND = 4;

/// The type of join is not known.
const DSREG_UNKNOWN_JOIN = 0;

/// The device is joined to Azure Active Directory (Azure AD).
const DSREG_DEVICE_JOIN = 1;

/// The device is registered to Azure Active Directory (Azure AD), meaning an
/// Azure AD work account is added on the device.
const DSREG_WORKPLACE_JOIN = 2;

const DUPLICATE_CLOSE_SOURCE = 1;

const DUPLICATE_SAME_ACCESS = 2;

/// Down.
const DWMSC_DOWN = 1;

/// Up.
const DWMSC_UP = 2;

/// Drag.
const DWMSC_DRAG = 4;

/// Hold.
const DWMSC_HOLD = 8;

/// Pen barrel.
const DWMSC_PENBARREL = 16;

/// None.
const DWMSC_NONE = 0;

/// All.
const DWMSC_ALL = 4294967295;

/// The window is docked at the top.
const DockPosition_Top = 0;

/// The window is docked at the left.
const DockPosition_Left = 1;

/// The window is docked at the bottom.
const DockPosition_Bottom = 2;

/// The window is docked at the right.
const DockPosition_Right = 3;

/// The window is docked on all four sides.
const DockPosition_Fill = 4;

/// The window is not docked.
const DockPosition_None = 5;

/// Audio rendering stream.
const eRender = 0;

/// Audio capture stream.
const eCapture = 1;

/// Audio rendering or capture stream.
const eAll = 2;

/// The number of members in the <a
/// href="https://docs.microsoft.com/windows/win32/api/mmdeviceapi/ne-mmdeviceapi-edataflow">EDataFlow</a>
/// enumeration (not counting the EDataFlow_enum_count member).
const EDataFlow_enum_count = 3;

const ESB_DISABLE_BOTH = 3;

const ESB_DISABLE_DOWN = 2;

const ESB_DISABLE_LEFT = 1;

const ESB_DISABLE_LTUP = 1;

const ESB_DISABLE_RIGHT = 2;

const ESB_DISABLE_RTDN = 2;

const ESB_DISABLE_UP = 1;

const ESB_ENABLE_BOTH = 0;

const EDS_RAWMODE = 2;

const EDS_ROTATEDMODE = 4;

const ENUM_CURRENT_SETTINGS = 4294967295;

const ENUM_REGISTRY_SETTINGS = 4294967294;

const SERVICE_ACTIVE = 1;

const SERVICE_INACTIVE = 2;

const SERVICE_STATE_ALL = 3;

const SERVICE_DRIVER = 11;

const SERVICE_KERNEL_DRIVER = 1;

const SERVICE_WIN32 = 48;

const SERVICE_WIN32_SHARE_PROCESS = 32;

const SERVICE_ADAPTER = 4;

const SERVICE_FILE_SYSTEM_DRIVER = 2;

const SERVICE_RECOGNIZER_DRIVER = 8;

const SERVICE_WIN32_OWN_PROCESS = 16;

const SERVICE_USER_OWN_PROCESS = 80;

const SERVICE_USER_SHARE_PROCESS = 96;

const kJobProduction = 1;

const kJobConsumption = 2;

const kAddingDocumentSequence = 0;

const kDocumentSequenceAdded = 1;

const kAddingFixedDocument = 2;

const kFixedDocumentAdded = 3;

const kAddingFixedPage = 4;

const kFixedPageAdded = 5;

const kResourceAdded = 6;

const kFontAdded = 7;

const kImageAdded = 8;

const kXpsDocumentCommitted = 9;

/// Games, system notification sounds, and voice commands.
const eConsole = 0;

/// Music, movies, narration, and live music recording.
const eMultimedia = 1;

/// Voice communications (talking to another person).
const eCommunications = 2;

/// The number of members in the <a
/// href="https://docs.microsoft.com/windows/win32/api/mmdeviceapi/ne-mmdeviceapi-erole">ERole</a>
/// enumeration (not counting the ERole_enum_count member).
const ERole_enum_count = 3;

const CLRBREAK = 9;

const CLRDTR = 6;

const CLRRTS = 4;

const SETBREAK = 8;

const SETDTR = 5;

const SETRTS = 3;

const SETXOFF = 1;

const SETXON = 2;

const ETO_OPAQUE = 2;

const ETO_CLIPPED = 4;

const ETO_GLYPH_INDEX = 16;

const ETO_RTLREADING = 128;

const ETO_NUMERICSLOCAL = 1024;

const ETO_NUMERICSLATIN = 2048;

const ETO_IGNORELANGUAGE = 4096;

const ETO_PDY = 8192;

const ETO_REVERSE_INDEX_MAP = 65536;

/// No children are visible.
const ExpandCollapseState_Collapsed = 0;

/// All children are visible.
const ExpandCollapseState_Expanded = 1;

/// Some, but not all, children are visible.
const ExpandCollapseState_PartiallyExpanded = 2;

/// The element does not expand or collapse.
const ExpandCollapseState_LeafNode = 3;

const FACILITY_MEDIASERVER = 13;

const FACILITY_MSMQ = 14;

const FACILITY_SETUPAPI = 15;

const FACILITY_SCARD = 16;

const FACILITY_COMPLUS = 17;

const FACILITY_AAF = 18;

const FACILITY_URT = 19;

const FACILITY_ACS = 20;

const FACILITY_DPLAY = 21;

const FACILITY_UMI = 22;

const FACILITY_SXS = 23;

const FACILITY_WINDOWS_CE = 24;

const FACILITY_HTTP = 25;

const FACILITY_USERMODE_COMMONLOG = 26;

const FACILITY_WER = 27;

const FACILITY_USERMODE_FILTER_MANAGER = 31;

const FACILITY_BACKGROUNDCOPY = 32;

const FACILITY_CONFIGURATION = 33;

const FACILITY_WIA = 33;

const FACILITY_STATE_MANAGEMENT = 34;

const FACILITY_METADIRECTORY = 35;

const FACILITY_WINDOWSUPDATE = 36;

const FACILITY_DIRECTORYSERVICE = 37;

const FACILITY_GRAPHICS = 38;

const FACILITY_SHELL = 39;

const FACILITY_NAP = 39;

const FACILITY_TPM_SERVICES = 40;

const FACILITY_TPM_SOFTWARE = 41;

const FACILITY_UI = 42;

const FACILITY_XAML = 43;

const FACILITY_ACTION_QUEUE = 44;

const FACILITY_PLA = 48;

const FACILITY_WINDOWS_SETUP = 48;

const FACILITY_FVE = 49;

const FACILITY_FWP = 50;

const FACILITY_WINRM = 51;

const FACILITY_NDIS = 52;

const FACILITY_USERMODE_HYPERVISOR = 53;

const FACILITY_CMI = 54;

const FACILITY_USERMODE_VIRTUALIZATION = 55;

const FACILITY_USERMODE_VOLMGR = 56;

const FACILITY_BCD = 57;

const FACILITY_USERMODE_VHD = 58;

const FACILITY_USERMODE_HNS = 59;

const FACILITY_SDIAG = 60;

const FACILITY_WEBSERVICES = 61;

const FACILITY_WINPE = 61;

const FACILITY_WPN = 62;

const FACILITY_WINDOWS_STORE = 63;

const FACILITY_INPUT = 64;

const FACILITY_QUIC = 65;

const FACILITY_EAP = 66;

const FACILITY_IORING = 70;

const FACILITY_WINDOWS_DEFENDER = 80;

const FACILITY_OPC = 81;

const FACILITY_XPS = 82;

const FACILITY_MBN = 84;

const FACILITY_POWERSHELL = 84;

const FACILITY_RAS = 83;

const FACILITY_P2P_INT = 98;

const FACILITY_P2P = 99;

const FACILITY_DAF = 100;

const FACILITY_BLUETOOTH_ATT = 101;

const FACILITY_AUDIO = 102;

const FACILITY_STATEREPOSITORY = 103;

const FACILITY_VISUALCPP = 109;

const FACILITY_SCRIPT = 112;

const FACILITY_PARSE = 113;

const FACILITY_BLB = 120;

const FACILITY_BLB_CLI = 121;

const FACILITY_WSBAPP = 122;

const FACILITY_BLBUI = 128;

const FACILITY_USN = 129;

const FACILITY_USERMODE_VOLSNAP = 130;

const FACILITY_TIERING = 131;

const FACILITY_WSB_ONLINE = 133;

const FACILITY_ONLINE_ID = 134;

const FACILITY_DEVICE_UPDATE_AGENT = 135;

const FACILITY_DRVSERVICING = 136;

const FACILITY_DLS = 153;

const FACILITY_DELIVERY_OPTIMIZATION = 208;

const FACILITY_USERMODE_SPACES = 231;

const FACILITY_USER_MODE_SECURITY_CORE = 232;

const FACILITY_USERMODE_LICENSING = 234;

const FACILITY_SOS = 160;

const FACILITY_OCP_UPDATE_AGENT = 173;

const FACILITY_DEBUGGERS = 176;

const FACILITY_SPP = 256;

const FACILITY_RESTORE = 256;

const FACILITY_DMSERVER = 256;

const FACILITY_DEPLOYMENT_SERVICES_SERVER = 257;

const FACILITY_DEPLOYMENT_SERVICES_IMAGING = 258;

const FACILITY_DEPLOYMENT_SERVICES_MANAGEMENT = 259;

const FACILITY_DEPLOYMENT_SERVICES_UTIL = 260;

const FACILITY_DEPLOYMENT_SERVICES_BINLSVC = 261;

const FACILITY_DEPLOYMENT_SERVICES_PXE = 263;

const FACILITY_DEPLOYMENT_SERVICES_TFTP = 264;

const FACILITY_DEPLOYMENT_SERVICES_TRANSPORT_MANAGEMENT = 272;

const FACILITY_DEPLOYMENT_SERVICES_DRIVER_PROVISIONING = 278;

const FACILITY_DEPLOYMENT_SERVICES_MULTICAST_SERVER = 289;

const FACILITY_DEPLOYMENT_SERVICES_MULTICAST_CLIENT = 290;

const FACILITY_DEPLOYMENT_SERVICES_CONTENT_PROVIDER = 293;

const FACILITY_HSP_SERVICES = 296;

const FACILITY_HSP_SOFTWARE = 297;

const FACILITY_LINGUISTIC_SERVICES = 305;

const FACILITY_AUDIOSTREAMING = 1094;

const FACILITY_TTD = 1490;

const FACILITY_ACCELERATOR = 1536;

const FACILITY_WMAAECMA = 1996;

const FACILITY_DIRECTMUSIC = 2168;

const FACILITY_DIRECT3D10 = 2169;

const FACILITY_DXGI = 2170;

const FACILITY_DXGI_DDI = 2171;

const FACILITY_DIRECT3D11 = 2172;

const FACILITY_DIRECT3D11_DEBUG = 2173;

const FACILITY_DIRECT3D12 = 2174;

const FACILITY_DIRECT3D12_DEBUG = 2175;

const FACILITY_DXCORE = 2176;

const FACILITY_PRESENTATION = 2177;

const FACILITY_LEAP = 2184;

const FACILITY_AUDCLNT = 2185;

const FACILITY_WINCODEC_DWRITE_DWM = 2200;

const FACILITY_WINML = 2192;

const FACILITY_DIRECT2D = 2201;

const FACILITY_DEFRAG = 2304;

const FACILITY_USERMODE_SDBUS = 2305;

const FACILITY_JSCRIPT = 2306;

const FACILITY_PIDGENX = 2561;

const FACILITY_EAS = 85;

const FACILITY_WEB = 885;

const FACILITY_WEB_SOCKET = 886;

const FACILITY_MOBILE = 1793;

const FACILITY_SQLITE = 1967;

const FACILITY_SERVICE_FABRIC = 1968;

const FACILITY_UTC = 1989;

const FACILITY_WEP = 2049;

const FACILITY_SYNCENGINE = 2050;

const FACILITY_XBOX = 2339;

const FACILITY_GAME = 2340;

const FACILITY_PIX = 2748;

const FACILITY_NT_BIT = 268435456;

const FOFX_NOSKIPJUNCTIONS = 65536;

const FOFX_PREFERHARDLINK = 131072;

const FOFX_SHOWELEVATIONPROMPT = 262144;

const FOFX_RECYCLEONDELETE = 524288;

const FOFX_EARLYFAILURE = 1048576;

const FOFX_PRESERVEFILEEXTENSIONS = 2097152;

const FOFX_KEEPNEWERFILE = 4194304;

const FOFX_NOCOPYHOOKS = 8388608;

const FOFX_NOMINIMIZEBOX = 16777216;

const FOFX_MOVEACLSACROSSVOLUMES = 33554432;

const FOFX_DONTDISPLAYSOURCEPATH = 67108864;

const FOFX_DONTDISPLAYDESTPATH = 134217728;

const FOFX_REQUIREELEVATION = 268435456;

const FOFX_ADDUNDORECORD = 536870912;

const FOFX_COPYASDOWNLOAD = 1073741824;

const FOFX_DONTDISPLAYLOCATIONS = 2147483648;

const FOF_CONFIRMMOUSE = 2;

const FOF_NORECURSEREPARSE = 32768;

const SPECIFIC_RIGHTS_ALL = 65535;

const SECURITY_ANONYMOUS = 0;

const SECURITY_IDENTIFICATION = 65536;

const SECURITY_IMPERSONATION = 131072;

const SECURITY_DELEGATION = 196608;

const SECURITY_CONTEXT_TRACKING = 262144;

const SECURITY_EFFECTIVE_ONLY = 524288;

const SECURITY_SQOS_PRESENT = 1048576;

const SECURITY_VALID_SQOS_FLAGS = 2031616;

/// Minimal information for the file should be retrieved or set.
const FileBasicInfo = 0;

/// Extended information for the file should be retrieved.
const FileStandardInfo = 1;

/// The file name should be retrieved.
const FileNameInfo = 2;

/// The file name should be changed.
const FileRenameInfo = 3;

/// The file should be deleted.
const FileDispositionInfo = 4;

/// The file allocation information should be changed.
const FileAllocationInfo = 5;

/// The end of the file should be set.
const FileEndOfFileInfo = 6;

/// File stream information for the specified file should be retrieved.
const FileStreamInfo = 7;

/// File compression information should be retrieved.
const FileCompressionInfo = 8;

/// File attribute information should be retrieved.
const FileAttributeTagInfo = 9;

/// Files in the specified directory should be retrieved.
const FileIdBothDirectoryInfo = 10;

/// Identical to <b>FileIdBothDirectoryInfo</b>, but forces the enumeration
/// operation to start again from the beginning.
const FileIdBothDirectoryRestartInfo = 11;

/// Priority hint information should be set.
const FileIoPriorityHintInfo = 12;

/// File remote protocol information should be retrieved.
const FileRemoteProtocolInfo = 13;

/// Files in the specified directory should be retrieved.
const FileFullDirectoryInfo = 14;

/// Identical to <b>FileFullDirectoryInfo</b>, but forces the enumeration
/// operation to start again from the beginning.
const FileFullDirectoryRestartInfo = 15;

/// File storage information should be retrieved.
const FileStorageInfo = 16;

/// File alignment information should be retrieved.
const FileAlignmentInfo = 17;

/// File information should be retrieved.
const FileIdInfo = 18;

/// Files in the specified directory should be retrieved.
const FileIdExtdDirectoryInfo = 19;

/// Identical to <b>FileIdExtdDirectoryInfo</b>, but forces the enumeration
/// operation to start again from the beginning.
const FileIdExtdDirectoryRestartInfo = 20;

const FileDispositionInfoEx = 21;

const FileRenameInfoEx = 22;

const FileCaseSensitiveInfo = 23;

const FileNormalizedNameInfo = 24;

/// This value is used for validation.
const MaximumFileInfoByHandleClass = 25;

const FILE_SHARE_NONE = 0;

const FILE_TYPE_UNKNOWN = 0;

const FILE_TYPE_DISK = 1;

const FILE_TYPE_CHAR = 2;

const FILE_TYPE_PIPE = 3;

const FILE_TYPE_REMOTE = 32768;

/// The file is being played by the process that has it open.
const FUT_PLAYING = 0;

/// The file is being edited by the process that has it open.
const FUT_EDITING = 1;

/// The file is open in the process for an unspecified action or an action
/// that does not readily fit into the other two categories.
const FUT_GENERIC = 2;

/// The <a
/// href="https://docs.microsoft.com/windows/desktop/api/fileapi/nf-fileapi-findfirstfileexa">FindFirstFileEx</a>
/// function retrieves a standard set of attribute information.
const FindExInfoStandard = 0;

/// The <a
/// href="https://docs.microsoft.com/windows/desktop/api/fileapi/nf-fileapi-findfirstfileexa">FindFirstFileEx</a>
/// function does not query the short file name, improving overall enumeration
/// speed.
const FindExInfoBasic = 1;

/// This value is used for validation.
const FindExInfoMaxInfoLevel = 2;

/// The search for a file that matches a specified file name.
const FindExSearchNameMatch = 0;

/// This is an advisory flag.
const FindExSearchLimitToDirectories = 1;

/// This filtering type is not available.
const FindExSearchLimitToDevices = 2;

const FindExSearchMaxSearchOp = 3;

const FR_RAW = 131072;

const FR_SHOWWRAPAROUND = 262144;

const FR_NOWRAPAROUND = 524288;

const FR_WRAPAROUND = 1048576;

const FIND_FIRST_EX_CASE_SENSITIVE = 1;

const FIND_FIRST_EX_LARGE_FETCH = 2;

const FIND_FIRST_EX_ON_DISK_ENTRIES_ONLY = 4;

const ACPI = 1094930505;

const FIRM = 1179210317;

const RSMB = 1381190978;

const MAC_CHARSET = 77;

const BALTIC_CHARSET = 186;

const CLIP_DEFAULT_PRECIS = 0;

const CLIP_CHARACTER_PRECIS = 1;

const CLIP_STROKE_PRECIS = 2;

const CLIP_MASK = 15;

const CLIP_LH_ANGLES = 16;

const CLIP_TT_ALWAYS = 32;

const CLIP_DFA_DISABLE = 64;

const CLIP_EMBEDDED = 128;

const CLIP_DFA_OVERRIDE = 64;

const OUT_DEFAULT_PRECIS = 0;

const OUT_STRING_PRECIS = 1;

const OUT_CHARACTER_PRECIS = 2;

const OUT_STROKE_PRECIS = 3;

const OUT_TT_PRECIS = 4;

const OUT_DEVICE_PRECIS = 5;

const OUT_RASTER_PRECIS = 6;

const OUT_TT_ONLY_PRECIS = 7;

const OUT_OUTLINE_PRECIS = 8;

const OUT_SCREEN_OUTLINE_PRECIS = 9;

const OUT_PS_ONLY_PRECIS = 10;

const DEFAULT_QUALITY = 0;

const DRAFT_QUALITY = 1;

const PROOF_QUALITY = 2;

const NONANTIALIASED_QUALITY = 3;

const ANTIALIASED_QUALITY = 4;

const CLEARTYPE_QUALITY = 5;

const FR_PRIVATE = 16;

const FR_NOT_ENUM = 32;

const LSFW_LOCK = 1;

const LSFW_UNLOCK = 2;

const FORMAT_MESSAGE_ALLOCATE_BUFFER = 256;

/// The function should not be accessible from macro languages.
const FUNCFLAG_FRESTRICTED = 1;

/// The function returns an object that is a source of events.
const FUNCFLAG_FSOURCE = 2;

/// The function that supports data binding.
const FUNCFLAG_FBINDABLE = 4;

/// When set, any call to a method that sets the property results first in a
/// call to <b>IPropertyNotifySink::OnRequestEdit</b>.
const FUNCFLAG_FREQUESTEDIT = 8;

/// The function that is displayed to the user as bindable.
const FUNCFLAG_FDISPLAYBIND = 16;

/// The function that best represents the object.
const FUNCFLAG_FDEFAULTBIND = 32;

/// The function should not be displayed to the user, although it exists and
/// is bindable.
const FUNCFLAG_FHIDDEN = 64;

/// The function supports <b>GetLastError</b>.
const FUNCFLAG_FUSESGETLASTERROR = 128;

/// Permits an optimization in which the compiler looks for a member named xyz
/// on the type of abc.
const FUNCFLAG_FDEFAULTCOLLELEM = 256;

/// The type information member is the default member for display in the user
/// interface.
const FUNCFLAG_FUIDEFAULT = 512;

/// The property appears in an object browser, but not in a properties
/// browser.
const FUNCFLAG_FNONBROWSABLE = 1024;

/// Tags the interface as having default behaviors.
const FUNCFLAG_FREPLACEABLE = 2048;

/// Mapped as individual bindable properties.
const FUNCFLAG_FIMMEDIATEBIND = 4096;

/// The function is accessed the same as PUREVIRTUAL, except the function has
/// an implementation.
const FUNC_VIRTUAL = 0;

/// The function is accessed through the virtual function table (VTBL), and
/// takes an implicit this pointer.
const FUNC_PUREVIRTUAL = 1;

/// The function is accessed by static address and takes an implicit this
/// pointer.
const FUNC_NONVIRTUAL = 2;

/// The function is accessed by static address and does not take an implicit
/// this pointer.
const FUNC_STATIC = 3;

/// The function can be accessed only through <a
/// href="https://docs.microsoft.com/previous-versions/windows/desktop/api/oaidl/nn-oaidl-idispatch">IDispatch</a>.
const FUNC_DISPATCH = 4;

const RGN_ERROR = 0;

const NULLREGION = 1;

const SIMPLEREGION = 2;

const COMPLEXREGION = 3;

const GID_BEGIN = 1;

const GID_END = 2;

const GID_ZOOM = 3;

const GID_PAN = 4;

const GID_ROTATE = 5;

const GID_TWOFINGERTAP = 6;

const GID_PRESSANDTAP = 7;

const GID_ROLLOVER = 7;

/// A pen tap.
const GT_PEN_TAP = 0;

/// A pen double tap.
const GT_PEN_DOUBLETAP = 1;

/// A pen right tap.
const GT_PEN_RIGHTTAP = 2;

/// A pen press and hold.
const GT_PEN_PRESSANDHOLD = 3;

/// An abort of the pen press and hold.
const GT_PEN_PRESSANDHOLDABORT = 4;

/// A touch tap.
const GT_TOUCH_TAP = 5;

/// A touch double tap.
const GT_TOUCH_DOUBLETAP = 6;

/// A touch right tap.
const GT_TOUCH_RIGHTTAP = 7;

/// A touch press and hold.
const GT_TOUCH_PRESSANDHOLD = 8;

/// An abort of the pen press and hold.
const GT_TOUCH_PRESSANDHOLDABORT = 9;

/// A touch press and tap.
const GT_TOUCH_PRESSANDTAP = 10;

const VOLUME_NAME_DOS = 0;

const VOLUME_NAME_GUID = 1;

const VOLUME_NAME_NT = 2;

const VOLUME_NAME_NONE = 4;

const FILE_NAME_NORMALIZED = 0;

const FILE_NAME_OPENED = 8;

/// Meaning to a calling process: Return a read-only property store that
/// contains all properties.
const GPS_DEFAULT = 0;

/// Meaning to a calling process: Include only properties directly from the
/// property handler, which opens the file on the disk, network, or device.
const GPS_HANDLERPROPERTIESONLY = 1;

/// Meaning to a calling process: Can write properties to the item.
const GPS_READWRITE = 2;

/// Meaning to a calling process: Provides a writable store, with no initial
/// properties, that exists for the lifetime of the Shell item instance;
/// basically, a property bag attached to the item instance.
const GPS_TEMPORARY = 4;

/// Meaning to a calling process: Provides a store that does not involve
/// reading from the disk or network.
const GPS_FASTPROPERTIESONLY = 8;

/// Meaning to a calling process: Open a slow item (offline file) if
/// necessary.
const GPS_OPENSLOWITEM = 16;

/// Meaning to a calling process: Delay memory-intensive operations, such as
/// file access, until a property is requested that requires such access.
const GPS_DELAYCREATION = 32;

/// Meaning to a calling process: Succeed at getting the store, even if some
/// properties are not returned.
const GPS_BESTEFFORT = 64;

const GPS_NO_OPLOCK = 128;

const GPS_PREFERQUERYPROPERTIES = 256;

/// Include properties from the file's secondary stream.
const GPS_EXTRINSICPROPERTIES = 512;

/// Include only properties from the file's secondary stream.
const GPS_EXTRINSICPROPERTIESONLY = 1024;

const GPS_VOLATILEPROPERTIES = 2048;

const GPS_VOLATILEPROPERTIESONLY = 4096;

/// Mask for valid <a
/// href="https://docs.microsoft.com/windows/desktop/api/propsys/ne-propsys-getpropertystoreflags">GETPROPERTYSTOREFLAGS</a>
/// values.
const GPS_MASK_VALID = 8191;

const GAA_FLAG_SKIP_UNICAST = 1;

const GAA_FLAG_SKIP_ANYCAST = 2;

const GAA_FLAG_SKIP_MULTICAST = 4;

const GAA_FLAG_SKIP_DNS_SERVER = 8;

const GAA_FLAG_INCLUDE_PREFIX = 16;

const GAA_FLAG_SKIP_FRIENDLY_NAME = 32;

const GAA_FLAG_INCLUDE_WINS_INFO = 64;

const GAA_FLAG_INCLUDE_GATEWAYS = 128;

const GAA_FLAG_INCLUDE_ALL_INTERFACES = GET_ADAPTERS_ADDRESSES_FLAGS(256);

const GAA_FLAG_INCLUDE_ALL_COMPARTMENTS = GET_ADAPTERS_ADDRESSES_FLAGS(512);

const GAA_FLAG_INCLUDE_TUNNEL_BINDINGORDER = GET_ADAPTERS_ADDRESSES_FLAGS(1024);

const GA_PARENT = 1;

const GA_ROOT = 2;

const GA_ROOTOWNER = 3;

const GCL_HICONSM = GET_CLASS_LONG_INDEX(-34);

const GCLP_HBRBACKGROUND = GET_CLASS_LONG_INDEX(-10);

const GCLP_HCURSOR = GET_CLASS_LONG_INDEX(-12);

const GCLP_HICON = GET_CLASS_LONG_INDEX(-14);

const GCLP_HICONSM = GET_CLASS_LONG_INDEX(-34);

const GCLP_HMODULE = GET_CLASS_LONG_INDEX(-16);

const GCLP_MENUNAME = GET_CLASS_LONG_INDEX(-8);

const GCLP_WNDPROC = GET_CLASS_LONG_INDEX(-24);

const DCX_WINDOW = 1;

const DCX_CACHE = 2;

const DCX_PARENTCLIP = 32;

const DCX_CLIPSIBLINGS = 16;

const DCX_CLIPCHILDREN = 8;

const DCX_NORESETATTRS = 4;

const DCX_LOCKWINDOWUPDATE = 1024;

const DCX_EXCLUDERGN = 64;

const DCX_INTERSECTRGN = 128;

const DCX_INTERSECTUPDATE = 512;

const DCX_VALIDATE = 2097152;

/// The <a
/// href="https://docs.microsoft.com/windows/desktop/api/fileapi/nf-fileapi-getfileattributesexa">GetFileAttributesEx</a>
/// or <a
/// href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileattributestransacteda">GetFileAttributesTransacted</a>
/// function retrieves a standard set of attribute information.
const GetFileExInfoStandard = 0;

/// One greater than the maximum value.
const GetFileExMaxInfoLevel = 1;

const GMDI_GOINTOPOPUPS = 2;

const GMDI_USEDISABLED = 1;

const GMMP_USE_DISPLAY_POINTS = 1;

const GMMP_USE_HIGH_RESOLUTION_POINTS = GET_MOUSE_MOVE_POINTS_EX_RESOLUTION(2);

const DC_BRUSH = 18;

const DC_PEN = 19;

const DEFAULT_GUI_FONT = 17;

const GMEM_MOVEABLE = 2;

const GUI_CARETBLINKING = 1;

const GUI_INMENUMODE = 4;

const GUI_INMOVESIZE = 2;

const GUI_POPUPMENUMODE = 16;

const GUI_SYSTEMMENUMODE = 8;

const HEAP_NONE = 0;

const HEAP_GROWABLE = 2;

const HEAP_TAIL_CHECKING_ENABLED = 32;

const HEAP_FREE_CHECKING_ENABLED = 64;

const HEAP_DISABLE_COALESCE_ON_FREE = 128;

const HEAP_CREATE_ALIGN_16 = 65536;

const HEAP_CREATE_ENABLE_TRACING = 131072;

const HEAP_MAXIMUM_TAG = 4095;

const HEAP_PSEUDO_TAG_FLAG = 32768;

const HEAP_TAG_SHIFT = 18;

const HEAP_CREATE_SEGMENT_HEAP = 256;

const HEAP_CREATE_HARDENED = 512;

/// The heap features that are enabled.
const HeapCompatibilityInformation = 0;

/// The terminate-on-corruption feature.
const HeapEnableTerminationOnCorruption = 1;

const HeapOptimizeResources = 3;

const HeapTag = 7;

const MOD_ALT = 1;

const MOD_CONTROL = 2;

const MOD_NOREPEAT = 16384;

const MOD_SHIFT = 4;

const MOD_WIN = 8;

const IDLFLAG_NONE = 0;

const IDLFLAG_FIN = 1;

const IDLFLAG_FOUT = 2;

const IDLFLAG_FLCID = 4;

const IDLFLAG_FRETVAL = 8;

/// The interface is up and operational.
const IfOperStatusUp = 1;

/// The interface is not down and not operational.
const IfOperStatusDown = 2;

/// The interface is being tested.
const IfOperStatusTesting = 3;

/// The interface status is unknown.
const IfOperStatusUnknown = 4;

/// The interface is not in a condition to pass packets.
const IfOperStatusDormant = 5;

/// This state is a refinement on the down state which indicates that the
/// interface is down specifically because some component (for example, a
/// hardware component) is not present in the system.
const IfOperStatusNotPresent = 6;

/// This state is a refinement on the down state.
const IfOperStatusLowerLayerDown = 7;

/// Turns off explicit updates to the last access time of a symbol that is
/// loaded.
const SYMOPT_EX_DISABLEACCESSTIMEUPDATE = 0;

const SYMOPT_EX_LASTVALIDDEBUGDIRECTORY = 1;

const SYMOPT_EX_NOIMPLICITPATTERNSEARCH = 2;

const SYMOPT_EX_NEVERLOADSYMBOLS = 3;

const SYMOPT_EX_MAX = 4;

const IMPLTYPEFLAG_FDEFAULT = 1;

const IMPLTYPEFLAG_FSOURCE = 2;

const IMPLTYPEFLAG_FRESTRICTED = 4;

const IMPLTYPEFLAG_FDEFAULTVTABLE = 8;

/// The member is called using a normal function invocation syntax.
const INVOKE_FUNC = 1;

/// The function is invoked using a normal property-access syntax.
const INVOKE_PROPERTYGET = 2;

/// The function is invoked using a property value assignment syntax.
const INVOKE_PROPERTYPUT = 4;

/// The function is invoked using a property reference assignment syntax.
const INVOKE_PROPERTYPUTREF = 8;

const JobObjectBasicAccountingInformation = 1;

const JobObjectBasicLimitInformation = 2;

const JobObjectBasicProcessIdList = 3;

const JobObjectBasicUIRestrictions = 4;

const JobObjectSecurityLimitInformation = 5;

const JobObjectEndOfJobTimeInformation = 6;

const JobObjectAssociateCompletionPortInformation = JOBOBJECTINFOCLASS(7);

const JobObjectBasicAndIoAccountingInformation = 8;

const JobObjectExtendedLimitInformation = 9;

const JobObjectJobSetInformation = 10;

const JobObjectGroupInformation = 11;

const JobObjectNotificationLimitInformation = 12;

const JobObjectLimitViolationInformation = 13;

const JobObjectGroupInformationEx = 14;

const JobObjectCpuRateControlInformation = 15;

const JobObjectCompletionFilter = 16;

const JobObjectCompletionCounter = 17;

const JobObjectReserved1Information = 18;

const JobObjectReserved2Information = 19;

const JobObjectReserved3Information = 20;

const JobObjectReserved4Information = 21;

const JobObjectReserved5Information = 22;

const JobObjectReserved6Information = 23;

const JobObjectReserved7Information = 24;

const JobObjectReserved8Information = 25;

const JobObjectReserved9Information = 26;

const JobObjectReserved10Information = 27;

const JobObjectReserved11Information = 28;

const JobObjectReserved12Information = 29;

const JobObjectReserved13Information = 30;

const JobObjectReserved14Information = 31;

const JobObjectNetRateControlInformation = 32;

const JobObjectNotificationLimitInformation2 = 33;

const JobObjectLimitViolationInformation2 = 34;

const JobObjectCreateSilo = 35;

const JobObjectSiloBasicInformation = 36;

const JobObjectReserved15Information = 37;

const JobObjectReserved16Information = 38;

const JobObjectReserved17Information = 39;

const JobObjectReserved18Information = 40;

const JobObjectReserved19Information = 41;

const JobObjectReserved20Information = 42;

const JobObjectReserved21Information = 43;

const JobObjectReserved22Information = 44;

const JobObjectReserved23Information = 45;

const JobObjectReserved24Information = 46;

const JobObjectReserved25Information = 47;

const JobObjectReserved26Information = 48;

const JobObjectReserved27Information = 49;

const MaxJobObjectInfoClass = 50;

const LOAD_LIBRARY_SEARCH_SYSTEM32_NO_FORWARDER = LOAD_LIBRARY_FLAGS(16384);

const LOCKFILE_EXCLUSIVE_LOCK = 2;

const LOCKFILE_FAIL_IMMEDIATELY = 1;

/// The specified logical processors share a single processor core.
const RelationProcessorCore = 0;

/// The specified logical processors are part of the same NUMA node.
const RelationNumaNode = 1;

/// The specified logical processors share a cache.
const RelationCache = 2;

/// The specified logical processors share a physical package (a single
/// package socketed or soldered onto a motherboard may contain multiple
/// processor cores or threads, each of which is treated as a separate
/// processor by the operating system).
const RelationProcessorPackage = 3;

/// The specified logical processors share a single <a
/// href="https://docs.microsoft.com/windows/desktop/ProcThread/processor-groups">processor
/// group</a>.
const RelationGroup = 4;

/// The specified logical processors share a single processor die.
const RelationProcessorDie = 5;

/// Requests that the full affinity be returned.
const RelationNumaNodeEx = 6;

const RelationProcessorModule = 7;

/// On input, retrieves information about all possible relationship types.
const RelationAll = 65535;

const Off = 0;

const Polite = 1;

const Assertive = 2;

/// The specified architecture of code can run in user mode.
const UserEnabled = 1;

/// The specified architecture of code can run in kernel mode.
const KernelEnabled = 2;

/// The specified architecture of code runs by relying on WOW64's namespace
/// `File System Redirector` and `Registry Redirector`.
const Wow64Container = 4;

const MAPVK_VK_TO_VSC = 0;

const MAPVK_VSC_TO_VK = 1;

const MAPVK_VK_TO_CHAR = 2;

const MAPVK_VSC_TO_VK_EX = 3;

const MAPVK_VK_TO_VSC_EX = 4;

/// Format is unknown
const Unknown = 0;

/// A 5.25" floppy, with 1.2MB and 512 bytes/sector.
const F5_1Pt2_512 = 1;

/// A 3.5" floppy, with 1.44MB and 512 bytes/sector.
const F3_1Pt44_512 = 2;

/// A 3.5" floppy, with 2.88MB and 512 bytes/sector.
const F3_2Pt88_512 = 3;

/// A 3.5" floppy, with 20.8MB and 512 bytes/sector.
const F3_20Pt8_512 = 4;

/// A 3.5" floppy, with 720KB and 512 bytes/sector.
const F3_720_512 = 5;

/// A 5.25" floppy, with 360KB and 512 bytes/sector.
const F5_360_512 = 6;

/// A 5.25" floppy, with 320KB and 512 bytes/sector.
const F5_320_512 = 7;

/// A 5.25" floppy, with 320KB and 1024 bytes/sector.
const F5_320_1024 = 8;

/// A 5.25" floppy, with 180KB and 512 bytes/sector.
const F5_180_512 = 9;

/// A 5.25" floppy, with 160KB and 512 bytes/sector.
const F5_160_512 = 10;

/// Removable media other than floppy.
const RemovableMedia = 11;

/// Fixed hard disk media.
const FixedMedia = 12;

/// A 3.5" floppy, with 120MB and 512 bytes/sector.
const F3_120M_512 = 13;

/// A 3.5" floppy, with 640KB and 512 bytes/sector.
const F3_640_512 = 14;

/// A 5.25" floppy, with 640KB and 512 bytes/sector.
const F5_640_512 = 15;

/// A 5.25" floppy, with 720KB and 512 bytes/sector.
const F5_720_512 = 16;

/// A 3.5" floppy, with 1.2MB and 512 bytes/sector.
const F3_1Pt2_512 = 17;

/// A 3.5" floppy, with 1.23MB and 1024 bytes/sector.
const F3_1Pt23_1024 = 18;

/// A 5.25" floppy, with 1.23MB and 1024 bytes/sector.
const F5_1Pt23_1024 = 19;

/// A 3.5" floppy, with 128MB and 512 bytes/sector.
const F3_128Mb_512 = 20;

/// A 3.5" floppy, with 230MB and 512 bytes/sector.
const F3_230Mb_512 = 21;

/// An 8" floppy, with 256KB and 128 bytes/sector.
const F8_256_128 = 22;

/// A 3.5" floppy, with 200MB and 512 bytes/sector.
const F3_200Mb_512 = 23;

/// A 3.5" floppy, with 240MB and 512 bytes/sector.
const F3_240M_512 = 24;

/// A 3.5" floppy, with 32MB and 512 bytes/sector.
const F3_32M_512 = 25;

const MIM_APPLYTOSUBMENUS = 2147483648;

const MIM_BACKGROUND = 2;

const MIM_HELPID = 4;

const MIM_MAXHEIGHT = 1;

const MIM_MENUDATA = 8;

const MIM_STYLE = 16;

const MNS_AUTODISMISS = 268435456;

const MNS_CHECKORBMP = 67108864;

const MNS_DRAGDROP = 536870912;

const MNS_MODELESS = 1073741824;

const MNS_NOCHECK = 2147483648;

const MNS_NOTIFYBYPOS = 134217728;

const MIIM_BITMAP = 128;

const MIIM_CHECKMARKS = 8;

const MIIM_DATA = 32;

const MIIM_FTYPE = 256;

const MIIM_ID = 2;

const MIIM_STATE = 1;

const MIIM_STRING = 64;

const MIIM_SUBMENU = 4;

const MIIM_TYPE = 16;

const MFS_GRAYED = 3;

const MFS_DISABLED = 3;

const MFS_CHECKED = 8;

const MFS_HILITE = 128;

const MFS_ENABLED = 0;

const MFS_UNCHECKED = 0;

const MFS_UNHILITE = 0;

const MFS_DEFAULT = 4096;

const MFT_BITMAP = 4;

const MFT_MENUBARBREAK = 32;

const MFT_MENUBREAK = 64;

const MFT_OWNERDRAW = 256;

const MFT_RADIOCHECK = 512;

const MFT_RIGHTJUSTIFY = 16384;

const MFT_RIGHTORDER = 8192;

const MFT_SEPARATOR = 2048;

const MFT_STRING = 0;

const IDASYNC = 32001;

const MB_USERICON = 128;

const MB_NOFOCUS = 32768;

const MB_SERVICE_NOTIFICATION_NT3X = 262144;

const MB_TYPEMASK = 15;

const MB_ICONMASK = 240;

const MB_DEFMASK = 3840;

const MB_MODEMASK = 12288;

const MB_MISCMASK = 49152;

const CALLBACK_TYPEMASK = 458752;

const CALLBACK_TASK = 131072;

const WAVE_FORMAT_DIRECT_QUERY = 9;

const MIDI_IO_STATUS = 32;

const DIALOPTION_BILLING = 64;

const DIALOPTION_DIALTONE = 256;

const DIALOPTION_QUIET = 128;

const MDMSPKRFLAG_CALLSETUP = 8;

const MDMSPKRFLAG_DIAL = 2;

const MDMSPKRFLAG_OFF = 1;

const MDMSPKRFLAG_ON = 4;

const MDMVOLFLAG_HIGH = 4;

const MDMVOLFLAG_LOW = 1;

const MDMVOLFLAG_MEDIUM = 2;

const MDMSPKR_CALLSETUP = 8;

const MDMSPKR_DIAL = 2;

const MDMSPKR_OFF = 1;

const MDMSPKR_ON = 4;

const MDMVOL_HIGH = 2;

const MDMVOL_LOW = 0;

const MDMVOL_MEDIUM = 1;

const MS_CTS_ON = 16;

const MS_DSR_ON = 32;

const MS_RING_ON = 64;

const MS_RLSD_ON = 128;

const DBHHEADER_DEBUGDIRS = 1;

const DBHHEADER_CVMISC = 2;

const MOUSE_MOVE_RELATIVE = 0;

const MOUSE_MOVE_ABSOLUTE = 1;

const MOUSE_VIRTUAL_DESKTOP = 2;

const MOUSE_ATTRIBUTES_CHANGED = 4;

const MOUSE_MOVE_NOCOALESCE = 8;

const MSGFLTINFO_NONE = 0;

const MSGFLTINFO_ALLOWED_HIGHER = 3;

const MSGFLTINFO_ALREADYALLOWED_FORWND = 1;

const MSGFLTINFO_ALREADYDISALLOWED_FORWND = 2;

const MWMO_NONE = 0;

const MWMO_ALERTABLE = 2;

const MWMO_INPUTAVAILABLE = 4;

const MWMO_WAITALL = 1;

/// Specifies the dedicated connection type.
const NET_IF_CONNECTION_DEDICATED = 1;

/// Specifies the passive connection type.
const NET_IF_CONNECTION_PASSIVE = 2;

/// Specifies the demand-dial connection type.
const NET_IF_CONNECTION_DEMAND = 3;

/// A maximum value for testing purposes.
const NET_IF_CONNECTION_MAXIMUM = 4;

/// The cost is unknown.
const NLM_CONNECTION_COST_UNKNOWN = 0;

/// The connection is unlimited and is considered to be unrestricted of usage
/// charges and capacity constraints.
const NLM_CONNECTION_COST_UNRESTRICTED = 1;

/// The use of this connection is unrestricted up to a specific data transfer
/// limit.
const NLM_CONNECTION_COST_FIXED = 2;

/// This connection is regulated on a per byte basis.
const NLM_CONNECTION_COST_VARIABLE = 4;

/// The connection is currently in an OverDataLimit state as it has exceeded
/// the carrier specified data transfer limit.
const NLM_CONNECTION_COST_OVERDATALIMIT = 65536;

/// The network is experiencing high traffic load and is congested.
const NLM_CONNECTION_COST_CONGESTED = 131072;

/// The connection is roaming outside the network and affiliates of the home
/// provider.
const NLM_CONNECTION_COST_ROAMING = 262144;

/// The connection is approaching the data limit specified by the carrier.
const NLM_CONNECTION_COST_APPROACHINGDATALIMIT = NLM_CONNECTION_COST(524288);

/// The Network is not an Active Directory Network.
const NLM_DOMAIN_TYPE_NON_DOMAIN_NETWORK = 0;

/// The Network is an Active Directory Network, but this machine is not
/// authenticated against it.
const NLM_DOMAIN_TYPE_DOMAIN_NETWORK = 1;

/// The Network is an Active Directory Network, and this machine is
/// authenticated against it.
const NLM_DOMAIN_TYPE_DOMAIN_AUTHENTICATED = 2;

/// The network is a public (untrusted) network.
const NLM_NETWORK_CATEGORY_PUBLIC = 0;

/// The network is a private (trusted) network.
const NLM_NETWORK_CATEGORY_PRIVATE = 1;

/// The network is authenticated against an Active Directory domain.
const NLM_NETWORK_CATEGORY_DOMAIN_AUTHENTICATED = NLM_NETWORK_CATEGORY(2);

const NldsInvalid = 0;

const NldsTentative = 1;

const NldsDuplicate = 2;

const NldsDeprecated = 3;

const NldsPreferred = 4;

/// The DAD state is invalid.
const IpDadStateInvalid = 0;

/// The DAD state is tentative.
const IpDadStateTentative = 1;

/// A duplicate IP address has been detected.
const IpDadStateDuplicate = 2;

/// The IP address has been deprecated.
const IpDadStateDeprecated = 3;

/// The IP address is the preferred address.
const IpDadStatePreferred = 4;

/// The IP prefix was provided by a source other than those defined in this
/// enumeration.
const IpPrefixOriginOther = 0;

/// The IP address prefix was manually specified.
const IpPrefixOriginManual = 1;

/// The IP address prefix is from a well known source.
const IpPrefixOriginWellKnown = 2;

/// The IP address prefix was provided by DHCP settings.
const IpPrefixOriginDhcp = 3;

/// The IP address prefix was obtained through a router advertisement (RA).
const IpPrefixOriginRouterAdvertisement = 4;

/// The IP address prefix should be unchanged.
const IpPrefixOriginUnchanged = 16;

const NlsoOther = 0;

const NlsoManual = 1;

const NlsoWellKnown = 2;

const NlsoDhcp = 3;

const NlsoLinkLayerAddress = 4;

const NlsoRandom = 5;

/// The IP address suffix was provided by a source other than those defined in
/// this enumeration.
const IpSuffixOriginOther = 0;

/// The IP address suffix was manually specified.
const IpSuffixOriginManual = 1;

/// The IP address suffix is from a well-known source.
const IpSuffixOriginWellKnown = 2;

/// The IP address suffix was provided by DHCP settings.
const IpSuffixOriginDhcp = 3;

/// The IP address suffix was obtained from the link-layer address.
const IpSuffixOriginLinkLayerAddress = 4;

/// The IP address suffix was obtained from a random source.
const IpSuffixOriginRandom = 5;

/// The IP address suffix should be unchanged.
const IpSuffixOriginUnchanged = 16;

/// The navigation direction is to the parent.
const NavigateDirection_Parent = 0;

/// The navigation direction is to the next sibling.
const NavigateDirection_NextSibling = 1;

/// The navigation direction is to the previous sibling.
const NavigateDirection_PreviousSibling = 2;

/// The navigation direction is to the first child.
const NavigateDirection_FirstChild = 3;

/// The navigation direction is to the last child.
const NavigateDirection_LastChild = 4;

const OBJID_WINDOW = 0;

const OBJID_SYSMENU = OBJECT_IDENTIFIER(-1);

const OBJID_TITLEBAR = OBJECT_IDENTIFIER(-2);

const OBJID_MENU = OBJECT_IDENTIFIER(-3);

const OBJID_CLIENT = OBJECT_IDENTIFIER(-4);

const OBJID_VSCROLL = OBJECT_IDENTIFIER(-5);

const OBJID_HSCROLL = OBJECT_IDENTIFIER(-6);

const OBJID_SIZEGRIP = OBJECT_IDENTIFIER(-7);

const OBJID_CARET = OBJECT_IDENTIFIER(-8);

const OBJID_CURSOR = OBJECT_IDENTIFIER(-9);

const OBJID_ALERT = OBJECT_IDENTIFIER(-10);

const OBJID_SOUND = OBJECT_IDENTIFIER(-11);

const OBJID_QUERYCLASSNAMEIDX = OBJECT_IDENTIFIER(-12);

const OBJID_NATIVEOM = OBJECT_IDENTIFIER(-16);

const ATTRIBUTE_SECURITY_INFORMATION = 32;

const BACKUP_SECURITY_INFORMATION = 65536;

const DACL_SECURITY_INFORMATION = 4;

const GROUP_SECURITY_INFORMATION = 2;

const LABEL_SECURITY_INFORMATION = 16;

const OWNER_SECURITY_INFORMATION = 1;

const PROTECTED_DACL_SECURITY_INFORMATION = OBJECT_SECURITY_INFORMATION(
  2147483648,
);

const PROTECTED_SACL_SECURITY_INFORMATION = OBJECT_SECURITY_INFORMATION(
  1073741824,
);

const SACL_SECURITY_INFORMATION = 8;

const SCOPE_SECURITY_INFORMATION = 64;

const UNPROTECTED_DACL_SECURITY_INFORMATION = OBJECT_SECURITY_INFORMATION(
  536870912,
);

const UNPROTECTED_SACL_SECURITY_INFORMATION = OBJECT_SECURITY_INFORMATION(
  268435456,
);

const OFN_EX_NONE = 0;

const OTD_FORCE_RECT_SIZING = 1;

const OTD_NONCLIENT = 2;

/// The process has no device orientation preferences.
const ORIENTATION_PREFERENCE_NONE = 0;

/// The process represents a desktop app that can be used in landscape mode.
const ORIENTATION_PREFERENCE_LANDSCAPE = 1;

/// The process represents a desktop app that can be used in portrait mode.
const ORIENTATION_PREFERENCE_PORTRAIT = 2;

/// The process represents a desktop app that can be used in flipped landscape
/// mode.
const ORIENTATION_PREFERENCE_LANDSCAPE_FLIPPED = ORIENTATION_PREFERENCE(4);

/// The process represents a desktop app that can be used in flipped portrait
/// mode.
const ORIENTATION_PREFERENCE_PORTRAIT_FLIPPED = ORIENTATION_PREFERENCE(8);

const PRODUCT_IOTUAPCOMMERCIAL = 131;

const PRODUCT_MOBILE_CORE = 104;

const PRODUCT_MOBILE_ENTERPRISE = 133;

const PRODUCT_STANDARD_SERVER_CORE_ = 13;

/// The control has no orientation.
const OrientationType_None = 0;

/// The control has horizontal orientation.
const OrientationType_Horizontal = 1;

/// The control has vertical orientation.
const OrientationType_Vertical = 2;

const PAGE_GRAPHICS_NOCACHE = 262144;

const PAGE_ENCLAVE_MASK = 268435456;

const PAGE_ENCLAVE_SS_FIRST = 268435457;

const PAGE_ENCLAVE_SS_REST = 268435458;

const SEC_PARTITION_OWNER_HANDLE = 262144;

const SEC_64K_PAGES = 524288;

const SEC_FILE = 8388608;

const SEC_IMAGE = 16777216;

const SEC_PROTECTED_IMAGE = 33554432;

const SEC_RESERVE = 67108864;

const SEC_COMMIT = 134217728;

const SEC_NOCACHE = 268435456;

const SEC_WRITECOMBINE = 1073741824;

const SEC_LARGE_PAGES = 2147483648;

const SEC_IMAGE_NO_EXECUTE = 285212672;

const PARAMFLAG_NONE = 0;

const PARAMFLAG_FIN = 1;

const PARAMFLAG_FOUT = 2;

const PARAMFLAG_FLCID = 4;

const PARAMFLAG_FRETVAL = 8;

const PARAMFLAG_FOPT = 16;

const PARAMFLAG_FHASDEFAULT = 32;

const PARAMFLAG_FHASCUSTDATA = 64;

const PM_QS_INPUT = 67567616;

const PM_QS_POSTMESSAGE = 9961472;

const PM_QS_PAINT = 2097152;

const PM_QS_SENDMESSAGE = 4194304;

/// No change in button state.
const POINTER_CHANGE_NONE = 0;

/// The first button (see <a
/// href="https://docs.microsoft.com/windows/win32/inputmsg/pointer-flags-contants">POINTER_FLAG_FIRSTBUTTON</a>)
/// transitioned to a pressed state.
const POINTER_CHANGE_FIRSTBUTTON_DOWN = 1;

/// The first button (see <a
/// href="https://docs.microsoft.com/windows/win32/inputmsg/pointer-flags-contants">POINTER_FLAG_FIRSTBUTTON</a>)
/// transitioned to a released state.
const POINTER_CHANGE_FIRSTBUTTON_UP = 2;

/// The second button (see <a
/// href="https://docs.microsoft.com/windows/win32/inputmsg/pointer-flags-contants">POINTER_FLAG_SECONDBUTTON</a>)
/// transitioned to a pressed state.
const POINTER_CHANGE_SECONDBUTTON_DOWN = 3;

/// The second button (see <a
/// href="https://docs.microsoft.com/windows/win32/inputmsg/pointer-flags-contants">POINTER_FLAG_SECONDBUTTON</a>)
/// transitioned to a released state.
const POINTER_CHANGE_SECONDBUTTON_UP = 4;

/// The third button (see <a
/// href="https://docs.microsoft.com/windows/win32/inputmsg/pointer-flags-contants">POINTER_FLAG_THIRDBUTTON</a>)
/// transitioned to a pressed state.
const POINTER_CHANGE_THIRDBUTTON_DOWN = 5;

/// The third button (see <a
/// href="https://docs.microsoft.com/windows/win32/inputmsg/pointer-flags-contants">POINTER_FLAG_THIRDBUTTON</a>)
/// transitioned to a released state.
const POINTER_CHANGE_THIRDBUTTON_UP = 6;

/// The fourth button (see <a
/// href="https://docs.microsoft.com/windows/win32/inputmsg/pointer-flags-contants">POINTER_FLAG_FOURTHBUTTON</a>)
/// transitioned to a pressed state.
const POINTER_CHANGE_FOURTHBUTTON_DOWN = 7;

/// The fourth button (see <a
/// href="https://docs.microsoft.com/windows/win32/inputmsg/pointer-flags-contants">POINTER_FLAG_FOURTHBUTTON</a>)
/// transitioned to a released state.
const POINTER_CHANGE_FOURTHBUTTON_UP = 8;

/// The fifth button (see <a
/// href="https://docs.microsoft.com/windows/win32/inputmsg/pointer-flags-contants">POINTER_FLAG_FIFTHBUTTON</a>)
/// transitioned to a pressed state.
const POINTER_CHANGE_FIFTHBUTTON_DOWN = 9;

/// The fifth button (see <a
/// href="https://docs.microsoft.com/windows/win32/inputmsg/pointer-flags-contants">POINTER_FLAG_FIFTHBUTTON</a>)
/// transitioned to a released state.
const POINTER_CHANGE_FIFTHBUTTON_UP = 10;

const POINTER_FLAG_NONE = 0;

const POINTER_FLAG_NEW = 1;

const POINTER_FLAG_INRANGE = 2;

const POINTER_FLAG_INCONTACT = 4;

const POINTER_FLAG_FIRSTBUTTON = 16;

const POINTER_FLAG_SECONDBUTTON = 32;

const POINTER_FLAG_THIRDBUTTON = 64;

const POINTER_FLAG_FOURTHBUTTON = 128;

const POINTER_FLAG_FIFTHBUTTON = 256;

const POINTER_FLAG_PRIMARY = 8192;

const POINTER_FLAG_CONFIDENCE = 16384;

const POINTER_FLAG_CANCELED = 32768;

const POINTER_FLAG_DOWN = 65536;

const POINTER_FLAG_UPDATE = 131072;

const POINTER_FLAG_UP = 262144;

const POINTER_FLAG_WHEEL = 524288;

const POINTER_FLAG_HWHEEL = 1048576;

const POINTER_FLAG_CAPTURECHANGED = 2097152;

const POINTER_FLAG_HASTRANSFORM = 4194304;

const PT_POINTER = 1;

const PT_TOUCH = 2;

const PT_PEN = 3;

const PT_MOUSE = 4;

const PT_TOUCHPAD = 5;

const PRINTER_ALL_ACCESS = 983052;

const PRINTER_READ = 131080;

const PRINTER_WRITE = 131080;

const PRINTER_EXECUTE = 131080;

const SERVER_ALL_ACCESS = 983043;

const SERVER_READ = 131074;

const SERVER_WRITE = 131075;

const SERVER_EXECUTE = 131074;

const PRINTER_DELETE = 65536;

const PRINTER_READ_CONTROL = 131072;

const PRINTER_WRITE_DAC = 262144;

const PRINTER_WRITE_OWNER = 524288;

const PRINTER_SYNCHRONIZE = 1048576;

const PRINTER_STANDARD_RIGHTS_REQUIRED = 983040;

const PRINTER_STANDARD_RIGHTS_READ = 131072;

const PRINTER_STANDARD_RIGHTS_WRITE = 131072;

const PRINTER_STANDARD_RIGHTS_EXECUTE = 131072;

const SERVER_ACCESS_ADMINISTER = 1;

const SERVER_ACCESS_ENUMERATE = 2;

const PRINTER_ACCESS_ADMINISTER = 4;

const PRINTER_ACCESS_USE = 8;

const PRINTER_ACCESS_MANAGE_LIMITED = 64;

const PRINT_EXECUTION_CONTEXT_APPLICATION = 0;

const PRINT_EXECUTION_CONTEXT_SPOOLER_SERVICE = PRINT_EXECUTION_CONTEXT(1);

const PRINT_EXECUTION_CONTEXT_SPOOLER_ISOLATION_HOST = PRINT_EXECUTION_CONTEXT(
  2,
);

const PRINT_EXECUTION_CONTEXT_FILTER_PIPELINE = PRINT_EXECUTION_CONTEXT(3);

const PRINT_EXECUTION_CONTEXT_WOW64 = 4;

const PW_CLIENTONLY = 1;

/// The cache is unified.
const CacheUnified = 0;

/// The cache is for processor instructions.
const CacheInstruction = 1;

/// The cache is for data.
const CacheData = 2;

/// The cache is for traces.
const CacheTrace = 3;

const PROCESS_DELETE = 65536;

const PROCESS_READ_CONTROL = 131072;

const PROCESS_WRITE_DAC = 262144;

const PROCESS_WRITE_OWNER = 524288;

const PROCESS_SYNCHRONIZE = 1048576;

const PROCESS_STANDARD_RIGHTS_REQUIRED = 983040;

const PROCESS_NAME_WIN32 = 0;

const PROCESS_NAME_NATIVE = 1;

const PRSPEC_LPWSTR = 0;

const PRSPEC_PROPID = 1;

const RDW_INVALIDATE = 1;

const RDW_INTERNALPAINT = 2;

const RDW_ERASE = 4;

const RDW_VALIDATE = 8;

const RDW_NOINTERNALPAINT = 16;

const RDW_NOERASE = 32;

const RDW_NOCHILDREN = 64;

const RDW_ALLCHILDREN = 128;

const RDW_UPDATENOW = 256;

const RDW_ERASENOW = 512;

const RDW_FRAME = 1024;

const RDW_NOFRAME = 2048;

const DEVICE_NOTIFY_CALLBACK = 2;

const DEVICE_NOTIFY_ALL_INTERFACE_CLASSES = REGISTER_NOTIFICATION_FLAGS(4);

const TWF_FINETOUCH = 1;

const TWF_WANTPALM = 2;

const REG_CREATED_NEW_KEY = 1;

const REG_OPENED_EXISTING_KEY = 2;

const REG_OPTION_RESERVED = 0;

const REG_OPTION_NON_VOLATILE = 0;

const REG_OPTION_VOLATILE = 1;

const REG_OPTION_CREATE_LINK = 2;

const REG_OPTION_BACKUP_RESTORE = 4;

const REG_OPTION_OPEN_LINK = 8;

const REG_OPTION_DONT_VIRTUALIZE = 16;

const KEY_WOW64_RES = 768;

const REG_STANDARD_FORMAT = 1;

const REG_LATEST_FORMAT = 2;

const REG_NO_COMPRESSION = 4;

const REG_RESOURCE_LIST = 8;

const REG_FULL_RESOURCE_DESCRIPTOR = 9;

const REG_RESOURCE_REQUIREMENTS_LIST = 10;

const RGN_AND = 1;

const RGN_OR = 2;

const RGN_XOR = 3;

const RGN_DIFF = 4;

const RGN_COPY = 5;

const RGN_MIN = 1;

const RGN_MAX = 5;

const RIM_TYPEMOUSE = 0;

const RIM_TYPEKEYBOARD = 1;

const RIM_TYPEHID = 2;

const ROTFLAGS_REGISTRATIONKEEPSALIVE = 1;

const ROTFLAGS_ALLOWANYCLIENT = 2;

/// Data in the table should be read row by row.
const RowOrColumnMajor_RowMajor = 0;

/// Data in the table should be read column by column.
const RowOrColumnMajor_ColumnMajor = 1;

/// The best way to present the data is indeterminate.
const RowOrColumnMajor_Indeterminate = 2;

const SCARD_STATE_UNAWARE = 0;

const SCARD_STATE_IGNORE = 1;

const SCARD_STATE_UNAVAILABLE = 8;

const SCARD_STATE_EMPTY = 16;

const SCARD_STATE_PRESENT = 32;

const SCARD_STATE_ATRMATCH = 64;

const SCARD_STATE_EXCLUSIVE = 128;

const SCARD_STATE_INUSE = 256;

const SCARD_STATE_MUTE = 512;

const SCARD_STATE_CHANGED = 2;

const SCARD_STATE_UNKNOWN = 4;

const SW_SCROLLCHILDREN = 1;

const SW_INVALIDATE = 2;

const SW_ERASE = 4;

const SW_SMOOTHSCROLL = 16;

const SC_ACTION_NONE = 0;

const SC_ACTION_RESTART = 1;

const SC_ACTION_REBOOT = 2;

const SC_ACTION_RUN_COMMAND = 3;

const SC_ACTION_OWN_RESTART = 4;

const SC_ENUM_PROCESS_INFO = 0;

const SC_STATUS_PROCESS_INFO = 0;

const SDP_ST_NONE = 0;

const SDP_ST_UINT8 = 16;

const SDP_ST_UINT16 = 272;

const SDP_ST_UINT32 = 528;

const SDP_ST_UINT64 = 784;

const SDP_ST_UINT128 = 1040;

const SDP_ST_INT8 = 32;

const SDP_ST_INT16 = 288;

const SDP_ST_INT32 = 544;

const SDP_ST_INT64 = 800;

const SDP_ST_INT128 = 1056;

const SDP_ST_UUID16 = 304;

const SDP_ST_UUID32 = 544;

const SDP_ST_UUID128 = 1072;

const SDP_TYPE_NIL = 0;

const SDP_TYPE_UINT = 1;

const SDP_TYPE_INT = 2;

const SDP_TYPE_UUID = 3;

const SDP_TYPE_STRING = 4;

const SDP_TYPE_BOOLEAN = 5;

const SDP_TYPE_SEQUENCE = 6;

const SDP_TYPE_ALTERNATIVE = 7;

const SDP_TYPE_URL = 8;

const SDP_TYPE_CONTAINER = 32;

const SE_OWNER_DEFAULTED = 1;

const SE_GROUP_DEFAULTED = 2;

const SE_DACL_PRESENT = 4;

const SE_DACL_DEFAULTED = 8;

const SE_SACL_PRESENT = 16;

const SE_SACL_DEFAULTED = 32;

const SE_DACL_AUTO_INHERIT_REQ = 256;

const SE_SACL_AUTO_INHERIT_REQ = 512;

const SE_DACL_AUTO_INHERITED = 1024;

const SE_SACL_AUTO_INHERITED = 2048;

const SE_DACL_PROTECTED = 4096;

const SE_SACL_PROTECTED = 8192;

const SE_RM_CONTROL_VALID = 16384;

const SE_SELF_RELATIVE = 32768;

const MSG_OOB = 1;

const MSG_PEEK = 2;

const MSG_DONTROUTE = 4;

const MSG_WAITALL = 8;

const MSG_PUSH_IMMEDIATE = 32;

const SERVICE_CONFIG_DELAYED_AUTO_START_INFO = 3;

const SERVICE_CONFIG_DESCRIPTION = 1;

const SERVICE_CONFIG_FAILURE_ACTIONS = 2;

const SERVICE_CONFIG_FAILURE_ACTIONS_FLAG = 4;

const SERVICE_CONFIG_PREFERRED_NODE = 9;

const SERVICE_CONFIG_PRESHUTDOWN_INFO = 7;

const SERVICE_CONFIG_REQUIRED_PRIVILEGES_INFO = 6;

const SERVICE_CONFIG_SERVICE_SID_INFO = 5;

const SERVICE_CONFIG_TRIGGER_INFO = 8;

const SERVICE_CONFIG_LAUNCH_PROTECTED = 12;

/// Mutable, persistent service state.
const ServiceDirectoryPersistentState = 0;

/// Reserved.
const ServiceDirectoryTypeMax = 1;

const SERVICE_ERROR_CRITICAL = 3;

const SERVICE_ERROR_IGNORE = 0;

const SERVICE_ERROR_NORMAL = 1;

const SERVICE_ERROR_SEVERE = 2;

const SERVICE_NOTIFY_CREATED = 128;

const SERVICE_NOTIFY_CONTINUE_PENDING = 16;

const SERVICE_NOTIFY_DELETE_PENDING = 512;

const SERVICE_NOTIFY_DELETED = 256;

const SERVICE_NOTIFY_PAUSE_PENDING = 32;

const SERVICE_NOTIFY_PAUSED = 64;

const SERVICE_NOTIFY_RUNNING = 8;

const SERVICE_NOTIFY_START_PENDING = 2;

const SERVICE_NOTIFY_STOP_PENDING = 4;

const SERVICE_NOTIFY_STOPPED = 1;

/// Immutable service state, populated by INF to the Parameters subkey.
const ServiceRegistryStateParameters = 0;

/// Mutable, persistent service state.
const ServiceRegistryStatePersistent = 1;

/// Reserved.
const MaxServiceRegistryStateType = 2;

const SERVICE_RUNS_IN_NON_SYSTEM_OR_NOT_RUNNING = SERVICE_RUNS_IN_PROCESS(0);

const SERVICE_RUNS_IN_SYSTEM_PROCESS = 1;

/// Mutable, persistent service state.
const ServiceSharedDirectoryPersistentState = SERVICE_SHARED_DIRECTORY_TYPE(0);

/// Mutable, persistent service state.
const ServiceSharedRegistryPersistentState = SERVICE_SHARED_REGISTRY_STATE_TYPE(
  0,
);

const SERVICE_AUTO_START = 2;

const SERVICE_BOOT_START = 0;

const SERVICE_DEMAND_START = 3;

const SERVICE_DISABLED = 4;

const SERVICE_SYSTEM_START = 1;

const SERVICE_CONTINUE_PENDING = 5;

const SERVICE_PAUSE_PENDING = 6;

const SERVICE_PAUSED = 7;

const SERVICE_RUNNING = 4;

const SERVICE_START_PENDING = 2;

const SERVICE_STOP_PENDING = 3;

const SERVICE_STOPPED = 1;

const SERVICE_TRIGGER_ACTION_SERVICE_START = 1;

const SERVICE_TRIGGER_ACTION_SERVICE_STOP = 2;

const SERVICE_TRIGGER_DATA_TYPE_BINARY =
    SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_DATA_TYPE(1);

const SERVICE_TRIGGER_DATA_TYPE_STRING =
    SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_DATA_TYPE(2);

const SERVICE_TRIGGER_DATA_TYPE_LEVEL =
    SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_DATA_TYPE(3);

const SERVICE_TRIGGER_DATA_TYPE_KEYWORD_ANY =
    SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_DATA_TYPE(4);

const SERVICE_TRIGGER_DATA_TYPE_KEYWORD_ALL =
    SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_DATA_TYPE(5);

const SERVICE_TRIGGER_TYPE_CUSTOM = 20;

const SERVICE_TRIGGER_TYPE_DEVICE_INTERFACE_ARRIVAL = SERVICE_TRIGGER_TYPE(1);

const SERVICE_TRIGGER_TYPE_DOMAIN_JOIN = 3;

const SERVICE_TRIGGER_TYPE_FIREWALL_PORT_EVENT = SERVICE_TRIGGER_TYPE(4);

const SERVICE_TRIGGER_TYPE_GROUP_POLICY = 5;

const SERVICE_TRIGGER_TYPE_IP_ADDRESS_AVAILABILITY = SERVICE_TRIGGER_TYPE(2);

const SERVICE_TRIGGER_TYPE_NETWORK_ENDPOINT = 6;

const DIGCF_INTERFACEDEVICE = 16;

const SPDRP_UNUSED0 = 3;

const SPDRP_UNUSED1 = 5;

const SPDRP_UNUSED2 = 6;

const SPDRP_BASE_CONTAINERID = 36;

const SPDRP_MAXIMUM_PROPERTY = 37;

const FILE_BEGIN = 0;

const FILE_CURRENT = 1;

const FILE_END = 2;

const ALLOW_NONCLIENT = 1;

const ALLOW_CONTROLS = 2;

const ALLOW_WEBCONTENT = 4;

const VALIDBITS = 7;

const SFGAO_CANCOPY = 1;

const SFGAO_CANMOVE = 2;

const SFGAO_CANLINK = 4;

const SFGAO_STORAGE = 8;

const SFGAO_CANRENAME = 16;

const SFGAO_CANDELETE = 32;

const SFGAO_HASPROPSHEET = 64;

const SFGAO_DROPTARGET = 256;

const SFGAO_CAPABILITYMASK = 375;

const SFGAO_PLACEHOLDER = 2048;

const SFGAO_SYSTEM = 4096;

const SFGAO_ENCRYPTED = 8192;

const SFGAO_ISSLOW = 16384;

const SFGAO_GHOSTED = 32768;

const SFGAO_LINK = 65536;

const SFGAO_SHARE = 131072;

const SFGAO_READONLY = 262144;

const SFGAO_HIDDEN = 524288;

const SFGAO_DISPLAYATTRMASK = 1032192;

const SFGAO_FILESYSANCESTOR = 268435456;

const SFGAO_FOLDER = 536870912;

const SFGAO_FILESYSTEM = 1073741824;

const SFGAO_HASSUBFOLDER = 2147483648;

const SFGAO_CONTENTSMASK = 2147483648;

const SFGAO_VALIDATE = 16777216;

const SFGAO_REMOVABLE = 33554432;

const SFGAO_COMPRESSED = 67108864;

const SFGAO_BROWSABLE = 134217728;

const SFGAO_NONENUMERATED = 1048576;

const SFGAO_NEWCONTENT = 2097152;

const SFGAO_CANMONIKER = 4194304;

const SFGAO_HASSTORAGE = 4194304;

const SFGAO_STREAM = 4194304;

const SFGAO_STORAGEANCESTOR = 8388608;

const SFGAO_STORAGECAPMASK = 1891958792;

const SFGAO_PKEYSFGAOMASK = 2164539392;

const SHGDN_NORMAL = 0;

const SHGDN_INFOLDER = 1;

const SHGDN_FOREDITING = 4096;

const SHGDN_FORADDRESSBAR = 16384;

const SHGDN_FORPARSING = 32768;

const SHGFI_ADDOVERLAYS = 32;

const SHGFI_ATTR_SPECIFIED = 131072;

const SHGFI_ATTRIBUTES = 2048;

const SHGFI_DISPLAYNAME = 512;

const SHGFI_EXETYPE = 8192;

const SHGFI_ICON = 256;

const SHGFI_ICONLOCATION = 4096;

const SHGFI_LARGEICON = 0;

const SHGFI_LINKOVERLAY = 32768;

const SHGFI_OPENICON = 2;

const SHGFI_OVERLAYINDEX = 64;

const SHGFI_PIDL = 8;

const SHGFI_SELECTED = 65536;

const SHGFI_SHELLICONSIZE = 4;

const SHGFI_SMALLICON = 1;

const SHGFI_SYSICONINDEX = 16384;

const SHGFI_TYPENAME = 1024;

const SHGFI_USEFILEATTRIBUTES = 16;

const SW_MAX = 11;

const SHUTDOWN_SKIP_SVC_PRESHUTDOWN = 256;

const SHUTDOWN_RESTART_BOOTOPTIONS = 1024;

const SHUTDOWN_SOFT_REBOOT = 2048;

const SHUTDOWN_MOBILE_UI = 4096;

const SHUTDOWN_ARSO = 8192;

const SHUTDOWN_CHECK_SAFE_FOR_SERVER = 16384;

const SHUTDOWN_VAIL_CONTAINER = 32768;

const SHUTDOWN_SYSTEM_INITIATED = 65536;

const SHTDN_REASON_NONE = 0;

const SHTDN_REASON_FLAG_COMMENT_REQUIRED = 16777216;

const SHTDN_REASON_FLAG_DIRTY_PROBLEM_ID_REQUIRED = SHUTDOWN_REASON(33554432);

const SHTDN_REASON_FLAG_CLEAN_UI = 67108864;

const SHTDN_REASON_FLAG_DIRTY_UI = 134217728;

const SHTDN_REASON_FLAG_MOBILE_UI_RESERVED = SHUTDOWN_REASON(268435456);

const SHTDN_REASON_FLAG_USER_DEFINED = 1073741824;

const SHTDN_REASON_FLAG_PLANNED = 2147483648;

const SHTDN_REASON_MAJOR_OTHER = 0;

const SHTDN_REASON_MAJOR_NONE = 0;

const SHTDN_REASON_MAJOR_HARDWARE = 65536;

const SHTDN_REASON_MAJOR_OPERATINGSYSTEM = 131072;

const SHTDN_REASON_MAJOR_SOFTWARE = 196608;

const SHTDN_REASON_MAJOR_APPLICATION = 262144;

const SHTDN_REASON_MAJOR_SYSTEM = 327680;

const SHTDN_REASON_MAJOR_POWER = 393216;

const SHTDN_REASON_MAJOR_LEGACY_API = 458752;

const SHTDN_REASON_MINOR_OTHER = 0;

const SHTDN_REASON_MINOR_NONE = 255;

const SHTDN_REASON_MINOR_MAINTENANCE = 1;

const SHTDN_REASON_MINOR_INSTALLATION = 2;

const SHTDN_REASON_MINOR_UPGRADE = 3;

const SHTDN_REASON_MINOR_RECONFIG = 4;

const SHTDN_REASON_MINOR_HUNG = 5;

const SHTDN_REASON_MINOR_UNSTABLE = 6;

const SHTDN_REASON_MINOR_DISK = 7;

const SHTDN_REASON_MINOR_PROCESSOR = 8;

const SHTDN_REASON_MINOR_NETWORKCARD = 9;

const SHTDN_REASON_MINOR_POWER_SUPPLY = 10;

const SHTDN_REASON_MINOR_CORDUNPLUGGED = 11;

const SHTDN_REASON_MINOR_ENVIRONMENT = 12;

const SHTDN_REASON_MINOR_HARDWARE_DRIVER = 13;

const SHTDN_REASON_MINOR_OTHERDRIVER = 14;

const SHTDN_REASON_MINOR_BLUESCREEN = 15;

const SHTDN_REASON_MINOR_SERVICEPACK = 16;

const SHTDN_REASON_MINOR_HOTFIX = 17;

const SHTDN_REASON_MINOR_SECURITYFIX = 18;

const SHTDN_REASON_MINOR_SECURITY = 19;

const SHTDN_REASON_MINOR_NETWORK_CONNECTIVITY = 20;

const SHTDN_REASON_MINOR_WMI = 21;

const SHTDN_REASON_MINOR_SERVICEPACK_UNINSTALL = 22;

const SHTDN_REASON_MINOR_HOTFIX_UNINSTALL = 23;

const SHTDN_REASON_MINOR_SECURITYFIX_UNINSTALL = 24;

const SHTDN_REASON_MINOR_MMC = 25;

const SHTDN_REASON_MINOR_SYSTEMRESTORE = 26;

const SHTDN_REASON_MINOR_TERMSRV = 32;

const SHTDN_REASON_MINOR_DC_PROMOTION = 33;

const SHTDN_REASON_MINOR_DC_DEMOTION = 34;

const SHTDN_REASON_UNKNOWN = 255;

const SHTDN_REASON_LEGACY_API = 2147942400;

const SHTDN_REASON_VALID_BIT_MASK = 3238002687;

const SIATTRIBFLAGS_AND = 1;

const SIATTRIBFLAGS_OR = 2;

const SIATTRIBFLAGS_APPCOMPAT = 3;

const SIATTRIBFLAGS_MASK = 3;

const SIATTRIBFLAGS_ALLITEMS = 16384;

const SIIGBF_RESIZETOFIT = 0;

const SIIGBF_BIGGERSIZEOK = 1;

const SIIGBF_MEMORYONLY = 2;

const SIIGBF_ICONONLY = 4;

const SIIGBF_THUMBNAILONLY = 8;

const SIIGBF_INCACHEONLY = 16;

const SIIGBF_CROPTOSQUARE = 32;

const SIIGBF_WIDETHUMBNAILS = 64;

const SIIGBF_ICONBACKGROUND = 128;

const SIIGBF_SCALEUP = 256;

const SPEI_UNDEFINED = 0;

const SPEI_START_INPUT_STREAM = 1;

const SPEI_END_INPUT_STREAM = 2;

const SPEI_VOICE_CHANGE = 3;

const SPEI_TTS_BOOKMARK = 4;

const SPEI_WORD_BOUNDARY = 5;

const SPEI_PHONEME = 6;

const SPEI_SENTENCE_BOUNDARY = 7;

const SPEI_VISEME = 8;

const SPEI_TTS_AUDIO_LEVEL = 9;

const SPEI_TTS_PRIVATE = 15;

const SPEI_MIN_TTS = 1;

const SPEI_MAX_TTS = 15;

const SPEI_END_SR_STREAM = 34;

const SPEI_SOUND_START = 35;

const SPEI_SOUND_END = 36;

const SPEI_PHRASE_START = 37;

const SPEI_RECOGNITION = 38;

const SPEI_HYPOTHESIS = 39;

const SPEI_SR_BOOKMARK = 40;

const SPEI_PROPERTY_NUM_CHANGE = 41;

const SPEI_PROPERTY_STRING_CHANGE = 42;

const SPEI_FALSE_RECOGNITION = 43;

const SPEI_INTERFERENCE = 44;

const SPEI_REQUEST_UI = 45;

const SPEI_RECO_STATE_CHANGE = 46;

const SPEI_ADAPTATION = 47;

const SPEI_START_SR_STREAM = 48;

const SPEI_RECO_OTHER_CONTEXT = 49;

const SPEI_SR_AUDIO_LEVEL = 50;

const SPEI_SR_RETAINEDAUDIO = 51;

const SPEI_SR_PRIVATE = 52;

const SPEI_RESERVED4 = 53;

const SPEI_RESERVED5 = 54;

const SPEI_RESERVED6 = 55;

const SPEI_MIN_SR = 34;

const SPEI_MAX_SR = 55;

const SPEI_RESERVED1 = 30;

const SPEI_RESERVED2 = 33;

const SPEI_RESERVED3 = 63;

const SP_VISEME_0 = 0;

const SP_VISEME_1 = 1;

const SP_VISEME_2 = 2;

const SP_VISEME_3 = 3;

const SP_VISEME_4 = 4;

const SP_VISEME_5 = 5;

const SP_VISEME_6 = 6;

const SP_VISEME_7 = 7;

const SP_VISEME_8 = 8;

const SP_VISEME_9 = 9;

const SP_VISEME_10 = 10;

const SP_VISEME_11 = 11;

const SP_VISEME_12 = 12;

const SP_VISEME_13 = 13;

const SP_VISEME_14 = 14;

const SP_VISEME_15 = 15;

const SP_VISEME_16 = 16;

const SP_VISEME_17 = 17;

const SP_VISEME_18 = 18;

const SP_VISEME_19 = 19;

const SP_VISEME_20 = 20;

const SP_VISEME_21 = 21;

const SPVPRI_NORMAL = 0;

const SPVPRI_ALERT = 1;

const SPVPRI_OVER = 2;

/// The <a
/// href="https://docs.microsoft.com/windows/desktop/api/fileapi/nf-fileapi-findfirststreamw">FindFirstStreamW</a>
/// function retrieves standard stream information.
const FindStreamInfoStandard = 0;

/// Used to determine valid enumeration values.
const FindStreamInfoMaxInfoLevel = 1;

/// The new seek pointer is an offset relative to the beginning of the stream.
const STREAM_SEEK_SET = 0;

/// The new seek pointer is an offset relative to the current seek pointer
/// location.
const STREAM_SEEK_CUR = 1;

/// The new seek pointer is an offset relative to the end of the stream.
const STREAM_SEEK_END = 2;

const SLMFLAG_NONE = 0;

const SLMFLAG_VIRTUAL = 1;

const SLMFLAG_ALT_INDEX = 2;

const SLMFLAG_NO_SYMBOLS = 4;

const EVENT_ALL_ACCESS = 2031619;

const EVENT_MODIFY_STATE = 2;

const MUTEX_ALL_ACCESS = 2031617;

const MUTEX_MODIFY_STATE = 1;

const SEMAPHORE_ALL_ACCESS = 2031619;

const SEMAPHORE_MODIFY_STATE = 2;

const TIMER_ALL_ACCESS = 2031619;

const TIMER_MODIFY_STATE = 2;

const TIMER_QUERY_STATE = 1;

const SYNCHRONIZATION_DELETE = 65536;

const SYNCHRONIZATION_READ_CONTROL = SYNCHRONIZATION_ACCESS_RIGHTS(131072);

const SYNCHRONIZATION_WRITE_DAC = SYNCHRONIZATION_ACCESS_RIGHTS(262144);

const SYNCHRONIZATION_WRITE_OWNER = SYNCHRONIZATION_ACCESS_RIGHTS(524288);

const SYNCHRONIZATION_SYNCHRONIZE = SYNCHRONIZATION_ACCESS_RIGHTS(1048576);

const OCR_APPSTARTING = 32650;

const OCR_NORMAL = 32512;

const OCR_CROSS = 32515;

const OCR_HAND = 32649;

const OCR_HELP = 32651;

const OCR_IBEAM = 32513;

const OCR_NO = 32648;

const OCR_SIZEALL = 32646;

const OCR_SIZENESW = 32643;

const OCR_SIZENS = 32645;

const OCR_SIZENWSE = 32642;

const OCR_SIZEWE = 32644;

const OCR_UP = 32516;

const OCR_WAIT = 32514;

const SPI_LANGDRIVER = 12;

const SPI_GETTOUCHPREDICTIONPARAMETERS = SYSTEM_PARAMETERS_INFO_ACTION(156);

const SPI_SETTOUCHPREDICTIONPARAMETERS = SYSTEM_PARAMETERS_INFO_ACTION(157);

const SPI_GETLOGICALDPIOVERRIDE = 158;

const SPI_SETLOGICALDPIOVERRIDE = 159;

const SPI_GETMENURECT = 162;

const SPI_SETMENURECT = 163;

const SPI_GETACTIVEWINDOWTRACKING = SYSTEM_PARAMETERS_INFO_ACTION(4096);

const SPI_SETACTIVEWINDOWTRACKING = SYSTEM_PARAMETERS_INFO_ACTION(4097);

const SPI_GETMENUANIMATION = 4098;

const SPI_SETMENUANIMATION = 4099;

const SPI_GETCOMBOBOXANIMATION = 4100;

const SPI_SETCOMBOBOXANIMATION = 4101;

const SPI_GETLISTBOXSMOOTHSCROLLING = SYSTEM_PARAMETERS_INFO_ACTION(4102);

const SPI_SETLISTBOXSMOOTHSCROLLING = SYSTEM_PARAMETERS_INFO_ACTION(4103);

const SPI_GETGRADIENTCAPTIONS = 4104;

const SPI_SETGRADIENTCAPTIONS = 4105;

const SPI_GETKEYBOARDCUES = 4106;

const SPI_SETKEYBOARDCUES = 4107;

const SPI_GETMENUUNDERLINES = 4106;

const SPI_SETMENUUNDERLINES = 4107;

const SPI_GETACTIVEWNDTRKZORDER = 4108;

const SPI_SETACTIVEWNDTRKZORDER = 4109;

const SPI_GETHOTTRACKING = 4110;

const SPI_SETHOTTRACKING = 4111;

const SPI_GETMENUFADE = 4114;

const SPI_SETMENUFADE = 4115;

const SPI_GETSELECTIONFADE = 4116;

const SPI_SETSELECTIONFADE = 4117;

const SPI_GETTOOLTIPANIMATION = 4118;

const SPI_SETTOOLTIPANIMATION = 4119;

const SPI_GETTOOLTIPFADE = 4120;

const SPI_SETTOOLTIPFADE = 4121;

const SPI_GETCURSORSHADOW = 4122;

const SPI_SETCURSORSHADOW = 4123;

const SPI_GETMOUSESONAR = 4124;

const SPI_SETMOUSESONAR = 4125;

const SPI_GETMOUSECLICKLOCK = 4126;

const SPI_SETMOUSECLICKLOCK = 4127;

const SPI_GETMOUSEVANISH = 4128;

const SPI_SETMOUSEVANISH = 4129;

const SPI_GETFLATMENU = 4130;

const SPI_SETFLATMENU = 4131;

const SPI_GETDROPSHADOW = 4132;

const SPI_SETDROPSHADOW = 4133;

const SPI_GETBLOCKSENDINPUTRESETS = SYSTEM_PARAMETERS_INFO_ACTION(4134);

const SPI_SETBLOCKSENDINPUTRESETS = SYSTEM_PARAMETERS_INFO_ACTION(4135);

const SPI_GETUIEFFECTS = 4158;

const SPI_SETUIEFFECTS = 4159;

const SPI_GETDISABLEOVERLAPPEDCONTENT = SYSTEM_PARAMETERS_INFO_ACTION(4160);

const SPI_SETDISABLEOVERLAPPEDCONTENT = SYSTEM_PARAMETERS_INFO_ACTION(4161);

const SPI_GETCLIENTAREAANIMATION = 4162;

const SPI_SETCLIENTAREAANIMATION = 4163;

const SPI_GETCLEARTYPE = 4168;

const SPI_SETCLEARTYPE = 4169;

const SPI_GETSPEECHRECOGNITION = 4170;

const SPI_SETSPEECHRECOGNITION = 4171;

const SPI_GETCARETBROWSING = 4172;

const SPI_SETCARETBROWSING = 4173;

const SPI_GETTHREADLOCALINPUTSETTINGS = SYSTEM_PARAMETERS_INFO_ACTION(4174);

const SPI_SETTHREADLOCALINPUTSETTINGS = SYSTEM_PARAMETERS_INFO_ACTION(4175);

const SPI_GETSYSTEMLANGUAGEBAR = 4176;

const SPI_SETSYSTEMLANGUAGEBAR = 4177;

const SPI_GETFOREGROUNDLOCKTIMEOUT = SYSTEM_PARAMETERS_INFO_ACTION(8192);

const SPI_SETFOREGROUNDLOCKTIMEOUT = SYSTEM_PARAMETERS_INFO_ACTION(8193);

const SPI_GETACTIVEWNDTRKTIMEOUT = 8194;

const SPI_SETACTIVEWNDTRKTIMEOUT = 8195;

const SPI_GETFOREGROUNDFLASHCOUNT = SYSTEM_PARAMETERS_INFO_ACTION(8196);

const SPI_SETFOREGROUNDFLASHCOUNT = SYSTEM_PARAMETERS_INFO_ACTION(8197);

const SPI_GETCARETWIDTH = 8198;

const SPI_SETCARETWIDTH = 8199;

const SPI_GETMOUSECLICKLOCKTIME = 8200;

const SPI_SETMOUSECLICKLOCKTIME = 8201;

const SPI_GETFONTSMOOTHINGTYPE = 8202;

const SPI_SETFONTSMOOTHINGTYPE = 8203;

const SPI_GETFONTSMOOTHINGCONTRAST = SYSTEM_PARAMETERS_INFO_ACTION(8204);

const SPI_SETFONTSMOOTHINGCONTRAST = SYSTEM_PARAMETERS_INFO_ACTION(8205);

const SPI_GETFOCUSBORDERWIDTH = 8206;

const SPI_SETFOCUSBORDERWIDTH = 8207;

const SPI_GETFOCUSBORDERHEIGHT = 8208;

const SPI_SETFOCUSBORDERHEIGHT = 8209;

const SPI_GETFONTSMOOTHINGORIENTATION = SYSTEM_PARAMETERS_INFO_ACTION(8210);

const SPI_SETFONTSMOOTHINGORIENTATION = SYSTEM_PARAMETERS_INFO_ACTION(8211);

const SPI_GETMINIMUMHITRADIUS = 8212;

const SPI_SETMINIMUMHITRADIUS = 8213;

const SPI_GETMESSAGEDURATION = 8214;

const SPI_SETMESSAGEDURATION = 8215;

const SPI_GETCONTACTVISUALIZATION = SYSTEM_PARAMETERS_INFO_ACTION(8216);

const SPI_SETCONTACTVISUALIZATION = SYSTEM_PARAMETERS_INFO_ACTION(8217);

const SPI_GETGESTUREVISUALIZATION = SYSTEM_PARAMETERS_INFO_ACTION(8218);

const SPI_SETGESTUREVISUALIZATION = SYSTEM_PARAMETERS_INFO_ACTION(8219);

const SPI_GETMOUSEWHEELROUTING = 8220;

const SPI_SETMOUSEWHEELROUTING = 8221;

const SPI_GETPENVISUALIZATION = 8222;

const SPI_SETPENVISUALIZATION = 8223;

const SPI_GETPENARBITRATIONTYPE = 8224;

const SPI_SETPENARBITRATIONTYPE = 8225;

const SPI_GETCARETTIMEOUT = 8226;

const SPI_SETCARETTIMEOUT = 8227;

const SPI_GETHANDEDNESS = 8228;

const SPI_SETHANDEDNESS = 8229;

const SPIF_UPDATEINIFILE = 1;

const SPIF_SENDCHANGE = 2;

const SPIF_SENDWININICHANGE = 2;

const COLOR_3DDKSHADOW = 21;

const COLOR_3DLIGHT = 22;

const COLOR_INFOTEXT = 23;

const COLOR_INFOBK = 24;

const COLOR_HOTLIGHT = 26;

const COLOR_GRADIENTACTIVECAPTION = 27;

const COLOR_GRADIENTINACTIVECAPTION = 28;

const COLOR_MENUHILIGHT = 29;

const COLOR_MENUBAR = 30;

const COLOR_DESKTOP = 1;

const COLOR_3DFACE = 15;

const COLOR_3DSHADOW = 16;

const COLOR_3DHIGHLIGHT = 20;

const COLOR_3DHILIGHT = 20;

const COLOR_BTNHILIGHT = 20;

/// Minimum enumerated sensor state.
const SENSOR_STATE_MIN = 0;

/// Ready to send sensor data.
const SENSOR_STATE_READY = 0;

/// The sensor is not available for use.
const SENSOR_STATE_NOT_AVAILABLE = 1;

/// The sensor is available but does not have data.
const SENSOR_STATE_NO_DATA = 2;

/// The sensor is available, but performing initialization.
const SENSOR_STATE_INITIALIZING = 3;

/// The sensor is available, but the user account does not have permission to
/// access the sensor data.
const SENSOR_STATE_ACCESS_DENIED = 4;

/// The sensor has raised an error.
const SENSOR_STATE_ERROR = 5;

/// Maximum enumerated sensor state.
const SENSOR_STATE_MAX = 5;

const STCInprocServer = 1;

const STCInprocHandler = 2;

const STCLocalServer = 4;

const STCRemoteServer = 16;

const STCAll = 23;

const STSF_AppData = 26;

const STSF_LocalAppData = 28;

const STSF_CommonAppData = 35;

const STSF_FlagCreate = 32768;

/// Does not support text selections.
const SupportedTextSelection_None = 0;

/// Supports a single, continuous text selection.
const SupportedTextSelection_Single = 1;

/// Supports multiple, disjoint text selections.
const SupportedTextSelection_Multiple = 2;

/// A key has been released.
const SynchronizedInputType_KeyUp = 1;

/// A key has been pressed.
const SynchronizedInputType_KeyDown = 2;

/// The left mouse button has been released.
const SynchronizedInputType_LeftMouseUp = 4;

/// The left mouse button has been pressed.
const SynchronizedInputType_LeftMouseDown = 8;

/// The right mouse button has been released.
const SynchronizedInputType_RightMouseUp = 16;

/// The right mouse button has been pressed.
const SynchronizedInputType_RightMouseDown = 32;

const THREAD_CREATE_RUN_IMMEDIATELY = 0;

const THREAD_CREATE_SUSPENDED = 4;

const STACK_SIZE_PARAM_IS_A_RESERVATION = 65536;

const SEM_ALL_ERRORS = 0;

const MDITILE_HORIZONTAL = 1;

const MDITILE_VERTICAL = 0;

const TMPF_FIXED_PITCH = 1;

const TMPF_VECTOR = 2;

const TMPF_DEVICE = 8;

const TMPF_TRUETYPE = 4;

const TOKEN_DELETE = 65536;

const TOKEN_READ_CONTROL = 131072;

const TOKEN_WRITE_DAC = 262144;

const TOKEN_WRITE_OWNER = 524288;

const TOKEN_ACCESS_SYSTEM_SECURITY = 16777216;

const TOKEN_TRUST_CONSTRAINT_MASK = 131096;

const TOKEN_ACCESS_PSEUDO_HANDLE_WIN8 = 24;

const TOKEN_ACCESS_PSEUDO_HANDLE = 24;

const TOUCHEVENTF_MOVE = 1;

const TOUCHEVENTF_DOWN = 2;

const TOUCHEVENTF_UP = 4;

const TOUCHEVENTF_INRANGE = 8;

const TOUCHEVENTF_PRIMARY = 16;

const TOUCHEVENTF_NOCOALESCE = 32;

const TOUCHEVENTF_PEN = 64;

const TOUCHEVENTF_PALM = 128;

const TOUCHINPUTMASKF_TIMEFROMSYSTEM = 1;

const TOUCHINPUTMASKF_EXTRAINFO = 2;

const TOUCHINPUTMASKF_CONTACTAREA = 4;

/// Indicates that a tunnel is not specified.
const TUNNEL_TYPE_NONE = 0;

/// Indicates that none of the following tunnel types is specified.
const TUNNEL_TYPE_OTHER = 1;

/// Specifies that a packet is encapsulated directly within a normal IP
/// header, with no intermediate header, and the packet is sent unicast to the
/// remote tunnel endpoint.
const TUNNEL_TYPE_DIRECT = 2;

/// Specifies that an IPv6 packet is encapsulated directly within an IPv4
/// header, with no intermediate header, and the packet is sent unicast to the
/// destination determined by the 6to4 protocol.
const TUNNEL_TYPE_6TO4 = 11;

/// Specifies that an IPv6 packet is encapsulated directly within an IPv4
/// header, with no intermediate header, and the packet is sent unicast to the
/// destination determined by the ISATAP protocol.
const TUNNEL_TYPE_ISATAP = 13;

/// Specifies that the tunnel uses Teredo encapsulation.
const TUNNEL_TYPE_TEREDO = 14;

/// Specifies that the tunnel uses IP over Hypertext Transfer Protocol Secure
/// (HTTPS).
const TUNNEL_TYPE_IPHTTPS = 15;

/// A set of enumerators.
const TKIND_ENUM = 0;

/// A structure with no methods.
const TKIND_RECORD = 1;

/// A module that can only have static functions and data (for example, a
/// DLL).
const TKIND_MODULE = 2;

/// A type that has virtual and pure functions.
const TKIND_INTERFACE = 3;

/// A set of methods and properties that are accessible through <a
/// href="https://docs.microsoft.com/previous-versions/windows/desktop/api/oaidl/nf-oaidl-idispatch-invoke">IDispatch::Invoke</a>.
const TKIND_DISPATCH = 4;

/// A set of implemented component object interfaces.
const TKIND_COCLASS = 5;

/// A type that is an alias for another type.
const TKIND_ALIAS = 6;

/// A union, all of whose members have an offset of zero.
const TKIND_UNION = 7;

/// End of enum marker.
const TKIND_MAX = 8;

/// Not related to a specific change type.
const TextEditChangeType_None = 0;

/// Change is from an auto-correct action performed by a control.
const TextEditChangeType_AutoCorrect = 1;

/// Change is from an IME active composition within a control.
const TextEditChangeType_Composition = 2;

/// Change is from an IME composition going from active to finalized state
/// within a control.
const TextEditChangeType_CompositionFinalized = 3;

const TextEditChangeType_AutoComplete = 4;

/// The starting endpoint of the range.
const TextPatternRangeEndpoint_Start = 0;

/// The ending endpoint of the range.
const TextPatternRangeEndpoint_End = 1;

/// Character.
const TextUnit_Character = 0;

/// Format.
const TextUnit_Format = 1;

/// Word.
const TextUnit_Word = 2;

/// Line.
const TextUnit_Line = 3;

/// Paragraph.
const TextUnit_Paragraph = 4;

/// Page.
const TextUnit_Page = 5;

/// Document.
const TextUnit_Document = 6;

const TMT_RESERVEDLOW = 0;

const TMT_RESERVEDHIGH = 7999;

const TMT_DIBDATA = 2;

const TMT_GLYPHDIBDATA = 8;

const TMT_ENUM = 200;

const TMT_STRING = 201;

const TMT_INT = 202;

const TMT_BOOL = 203;

const TMT_COLOR = 204;

const TMT_MARGINS = 205;

const TMT_FILENAME = 206;

const TMT_SIZE = 207;

const TMT_POSITION = 208;

const TMT_RECT = 209;

const TMT_FONT = 210;

const TMT_INTLIST = 211;

const TMT_HBITMAP = 212;

const TMT_DISKSTREAM = 213;

const TMT_STREAM = 214;

const TMT_BITMAPREF = 215;

const TMT_FLOAT = 216;

const TMT_FLOATLIST = 217;

const TMT_COLORSCHEMES = 401;

const TMT_SIZES = 402;

const TMT_CHARSET = 403;

const TMT_NAME = 600;

const TMT_DISPLAYNAME = 601;

const TMT_TOOLTIP = 602;

const TMT_COMPANY = 603;

const TMT_AUTHOR = 604;

const TMT_COPYRIGHT = 605;

const TMT_URL = 606;

const TMT_VERSION = 607;

const TMT_DESCRIPTION = 608;

const TMT_FIRST_RCSTRING_NAME = 601;

const TMT_LAST_RCSTRING_NAME = 608;

const TMT_HEADING1FONT = 807;

const TMT_HEADING2FONT = 808;

const TMT_BODYFONT = 809;

const TMT_FIRSTFONT = 801;

const TMT_LASTFONT = 809;

const TMT_FLATMENUS = 1001;

const TMT_FIRSTBOOL = 1001;

const TMT_LASTBOOL = 1001;

const TMT_SIZINGBORDERWIDTH = 1201;

const TMT_SCROLLBARWIDTH = 1202;

const TMT_SCROLLBARHEIGHT = 1203;

const TMT_CAPTIONBARWIDTH = 1204;

const TMT_CAPTIONBARHEIGHT = 1205;

const TMT_SMCAPTIONBARWIDTH = 1206;

const TMT_SMCAPTIONBARHEIGHT = 1207;

const TMT_MENUBARWIDTH = 1208;

const TMT_MENUBARHEIGHT = 1209;

const TMT_PADDEDBORDERWIDTH = 1210;

const TMT_FIRSTSIZE = 1201;

const TMT_LASTSIZE = 1210;

const TMT_MINCOLORDEPTH = 1301;

const TMT_FIRSTINT = 1301;

const TMT_LASTINT = 1301;

const TMT_CSSNAME = 1401;

const TMT_XMLNAME = 1402;

const TMT_LASTUPDATED = 1403;

const TMT_ALIAS = 1404;

const TMT_FIRSTSTRING = 1401;

const TMT_LASTSTRING = 1404;

const TMT_SCROLLBAR = 1601;

const TMT_BACKGROUND = 1602;

const TMT_ACTIVECAPTION = 1603;

const TMT_INACTIVECAPTION = 1604;

const TMT_MENU = 1605;

const TMT_WINDOW = 1606;

const TMT_WINDOWFRAME = 1607;

const TMT_MENUTEXT = 1608;

const TMT_WINDOWTEXT = 1609;

const TMT_CAPTIONTEXT = 1610;

const TMT_ACTIVEBORDER = 1611;

const TMT_INACTIVEBORDER = 1612;

const TMT_APPWORKSPACE = 1613;

const TMT_HIGHLIGHT = 1614;

const TMT_HIGHLIGHTTEXT = 1615;

const TMT_BTNFACE = 1616;

const TMT_BTNSHADOW = 1617;

const TMT_GRAYTEXT = 1618;

const TMT_BTNTEXT = 1619;

const TMT_INACTIVECAPTIONTEXT = 1620;

const TMT_BTNHIGHLIGHT = 1621;

const TMT_DKSHADOW3D = 1622;

const TMT_LIGHT3D = 1623;

const TMT_INFOTEXT = 1624;

const TMT_INFOBK = 1625;

const TMT_BUTTONALTERNATEFACE = 1626;

const TMT_HOTTRACKING = 1627;

const TMT_GRADIENTACTIVECAPTION = 1628;

const TMT_GRADIENTINACTIVECAPTION = 1629;

const TMT_MENUHILIGHT = 1630;

const TMT_MENUBAR = 1631;

const TMT_FIRSTCOLOR = 1601;

const TMT_LASTCOLOR = 1631;

const TMT_FROMHUE1 = 1801;

const TMT_FROMHUE2 = 1802;

const TMT_FROMHUE3 = 1803;

const TMT_FROMHUE4 = 1804;

const TMT_FROMHUE5 = 1805;

const TMT_TOHUE1 = 1806;

const TMT_TOHUE2 = 1807;

const TMT_TOHUE3 = 1808;

const TMT_TOHUE4 = 1809;

const TMT_TOHUE5 = 1810;

const TMT_FROMCOLOR1 = 2001;

const TMT_FROMCOLOR2 = 2002;

const TMT_FROMCOLOR3 = 2003;

const TMT_FROMCOLOR4 = 2004;

const TMT_FROMCOLOR5 = 2005;

const TMT_TOCOLOR1 = 2006;

const TMT_TOCOLOR2 = 2007;

const TMT_TOCOLOR3 = 2008;

const TMT_TOCOLOR4 = 2009;

const TMT_TOCOLOR5 = 2010;

const TMT_TRANSPARENT = 2201;

const TMT_AUTOSIZE = 2202;

const TMT_BORDERONLY = 2203;

const TMT_COMPOSITED = 2204;

const TMT_BGFILL = 2205;

const TMT_GLYPHTRANSPARENT = 2206;

const TMT_GLYPHONLY = 2207;

const TMT_ALWAYSSHOWSIZINGBAR = 2208;

const TMT_MIRRORIMAGE = 2209;

const TMT_UNIFORMSIZING = 2210;

const TMT_INTEGRALSIZING = 2211;

const TMT_SOURCEGROW = 2212;

const TMT_SOURCESHRINK = 2213;

const TMT_DRAWBORDERS = 2214;

const TMT_NOETCHEDEFFECT = 2215;

const TMT_TEXTAPPLYOVERLAY = 2216;

const TMT_TEXTGLOW = 2217;

const TMT_TEXTITALIC = 2218;

const TMT_COMPOSITEDOPAQUE = 2219;

const TMT_LOCALIZEDMIRRORIMAGE = 2220;

const TMT_IMAGECOUNT = 2401;

const TMT_ALPHALEVEL = 2402;

const TMT_BORDERSIZE = 2403;

const TMT_ROUNDCORNERWIDTH = 2404;

const TMT_ROUNDCORNERHEIGHT = 2405;

const TMT_GRADIENTRATIO1 = 2406;

const TMT_GRADIENTRATIO2 = 2407;

const TMT_GRADIENTRATIO3 = 2408;

const TMT_GRADIENTRATIO4 = 2409;

const TMT_GRADIENTRATIO5 = 2410;

const TMT_PROGRESSCHUNKSIZE = 2411;

const TMT_PROGRESSSPACESIZE = 2412;

const TMT_SATURATION = 2413;

const TMT_TEXTBORDERSIZE = 2414;

const TMT_ALPHATHRESHOLD = 2415;

const TMT_WIDTH = 2416;

const TMT_HEIGHT = 2417;

const TMT_GLYPHINDEX = 2418;

const TMT_TRUESIZESTRETCHMARK = 2419;

const TMT_MINDPI1 = 2420;

const TMT_MINDPI2 = 2421;

const TMT_MINDPI3 = 2422;

const TMT_MINDPI4 = 2423;

const TMT_MINDPI5 = 2424;

const TMT_TEXTGLOWSIZE = 2425;

const TMT_FRAMESPERSECOND = 2426;

const TMT_PIXELSPERFRAME = 2427;

const TMT_ANIMATIONDELAY = 2428;

const TMT_GLOWINTENSITY = 2429;

const TMT_OPACITY = 2430;

const TMT_COLORIZATIONCOLOR = 2431;

const TMT_COLORIZATIONOPACITY = 2432;

const TMT_MINDPI6 = 2433;

const TMT_MINDPI7 = 2434;

const TMT_GLYPHFONT = 2601;

const TMT_IMAGEFILE = 3001;

const TMT_IMAGEFILE1 = 3002;

const TMT_IMAGEFILE2 = 3003;

const TMT_IMAGEFILE3 = 3004;

const TMT_IMAGEFILE4 = 3005;

const TMT_IMAGEFILE5 = 3006;

const TMT_GLYPHIMAGEFILE = 3008;

const TMT_IMAGEFILE6 = 3009;

const TMT_IMAGEFILE7 = 3010;

const TMT_TEXT = 3201;

const TMT_CLASSICVALUE = 3202;

const TMT_OFFSET = 3401;

const TMT_TEXTSHADOWOFFSET = 3402;

const TMT_MINSIZE = 3403;

const TMT_MINSIZE1 = 3404;

const TMT_MINSIZE2 = 3405;

const TMT_MINSIZE3 = 3406;

const TMT_MINSIZE4 = 3407;

const TMT_MINSIZE5 = 3408;

const TMT_NORMALSIZE = 3409;

const TMT_MINSIZE6 = 3410;

const TMT_MINSIZE7 = 3411;

const TMT_SIZINGMARGINS = 3601;

const TMT_CONTENTMARGINS = 3602;

const TMT_CAPTIONMARGINS = 3603;

const TMT_BORDERCOLOR = 3801;

const TMT_FILLCOLOR = 3802;

const TMT_TEXTCOLOR = 3803;

const TMT_EDGELIGHTCOLOR = 3804;

const TMT_EDGEHIGHLIGHTCOLOR = 3805;

const TMT_EDGESHADOWCOLOR = 3806;

const TMT_EDGEDKSHADOWCOLOR = 3807;

const TMT_EDGEFILLCOLOR = 3808;

const TMT_TRANSPARENTCOLOR = 3809;

const TMT_GRADIENTCOLOR1 = 3810;

const TMT_GRADIENTCOLOR2 = 3811;

const TMT_GRADIENTCOLOR3 = 3812;

const TMT_GRADIENTCOLOR4 = 3813;

const TMT_GRADIENTCOLOR5 = 3814;

const TMT_SHADOWCOLOR = 3815;

const TMT_GLOWCOLOR = 3816;

const TMT_TEXTBORDERCOLOR = 3817;

const TMT_TEXTSHADOWCOLOR = 3818;

const TMT_GLYPHTEXTCOLOR = 3819;

const TMT_GLYPHTRANSPARENTCOLOR = 3820;

const TMT_FILLCOLORHINT = 3821;

const TMT_BORDERCOLORHINT = 3822;

const TMT_ACCENTCOLORHINT = 3823;

const TMT_TEXTCOLORHINT = 3824;

const TMT_HEADING1TEXTCOLOR = 3825;

const TMT_HEADING2TEXTCOLOR = 3826;

const TMT_BODYTEXTCOLOR = 3827;

const TMT_BGTYPE = 4001;

const TMT_BORDERTYPE = 4002;

const TMT_FILLTYPE = 4003;

const TMT_SIZINGTYPE = 4004;

const TMT_HALIGN = 4005;

const TMT_CONTENTALIGNMENT = 4006;

const TMT_VALIGN = 4007;

const TMT_OFFSETTYPE = 4008;

const TMT_ICONEFFECT = 4009;

const TMT_TEXTSHADOWTYPE = 4010;

const TMT_IMAGELAYOUT = 4011;

const TMT_GLYPHTYPE = 4012;

const TMT_IMAGESELECTTYPE = 4013;

const TMT_GLYPHFONTSIZINGTYPE = 4014;

const TMT_TRUESIZESCALINGTYPE = 4015;

const TMT_USERPICTURE = 5001;

const TMT_DEFAULTPANESIZE = 5002;

const TMT_BLENDCOLOR = 5003;

const TMT_CUSTOMSPLITRECT = 5004;

const TMT_ANIMATIONBUTTONRECT = 5005;

const TMT_ANIMATIONDURATION = 5006;

const TMT_TRANSITIONDURATIONS = 6000;

const TMT_SCALEDBACKGROUND = 7001;

const TMT_ATLASIMAGE = 8000;

const TMT_ATLASINPUTIMAGE = 8001;

const TMT_ATLASRECT = 8002;

const AnnotationType_Unknown = 60000;

const AnnotationType_SpellingError = 60001;

const AnnotationType_GrammarError = 60002;

const AnnotationType_Comment = 60003;

const AnnotationType_FormulaError = 60004;

const AnnotationType_TrackChanges = 60005;

const AnnotationType_Header = 60006;

const AnnotationType_Footer = 60007;

const AnnotationType_Highlighted = 60008;

const AnnotationType_Endnote = 60009;

const AnnotationType_Footnote = 60010;

const AnnotationType_InsertionChange = 60011;

const AnnotationType_DeletionChange = 60012;

const AnnotationType_MoveChange = 60013;

const AnnotationType_FormatChange = 60014;

const AnnotationType_UnsyncedChange = 60015;

const AnnotationType_EditingLockedChange = 60016;

const AnnotationType_ExternalChange = 60017;

const AnnotationType_ConflictingChange = 60018;

const AnnotationType_Author = 60019;

const AnnotationType_AdvancedProofingIssue = 60020;

const AnnotationType_DataValidationError = 60021;

const AnnotationType_CircularReferenceError = UIA_ANNOTATIONTYPE(60022);

const AnnotationType_Mathematics = 60023;

const AnnotationType_Sensitive = 60024;

const UIA_ToolTipOpenedEventId = 20000;

const UIA_ToolTipClosedEventId = 20001;

const UIA_StructureChangedEventId = 20002;

const UIA_MenuOpenedEventId = 20003;

const UIA_AutomationPropertyChangedEventId = 20004;

const UIA_AutomationFocusChangedEventId = 20005;

const UIA_AsyncContentLoadedEventId = 20006;

const UIA_MenuClosedEventId = 20007;

const UIA_LayoutInvalidatedEventId = 20008;

const UIA_Invoke_InvokedEventId = 20009;

const UIA_SelectionItem_ElementAddedToSelectionEventId = UIA_EVENT_ID(20010);

const UIA_SelectionItem_ElementRemovedFromSelectionEventId = UIA_EVENT_ID(
  20011,
);

const UIA_SelectionItem_ElementSelectedEventId = 20012;

const UIA_Selection_InvalidatedEventId = 20013;

const UIA_Text_TextSelectionChangedEventId = 20014;

const UIA_Text_TextChangedEventId = 20015;

const UIA_Window_WindowOpenedEventId = 20016;

const UIA_Window_WindowClosedEventId = 20017;

const UIA_MenuModeStartEventId = 20018;

const UIA_MenuModeEndEventId = 20019;

const UIA_InputReachedTargetEventId = 20020;

const UIA_InputReachedOtherElementEventId = 20021;

const UIA_InputDiscardedEventId = 20022;

const UIA_SystemAlertEventId = 20023;

const UIA_LiveRegionChangedEventId = 20024;

const UIA_HostedFragmentRootsInvalidatedEventId = 20025;

const UIA_Drag_DragStartEventId = 20026;

const UIA_Drag_DragCancelEventId = 20027;

const UIA_Drag_DragCompleteEventId = 20028;

const UIA_DropTarget_DragEnterEventId = 20029;

const UIA_DropTarget_DragLeaveEventId = 20030;

const UIA_DropTarget_DroppedEventId = 20031;

const UIA_TextEdit_TextChangedEventId = 20032;

const UIA_TextEdit_ConversionTargetChangedEventId = UIA_EVENT_ID(20033);

const UIA_ChangesEventId = 20034;

const UIA_NotificationEventId = 20035;

const UIA_ActiveTextPositionChangedEventId = 20036;

const HeadingLevel_None = 80050;

const HeadingLevel1 = 80051;

const HeadingLevel2 = 80052;

const HeadingLevel3 = 80053;

const HeadingLevel4 = 80054;

const HeadingLevel5 = 80055;

const HeadingLevel6 = 80056;

const HeadingLevel7 = 80057;

const HeadingLevel8 = 80058;

const HeadingLevel9 = 80059;

const UIA_CustomLandmarkTypeId = 80000;

const UIA_FormLandmarkTypeId = 80001;

const UIA_MainLandmarkTypeId = 80002;

const UIA_NavigationLandmarkTypeId = 80003;

const UIA_SearchLandmarkTypeId = 80004;

const UIA_SayAsInterpretAsMetadataId = 100000;

const UIA_SelectionPattern2Id = 10034;

const UIA_IsSelectionPattern2AvailablePropertyId = UIA_PROPERTY_ID(30168);

const UIA_Selection2FirstSelectedItemPropertyId = UIA_PROPERTY_ID(30169);

const UIA_Selection2LastSelectedItemPropertyId = UIA_PROPERTY_ID(30170);

const UIA_Selection2CurrentSelectedItemPropertyId = UIA_PROPERTY_ID(30171);

const UIA_Selection2ItemCountPropertyId = 30172;

const StyleId_Custom = 70000;

const StyleId_Heading1 = 70001;

const StyleId_Heading2 = 70002;

const StyleId_Heading3 = 70003;

const StyleId_Heading4 = 70004;

const StyleId_Heading5 = 70005;

const StyleId_Heading6 = 70006;

const StyleId_Heading7 = 70007;

const StyleId_Heading8 = 70008;

const StyleId_Heading9 = 70009;

const StyleId_Title = 70010;

const StyleId_Subtitle = 70011;

const StyleId_Normal = 70012;

const StyleId_Emphasis = 70013;

const StyleId_Quote = 70014;

const StyleId_BulletedList = 70015;

const StyleId_NumberedList = 70016;

const UIA_AnimationStyleAttributeId = 40000;

const UIA_BackgroundColorAttributeId = 40001;

const UIA_BulletStyleAttributeId = 40002;

const UIA_CapStyleAttributeId = 40003;

const UIA_CultureAttributeId = 40004;

const UIA_FontNameAttributeId = 40005;

const UIA_FontSizeAttributeId = 40006;

const UIA_FontWeightAttributeId = 40007;

const UIA_ForegroundColorAttributeId = 40008;

const UIA_HorizontalTextAlignmentAttributeId = UIA_TEXTATTRIBUTE_ID(40009);

const UIA_IndentationFirstLineAttributeId = UIA_TEXTATTRIBUTE_ID(40010);

const UIA_IndentationLeadingAttributeId = 40011;

const UIA_IndentationTrailingAttributeId = 40012;

const UIA_IsHiddenAttributeId = 40013;

const UIA_IsItalicAttributeId = 40014;

const UIA_IsReadOnlyAttributeId = 40015;

const UIA_IsSubscriptAttributeId = 40016;

const UIA_IsSuperscriptAttributeId = 40017;

const UIA_MarginBottomAttributeId = 40018;

const UIA_MarginLeadingAttributeId = 40019;

const UIA_MarginTopAttributeId = 40020;

const UIA_MarginTrailingAttributeId = 40021;

const UIA_OutlineStylesAttributeId = 40022;

const UIA_OverlineColorAttributeId = 40023;

const UIA_OverlineStyleAttributeId = 40024;

const UIA_StrikethroughColorAttributeId = 40025;

const UIA_StrikethroughStyleAttributeId = 40026;

const UIA_TabsAttributeId = 40027;

const UIA_TextFlowDirectionsAttributeId = 40028;

const UIA_UnderlineColorAttributeId = 40029;

const UIA_UnderlineStyleAttributeId = 40030;

const UIA_AnnotationTypesAttributeId = 40031;

const UIA_AnnotationObjectsAttributeId = 40032;

const UIA_StyleNameAttributeId = 40033;

const UIA_StyleIdAttributeId = 40034;

const UIA_LinkAttributeId = 40035;

const UIA_IsActiveAttributeId = 40036;

const UIA_SelectionActiveEndAttributeId = 40037;

const UIA_CaretPositionAttributeId = 40038;

const UIA_CaretBidiModeAttributeId = 40039;

const UIA_LineSpacingAttributeId = 40040;

const UIA_BeforeParagraphSpacingAttributeId = UIA_TEXTATTRIBUTE_ID(40041);

const UIA_AfterParagraphSpacingAttributeId = UIA_TEXTATTRIBUTE_ID(40042);

const UIA_SayAsInterpretAsAttributeId = 40043;

const MEM_UNMAP_NONE = 0;

const ULW_ALPHA = 2;

const ULW_COLORKEY = 1;

const ULW_OPAQUE = 4;

const ULW_EX_NORESIZE = 8;

const UOI_FLAGS = 1;

const UOI_HEAPSIZE = 5;

const UOI_IO = 6;

const UOI_NAME = 2;

const UOI_TYPE = 3;

const UOI_USER_SID = 4;

const Uri_PROPERTY_ABSOLUTE_URI = 0;

const Uri_PROPERTY_STRING_START = 0;

const Uri_PROPERTY_AUTHORITY = 1;

const Uri_PROPERTY_DISPLAY_URI = 2;

const Uri_PROPERTY_DOMAIN = 3;

const Uri_PROPERTY_EXTENSION = 4;

const Uri_PROPERTY_FRAGMENT = 5;

const Uri_PROPERTY_HOST = 6;

const Uri_PROPERTY_PASSWORD = 7;

const Uri_PROPERTY_PATH = 8;

const Uri_PROPERTY_PATH_AND_QUERY = 9;

const Uri_PROPERTY_QUERY = 10;

const Uri_PROPERTY_RAW_URI = 11;

const Uri_PROPERTY_SCHEME_NAME = 12;

const Uri_PROPERTY_USER_INFO = 13;

const Uri_PROPERTY_USER_NAME = 14;

const Uri_PROPERTY_STRING_LAST = 14;

const Uri_PROPERTY_HOST_TYPE = 15;

const Uri_PROPERTY_DWORD_START = 15;

const Uri_PROPERTY_PORT = 16;

const Uri_PROPERTY_SCHEME = 17;

const Uri_PROPERTY_ZONE = 18;

const Uri_PROPERTY_DWORD_LAST = 18;

/// Assignment to the variable should not be allowed.
const VARFLAG_FREADONLY = 1;

/// The variable returns an object that is a source of events.
const VARFLAG_FSOURCE = 2;

/// The variable supports data binding.
const VARFLAG_FBINDABLE = 4;

/// When set, any attempt to directly change the property results in a call to
/// <b>IPropertyNotifySink::OnRequestEdit</b>.
const VARFLAG_FREQUESTEDIT = 8;

/// The variable is displayed to the user as bindable.
const VARFLAG_FDISPLAYBIND = 16;

/// The variable is the single property that best represents the object.
const VARFLAG_FDEFAULTBIND = 32;

/// The variable should not be displayed to the user in a browser, although it
/// exists and is bindable.
const VARFLAG_FHIDDEN = 64;

/// The variable should not be accessible from macro languages.
const VARFLAG_FRESTRICTED = 128;

/// Permits an optimization in which the compiler looks for a member named
/// "xyz" on the type of abc.
const VARFLAG_FDEFAULTCOLLELEM = 256;

/// The variable is the default display in the user interface.
const VARFLAG_FUIDEFAULT = 512;

/// The variable appears in an object browser, but not in a properties
/// browser.
const VARFLAG_FNONBROWSABLE = 1024;

/// Tags the interface as having default behaviors.
const VARFLAG_FREPLACEABLE = 2048;

/// The variable is mapped as individual bindable properties.
const VARFLAG_FIMMEDIATEBIND = 4096;

/// The variable is a field or member of the type.
const VAR_PERINSTANCE = 0;

/// There is only one instance of the variable.
const VAR_STATIC = 1;

/// The VARDESC describes a symbolic constant.
const VAR_CONST = 2;

/// The variable can only be accessed through <a
/// href="https://docs.microsoft.com/previous-versions/windows/desktop/api/oaidl/nf-oaidl-idispatch-invoke">IDispatch::Invoke</a>.
const VAR_DISPATCH = 3;

const VARIANT_CALENDAR_HIJRI = 8;

const VARIANT_CALENDAR_THAI = 32;

const VARIANT_CALENDAR_GREGORIAN = 64;

const VARIANT_USE_NLS = 128;

const VFF_CURNEDEST = 1;

const VFF_FILEINUSE = 2;

const VFF_BUFFTOOSMALL = 4;

const VIF_TEMPFILE = 1;

const VIF_MISMATCH = 2;

const VIF_SRCOLD = 4;

const VIF_DIFFLANG = 8;

const VIF_DIFFCODEPG = 16;

const VIF_DIFFTYPE = 32;

const VIF_WRITEPROT = 64;

const VIF_FILEINUSE = 128;

const VIF_OUTOFSPACE = 256;

const VIF_ACCESSVIOLATION = 512;

const VIF_SHARINGVIOLATION = 1024;

const VIF_CANNOTCREATE = 2048;

const VIF_CANNOTDELETE = 4096;

const VIF_CANNOTRENAME = 8192;

const VIF_CANNOTDELETECUR = 16384;

const VIF_OUTOFMEMORY = 32768;

const VIF_CANNOTREADSRC = 65536;

const VIF_CANNOTREADDST = 131072;

const VIF_BUFFTOOSMALL = 262144;

const VIF_CANNOTLOADLZ32 = 524288;

const VIF_CANNOTLOADCABINET = 1048576;

const VK_0 = 48;

const VK_1 = 49;

const VK_2 = 50;

const VK_3 = 51;

const VK_4 = 52;

const VK_5 = 53;

const VK_6 = 54;

const VK_7 = 55;

const VK_8 = 56;

const VK_9 = 57;

const VK_A = 65;

const VK_B = 66;

const VK_C = 67;

const VK_D = 68;

const VK_E = 69;

const VK_F = 70;

const VK_G = 71;

const VK_H = 72;

const VK_I = 73;

const VK_J = 74;

const VK_K = 75;

const VK_L = 76;

const VK_M = 77;

const VK_N = 78;

const VK_O = 79;

const VK_P = 80;

const VK_Q = 81;

const VK_R = 82;

const VK_S = 83;

const VK_T = 84;

const VK_U = 85;

const VK_V = 86;

const VK_W = 87;

const VK_X = 88;

const VK_Y = 89;

const VK_Z = 90;

const VK_ABNT_C1 = 193;

const VK_ABNT_C2 = 194;

const VK_DBE_ALPHANUMERIC = 240;

const VK_DBE_CODEINPUT = 250;

const VK_DBE_DBCSCHAR = 244;

const VK_DBE_DETERMINESTRING = 252;

const VK_DBE_ENTERDLGCONVERSIONMODE = 253;

const VK_DBE_ENTERIMECONFIGMODE = 248;

const VK_DBE_ENTERWORDREGISTERMODE = 247;

const VK_DBE_FLUSHSTRING = 249;

const VK_DBE_HIRAGANA = 242;

const VK_DBE_KATAKANA = 241;

const VK_DBE_NOCODEINPUT = 251;

const VK_DBE_NOROMAN = 246;

const VK_DBE_ROMAN = 245;

const VK_DBE_SBCSCHAR = 243;

const VK__none_ = 255;

const VK_IME_ON = 22;

const VK_IME_OFF = 26;

const VK_NAVIGATION_VIEW = 136;

const VK_NAVIGATION_MENU = 137;

const VK_NAVIGATION_UP = 138;

const VK_NAVIGATION_DOWN = 139;

const VK_NAVIGATION_LEFT = 140;

const VK_NAVIGATION_RIGHT = 141;

const VK_NAVIGATION_ACCEPT = 142;

const VK_NAVIGATION_CANCEL = 143;

const VK_OEM_NEC_EQUAL = 146;

const VK_OEM_FJ_JISHO = 146;

const VK_OEM_FJ_MASSHOU = 147;

const VK_OEM_FJ_TOUROKU = 148;

const VK_OEM_FJ_LOYA = 149;

const VK_OEM_FJ_ROYA = 150;

const VK_GAMEPAD_A = 195;

const VK_GAMEPAD_B = 196;

const VK_GAMEPAD_X = 197;

const VK_GAMEPAD_Y = 198;

const VK_GAMEPAD_RIGHT_SHOULDER = 199;

const VK_GAMEPAD_LEFT_SHOULDER = 200;

const VK_GAMEPAD_LEFT_TRIGGER = 201;

const VK_GAMEPAD_RIGHT_TRIGGER = 202;

const VK_GAMEPAD_DPAD_UP = 203;

const VK_GAMEPAD_DPAD_DOWN = 204;

const VK_GAMEPAD_DPAD_LEFT = 205;

const VK_GAMEPAD_DPAD_RIGHT = 206;

const VK_GAMEPAD_MENU = 207;

const VK_GAMEPAD_VIEW = 208;

const VK_GAMEPAD_LEFT_THUMBSTICK_BUTTON = 209;

const VK_GAMEPAD_RIGHT_THUMBSTICK_BUTTON = 210;

const VK_GAMEPAD_LEFT_THUMBSTICK_UP = 211;

const VK_GAMEPAD_LEFT_THUMBSTICK_DOWN = 212;

const VK_GAMEPAD_LEFT_THUMBSTICK_RIGHT = 213;

const VK_GAMEPAD_LEFT_THUMBSTICK_LEFT = 214;

const VK_GAMEPAD_RIGHT_THUMBSTICK_UP = 215;

const VK_GAMEPAD_RIGHT_THUMBSTICK_DOWN = 216;

const VK_GAMEPAD_RIGHT_THUMBSTICK_RIGHT = 217;

const VK_GAMEPAD_RIGHT_THUMBSTICK_LEFT = 218;

const VK_OEM_RESET = 233;

const VK_OEM_JUMP = 234;

const VK_OEM_PA1 = 235;

const VK_OEM_PA2 = 236;

const VK_OEM_PA3 = 237;

const VK_OEM_WSCTRL = 238;

const VK_OEM_CUSEL = 239;

const VK_OEM_ATTN = 240;

const VK_OEM_FINISH = 241;

const VK_OEM_COPY = 242;

const VK_OEM_AUTO = 243;

const VK_OEM_ENLW = 244;

const VK_OEM_BACKTAB = 245;

const VK_ATTN = 246;

const VK_CRSEL = 247;

const VK_EXSEL = 248;

const VK_EREOF = 249;

const VK_PLAY = 250;

const VK_ZOOM = 251;

const VK_NONAME = 252;

const VK_PA1 = 253;

const VK_OEM_CLEAR = 254;

const VS_FF_DEBUG = 1;

const VS_FF_PRERELEASE = 2;

const VS_FF_PATCHED = 4;

const VS_FF_PRIVATEBUILD = 8;

const VS_FF_INFOINFERRED = 16;

const VS_FF_SPECIALBUILD = 32;

const VOS_UNKNOWN = 0;

const VOS_DOS = 65536;

const VOS_OS216 = 131072;

const VOS_OS232 = 196608;

const VOS_NT = 262144;

const VOS_WINCE = 327680;

const VOS__BASE = 0;

const VOS__WINDOWS16 = 1;

const VOS__PM16 = 2;

const VOS__PM32 = 3;

const VOS__WINDOWS32 = 4;

const VOS_DOS_WINDOWS16 = 65537;

const VOS_DOS_WINDOWS32 = 65540;

const VOS_OS216_PM16 = 131074;

const VOS_OS232_PM32 = 196611;

const VOS_NT_WINDOWS32 = 262148;

const WAIT_OBJECT_0 = 0;

const WAIT_ABANDONED = 128;

const WAIT_ABANDONED_0 = 128;

const WAIT_IO_COMPLETION = 192;

const WAIT_TIMEOUT = 258;

const WAIT_FAILED = 4294967295;

/// Compare all features.
const WBEM_COMPARISON_INCLUDE_ALL = 0;

/// Ignore all qualifiers (including <b>Key</b> and <b>Dynamic</b>) in
/// comparison.
const WBEM_FLAG_IGNORE_QUALIFIERS = 1;

/// Ignore the source of the objects, namely the server and the namespace they
/// came from, in comparison to other objects.
const WBEM_FLAG_IGNORE_OBJECT_SOURCE = 2;

/// Ignore default values of properties.
const WBEM_FLAG_IGNORE_DEFAULT_VALUES = 4;

/// Assume that the objects being compared are instances of the same class.
const WBEM_FLAG_IGNORE_CLASS = 8;

/// Compare string values in a case-insensitive manner.
const WBEM_FLAG_IGNORE_CASE = 16;

/// Ignore qualifier flavors.
const WBEM_FLAG_IGNORE_FLAVOR = 32;

const WBEM_FLAG_ALWAYS = 0;

const WBEM_FLAG_ONLY_IF_TRUE = 1;

const WBEM_FLAG_ONLY_IF_FALSE = 2;

const WBEM_FLAG_ONLY_IF_IDENTICAL = 3;

const WBEM_MASK_PRIMARY_CONDITION = 3;

const WBEM_FLAG_KEYS_ONLY = 4;

const WBEM_FLAG_REFS_ONLY = 8;

const WBEM_FLAG_LOCAL_ONLY = 16;

const WBEM_FLAG_PROPAGATED_ONLY = 32;

const WBEM_FLAG_SYSTEM_ONLY = 48;

const WBEM_FLAG_NONSYSTEM_ONLY = 64;

const WBEM_MASK_CONDITION_ORIGIN = 112;

const WBEM_FLAG_CLASS_OVERRIDES_ONLY = 256;

const WBEM_FLAG_CLASS_LOCAL_AND_OVERRIDES = WBEM_CONDITION_FLAG_TYPE(512);

const WBEM_MASK_CLASS_CONDITION = 768;

const ERROR_EXPECTED_SECTION_NAME = 3758096384;

const ERROR_BAD_SECTION_NAME_LINE = 3758096385;

const ERROR_SECTION_NAME_TOO_LONG = 3758096386;

const ERROR_GENERAL_SYNTAX = 3758096387;

const ERROR_WRONG_INF_STYLE = 3758096640;

const ERROR_SECTION_NOT_FOUND = 3758096641;

const ERROR_LINE_NOT_FOUND = 3758096642;

const ERROR_NO_BACKUP = 3758096643;

const ERROR_NO_ASSOCIATED_CLASS = 3758096896;

const ERROR_CLASS_MISMATCH = 3758096897;

const ERROR_DUPLICATE_FOUND = 3758096898;

const ERROR_NO_DRIVER_SELECTED = 3758096899;

const ERROR_KEY_DOES_NOT_EXIST = 3758096900;

const ERROR_INVALID_DEVINST_NAME = 3758096901;

const ERROR_INVALID_CLASS = 3758096902;

const ERROR_DEVINST_ALREADY_EXISTS = 3758096903;

const ERROR_DEVINFO_NOT_REGISTERED = 3758096904;

const ERROR_INVALID_REG_PROPERTY = 3758096905;

const ERROR_NO_INF = 3758096906;

const ERROR_NO_SUCH_DEVINST = 3758096907;

const ERROR_CANT_LOAD_CLASS_ICON = 3758096908;

const ERROR_INVALID_CLASS_INSTALLER = 3758096909;

const ERROR_DI_DO_DEFAULT = 3758096910;

const ERROR_DI_NOFILECOPY = 3758096911;

const ERROR_INVALID_HWPROFILE = 3758096912;

const ERROR_NO_DEVICE_SELECTED = 3758096913;

const ERROR_DEVINFO_LIST_LOCKED = 3758096914;

const ERROR_DEVINFO_DATA_LOCKED = 3758096915;

const ERROR_DI_BAD_PATH = 3758096916;

const ERROR_NO_CLASSINSTALL_PARAMS = 3758096917;

const ERROR_FILEQUEUE_LOCKED = 3758096918;

const ERROR_BAD_SERVICE_INSTALLSECT = 3758096919;

const ERROR_NO_CLASS_DRIVER_LIST = 3758096920;

const ERROR_NO_ASSOCIATED_SERVICE = 3758096921;

const ERROR_NO_DEFAULT_DEVICE_INTERFACE = 3758096922;

const ERROR_DEVICE_INTERFACE_ACTIVE = 3758096923;

const ERROR_DEVICE_INTERFACE_REMOVED = 3758096924;

const ERROR_BAD_INTERFACE_INSTALLSECT = 3758096925;

const ERROR_NO_SUCH_INTERFACE_CLASS = 3758096926;

const ERROR_INVALID_REFERENCE_STRING = 3758096927;

const ERROR_INVALID_MACHINENAME = 3758096928;

const ERROR_REMOTE_COMM_FAILURE = 3758096929;

const ERROR_MACHINE_UNAVAILABLE = 3758096930;

const ERROR_NO_CONFIGMGR_SERVICES = 3758096931;

const ERROR_INVALID_PROPPAGE_PROVIDER = 3758096932;

const ERROR_NO_SUCH_DEVICE_INTERFACE = 3758096933;

const ERROR_DI_POSTPROCESSING_REQUIRED = 3758096934;

const ERROR_INVALID_COINSTALLER = 3758096935;

const ERROR_NO_COMPAT_DRIVERS = 3758096936;

const ERROR_NO_DEVICE_ICON = 3758096937;

const ERROR_INVALID_INF_LOGCONFIG = 3758096938;

const ERROR_DI_DONT_INSTALL = 3758096939;

const ERROR_INVALID_FILTER_DRIVER = 3758096940;

const ERROR_NON_WINDOWS_NT_DRIVER = 3758096941;

const ERROR_NON_WINDOWS_DRIVER = 3758096942;

const ERROR_NO_CATALOG_FOR_OEM_INF = 3758096943;

const ERROR_DEVINSTALL_QUEUE_NONNATIVE = 3758096944;

const ERROR_NOT_DISABLEABLE = 3758096945;

const ERROR_CANT_REMOVE_DEVINST = 3758096946;

const ERROR_INVALID_TARGET = 3758096947;

const ERROR_DRIVER_NONNATIVE = 3758096948;

const ERROR_IN_WOW64 = 3758096949;

const ERROR_SET_SYSTEM_RESTORE_POINT = 3758096950;

const ERROR_SCE_DISABLED = 3758096952;

const ERROR_UNKNOWN_EXCEPTION = 3758096953;

const ERROR_PNP_REGISTRY_ERROR = 3758096954;

const ERROR_REMOTE_REQUEST_UNSUPPORTED = 3758096955;

const ERROR_NOT_AN_INSTALLED_OEM_INF = 3758096956;

const ERROR_INF_IN_USE_BY_DEVICES = 3758096957;

const ERROR_DI_FUNCTION_OBSOLETE = 3758096958;

const ERROR_NO_AUTHENTICODE_CATALOG = 3758096959;

const ERROR_AUTHENTICODE_DISALLOWED = 3758096960;

const ERROR_AUTHENTICODE_TRUSTED_PUBLISHER = 3758096961;

const ERROR_AUTHENTICODE_TRUST_NOT_ESTABLISHED = WIN32_ERROR(3758096962);

const ERROR_AUTHENTICODE_PUBLISHER_NOT_TRUSTED = WIN32_ERROR(3758096963);

const ERROR_SIGNATURE_OSATTRIBUTE_MISMATCH = 3758096964;

const ERROR_ONLY_VALIDATE_VIA_AUTHENTICODE = 3758096965;

const ERROR_DEVICE_INSTALLER_NOT_READY = 3758096966;

const ERROR_DRIVER_STORE_ADD_FAILED = 3758096967;

const ERROR_DEVICE_INSTALL_BLOCKED = 3758096968;

const ERROR_DRIVER_INSTALL_BLOCKED = 3758096969;

const ERROR_WRONG_INF_TYPE = 3758096970;

const ERROR_FILE_HASH_NOT_IN_CATALOG = 3758096971;

const ERROR_DRIVER_STORE_DELETE_FAILED = 3758096972;

const ERROR_UNRECOVERABLE_STACK_OVERFLOW = 3758097152;

const ERROR_NO_DEFAULT_INTERFACE_DEVICE = 3758096922;

const ERROR_INTERFACE_DEVICE_ACTIVE = 3758096923;

const ERROR_INTERFACE_DEVICE_REMOVED = 3758096924;

const ERROR_NO_SUCH_INTERFACE_DEVICE = 3758096933;

const ERROR_NOT_INSTALLED = 3758100480;

const ERROR_RING2SEG_MUST_BE_MOVABLE = 200;

const ERROR_RELOC_CHAIN_XEEDS_SEGLIM = 201;

const ERROR_INFLOOP_IN_RELOC_CHAIN = 202;

const ERROR_ENVVAR_NOT_FOUND = 203;

const ERROR_NO_SIGNAL_SENT = 205;

const ERROR_FILENAME_EXCED_RANGE = 206;

const ERROR_RING2_STACK_IN_USE = 207;

const ERROR_META_EXPANSION_TOO_LONG = 208;

const ERROR_INVALID_SIGNAL_NUMBER = 209;

const ERROR_THREAD_1_INACTIVE = 210;

const ERROR_LOCKED = 212;

const ERROR_TOO_MANY_MODULES = 214;

const ERROR_NESTING_NOT_ALLOWED = 215;

const ERROR_EXE_MACHINE_TYPE_MISMATCH = 216;

const ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY = 217;

const ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY = 218;

const ERROR_FILE_CHECKED_OUT = 220;

const ERROR_CHECKOUT_REQUIRED = 221;

const ERROR_BAD_FILE_TYPE = 222;

const ERROR_FILE_TOO_LARGE = 223;

const ERROR_FORMS_AUTH_REQUIRED = 224;

const ERROR_VIRUS_INFECTED = 225;

const ERROR_VIRUS_DELETED = 226;

const ERROR_PIPE_LOCAL = 229;

const ERROR_BAD_PIPE = 230;

const ERROR_PIPE_BUSY = 231;

const ERROR_NO_DATA = 232;

const ERROR_PIPE_NOT_CONNECTED = 233;

const ERROR_NO_WORK_DONE = 235;

const ERROR_VC_DISCONNECTED = 240;

const ERROR_INVALID_EA_NAME = 254;

const ERROR_EA_LIST_INCONSISTENT = 255;

const ERROR_CANNOT_COPY = 266;

const ERROR_DIRECTORY = 267;

const ERROR_EAS_DIDNT_FIT = 275;

const ERROR_EA_FILE_CORRUPT = 276;

const ERROR_EA_TABLE_FULL = 277;

const ERROR_INVALID_EA_HANDLE = 278;

const ERROR_EAS_NOT_SUPPORTED = 282;

const ERROR_NOT_OWNER = 288;

const ERROR_TOO_MANY_POSTS = 298;

const ERROR_PARTIAL_COPY = 299;

const ERROR_OPLOCK_NOT_GRANTED = 300;

const ERROR_INVALID_OPLOCK_PROTOCOL = 301;

const ERROR_DISK_TOO_FRAGMENTED = 302;

const ERROR_DELETE_PENDING = 303;

const ERROR_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING = WIN32_ERROR(
  304,
);

const ERROR_SHORT_NAMES_NOT_ENABLED_ON_VOLUME = 305;

const ERROR_SECURITY_STREAM_IS_INCONSISTENT = 306;

const ERROR_INVALID_LOCK_RANGE = 307;

const ERROR_IMAGE_SUBSYSTEM_NOT_PRESENT = 308;

const ERROR_NOTIFICATION_GUID_ALREADY_DEFINED = 309;

const ERROR_INVALID_EXCEPTION_HANDLER = 310;

const ERROR_DUPLICATE_PRIVILEGES = 311;

const ERROR_NO_RANGES_PROCESSED = 312;

const ERROR_NOT_ALLOWED_ON_SYSTEM_FILE = 313;

const ERROR_DISK_RESOURCES_EXHAUSTED = 314;

const ERROR_INVALID_TOKEN = 315;

const ERROR_DEVICE_FEATURE_NOT_SUPPORTED = 316;

const ERROR_MR_MID_NOT_FOUND = 317;

const ERROR_SCOPE_NOT_FOUND = 318;

const ERROR_UNDEFINED_SCOPE = 319;

const ERROR_INVALID_CAP = 320;

const ERROR_DEVICE_UNREACHABLE = 321;

const ERROR_DEVICE_NO_RESOURCES = 322;

const ERROR_DATA_CHECKSUM_ERROR = 323;

const ERROR_INTERMIXED_KERNEL_EA_OPERATION = 324;

const ERROR_FILE_LEVEL_TRIM_NOT_SUPPORTED = 326;

const ERROR_OFFSET_ALIGNMENT_VIOLATION = 327;

const ERROR_INVALID_FIELD_IN_PARAMETER_LIST = 328;

const ERROR_OPERATION_IN_PROGRESS = 329;

const ERROR_BAD_DEVICE_PATH = 330;

const ERROR_TOO_MANY_DESCRIPTORS = 331;

const ERROR_SCRUB_DATA_DISABLED = 332;

const ERROR_NOT_REDUNDANT_STORAGE = 333;

const ERROR_RESIDENT_FILE_NOT_SUPPORTED = 334;

const ERROR_COMPRESSED_FILE_NOT_SUPPORTED = 335;

const ERROR_DIRECTORY_NOT_SUPPORTED = 336;

const ERROR_NOT_READ_FROM_COPY = 337;

const ERROR_FT_WRITE_FAILURE = 338;

const ERROR_FT_DI_SCAN_REQUIRED = 339;

const ERROR_INVALID_KERNEL_INFO_VERSION = 340;

const ERROR_INVALID_PEP_INFO_VERSION = 341;

const ERROR_OBJECT_NOT_EXTERNALLY_BACKED = 342;

const ERROR_EXTERNAL_BACKING_PROVIDER_UNKNOWN = 343;

const ERROR_COMPRESSION_NOT_BENEFICIAL = 344;

const ERROR_STORAGE_TOPOLOGY_ID_MISMATCH = 345;

const ERROR_BLOCKED_BY_PARENTAL_CONTROLS = 346;

const ERROR_BLOCK_TOO_MANY_REFERENCES = 347;

const ERROR_MARKED_TO_DISALLOW_WRITES = 348;

const ERROR_ENCLAVE_FAILURE = 349;

const ERROR_FAIL_NOACTION_REBOOT = 350;

const ERROR_FAIL_SHUTDOWN = 351;

const ERROR_FAIL_RESTART = 352;

const ERROR_MAX_SESSIONS_REACHED = 353;

const ERROR_NETWORK_ACCESS_DENIED_EDP = 354;

const ERROR_DEVICE_HINT_NAME_BUFFER_TOO_SMALL = 355;

const ERROR_EDP_POLICY_DENIES_OPERATION = 356;

const ERROR_EDP_DPL_POLICY_CANT_BE_SATISFIED = 357;

const ERROR_CLOUD_FILE_SYNC_ROOT_METADATA_CORRUPT = 358;

const ERROR_DEVICE_IN_MAINTENANCE = 359;

const ERROR_NOT_SUPPORTED_ON_DAX = 360;

const ERROR_DAX_MAPPING_EXISTS = 361;

const ERROR_CLOUD_FILE_PROVIDER_NOT_RUNNING = 362;

const ERROR_CLOUD_FILE_METADATA_CORRUPT = 363;

const ERROR_CLOUD_FILE_METADATA_TOO_LARGE = 364;

const ERROR_CLOUD_FILE_PROPERTY_BLOB_TOO_LARGE = 365;

const ERROR_CLOUD_FILE_PROPERTY_BLOB_CHECKSUM_MISMATCH = WIN32_ERROR(366);

const ERROR_CHILD_PROCESS_BLOCKED = 367;

const ERROR_STORAGE_LOST_DATA_PERSISTENCE = 368;

const ERROR_FILE_SYSTEM_VIRTUALIZATION_UNAVAILABLE = 369;

const ERROR_FILE_SYSTEM_VIRTUALIZATION_METADATA_CORRUPT = WIN32_ERROR(370);

const ERROR_FILE_SYSTEM_VIRTUALIZATION_BUSY = 371;

const ERROR_FILE_SYSTEM_VIRTUALIZATION_PROVIDER_UNKNOWN = WIN32_ERROR(372);

const ERROR_GDI_HANDLE_LEAK = 373;

const ERROR_CLOUD_FILE_TOO_MANY_PROPERTY_BLOBS = 374;

const ERROR_CLOUD_FILE_PROPERTY_VERSION_NOT_SUPPORTED = WIN32_ERROR(375);

const ERROR_NOT_A_CLOUD_FILE = 376;

const ERROR_CLOUD_FILE_NOT_IN_SYNC = 377;

const ERROR_CLOUD_FILE_ALREADY_CONNECTED = 378;

const ERROR_CLOUD_FILE_NOT_SUPPORTED = 379;

const ERROR_CLOUD_FILE_INVALID_REQUEST = 380;

const ERROR_CLOUD_FILE_READ_ONLY_VOLUME = 381;

const ERROR_CLOUD_FILE_CONNECTED_PROVIDER_ONLY = 382;

const ERROR_CLOUD_FILE_VALIDATION_FAILED = 383;

const ERROR_SMB1_NOT_AVAILABLE = 384;

const ERROR_FILE_SYSTEM_VIRTUALIZATION_INVALID_OPERATION = WIN32_ERROR(385);

const ERROR_CLOUD_FILE_AUTHENTICATION_FAILED = 386;

const ERROR_CLOUD_FILE_INSUFFICIENT_RESOURCES = 387;

const ERROR_CLOUD_FILE_NETWORK_UNAVAILABLE = 388;

const ERROR_CLOUD_FILE_UNSUCCESSFUL = 389;

const ERROR_CLOUD_FILE_NOT_UNDER_SYNC_ROOT = 390;

const ERROR_CLOUD_FILE_IN_USE = 391;

const ERROR_CLOUD_FILE_PINNED = 392;

const ERROR_CLOUD_FILE_REQUEST_ABORTED = 393;

const ERROR_CLOUD_FILE_PROPERTY_CORRUPT = 394;

const ERROR_CLOUD_FILE_ACCESS_DENIED = 395;

const ERROR_CLOUD_FILE_INCOMPATIBLE_HARDLINKS = 396;

const ERROR_CLOUD_FILE_PROPERTY_LOCK_CONFLICT = 397;

const ERROR_CLOUD_FILE_REQUEST_CANCELED = 398;

const ERROR_EXTERNAL_SYSKEY_NOT_SUPPORTED = 399;

const ERROR_THREAD_MODE_ALREADY_BACKGROUND = 400;

const ERROR_THREAD_MODE_NOT_BACKGROUND = 401;

const ERROR_PROCESS_MODE_ALREADY_BACKGROUND = 402;

const ERROR_PROCESS_MODE_NOT_BACKGROUND = 403;

const ERROR_CLOUD_FILE_PROVIDER_TERMINATED = 404;

const ERROR_NOT_A_CLOUD_SYNC_ROOT = 405;

const ERROR_FILE_PROTECTED_UNDER_DPL = 406;

const ERROR_VOLUME_NOT_CLUSTER_ALIGNED = 407;

const ERROR_NO_PHYSICALLY_ALIGNED_FREE_SPACE_FOUND = 408;

const ERROR_APPX_FILE_NOT_ENCRYPTED = 409;

const ERROR_RWRAW_ENCRYPTED_FILE_NOT_ENCRYPTED = 410;

const ERROR_RWRAW_ENCRYPTED_INVALID_EDATAINFO_FILEOFFSET = WIN32_ERROR(411);

const ERROR_RWRAW_ENCRYPTED_INVALID_EDATAINFO_FILERANGE = WIN32_ERROR(412);

const ERROR_RWRAW_ENCRYPTED_INVALID_EDATAINFO_PARAMETER = WIN32_ERROR(413);

const ERROR_LINUX_SUBSYSTEM_NOT_PRESENT = 414;

const ERROR_FT_READ_FAILURE = 415;

const ERROR_STORAGE_RESERVE_ID_INVALID = 416;

const ERROR_STORAGE_RESERVE_DOES_NOT_EXIST = 417;

const ERROR_STORAGE_RESERVE_ALREADY_EXISTS = 418;

const ERROR_STORAGE_RESERVE_NOT_EMPTY = 419;

const ERROR_NOT_A_DAX_VOLUME = 420;

const ERROR_NOT_DAX_MAPPABLE = 421;

const ERROR_TIME_SENSITIVE_THREAD = 422;

const ERROR_DPL_NOT_SUPPORTED_FOR_USER = 423;

const ERROR_CASE_DIFFERING_NAMES_IN_DIR = 424;

const ERROR_FILE_NOT_SUPPORTED = 425;

const ERROR_CLOUD_FILE_REQUEST_TIMEOUT = 426;

const ERROR_NO_TASK_QUEUE = 427;

const ERROR_SRC_SRV_DLL_LOAD_FAILED = 428;

const ERROR_NOT_SUPPORTED_WITH_BTT = 429;

const ERROR_ENCRYPTION_DISABLED = 430;

const ERROR_ENCRYPTING_METADATA_DISALLOWED = 431;

const ERROR_CANT_CLEAR_ENCRYPTION_FLAG = 432;

const ERROR_NO_SUCH_DEVICE = 433;

const ERROR_CLOUD_FILE_DEHYDRATION_DISALLOWED = 434;

const ERROR_FILE_SNAP_IN_PROGRESS = 435;

const ERROR_FILE_SNAP_USER_SECTION_NOT_SUPPORTED = 436;

const ERROR_FILE_SNAP_MODIFY_NOT_SUPPORTED = 437;

const ERROR_FILE_SNAP_IO_NOT_COORDINATED = 438;

const ERROR_FILE_SNAP_UNEXPECTED_ERROR = 439;

const ERROR_FILE_SNAP_INVALID_PARAMETER = 440;

const ERROR_UNSATISFIED_DEPENDENCIES = 441;

const ERROR_CASE_SENSITIVE_PATH = 442;

const ERROR_UNEXPECTED_NTCACHEMANAGER_ERROR = 443;

const ERROR_LINUX_SUBSYSTEM_UPDATE_REQUIRED = 444;

const ERROR_DLP_POLICY_WARNS_AGAINST_OPERATION = 445;

const ERROR_DLP_POLICY_DENIES_OPERATION = 446;

const ERROR_SECURITY_DENIES_OPERATION = 447;

const ERROR_UNTRUSTED_MOUNT_POINT = 448;

const ERROR_DLP_POLICY_SILENTLY_FAIL = 449;

const ERROR_CAPAUTHZ_NOT_DEVUNLOCKED = 450;

const ERROR_CAPAUTHZ_CHANGE_TYPE = 451;

const ERROR_CAPAUTHZ_NOT_PROVISIONED = 452;

const ERROR_CAPAUTHZ_NOT_AUTHORIZED = 453;

const ERROR_CAPAUTHZ_NO_POLICY = 454;

const ERROR_CAPAUTHZ_DB_CORRUPTED = 455;

const ERROR_CAPAUTHZ_SCCD_INVALID_CATALOG = 456;

const ERROR_CAPAUTHZ_SCCD_NO_AUTH_ENTITY = 457;

const ERROR_CAPAUTHZ_SCCD_PARSE_ERROR = 458;

const ERROR_CAPAUTHZ_SCCD_DEV_MODE_REQUIRED = 459;

const ERROR_CAPAUTHZ_SCCD_NO_CAPABILITY_MATCH = 460;

const ERROR_CIMFS_IMAGE_CORRUPT = 470;

const ERROR_CIMFS_IMAGE_VERSION_NOT_SUPPORTED = 471;

const ERROR_STORAGE_STACK_ACCESS_DENIED = 472;

const ERROR_INSUFFICIENT_VIRTUAL_ADDR_RESOURCES = 473;

const ERROR_INDEX_OUT_OF_BOUNDS = 474;

const ERROR_CLOUD_FILE_US_MESSAGE_TIMEOUT = 475;

const ERROR_NOT_A_DEV_VOLUME = 476;

const ERROR_FS_GUID_MISMATCH = 477;

const ERROR_CANT_ATTACH_TO_DEV_VOLUME = 478;

const ERROR_INVALID_CONFIG_VALUE = 479;

const ERROR_PNP_QUERY_REMOVE_DEVICE_TIMEOUT = 480;

const ERROR_PNP_QUERY_REMOVE_RELATED_DEVICE_TIMEOUT = 481;

const ERROR_PNP_QUERY_REMOVE_UNRELATED_DEVICE_TIMEOUT = WIN32_ERROR(482);

const ERROR_DEVICE_HARDWARE_ERROR = 483;

const ERROR_INVALID_ADDRESS = 487;

const ERROR_HAS_SYSTEM_CRITICAL_FILES = 488;

const ERROR_ENCRYPTED_FILE_NOT_SUPPORTED = 489;

const ERROR_SPARSE_FILE_NOT_SUPPORTED = 490;

const ERROR_PAGEFILE_NOT_SUPPORTED = 491;

const ERROR_VOLUME_NOT_SUPPORTED = 492;

const ERROR_NOT_SUPPORTED_WITH_BYPASSIO = 493;

const ERROR_NO_BYPASSIO_DRIVER_SUPPORT = 494;

const ERROR_NOT_SUPPORTED_WITH_ENCRYPTION = 495;

const ERROR_NOT_SUPPORTED_WITH_COMPRESSION = 496;

const ERROR_NOT_SUPPORTED_WITH_REPLICATION = 497;

const ERROR_NOT_SUPPORTED_WITH_DEDUPLICATION = 498;

const ERROR_NOT_SUPPORTED_WITH_AUDITING = 499;

const ERROR_USER_PROFILE_LOAD = 500;

const ERROR_SESSION_KEY_TOO_SHORT = 501;

const ERROR_ACCESS_DENIED_APPDATA = 502;

const ERROR_NOT_SUPPORTED_WITH_MONITORING = 503;

const ERROR_NOT_SUPPORTED_WITH_SNAPSHOT = 504;

const ERROR_NOT_SUPPORTED_WITH_VIRTUALIZATION = 505;

const ERROR_BYPASSIO_FLT_NOT_SUPPORTED = 506;

const ERROR_DEVICE_RESET_REQUIRED = 507;

const ERROR_VOLUME_WRITE_ACCESS_DENIED = 508;

const ERROR_NOT_SUPPORTED_WITH_CACHED_HANDLE = 509;

const ERROR_FS_METADATA_INCONSISTENT = 510;

const ERROR_BLOCK_WEAK_REFERENCE_INVALID = 511;

const ERROR_BLOCK_SOURCE_WEAK_REFERENCE_INVALID = 512;

const ERROR_BLOCK_TARGET_WEAK_REFERENCE_INVALID = 513;

const ERROR_BLOCK_SHARED = 514;

const ERROR_VOLUME_UPGRADE_NOT_NEEDED = 515;

const ERROR_VOLUME_UPGRADE_PENDING = 516;

const ERROR_VOLUME_UPGRADE_DISABLED = 517;

const ERROR_VOLUME_UPGRADE_DISABLED_TILL_OS_DOWNGRADE_EXPIRED = WIN32_ERROR(
  518,
);

const ERROR_ARITHMETIC_OVERFLOW = 534;

const ERROR_PIPE_CONNECTED = 535;

const ERROR_PIPE_LISTENING = 536;

const ERROR_VERIFIER_STOP = 537;

const ERROR_ABIOS_ERROR = 538;

const ERROR_WX86_WARNING = 539;

const ERROR_WX86_ERROR = 540;

const ERROR_TIMER_NOT_CANCELED = 541;

const ERROR_UNWIND = 542;

const ERROR_BAD_STACK = 543;

const ERROR_INVALID_UNWIND_TARGET = 544;

const ERROR_INVALID_PORT_ATTRIBUTES = 545;

const ERROR_PORT_MESSAGE_TOO_LONG = 546;

const ERROR_INVALID_QUOTA_LOWER = 547;

const ERROR_DEVICE_ALREADY_ATTACHED = 548;

const ERROR_INSTRUCTION_MISALIGNMENT = 549;

const ERROR_PROFILING_NOT_STARTED = 550;

const ERROR_PROFILING_NOT_STOPPED = 551;

const ERROR_COULD_NOT_INTERPRET = 552;

const ERROR_PROFILING_AT_LIMIT = 553;

const ERROR_CANT_WAIT = 554;

const ERROR_CANT_TERMINATE_SELF = 555;

const ERROR_UNEXPECTED_MM_CREATE_ERR = 556;

const ERROR_UNEXPECTED_MM_MAP_ERROR = 557;

const ERROR_UNEXPECTED_MM_EXTEND_ERR = 558;

const ERROR_BAD_FUNCTION_TABLE = 559;

const ERROR_NO_GUID_TRANSLATION = 560;

const ERROR_INVALID_LDT_SIZE = 561;

const ERROR_INVALID_LDT_OFFSET = 563;

const ERROR_INVALID_LDT_DESCRIPTOR = 564;

const ERROR_TOO_MANY_THREADS = 565;

const ERROR_THREAD_NOT_IN_PROCESS = 566;

const ERROR_PAGEFILE_QUOTA_EXCEEDED = 567;

const ERROR_LOGON_SERVER_CONFLICT = 568;

const ERROR_SYNCHRONIZATION_REQUIRED = 569;

const ERROR_NET_OPEN_FAILED = 570;

const ERROR_IO_PRIVILEGE_FAILED = 571;

const ERROR_CONTROL_C_EXIT = 572;

const ERROR_MISSING_SYSTEMFILE = 573;

const ERROR_UNHANDLED_EXCEPTION = 574;

const ERROR_APP_INIT_FAILURE = 575;

const ERROR_PAGEFILE_CREATE_FAILED = 576;

const ERROR_INVALID_IMAGE_HASH = 577;

const ERROR_NO_PAGEFILE = 578;

const ERROR_ILLEGAL_FLOAT_CONTEXT = 579;

const ERROR_NO_EVENT_PAIR = 580;

const ERROR_DOMAIN_CTRLR_CONFIG_ERROR = 581;

const ERROR_ILLEGAL_CHARACTER = 582;

const ERROR_UNDEFINED_CHARACTER = 583;

const ERROR_FLOPPY_VOLUME = 584;

const ERROR_BIOS_FAILED_TO_CONNECT_INTERRUPT = 585;

const ERROR_BACKUP_CONTROLLER = 586;

const ERROR_MUTANT_LIMIT_EXCEEDED = 587;

const ERROR_FS_DRIVER_REQUIRED = 588;

const ERROR_CANNOT_LOAD_REGISTRY_FILE = 589;

const ERROR_DEBUG_ATTACH_FAILED = 590;

const ERROR_SYSTEM_PROCESS_TERMINATED = 591;

const ERROR_DATA_NOT_ACCEPTED = 592;

const ERROR_VDM_HARD_ERROR = 593;

const ERROR_DRIVER_CANCEL_TIMEOUT = 594;

const ERROR_REPLY_MESSAGE_MISMATCH = 595;

const ERROR_LOST_WRITEBEHIND_DATA = 596;

const ERROR_CLIENT_SERVER_PARAMETERS_INVALID = 597;

const ERROR_NOT_TINY_STREAM = 598;

const ERROR_STACK_OVERFLOW_READ = 599;

const ERROR_CONVERT_TO_LARGE = 600;

const ERROR_FOUND_OUT_OF_SCOPE = 601;

const ERROR_ALLOCATE_BUCKET = 602;

const ERROR_MARSHALL_OVERFLOW = 603;

const ERROR_INVALID_VARIANT = 604;

const ERROR_BAD_COMPRESSION_BUFFER = 605;

const ERROR_AUDIT_FAILED = 606;

const ERROR_TIMER_RESOLUTION_NOT_SET = 607;

const ERROR_INSUFFICIENT_LOGON_INFO = 608;

const ERROR_BAD_DLL_ENTRYPOINT = 609;

const ERROR_BAD_SERVICE_ENTRYPOINT = 610;

const ERROR_IP_ADDRESS_CONFLICT1 = 611;

const ERROR_IP_ADDRESS_CONFLICT2 = 612;

const ERROR_REGISTRY_QUOTA_LIMIT = 613;

const ERROR_NO_CALLBACK_ACTIVE = 614;

const ERROR_PWD_TOO_SHORT = 615;

const ERROR_PWD_TOO_RECENT = 616;

const ERROR_PWD_HISTORY_CONFLICT = 617;

const ERROR_UNSUPPORTED_COMPRESSION = 618;

const ERROR_INVALID_HW_PROFILE = 619;

const ERROR_INVALID_PLUGPLAY_DEVICE_PATH = 620;

const ERROR_QUOTA_LIST_INCONSISTENT = 621;

const ERROR_EVALUATION_EXPIRATION = 622;

const ERROR_ILLEGAL_DLL_RELOCATION = 623;

const ERROR_DLL_INIT_FAILED_LOGOFF = 624;

const ERROR_VALIDATE_CONTINUE = 625;

const ERROR_NO_MORE_MATCHES = 626;

const ERROR_RANGE_LIST_CONFLICT = 627;

const ERROR_SERVER_SID_MISMATCH = 628;

const ERROR_CANT_ENABLE_DENY_ONLY = 629;

const ERROR_FLOAT_MULTIPLE_FAULTS = 630;

const ERROR_FLOAT_MULTIPLE_TRAPS = 631;

const ERROR_NOINTERFACE = 632;

const ERROR_DRIVER_FAILED_SLEEP = 633;

const ERROR_CORRUPT_SYSTEM_FILE = 634;

const ERROR_COMMITMENT_MINIMUM = 635;

const ERROR_PNP_RESTART_ENUMERATION = 636;

const ERROR_SYSTEM_IMAGE_BAD_SIGNATURE = 637;

const ERROR_PNP_REBOOT_REQUIRED = 638;

const ERROR_INSUFFICIENT_POWER = 639;

const ERROR_MULTIPLE_FAULT_VIOLATION = 640;

const ERROR_SYSTEM_SHUTDOWN = 641;

const ERROR_PORT_NOT_SET = 642;

const ERROR_DS_VERSION_CHECK_FAILURE = 643;

const ERROR_RANGE_NOT_FOUND = 644;

const ERROR_NOT_SAFE_MODE_DRIVER = 646;

const ERROR_FAILED_DRIVER_ENTRY = 647;

const ERROR_DEVICE_ENUMERATION_ERROR = 648;

const ERROR_MOUNT_POINT_NOT_RESOLVED = 649;

const ERROR_INVALID_DEVICE_OBJECT_PARAMETER = 650;

const ERROR_MCA_OCCURED = 651;

const ERROR_DRIVER_DATABASE_ERROR = 652;

const ERROR_SYSTEM_HIVE_TOO_LARGE = 653;

const ERROR_DRIVER_FAILED_PRIOR_UNLOAD = 654;

const ERROR_VOLSNAP_PREPARE_HIBERNATE = 655;

const ERROR_HIBERNATION_FAILURE = 656;

const ERROR_PWD_TOO_LONG = 657;

const ERROR_FILE_SYSTEM_LIMITATION = 665;

const ERROR_ASSERTION_FAILURE = 668;

const ERROR_ACPI_ERROR = 669;

const ERROR_WOW_ASSERTION = 670;

const ERROR_PNP_BAD_MPS_TABLE = 671;

const ERROR_PNP_TRANSLATION_FAILED = 672;

const ERROR_PNP_IRQ_TRANSLATION_FAILED = 673;

const ERROR_PNP_INVALID_ID = 674;

const ERROR_WAKE_SYSTEM_DEBUGGER = 675;

const ERROR_HANDLES_CLOSED = 676;

const ERROR_EXTRANEOUS_INFORMATION = 677;

const ERROR_RXACT_COMMIT_NECESSARY = 678;

const ERROR_MEDIA_CHECK = 679;

const ERROR_GUID_SUBSTITUTION_MADE = 680;

const ERROR_STOPPED_ON_SYMLINK = 681;

const ERROR_LONGJUMP = 682;

const ERROR_PLUGPLAY_QUERY_VETOED = 683;

const ERROR_UNWIND_CONSOLIDATE = 684;

const ERROR_REGISTRY_HIVE_RECOVERED = 685;

const ERROR_DLL_MIGHT_BE_INSECURE = 686;

const ERROR_DLL_MIGHT_BE_INCOMPATIBLE = 687;

const ERROR_DBG_EXCEPTION_NOT_HANDLED = 688;

const ERROR_DBG_REPLY_LATER = 689;

const ERROR_DBG_UNABLE_TO_PROVIDE_HANDLE = 690;

const ERROR_DBG_TERMINATE_THREAD = 691;

const ERROR_DBG_TERMINATE_PROCESS = 692;

const ERROR_DBG_CONTROL_C = 693;

const ERROR_DBG_PRINTEXCEPTION_C = 694;

const ERROR_DBG_RIPEXCEPTION = 695;

const ERROR_DBG_CONTROL_BREAK = 696;

const ERROR_DBG_COMMAND_EXCEPTION = 697;

const ERROR_OBJECT_NAME_EXISTS = 698;

const ERROR_THREAD_WAS_SUSPENDED = 699;

const ERROR_IMAGE_NOT_AT_BASE = 700;

const ERROR_RXACT_STATE_CREATED = 701;

const ERROR_SEGMENT_NOTIFICATION = 702;

const ERROR_BAD_CURRENT_DIRECTORY = 703;

const ERROR_FT_READ_RECOVERY_FROM_BACKUP = 704;

const ERROR_FT_WRITE_RECOVERY = 705;

const ERROR_IMAGE_MACHINE_TYPE_MISMATCH = 706;

const ERROR_RECEIVE_PARTIAL = 707;

const ERROR_RECEIVE_EXPEDITED = 708;

const ERROR_RECEIVE_PARTIAL_EXPEDITED = 709;

const ERROR_EVENT_DONE = 710;

const ERROR_EVENT_PENDING = 711;

const ERROR_CHECKING_FILE_SYSTEM = 712;

const ERROR_FATAL_APP_EXIT = 713;

const ERROR_PREDEFINED_HANDLE = 714;

const ERROR_WAS_UNLOCKED = 715;

const ERROR_SERVICE_NOTIFICATION = 716;

const ERROR_WAS_LOCKED = 717;

const ERROR_LOG_HARD_ERROR = 718;

const ERROR_ALREADY_WIN32 = 719;

const ERROR_IMAGE_MACHINE_TYPE_MISMATCH_EXE = 720;

const ERROR_NO_YIELD_PERFORMED = 721;

const ERROR_TIMER_RESUME_IGNORED = 722;

const ERROR_ARBITRATION_UNHANDLED = 723;

const ERROR_CARDBUS_NOT_SUPPORTED = 724;

const ERROR_MP_PROCESSOR_MISMATCH = 725;

const ERROR_HIBERNATED = 726;

const ERROR_RESUME_HIBERNATION = 727;

const ERROR_FIRMWARE_UPDATED = 728;

const ERROR_DRIVERS_LEAKING_LOCKED_PAGES = 729;

const ERROR_WAKE_SYSTEM = 730;

const ERROR_WAIT_1 = 731;

const ERROR_WAIT_2 = 732;

const ERROR_WAIT_3 = 733;

const ERROR_WAIT_63 = 734;

const ERROR_ABANDONED_WAIT_0 = 735;

const ERROR_ABANDONED_WAIT_63 = 736;

const ERROR_USER_APC = 737;

const ERROR_KERNEL_APC = 738;

const ERROR_ALERTED = 739;

const ERROR_ELEVATION_REQUIRED = 740;

const ERROR_REPARSE = 741;

const ERROR_OPLOCK_BREAK_IN_PROGRESS = 742;

const ERROR_VOLUME_MOUNTED = 743;

const ERROR_RXACT_COMMITTED = 744;

const ERROR_NOTIFY_CLEANUP = 745;

const ERROR_PRIMARY_TRANSPORT_CONNECT_FAILED = 746;

const ERROR_PAGE_FAULT_TRANSITION = 747;

const ERROR_PAGE_FAULT_DEMAND_ZERO = 748;

const ERROR_PAGE_FAULT_COPY_ON_WRITE = 749;

const ERROR_PAGE_FAULT_GUARD_PAGE = 750;

const ERROR_PAGE_FAULT_PAGING_FILE = 751;

const ERROR_CACHE_PAGE_LOCKED = 752;

const ERROR_CRASH_DUMP = 753;

const ERROR_BUFFER_ALL_ZEROS = 754;

const ERROR_REPARSE_OBJECT = 755;

const ERROR_RESOURCE_REQUIREMENTS_CHANGED = 756;

const ERROR_TRANSLATION_COMPLETE = 757;

const ERROR_NOTHING_TO_TERMINATE = 758;

const ERROR_PROCESS_NOT_IN_JOB = 759;

const ERROR_PROCESS_IN_JOB = 760;

const ERROR_VOLSNAP_HIBERNATE_READY = 761;

const ERROR_FSFILTER_OP_COMPLETED_SUCCESSFULLY = 762;

const ERROR_INTERRUPT_VECTOR_ALREADY_CONNECTED = 763;

const ERROR_INTERRUPT_STILL_CONNECTED = 764;

const ERROR_WAIT_FOR_OPLOCK = 765;

const ERROR_DBG_EXCEPTION_HANDLED = 766;

const ERROR_DBG_CONTINUE = 767;

const ERROR_CALLBACK_POP_STACK = 768;

const ERROR_COMPRESSION_DISABLED = 769;

const ERROR_CANTFETCHBACKWARDS = 770;

const ERROR_CANTSCROLLBACKWARDS = 771;

const ERROR_ROWSNOTRELEASED = 772;

const ERROR_BAD_ACCESSOR_FLAGS = 773;

const ERROR_ERRORS_ENCOUNTERED = 774;

const ERROR_NOT_CAPABLE = 775;

const ERROR_REQUEST_OUT_OF_SEQUENCE = 776;

const ERROR_VERSION_PARSE_ERROR = 777;

const ERROR_BADSTARTPOSITION = 778;

const ERROR_MEMORY_HARDWARE = 779;

const ERROR_DISK_REPAIR_DISABLED = 780;

const ERROR_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE =
    WIN32_ERROR(781);

const ERROR_SYSTEM_POWERSTATE_TRANSITION = 782;

const ERROR_SYSTEM_POWERSTATE_COMPLEX_TRANSITION = 783;

const ERROR_MCA_EXCEPTION = 784;

const ERROR_ACCESS_AUDIT_BY_POLICY = 785;

const ERROR_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY = 786;

const ERROR_ABANDON_HIBERFILE = 787;

const ERROR_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED = WIN32_ERROR(788);

const ERROR_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR = WIN32_ERROR(789);

const ERROR_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR = 790;

const ERROR_BAD_MCFG_TABLE = 791;

const ERROR_DISK_REPAIR_REDIRECTED = 792;

const ERROR_DISK_REPAIR_UNSUCCESSFUL = 793;

const ERROR_CORRUPT_LOG_OVERFULL = 794;

const ERROR_CORRUPT_LOG_CORRUPTED = 795;

const ERROR_CORRUPT_LOG_UNAVAILABLE = 796;

const ERROR_CORRUPT_LOG_DELETED_FULL = 797;

const ERROR_CORRUPT_LOG_CLEARED = 798;

const ERROR_ORPHAN_NAME_EXHAUSTED = 799;

const ERROR_OPLOCK_SWITCHED_TO_NEW_HANDLE = 800;

const ERROR_CANNOT_GRANT_REQUESTED_OPLOCK = 801;

const ERROR_CANNOT_BREAK_OPLOCK = 802;

const ERROR_OPLOCK_HANDLE_CLOSED = 803;

const ERROR_NO_ACE_CONDITION = 804;

const ERROR_INVALID_ACE_CONDITION = 805;

const ERROR_FILE_HANDLE_REVOKED = 806;

const ERROR_IMAGE_AT_DIFFERENT_BASE = 807;

const ERROR_ENCRYPTED_IO_NOT_POSSIBLE = 808;

const ERROR_FILE_METADATA_OPTIMIZATION_IN_PROGRESS = 809;

const ERROR_QUOTA_ACTIVITY = 810;

const ERROR_HANDLE_REVOKED = 811;

const ERROR_CALLBACK_INVOKE_INLINE = 812;

const ERROR_CPU_SET_INVALID = 813;

const ERROR_ENCLAVE_NOT_TERMINATED = 814;

const ERROR_ENCLAVE_VIOLATION = 815;

const ERROR_SERVER_TRANSPORT_CONFLICT = 816;

const ERROR_CERTIFICATE_VALIDATION_PREFERENCE_CONFLICT = WIN32_ERROR(817);

const ERROR_FT_READ_FROM_COPY_FAILURE = 818;

const ERROR_SECTION_DIRECT_MAP_ONLY = 819;

const ERROR_EA_ACCESS_DENIED = 994;

const ERROR_OPERATION_ABORTED = 995;

const ERROR_IO_INCOMPLETE = 996;

const ERROR_IO_PENDING = 997;

const ERROR_NOACCESS = 998;

const ERROR_SWAPERROR = 999;

const ERROR_STACK_OVERFLOW = 1001;

const ERROR_INVALID_MESSAGE = 1002;

const ERROR_CAN_NOT_COMPLETE = 1003;

const ERROR_UNRECOGNIZED_VOLUME = 1005;

const ERROR_FILE_INVALID = 1006;

const ERROR_FULLSCREEN_MODE = 1007;

const ERROR_NO_TOKEN = 1008;

const ERROR_BADDB = 1009;

const ERROR_BADKEY = 1010;

const ERROR_CANTOPEN = 1011;

const ERROR_CANTREAD = 1012;

const ERROR_CANTWRITE = 1013;

const ERROR_REGISTRY_RECOVERED = 1014;

const ERROR_REGISTRY_CORRUPT = 1015;

const ERROR_REGISTRY_IO_FAILED = 1016;

const ERROR_NOT_REGISTRY_FILE = 1017;

const ERROR_KEY_DELETED = 1018;

const ERROR_NO_LOG_SPACE = 1019;

const ERROR_KEY_HAS_CHILDREN = 1020;

const ERROR_CHILD_MUST_BE_VOLATILE = 1021;

const ERROR_NOTIFY_ENUM_DIR = 1022;

const ERROR_DEPENDENT_SERVICES_RUNNING = 1051;

const ERROR_INVALID_SERVICE_CONTROL = 1052;

const ERROR_SERVICE_REQUEST_TIMEOUT = 1053;

const ERROR_SERVICE_NO_THREAD = 1054;

const ERROR_SERVICE_DATABASE_LOCKED = 1055;

const ERROR_SERVICE_ALREADY_RUNNING = 1056;

const ERROR_INVALID_SERVICE_ACCOUNT = 1057;

const ERROR_SERVICE_DISABLED = 1058;

const ERROR_CIRCULAR_DEPENDENCY = 1059;

const ERROR_SERVICE_DOES_NOT_EXIST = 1060;

const ERROR_SERVICE_CANNOT_ACCEPT_CTRL = 1061;

const ERROR_FAILED_SERVICE_CONTROLLER_CONNECT = 1063;

const ERROR_EXCEPTION_IN_SERVICE = 1064;

const ERROR_DATABASE_DOES_NOT_EXIST = 1065;

const ERROR_SERVICE_SPECIFIC_ERROR = 1066;

const ERROR_PROCESS_ABORTED = 1067;

const ERROR_SERVICE_DEPENDENCY_FAIL = 1068;

const ERROR_SERVICE_LOGON_FAILED = 1069;

const ERROR_SERVICE_START_HANG = 1070;

const ERROR_INVALID_SERVICE_LOCK = 1071;

const ERROR_SERVICE_MARKED_FOR_DELETE = 1072;

const ERROR_SERVICE_EXISTS = 1073;

const ERROR_ALREADY_RUNNING_LKG = 1074;

const ERROR_SERVICE_DEPENDENCY_DELETED = 1075;

const ERROR_BOOT_ALREADY_ACCEPTED = 1076;

const ERROR_SERVICE_NEVER_STARTED = 1077;

const ERROR_DUPLICATE_SERVICE_NAME = 1078;

const ERROR_DIFFERENT_SERVICE_ACCOUNT = 1079;

const ERROR_CANNOT_DETECT_DRIVER_FAILURE = 1080;

const ERROR_CANNOT_DETECT_PROCESS_ABORT = 1081;

const ERROR_NO_RECOVERY_PROGRAM = 1082;

const ERROR_SERVICE_NOT_IN_EXE = 1083;

const ERROR_NOT_SAFEBOOT_SERVICE = 1084;

const ERROR_END_OF_MEDIA = 1100;

const ERROR_FILEMARK_DETECTED = 1101;

const ERROR_BEGINNING_OF_MEDIA = 1102;

const ERROR_SETMARK_DETECTED = 1103;

const ERROR_NO_DATA_DETECTED = 1104;

const ERROR_PARTITION_FAILURE = 1105;

const ERROR_INVALID_BLOCK_LENGTH = 1106;

const ERROR_DEVICE_NOT_PARTITIONED = 1107;

const ERROR_UNABLE_TO_LOCK_MEDIA = 1108;

const ERROR_UNABLE_TO_UNLOAD_MEDIA = 1109;

const ERROR_MEDIA_CHANGED = 1110;

const ERROR_BUS_RESET = 1111;

const ERROR_NO_MEDIA_IN_DRIVE = 1112;

const ERROR_NO_UNICODE_TRANSLATION = 1113;

const ERROR_DLL_INIT_FAILED = 1114;

const ERROR_SHUTDOWN_IN_PROGRESS = 1115;

const ERROR_NO_SHUTDOWN_IN_PROGRESS = 1116;

const ERROR_IO_DEVICE = 1117;

const ERROR_SERIAL_NO_DEVICE = 1118;

const ERROR_IRQ_BUSY = 1119;

const ERROR_MORE_WRITES = 1120;

const ERROR_COUNTER_TIMEOUT = 1121;

const ERROR_FLOPPY_ID_MARK_NOT_FOUND = 1122;

const ERROR_FLOPPY_WRONG_CYLINDER = 1123;

const ERROR_FLOPPY_UNKNOWN_ERROR = 1124;

const ERROR_FLOPPY_BAD_REGISTERS = 1125;

const ERROR_DISK_RECALIBRATE_FAILED = 1126;

const ERROR_DISK_OPERATION_FAILED = 1127;

const ERROR_DISK_RESET_FAILED = 1128;

const ERROR_EOM_OVERFLOW = 1129;

const ERROR_NOT_ENOUGH_SERVER_MEMORY = 1130;

const ERROR_POSSIBLE_DEADLOCK = 1131;

const ERROR_MAPPED_ALIGNMENT = 1132;

const ERROR_SET_POWER_STATE_VETOED = 1140;

const ERROR_SET_POWER_STATE_FAILED = 1141;

const ERROR_TOO_MANY_LINKS = 1142;

const ERROR_OLD_WIN_VERSION = 1150;

const ERROR_APP_WRONG_OS = 1151;

const ERROR_SINGLE_INSTANCE_APP = 1152;

const ERROR_RMODE_APP = 1153;

const ERROR_INVALID_DLL = 1154;

const ERROR_NO_ASSOCIATION = 1155;

const ERROR_DDE_FAIL = 1156;

const ERROR_DLL_NOT_FOUND = 1157;

const ERROR_NO_MORE_USER_HANDLES = 1158;

const ERROR_MESSAGE_SYNC_ONLY = 1159;

const ERROR_SOURCE_ELEMENT_EMPTY = 1160;

const ERROR_DESTINATION_ELEMENT_FULL = 1161;

const ERROR_ILLEGAL_ELEMENT_ADDRESS = 1162;

const ERROR_MAGAZINE_NOT_PRESENT = 1163;

const ERROR_DEVICE_REINITIALIZATION_NEEDED = 1164;

const ERROR_DEVICE_REQUIRES_CLEANING = 1165;

const ERROR_DEVICE_DOOR_OPEN = 1166;

const ERROR_NO_MATCH = 1169;

const ERROR_SET_NOT_FOUND = 1170;

const ERROR_POINT_NOT_FOUND = 1171;

const ERROR_NO_TRACKING_SERVICE = 1172;

const ERROR_NO_VOLUME_ID = 1173;

const ERROR_UNABLE_TO_REMOVE_REPLACED = 1175;

const ERROR_UNABLE_TO_MOVE_REPLACEMENT = 1176;

const ERROR_UNABLE_TO_MOVE_REPLACEMENT_2 = 1177;

const ERROR_JOURNAL_DELETE_IN_PROGRESS = 1178;

const ERROR_JOURNAL_NOT_ACTIVE = 1179;

const ERROR_POTENTIAL_FILE_FOUND = 1180;

const ERROR_JOURNAL_ENTRY_DELETED = 1181;

const ERROR_PARTITION_TERMINATING = 1184;

const ERROR_SHUTDOWN_IS_SCHEDULED = 1190;

const ERROR_SHUTDOWN_USERS_LOGGED_ON = 1191;

const ERROR_SHUTDOWN_DISKS_NOT_IN_MAINTENANCE_MODE = 1192;

const ERROR_BAD_DEVICE = 1200;

const ERROR_CONNECTION_UNAVAIL = 1201;

const ERROR_DEVICE_ALREADY_REMEMBERED = 1202;

const ERROR_NO_NET_OR_BAD_PATH = 1203;

const ERROR_BAD_PROVIDER = 1204;

const ERROR_CANNOT_OPEN_PROFILE = 1205;

const ERROR_BAD_PROFILE = 1206;

const ERROR_NOT_CONTAINER = 1207;

const ERROR_EXTENDED_ERROR = 1208;

const ERROR_INVALID_GROUPNAME = 1209;

const ERROR_INVALID_COMPUTERNAME = 1210;

const ERROR_INVALID_EVENTNAME = 1211;

const ERROR_INVALID_DOMAINNAME = 1212;

const ERROR_INVALID_SERVICENAME = 1213;

const ERROR_INVALID_NETNAME = 1214;

const ERROR_INVALID_SHARENAME = 1215;

const ERROR_INVALID_PASSWORDNAME = 1216;

const ERROR_INVALID_MESSAGENAME = 1217;

const ERROR_INVALID_MESSAGEDEST = 1218;

const ERROR_SESSION_CREDENTIAL_CONFLICT = 1219;

const ERROR_REMOTE_SESSION_LIMIT_EXCEEDED = 1220;

const ERROR_DUP_DOMAINNAME = 1221;

const ERROR_NO_NETWORK = 1222;

const ERROR_USER_MAPPED_FILE = 1224;

const ERROR_CONNECTION_REFUSED = 1225;

const ERROR_GRACEFUL_DISCONNECT = 1226;

const ERROR_ADDRESS_ALREADY_ASSOCIATED = 1227;

const ERROR_ADDRESS_NOT_ASSOCIATED = 1228;

const ERROR_CONNECTION_INVALID = 1229;

const ERROR_CONNECTION_ACTIVE = 1230;

const ERROR_NETWORK_UNREACHABLE = 1231;

const ERROR_HOST_UNREACHABLE = 1232;

const ERROR_PROTOCOL_UNREACHABLE = 1233;

const ERROR_PORT_UNREACHABLE = 1234;

const ERROR_REQUEST_ABORTED = 1235;

const ERROR_CONNECTION_ABORTED = 1236;

const ERROR_RETRY = 1237;

const ERROR_CONNECTION_COUNT_LIMIT = 1238;

const ERROR_LOGIN_TIME_RESTRICTION = 1239;

const ERROR_LOGIN_WKSTA_RESTRICTION = 1240;

const ERROR_INCORRECT_ADDRESS = 1241;

const ERROR_ALREADY_REGISTERED = 1242;

const ERROR_SERVICE_NOT_FOUND = 1243;

const ERROR_NOT_AUTHENTICATED = 1244;

const ERROR_NOT_LOGGED_ON = 1245;

const ERROR_CONTINUE = 1246;

const ERROR_ALREADY_INITIALIZED = 1247;

const ERROR_NO_MORE_DEVICES = 1248;

const ERROR_NO_SUCH_SITE = 1249;

const ERROR_DOMAIN_CONTROLLER_EXISTS = 1250;

const ERROR_ONLY_IF_CONNECTED = 1251;

const ERROR_OVERRIDE_NOCHANGES = 1252;

const ERROR_BAD_USER_PROFILE = 1253;

const ERROR_NOT_SUPPORTED_ON_SBS = 1254;

const ERROR_SERVER_SHUTDOWN_IN_PROGRESS = 1255;

const ERROR_HOST_DOWN = 1256;

const ERROR_NON_ACCOUNT_SID = 1257;

const ERROR_NON_DOMAIN_SID = 1258;

const ERROR_APPHELP_BLOCK = 1259;

const ERROR_ACCESS_DISABLED_BY_POLICY = 1260;

const ERROR_REG_NAT_CONSUMPTION = 1261;

const ERROR_CSCSHARE_OFFLINE = 1262;

const ERROR_PKINIT_FAILURE = 1263;

const ERROR_SMARTCARD_SUBSYSTEM_FAILURE = 1264;

const ERROR_DOWNGRADE_DETECTED = 1265;

const ERROR_MACHINE_LOCKED = 1271;

const ERROR_SMB_GUEST_LOGON_BLOCKED = 1272;

const ERROR_CALLBACK_SUPPLIED_INVALID_DATA = 1273;

const ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED = 1274;

const ERROR_DRIVER_BLOCKED = 1275;

const ERROR_INVALID_IMPORT_OF_NON_DLL = 1276;

const ERROR_ACCESS_DISABLED_WEBBLADE = 1277;

const ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER = 1278;

const ERROR_RECOVERY_FAILURE = 1279;

const ERROR_ALREADY_FIBER = 1280;

const ERROR_ALREADY_THREAD = 1281;

const ERROR_STACK_BUFFER_OVERRUN = 1282;

const ERROR_PARAMETER_QUOTA_EXCEEDED = 1283;

const ERROR_DEBUGGER_INACTIVE = 1284;

const ERROR_DELAY_LOAD_FAILED = 1285;

const ERROR_VDM_DISALLOWED = 1286;

const ERROR_UNIDENTIFIED_ERROR = 1287;

const ERROR_INVALID_CRUNTIME_PARAMETER = 1288;

const ERROR_BEYOND_VDL = 1289;

const ERROR_INCOMPATIBLE_SERVICE_SID_TYPE = 1290;

const ERROR_DRIVER_PROCESS_TERMINATED = 1291;

const ERROR_IMPLEMENTATION_LIMIT = 1292;

const ERROR_PROCESS_IS_PROTECTED = 1293;

const ERROR_SERVICE_NOTIFY_CLIENT_LAGGING = 1294;

const ERROR_DISK_QUOTA_EXCEEDED = 1295;

const ERROR_CONTENT_BLOCKED = 1296;

const ERROR_INCOMPATIBLE_SERVICE_PRIVILEGE = 1297;

const ERROR_APP_HANG = 1298;

const ERROR_INVALID_LABEL = 1299;

const ERROR_NOT_ALL_ASSIGNED = 1300;

const ERROR_SOME_NOT_MAPPED = 1301;

const ERROR_NO_QUOTAS_FOR_ACCOUNT = 1302;

const ERROR_LOCAL_USER_SESSION_KEY = 1303;

const ERROR_NULL_LM_PASSWORD = 1304;

const ERROR_UNKNOWN_REVISION = 1305;

const ERROR_INVALID_OWNER = 1307;

const ERROR_INVALID_PRIMARY_GROUP = 1308;

const ERROR_NO_IMPERSONATION_TOKEN = 1309;

const ERROR_CANT_DISABLE_MANDATORY = 1310;

const ERROR_NO_LOGON_SERVERS = 1311;

const ERROR_NO_SUCH_PRIVILEGE = 1313;

const ERROR_PRIVILEGE_NOT_HELD = 1314;

const ERROR_INVALID_ACCOUNT_NAME = 1315;

const ERROR_USER_EXISTS = 1316;

const ERROR_NO_SUCH_USER = 1317;

const ERROR_GROUP_EXISTS = 1318;

const ERROR_NO_SUCH_GROUP = 1319;

const ERROR_MEMBER_IN_GROUP = 1320;

const ERROR_MEMBER_NOT_IN_GROUP = 1321;

const ERROR_LAST_ADMIN = 1322;

const ERROR_WRONG_PASSWORD = 1323;

const ERROR_ILL_FORMED_PASSWORD = 1324;

const ERROR_PASSWORD_RESTRICTION = 1325;

const ERROR_LOGON_FAILURE = 1326;

const ERROR_ACCOUNT_RESTRICTION = 1327;

const ERROR_INVALID_LOGON_HOURS = 1328;

const ERROR_INVALID_WORKSTATION = 1329;

const ERROR_PASSWORD_EXPIRED = 1330;

const ERROR_ACCOUNT_DISABLED = 1331;

const ERROR_NONE_MAPPED = 1332;

const ERROR_TOO_MANY_LUIDS_REQUESTED = 1333;

const ERROR_LUIDS_EXHAUSTED = 1334;

const ERROR_INVALID_SUB_AUTHORITY = 1335;

const ERROR_INVALID_ACL = 1336;

const ERROR_INVALID_SID = 1337;

const ERROR_INVALID_SECURITY_DESCR = 1338;

const ERROR_BAD_INHERITANCE_ACL = 1340;

const ERROR_SERVER_DISABLED = 1341;

const ERROR_SERVER_NOT_DISABLED = 1342;

const ERROR_INVALID_ID_AUTHORITY = 1343;

const ERROR_ALLOTTED_SPACE_EXCEEDED = 1344;

const ERROR_INVALID_GROUP_ATTRIBUTES = 1345;

const ERROR_BAD_IMPERSONATION_LEVEL = 1346;

const ERROR_CANT_OPEN_ANONYMOUS = 1347;

const ERROR_BAD_VALIDATION_CLASS = 1348;

const ERROR_BAD_TOKEN_TYPE = 1349;

const ERROR_NO_SECURITY_ON_OBJECT = 1350;

const ERROR_CANT_ACCESS_DOMAIN_INFO = 1351;

const ERROR_INVALID_SERVER_STATE = 1352;

const ERROR_INVALID_DOMAIN_STATE = 1353;

const ERROR_INVALID_DOMAIN_ROLE = 1354;

const ERROR_NO_SUCH_DOMAIN = 1355;

const ERROR_DOMAIN_EXISTS = 1356;

const ERROR_DOMAIN_LIMIT_EXCEEDED = 1357;

const ERROR_INTERNAL_DB_CORRUPTION = 1358;

const ERROR_INTERNAL_ERROR = 1359;

const ERROR_GENERIC_NOT_MAPPED = 1360;

const ERROR_BAD_DESCRIPTOR_FORMAT = 1361;

const ERROR_NOT_LOGON_PROCESS = 1362;

const ERROR_LOGON_SESSION_EXISTS = 1363;

const ERROR_NO_SUCH_PACKAGE = 1364;

const ERROR_BAD_LOGON_SESSION_STATE = 1365;

const ERROR_LOGON_SESSION_COLLISION = 1366;

const ERROR_INVALID_LOGON_TYPE = 1367;

const ERROR_CANNOT_IMPERSONATE = 1368;

const ERROR_RXACT_INVALID_STATE = 1369;

const ERROR_RXACT_COMMIT_FAILURE = 1370;

const ERROR_SPECIAL_ACCOUNT = 1371;

const ERROR_SPECIAL_GROUP = 1372;

const ERROR_SPECIAL_USER = 1373;

const ERROR_MEMBERS_PRIMARY_GROUP = 1374;

const ERROR_TOKEN_ALREADY_IN_USE = 1375;

const ERROR_NO_SUCH_ALIAS = 1376;

const ERROR_MEMBER_NOT_IN_ALIAS = 1377;

const ERROR_MEMBER_IN_ALIAS = 1378;

const ERROR_ALIAS_EXISTS = 1379;

const ERROR_LOGON_NOT_GRANTED = 1380;

const ERROR_TOO_MANY_SECRETS = 1381;

const ERROR_SECRET_TOO_LONG = 1382;

const ERROR_INTERNAL_DB_ERROR = 1383;

const ERROR_TOO_MANY_CONTEXT_IDS = 1384;

const ERROR_LOGON_TYPE_NOT_GRANTED = 1385;

const ERROR_NT_CROSS_ENCRYPTION_REQUIRED = 1386;

const ERROR_NO_SUCH_MEMBER = 1387;

const ERROR_INVALID_MEMBER = 1388;

const ERROR_TOO_MANY_SIDS = 1389;

const ERROR_LM_CROSS_ENCRYPTION_REQUIRED = 1390;

const ERROR_NO_INHERITANCE = 1391;

const ERROR_FILE_CORRUPT = 1392;

const ERROR_DISK_CORRUPT = 1393;

const ERROR_NO_USER_SESSION_KEY = 1394;

const ERROR_LICENSE_QUOTA_EXCEEDED = 1395;

const ERROR_WRONG_TARGET_NAME = 1396;

const ERROR_MUTUAL_AUTH_FAILED = 1397;

const ERROR_TIME_SKEW = 1398;

const ERROR_CURRENT_DOMAIN_NOT_ALLOWED = 1399;

const ERROR_INVALID_WINDOW_HANDLE = 1400;

const ERROR_INVALID_MENU_HANDLE = 1401;

const ERROR_INVALID_CURSOR_HANDLE = 1402;

const ERROR_INVALID_ACCEL_HANDLE = 1403;

const ERROR_INVALID_HOOK_HANDLE = 1404;

const ERROR_INVALID_DWP_HANDLE = 1405;

const ERROR_TLW_WITH_WSCHILD = 1406;

const ERROR_CANNOT_FIND_WND_CLASS = 1407;

const ERROR_WINDOW_OF_OTHER_THREAD = 1408;

const ERROR_HOTKEY_ALREADY_REGISTERED = 1409;

const ERROR_CLASS_ALREADY_EXISTS = 1410;

const ERROR_CLASS_DOES_NOT_EXIST = 1411;

const ERROR_CLASS_HAS_WINDOWS = 1412;

const ERROR_INVALID_INDEX = 1413;

const ERROR_INVALID_ICON_HANDLE = 1414;

const ERROR_PRIVATE_DIALOG_INDEX = 1415;

const ERROR_LISTBOX_ID_NOT_FOUND = 1416;

const ERROR_NO_WILDCARD_CHARACTERS = 1417;

const ERROR_CLIPBOARD_NOT_OPEN = 1418;

const ERROR_HOTKEY_NOT_REGISTERED = 1419;

const ERROR_WINDOW_NOT_DIALOG = 1420;

const ERROR_CONTROL_ID_NOT_FOUND = 1421;

const ERROR_INVALID_COMBOBOX_MESSAGE = 1422;

const ERROR_WINDOW_NOT_COMBOBOX = 1423;

const ERROR_INVALID_EDIT_HEIGHT = 1424;

const ERROR_DC_NOT_FOUND = 1425;

const ERROR_INVALID_HOOK_FILTER = 1426;

const ERROR_INVALID_FILTER_PROC = 1427;

const ERROR_HOOK_NEEDS_HMOD = 1428;

const ERROR_GLOBAL_ONLY_HOOK = 1429;

const ERROR_JOURNAL_HOOK_SET = 1430;

const ERROR_HOOK_NOT_INSTALLED = 1431;

const ERROR_INVALID_LB_MESSAGE = 1432;

const ERROR_SETCOUNT_ON_BAD_LB = 1433;

const ERROR_LB_WITHOUT_TABSTOPS = 1434;

const ERROR_DESTROY_OBJECT_OF_OTHER_THREAD = 1435;

const ERROR_CHILD_WINDOW_MENU = 1436;

const ERROR_NO_SYSTEM_MENU = 1437;

const ERROR_INVALID_MSGBOX_STYLE = 1438;

const ERROR_INVALID_SPI_VALUE = 1439;

const ERROR_SCREEN_ALREADY_LOCKED = 1440;

const ERROR_HWNDS_HAVE_DIFF_PARENT = 1441;

const ERROR_NOT_CHILD_WINDOW = 1442;

const ERROR_INVALID_GW_COMMAND = 1443;

const ERROR_INVALID_THREAD_ID = 1444;

const ERROR_NON_MDICHILD_WINDOW = 1445;

const ERROR_POPUP_ALREADY_ACTIVE = 1446;

const ERROR_NO_SCROLLBARS = 1447;

const ERROR_INVALID_SCROLLBAR_RANGE = 1448;

const ERROR_INVALID_SHOWWIN_COMMAND = 1449;

const ERROR_NO_SYSTEM_RESOURCES = 1450;

const ERROR_NONPAGED_SYSTEM_RESOURCES = 1451;

const ERROR_PAGED_SYSTEM_RESOURCES = 1452;

const ERROR_WORKING_SET_QUOTA = 1453;

const ERROR_PAGEFILE_QUOTA = 1454;

const ERROR_COMMITMENT_LIMIT = 1455;

const ERROR_MENU_ITEM_NOT_FOUND = 1456;

const ERROR_INVALID_KEYBOARD_HANDLE = 1457;

const ERROR_HOOK_TYPE_NOT_ALLOWED = 1458;

const ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION = 1459;

const ERROR_TIMEOUT = 1460;

const ERROR_INVALID_MONITOR_HANDLE = 1461;

const ERROR_INCORRECT_SIZE = 1462;

const ERROR_SYMLINK_CLASS_DISABLED = 1463;

const ERROR_SYMLINK_NOT_SUPPORTED = 1464;

const ERROR_XML_PARSE_ERROR = 1465;

const ERROR_XMLDSIG_ERROR = 1466;

const ERROR_RESTART_APPLICATION = 1467;

const ERROR_WRONG_COMPARTMENT = 1468;

const ERROR_AUTHIP_FAILURE = 1469;

const ERROR_NO_NVRAM_RESOURCES = 1470;

const ERROR_NOT_GUI_PROCESS = 1471;

const ERROR_EVENTLOG_FILE_CORRUPT = 1500;

const ERROR_EVENTLOG_CANT_START = 1501;

const ERROR_LOG_FILE_FULL = 1502;

const ERROR_EVENTLOG_FILE_CHANGED = 1503;

const ERROR_CONTAINER_ASSIGNED = 1504;

const ERROR_JOB_NO_CONTAINER = 1505;

const ERROR_INVALID_TASK_NAME = 1550;

const ERROR_INVALID_TASK_INDEX = 1551;

const ERROR_THREAD_ALREADY_IN_TASK = 1552;

const ERROR_INSTALL_SERVICE_FAILURE = 1601;

const ERROR_INSTALL_USEREXIT = 1602;

const ERROR_INSTALL_FAILURE = 1603;

const ERROR_INSTALL_SUSPEND = 1604;

const ERROR_UNKNOWN_PRODUCT = 1605;

const ERROR_UNKNOWN_FEATURE = 1606;

const ERROR_UNKNOWN_COMPONENT = 1607;

const ERROR_UNKNOWN_PROPERTY = 1608;

const ERROR_INVALID_HANDLE_STATE = 1609;

const ERROR_BAD_CONFIGURATION = 1610;

const ERROR_INDEX_ABSENT = 1611;

const ERROR_INSTALL_SOURCE_ABSENT = 1612;

const ERROR_INSTALL_PACKAGE_VERSION = 1613;

const ERROR_PRODUCT_UNINSTALLED = 1614;

const ERROR_BAD_QUERY_SYNTAX = 1615;

const ERROR_INVALID_FIELD = 1616;

const ERROR_DEVICE_REMOVED = 1617;

const ERROR_INSTALL_ALREADY_RUNNING = 1618;

const ERROR_INSTALL_PACKAGE_OPEN_FAILED = 1619;

const ERROR_INSTALL_PACKAGE_INVALID = 1620;

const ERROR_INSTALL_UI_FAILURE = 1621;

const ERROR_INSTALL_LOG_FAILURE = 1622;

const ERROR_INSTALL_LANGUAGE_UNSUPPORTED = 1623;

const ERROR_INSTALL_TRANSFORM_FAILURE = 1624;

const ERROR_INSTALL_PACKAGE_REJECTED = 1625;

const ERROR_FUNCTION_NOT_CALLED = 1626;

const ERROR_FUNCTION_FAILED = 1627;

const ERROR_INVALID_TABLE = 1628;

const ERROR_DATATYPE_MISMATCH = 1629;

const ERROR_UNSUPPORTED_TYPE = 1630;

const ERROR_CREATE_FAILED = 1631;

const ERROR_INSTALL_TEMP_UNWRITABLE = 1632;

const ERROR_INSTALL_PLATFORM_UNSUPPORTED = 1633;

const ERROR_INSTALL_NOTUSED = 1634;

const ERROR_PATCH_PACKAGE_OPEN_FAILED = 1635;

const ERROR_PATCH_PACKAGE_INVALID = 1636;

const ERROR_PATCH_PACKAGE_UNSUPPORTED = 1637;

const ERROR_PRODUCT_VERSION = 1638;

const ERROR_INVALID_COMMAND_LINE = 1639;

const ERROR_INSTALL_REMOTE_DISALLOWED = 1640;

const ERROR_SUCCESS_REBOOT_INITIATED = 1641;

const ERROR_PATCH_TARGET_NOT_FOUND = 1642;

const ERROR_PATCH_PACKAGE_REJECTED = 1643;

const ERROR_INSTALL_TRANSFORM_REJECTED = 1644;

const ERROR_INSTALL_REMOTE_PROHIBITED = 1645;

const ERROR_PATCH_REMOVAL_UNSUPPORTED = 1646;

const ERROR_UNKNOWN_PATCH = 1647;

const ERROR_PATCH_NO_SEQUENCE = 1648;

const ERROR_PATCH_REMOVAL_DISALLOWED = 1649;

const ERROR_INVALID_PATCH_XML = 1650;

const ERROR_PATCH_MANAGED_ADVERTISED_PRODUCT = 1651;

const ERROR_INSTALL_SERVICE_SAFEBOOT = 1652;

const ERROR_FAIL_FAST_EXCEPTION = 1653;

const ERROR_INSTALL_REJECTED = 1654;

const ERROR_DYNAMIC_CODE_BLOCKED = 1655;

const ERROR_NOT_SAME_OBJECT = 1656;

const ERROR_STRICT_CFG_VIOLATION = 1657;

const ERROR_SET_CONTEXT_DENIED = 1660;

const ERROR_CROSS_PARTITION_VIOLATION = 1661;

const ERROR_RETURN_ADDRESS_HIJACK_ATTEMPT = 1662;

const ERROR_INVALID_USER_BUFFER = 1784;

const ERROR_UNRECOGNIZED_MEDIA = 1785;

const ERROR_NO_TRUST_LSA_SECRET = 1786;

const ERROR_NO_TRUST_SAM_ACCOUNT = 1787;

const ERROR_TRUSTED_DOMAIN_FAILURE = 1788;

const ERROR_TRUSTED_RELATIONSHIP_FAILURE = 1789;

const ERROR_TRUST_FAILURE = 1790;

const ERROR_NETLOGON_NOT_STARTED = 1792;

const ERROR_ACCOUNT_EXPIRED = 1793;

const ERROR_REDIRECTOR_HAS_OPEN_HANDLES = 1794;

const ERROR_PRINTER_DRIVER_ALREADY_INSTALLED = 1795;

const ERROR_UNKNOWN_PORT = 1796;

const ERROR_UNKNOWN_PRINTER_DRIVER = 1797;

const ERROR_UNKNOWN_PRINTPROCESSOR = 1798;

const ERROR_INVALID_SEPARATOR_FILE = 1799;

const ERROR_INVALID_PRIORITY = 1800;

const ERROR_INVALID_PRINTER_NAME = 1801;

const ERROR_PRINTER_ALREADY_EXISTS = 1802;

const ERROR_INVALID_PRINTER_COMMAND = 1803;

const ERROR_INVALID_DATATYPE = 1804;

const ERROR_INVALID_ENVIRONMENT = 1805;

const ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT = 1807;

const ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT = 1808;

const ERROR_NOLOGON_SERVER_TRUST_ACCOUNT = 1809;

const ERROR_DOMAIN_TRUST_INCONSISTENT = 1810;

const ERROR_SERVER_HAS_OPEN_HANDLES = 1811;

const ERROR_RESOURCE_DATA_NOT_FOUND = 1812;

const ERROR_RESOURCE_TYPE_NOT_FOUND = 1813;

const ERROR_RESOURCE_NAME_NOT_FOUND = 1814;

const ERROR_RESOURCE_LANG_NOT_FOUND = 1815;

const ERROR_NOT_ENOUGH_QUOTA = 1816;

const ERROR_INVALID_TIME = 1901;

const ERROR_INVALID_FORM_NAME = 1902;

const ERROR_INVALID_FORM_SIZE = 1903;

const ERROR_ALREADY_WAITING = 1904;

const ERROR_PRINTER_DELETED = 1905;

const ERROR_INVALID_PRINTER_STATE = 1906;

const ERROR_PASSWORD_MUST_CHANGE = 1907;

const ERROR_DOMAIN_CONTROLLER_NOT_FOUND = 1908;

const ERROR_ACCOUNT_LOCKED_OUT = 1909;

const ERROR_NO_SITENAME = 1919;

const ERROR_CANT_ACCESS_FILE = 1920;

const ERROR_CANT_RESOLVE_FILENAME = 1921;

const ERROR_KM_DRIVER_BLOCKED = 1930;

const ERROR_CONTEXT_EXPIRED = 1931;

const ERROR_PER_USER_TRUST_QUOTA_EXCEEDED = 1932;

const ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED = 1933;

const ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED = 1934;

const ERROR_AUTHENTICATION_FIREWALL_FAILED = 1935;

const ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED = 1936;

const ERROR_NTLM_BLOCKED = 1937;

const ERROR_PASSWORD_CHANGE_REQUIRED = 1938;

const ERROR_LOST_MODE_LOGON_RESTRICTION = 1939;

const ERROR_INVALID_PIXEL_FORMAT = 2000;

const ERROR_BAD_DRIVER = 2001;

const ERROR_INVALID_WINDOW_STYLE = 2002;

const ERROR_METAFILE_NOT_SUPPORTED = 2003;

const ERROR_TRANSFORM_NOT_SUPPORTED = 2004;

const ERROR_CLIPPING_NOT_SUPPORTED = 2005;

const ERROR_INVALID_CMM = 2010;

const ERROR_INVALID_PROFILE = 2011;

const ERROR_TAG_NOT_FOUND = 2012;

const ERROR_TAG_NOT_PRESENT = 2013;

const ERROR_DUPLICATE_TAG = 2014;

const ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE = 2015;

const ERROR_PROFILE_NOT_FOUND = 2016;

const ERROR_INVALID_COLORSPACE = 2017;

const ERROR_ICM_NOT_ENABLED = 2018;

const ERROR_DELETING_ICM_XFORM = 2019;

const ERROR_INVALID_TRANSFORM = 2020;

const ERROR_COLORSPACE_MISMATCH = 2021;

const ERROR_INVALID_COLORINDEX = 2022;

const ERROR_PROFILE_DOES_NOT_MATCH_DEVICE = 2023;

const ERROR_CONNECTED_OTHER_PASSWORD = 2108;

const ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT = 2109;

const ERROR_NOT_CONNECTED = 2250;

const ERROR_OPEN_FILES = 2401;

const ERROR_ACTIVE_CONNECTIONS = 2402;

const ERROR_DEVICE_IN_USE = 2404;

const ERROR_UNKNOWN_PRINT_MONITOR = 3000;

const ERROR_PRINTER_DRIVER_IN_USE = 3001;

const ERROR_SPOOL_FILE_NOT_FOUND = 3002;

const ERROR_SPL_NO_STARTDOC = 3003;

const ERROR_SPL_NO_ADDJOB = 3004;

const ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED = 3005;

const ERROR_PRINT_MONITOR_ALREADY_INSTALLED = 3006;

const ERROR_INVALID_PRINT_MONITOR = 3007;

const ERROR_PRINT_MONITOR_IN_USE = 3008;

const ERROR_PRINTER_HAS_JOBS_QUEUED = 3009;

const ERROR_SUCCESS_REBOOT_REQUIRED = 3010;

const ERROR_SUCCESS_RESTART_REQUIRED = 3011;

const ERROR_PRINTER_NOT_FOUND = 3012;

const ERROR_PRINTER_DRIVER_WARNED = 3013;

const ERROR_PRINTER_DRIVER_BLOCKED = 3014;

const ERROR_PRINTER_DRIVER_PACKAGE_IN_USE = 3015;

const ERROR_CORE_DRIVER_PACKAGE_NOT_FOUND = 3016;

const ERROR_FAIL_REBOOT_REQUIRED = 3017;

const ERROR_FAIL_REBOOT_INITIATED = 3018;

const ERROR_PRINTER_DRIVER_DOWNLOAD_NEEDED = 3019;

const ERROR_PRINT_JOB_RESTART_REQUIRED = 3020;

const ERROR_INVALID_PRINTER_DRIVER_MANIFEST = 3021;

const ERROR_PRINTER_NOT_SHAREABLE = 3022;

const ERROR_SERVER_SERVICE_CALL_REQUIRES_SMB1 = 3023;

const ERROR_NETWORK_AUTHENTICATION_PROMPT_CANCELED = 3024;

const ERROR_REQUEST_PAUSED = 3050;

const ERROR_APPEXEC_CONDITION_NOT_SATISFIED = 3060;

const ERROR_APPEXEC_HANDLE_INVALIDATED = 3061;

const ERROR_APPEXEC_INVALID_HOST_GENERATION = 3062;

const ERROR_APPEXEC_UNEXPECTED_PROCESS_REGISTRATION = WIN32_ERROR(3063);

const ERROR_APPEXEC_INVALID_HOST_STATE = 3064;

const ERROR_APPEXEC_NO_DONOR = 3065;

const ERROR_APPEXEC_HOST_ID_MISMATCH = 3066;

const ERROR_APPEXEC_UNKNOWN_USER = 3067;

const ERROR_APPEXEC_APP_COMPAT_BLOCK = 3068;

const ERROR_APPEXEC_CALLER_WAIT_TIMEOUT = 3069;

const ERROR_APPEXEC_CALLER_WAIT_TIMEOUT_TERMINATION = WIN32_ERROR(3070);

const ERROR_APPEXEC_CALLER_WAIT_TIMEOUT_LICENSING = 3071;

const ERROR_APPEXEC_CALLER_WAIT_TIMEOUT_RESOURCES = 3072;

const ERROR_VRF_VOLATILE_CFG_AND_IO_ENABLED = 3080;

const ERROR_VRF_VOLATILE_NOT_STOPPABLE = 3081;

const ERROR_VRF_VOLATILE_SAFE_MODE = 3082;

const ERROR_VRF_VOLATILE_NOT_RUNNABLE_SYSTEM = 3083;

const ERROR_VRF_VOLATILE_NOT_SUPPORTED_RULECLASS = 3084;

const ERROR_VRF_VOLATILE_PROTECTED_DRIVER = 3085;

const ERROR_VRF_VOLATILE_NMI_REGISTERED = 3086;

const ERROR_VRF_VOLATILE_SETTINGS_CONFLICT = 3087;

const ERROR_DIF_IOCALLBACK_NOT_REPLACED = 3190;

const ERROR_DIF_LIVEDUMP_LIMIT_EXCEEDED = 3191;

const ERROR_DIF_VOLATILE_SECTION_NOT_LOCKED = 3192;

const ERROR_DIF_VOLATILE_DRIVER_HOTPATCHED = 3193;

const ERROR_DIF_VOLATILE_INVALID_INFO = 3194;

const ERROR_DIF_VOLATILE_DRIVER_IS_NOT_RUNNING = 3195;

const ERROR_DIF_VOLATILE_PLUGIN_IS_NOT_RUNNING = 3196;

const ERROR_DIF_VOLATILE_PLUGIN_CHANGE_NOT_ALLOWED = 3197;

const ERROR_DIF_VOLATILE_NOT_ALLOWED = 3198;

const ERROR_DIF_BINDING_API_NOT_FOUND = 3199;

const ERROR_IO_REISSUE_AS_CACHED = 3950;

const ERROR_WINS_INTERNAL = 4000;

const ERROR_CAN_NOT_DEL_LOCAL_WINS = 4001;

const ERROR_STATIC_INIT = 4002;

const ERROR_INC_BACKUP = 4003;

const ERROR_FULL_BACKUP = 4004;

const ERROR_REC_NON_EXISTENT = 4005;

const ERROR_RPL_NOT_ALLOWED = 4006;

const ERROR_DHCP_ADDRESS_CONFLICT = 4100;

const ERROR_WMI_GUID_NOT_FOUND = 4200;

const ERROR_WMI_INSTANCE_NOT_FOUND = 4201;

const ERROR_WMI_ITEMID_NOT_FOUND = 4202;

const ERROR_WMI_TRY_AGAIN = 4203;

const ERROR_WMI_DP_NOT_FOUND = 4204;

const ERROR_WMI_UNRESOLVED_INSTANCE_REF = 4205;

const ERROR_WMI_ALREADY_ENABLED = 4206;

const ERROR_WMI_GUID_DISCONNECTED = 4207;

const ERROR_WMI_SERVER_UNAVAILABLE = 4208;

const ERROR_WMI_DP_FAILED = 4209;

const ERROR_WMI_INVALID_MOF = 4210;

const ERROR_WMI_INVALID_REGINFO = 4211;

const ERROR_WMI_ALREADY_DISABLED = 4212;

const ERROR_WMI_READ_ONLY = 4213;

const ERROR_WMI_SET_FAILURE = 4214;

const ERROR_NOT_APPCONTAINER = 4250;

const ERROR_APPCONTAINER_REQUIRED = 4251;

const ERROR_NOT_SUPPORTED_IN_APPCONTAINER = 4252;

const ERROR_INVALID_PACKAGE_SID_LENGTH = 4253;

const ERROR_INVALID_MEDIA = 4300;

const ERROR_INVALID_LIBRARY = 4301;

const ERROR_INVALID_MEDIA_POOL = 4302;

const ERROR_DRIVE_MEDIA_MISMATCH = 4303;

const ERROR_MEDIA_OFFLINE = 4304;

const ERROR_LIBRARY_OFFLINE = 4305;

const ERROR_EMPTY = 4306;

const ERROR_NOT_EMPTY = 4307;

const ERROR_MEDIA_UNAVAILABLE = 4308;

const ERROR_RESOURCE_DISABLED = 4309;

const ERROR_INVALID_CLEANER = 4310;

const ERROR_UNABLE_TO_CLEAN = 4311;

const ERROR_OBJECT_NOT_FOUND = 4312;

const ERROR_DATABASE_FAILURE = 4313;

const ERROR_DATABASE_FULL = 4314;

const ERROR_MEDIA_INCOMPATIBLE = 4315;

const ERROR_RESOURCE_NOT_PRESENT = 4316;

const ERROR_INVALID_OPERATION = 4317;

const ERROR_MEDIA_NOT_AVAILABLE = 4318;

const ERROR_DEVICE_NOT_AVAILABLE = 4319;

const ERROR_REQUEST_REFUSED = 4320;

const ERROR_INVALID_DRIVE_OBJECT = 4321;

const ERROR_LIBRARY_FULL = 4322;

const ERROR_MEDIUM_NOT_ACCESSIBLE = 4323;

const ERROR_UNABLE_TO_LOAD_MEDIUM = 4324;

const ERROR_UNABLE_TO_INVENTORY_DRIVE = 4325;

const ERROR_UNABLE_TO_INVENTORY_SLOT = 4326;

const ERROR_UNABLE_TO_INVENTORY_TRANSPORT = 4327;

const ERROR_TRANSPORT_FULL = 4328;

const ERROR_CONTROLLING_IEPORT = 4329;

const ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA = 4330;

const ERROR_CLEANER_SLOT_SET = 4331;

const ERROR_CLEANER_SLOT_NOT_SET = 4332;

const ERROR_CLEANER_CARTRIDGE_SPENT = 4333;

const ERROR_UNEXPECTED_OMID = 4334;

const ERROR_CANT_DELETE_LAST_ITEM = 4335;

const ERROR_MESSAGE_EXCEEDS_MAX_SIZE = 4336;

const ERROR_VOLUME_CONTAINS_SYS_FILES = 4337;

const ERROR_INDIGENOUS_TYPE = 4338;

const ERROR_NO_SUPPORTING_DRIVES = 4339;

const ERROR_CLEANER_CARTRIDGE_INSTALLED = 4340;

const ERROR_IEPORT_FULL = 4341;

const ERROR_FILE_OFFLINE = 4350;

const ERROR_REMOTE_STORAGE_NOT_ACTIVE = 4351;

const ERROR_REMOTE_STORAGE_MEDIA_ERROR = 4352;

const ERROR_NOT_A_REPARSE_POINT = 4390;

const ERROR_REPARSE_ATTRIBUTE_CONFLICT = 4391;

const ERROR_INVALID_REPARSE_DATA = 4392;

const ERROR_REPARSE_TAG_INVALID = 4393;

const ERROR_REPARSE_TAG_MISMATCH = 4394;

const ERROR_REPARSE_POINT_ENCOUNTERED = 4395;

const ERROR_APP_DATA_NOT_FOUND = 4400;

const ERROR_APP_DATA_EXPIRED = 4401;

const ERROR_APP_DATA_CORRUPT = 4402;

const ERROR_APP_DATA_LIMIT_EXCEEDED = 4403;

const ERROR_APP_DATA_REBOOT_REQUIRED = 4404;

const ERROR_SECUREBOOT_ROLLBACK_DETECTED = 4420;

const ERROR_SECUREBOOT_POLICY_VIOLATION = 4421;

const ERROR_SECUREBOOT_INVALID_POLICY = 4422;

const ERROR_SECUREBOOT_POLICY_PUBLISHER_NOT_FOUND = 4423;

const ERROR_SECUREBOOT_POLICY_NOT_SIGNED = 4424;

const ERROR_SECUREBOOT_NOT_ENABLED = 4425;

const ERROR_SECUREBOOT_FILE_REPLACED = 4426;

const ERROR_SECUREBOOT_POLICY_NOT_AUTHORIZED = 4427;

const ERROR_SECUREBOOT_POLICY_UNKNOWN = 4428;

const ERROR_SECUREBOOT_POLICY_MISSING_ANTIROLLBACKVERSION = WIN32_ERROR(4429);

const ERROR_SECUREBOOT_PLATFORM_ID_MISMATCH = 4430;

const ERROR_SECUREBOOT_POLICY_ROLLBACK_DETECTED = 4431;

const ERROR_SECUREBOOT_POLICY_UPGRADE_MISMATCH = 4432;

const ERROR_SECUREBOOT_REQUIRED_POLICY_FILE_MISSING = WIN32_ERROR(4433);

const ERROR_SECUREBOOT_NOT_BASE_POLICY = 4434;

const ERROR_SECUREBOOT_NOT_SUPPLEMENTAL_POLICY = 4435;

const ERROR_OFFLOAD_READ_FLT_NOT_SUPPORTED = 4440;

const ERROR_OFFLOAD_WRITE_FLT_NOT_SUPPORTED = 4441;

const ERROR_OFFLOAD_READ_FILE_NOT_SUPPORTED = 4442;

const ERROR_OFFLOAD_WRITE_FILE_NOT_SUPPORTED = 4443;

const ERROR_ALREADY_HAS_STREAM_ID = 4444;

const ERROR_SMR_GARBAGE_COLLECTION_REQUIRED = 4445;

const ERROR_WOF_WIM_HEADER_CORRUPT = 4446;

const ERROR_WOF_WIM_RESOURCE_TABLE_CORRUPT = 4447;

const ERROR_WOF_FILE_RESOURCE_TABLE_CORRUPT = 4448;

const ERROR_OBJECT_IS_IMMUTABLE = 4449;

const ERROR_VOLUME_NOT_SIS_ENABLED = 4500;

const ERROR_SYSTEM_INTEGRITY_ROLLBACK_DETECTED = 4550;

const ERROR_SYSTEM_INTEGRITY_POLICY_VIOLATION = 4551;

const ERROR_SYSTEM_INTEGRITY_INVALID_POLICY = 4552;

const ERROR_SYSTEM_INTEGRITY_POLICY_NOT_SIGNED = 4553;

const ERROR_SYSTEM_INTEGRITY_TOO_MANY_POLICIES = 4554;

const ERROR_SYSTEM_INTEGRITY_SUPPLEMENTAL_POLICY_NOT_AUTHORIZED = WIN32_ERROR(
  4555,
);

const ERROR_SYSTEM_INTEGRITY_REPUTATION_MALICIOUS = 4556;

const ERROR_SYSTEM_INTEGRITY_REPUTATION_PUA = 4557;

const ERROR_SYSTEM_INTEGRITY_REPUTATION_DANGEROUS_EXT = WIN32_ERROR(4558);

const ERROR_SYSTEM_INTEGRITY_REPUTATION_OFFLINE = 4559;

const ERROR_VSM_NOT_INITIALIZED = 4560;

const ERROR_VSM_DMA_PROTECTION_NOT_IN_USE = 4561;

const ERROR_PLATFORM_MANIFEST_NOT_AUTHORIZED = 4570;

const ERROR_PLATFORM_MANIFEST_INVALID = 4571;

const ERROR_PLATFORM_MANIFEST_FILE_NOT_AUTHORIZED = 4572;

const ERROR_PLATFORM_MANIFEST_CATALOG_NOT_AUTHORIZED = WIN32_ERROR(4573);

const ERROR_PLATFORM_MANIFEST_BINARY_ID_NOT_FOUND = 4574;

const ERROR_PLATFORM_MANIFEST_NOT_ACTIVE = 4575;

const ERROR_PLATFORM_MANIFEST_NOT_SIGNED = 4576;

const ERROR_SYSTEM_INTEGRITY_REPUTATION_UNFRIENDLY_FILE = WIN32_ERROR(4580);

const ERROR_SYSTEM_INTEGRITY_REPUTATION_UNATTAINABLE = WIN32_ERROR(4581);

const ERROR_SYSTEM_INTEGRITY_REPUTATION_EXPLICIT_DENY_FILE = WIN32_ERROR(4582);

const ERROR_DEPENDENT_RESOURCE_EXISTS = 5001;

const ERROR_DEPENDENCY_NOT_FOUND = 5002;

const ERROR_DEPENDENCY_ALREADY_EXISTS = 5003;

const ERROR_RESOURCE_NOT_ONLINE = 5004;

const ERROR_HOST_NODE_NOT_AVAILABLE = 5005;

const ERROR_RESOURCE_NOT_AVAILABLE = 5006;

const ERROR_RESOURCE_NOT_FOUND = 5007;

const ERROR_SHUTDOWN_CLUSTER = 5008;

const ERROR_CANT_EVICT_ACTIVE_NODE = 5009;

const ERROR_OBJECT_ALREADY_EXISTS = 5010;

const ERROR_OBJECT_IN_LIST = 5011;

const ERROR_GROUP_NOT_AVAILABLE = 5012;

const ERROR_GROUP_NOT_FOUND = 5013;

const ERROR_GROUP_NOT_ONLINE = 5014;

const ERROR_HOST_NODE_NOT_RESOURCE_OWNER = 5015;

const ERROR_HOST_NODE_NOT_GROUP_OWNER = 5016;

const ERROR_RESMON_CREATE_FAILED = 5017;

const ERROR_RESMON_ONLINE_FAILED = 5018;

const ERROR_RESOURCE_ONLINE = 5019;

const ERROR_QUORUM_RESOURCE = 5020;

const ERROR_NOT_QUORUM_CAPABLE = 5021;

const ERROR_CLUSTER_SHUTTING_DOWN = 5022;

const ERROR_INVALID_STATE = 5023;

const ERROR_RESOURCE_PROPERTIES_STORED = 5024;

const ERROR_NOT_QUORUM_CLASS = 5025;

const ERROR_CORE_RESOURCE = 5026;

const ERROR_QUORUM_RESOURCE_ONLINE_FAILED = 5027;

const ERROR_QUORUMLOG_OPEN_FAILED = 5028;

const ERROR_CLUSTERLOG_CORRUPT = 5029;

const ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE = 5030;

const ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE = 5031;

const ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND = 5032;

const ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE = 5033;

const ERROR_QUORUM_OWNER_ALIVE = 5034;

const ERROR_NETWORK_NOT_AVAILABLE = 5035;

const ERROR_NODE_NOT_AVAILABLE = 5036;

const ERROR_ALL_NODES_NOT_AVAILABLE = 5037;

const ERROR_RESOURCE_FAILED = 5038;

const ERROR_CLUSTER_INVALID_NODE = 5039;

const ERROR_CLUSTER_NODE_EXISTS = 5040;

const ERROR_CLUSTER_JOIN_IN_PROGRESS = 5041;

const ERROR_CLUSTER_NODE_NOT_FOUND = 5042;

const ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND = 5043;

const ERROR_CLUSTER_NETWORK_EXISTS = 5044;

const ERROR_CLUSTER_NETWORK_NOT_FOUND = 5045;

const ERROR_CLUSTER_NETINTERFACE_EXISTS = 5046;

const ERROR_CLUSTER_NETINTERFACE_NOT_FOUND = 5047;

const ERROR_CLUSTER_INVALID_REQUEST = 5048;

const ERROR_CLUSTER_INVALID_NETWORK_PROVIDER = 5049;

const ERROR_CLUSTER_NODE_DOWN = 5050;

const ERROR_CLUSTER_NODE_UNREACHABLE = 5051;

const ERROR_CLUSTER_NODE_NOT_MEMBER = 5052;

const ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS = 5053;

const ERROR_CLUSTER_INVALID_NETWORK = 5054;

const ERROR_CLUSTER_NODE_UP = 5056;

const ERROR_CLUSTER_IPADDR_IN_USE = 5057;

const ERROR_CLUSTER_NODE_NOT_PAUSED = 5058;

const ERROR_CLUSTER_NO_SECURITY_CONTEXT = 5059;

const ERROR_CLUSTER_NETWORK_NOT_INTERNAL = 5060;

const ERROR_CLUSTER_NODE_ALREADY_UP = 5061;

const ERROR_CLUSTER_NODE_ALREADY_DOWN = 5062;

const ERROR_CLUSTER_NETWORK_ALREADY_ONLINE = 5063;

const ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE = 5064;

const ERROR_CLUSTER_NODE_ALREADY_MEMBER = 5065;

const ERROR_CLUSTER_LAST_INTERNAL_NETWORK = 5066;

const ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS = 5067;

const ERROR_INVALID_OPERATION_ON_QUORUM = 5068;

const ERROR_DEPENDENCY_NOT_ALLOWED = 5069;

const ERROR_CLUSTER_NODE_PAUSED = 5070;

const ERROR_NODE_CANT_HOST_RESOURCE = 5071;

const ERROR_CLUSTER_NODE_NOT_READY = 5072;

const ERROR_CLUSTER_NODE_SHUTTING_DOWN = 5073;

const ERROR_CLUSTER_JOIN_ABORTED = 5074;

const ERROR_CLUSTER_INCOMPATIBLE_VERSIONS = 5075;

const ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED = 5076;

const ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED = 5077;

const ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND = 5078;

const ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED = 5079;

const ERROR_CLUSTER_RESNAME_NOT_FOUND = 5080;

const ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED = 5081;

const ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST = 5082;

const ERROR_CLUSTER_DATABASE_SEQMISMATCH = 5083;

const ERROR_RESMON_INVALID_STATE = 5084;

const ERROR_CLUSTER_GUM_NOT_LOCKER = 5085;

const ERROR_QUORUM_DISK_NOT_FOUND = 5086;

const ERROR_DATABASE_BACKUP_CORRUPT = 5087;

const ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT = 5088;

const ERROR_RESOURCE_PROPERTY_UNCHANGEABLE = 5089;

const ERROR_NO_ADMIN_ACCESS_POINT = 5090;

const ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE = 5890;

const ERROR_CLUSTER_QUORUMLOG_NOT_FOUND = 5891;

const ERROR_CLUSTER_MEMBERSHIP_HALT = 5892;

const ERROR_CLUSTER_INSTANCE_ID_MISMATCH = 5893;

const ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP = 5894;

const ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH = 5895;

const ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP = 5896;

const ERROR_CLUSTER_PARAMETER_MISMATCH = 5897;

const ERROR_NODE_CANNOT_BE_CLUSTERED = 5898;

const ERROR_CLUSTER_WRONG_OS_VERSION = 5899;

const ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME = 5900;

const ERROR_CLUSCFG_ALREADY_COMMITTED = 5901;

const ERROR_CLUSCFG_ROLLBACK_FAILED = 5902;

const ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT = WIN32_ERROR(5903);

const ERROR_CLUSTER_OLD_VERSION = 5904;

const ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME = 5905;

const ERROR_CLUSTER_NO_NET_ADAPTERS = 5906;

const ERROR_CLUSTER_POISONED = 5907;

const ERROR_CLUSTER_GROUP_MOVING = 5908;

const ERROR_CLUSTER_RESOURCE_TYPE_BUSY = 5909;

const ERROR_RESOURCE_CALL_TIMED_OUT = 5910;

const ERROR_INVALID_CLUSTER_IPV6_ADDRESS = 5911;

const ERROR_CLUSTER_INTERNAL_INVALID_FUNCTION = 5912;

const ERROR_CLUSTER_PARAMETER_OUT_OF_BOUNDS = 5913;

const ERROR_CLUSTER_PARTIAL_SEND = 5914;

const ERROR_CLUSTER_REGISTRY_INVALID_FUNCTION = 5915;

const ERROR_CLUSTER_INVALID_STRING_TERMINATION = 5916;

const ERROR_CLUSTER_INVALID_STRING_FORMAT = 5917;

const ERROR_CLUSTER_DATABASE_TRANSACTION_IN_PROGRESS = WIN32_ERROR(5918);

const ERROR_CLUSTER_DATABASE_TRANSACTION_NOT_IN_PROGRESS = WIN32_ERROR(5919);

const ERROR_CLUSTER_NULL_DATA = 5920;

const ERROR_CLUSTER_PARTIAL_READ = 5921;

const ERROR_CLUSTER_PARTIAL_WRITE = 5922;

const ERROR_CLUSTER_CANT_DESERIALIZE_DATA = 5923;

const ERROR_DEPENDENT_RESOURCE_PROPERTY_CONFLICT = 5924;

const ERROR_CLUSTER_NO_QUORUM = 5925;

const ERROR_CLUSTER_INVALID_IPV6_NETWORK = 5926;

const ERROR_CLUSTER_INVALID_IPV6_TUNNEL_NETWORK = 5927;

const ERROR_QUORUM_NOT_ALLOWED_IN_THIS_GROUP = 5928;

const ERROR_DEPENDENCY_TREE_TOO_COMPLEX = 5929;

const ERROR_EXCEPTION_IN_RESOURCE_CALL = 5930;

const ERROR_CLUSTER_RHS_FAILED_INITIALIZATION = 5931;

const ERROR_CLUSTER_NOT_INSTALLED = 5932;

const ERROR_CLUSTER_RESOURCES_MUST_BE_ONLINE_ON_THE_SAME_NODE = WIN32_ERROR(
  5933,
);

const ERROR_CLUSTER_MAX_NODES_IN_CLUSTER = 5934;

const ERROR_CLUSTER_TOO_MANY_NODES = 5935;

const ERROR_CLUSTER_OBJECT_ALREADY_USED = 5936;

const ERROR_NONCORE_GROUPS_FOUND = 5937;

const ERROR_FILE_SHARE_RESOURCE_CONFLICT = 5938;

const ERROR_CLUSTER_EVICT_INVALID_REQUEST = 5939;

const ERROR_CLUSTER_SINGLETON_RESOURCE = 5940;

const ERROR_CLUSTER_GROUP_SINGLETON_RESOURCE = 5941;

const ERROR_CLUSTER_RESOURCE_PROVIDER_FAILED = 5942;

const ERROR_CLUSTER_RESOURCE_CONFIGURATION_ERROR = 5943;

const ERROR_CLUSTER_GROUP_BUSY = 5944;

const ERROR_CLUSTER_NOT_SHARED_VOLUME = 5945;

const ERROR_CLUSTER_INVALID_SECURITY_DESCRIPTOR = 5946;

const ERROR_CLUSTER_SHARED_VOLUMES_IN_USE = 5947;

const ERROR_CLUSTER_USE_SHARED_VOLUMES_API = 5948;

const ERROR_CLUSTER_BACKUP_IN_PROGRESS = 5949;

const ERROR_NON_CSV_PATH = 5950;

const ERROR_CSV_VOLUME_NOT_LOCAL = 5951;

const ERROR_CLUSTER_WATCHDOG_TERMINATING = 5952;

const ERROR_CLUSTER_RESOURCE_VETOED_MOVE_INCOMPATIBLE_NODES = WIN32_ERROR(5953);

const ERROR_CLUSTER_INVALID_NODE_WEIGHT = 5954;

const ERROR_CLUSTER_RESOURCE_VETOED_CALL = 5955;

const ERROR_RESMON_SYSTEM_RESOURCES_LACKING = 5956;

const ERROR_CLUSTER_RESOURCE_VETOED_MOVE_NOT_ENOUGH_RESOURCES_ON_DESTINATION =
    WIN32_ERROR(5957);

const ERROR_CLUSTER_RESOURCE_VETOED_MOVE_NOT_ENOUGH_RESOURCES_ON_SOURCE =
    WIN32_ERROR(5958);

const ERROR_CLUSTER_GROUP_QUEUED = 5959;

const ERROR_CLUSTER_RESOURCE_LOCKED_STATUS = 5960;

const ERROR_CLUSTER_SHARED_VOLUME_FAILOVER_NOT_ALLOWED = WIN32_ERROR(5961);

const ERROR_CLUSTER_NODE_DRAIN_IN_PROGRESS = 5962;

const ERROR_CLUSTER_DISK_NOT_CONNECTED = 5963;

const ERROR_DISK_NOT_CSV_CAPABLE = 5964;

const ERROR_RESOURCE_NOT_IN_AVAILABLE_STORAGE = 5965;

const ERROR_CLUSTER_SHARED_VOLUME_REDIRECTED = 5966;

const ERROR_CLUSTER_SHARED_VOLUME_NOT_REDIRECTED = 5967;

const ERROR_CLUSTER_CANNOT_RETURN_PROPERTIES = 5968;

const ERROR_CLUSTER_RESOURCE_CONTAINS_UNSUPPORTED_DIFF_AREA_FOR_SHARED_VOLUMES =
    WIN32_ERROR(5969);

const ERROR_CLUSTER_RESOURCE_IS_IN_MAINTENANCE_MODE = WIN32_ERROR(5970);

const ERROR_CLUSTER_AFFINITY_CONFLICT = 5971;

const ERROR_CLUSTER_RESOURCE_IS_REPLICA_VIRTUAL_MACHINE = WIN32_ERROR(5972);

const ERROR_CLUSTER_UPGRADE_INCOMPATIBLE_VERSIONS = 5973;

const ERROR_CLUSTER_UPGRADE_FIX_QUORUM_NOT_SUPPORTED = WIN32_ERROR(5974);

const ERROR_CLUSTER_UPGRADE_RESTART_REQUIRED = 5975;

const ERROR_CLUSTER_UPGRADE_IN_PROGRESS = 5976;

const ERROR_CLUSTER_UPGRADE_INCOMPLETE = 5977;

const ERROR_CLUSTER_NODE_IN_GRACE_PERIOD = 5978;

const ERROR_CLUSTER_CSV_IO_PAUSE_TIMEOUT = 5979;

const ERROR_NODE_NOT_ACTIVE_CLUSTER_MEMBER = 5980;

const ERROR_CLUSTER_RESOURCE_NOT_MONITORED = 5981;

const ERROR_CLUSTER_RESOURCE_DOES_NOT_SUPPORT_UNMONITORED = WIN32_ERROR(5982);

const ERROR_CLUSTER_RESOURCE_IS_REPLICATED = 5983;

const ERROR_CLUSTER_NODE_ISOLATED = 5984;

const ERROR_CLUSTER_NODE_QUARANTINED = 5985;

const ERROR_CLUSTER_DATABASE_UPDATE_CONDITION_FAILED = WIN32_ERROR(5986);

const ERROR_CLUSTER_SPACE_DEGRADED = 5987;

const ERROR_CLUSTER_TOKEN_DELEGATION_NOT_SUPPORTED = 5988;

const ERROR_CLUSTER_CSV_INVALID_HANDLE = 5989;

const ERROR_CLUSTER_CSV_SUPPORTED_ONLY_ON_COORDINATOR = WIN32_ERROR(5990);

const ERROR_GROUPSET_NOT_AVAILABLE = 5991;

const ERROR_GROUPSET_NOT_FOUND = 5992;

const ERROR_GROUPSET_CANT_PROVIDE = 5993;

const ERROR_CLUSTER_FAULT_DOMAIN_PARENT_NOT_FOUND = 5994;

const ERROR_CLUSTER_FAULT_DOMAIN_INVALID_HIERARCHY = 5995;

const ERROR_CLUSTER_FAULT_DOMAIN_FAILED_S2D_VALIDATION = WIN32_ERROR(5996);

const ERROR_CLUSTER_FAULT_DOMAIN_S2D_CONNECTIVITY_LOSS = WIN32_ERROR(5997);

const ERROR_CLUSTER_INVALID_INFRASTRUCTURE_FILESERVER_NAME = WIN32_ERROR(5998);

const ERROR_CLUSTERSET_MANAGEMENT_CLUSTER_UNREACHABLE = WIN32_ERROR(5999);

const ERROR_ENCRYPTION_FAILED = 6000;

const ERROR_DECRYPTION_FAILED = 6001;

const ERROR_FILE_ENCRYPTED = 6002;

const ERROR_NO_RECOVERY_POLICY = 6003;

const ERROR_NO_EFS = 6004;

const ERROR_WRONG_EFS = 6005;

const ERROR_NO_USER_KEYS = 6006;

const ERROR_FILE_NOT_ENCRYPTED = 6007;

const ERROR_NOT_EXPORT_FORMAT = 6008;

const ERROR_FILE_READ_ONLY = 6009;

const ERROR_DIR_EFS_DISALLOWED = 6010;

const ERROR_EFS_SERVER_NOT_TRUSTED = 6011;

const ERROR_BAD_RECOVERY_POLICY = 6012;

const ERROR_EFS_ALG_BLOB_TOO_BIG = 6013;

const ERROR_VOLUME_NOT_SUPPORT_EFS = 6014;

const ERROR_EFS_DISABLED = 6015;

const ERROR_EFS_VERSION_NOT_SUPPORT = 6016;

const ERROR_CS_ENCRYPTION_INVALID_SERVER_RESPONSE = 6017;

const ERROR_CS_ENCRYPTION_UNSUPPORTED_SERVER = 6018;

const ERROR_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE = 6019;

const ERROR_CS_ENCRYPTION_NEW_ENCRYPTED_FILE = 6020;

const ERROR_CS_ENCRYPTION_FILE_NOT_CSE = 6021;

const ERROR_ENCRYPTION_POLICY_DENIES_OPERATION = 6022;

const ERROR_WIP_ENCRYPTION_FAILED = 6023;

const ERROR_NO_BROWSER_SERVERS_FOUND = 6118;

const ERROR_CLUSTER_OBJECT_IS_CLUSTER_SET_VM = 6250;

const ERROR_LOG_SECTOR_INVALID = 6600;

const ERROR_LOG_SECTOR_PARITY_INVALID = 6601;

const ERROR_LOG_SECTOR_REMAPPED = 6602;

const ERROR_LOG_BLOCK_INCOMPLETE = 6603;

const ERROR_LOG_INVALID_RANGE = 6604;

const ERROR_LOG_BLOCKS_EXHAUSTED = 6605;

const ERROR_LOG_READ_CONTEXT_INVALID = 6606;

const ERROR_LOG_RESTART_INVALID = 6607;

const ERROR_LOG_BLOCK_VERSION = 6608;

const ERROR_LOG_BLOCK_INVALID = 6609;

const ERROR_LOG_READ_MODE_INVALID = 6610;

const ERROR_LOG_NO_RESTART = 6611;

const ERROR_LOG_METADATA_CORRUPT = 6612;

const ERROR_LOG_METADATA_INVALID = 6613;

const ERROR_LOG_METADATA_INCONSISTENT = 6614;

const ERROR_LOG_RESERVATION_INVALID = 6615;

const ERROR_LOG_CANT_DELETE = 6616;

const ERROR_LOG_CONTAINER_LIMIT_EXCEEDED = 6617;

const ERROR_LOG_START_OF_LOG = 6618;

const ERROR_LOG_POLICY_ALREADY_INSTALLED = 6619;

const ERROR_LOG_POLICY_NOT_INSTALLED = 6620;

const ERROR_LOG_POLICY_INVALID = 6621;

const ERROR_LOG_POLICY_CONFLICT = 6622;

const ERROR_LOG_PINNED_ARCHIVE_TAIL = 6623;

const ERROR_LOG_RECORD_NONEXISTENT = 6624;

const ERROR_LOG_RECORDS_RESERVED_INVALID = 6625;

const ERROR_LOG_SPACE_RESERVED_INVALID = 6626;

const ERROR_LOG_TAIL_INVALID = 6627;

const ERROR_LOG_FULL = 6628;

const ERROR_COULD_NOT_RESIZE_LOG = 6629;

const ERROR_LOG_MULTIPLEXED = 6630;

const ERROR_LOG_DEDICATED = 6631;

const ERROR_LOG_ARCHIVE_NOT_IN_PROGRESS = 6632;

const ERROR_LOG_ARCHIVE_IN_PROGRESS = 6633;

const ERROR_LOG_EPHEMERAL = 6634;

const ERROR_LOG_NOT_ENOUGH_CONTAINERS = 6635;

const ERROR_LOG_CLIENT_ALREADY_REGISTERED = 6636;

const ERROR_LOG_CLIENT_NOT_REGISTERED = 6637;

const ERROR_LOG_FULL_HANDLER_IN_PROGRESS = 6638;

const ERROR_LOG_CONTAINER_READ_FAILED = 6639;

const ERROR_LOG_CONTAINER_WRITE_FAILED = 6640;

const ERROR_LOG_CONTAINER_OPEN_FAILED = 6641;

const ERROR_LOG_CONTAINER_STATE_INVALID = 6642;

const ERROR_LOG_STATE_INVALID = 6643;

const ERROR_LOG_PINNED = 6644;

const ERROR_LOG_METADATA_FLUSH_FAILED = 6645;

const ERROR_LOG_INCONSISTENT_SECURITY = 6646;

const ERROR_LOG_APPENDED_FLUSH_FAILED = 6647;

const ERROR_LOG_PINNED_RESERVATION = 6648;

const ERROR_INVALID_TRANSACTION = 6700;

const ERROR_TRANSACTION_NOT_ACTIVE = 6701;

const ERROR_TRANSACTION_REQUEST_NOT_VALID = 6702;

const ERROR_TRANSACTION_NOT_REQUESTED = 6703;

const ERROR_TRANSACTION_ALREADY_ABORTED = 6704;

const ERROR_TRANSACTION_ALREADY_COMMITTED = 6705;

const ERROR_TM_INITIALIZATION_FAILED = 6706;

const ERROR_RESOURCEMANAGER_READ_ONLY = 6707;

const ERROR_TRANSACTION_NOT_JOINED = 6708;

const ERROR_TRANSACTION_SUPERIOR_EXISTS = 6709;

const ERROR_CRM_PROTOCOL_ALREADY_EXISTS = 6710;

const ERROR_TRANSACTION_PROPAGATION_FAILED = 6711;

const ERROR_CRM_PROTOCOL_NOT_FOUND = 6712;

const ERROR_TRANSACTION_INVALID_MARSHALL_BUFFER = 6713;

const ERROR_CURRENT_TRANSACTION_NOT_VALID = 6714;

const ERROR_TRANSACTION_NOT_FOUND = 6715;

const ERROR_RESOURCEMANAGER_NOT_FOUND = 6716;

const ERROR_ENLISTMENT_NOT_FOUND = 6717;

const ERROR_TRANSACTIONMANAGER_NOT_FOUND = 6718;

const ERROR_TRANSACTIONMANAGER_NOT_ONLINE = 6719;

const ERROR_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION = WIN32_ERROR(6720);

const ERROR_TRANSACTION_NOT_ROOT = 6721;

const ERROR_TRANSACTION_OBJECT_EXPIRED = 6722;

const ERROR_TRANSACTION_RESPONSE_NOT_ENLISTED = 6723;

const ERROR_TRANSACTION_RECORD_TOO_LONG = 6724;

const ERROR_IMPLICIT_TRANSACTION_NOT_SUPPORTED = 6725;

const ERROR_TRANSACTION_INTEGRITY_VIOLATED = 6726;

const ERROR_TRANSACTIONMANAGER_IDENTITY_MISMATCH = 6727;

const ERROR_RM_CANNOT_BE_FROZEN_FOR_SNAPSHOT = 6728;

const ERROR_TRANSACTION_MUST_WRITETHROUGH = 6729;

const ERROR_TRANSACTION_NO_SUPERIOR = 6730;

const ERROR_HEURISTIC_DAMAGE_POSSIBLE = 6731;

const ERROR_TRANSACTIONAL_CONFLICT = 6800;

const ERROR_RM_NOT_ACTIVE = 6801;

const ERROR_RM_METADATA_CORRUPT = 6802;

const ERROR_DIRECTORY_NOT_RM = 6803;

const ERROR_TRANSACTIONS_UNSUPPORTED_REMOTE = 6805;

const ERROR_LOG_RESIZE_INVALID_SIZE = 6806;

const ERROR_OBJECT_NO_LONGER_EXISTS = 6807;

const ERROR_STREAM_MINIVERSION_NOT_FOUND = 6808;

const ERROR_STREAM_MINIVERSION_NOT_VALID = 6809;

const ERROR_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION = WIN32_ERROR(
  6810,
);

const ERROR_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT = WIN32_ERROR(6811);

const ERROR_CANT_CREATE_MORE_STREAM_MINIVERSIONS = 6812;

const ERROR_REMOTE_FILE_VERSION_MISMATCH = 6814;

const ERROR_HANDLE_NO_LONGER_VALID = 6815;

const ERROR_NO_TXF_METADATA = 6816;

const ERROR_LOG_CORRUPTION_DETECTED = 6817;

const ERROR_CANT_RECOVER_WITH_HANDLE_OPEN = 6818;

const ERROR_RM_DISCONNECTED = 6819;

const ERROR_ENLISTMENT_NOT_SUPERIOR = 6820;

const ERROR_RECOVERY_NOT_NEEDED = 6821;

const ERROR_RM_ALREADY_STARTED = 6822;

const ERROR_FILE_IDENTITY_NOT_PERSISTENT = 6823;

const ERROR_CANT_BREAK_TRANSACTIONAL_DEPENDENCY = 6824;

const ERROR_CANT_CROSS_RM_BOUNDARY = 6825;

const ERROR_TXF_DIR_NOT_EMPTY = 6826;

const ERROR_INDOUBT_TRANSACTIONS_EXIST = 6827;

const ERROR_TM_VOLATILE = 6828;

const ERROR_ROLLBACK_TIMER_EXPIRED = 6829;

const ERROR_TXF_ATTRIBUTE_CORRUPT = 6830;

const ERROR_EFS_NOT_ALLOWED_IN_TRANSACTION = 6831;

const ERROR_TRANSACTIONAL_OPEN_NOT_ALLOWED = 6832;

const ERROR_LOG_GROWTH_FAILED = 6833;

const ERROR_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE = 6834;

const ERROR_TXF_METADATA_ALREADY_PRESENT = 6835;

const ERROR_TRANSACTION_SCOPE_CALLBACKS_NOT_SET = 6836;

const ERROR_TRANSACTION_REQUIRED_PROMOTION = 6837;

const ERROR_CANNOT_EXECUTE_FILE_IN_TRANSACTION = 6838;

const ERROR_TRANSACTIONS_NOT_FROZEN = 6839;

const ERROR_TRANSACTION_FREEZE_IN_PROGRESS = 6840;

const ERROR_NOT_SNAPSHOT_VOLUME = 6841;

const ERROR_NO_SAVEPOINT_WITH_OPEN_FILES = 6842;

const ERROR_DATA_LOST_REPAIR = 6843;

const ERROR_SPARSE_NOT_ALLOWED_IN_TRANSACTION = 6844;

const ERROR_TM_IDENTITY_MISMATCH = 6845;

const ERROR_FLOATED_SECTION = 6846;

const ERROR_CANNOT_ACCEPT_TRANSACTED_WORK = 6847;

const ERROR_CANNOT_ABORT_TRANSACTIONS = 6848;

const ERROR_BAD_CLUSTERS = 6849;

const ERROR_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION = 6850;

const ERROR_VOLUME_DIRTY = 6851;

const ERROR_NO_LINK_TRACKING_IN_TRANSACTION = 6852;

const ERROR_OPERATION_NOT_SUPPORTED_IN_TRANSACTION = 6853;

const ERROR_EXPIRED_HANDLE = 6854;

const ERROR_TRANSACTION_NOT_ENLISTED = 6855;

const ERROR_CTX_WINSTATION_NAME_INVALID = 7001;

const ERROR_CTX_INVALID_PD = 7002;

const ERROR_CTX_PD_NOT_FOUND = 7003;

const ERROR_CTX_WD_NOT_FOUND = 7004;

const ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY = 7005;

const ERROR_CTX_SERVICE_NAME_COLLISION = 7006;

const ERROR_CTX_CLOSE_PENDING = 7007;

const ERROR_CTX_NO_OUTBUF = 7008;

const ERROR_CTX_MODEM_INF_NOT_FOUND = 7009;

const ERROR_CTX_INVALID_MODEMNAME = 7010;

const ERROR_CTX_MODEM_RESPONSE_ERROR = 7011;

const ERROR_CTX_MODEM_RESPONSE_TIMEOUT = 7012;

const ERROR_CTX_MODEM_RESPONSE_NO_CARRIER = 7013;

const ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE = 7014;

const ERROR_CTX_MODEM_RESPONSE_BUSY = 7015;

const ERROR_CTX_MODEM_RESPONSE_VOICE = 7016;

const ERROR_CTX_TD_ERROR = 7017;

const ERROR_CTX_WINSTATION_NOT_FOUND = 7022;

const ERROR_CTX_WINSTATION_ALREADY_EXISTS = 7023;

const ERROR_CTX_WINSTATION_BUSY = 7024;

const ERROR_CTX_BAD_VIDEO_MODE = 7025;

const ERROR_CTX_GRAPHICS_INVALID = 7035;

const ERROR_CTX_LOGON_DISABLED = 7037;

const ERROR_CTX_NOT_CONSOLE = 7038;

const ERROR_CTX_CLIENT_QUERY_TIMEOUT = 7040;

const ERROR_CTX_CONSOLE_DISCONNECT = 7041;

const ERROR_CTX_CONSOLE_CONNECT = 7042;

const ERROR_CTX_SHADOW_DENIED = 7044;

const ERROR_CTX_WINSTATION_ACCESS_DENIED = 7045;

const ERROR_CTX_INVALID_WD = 7049;

const ERROR_CTX_SHADOW_INVALID = 7050;

const ERROR_CTX_SHADOW_DISABLED = 7051;

const ERROR_CTX_CLIENT_LICENSE_IN_USE = 7052;

const ERROR_CTX_CLIENT_LICENSE_NOT_SET = 7053;

const ERROR_CTX_LICENSE_NOT_AVAILABLE = 7054;

const ERROR_CTX_LICENSE_CLIENT_INVALID = 7055;

const ERROR_CTX_LICENSE_EXPIRED = 7056;

const ERROR_CTX_SHADOW_NOT_RUNNING = 7057;

const ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE = 7058;

const ERROR_ACTIVATION_COUNT_EXCEEDED = 7059;

const ERROR_CTX_WINSTATIONS_DISABLED = 7060;

const ERROR_CTX_ENCRYPTION_LEVEL_REQUIRED = 7061;

const ERROR_CTX_SESSION_IN_USE = 7062;

const ERROR_CTX_NO_FORCE_LOGOFF = 7063;

const ERROR_CTX_ACCOUNT_RESTRICTION = 7064;

const ERROR_RDP_PROTOCOL_ERROR = 7065;

const ERROR_CTX_CDM_CONNECT = 7066;

const ERROR_CTX_CDM_DISCONNECT = 7067;

const ERROR_CTX_SECURITY_LAYER_ERROR = 7068;

const ERROR_TS_INCOMPATIBLE_SESSIONS = 7069;

const ERROR_TS_VIDEO_SUBSYSTEM_ERROR = 7070;

const ERROR_DS_NOT_INSTALLED = 8200;

const ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY = 8201;

const ERROR_DS_NO_ATTRIBUTE_OR_VALUE = 8202;

const ERROR_DS_INVALID_ATTRIBUTE_SYNTAX = 8203;

const ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED = 8204;

const ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS = 8205;

const ERROR_DS_BUSY = 8206;

const ERROR_DS_UNAVAILABLE = 8207;

const ERROR_DS_NO_RIDS_ALLOCATED = 8208;

const ERROR_DS_NO_MORE_RIDS = 8209;

const ERROR_DS_INCORRECT_ROLE_OWNER = 8210;

const ERROR_DS_RIDMGR_INIT_ERROR = 8211;

const ERROR_DS_OBJ_CLASS_VIOLATION = 8212;

const ERROR_DS_CANT_ON_NON_LEAF = 8213;

const ERROR_DS_CANT_ON_RDN = 8214;

const ERROR_DS_CANT_MOD_OBJ_CLASS = 8215;

const ERROR_DS_CROSS_DOM_MOVE_ERROR = 8216;

const ERROR_DS_GC_NOT_AVAILABLE = 8217;

const ERROR_SHARED_POLICY = 8218;

const ERROR_POLICY_OBJECT_NOT_FOUND = 8219;

const ERROR_POLICY_ONLY_IN_DS = 8220;

const ERROR_PROMOTION_ACTIVE = 8221;

const ERROR_NO_PROMOTION_ACTIVE = 8222;

const ERROR_DS_OPERATIONS_ERROR = 8224;

const ERROR_DS_PROTOCOL_ERROR = 8225;

const ERROR_DS_TIMELIMIT_EXCEEDED = 8226;

const ERROR_DS_SIZELIMIT_EXCEEDED = 8227;

const ERROR_DS_ADMIN_LIMIT_EXCEEDED = 8228;

const ERROR_DS_COMPARE_FALSE = 8229;

const ERROR_DS_COMPARE_TRUE = 8230;

const ERROR_DS_AUTH_METHOD_NOT_SUPPORTED = 8231;

const ERROR_DS_STRONG_AUTH_REQUIRED = 8232;

const ERROR_DS_INAPPROPRIATE_AUTH = 8233;

const ERROR_DS_AUTH_UNKNOWN = 8234;

const ERROR_DS_REFERRAL = 8235;

const ERROR_DS_UNAVAILABLE_CRIT_EXTENSION = 8236;

const ERROR_DS_CONFIDENTIALITY_REQUIRED = 8237;

const ERROR_DS_INAPPROPRIATE_MATCHING = 8238;

const ERROR_DS_CONSTRAINT_VIOLATION = 8239;

const ERROR_DS_NO_SUCH_OBJECT = 8240;

const ERROR_DS_ALIAS_PROBLEM = 8241;

const ERROR_DS_INVALID_DN_SYNTAX = 8242;

const ERROR_DS_IS_LEAF = 8243;

const ERROR_DS_ALIAS_DEREF_PROBLEM = 8244;

const ERROR_DS_UNWILLING_TO_PERFORM = 8245;

const ERROR_DS_LOOP_DETECT = 8246;

const ERROR_DS_NAMING_VIOLATION = 8247;

const ERROR_DS_OBJECT_RESULTS_TOO_LARGE = 8248;

const ERROR_DS_AFFECTS_MULTIPLE_DSAS = 8249;

const ERROR_DS_SERVER_DOWN = 8250;

const ERROR_DS_LOCAL_ERROR = 8251;

const ERROR_DS_ENCODING_ERROR = 8252;

const ERROR_DS_DECODING_ERROR = 8253;

const ERROR_DS_FILTER_UNKNOWN = 8254;

const ERROR_DS_PARAM_ERROR = 8255;

const ERROR_DS_NOT_SUPPORTED = 8256;

const ERROR_DS_NO_RESULTS_RETURNED = 8257;

const ERROR_DS_CONTROL_NOT_FOUND = 8258;

const ERROR_DS_CLIENT_LOOP = 8259;

const ERROR_DS_REFERRAL_LIMIT_EXCEEDED = 8260;

const ERROR_DS_SORT_CONTROL_MISSING = 8261;

const ERROR_DS_OFFSET_RANGE_ERROR = 8262;

const ERROR_DS_RIDMGR_DISABLED = 8263;

const ERROR_DS_ROOT_MUST_BE_NC = 8301;

const ERROR_DS_ADD_REPLICA_INHIBITED = 8302;

const ERROR_DS_ATT_NOT_DEF_IN_SCHEMA = 8303;

const ERROR_DS_MAX_OBJ_SIZE_EXCEEDED = 8304;

const ERROR_DS_OBJ_STRING_NAME_EXISTS = 8305;

const ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA = 8306;

const ERROR_DS_RDN_DOESNT_MATCH_SCHEMA = 8307;

const ERROR_DS_NO_REQUESTED_ATTS_FOUND = 8308;

const ERROR_DS_USER_BUFFER_TO_SMALL = 8309;

const ERROR_DS_ATT_IS_NOT_ON_OBJ = 8310;

const ERROR_DS_ILLEGAL_MOD_OPERATION = 8311;

const ERROR_DS_OBJ_TOO_LARGE = 8312;

const ERROR_DS_BAD_INSTANCE_TYPE = 8313;

const ERROR_DS_MASTERDSA_REQUIRED = 8314;

const ERROR_DS_OBJECT_CLASS_REQUIRED = 8315;

const ERROR_DS_MISSING_REQUIRED_ATT = 8316;

const ERROR_DS_ATT_NOT_DEF_FOR_CLASS = 8317;

const ERROR_DS_ATT_ALREADY_EXISTS = 8318;

const ERROR_DS_CANT_ADD_ATT_VALUES = 8320;

const ERROR_DS_SINGLE_VALUE_CONSTRAINT = 8321;

const ERROR_DS_RANGE_CONSTRAINT = 8322;

const ERROR_DS_ATT_VAL_ALREADY_EXISTS = 8323;

const ERROR_DS_CANT_REM_MISSING_ATT = 8324;

const ERROR_DS_CANT_REM_MISSING_ATT_VAL = 8325;

const ERROR_DS_ROOT_CANT_BE_SUBREF = 8326;

const ERROR_DS_NO_CHAINING = 8327;

const ERROR_DS_NO_CHAINED_EVAL = 8328;

const ERROR_DS_NO_PARENT_OBJECT = 8329;

const ERROR_DS_PARENT_IS_AN_ALIAS = 8330;

const ERROR_DS_CANT_MIX_MASTER_AND_REPS = 8331;

const ERROR_DS_CHILDREN_EXIST = 8332;

const ERROR_DS_OBJ_NOT_FOUND = 8333;

const ERROR_DS_ALIASED_OBJ_MISSING = 8334;

const ERROR_DS_BAD_NAME_SYNTAX = 8335;

const ERROR_DS_ALIAS_POINTS_TO_ALIAS = 8336;

const ERROR_DS_CANT_DEREF_ALIAS = 8337;

const ERROR_DS_OUT_OF_SCOPE = 8338;

const ERROR_DS_OBJECT_BEING_REMOVED = 8339;

const ERROR_DS_CANT_DELETE_DSA_OBJ = 8340;

const ERROR_DS_GENERIC_ERROR = 8341;

const ERROR_DS_DSA_MUST_BE_INT_MASTER = 8342;

const ERROR_DS_CLASS_NOT_DSA = 8343;

const ERROR_DS_INSUFF_ACCESS_RIGHTS = 8344;

const ERROR_DS_ILLEGAL_SUPERIOR = 8345;

const ERROR_DS_ATTRIBUTE_OWNED_BY_SAM = 8346;

const ERROR_DS_NAME_TOO_MANY_PARTS = 8347;

const ERROR_DS_NAME_TOO_LONG = 8348;

const ERROR_DS_NAME_VALUE_TOO_LONG = 8349;

const ERROR_DS_NAME_UNPARSEABLE = 8350;

const ERROR_DS_NAME_TYPE_UNKNOWN = 8351;

const ERROR_DS_NOT_AN_OBJECT = 8352;

const ERROR_DS_SEC_DESC_TOO_SHORT = 8353;

const ERROR_DS_SEC_DESC_INVALID = 8354;

const ERROR_DS_NO_DELETED_NAME = 8355;

const ERROR_DS_SUBREF_MUST_HAVE_PARENT = 8356;

const ERROR_DS_NCNAME_MUST_BE_NC = 8357;

const ERROR_DS_CANT_ADD_SYSTEM_ONLY = 8358;

const ERROR_DS_CLASS_MUST_BE_CONCRETE = 8359;

const ERROR_DS_INVALID_DMD = 8360;

const ERROR_DS_OBJ_GUID_EXISTS = 8361;

const ERROR_DS_NOT_ON_BACKLINK = 8362;

const ERROR_DS_NO_CROSSREF_FOR_NC = 8363;

const ERROR_DS_SHUTTING_DOWN = 8364;

const ERROR_DS_UNKNOWN_OPERATION = 8365;

const ERROR_DS_INVALID_ROLE_OWNER = 8366;

const ERROR_DS_COULDNT_CONTACT_FSMO = 8367;

const ERROR_DS_CROSS_NC_DN_RENAME = 8368;

const ERROR_DS_CANT_MOD_SYSTEM_ONLY = 8369;

const ERROR_DS_REPLICATOR_ONLY = 8370;

const ERROR_DS_OBJ_CLASS_NOT_DEFINED = 8371;

const ERROR_DS_OBJ_CLASS_NOT_SUBCLASS = 8372;

const ERROR_DS_NAME_REFERENCE_INVALID = 8373;

const ERROR_DS_CROSS_REF_EXISTS = 8374;

const ERROR_DS_CANT_DEL_MASTER_CROSSREF = 8375;

const ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD = 8376;

const ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX = 8377;

const ERROR_DS_DUP_RDN = 8378;

const ERROR_DS_DUP_OID = 8379;

const ERROR_DS_DUP_MAPI_ID = 8380;

const ERROR_DS_DUP_SCHEMA_ID_GUID = 8381;

const ERROR_DS_DUP_LDAP_DISPLAY_NAME = 8382;

const ERROR_DS_SEMANTIC_ATT_TEST = 8383;

const ERROR_DS_SYNTAX_MISMATCH = 8384;

const ERROR_DS_EXISTS_IN_MUST_HAVE = 8385;

const ERROR_DS_EXISTS_IN_MAY_HAVE = 8386;

const ERROR_DS_NONEXISTENT_MAY_HAVE = 8387;

const ERROR_DS_NONEXISTENT_MUST_HAVE = 8388;

const ERROR_DS_AUX_CLS_TEST_FAIL = 8389;

const ERROR_DS_NONEXISTENT_POSS_SUP = 8390;

const ERROR_DS_SUB_CLS_TEST_FAIL = 8391;

const ERROR_DS_BAD_RDN_ATT_ID_SYNTAX = 8392;

const ERROR_DS_EXISTS_IN_AUX_CLS = 8393;

const ERROR_DS_EXISTS_IN_SUB_CLS = 8394;

const ERROR_DS_EXISTS_IN_POSS_SUP = 8395;

const ERROR_DS_RECALCSCHEMA_FAILED = 8396;

const ERROR_DS_TREE_DELETE_NOT_FINISHED = 8397;

const ERROR_DS_CANT_DELETE = 8398;

const ERROR_DS_ATT_SCHEMA_REQ_ID = 8399;

const ERROR_DS_BAD_ATT_SCHEMA_SYNTAX = 8400;

const ERROR_DS_CANT_CACHE_ATT = 8401;

const ERROR_DS_CANT_CACHE_CLASS = 8402;

const ERROR_DS_CANT_REMOVE_ATT_CACHE = 8403;

const ERROR_DS_CANT_REMOVE_CLASS_CACHE = 8404;

const ERROR_DS_CANT_RETRIEVE_DN = 8405;

const ERROR_DS_MISSING_SUPREF = 8406;

const ERROR_DS_CANT_RETRIEVE_INSTANCE = 8407;

const ERROR_DS_CODE_INCONSISTENCY = 8408;

const ERROR_DS_DATABASE_ERROR = 8409;

const ERROR_DS_GOVERNSID_MISSING = 8410;

const ERROR_DS_MISSING_EXPECTED_ATT = 8411;

const ERROR_DS_NCNAME_MISSING_CR_REF = 8412;

const ERROR_DS_SECURITY_CHECKING_ERROR = 8413;

const ERROR_DS_SCHEMA_NOT_LOADED = 8414;

const ERROR_DS_SCHEMA_ALLOC_FAILED = 8415;

const ERROR_DS_ATT_SCHEMA_REQ_SYNTAX = 8416;

const ERROR_DS_GCVERIFY_ERROR = 8417;

const ERROR_DS_DRA_SCHEMA_MISMATCH = 8418;

const ERROR_DS_CANT_FIND_DSA_OBJ = 8419;

const ERROR_DS_CANT_FIND_EXPECTED_NC = 8420;

const ERROR_DS_CANT_FIND_NC_IN_CACHE = 8421;

const ERROR_DS_CANT_RETRIEVE_CHILD = 8422;

const ERROR_DS_SECURITY_ILLEGAL_MODIFY = 8423;

const ERROR_DS_CANT_REPLACE_HIDDEN_REC = 8424;

const ERROR_DS_BAD_HIERARCHY_FILE = 8425;

const ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED = 8426;

const ERROR_DS_CONFIG_PARAM_MISSING = 8427;

const ERROR_DS_COUNTING_AB_INDICES_FAILED = 8428;

const ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED = 8429;

const ERROR_DS_INTERNAL_FAILURE = 8430;

const ERROR_DS_UNKNOWN_ERROR = 8431;

const ERROR_DS_ROOT_REQUIRES_CLASS_TOP = 8432;

const ERROR_DS_REFUSING_FSMO_ROLES = 8433;

const ERROR_DS_MISSING_FSMO_SETTINGS = 8434;

const ERROR_DS_UNABLE_TO_SURRENDER_ROLES = 8435;

const ERROR_DS_DRA_GENERIC = 8436;

const ERROR_DS_DRA_INVALID_PARAMETER = 8437;

const ERROR_DS_DRA_BUSY = 8438;

const ERROR_DS_DRA_BAD_DN = 8439;

const ERROR_DS_DRA_BAD_NC = 8440;

const ERROR_DS_DRA_DN_EXISTS = 8441;

const ERROR_DS_DRA_INTERNAL_ERROR = 8442;

const ERROR_DS_DRA_INCONSISTENT_DIT = 8443;

const ERROR_DS_DRA_CONNECTION_FAILED = 8444;

const ERROR_DS_DRA_BAD_INSTANCE_TYPE = 8445;

const ERROR_DS_DRA_OUT_OF_MEM = 8446;

const ERROR_DS_DRA_MAIL_PROBLEM = 8447;

const ERROR_DS_DRA_REF_ALREADY_EXISTS = 8448;

const ERROR_DS_DRA_REF_NOT_FOUND = 8449;

const ERROR_DS_DRA_OBJ_IS_REP_SOURCE = 8450;

const ERROR_DS_DRA_DB_ERROR = 8451;

const ERROR_DS_DRA_NO_REPLICA = 8452;

const ERROR_DS_DRA_ACCESS_DENIED = 8453;

const ERROR_DS_DRA_NOT_SUPPORTED = 8454;

const ERROR_DS_DRA_RPC_CANCELLED = 8455;

const ERROR_DS_DRA_SOURCE_DISABLED = 8456;

const ERROR_DS_DRA_SINK_DISABLED = 8457;

const ERROR_DS_DRA_NAME_COLLISION = 8458;

const ERROR_DS_DRA_SOURCE_REINSTALLED = 8459;

const ERROR_DS_DRA_MISSING_PARENT = 8460;

const ERROR_DS_DRA_PREEMPTED = 8461;

const ERROR_DS_DRA_ABANDON_SYNC = 8462;

const ERROR_DS_DRA_SHUTDOWN = 8463;

const ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET = 8464;

const ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA = 8465;

const ERROR_DS_DRA_EXTN_CONNECTION_FAILED = 8466;

const ERROR_DS_INSTALL_SCHEMA_MISMATCH = 8467;

const ERROR_DS_DUP_LINK_ID = 8468;

const ERROR_DS_NAME_ERROR_RESOLVING = 8469;

const ERROR_DS_NAME_ERROR_NOT_FOUND = 8470;

const ERROR_DS_NAME_ERROR_NOT_UNIQUE = 8471;

const ERROR_DS_NAME_ERROR_NO_MAPPING = 8472;

const ERROR_DS_NAME_ERROR_DOMAIN_ONLY = 8473;

const ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING = 8474;

const ERROR_DS_CONSTRUCTED_ATT_MOD = 8475;

const ERROR_DS_WRONG_OM_OBJ_CLASS = 8476;

const ERROR_DS_DRA_REPL_PENDING = 8477;

const ERROR_DS_DS_REQUIRED = 8478;

const ERROR_DS_INVALID_LDAP_DISPLAY_NAME = 8479;

const ERROR_DS_NON_BASE_SEARCH = 8480;

const ERROR_DS_CANT_RETRIEVE_ATTS = 8481;

const ERROR_DS_BACKLINK_WITHOUT_LINK = 8482;

const ERROR_DS_EPOCH_MISMATCH = 8483;

const ERROR_DS_SRC_NAME_MISMATCH = 8484;

const ERROR_DS_SRC_AND_DST_NC_IDENTICAL = 8485;

const ERROR_DS_DST_NC_MISMATCH = 8486;

const ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC = 8487;

const ERROR_DS_SRC_GUID_MISMATCH = 8488;

const ERROR_DS_CANT_MOVE_DELETED_OBJECT = 8489;

const ERROR_DS_PDC_OPERATION_IN_PROGRESS = 8490;

const ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD = 8491;

const ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION = 8492;

const ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS = 8493;

const ERROR_DS_NC_MUST_HAVE_NC_PARENT = 8494;

const ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE = 8495;

const ERROR_DS_DST_DOMAIN_NOT_NATIVE = 8496;

const ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER = 8497;

const ERROR_DS_CANT_MOVE_ACCOUNT_GROUP = 8498;

const ERROR_DS_CANT_MOVE_RESOURCE_GROUP = 8499;

const ERROR_DS_INVALID_SEARCH_FLAG = 8500;

const ERROR_DS_NO_TREE_DELETE_ABOVE_NC = 8501;

const ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE = 8502;

const ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE = WIN32_ERROR(8503);

const ERROR_DS_SAM_INIT_FAILURE = 8504;

const ERROR_DS_SENSITIVE_GROUP_VIOLATION = 8505;

const ERROR_DS_CANT_MOD_PRIMARYGROUPID = 8506;

const ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD = 8507;

const ERROR_DS_NONSAFE_SCHEMA_CHANGE = 8508;

const ERROR_DS_SCHEMA_UPDATE_DISALLOWED = 8509;

const ERROR_DS_CANT_CREATE_UNDER_SCHEMA = 8510;

const ERROR_DS_INSTALL_NO_SRC_SCH_VERSION = 8511;

const ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE = 8512;

const ERROR_DS_INVALID_GROUP_TYPE = 8513;

const ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN = 8514;

const ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN = 8515;

const ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER = 8516;

const ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER = 8517;

const ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER = 8518;

const ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER = 8519;

const ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER = WIN32_ERROR(8520);

const ERROR_DS_HAVE_PRIMARY_MEMBERS = 8521;

const ERROR_DS_STRING_SD_CONVERSION_FAILED = 8522;

const ERROR_DS_NAMING_MASTER_GC = 8523;

const ERROR_DS_DNS_LOOKUP_FAILURE = 8524;

const ERROR_DS_COULDNT_UPDATE_SPNS = 8525;

const ERROR_DS_CANT_RETRIEVE_SD = 8526;

const ERROR_DS_KEY_NOT_UNIQUE = 8527;

const ERROR_DS_WRONG_LINKED_ATT_SYNTAX = 8528;

const ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD = 8529;

const ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY = 8530;

const ERROR_DS_CANT_START = 8531;

const ERROR_DS_INIT_FAILURE = 8532;

const ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION = 8533;

const ERROR_DS_SOURCE_DOMAIN_IN_FOREST = 8534;

const ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST = 8535;

const ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED = 8536;

const ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN = 8537;

const ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER = 8538;

const ERROR_DS_SRC_SID_EXISTS_IN_FOREST = 8539;

const ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH = 8540;

const ERROR_SAM_INIT_FAILURE = 8541;

const ERROR_DS_DRA_SCHEMA_INFO_SHIP = 8542;

const ERROR_DS_DRA_SCHEMA_CONFLICT = 8543;

const ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT = 8544;

const ERROR_DS_DRA_OBJ_NC_MISMATCH = 8545;

const ERROR_DS_NC_STILL_HAS_DSAS = 8546;

const ERROR_DS_GC_REQUIRED = 8547;

const ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY = 8548;

const ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS = 8549;

const ERROR_DS_CANT_ADD_TO_GC = 8550;

const ERROR_DS_NO_CHECKPOINT_WITH_PDC = 8551;

const ERROR_DS_SOURCE_AUDITING_NOT_ENABLED = 8552;

const ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC = 8553;

const ERROR_DS_INVALID_NAME_FOR_SPN = 8554;

const ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS = 8555;

const ERROR_DS_UNICODEPWD_NOT_IN_QUOTES = 8556;

const ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED = 8557;

const ERROR_DS_MUST_BE_RUN_ON_DST_DC = 8558;

const ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER = 8559;

const ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ = 8560;

const ERROR_DS_INIT_FAILURE_CONSOLE = 8561;

const ERROR_DS_SAM_INIT_FAILURE_CONSOLE = 8562;

const ERROR_DS_FOREST_VERSION_TOO_HIGH = 8563;

const ERROR_DS_DOMAIN_VERSION_TOO_HIGH = 8564;

const ERROR_DS_FOREST_VERSION_TOO_LOW = 8565;

const ERROR_DS_DOMAIN_VERSION_TOO_LOW = 8566;

const ERROR_DS_INCOMPATIBLE_VERSION = 8567;

const ERROR_DS_LOW_DSA_VERSION = 8568;

const ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN = 8569;

const ERROR_DS_NOT_SUPPORTED_SORT_ORDER = 8570;

const ERROR_DS_NAME_NOT_UNIQUE = 8571;

const ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4 = 8572;

const ERROR_DS_OUT_OF_VERSION_STORE = 8573;

const ERROR_DS_INCOMPATIBLE_CONTROLS_USED = 8574;

const ERROR_DS_NO_REF_DOMAIN = 8575;

const ERROR_DS_RESERVED_LINK_ID = 8576;

const ERROR_DS_LINK_ID_NOT_AVAILABLE = 8577;

const ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER = 8578;

const ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE = WIN32_ERROR(8579);

const ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC = 8580;

const ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG = 8581;

const ERROR_DS_MODIFYDN_WRONG_GRANDPARENT = 8582;

const ERROR_DS_NAME_ERROR_TRUST_REFERRAL = 8583;

const ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER = 8584;

const ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD = 8585;

const ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2 = 8586;

const ERROR_DS_THREAD_LIMIT_EXCEEDED = 8587;

const ERROR_DS_NOT_CLOSEST = 8588;

const ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF = 8589;

const ERROR_DS_SINGLE_USER_MODE_FAILED = 8590;

const ERROR_DS_NTDSCRIPT_SYNTAX_ERROR = 8591;

const ERROR_DS_NTDSCRIPT_PROCESS_ERROR = 8592;

const ERROR_DS_DIFFERENT_REPL_EPOCHS = 8593;

const ERROR_DS_DRS_EXTENSIONS_CHANGED = 8594;

const ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR = WIN32_ERROR(
  8595,
);

const ERROR_DS_NO_MSDS_INTID = 8596;

const ERROR_DS_DUP_MSDS_INTID = 8597;

const ERROR_DS_EXISTS_IN_RDNATTID = 8598;

const ERROR_DS_AUTHORIZATION_FAILED = 8599;

const ERROR_DS_INVALID_SCRIPT = 8600;

const ERROR_DS_REMOTE_CROSSREF_OP_FAILED = 8601;

const ERROR_DS_CROSS_REF_BUSY = 8602;

const ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN = 8603;

const ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC = 8604;

const ERROR_DS_DUPLICATE_ID_FOUND = 8605;

const ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT = 8606;

const ERROR_DS_GROUP_CONVERSION_ERROR = 8607;

const ERROR_DS_CANT_MOVE_APP_BASIC_GROUP = 8608;

const ERROR_DS_CANT_MOVE_APP_QUERY_GROUP = 8609;

const ERROR_DS_ROLE_NOT_VERIFIED = 8610;

const ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL = 8611;

const ERROR_DS_DOMAIN_RENAME_IN_PROGRESS = 8612;

const ERROR_DS_EXISTING_AD_CHILD_NC = 8613;

const ERROR_DS_REPL_LIFETIME_EXCEEDED = 8614;

const ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER = 8615;

const ERROR_DS_LDAP_SEND_QUEUE_FULL = 8616;

const ERROR_DS_DRA_OUT_SCHEDULE_WINDOW = 8617;

const ERROR_DS_POLICY_NOT_KNOWN = 8618;

const ERROR_NO_SITE_SETTINGS_OBJECT = 8619;

const ERROR_NO_SECRETS = 8620;

const ERROR_NO_WRITABLE_DC_FOUND = 8621;

const ERROR_DS_NO_SERVER_OBJECT = 8622;

const ERROR_DS_NO_NTDSA_OBJECT = 8623;

const ERROR_DS_NON_ASQ_SEARCH = 8624;

const ERROR_DS_AUDIT_FAILURE = 8625;

const ERROR_DS_INVALID_SEARCH_FLAG_SUBTREE = 8626;

const ERROR_DS_INVALID_SEARCH_FLAG_TUPLE = 8627;

const ERROR_DS_HIERARCHY_TABLE_TOO_DEEP = 8628;

const ERROR_DS_DRA_CORRUPT_UTD_VECTOR = 8629;

const ERROR_DS_DRA_SECRETS_DENIED = 8630;

const ERROR_DS_RESERVED_MAPI_ID = 8631;

const ERROR_DS_MAPI_ID_NOT_AVAILABLE = 8632;

const ERROR_DS_DRA_MISSING_KRBTGT_SECRET = 8633;

const ERROR_DS_DOMAIN_NAME_EXISTS_IN_FOREST = 8634;

const ERROR_DS_FLAT_NAME_EXISTS_IN_FOREST = 8635;

const ERROR_INVALID_USER_PRINCIPAL_NAME = 8636;

const ERROR_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS = 8637;

const ERROR_DS_OID_NOT_FOUND = 8638;

const ERROR_DS_DRA_RECYCLED_TARGET = 8639;

const ERROR_DS_DISALLOWED_NC_REDIRECT = 8640;

const ERROR_DS_HIGH_ADLDS_FFL = 8641;

const ERROR_DS_HIGH_DSA_VERSION = 8642;

const ERROR_DS_LOW_ADLDS_FFL = 8643;

const ERROR_DOMAIN_SID_SAME_AS_LOCAL_WORKSTATION = 8644;

const ERROR_DS_UNDELETE_SAM_VALIDATION_FAILED = 8645;

const ERROR_INCORRECT_ACCOUNT_TYPE = 8646;

const ERROR_DS_SPN_VALUE_NOT_UNIQUE_IN_FOREST = 8647;

const ERROR_DS_UPN_VALUE_NOT_UNIQUE_IN_FOREST = 8648;

const ERROR_DS_MISSING_FOREST_TRUST = 8649;

const ERROR_DS_VALUE_KEY_NOT_UNIQUE = 8650;

const ERROR_WEAK_WHFBKEY_BLOCKED = 8651;

const ERROR_DS_PER_ATTRIBUTE_AUTHZ_FAILED_DURING_ADD = WIN32_ERROR(8652);

const ERROR_LOCAL_POLICY_MODIFICATION_NOT_SUPPORTED = WIN32_ERROR(8653);

const ERROR_POLICY_CONTROLLED_ACCOUNT = 8654;

const ERROR_LAPS_LEGACY_SCHEMA_MISSING = 8655;

const ERROR_LAPS_SCHEMA_MISSING = 8656;

const ERROR_LAPS_ENCRYPTION_REQUIRES_2016_DFL = 8657;

const DNS_ERROR_RESPONSE_CODES_BASE = 9000;

const DNS_ERROR_RCODE_NO_ERROR = 0;

const DNS_ERROR_MASK = 9000;

const DNS_ERROR_RCODE_FORMAT_ERROR = 9001;

const DNS_ERROR_RCODE_SERVER_FAILURE = 9002;

const DNS_ERROR_RCODE_NAME_ERROR = 9003;

const DNS_ERROR_RCODE_NOT_IMPLEMENTED = 9004;

const DNS_ERROR_RCODE_REFUSED = 9005;

const DNS_ERROR_RCODE_YXDOMAIN = 9006;

const DNS_ERROR_RCODE_YXRRSET = 9007;

const DNS_ERROR_RCODE_NXRRSET = 9008;

const DNS_ERROR_RCODE_NOTAUTH = 9009;

const DNS_ERROR_RCODE_NOTZONE = 9010;

const DNS_ERROR_RCODE_BADSIG = 9016;

const DNS_ERROR_RCODE_BADKEY = 9017;

const DNS_ERROR_RCODE_BADTIME = 9018;

const DNS_ERROR_RCODE_LAST = 9018;

const DNS_ERROR_DNSSEC_BASE = 9100;

const DNS_ERROR_KEYMASTER_REQUIRED = 9101;

const DNS_ERROR_NOT_ALLOWED_ON_SIGNED_ZONE = 9102;

const DNS_ERROR_NSEC3_INCOMPATIBLE_WITH_RSA_SHA1 = 9103;

const DNS_ERROR_NOT_ENOUGH_SIGNING_KEY_DESCRIPTORS = 9104;

const DNS_ERROR_UNSUPPORTED_ALGORITHM = 9105;

const DNS_ERROR_INVALID_KEY_SIZE = 9106;

const DNS_ERROR_SIGNING_KEY_NOT_ACCESSIBLE = 9107;

const DNS_ERROR_KSP_DOES_NOT_SUPPORT_PROTECTION = 9108;

const DNS_ERROR_UNEXPECTED_DATA_PROTECTION_ERROR = 9109;

const DNS_ERROR_UNEXPECTED_CNG_ERROR = 9110;

const DNS_ERROR_UNKNOWN_SIGNING_PARAMETER_VERSION = 9111;

const DNS_ERROR_KSP_NOT_ACCESSIBLE = 9112;

const DNS_ERROR_TOO_MANY_SKDS = 9113;

const DNS_ERROR_INVALID_ROLLOVER_PERIOD = 9114;

const DNS_ERROR_INVALID_INITIAL_ROLLOVER_OFFSET = 9115;

const DNS_ERROR_ROLLOVER_IN_PROGRESS = 9116;

const DNS_ERROR_STANDBY_KEY_NOT_PRESENT = 9117;

const DNS_ERROR_NOT_ALLOWED_ON_ZSK = 9118;

const DNS_ERROR_NOT_ALLOWED_ON_ACTIVE_SKD = 9119;

const DNS_ERROR_ROLLOVER_ALREADY_QUEUED = 9120;

const DNS_ERROR_NOT_ALLOWED_ON_UNSIGNED_ZONE = 9121;

const DNS_ERROR_BAD_KEYMASTER = 9122;

const DNS_ERROR_INVALID_SIGNATURE_VALIDITY_PERIOD = 9123;

const DNS_ERROR_INVALID_NSEC3_ITERATION_COUNT = 9124;

const DNS_ERROR_DNSSEC_IS_DISABLED = 9125;

const DNS_ERROR_INVALID_XML = 9126;

const DNS_ERROR_NO_VALID_TRUST_ANCHORS = 9127;

const DNS_ERROR_ROLLOVER_NOT_POKEABLE = 9128;

const DNS_ERROR_NSEC3_NAME_COLLISION = 9129;

const DNS_ERROR_NSEC_INCOMPATIBLE_WITH_NSEC3_RSA_SHA1 = WIN32_ERROR(9130);

const DNS_ERROR_PACKET_FMT_BASE = 9500;

const DNS_ERROR_BAD_PACKET = 9502;

const DNS_ERROR_NO_PACKET = 9503;

const DNS_ERROR_RCODE = 9504;

const DNS_ERROR_UNSECURE_PACKET = 9505;

const DNS_ERROR_NO_MEMORY = 14;

const DNS_ERROR_INVALID_NAME = 123;

const DNS_ERROR_INVALID_DATA = 13;

const DNS_ERROR_GENERAL_API_BASE = 9550;

const DNS_ERROR_INVALID_TYPE = 9551;

const DNS_ERROR_INVALID_IP_ADDRESS = 9552;

const DNS_ERROR_INVALID_PROPERTY = 9553;

const DNS_ERROR_TRY_AGAIN_LATER = 9554;

const DNS_ERROR_NOT_UNIQUE = 9555;

const DNS_ERROR_NON_RFC_NAME = 9556;

const DNS_ERROR_INVALID_NAME_CHAR = 9560;

const DNS_ERROR_NUMERIC_NAME = 9561;

const DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER = 9562;

const DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION = 9563;

const DNS_ERROR_CANNOT_FIND_ROOT_HINTS = 9564;

const DNS_ERROR_INCONSISTENT_ROOT_HINTS = 9565;

const DNS_ERROR_DWORD_VALUE_TOO_SMALL = 9566;

const DNS_ERROR_DWORD_VALUE_TOO_LARGE = 9567;

const DNS_ERROR_BACKGROUND_LOADING = 9568;

const DNS_ERROR_NOT_ALLOWED_ON_RODC = 9569;

const DNS_ERROR_NOT_ALLOWED_UNDER_DNAME = 9570;

const DNS_ERROR_DELEGATION_REQUIRED = 9571;

const DNS_ERROR_INVALID_POLICY_TABLE = 9572;

const DNS_ERROR_ADDRESS_REQUIRED = 9573;

const DNS_ERROR_ZONE_BASE = 9600;

const DNS_ERROR_ZONE_DOES_NOT_EXIST = 9601;

const DNS_ERROR_NO_ZONE_INFO = 9602;

const DNS_ERROR_INVALID_ZONE_OPERATION = 9603;

const DNS_ERROR_ZONE_CONFIGURATION_ERROR = 9604;

const DNS_ERROR_ZONE_HAS_NO_SOA_RECORD = 9605;

const DNS_ERROR_ZONE_HAS_NO_NS_RECORDS = 9606;

const DNS_ERROR_ZONE_LOCKED = 9607;

const DNS_ERROR_ZONE_CREATION_FAILED = 9608;

const DNS_ERROR_ZONE_ALREADY_EXISTS = 9609;

const DNS_ERROR_AUTOZONE_ALREADY_EXISTS = 9610;

const DNS_ERROR_INVALID_ZONE_TYPE = 9611;

const DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP = 9612;

const DNS_ERROR_ZONE_NOT_SECONDARY = 9613;

const DNS_ERROR_NEED_SECONDARY_ADDRESSES = 9614;

const DNS_ERROR_WINS_INIT_FAILED = 9615;

const DNS_ERROR_NEED_WINS_SERVERS = 9616;

const DNS_ERROR_NBSTAT_INIT_FAILED = 9617;

const DNS_ERROR_SOA_DELETE_INVALID = 9618;

const DNS_ERROR_FORWARDER_ALREADY_EXISTS = 9619;

const DNS_ERROR_ZONE_REQUIRES_MASTER_IP = 9620;

const DNS_ERROR_ZONE_IS_SHUTDOWN = 9621;

const DNS_ERROR_ZONE_LOCKED_FOR_SIGNING = 9622;

const DNS_ERROR_DATAFILE_BASE = 9650;

const DNS_ERROR_PRIMARY_REQUIRES_DATAFILE = 9651;

const DNS_ERROR_INVALID_DATAFILE_NAME = 9652;

const DNS_ERROR_DATAFILE_OPEN_FAILURE = 9653;

const DNS_ERROR_FILE_WRITEBACK_FAILED = 9654;

const DNS_ERROR_DATAFILE_PARSING = 9655;

const DNS_ERROR_DATABASE_BASE = 9700;

const DNS_ERROR_RECORD_DOES_NOT_EXIST = 9701;

const DNS_ERROR_RECORD_FORMAT = 9702;

const DNS_ERROR_NODE_CREATION_FAILED = 9703;

const DNS_ERROR_UNKNOWN_RECORD_TYPE = 9704;

const DNS_ERROR_RECORD_TIMED_OUT = 9705;

const DNS_ERROR_NAME_NOT_IN_ZONE = 9706;

const DNS_ERROR_CNAME_LOOP = 9707;

const DNS_ERROR_NODE_IS_CNAME = 9708;

const DNS_ERROR_CNAME_COLLISION = 9709;

const DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT = 9710;

const DNS_ERROR_RECORD_ALREADY_EXISTS = 9711;

const DNS_ERROR_SECONDARY_DATA = 9712;

const DNS_ERROR_NO_CREATE_CACHE_DATA = 9713;

const DNS_ERROR_NAME_DOES_NOT_EXIST = 9714;

const DNS_ERROR_DS_UNAVAILABLE = 9717;

const DNS_ERROR_DS_ZONE_ALREADY_EXISTS = 9718;

const DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE = 9719;

const DNS_ERROR_NODE_IS_DNAME = 9720;

const DNS_ERROR_DNAME_COLLISION = 9721;

const DNS_ERROR_ALIAS_LOOP = 9722;

const DNS_ERROR_OPERATION_BASE = 9750;

const DNS_ERROR_AXFR = 9752;

const DNS_ERROR_SECURE_BASE = 9800;

const DNS_ERROR_SETUP_BASE = 9850;

const DNS_ERROR_NO_TCPIP = 9851;

const DNS_ERROR_NO_DNS_SERVERS = 9852;

const DNS_ERROR_DP_BASE = 9900;

const DNS_ERROR_DP_DOES_NOT_EXIST = 9901;

const DNS_ERROR_DP_ALREADY_EXISTS = 9902;

const DNS_ERROR_DP_NOT_ENLISTED = 9903;

const DNS_ERROR_DP_ALREADY_ENLISTED = 9904;

const DNS_ERROR_DP_NOT_AVAILABLE = 9905;

const DNS_ERROR_DP_FSMO_ERROR = 9906;

const DNS_ERROR_RRL_NOT_ENABLED = 9911;

const DNS_ERROR_RRL_INVALID_WINDOW_SIZE = 9912;

const DNS_ERROR_RRL_INVALID_IPV4_PREFIX = 9913;

const DNS_ERROR_RRL_INVALID_IPV6_PREFIX = 9914;

const DNS_ERROR_RRL_INVALID_TC_RATE = 9915;

const DNS_ERROR_RRL_INVALID_LEAK_RATE = 9916;

const DNS_ERROR_RRL_LEAK_RATE_LESSTHAN_TC_RATE = 9917;

const DNS_ERROR_VIRTUALIZATION_INSTANCE_ALREADY_EXISTS = WIN32_ERROR(9921);

const DNS_ERROR_VIRTUALIZATION_INSTANCE_DOES_NOT_EXIST = WIN32_ERROR(9922);

const DNS_ERROR_VIRTUALIZATION_TREE_LOCKED = 9923;

const DNS_ERROR_INVAILD_VIRTUALIZATION_INSTANCE_NAME = WIN32_ERROR(9924);

const DNS_ERROR_DEFAULT_VIRTUALIZATION_INSTANCE = 9925;

const DNS_ERROR_ZONESCOPE_ALREADY_EXISTS = 9951;

const DNS_ERROR_ZONESCOPE_DOES_NOT_EXIST = 9952;

const DNS_ERROR_DEFAULT_ZONESCOPE = 9953;

const DNS_ERROR_INVALID_ZONESCOPE_NAME = 9954;

const DNS_ERROR_NOT_ALLOWED_WITH_ZONESCOPES = 9955;

const DNS_ERROR_LOAD_ZONESCOPE_FAILED = 9956;

const DNS_ERROR_ZONESCOPE_FILE_WRITEBACK_FAILED = 9957;

const DNS_ERROR_INVALID_SCOPE_NAME = 9958;

const DNS_ERROR_SCOPE_DOES_NOT_EXIST = 9959;

const DNS_ERROR_DEFAULT_SCOPE = 9960;

const DNS_ERROR_INVALID_SCOPE_OPERATION = 9961;

const DNS_ERROR_SCOPE_LOCKED = 9962;

const DNS_ERROR_SCOPE_ALREADY_EXISTS = 9963;

const DNS_ERROR_POLICY_ALREADY_EXISTS = 9971;

const DNS_ERROR_POLICY_DOES_NOT_EXIST = 9972;

const DNS_ERROR_POLICY_INVALID_CRITERIA = 9973;

const DNS_ERROR_POLICY_INVALID_SETTINGS = 9974;

const DNS_ERROR_CLIENT_SUBNET_IS_ACCESSED = 9975;

const DNS_ERROR_CLIENT_SUBNET_DOES_NOT_EXIST = 9976;

const DNS_ERROR_CLIENT_SUBNET_ALREADY_EXISTS = 9977;

const DNS_ERROR_SUBNET_DOES_NOT_EXIST = 9978;

const DNS_ERROR_SUBNET_ALREADY_EXISTS = 9979;

const DNS_ERROR_POLICY_LOCKED = 9980;

const DNS_ERROR_POLICY_INVALID_WEIGHT = 9981;

const DNS_ERROR_POLICY_INVALID_NAME = 9982;

const DNS_ERROR_POLICY_MISSING_CRITERIA = 9983;

const DNS_ERROR_INVALID_CLIENT_SUBNET_NAME = 9984;

const DNS_ERROR_POLICY_PROCESSING_ORDER_INVALID = 9985;

const DNS_ERROR_POLICY_SCOPE_MISSING = 9986;

const DNS_ERROR_POLICY_SCOPE_NOT_ALLOWED = 9987;

const DNS_ERROR_SERVERSCOPE_IS_REFERENCED = 9988;

const DNS_ERROR_ZONESCOPE_IS_REFERENCED = 9989;

const DNS_ERROR_POLICY_INVALID_CRITERIA_CLIENT_SUBNET = WIN32_ERROR(9990);

const DNS_ERROR_POLICY_INVALID_CRITERIA_TRANSPORT_PROTOCOL = WIN32_ERROR(9991);

const DNS_ERROR_POLICY_INVALID_CRITERIA_NETWORK_PROTOCOL = WIN32_ERROR(9992);

const DNS_ERROR_POLICY_INVALID_CRITERIA_INTERFACE = 9993;

const DNS_ERROR_POLICY_INVALID_CRITERIA_FQDN = 9994;

const DNS_ERROR_POLICY_INVALID_CRITERIA_QUERY_TYPE = 9995;

const DNS_ERROR_POLICY_INVALID_CRITERIA_TIME_OF_DAY = WIN32_ERROR(9996);

const ERROR_IPSEC_QM_POLICY_EXISTS = 13000;

const ERROR_IPSEC_QM_POLICY_NOT_FOUND = 13001;

const ERROR_IPSEC_QM_POLICY_IN_USE = 13002;

const ERROR_IPSEC_MM_POLICY_EXISTS = 13003;

const ERROR_IPSEC_MM_POLICY_NOT_FOUND = 13004;

const ERROR_IPSEC_MM_POLICY_IN_USE = 13005;

const ERROR_IPSEC_MM_FILTER_EXISTS = 13006;

const ERROR_IPSEC_MM_FILTER_NOT_FOUND = 13007;

const ERROR_IPSEC_TRANSPORT_FILTER_EXISTS = 13008;

const ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND = 13009;

const ERROR_IPSEC_MM_AUTH_EXISTS = 13010;

const ERROR_IPSEC_MM_AUTH_NOT_FOUND = 13011;

const ERROR_IPSEC_MM_AUTH_IN_USE = 13012;

const ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND = 13013;

const ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND = 13014;

const ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND = 13015;

const ERROR_IPSEC_TUNNEL_FILTER_EXISTS = 13016;

const ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND = 13017;

const ERROR_IPSEC_MM_FILTER_PENDING_DELETION = 13018;

const ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION = WIN32_ERROR(13019);

const ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION = 13020;

const ERROR_IPSEC_MM_POLICY_PENDING_DELETION = 13021;

const ERROR_IPSEC_MM_AUTH_PENDING_DELETION = 13022;

const ERROR_IPSEC_QM_POLICY_PENDING_DELETION = 13023;

const ERROR_IPSEC_IKE_NEG_STATUS_BEGIN = 13800;

const ERROR_IPSEC_IKE_AUTH_FAIL = 13801;

const ERROR_IPSEC_IKE_ATTRIB_FAIL = 13802;

const ERROR_IPSEC_IKE_NEGOTIATION_PENDING = 13803;

const ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR = 13804;

const ERROR_IPSEC_IKE_TIMED_OUT = 13805;

const ERROR_IPSEC_IKE_NO_CERT = 13806;

const ERROR_IPSEC_IKE_SA_DELETED = 13807;

const ERROR_IPSEC_IKE_SA_REAPED = 13808;

const ERROR_IPSEC_IKE_MM_ACQUIRE_DROP = 13809;

const ERROR_IPSEC_IKE_QM_ACQUIRE_DROP = 13810;

const ERROR_IPSEC_IKE_QUEUE_DROP_MM = 13811;

const ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM = 13812;

const ERROR_IPSEC_IKE_DROP_NO_RESPONSE = 13813;

const ERROR_IPSEC_IKE_MM_DELAY_DROP = 13814;

const ERROR_IPSEC_IKE_QM_DELAY_DROP = 13815;

const ERROR_IPSEC_IKE_ERROR = 13816;

const ERROR_IPSEC_IKE_CRL_FAILED = 13817;

const ERROR_IPSEC_IKE_INVALID_KEY_USAGE = 13818;

const ERROR_IPSEC_IKE_INVALID_CERT_TYPE = 13819;

const ERROR_IPSEC_IKE_NO_PRIVATE_KEY = 13820;

const ERROR_IPSEC_IKE_SIMULTANEOUS_REKEY = 13821;

const ERROR_IPSEC_IKE_DH_FAIL = 13822;

const ERROR_IPSEC_IKE_CRITICAL_PAYLOAD_NOT_RECOGNIZED = WIN32_ERROR(13823);

const ERROR_IPSEC_IKE_INVALID_HEADER = 13824;

const ERROR_IPSEC_IKE_NO_POLICY = 13825;

const ERROR_IPSEC_IKE_INVALID_SIGNATURE = 13826;

const ERROR_IPSEC_IKE_KERBEROS_ERROR = 13827;

const ERROR_IPSEC_IKE_NO_PUBLIC_KEY = 13828;

const ERROR_IPSEC_IKE_PROCESS_ERR = 13829;

const ERROR_IPSEC_IKE_PROCESS_ERR_SA = 13830;

const ERROR_IPSEC_IKE_PROCESS_ERR_PROP = 13831;

const ERROR_IPSEC_IKE_PROCESS_ERR_TRANS = 13832;

const ERROR_IPSEC_IKE_PROCESS_ERR_KE = 13833;

const ERROR_IPSEC_IKE_PROCESS_ERR_ID = 13834;

const ERROR_IPSEC_IKE_PROCESS_ERR_CERT = 13835;

const ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ = 13836;

const ERROR_IPSEC_IKE_PROCESS_ERR_HASH = 13837;

const ERROR_IPSEC_IKE_PROCESS_ERR_SIG = 13838;

const ERROR_IPSEC_IKE_PROCESS_ERR_NONCE = 13839;

const ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY = 13840;

const ERROR_IPSEC_IKE_PROCESS_ERR_DELETE = 13841;

const ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR = 13842;

const ERROR_IPSEC_IKE_INVALID_PAYLOAD = 13843;

const ERROR_IPSEC_IKE_LOAD_SOFT_SA = 13844;

const ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN = 13845;

const ERROR_IPSEC_IKE_INVALID_COOKIE = 13846;

const ERROR_IPSEC_IKE_NO_PEER_CERT = 13847;

const ERROR_IPSEC_IKE_PEER_CRL_FAILED = 13848;

const ERROR_IPSEC_IKE_POLICY_CHANGE = 13849;

const ERROR_IPSEC_IKE_NO_MM_POLICY = 13850;

const ERROR_IPSEC_IKE_NOTCBPRIV = 13851;

const ERROR_IPSEC_IKE_SECLOADFAIL = 13852;

const ERROR_IPSEC_IKE_FAILSSPINIT = 13853;

const ERROR_IPSEC_IKE_FAILQUERYSSP = 13854;

const ERROR_IPSEC_IKE_SRVACQFAIL = 13855;

const ERROR_IPSEC_IKE_SRVQUERYCRED = 13856;

const ERROR_IPSEC_IKE_GETSPIFAIL = 13857;

const ERROR_IPSEC_IKE_INVALID_FILTER = 13858;

const ERROR_IPSEC_IKE_OUT_OF_MEMORY = 13859;

const ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED = 13860;

const ERROR_IPSEC_IKE_INVALID_POLICY = 13861;

const ERROR_IPSEC_IKE_UNKNOWN_DOI = 13862;

const ERROR_IPSEC_IKE_INVALID_SITUATION = 13863;

const ERROR_IPSEC_IKE_DH_FAILURE = 13864;

const ERROR_IPSEC_IKE_INVALID_GROUP = 13865;

const ERROR_IPSEC_IKE_ENCRYPT = 13866;

const ERROR_IPSEC_IKE_DECRYPT = 13867;

const ERROR_IPSEC_IKE_POLICY_MATCH = 13868;

const ERROR_IPSEC_IKE_UNSUPPORTED_ID = 13869;

const ERROR_IPSEC_IKE_INVALID_HASH = 13870;

const ERROR_IPSEC_IKE_INVALID_HASH_ALG = 13871;

const ERROR_IPSEC_IKE_INVALID_HASH_SIZE = 13872;

const ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG = 13873;

const ERROR_IPSEC_IKE_INVALID_AUTH_ALG = 13874;

const ERROR_IPSEC_IKE_INVALID_SIG = 13875;

const ERROR_IPSEC_IKE_LOAD_FAILED = 13876;

const ERROR_IPSEC_IKE_RPC_DELETE = 13877;

const ERROR_IPSEC_IKE_BENIGN_REINIT = 13878;

const ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY = WIN32_ERROR(13879);

const ERROR_IPSEC_IKE_INVALID_MAJOR_VERSION = 13880;

const ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN = 13881;

const ERROR_IPSEC_IKE_MM_LIMIT = 13882;

const ERROR_IPSEC_IKE_NEGOTIATION_DISABLED = 13883;

const ERROR_IPSEC_IKE_QM_LIMIT = 13884;

const ERROR_IPSEC_IKE_MM_EXPIRED = 13885;

const ERROR_IPSEC_IKE_PEER_MM_ASSUMED_INVALID = 13886;

const ERROR_IPSEC_IKE_CERT_CHAIN_POLICY_MISMATCH = 13887;

const ERROR_IPSEC_IKE_UNEXPECTED_MESSAGE_ID = 13888;

const ERROR_IPSEC_IKE_INVALID_AUTH_PAYLOAD = 13889;

const ERROR_IPSEC_IKE_DOS_COOKIE_SENT = 13890;

const ERROR_IPSEC_IKE_SHUTTING_DOWN = 13891;

const ERROR_IPSEC_IKE_CGA_AUTH_FAILED = 13892;

const ERROR_IPSEC_IKE_PROCESS_ERR_NATOA = 13893;

const ERROR_IPSEC_IKE_INVALID_MM_FOR_QM = 13894;

const ERROR_IPSEC_IKE_QM_EXPIRED = 13895;

const ERROR_IPSEC_IKE_TOO_MANY_FILTERS = 13896;

const ERROR_IPSEC_IKE_NEG_STATUS_END = 13897;

const ERROR_IPSEC_IKE_KILL_DUMMY_NAP_TUNNEL = 13898;

const ERROR_IPSEC_IKE_INNER_IP_ASSIGNMENT_FAILURE = 13899;

const ERROR_IPSEC_IKE_REQUIRE_CP_PAYLOAD_MISSING = 13900;

const ERROR_IPSEC_KEY_MODULE_IMPERSONATION_NEGOTIATION_PENDING = WIN32_ERROR(
  13901,
);

const ERROR_IPSEC_IKE_COEXISTENCE_SUPPRESS = 13902;

const ERROR_IPSEC_IKE_RATELIMIT_DROP = 13903;

const ERROR_IPSEC_IKE_PEER_DOESNT_SUPPORT_MOBIKE = 13904;

const ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE = 13905;

const ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_FAILURE = WIN32_ERROR(13906);

const ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE_WITH_OPTIONAL_RETRY = WIN32_ERROR(
  13907,
);

const ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_AND_CERTMAP_FAILURE =
    WIN32_ERROR(13908);

const ERROR_IPSEC_IKE_NEG_STATUS_EXTENDED_END = 13909;

const ERROR_IPSEC_BAD_SPI = 13910;

const ERROR_IPSEC_SA_LIFETIME_EXPIRED = 13911;

const ERROR_IPSEC_WRONG_SA = 13912;

const ERROR_IPSEC_REPLAY_CHECK_FAILED = 13913;

const ERROR_IPSEC_INVALID_PACKET = 13914;

const ERROR_IPSEC_INTEGRITY_CHECK_FAILED = 13915;

const ERROR_IPSEC_CLEAR_TEXT_DROP = 13916;

const ERROR_IPSEC_AUTH_FIREWALL_DROP = 13917;

const ERROR_IPSEC_THROTTLE_DROP = 13918;

const ERROR_IPSEC_DOSP_BLOCK = 13925;

const ERROR_IPSEC_DOSP_RECEIVED_MULTICAST = 13926;

const ERROR_IPSEC_DOSP_INVALID_PACKET = 13927;

const ERROR_IPSEC_DOSP_STATE_LOOKUP_FAILED = 13928;

const ERROR_IPSEC_DOSP_MAX_ENTRIES = 13929;

const ERROR_IPSEC_DOSP_KEYMOD_NOT_ALLOWED = 13930;

const ERROR_IPSEC_DOSP_NOT_INSTALLED = 13931;

const ERROR_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES = WIN32_ERROR(13932);

const ERROR_SXS_SECTION_NOT_FOUND = 14000;

const ERROR_SXS_CANT_GEN_ACTCTX = 14001;

const ERROR_SXS_INVALID_ACTCTXDATA_FORMAT = 14002;

const ERROR_SXS_ASSEMBLY_NOT_FOUND = 14003;

const ERROR_SXS_MANIFEST_FORMAT_ERROR = 14004;

const ERROR_SXS_MANIFEST_PARSE_ERROR = 14005;

const ERROR_SXS_ACTIVATION_CONTEXT_DISABLED = 14006;

const ERROR_SXS_KEY_NOT_FOUND = 14007;

const ERROR_SXS_VERSION_CONFLICT = 14008;

const ERROR_SXS_WRONG_SECTION_TYPE = 14009;

const ERROR_SXS_THREAD_QUERIES_DISABLED = 14010;

const ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET = 14011;

const ERROR_SXS_UNKNOWN_ENCODING_GROUP = 14012;

const ERROR_SXS_UNKNOWN_ENCODING = 14013;

const ERROR_SXS_INVALID_XML_NAMESPACE_URI = 14014;

const ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED = WIN32_ERROR(14015);

const ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED = WIN32_ERROR(14016);

const ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE = WIN32_ERROR(14017);

const ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE = WIN32_ERROR(
  14018,
);

const ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE = WIN32_ERROR(
  14019,
);

const ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT = WIN32_ERROR(
  14020,
);

const ERROR_SXS_DUPLICATE_DLL_NAME = 14021;

const ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME = 14022;

const ERROR_SXS_DUPLICATE_CLSID = 14023;

const ERROR_SXS_DUPLICATE_IID = 14024;

const ERROR_SXS_DUPLICATE_TLBID = 14025;

const ERROR_SXS_DUPLICATE_PROGID = 14026;

const ERROR_SXS_DUPLICATE_ASSEMBLY_NAME = 14027;

const ERROR_SXS_FILE_HASH_MISMATCH = 14028;

const ERROR_SXS_POLICY_PARSE_ERROR = 14029;

const ERROR_SXS_XML_E_MISSINGQUOTE = 14030;

const ERROR_SXS_XML_E_COMMENTSYNTAX = 14031;

const ERROR_SXS_XML_E_BADSTARTNAMECHAR = 14032;

const ERROR_SXS_XML_E_BADNAMECHAR = 14033;

const ERROR_SXS_XML_E_BADCHARINSTRING = 14034;

const ERROR_SXS_XML_E_XMLDECLSYNTAX = 14035;

const ERROR_SXS_XML_E_BADCHARDATA = 14036;

const ERROR_SXS_XML_E_MISSINGWHITESPACE = 14037;

const ERROR_SXS_XML_E_EXPECTINGTAGEND = 14038;

const ERROR_SXS_XML_E_MISSINGSEMICOLON = 14039;

const ERROR_SXS_XML_E_UNBALANCEDPAREN = 14040;

const ERROR_SXS_XML_E_INTERNALERROR = 14041;

const ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE = 14042;

const ERROR_SXS_XML_E_INCOMPLETE_ENCODING = 14043;

const ERROR_SXS_XML_E_MISSING_PAREN = 14044;

const ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE = 14045;

const ERROR_SXS_XML_E_MULTIPLE_COLONS = 14046;

const ERROR_SXS_XML_E_INVALID_DECIMAL = 14047;

const ERROR_SXS_XML_E_INVALID_HEXIDECIMAL = 14048;

const ERROR_SXS_XML_E_INVALID_UNICODE = 14049;

const ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK = 14050;

const ERROR_SXS_XML_E_UNEXPECTEDENDTAG = 14051;

const ERROR_SXS_XML_E_UNCLOSEDTAG = 14052;

const ERROR_SXS_XML_E_DUPLICATEATTRIBUTE = 14053;

const ERROR_SXS_XML_E_MULTIPLEROOTS = 14054;

const ERROR_SXS_XML_E_INVALIDATROOTLEVEL = 14055;

const ERROR_SXS_XML_E_BADXMLDECL = 14056;

const ERROR_SXS_XML_E_MISSINGROOT = 14057;

const ERROR_SXS_XML_E_UNEXPECTEDEOF = 14058;

const ERROR_SXS_XML_E_BADPEREFINSUBSET = 14059;

const ERROR_SXS_XML_E_UNCLOSEDSTARTTAG = 14060;

const ERROR_SXS_XML_E_UNCLOSEDENDTAG = 14061;

const ERROR_SXS_XML_E_UNCLOSEDSTRING = 14062;

const ERROR_SXS_XML_E_UNCLOSEDCOMMENT = 14063;

const ERROR_SXS_XML_E_UNCLOSEDDECL = 14064;

const ERROR_SXS_XML_E_UNCLOSEDCDATA = 14065;

const ERROR_SXS_XML_E_RESERVEDNAMESPACE = 14066;

const ERROR_SXS_XML_E_INVALIDENCODING = 14067;

const ERROR_SXS_XML_E_INVALIDSWITCH = 14068;

const ERROR_SXS_XML_E_BADXMLCASE = 14069;

const ERROR_SXS_XML_E_INVALID_STANDALONE = 14070;

const ERROR_SXS_XML_E_UNEXPECTED_STANDALONE = 14071;

const ERROR_SXS_XML_E_INVALID_VERSION = 14072;

const ERROR_SXS_XML_E_MISSINGEQUALS = 14073;

const ERROR_SXS_PROTECTION_RECOVERY_FAILED = 14074;

const ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT = 14075;

const ERROR_SXS_PROTECTION_CATALOG_NOT_VALID = 14076;

const ERROR_SXS_UNTRANSLATABLE_HRESULT = 14077;

const ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING = 14078;

const ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE = WIN32_ERROR(14079);

const ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME = WIN32_ERROR(14080);

const ERROR_SXS_ASSEMBLY_MISSING = 14081;

const ERROR_SXS_CORRUPT_ACTIVATION_STACK = 14082;

const ERROR_SXS_CORRUPTION = 14083;

const ERROR_SXS_EARLY_DEACTIVATION = 14084;

const ERROR_SXS_INVALID_DEACTIVATION = 14085;

const ERROR_SXS_MULTIPLE_DEACTIVATION = 14086;

const ERROR_SXS_PROCESS_TERMINATION_REQUESTED = 14087;

const ERROR_SXS_RELEASE_ACTIVATION_CONTEXT = 14088;

const ERROR_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY = WIN32_ERROR(14089);

const ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE = 14090;

const ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME = 14091;

const ERROR_SXS_IDENTITY_DUPLICATE_ATTRIBUTE = 14092;

const ERROR_SXS_IDENTITY_PARSE_ERROR = 14093;

const ERROR_MALFORMED_SUBSTITUTION_STRING = 14094;

const ERROR_SXS_INCORRECT_PUBLIC_KEY_TOKEN = 14095;

const ERROR_UNMAPPED_SUBSTITUTION_STRING = 14096;

const ERROR_SXS_ASSEMBLY_NOT_LOCKED = 14097;

const ERROR_SXS_COMPONENT_STORE_CORRUPT = 14098;

const ERROR_ADVANCED_INSTALLER_FAILED = 14099;

const ERROR_XML_ENCODING_MISMATCH = 14100;

const ERROR_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT = WIN32_ERROR(
  14101,
);

const ERROR_SXS_IDENTITIES_DIFFERENT = 14102;

const ERROR_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT = 14103;

const ERROR_SXS_FILE_NOT_PART_OF_ASSEMBLY = 14104;

const ERROR_SXS_MANIFEST_TOO_BIG = 14105;

const ERROR_SXS_SETTING_NOT_REGISTERED = 14106;

const ERROR_SXS_TRANSACTION_CLOSURE_INCOMPLETE = 14107;

const ERROR_SMI_PRIMITIVE_INSTALLER_FAILED = 14108;

const ERROR_GENERIC_COMMAND_FAILED = 14109;

const ERROR_SXS_FILE_HASH_MISSING = 14110;

const ERROR_SXS_DUPLICATE_ACTIVATABLE_CLASS = 14111;

const ERROR_EVT_INVALID_CHANNEL_PATH = 15000;

const ERROR_EVT_INVALID_QUERY = 15001;

const ERROR_EVT_PUBLISHER_METADATA_NOT_FOUND = 15002;

const ERROR_EVT_EVENT_TEMPLATE_NOT_FOUND = 15003;

const ERROR_EVT_INVALID_PUBLISHER_NAME = 15004;

const ERROR_EVT_INVALID_EVENT_DATA = 15005;

const ERROR_EVT_CHANNEL_NOT_FOUND = 15007;

const ERROR_EVT_MALFORMED_XML_TEXT = 15008;

const ERROR_EVT_SUBSCRIPTION_TO_DIRECT_CHANNEL = 15009;

const ERROR_EVT_CONFIGURATION_ERROR = 15010;

const ERROR_EVT_QUERY_RESULT_STALE = 15011;

const ERROR_EVT_QUERY_RESULT_INVALID_POSITION = 15012;

const ERROR_EVT_NON_VALIDATING_MSXML = 15013;

const ERROR_EVT_FILTER_ALREADYSCOPED = 15014;

const ERROR_EVT_FILTER_NOTELTSET = 15015;

const ERROR_EVT_FILTER_INVARG = 15016;

const ERROR_EVT_FILTER_INVTEST = 15017;

const ERROR_EVT_FILTER_INVTYPE = 15018;

const ERROR_EVT_FILTER_PARSEERR = 15019;

const ERROR_EVT_FILTER_UNSUPPORTEDOP = 15020;

const ERROR_EVT_FILTER_UNEXPECTEDTOKEN = 15021;

const ERROR_EVT_INVALID_OPERATION_OVER_ENABLED_DIRECT_CHANNEL = WIN32_ERROR(
  15022,
);

const ERROR_EVT_INVALID_CHANNEL_PROPERTY_VALUE = 15023;

const ERROR_EVT_INVALID_PUBLISHER_PROPERTY_VALUE = 15024;

const ERROR_EVT_CHANNEL_CANNOT_ACTIVATE = 15025;

const ERROR_EVT_FILTER_TOO_COMPLEX = 15026;

const ERROR_EVT_MESSAGE_NOT_FOUND = 15027;

const ERROR_EVT_MESSAGE_ID_NOT_FOUND = 15028;

const ERROR_EVT_UNRESOLVED_VALUE_INSERT = 15029;

const ERROR_EVT_UNRESOLVED_PARAMETER_INSERT = 15030;

const ERROR_EVT_MAX_INSERTS_REACHED = 15031;

const ERROR_EVT_EVENT_DEFINITION_NOT_FOUND = 15032;

const ERROR_EVT_MESSAGE_LOCALE_NOT_FOUND = 15033;

const ERROR_EVT_VERSION_TOO_OLD = 15034;

const ERROR_EVT_VERSION_TOO_NEW = 15035;

const ERROR_EVT_CANNOT_OPEN_CHANNEL_OF_QUERY = 15036;

const ERROR_EVT_PUBLISHER_DISABLED = 15037;

const ERROR_EVT_FILTER_OUT_OF_RANGE = 15038;

const ERROR_EC_SUBSCRIPTION_CANNOT_ACTIVATE = 15080;

const ERROR_EC_LOG_DISABLED = 15081;

const ERROR_EC_CIRCULAR_FORWARDING = 15082;

const ERROR_EC_CREDSTORE_FULL = 15083;

const ERROR_EC_CRED_NOT_FOUND = 15084;

const ERROR_EC_NO_ACTIVE_CHANNEL = 15085;

const ERROR_MUI_FILE_NOT_FOUND = 15100;

const ERROR_MUI_INVALID_FILE = 15101;

const ERROR_MUI_INVALID_RC_CONFIG = 15102;

const ERROR_MUI_INVALID_LOCALE_NAME = 15103;

const ERROR_MUI_INVALID_ULTIMATEFALLBACK_NAME = 15104;

const ERROR_MUI_FILE_NOT_LOADED = 15105;

const ERROR_RESOURCE_ENUM_USER_STOP = 15106;

const ERROR_MUI_INTLSETTINGS_UILANG_NOT_INSTALLED = 15107;

const ERROR_MUI_INTLSETTINGS_INVALID_LOCALE_NAME = 15108;

const ERROR_MRM_RUNTIME_NO_DEFAULT_OR_NEUTRAL_RESOURCE = WIN32_ERROR(15110);

const ERROR_MRM_INVALID_PRICONFIG = 15111;

const ERROR_MRM_INVALID_FILE_TYPE = 15112;

const ERROR_MRM_UNKNOWN_QUALIFIER = 15113;

const ERROR_MRM_INVALID_QUALIFIER_VALUE = 15114;

const ERROR_MRM_NO_CANDIDATE = 15115;

const ERROR_MRM_NO_MATCH_OR_DEFAULT_CANDIDATE = 15116;

const ERROR_MRM_RESOURCE_TYPE_MISMATCH = 15117;

const ERROR_MRM_DUPLICATE_MAP_NAME = 15118;

const ERROR_MRM_DUPLICATE_ENTRY = 15119;

const ERROR_MRM_INVALID_RESOURCE_IDENTIFIER = 15120;

const ERROR_MRM_FILEPATH_TOO_LONG = 15121;

const ERROR_MRM_UNSUPPORTED_DIRECTORY_TYPE = 15122;

const ERROR_MRM_INVALID_PRI_FILE = 15126;

const ERROR_MRM_NAMED_RESOURCE_NOT_FOUND = 15127;

const ERROR_MRM_MAP_NOT_FOUND = 15135;

const ERROR_MRM_UNSUPPORTED_PROFILE_TYPE = 15136;

const ERROR_MRM_INVALID_QUALIFIER_OPERATOR = 15137;

const ERROR_MRM_INDETERMINATE_QUALIFIER_VALUE = 15138;

const ERROR_MRM_AUTOMERGE_ENABLED = 15139;

const ERROR_MRM_TOO_MANY_RESOURCES = 15140;

const ERROR_MRM_UNSUPPORTED_FILE_TYPE_FOR_MERGE = 15141;

const ERROR_MRM_UNSUPPORTED_FILE_TYPE_FOR_LOAD_UNLOAD_PRI_FILE = WIN32_ERROR(
  15142,
);

const ERROR_MRM_NO_CURRENT_VIEW_ON_THREAD = 15143;

const ERROR_DIFFERENT_PROFILE_RESOURCE_MANAGER_EXIST = WIN32_ERROR(15144);

const ERROR_OPERATION_NOT_ALLOWED_FROM_SYSTEM_COMPONENT = WIN32_ERROR(15145);

const ERROR_MRM_DIRECT_REF_TO_NON_DEFAULT_RESOURCE = WIN32_ERROR(15146);

const ERROR_MRM_GENERATION_COUNT_MISMATCH = 15147;

const ERROR_PRI_MERGE_VERSION_MISMATCH = 15148;

const ERROR_PRI_MERGE_MISSING_SCHEMA = 15149;

const ERROR_PRI_MERGE_LOAD_FILE_FAILED = 15150;

const ERROR_PRI_MERGE_ADD_FILE_FAILED = 15151;

const ERROR_PRI_MERGE_WRITE_FILE_FAILED = 15152;

const ERROR_PRI_MERGE_MULTIPLE_PACKAGE_FAMILIES_NOT_ALLOWED = WIN32_ERROR(
  15153,
);

const ERROR_PRI_MERGE_MULTIPLE_MAIN_PACKAGES_NOT_ALLOWED = WIN32_ERROR(15154);

const ERROR_PRI_MERGE_BUNDLE_PACKAGES_NOT_ALLOWED = 15155;

const ERROR_PRI_MERGE_MAIN_PACKAGE_REQUIRED = 15156;

const ERROR_PRI_MERGE_RESOURCE_PACKAGE_REQUIRED = 15157;

const ERROR_PRI_MERGE_INVALID_FILE_NAME = 15158;

const ERROR_MRM_PACKAGE_NOT_FOUND = 15159;

const ERROR_MRM_MISSING_DEFAULT_LANGUAGE = 15160;

const ERROR_MRM_SCOPE_ITEM_CONFLICT = 15161;

const ERROR_MCA_INVALID_CAPABILITIES_STRING = 15200;

const ERROR_MCA_INVALID_VCP_VERSION = 15201;

const ERROR_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION = WIN32_ERROR(15202);

const ERROR_MCA_MCCS_VERSION_MISMATCH = 15203;

const ERROR_MCA_UNSUPPORTED_MCCS_VERSION = 15204;

const ERROR_MCA_INTERNAL_ERROR = 15205;

const ERROR_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED = 15206;

const ERROR_MCA_UNSUPPORTED_COLOR_TEMPERATURE = 15207;

const ERROR_AMBIGUOUS_SYSTEM_DEVICE = 15250;

const ERROR_SYSTEM_DEVICE_NOT_FOUND = 15299;

const ERROR_HASH_NOT_SUPPORTED = 15300;

const ERROR_HASH_NOT_PRESENT = 15301;

const ERROR_SECONDARY_IC_PROVIDER_NOT_REGISTERED = 15321;

const ERROR_GPIO_CLIENT_INFORMATION_INVALID = 15322;

const ERROR_GPIO_VERSION_NOT_SUPPORTED = 15323;

const ERROR_GPIO_INVALID_REGISTRATION_PACKET = 15324;

const ERROR_GPIO_OPERATION_DENIED = 15325;

const ERROR_GPIO_INCOMPATIBLE_CONNECT_MODE = 15326;

const ERROR_GPIO_INTERRUPT_ALREADY_UNMASKED = 15327;

const ERROR_CANNOT_SWITCH_RUNLEVEL = 15400;

const ERROR_INVALID_RUNLEVEL_SETTING = 15401;

const ERROR_RUNLEVEL_SWITCH_TIMEOUT = 15402;

const ERROR_RUNLEVEL_SWITCH_AGENT_TIMEOUT = 15403;

const ERROR_RUNLEVEL_SWITCH_IN_PROGRESS = 15404;

const ERROR_SERVICES_FAILED_AUTOSTART = 15405;

const ERROR_COM_TASK_STOP_PENDING = 15501;

const ERROR_INSTALL_OPEN_PACKAGE_FAILED = 15600;

const ERROR_INSTALL_PACKAGE_NOT_FOUND = 15601;

const ERROR_INSTALL_INVALID_PACKAGE = 15602;

const ERROR_INSTALL_RESOLVE_DEPENDENCY_FAILED = 15603;

const ERROR_INSTALL_OUT_OF_DISK_SPACE = 15604;

const ERROR_INSTALL_NETWORK_FAILURE = 15605;

const ERROR_INSTALL_REGISTRATION_FAILURE = 15606;

const ERROR_INSTALL_DEREGISTRATION_FAILURE = 15607;

const ERROR_INSTALL_CANCEL = 15608;

const ERROR_INSTALL_FAILED = 15609;

const ERROR_REMOVE_FAILED = 15610;

const ERROR_PACKAGE_ALREADY_EXISTS = 15611;

const ERROR_NEEDS_REMEDIATION = 15612;

const ERROR_INSTALL_PREREQUISITE_FAILED = 15613;

const ERROR_PACKAGE_REPOSITORY_CORRUPTED = 15614;

const ERROR_INSTALL_POLICY_FAILURE = 15615;

const ERROR_PACKAGE_UPDATING = 15616;

const ERROR_DEPLOYMENT_BLOCKED_BY_POLICY = 15617;

const ERROR_PACKAGES_IN_USE = 15618;

const ERROR_RECOVERY_FILE_CORRUPT = 15619;

const ERROR_INVALID_STAGED_SIGNATURE = 15620;

const ERROR_DELETING_EXISTING_APPLICATIONDATA_STORE_FAILED = WIN32_ERROR(15621);

const ERROR_INSTALL_PACKAGE_DOWNGRADE = 15622;

const ERROR_SYSTEM_NEEDS_REMEDIATION = 15623;

const ERROR_APPX_INTEGRITY_FAILURE_CLR_NGEN = 15624;

const ERROR_RESILIENCY_FILE_CORRUPT = 15625;

const ERROR_INSTALL_FIREWALL_SERVICE_NOT_RUNNING = 15626;

const ERROR_PACKAGE_MOVE_FAILED = 15627;

const ERROR_INSTALL_VOLUME_NOT_EMPTY = 15628;

const ERROR_INSTALL_VOLUME_OFFLINE = 15629;

const ERROR_INSTALL_VOLUME_CORRUPT = 15630;

const ERROR_NEEDS_REGISTRATION = 15631;

const ERROR_INSTALL_WRONG_PROCESSOR_ARCHITECTURE = 15632;

const ERROR_DEV_SIDELOAD_LIMIT_EXCEEDED = 15633;

const ERROR_INSTALL_OPTIONAL_PACKAGE_REQUIRES_MAIN_PACKAGE = WIN32_ERROR(15634);

const ERROR_PACKAGE_NOT_SUPPORTED_ON_FILESYSTEM = 15635;

const ERROR_PACKAGE_MOVE_BLOCKED_BY_STREAMING = 15636;

const ERROR_INSTALL_OPTIONAL_PACKAGE_APPLICATIONID_NOT_UNIQUE = WIN32_ERROR(
  15637,
);

const ERROR_PACKAGE_STAGING_ONHOLD = 15638;

const ERROR_INSTALL_INVALID_RELATED_SET_UPDATE = 15639;

const ERROR_INSTALL_OPTIONAL_PACKAGE_REQUIRES_MAIN_PACKAGE_FULLTRUST_CAPABILITY =
    WIN32_ERROR(15640);

const ERROR_DEPLOYMENT_BLOCKED_BY_USER_LOG_OFF = 15641;

const ERROR_PROVISION_OPTIONAL_PACKAGE_REQUIRES_MAIN_PACKAGE_PROVISIONED =
    WIN32_ERROR(15642);

const ERROR_PACKAGES_REPUTATION_CHECK_FAILED = 15643;

const ERROR_PACKAGES_REPUTATION_CHECK_TIMEDOUT = 15644;

const ERROR_DEPLOYMENT_OPTION_NOT_SUPPORTED = 15645;

const ERROR_APPINSTALLER_ACTIVATION_BLOCKED = 15646;

const ERROR_REGISTRATION_FROM_REMOTE_DRIVE_NOT_SUPPORTED = WIN32_ERROR(15647);

const ERROR_APPX_RAW_DATA_WRITE_FAILED = 15648;

const ERROR_DEPLOYMENT_BLOCKED_BY_VOLUME_POLICY_PACKAGE = WIN32_ERROR(15649);

const ERROR_DEPLOYMENT_BLOCKED_BY_VOLUME_POLICY_MACHINE = WIN32_ERROR(15650);

const ERROR_DEPLOYMENT_BLOCKED_BY_PROFILE_POLICY = 15651;

const ERROR_DEPLOYMENT_FAILED_CONFLICTING_MUTABLE_PACKAGE_DIRECTORY =
    WIN32_ERROR(15652);

const ERROR_SINGLETON_RESOURCE_INSTALLED_IN_ACTIVE_USER = WIN32_ERROR(15653);

const ERROR_DIFFERENT_VERSION_OF_PACKAGED_SERVICE_INSTALLED = WIN32_ERROR(
  15654,
);

const ERROR_SERVICE_EXISTS_AS_NON_PACKAGED_SERVICE = WIN32_ERROR(15655);

const ERROR_PACKAGED_SERVICE_REQUIRES_ADMIN_PRIVILEGES = WIN32_ERROR(15656);

const ERROR_REDIRECTION_TO_DEFAULT_ACCOUNT_NOT_ALLOWED = WIN32_ERROR(15657);

const ERROR_PACKAGE_LACKS_CAPABILITY_TO_DEPLOY_ON_HOST = WIN32_ERROR(15658);

const ERROR_UNSIGNED_PACKAGE_INVALID_CONTENT = 15659;

const ERROR_UNSIGNED_PACKAGE_INVALID_PUBLISHER_NAMESPACE = WIN32_ERROR(15660);

const ERROR_SIGNED_PACKAGE_INVALID_PUBLISHER_NAMESPACE = WIN32_ERROR(15661);

const ERROR_PACKAGE_EXTERNAL_LOCATION_NOT_ALLOWED = 15662;

const ERROR_INSTALL_FULLTRUST_HOSTRUNTIME_REQUIRES_MAIN_PACKAGE_FULLTRUST_CAPABILITY =
    WIN32_ERROR(15663);

const ERROR_PACKAGE_LACKS_CAPABILITY_FOR_MANDATORY_STARTUPTASKS = WIN32_ERROR(
  15664,
);

const ERROR_INSTALL_RESOLVE_HOSTRUNTIME_DEPENDENCY_FAILED = WIN32_ERROR(15665);

const ERROR_MACHINE_SCOPE_NOT_ALLOWED = 15666;

const ERROR_CLASSIC_COMPAT_MODE_NOT_ALLOWED = 15667;

const ERROR_STAGEFROMUPDATEAGENT_PACKAGE_NOT_APPLICABLE = WIN32_ERROR(15668);

const ERROR_PACKAGE_NOT_REGISTERED_FOR_USER = 15669;

const ERROR_PACKAGE_NAME_MISMATCH = 15670;

const ERROR_APPINSTALLER_URI_IN_USE = 15671;

const ERROR_APPINSTALLER_IS_MANAGED_BY_SYSTEM = 15672;

const ERROR_STATE_LOAD_STORE_FAILED = 15800;

const ERROR_STATE_GET_VERSION_FAILED = 15801;

const ERROR_STATE_SET_VERSION_FAILED = 15802;

const ERROR_STATE_STRUCTURED_RESET_FAILED = 15803;

const ERROR_STATE_OPEN_CONTAINER_FAILED = 15804;

const ERROR_STATE_CREATE_CONTAINER_FAILED = 15805;

const ERROR_STATE_DELETE_CONTAINER_FAILED = 15806;

const ERROR_STATE_READ_SETTING_FAILED = 15807;

const ERROR_STATE_WRITE_SETTING_FAILED = 15808;

const ERROR_STATE_DELETE_SETTING_FAILED = 15809;

const ERROR_STATE_QUERY_SETTING_FAILED = 15810;

const ERROR_STATE_READ_COMPOSITE_SETTING_FAILED = 15811;

const ERROR_STATE_WRITE_COMPOSITE_SETTING_FAILED = 15812;

const ERROR_STATE_ENUMERATE_CONTAINER_FAILED = 15813;

const ERROR_STATE_ENUMERATE_SETTINGS_FAILED = 15814;

const ERROR_STATE_COMPOSITE_SETTING_VALUE_SIZE_LIMIT_EXCEEDED = WIN32_ERROR(
  15815,
);

const ERROR_STATE_SETTING_VALUE_SIZE_LIMIT_EXCEEDED = WIN32_ERROR(15816);

const ERROR_STATE_SETTING_NAME_SIZE_LIMIT_EXCEEDED = WIN32_ERROR(15817);

const ERROR_STATE_CONTAINER_NAME_SIZE_LIMIT_EXCEEDED = WIN32_ERROR(15818);

const ERROR_API_UNAVAILABLE = 15841;

const ERROR_NDIS_INTERFACE_CLOSING = 2150891522;

const ERROR_NDIS_BAD_VERSION = 2150891524;

const ERROR_NDIS_BAD_CHARACTERISTICS = 2150891525;

const ERROR_NDIS_ADAPTER_NOT_FOUND = 2150891526;

const ERROR_NDIS_OPEN_FAILED = 2150891527;

const ERROR_NDIS_DEVICE_FAILED = 2150891528;

const ERROR_NDIS_MULTICAST_FULL = 2150891529;

const ERROR_NDIS_MULTICAST_EXISTS = 2150891530;

const ERROR_NDIS_MULTICAST_NOT_FOUND = 2150891531;

const ERROR_NDIS_REQUEST_ABORTED = 2150891532;

const ERROR_NDIS_RESET_IN_PROGRESS = 2150891533;

const ERROR_NDIS_NOT_SUPPORTED = 2150891707;

const ERROR_NDIS_INVALID_PACKET = 2150891535;

const ERROR_NDIS_ADAPTER_NOT_READY = 2150891537;

const ERROR_NDIS_INVALID_LENGTH = 2150891540;

const ERROR_NDIS_INVALID_DATA = 2150891541;

const ERROR_NDIS_BUFFER_TOO_SHORT = 2150891542;

const ERROR_NDIS_INVALID_OID = 2150891543;

const ERROR_NDIS_ADAPTER_REMOVED = 2150891544;

const ERROR_NDIS_UNSUPPORTED_MEDIA = 2150891545;

const ERROR_NDIS_GROUP_ADDRESS_IN_USE = 2150891546;

const ERROR_NDIS_FILE_NOT_FOUND = 2150891547;

const ERROR_NDIS_ERROR_READING_FILE = 2150891548;

const ERROR_NDIS_ALREADY_MAPPED = 2150891549;

const ERROR_NDIS_RESOURCE_CONFLICT = 2150891550;

const ERROR_NDIS_MEDIA_DISCONNECTED = 2150891551;

const ERROR_NDIS_INVALID_ADDRESS = 2150891554;

const ERROR_NDIS_INVALID_DEVICE_REQUEST = 2150891536;

const ERROR_NDIS_PAUSED = 2150891562;

const ERROR_NDIS_INTERFACE_NOT_FOUND = 2150891563;

const ERROR_NDIS_UNSUPPORTED_REVISION = 2150891564;

const ERROR_NDIS_INVALID_PORT = 2150891565;

const ERROR_NDIS_INVALID_PORT_STATE = 2150891566;

const ERROR_NDIS_LOW_POWER_STATE = 2150891567;

const ERROR_NDIS_REINIT_REQUIRED = 2150891568;

const ERROR_NDIS_NO_QUEUES = 2150891569;

const ERROR_NDIS_DOT11_AUTO_CONFIG_ENABLED = 2150899712;

const ERROR_NDIS_DOT11_MEDIA_IN_USE = 2150899713;

const ERROR_NDIS_DOT11_POWER_STATE_INVALID = 2150899714;

const ERROR_NDIS_PM_WOL_PATTERN_LIST_FULL = 2150899715;

const ERROR_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL = WIN32_ERROR(2150899716);

const ERROR_NDIS_DOT11_AP_CHANNEL_CURRENTLY_NOT_AVAILABLE = WIN32_ERROR(
  2150899717,
);

const ERROR_NDIS_DOT11_AP_BAND_CURRENTLY_NOT_AVAILABLE = WIN32_ERROR(
  2150899718,
);

const ERROR_NDIS_DOT11_AP_CHANNEL_NOT_ALLOWED = WIN32_ERROR(2150899719);

const ERROR_NDIS_DOT11_AP_BAND_NOT_ALLOWED = 2150899720;

const ERROR_NDIS_INDICATION_REQUIRED = 3407873;

const ERROR_NDIS_OFFLOAD_POLICY = 3224637455;

const ERROR_NDIS_OFFLOAD_CONNECTION_REJECTED = 3224637458;

const ERROR_NDIS_OFFLOAD_PATH_REJECTED = 3224637459;

const ERROR_HV_INVALID_HYPERCALL_CODE = 3224698882;

const ERROR_HV_INVALID_HYPERCALL_INPUT = 3224698883;

const ERROR_HV_INVALID_ALIGNMENT = 3224698884;

const ERROR_HV_INVALID_PARAMETER = 3224698885;

const ERROR_HV_ACCESS_DENIED = 3224698886;

const ERROR_HV_INVALID_PARTITION_STATE = 3224698887;

const ERROR_HV_OPERATION_DENIED = 3224698888;

const ERROR_HV_UNKNOWN_PROPERTY = 3224698889;

const ERROR_HV_PROPERTY_VALUE_OUT_OF_RANGE = 3224698890;

const ERROR_HV_INSUFFICIENT_MEMORY = 3224698891;

const ERROR_HV_PARTITION_TOO_DEEP = 3224698892;

const ERROR_HV_INVALID_PARTITION_ID = 3224698893;

const ERROR_HV_INVALID_VP_INDEX = 3224698894;

const ERROR_HV_INVALID_PORT_ID = 3224698897;

const ERROR_HV_INVALID_CONNECTION_ID = 3224698898;

const ERROR_HV_INSUFFICIENT_BUFFERS = 3224698899;

const ERROR_HV_NOT_ACKNOWLEDGED = 3224698900;

const ERROR_HV_INVALID_VP_STATE = 3224698901;

const ERROR_HV_ACKNOWLEDGED = 3224698902;

const ERROR_HV_INVALID_SAVE_RESTORE_STATE = 3224698903;

const ERROR_HV_INVALID_SYNIC_STATE = 3224698904;

const ERROR_HV_OBJECT_IN_USE = 3224698905;

const ERROR_HV_INVALID_PROXIMITY_DOMAIN_INFO = 3224698906;

const ERROR_HV_NO_DATA = 3224698907;

const ERROR_HV_INACTIVE = 3224698908;

const ERROR_HV_NO_RESOURCES = 3224698909;

const ERROR_HV_FEATURE_UNAVAILABLE = 3224698910;

const ERROR_HV_INSUFFICIENT_BUFFER = 3224698931;

const ERROR_HV_INSUFFICIENT_DEVICE_DOMAINS = 3224698936;

const ERROR_HV_CPUID_FEATURE_VALIDATION = 3224698940;

const ERROR_HV_CPUID_XSAVE_FEATURE_VALIDATION = WIN32_ERROR(3224698941);

const ERROR_HV_PROCESSOR_STARTUP_TIMEOUT = 3224698942;

const ERROR_HV_SMX_ENABLED = 3224698943;

const ERROR_HV_INVALID_LP_INDEX = 3224698945;

const ERROR_HV_INVALID_REGISTER_VALUE = 3224698960;

const ERROR_HV_INVALID_VTL_STATE = 3224698961;

const ERROR_HV_NX_NOT_DETECTED = 3224698965;

const ERROR_HV_INVALID_DEVICE_ID = 3224698967;

const ERROR_HV_INVALID_DEVICE_STATE = 3224698968;

const ERROR_HV_PENDING_PAGE_REQUESTS = 3473497;

const ERROR_HV_PAGE_REQUEST_INVALID = 3224698976;

const ERROR_HV_INVALID_CPU_GROUP_ID = 3224698991;

const ERROR_HV_INVALID_CPU_GROUP_STATE = 3224698992;

const ERROR_HV_OPERATION_FAILED = 3224698993;

const ERROR_HV_NOT_ALLOWED_WITH_NESTED_VIRT_ACTIVE = WIN32_ERROR(3224698994);

const ERROR_HV_INSUFFICIENT_ROOT_MEMORY = 3224698995;

const ERROR_HV_EVENT_BUFFER_ALREADY_FREED = 3224698996;

const ERROR_HV_INSUFFICIENT_CONTIGUOUS_MEMORY = WIN32_ERROR(3224698997);

const ERROR_HV_DEVICE_NOT_IN_DOMAIN = 3224698998;

const ERROR_HV_NESTED_VM_EXIT = 3224698999;

const ERROR_HV_MSR_ACCESS_FAILED = 3224699008;

const ERROR_HV_INSUFFICIENT_MEMORY_MIRRORING = 3224699009;

const ERROR_HV_INSUFFICIENT_CONTIGUOUS_MEMORY_MIRRORING = WIN32_ERROR(
  3224699010,
);

const ERROR_HV_INSUFFICIENT_CONTIGUOUS_ROOT_MEMORY = WIN32_ERROR(3224699011);

const ERROR_HV_INSUFFICIENT_ROOT_MEMORY_MIRRORING = WIN32_ERROR(3224699012);

const ERROR_HV_INSUFFICIENT_CONTIGUOUS_ROOT_MEMORY_MIRRORING = WIN32_ERROR(
  3224699013,
);

const ERROR_HV_NOT_PRESENT = 3224702976;

const ERROR_VID_DUPLICATE_HANDLER = 3224829953;

const ERROR_VID_TOO_MANY_HANDLERS = 3224829954;

const ERROR_VID_QUEUE_FULL = 3224829955;

const ERROR_VID_HANDLER_NOT_PRESENT = 3224829956;

const ERROR_VID_INVALID_OBJECT_NAME = 3224829957;

const ERROR_VID_PARTITION_NAME_TOO_LONG = 3224829958;

const ERROR_VID_MESSAGE_QUEUE_NAME_TOO_LONG = 3224829959;

const ERROR_VID_PARTITION_ALREADY_EXISTS = 3224829960;

const ERROR_VID_PARTITION_DOES_NOT_EXIST = 3224829961;

const ERROR_VID_PARTITION_NAME_NOT_FOUND = 3224829962;

const ERROR_VID_MESSAGE_QUEUE_ALREADY_EXISTS = 3224829963;

const ERROR_VID_EXCEEDED_MBP_ENTRY_MAP_LIMIT = 3224829964;

const ERROR_VID_MB_STILL_REFERENCED = 3224829965;

const ERROR_VID_CHILD_GPA_PAGE_SET_CORRUPTED = 3224829966;

const ERROR_VID_INVALID_NUMA_SETTINGS = 3224829967;

const ERROR_VID_INVALID_NUMA_NODE_INDEX = 3224829968;

const ERROR_VID_NOTIFICATION_QUEUE_ALREADY_ASSOCIATED = WIN32_ERROR(3224829969);

const ERROR_VID_INVALID_MEMORY_BLOCK_HANDLE = 3224829970;

const ERROR_VID_PAGE_RANGE_OVERFLOW = 3224829971;

const ERROR_VID_INVALID_MESSAGE_QUEUE_HANDLE = 3224829972;

const ERROR_VID_INVALID_GPA_RANGE_HANDLE = 3224829973;

const ERROR_VID_NO_MEMORY_BLOCK_NOTIFICATION_QUEUE = WIN32_ERROR(3224829974);

const ERROR_VID_MEMORY_BLOCK_LOCK_COUNT_EXCEEDED = WIN32_ERROR(3224829975);

const ERROR_VID_INVALID_PPM_HANDLE = 3224829976;

const ERROR_VID_MBPS_ARE_LOCKED = 3224829977;

const ERROR_VID_MESSAGE_QUEUE_CLOSED = 3224829978;

const ERROR_VID_VIRTUAL_PROCESSOR_LIMIT_EXCEEDED = WIN32_ERROR(3224829979);

const ERROR_VID_STOP_PENDING = 3224829980;

const ERROR_VID_INVALID_PROCESSOR_STATE = 3224829981;

const ERROR_VID_EXCEEDED_KM_CONTEXT_COUNT_LIMIT = WIN32_ERROR(3224829982);

const ERROR_VID_KM_INTERFACE_ALREADY_INITIALIZED = WIN32_ERROR(3224829983);

const ERROR_VID_MB_PROPERTY_ALREADY_SET_RESET = WIN32_ERROR(3224829984);

const ERROR_VID_MMIO_RANGE_DESTROYED = 3224829985;

const ERROR_VID_INVALID_CHILD_GPA_PAGE_SET = 3224829986;

const ERROR_VID_RESERVE_PAGE_SET_IS_BEING_USED = WIN32_ERROR(3224829987);

const ERROR_VID_RESERVE_PAGE_SET_TOO_SMALL = 3224829988;

const ERROR_VID_MBP_ALREADY_LOCKED_USING_RESERVED_PAGE = WIN32_ERROR(
  3224829989,
);

const ERROR_VID_MBP_COUNT_EXCEEDED_LIMIT = 3224829990;

const ERROR_VID_SAVED_STATE_CORRUPT = 3224829991;

const ERROR_VID_SAVED_STATE_UNRECOGNIZED_ITEM = WIN32_ERROR(3224829992);

const ERROR_VID_SAVED_STATE_INCOMPATIBLE = 3224829993;

const ERROR_VID_VTL_ACCESS_DENIED = 3224829994;

const ERROR_VID_INSUFFICIENT_RESOURCES_RESERVE = WIN32_ERROR(3224829995);

const ERROR_VID_INSUFFICIENT_RESOURCES_PHYSICAL_BUFFER = WIN32_ERROR(
  3224829996,
);

const ERROR_VID_INSUFFICIENT_RESOURCES_HV_DEPOSIT = WIN32_ERROR(3224829997);

const ERROR_VID_MEMORY_TYPE_NOT_SUPPORTED = 3224829998;

const ERROR_VID_INSUFFICIENT_RESOURCES_WITHDRAW = WIN32_ERROR(3224829999);

const ERROR_VID_PROCESS_ALREADY_SET = 3224830000;

const ERROR_VMCOMPUTE_TERMINATED_DURING_START = WIN32_ERROR(3224830208);

const ERROR_VMCOMPUTE_IMAGE_MISMATCH = 3224830209;

const ERROR_VMCOMPUTE_HYPERV_NOT_INSTALLED = 3224830210;

const ERROR_VMCOMPUTE_OPERATION_PENDING = 3224830211;

const ERROR_VMCOMPUTE_TOO_MANY_NOTIFICATIONS = 3224830212;

const ERROR_VMCOMPUTE_INVALID_STATE = 3224830213;

const ERROR_VMCOMPUTE_UNEXPECTED_EXIT = 3224830214;

const ERROR_VMCOMPUTE_TERMINATED = 3224830215;

const ERROR_VMCOMPUTE_CONNECT_FAILED = 3224830216;

const ERROR_VMCOMPUTE_TIMEOUT = 3224830217;

const ERROR_VMCOMPUTE_CONNECTION_CLOSED = 3224830218;

const ERROR_VMCOMPUTE_UNKNOWN_MESSAGE = 3224830219;

const ERROR_VMCOMPUTE_UNSUPPORTED_PROTOCOL_VERSION = WIN32_ERROR(3224830220);

const ERROR_VMCOMPUTE_INVALID_JSON = 3224830221;

const ERROR_VMCOMPUTE_SYSTEM_NOT_FOUND = 3224830222;

const ERROR_VMCOMPUTE_SYSTEM_ALREADY_EXISTS = 3224830223;

const ERROR_VMCOMPUTE_SYSTEM_ALREADY_STOPPED = 3224830224;

const ERROR_VMCOMPUTE_PROTOCOL_ERROR = 3224830225;

const ERROR_VMCOMPUTE_INVALID_LAYER = 3224830226;

const ERROR_VMCOMPUTE_WINDOWS_INSIDER_REQUIRED = WIN32_ERROR(3224830227);

const ERROR_VNET_VIRTUAL_SWITCH_NAME_NOT_FOUND = WIN32_ERROR(3224830464);

const ERROR_VID_REMOTE_NODE_PARENT_GPA_PAGES_USED = WIN32_ERROR(2151088129);

const ERROR_VSMB_SAVED_STATE_FILE_NOT_FOUND = 3224830976;

const ERROR_VSMB_SAVED_STATE_CORRUPT = 3224830977;

const ERROR_VOLMGR_INCOMPLETE_REGENERATION = 2151153665;

const ERROR_VOLMGR_INCOMPLETE_DISK_MIGRATION = 2151153666;

const ERROR_VOLMGR_DATABASE_FULL = 3224895489;

const ERROR_VOLMGR_DISK_CONFIGURATION_CORRUPTED = WIN32_ERROR(3224895490);

const ERROR_VOLMGR_DISK_CONFIGURATION_NOT_IN_SYNC = WIN32_ERROR(3224895491);

const ERROR_VOLMGR_PACK_CONFIG_UPDATE_FAILED = 3224895492;

const ERROR_VOLMGR_DISK_CONTAINS_NON_SIMPLE_VOLUME = WIN32_ERROR(3224895493);

const ERROR_VOLMGR_DISK_DUPLICATE = 3224895494;

const ERROR_VOLMGR_DISK_DYNAMIC = 3224895495;

const ERROR_VOLMGR_DISK_ID_INVALID = 3224895496;

const ERROR_VOLMGR_DISK_INVALID = 3224895497;

const ERROR_VOLMGR_DISK_LAST_VOTER = 3224895498;

const ERROR_VOLMGR_DISK_LAYOUT_INVALID = 3224895499;

const ERROR_VOLMGR_DISK_LAYOUT_NON_BASIC_BETWEEN_BASIC_PARTITIONS = WIN32_ERROR(
  3224895500,
);

const ERROR_VOLMGR_DISK_LAYOUT_NOT_CYLINDER_ALIGNED = WIN32_ERROR(3224895501);

const ERROR_VOLMGR_DISK_LAYOUT_PARTITIONS_TOO_SMALL = WIN32_ERROR(3224895502);

const ERROR_VOLMGR_DISK_LAYOUT_PRIMARY_BETWEEN_LOGICAL_PARTITIONS = WIN32_ERROR(
  3224895503,
);

const ERROR_VOLMGR_DISK_LAYOUT_TOO_MANY_PARTITIONS = WIN32_ERROR(3224895504);

const ERROR_VOLMGR_DISK_MISSING = 3224895505;

const ERROR_VOLMGR_DISK_NOT_EMPTY = 3224895506;

const ERROR_VOLMGR_DISK_NOT_ENOUGH_SPACE = 3224895507;

const ERROR_VOLMGR_DISK_REVECTORING_FAILED = 3224895508;

const ERROR_VOLMGR_DISK_SECTOR_SIZE_INVALID = 3224895509;

const ERROR_VOLMGR_DISK_SET_NOT_CONTAINED = 3224895510;

const ERROR_VOLMGR_DISK_USED_BY_MULTIPLE_MEMBERS = WIN32_ERROR(3224895511);

const ERROR_VOLMGR_DISK_USED_BY_MULTIPLE_PLEXES = WIN32_ERROR(3224895512);

const ERROR_VOLMGR_DYNAMIC_DISK_NOT_SUPPORTED = WIN32_ERROR(3224895513);

const ERROR_VOLMGR_EXTENT_ALREADY_USED = 3224895514;

const ERROR_VOLMGR_EXTENT_NOT_CONTIGUOUS = 3224895515;

const ERROR_VOLMGR_EXTENT_NOT_IN_PUBLIC_REGION = WIN32_ERROR(3224895516);

const ERROR_VOLMGR_EXTENT_NOT_SECTOR_ALIGNED = 3224895517;

const ERROR_VOLMGR_EXTENT_OVERLAPS_EBR_PARTITION = WIN32_ERROR(3224895518);

const ERROR_VOLMGR_EXTENT_VOLUME_LENGTHS_DO_NOT_MATCH = WIN32_ERROR(3224895519);

const ERROR_VOLMGR_FAULT_TOLERANT_NOT_SUPPORTED = WIN32_ERROR(3224895520);

const ERROR_VOLMGR_INTERLEAVE_LENGTH_INVALID = 3224895521;

const ERROR_VOLMGR_MAXIMUM_REGISTERED_USERS = 3224895522;

const ERROR_VOLMGR_MEMBER_IN_SYNC = 3224895523;

const ERROR_VOLMGR_MEMBER_INDEX_DUPLICATE = 3224895524;

const ERROR_VOLMGR_MEMBER_INDEX_INVALID = 3224895525;

const ERROR_VOLMGR_MEMBER_MISSING = 3224895526;

const ERROR_VOLMGR_MEMBER_NOT_DETACHED = 3224895527;

const ERROR_VOLMGR_MEMBER_REGENERATING = 3224895528;

const ERROR_VOLMGR_ALL_DISKS_FAILED = 3224895529;

const ERROR_VOLMGR_NO_REGISTERED_USERS = 3224895530;

const ERROR_VOLMGR_NO_SUCH_USER = 3224895531;

const ERROR_VOLMGR_NOTIFICATION_RESET = 3224895532;

const ERROR_VOLMGR_NUMBER_OF_MEMBERS_INVALID = 3224895533;

const ERROR_VOLMGR_NUMBER_OF_PLEXES_INVALID = 3224895534;

const ERROR_VOLMGR_PACK_DUPLICATE = 3224895535;

const ERROR_VOLMGR_PACK_ID_INVALID = 3224895536;

const ERROR_VOLMGR_PACK_INVALID = 3224895537;

const ERROR_VOLMGR_PACK_NAME_INVALID = 3224895538;

const ERROR_VOLMGR_PACK_OFFLINE = 3224895539;

const ERROR_VOLMGR_PACK_HAS_QUORUM = 3224895540;

const ERROR_VOLMGR_PACK_WITHOUT_QUORUM = 3224895541;

const ERROR_VOLMGR_PARTITION_STYLE_INVALID = 3224895542;

const ERROR_VOLMGR_PARTITION_UPDATE_FAILED = 3224895543;

const ERROR_VOLMGR_PLEX_IN_SYNC = 3224895544;

const ERROR_VOLMGR_PLEX_INDEX_DUPLICATE = 3224895545;

const ERROR_VOLMGR_PLEX_INDEX_INVALID = 3224895546;

const ERROR_VOLMGR_PLEX_LAST_ACTIVE = 3224895547;

const ERROR_VOLMGR_PLEX_MISSING = 3224895548;

const ERROR_VOLMGR_PLEX_REGENERATING = 3224895549;

const ERROR_VOLMGR_PLEX_TYPE_INVALID = 3224895550;

const ERROR_VOLMGR_PLEX_NOT_RAID5 = 3224895551;

const ERROR_VOLMGR_PLEX_NOT_SIMPLE = 3224895552;

const ERROR_VOLMGR_STRUCTURE_SIZE_INVALID = 3224895553;

const ERROR_VOLMGR_TOO_MANY_NOTIFICATION_REQUESTS = WIN32_ERROR(3224895554);

const ERROR_VOLMGR_TRANSACTION_IN_PROGRESS = 3224895555;

const ERROR_VOLMGR_UNEXPECTED_DISK_LAYOUT_CHANGE = WIN32_ERROR(3224895556);

const ERROR_VOLMGR_VOLUME_CONTAINS_MISSING_DISK = WIN32_ERROR(3224895557);

const ERROR_VOLMGR_VOLUME_ID_INVALID = 3224895558;

const ERROR_VOLMGR_VOLUME_LENGTH_INVALID = 3224895559;

const ERROR_VOLMGR_VOLUME_LENGTH_NOT_SECTOR_SIZE_MULTIPLE = WIN32_ERROR(
  3224895560,
);

const ERROR_VOLMGR_VOLUME_NOT_MIRRORED = 3224895561;

const ERROR_VOLMGR_VOLUME_NOT_RETAINED = 3224895562;

const ERROR_VOLMGR_VOLUME_OFFLINE = 3224895563;

const ERROR_VOLMGR_VOLUME_RETAINED = 3224895564;

const ERROR_VOLMGR_NUMBER_OF_EXTENTS_INVALID = 3224895565;

const ERROR_VOLMGR_DIFFERENT_SECTOR_SIZE = 3224895566;

const ERROR_VOLMGR_BAD_BOOT_DISK = 3224895567;

const ERROR_VOLMGR_PACK_CONFIG_OFFLINE = 3224895568;

const ERROR_VOLMGR_PACK_CONFIG_ONLINE = 3224895569;

const ERROR_VOLMGR_NOT_PRIMARY_PACK = 3224895570;

const ERROR_VOLMGR_PACK_LOG_UPDATE_FAILED = 3224895571;

const ERROR_VOLMGR_NUMBER_OF_DISKS_IN_PLEX_INVALID = WIN32_ERROR(3224895572);

const ERROR_VOLMGR_NUMBER_OF_DISKS_IN_MEMBER_INVALID = WIN32_ERROR(3224895573);

const ERROR_VOLMGR_VOLUME_MIRRORED = 3224895574;

const ERROR_VOLMGR_PLEX_NOT_SIMPLE_SPANNED = 3224895575;

const ERROR_VOLMGR_NO_VALID_LOG_COPIES = 3224895576;

const ERROR_VOLMGR_PRIMARY_PACK_PRESENT = 3224895577;

const ERROR_VOLMGR_NUMBER_OF_DISKS_INVALID = 3224895578;

const ERROR_VOLMGR_MIRROR_NOT_SUPPORTED = 3224895579;

const ERROR_VOLMGR_RAID5_NOT_SUPPORTED = 3224895580;

const ERROR_BCD_NOT_ALL_ENTRIES_IMPORTED = 2151219201;

const ERROR_BCD_TOO_MANY_ELEMENTS = 3224961026;

const ERROR_BCD_NOT_ALL_ENTRIES_SYNCHRONIZED = 2151219203;

const ERROR_VHD_DRIVE_FOOTER_MISSING = 3225026561;

const ERROR_VHD_DRIVE_FOOTER_CHECKSUM_MISMATCH = WIN32_ERROR(3225026562);

const ERROR_VHD_DRIVE_FOOTER_CORRUPT = 3225026563;

const ERROR_VHD_FORMAT_UNKNOWN = 3225026564;

const ERROR_VHD_FORMAT_UNSUPPORTED_VERSION = 3225026565;

const ERROR_VHD_SPARSE_HEADER_CHECKSUM_MISMATCH = WIN32_ERROR(3225026566);

const ERROR_VHD_SPARSE_HEADER_UNSUPPORTED_VERSION = WIN32_ERROR(3225026567);

const ERROR_VHD_SPARSE_HEADER_CORRUPT = 3225026568;

const ERROR_VHD_BLOCK_ALLOCATION_FAILURE = 3225026569;

const ERROR_VHD_BLOCK_ALLOCATION_TABLE_CORRUPT = WIN32_ERROR(3225026570);

const ERROR_VHD_INVALID_BLOCK_SIZE = 3225026571;

const ERROR_VHD_BITMAP_MISMATCH = 3225026572;

const ERROR_VHD_PARENT_VHD_NOT_FOUND = 3225026573;

const ERROR_VHD_CHILD_PARENT_ID_MISMATCH = 3225026574;

const ERROR_VHD_CHILD_PARENT_TIMESTAMP_MISMATCH = WIN32_ERROR(3225026575);

const ERROR_VHD_METADATA_READ_FAILURE = 3225026576;

const ERROR_VHD_METADATA_WRITE_FAILURE = 3225026577;

const ERROR_VHD_INVALID_SIZE = 3225026578;

const ERROR_VHD_INVALID_FILE_SIZE = 3225026579;

const ERROR_VIRTDISK_PROVIDER_NOT_FOUND = 3225026580;

const ERROR_VIRTDISK_NOT_VIRTUAL_DISK = 3225026581;

const ERROR_VHD_PARENT_VHD_ACCESS_DENIED = 3225026582;

const ERROR_VHD_CHILD_PARENT_SIZE_MISMATCH = 3225026583;

const ERROR_VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED = WIN32_ERROR(3225026584);

const ERROR_VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT = WIN32_ERROR(3225026585);

const ERROR_VIRTUAL_DISK_LIMITATION = 3225026586;

const ERROR_VHD_INVALID_TYPE = 3225026587;

const ERROR_VHD_INVALID_STATE = 3225026588;

const ERROR_VIRTDISK_UNSUPPORTED_DISK_SECTOR_SIZE = WIN32_ERROR(3225026589);

const ERROR_VIRTDISK_DISK_ALREADY_OWNED = 3225026590;

const ERROR_VIRTDISK_DISK_ONLINE_AND_WRITABLE = WIN32_ERROR(3225026591);

const ERROR_CTLOG_TRACKING_NOT_INITIALIZED = 3225026592;

const ERROR_CTLOG_LOGFILE_SIZE_EXCEEDED_MAXSIZE = WIN32_ERROR(3225026593);

const ERROR_CTLOG_VHD_CHANGED_OFFLINE = 3225026594;

const ERROR_CTLOG_INVALID_TRACKING_STATE = 3225026595;

const ERROR_CTLOG_INCONSISTENT_TRACKING_FILE = 3225026596;

const ERROR_VHD_RESIZE_WOULD_TRUNCATE_DATA = 3225026597;

const ERROR_VHD_COULD_NOT_COMPUTE_MINIMUM_VIRTUAL_SIZE = WIN32_ERROR(
  3225026598,
);

const ERROR_VHD_ALREADY_AT_OR_BELOW_MINIMUM_VIRTUAL_SIZE = WIN32_ERROR(
  3225026599,
);

const ERROR_VHD_METADATA_FULL = 3225026600;

const ERROR_VHD_INVALID_CHANGE_TRACKING_ID = 3225026601;

const ERROR_VHD_CHANGE_TRACKING_DISABLED = 3225026602;

const ERROR_VHD_MISSING_CHANGE_TRACKING_INFORMATION = WIN32_ERROR(3225026608);

const ERROR_VHD_UNEXPECTED_ID = 3225026612;

const ERROR_QUERY_STORAGE_ERROR = 2151284737;

const WPF_ASYNCWINDOWPLACEMENT = 4;

const WPF_RESTORETOMAXIMIZED = 2;

const WPF_SETMINPOSITION = 1;

const GWL_HWNDPARENT = WINDOW_LONG_PTR_INDEX(-8);

const MSGFLT_ALLOW = 1;

const MSGFLT_DISALLOW = 2;

const MSGFLT_RESET = 0;

const SD_RECEIVE = 0;

const SD_SEND = 1;

const SD_BOTH = 2;

const wlan_autoconf_opcode_start = 0;

/// The opcode used to set or query the parameter specifying whether user and
/// group policy denied networks will be included in the available networks
/// list.
const wlan_autoconf_opcode_show_denied_networks = WLAN_AUTOCONF_OPCODE(1);

/// The opcode used to query the power settings.
const wlan_autoconf_opcode_power_setting = 2;

/// The opcode used to query whether profiles not created by group policy can
/// be used to connect to an allowed network with a matching group policy
/// profile.
const wlan_autoconf_opcode_only_use_gp_profiles_for_allowed_networks =
    WLAN_AUTOCONF_OPCODE(3);

/// The opcode used to set or query whether the current wireless interface has
/// shared user credentials allowed.
const wlan_autoconf_opcode_allow_explicit_creds = WLAN_AUTOCONF_OPCODE(4);

/// The opcode used to set or query the blocked period setting for the current
/// wireless interface.
const wlan_autoconf_opcode_block_period = 5;

/// The opcode used to set or query whether extensibility on a virtual station
/// is allowed.
const wlan_autoconf_opcode_allow_virtual_station_extensibility =
    WLAN_AUTOCONF_OPCODE(6);

const wlan_autoconf_opcode_end = 7;

/// A profile will be used to make the connection.
const wlan_connection_mode_profile = 0;

/// A temporary profile will be used to make the connection.
const wlan_connection_mode_temporary_profile = 1;

/// Secure discovery will be used to make the connection.
const wlan_connection_mode_discovery_secure = 2;

/// Unsecure discovery will be used to make the connection.
const wlan_connection_mode_discovery_unsecure = WLAN_CONNECTION_MODE(3);

/// The connection is initiated by the wireless service automatically using a
/// persistent profile.
const wlan_connection_mode_auto = 4;

const wlan_connection_mode_invalid = 5;

const WLAN_CONNECTION_NOTIFICATION_ADHOC_NETWORK_FORMED =
    WLAN_CONNECTION_NOTIFICATION_FLAGS(1);

const WLAN_CONNECTION_NOTIFICATION_CONSOLE_USER_PROFILE =
    WLAN_CONNECTION_NOTIFICATION_FLAGS(4);

/// Group policy permit list.
const wlan_filter_list_type_gp_permit = 0;

/// Group policy deny list.
const wlan_filter_list_type_gp_deny = 1;

/// User permit list.
const wlan_filter_list_type_user_permit = 2;

/// User deny list.
const wlan_filter_list_type_user_deny = 3;

/// The opcode used to query or set the wireless Hosted Network connection
/// settings.
const wlan_hosted_network_opcode_connection_settings =
    WLAN_HOSTED_NETWORK_OPCODE(0);

/// The opcode used to query the wireless Hosted Network security settings.
const wlan_hosted_network_opcode_security_settings = WLAN_HOSTED_NETWORK_OPCODE(
  1,
);

/// The opcode used to query the wireless Hosted Network station profile.
const wlan_hosted_network_opcode_station_profile = WLAN_HOSTED_NETWORK_OPCODE(
  2,
);

/// The opcode used to query or set the wireless Hosted Network enabled flag.
const wlan_hosted_network_opcode_enable = WLAN_HOSTED_NETWORK_OPCODE(3);

/// An invalid peer state.
const wlan_hosted_network_peer_state_invalid =
    WLAN_HOSTED_NETWORK_PEER_AUTH_STATE(0);

/// The peer is authenticated.
const wlan_hosted_network_peer_state_authenticated =
    WLAN_HOSTED_NETWORK_PEER_AUTH_STATE(1);

/// The operation was successful.
const wlan_hosted_network_reason_success = WLAN_HOSTED_NETWORK_REASON(0);

/// Unknown error.
const wlan_hosted_network_reason_unspecified = WLAN_HOSTED_NETWORK_REASON(1);

/// Bad parameters.
const wlan_hosted_network_reason_bad_parameters = WLAN_HOSTED_NETWORK_REASON(2);

/// Service is shutting down.
const wlan_hosted_network_reason_service_shutting_down =
    WLAN_HOSTED_NETWORK_REASON(3);

/// Service is out of resources.
const wlan_hosted_network_reason_insufficient_resources =
    WLAN_HOSTED_NETWORK_REASON(4);

/// This operation requires elevation.
const wlan_hosted_network_reason_elevation_required =
    WLAN_HOSTED_NETWORK_REASON(5);

/// An attempt was made to write read-only data.
const wlan_hosted_network_reason_read_only = WLAN_HOSTED_NETWORK_REASON(6);

/// Data persistence failed.
const wlan_hosted_network_reason_persistence_failed =
    WLAN_HOSTED_NETWORK_REASON(7);

/// A cryptographic error occurred.
const wlan_hosted_network_reason_crypt_error = WLAN_HOSTED_NETWORK_REASON(8);

/// User impersonation failed.
const wlan_hosted_network_reason_impersonation = WLAN_HOSTED_NETWORK_REASON(9);

/// An incorrect function call sequence was made.
const wlan_hosted_network_reason_stop_before_start = WLAN_HOSTED_NETWORK_REASON(
  10,
);

/// A wireless interface has become available.
const wlan_hosted_network_reason_interface_available =
    WLAN_HOSTED_NETWORK_REASON(11);

/// A wireless interface has become unavailable.
const wlan_hosted_network_reason_interface_unavailable =
    WLAN_HOSTED_NETWORK_REASON(12);

/// The wireless miniport driver stopped the Hosted Network.
const wlan_hosted_network_reason_miniport_stopped = WLAN_HOSTED_NETWORK_REASON(
  13,
);

/// The wireless miniport driver status changed.
const wlan_hosted_network_reason_miniport_started = WLAN_HOSTED_NETWORK_REASON(
  14,
);

/// An incompatible connection started.
const wlan_hosted_network_reason_incompatible_connection_started =
    WLAN_HOSTED_NETWORK_REASON(15);

/// An incompatible connection stopped.
const wlan_hosted_network_reason_incompatible_connection_stopped =
    WLAN_HOSTED_NETWORK_REASON(16);

/// A state change occurred that was caused by explicit user action.
const wlan_hosted_network_reason_user_action = WLAN_HOSTED_NETWORK_REASON(17);

/// A state change occurred that was caused by client abort.
const wlan_hosted_network_reason_client_abort = WLAN_HOSTED_NETWORK_REASON(18);

/// The driver for the wireless Hosted Network failed to start.
const wlan_hosted_network_reason_ap_start_failed = WLAN_HOSTED_NETWORK_REASON(
  19,
);

/// A peer connected to the wireless Hosted Network.
const wlan_hosted_network_reason_peer_arrived = WLAN_HOSTED_NETWORK_REASON(20);

/// A peer disconnected from the wireless Hosted Network.
const wlan_hosted_network_reason_peer_departed = WLAN_HOSTED_NETWORK_REASON(21);

/// A peer timed out.
const wlan_hosted_network_reason_peer_timeout = WLAN_HOSTED_NETWORK_REASON(22);

/// The operation was denied by group policy.
const wlan_hosted_network_reason_gp_denied = WLAN_HOSTED_NETWORK_REASON(23);

/// The Wireless LAN service is not running.
const wlan_hosted_network_reason_service_unavailable =
    WLAN_HOSTED_NETWORK_REASON(24);

/// The wireless adapter used by the wireless Hosted Network changed.
const wlan_hosted_network_reason_device_change = WLAN_HOSTED_NETWORK_REASON(25);

/// The properties of the wireless Hosted Network changed.
const wlan_hosted_network_reason_properties_change = WLAN_HOSTED_NETWORK_REASON(
  26,
);

/// A virtual station is active and blocking operation.
const wlan_hosted_network_reason_virtual_station_blocking_use =
    WLAN_HOSTED_NETWORK_REASON(27);

/// An identical service is available on a virtual station.
const wlan_hosted_network_reason_service_available_on_virtual_station =
    WLAN_HOSTED_NETWORK_REASON(28);

/// The wireless Hosted Network is unavailable.
const wlan_hosted_network_unavailable = 0;

/// The wireless Hosted Network is idle.
const wlan_hosted_network_idle = 1;

/// The wireless Hosted Network is active.
const wlan_hosted_network_active = 2;

/// Bypasses a WLAN service.
const wlan_ihv_control_type_service = 0;

/// Bypasses a WLAN driver.
const wlan_ihv_control_type_driver = 1;

/// The interface is not ready to operate.
const wlan_interface_state_not_ready = 0;

/// The interface is connected to a network.
const wlan_interface_state_connected = 1;

/// The interface is the first node in an ad hoc network.
const wlan_interface_state_ad_hoc_network_formed = WLAN_INTERFACE_STATE(2);

/// The interface is disconnecting from the current network.
const wlan_interface_state_disconnecting = 3;

/// The interface is not connected to any network.
const wlan_interface_state_disconnected = 4;

/// The interface is attempting to associate with a network.
const wlan_interface_state_associating = 5;

/// Auto configuration is discovering the settings for the network.
const wlan_interface_state_discovering = 6;

/// The interface is in the process of authenticating.
const wlan_interface_state_authenticating = 7;

/// Specifies an emulated 802.11 interface.
const wlan_interface_type_emulated_802_11 = 0;

/// Specifies a native 802.11 interface.
const wlan_interface_type_native_802_11 = 1;

/// The interface specified is invalid.
const wlan_interface_type_invalid = 2;

const wlan_intf_opcode_autoconf_start = 0;

/// The opcode used to set or query whether auto config is enabled.
const wlan_intf_opcode_autoconf_enabled = 1;

/// The opcode used to set or query whether background scan is enabled.
const wlan_intf_opcode_background_scan_enabled = 2;

/// The opcode used to set or query the media streaming mode of the driver.
const wlan_intf_opcode_media_streaming_mode = 3;

/// The opcode used to set or query the radio state.
const wlan_intf_opcode_radio_state = 4;

/// The opcode used to set or query the BSS type of the interface.
const wlan_intf_opcode_bss_type = 5;

/// The opcode used to query the state of the interface.
const wlan_intf_opcode_interface_state = 6;

/// The opcode used to query information about the current connection of the
/// interface.
const wlan_intf_opcode_current_connection = 7;

/// The opcode used to query the current channel on which the wireless
/// interface is operating.
const wlan_intf_opcode_channel_number = 8;

/// The opcode used to query the supported auth/cipher pairs for
/// infrastructure mode.
const wlan_intf_opcode_supported_infrastructure_auth_cipher_pairs =
    WLAN_INTF_OPCODE(9);

/// The opcode used to query the supported auth/cipher pairs for ad hoc mode.
const wlan_intf_opcode_supported_adhoc_auth_cipher_pairs = WLAN_INTF_OPCODE(10);

/// The opcode used to query the list of supported country or region strings.
const wlan_intf_opcode_supported_country_or_region_string_list =
    WLAN_INTF_OPCODE(11);

/// The opcode used to set or query the current operation mode of the wireless
/// interface.
const wlan_intf_opcode_current_operation_mode = 12;

/// The opcode used to query whether the miniport/NIC combination supports
/// Federal Information Processing Standards (FIPS) mode.
const wlan_intf_opcode_supported_safe_mode = 13;

/// The opcode used to query whether the miniport/NIC combination is FIPS
/// certified.
const wlan_intf_opcode_certified_safe_mode = 14;

/// The opcode used to query for Hosted Network support in the device driver
/// associated with the Wireless interface.
const wlan_intf_opcode_hosted_network_capable = 15;

/// The opcode used to query whether Management Frame Protection (MFP) is
/// supported in the device driver associated with the Wireless interface.
const wlan_intf_opcode_management_frame_protection_capable = WLAN_INTF_OPCODE(
  16,
);

const wlan_intf_opcode_secondary_sta_interfaces = 17;

const wlan_intf_opcode_secondary_sta_synchronized_connections =
    WLAN_INTF_OPCODE(18);

const wlan_intf_opcode_autoconf_end = 268435455;

const wlan_intf_opcode_msm_start = 268435712;

/// The opcode used to query driver statistics.
const wlan_intf_opcode_statistics = 268435713;

/// Opcode used to query the received signal strength.
const wlan_intf_opcode_rssi = 268435714;

const wlan_intf_opcode_msm_end = 536870911;

const wlan_intf_opcode_security_start = 536936448;

const wlan_intf_opcode_security_end = 805306367;

const wlan_intf_opcode_ihv_start = 805306368;

const wlan_intf_opcode_ihv_end = 1073741823;

const WLAN_NOTIFICATION_SOURCE_NONE = 0;

const WLAN_NOTIFICATION_SOURCE_ALL = 65535;

const WLAN_NOTIFICATION_SOURCE_ACM = 8;

const WLAN_NOTIFICATION_SOURCE_MSM = 16;

const WLAN_NOTIFICATION_SOURCE_SECURITY = WLAN_NOTIFICATION_SOURCES(32);

const WLAN_NOTIFICATION_SOURCE_IHV = 64;

const WLAN_NOTIFICATION_SOURCE_HNWK = 128;

const WLAN_NOTIFICATION_SOURCE_ONEX = 4;

const WLAN_NOTIFICATION_SOURCE_DEVICE_SERVICE = WLAN_NOTIFICATION_SOURCES(2048);

/// The auto config settings were queried, but the origin of the settings was
/// not determined.
const wlan_opcode_value_type_query_only = 0;

/// The auto config settings were set by group policy.
const wlan_opcode_value_type_set_by_group_policy = WLAN_OPCODE_VALUE_TYPE(1);

/// The auto config settings were set by the user.
const wlan_opcode_value_type_set_by_user = 2;

/// The auto config settings are invalid.
const wlan_opcode_value_type_invalid = 3;

/// The permissions for modifying the permit list for user profiles.
const wlan_secure_permit_list = 0;

/// The permissions for modifying the deny list for user profiles.
const wlan_secure_deny_list = 1;

/// The permissions for enabling the auto config service.
const wlan_secure_ac_enabled = 2;

/// The permissions for enabling background scans.
const wlan_secure_bc_scan_enabled = 3;

/// The permissions for altering the basic service set type.
const wlan_secure_bss_type = 4;

/// The permissions for modifying whether networks on the deny list appear in
/// the available networks list.
const wlan_secure_show_denied = 5;

/// The permissions for changing interface properties.
const wlan_secure_interface_properties = 6;

/// The permissions for using the <a
/// href="https://docs.microsoft.com/windows/desktop/api/wlanapi/nf-wlanapi-wlanihvcontrol">WlanIhvControl</a>
/// function for independent hardware vendor (IHV) control of WLAN drivers or
/// services.
const wlan_secure_ihv_control = 7;

/// The permissions for modifying the order of all-user profiles.
const wlan_secure_all_user_profiles_order = 8;

/// The permissions for adding new all-user profiles.
const wlan_secure_add_new_all_user_profiles = 9;

/// The permissions for adding new per-user profiles.
const wlan_secure_add_new_per_user_profiles = WLAN_SECURABLE_OBJECT(10);

/// The permissions for setting or querying the media streaming mode.
const wlan_secure_media_streaming_mode_enabled = WLAN_SECURABLE_OBJECT(11);

/// The permissions for setting or querying the operation mode of the wireless
/// interface.
const wlan_secure_current_operation_mode = 12;

/// The permissions for retrieving the plain text key from a wireless profile.
const wlan_secure_get_plaintext_key = 13;

/// The permissions that have elevated access to call the privileged Hosted
/// Network functions.
const wlan_secure_hosted_network_elevated_access = WLAN_SECURABLE_OBJECT(14);

const wlan_secure_virtual_station_extensibility = WLAN_SECURABLE_OBJECT(15);

/// This value is reserved for internal use by the Wi-Fi Direct service.
const wlan_secure_wfd_elevated_access = 16;

const WLAN_SECURABLE_OBJECT_COUNT = 17;

const WLAN_SET_EAPHOST_DATA_ALL_USERS = 1;

const XINPUT_FLAG_ALL = 0;

/// No increase or decrease in zoom.
const ZoomUnit_NoAmount = 0;

/// Decrease zoom by a large decrement.
const ZoomUnit_LargeDecrement = 1;

/// Decrease zoom by a small decrement.
const ZoomUnit_SmallDecrement = 2;

/// Increase zoom by a large increment.
const ZoomUnit_LargeIncrement = 3;

/// Increase zoom by a small increment.
const ZoomUnit_SmallIncrement = 4;
