import 'dart:async';

import 'package:drift/drift.dart';
import 'package:fit_book/database/database.dart';
import 'package:fit_book/main.dart';
import 'package:flutter/material.dart';

class SettingsState extends ChangeNotifier {
  late Setting value;
  late StreamSubscription subscription;

  bool get compactDiary => value.compactDiary;

  SettingsState(Setting settings) {
    value = settings;
    setSubscription();
  }

  void setSubscription() {
    subscription =
        (db.settings.select()..limit(1)).watchSingle().listen((event) {
      value = event;
      notifyListeners();
    });
  }

  void setValue(Setting newValue) {
    value = newValue;
    notifyListeners();
  }

  @override
  void dispose() {
    subscription.cancel();
    super.dispose();
  }
}
