import 'package:drift/drift.dart';
import 'package:fit_book/database/database.dart';
import 'package:flutter/material.dart';

enum AppMetric {
  calories,
  protein,
  bodyWeight,
  fat,
  carbs,
}

enum Period {
  day,
  week,
  month,
  year,
}

enum DiarySummary { remaining, division, both, none }

const excludedFields = [
  'id',
  'created',
  'favorite',
  'name',
  'calories',
  'serving_unit',
  'image_file',
  'barcode',
  'serving_size',
];

List<String> unitOptions = [
  'serving',
  'grams',
  'milliliters',
  'kilojoules',
  'cups',
  'tablespoons',
  'milligrams',
  'teaspoons',
  'ounces',
  'pounds',
  'kilograms',
  'liters',
];

List<String> foodFields = [
  'id',
  'name',
  'foodGroup',
  'calories',
  'fatG',
  'proteinG',
  'carbohydrateG',
  'sugarsG',
  'fiberG',
  'cholesterolMg',
  'saturatedFatsG',
  'calciumMg',
  'ironFeMg',
  'potassiumKMg',
  'magnesiumMg',
  'vitaminAIuIu',
  'vitaminARaeMcg',
  'vitaminCMg',
  'vitamin_b_12_mcg',
  'vitaminDMcg',
  'vitaminEAlphaTocopherolMg',
  'addedSugarG',
  'netCarbsG',
  'waterG',
  'omega_3s_mg',
  'omega_6s_mg',
  'pralScore',
  'transFattyAcidsG',
  'solubleFiberG',
  'insolubleFiberG',
  'sucroseG',
  'glucoseDextroseG',
  'fructoseG',
  'lactoseG',
  'maltoseG',
  'galactoseG',
  'starchG',
  'totalSugarAlcoholsG',
  'phosphorusPMg',
  'sodiumMg',
  'zincZnMg',
  'copperCuMg',
  'manganeseMg',
  'seleniumSeMcg',
  'fluorideFMcg',
  'molybdenumMcg',
  'chlorineMg',
  'thiaminB1Mg',
  'riboflavinB2Mg',
  'niacinB3Mg',
  'pantothenic_acid_b5_mg',
  'vitaminB6Mg',
  'biotinB7Mcg',
  'folateB9Mcg',
  'folicAcidMcg',
  'foodFolateMcg',
  'folateDfeMcg',
  'cholineMg',
  'betaineMg',
  'retinolMcg',
  'caroteneBetaMcg',
  'caroteneAlphaMcg',
  'lycopeneMcg',
  'luteinZeaxanthinMcg',
  'vitaminD2ErgocalciferolMcg',
  'vitaminD3CholecalciferolMcg',
  'vitaminDIuIu',
  'vitaminKMcg',
  'dihydrophylloquinoneMcg',
  'menaquinone_4_mcg',
  'fattyAcidsTotalMonounsaturatedMg',
  'fattyAcidsTotalPolyunsaturatedMg',
  '_18_3_n_3_c_c_c_ala_mg',
  '_20_5_n_3_epa_mg',
  '_22_5_n_3_dpa_mg',
  '_22_6_n_3_dha_mg',
  'tryptophanMg',
  'threonineMg',
  'isoleucineMg',
  'leucineMg',
  'lysineMg',
  'methionineMg',
  'cystineMg',
  'phenylalanineMg',
  'tyrosineMg',
  'valineMg',
  'arginineMg',
  'histidineMg',
  'alanineMg',
  'asparticAcidMg',
  'glutamicAcidMg',
  'glycineMg',
  'prolineMg',
  'serineMg',
  'hydroxyprolineMg',
  'alcoholG',
  'caffeineMg',
  'theobromineMg',
  'serving_weight_1_g',
  'serving_description_1_g',
  'serving_weight_2_g',
  'serving_description_2_g',
  'serving_weight_3_g',
  'serving_description_3_g',
  'serving_weight_4_g',
  'serving_description_4_g',
  'serving_weight_5_g',
  'serving_description_5_g',
  'serving_weight_6_g',
  'serving_description_6_g',
  'serving_weight_7_g',
  'serving_description_7_g',
  'serving_weight_8_g',
  'serving_description_8_g',
  'serving_weight_9_g',
  'serving_description_9_g',
  '_200_calorie_weight_g',
  'favorite',
  'servingUnit',
  'servingSize',
  'created',
];

List<String> positiveReinforcements = [
  'Great job! Your hard work is paying off.',
  'Keep it up! You are making excellent progress.',
  'Fantastic! Your dedication is showing results.',
  'Well done! You are one step closer to your goal.',
  'Impressive! Your efforts are bearing fruit.',
  'Amazing! You are on the right track.',
  'Bravo! Your commitment is commendable.',
  'Excellent! Your perseverance is inspiring.',
  'Superb! You are doing an outstanding job.',
  'Incredible! Your progress is noticeable.',
  'Way to go King',
  'Yeah buddy!',
  "That's how it's done.",
  "Easy as pie.",
  "You are doing great.",
  "Is that progress I see? Nice.",
];

final defaultSettings = SettingsCompanion.insert(
  longDateFormat: "dd/MM/yy",
  shortDateFormat: 'd/M/yy',
  entryUnit: 'serving',
  foodUnit: 'grams',
  themeMode: ThemeMode.system.toString(),
  diarySummary: DiarySummary.division.toString(),
  favoriteNew: false,
  positiveReinforcement: const Value(false),
  reminders: const Value(false),
  selectEntryOnSubmit: false,
  showOthers: false,
  systemColors: false,
  showImages: const Value(true),
);
