<div align="center">

![ic_launcher](https://github.com/prajwalch/TorrentSearch/blob/main/fastlane/metadata/android/en-US/images/icon.png)

[![Latest release](https://img.shields.io/github/v/release/prajwalch/TorrentSearch?style=for-the-badge)](https://github.com/prajwalch/TorrentSearch/releases)
[![F-Droid Version](https://img.shields.io/f-droid/v/com.prajwalch.torrentsearch?style=for-the-badge&color=blue)](https://f-droid.org/packages/com.prajwalch.torrentsearch)
[![IzzyOnDroid version](https://img.shields.io/endpoint?style=for-the-badge&url=https://apt.izzysoft.de/fdroid/api/v1/shield/com.prajwalch.torrentsearch)](https://apt.izzysoft.de/fdroid/index/apk/com.prajwalch.torrentsearch)
[![Downloads](https://img.shields.io/github/downloads/prajwalch/TorrentSearch/total?style=for-the-badge)](https://github.com/prajwalch/TorrentSearch/releases)
[![Translation status](https://img.shields.io/weblate/progress/torrentsearch?style=for-the-badge)](https://hosted.weblate.org/engage/torrentsearch/)

# Torrent Search

A modern Material 3 designed Android app for searching and downloading torrents from multiple
providers.

<br>
<img width="20%" src="https://github.com/prajwalch/TorrentSearch/blob/main/fastlane/metadata/android/en-US/images/phoneScreenshots/screenshot_1.jpg" alt="search results for all category">
<img width="20%" src="https://github.com/prajwalch/TorrentSearch/blob/main/fastlane/metadata/android/en-US/images/phoneScreenshots/screenshot_2.jpg" alt="search bar">  	
<img width="20%" src="https://github.com/prajwalch/TorrentSearch/blob/main/fastlane/metadata/android/en-US/images/phoneScreenshots/screenshot_3.jpg" alt="torrent actions">  	
<img width="20%" src="https://github.com/prajwalch/TorrentSearch/blob/main/fastlane/metadata/android/en-US/images/phoneScreenshots/screenshot_4.jpg" alt="torrent client not found dialog">  	
<br/>
<img width="20%" src="https://github.com/prajwalch/TorrentSearch/blob/main/fastlane/metadata/android/en-US/images/phoneScreenshots/screenshot_5.jpg" alt="bookmarks screen">
<img width="20%" src="https://github.com/prajwalch/TorrentSearch/blob/main/fastlane/metadata/android/en-US/images/phoneScreenshots/screenshot_6.jpg" alt="settings screen">  	
<img width="20%" src="https://github.com/prajwalch/TorrentSearch/blob/main/fastlane/metadata/android/en-US/images/phoneScreenshots/screenshot_7.jpg" alt="search providers setting">  	
<img width="20%" src="https://github.com/prajwalch/TorrentSearch/blob/main/fastlane/metadata/android/en-US/images/phoneScreenshots/screenshot_8.jpg" alt="dark theme setting">  	
</div>

## Features

- Modern Material 3 design UI
    - A clean, smooth, and responsive user interface, adapting to your device's wallpaper and theme
      settings.
- Different category selections
- Detailed view of search results:
    - Provider name
    - Upload date
    - Category
    - NSFW tag
    - File size
    - Seeders/Peers
- Various torrent actions:
    - Bookmark
    - Download (requires an external torrent client)
        - If not found, shows a friendly dialog with different FOSS torrent clients to choose from.
    - Copy/share magnet link
    - Open torrent description page
    - Copy/share torrent description page URL
- Safe mode option:
    - Automatically disables Unsafe and NSFW search providers
    - Automatically hides NSFW categories
    - Automatically hides NSFW torrents
- Option to enable or disable individual providers
- [Jackett](https://github.com/Jackett/Jackett)/[Prowlarr](https://github.com/Prowlarr/Prowlarr)/other *arr service integration support using [Torznab API](https://torznab.github.io/spec-1.3-draft/torznab/Specification-v1.3.html#torznab-api-specification)
  - Read [wiki](https://github.com/prajwalch/TorrentSearch/wiki) to learn more

## Download

[<img src="https://f-droid.org/badge/get-it-on.png" alt="Get it on F-Droid" height="80">](https://f-droid.org/packages/com.prajwalch.torrentsearch)
<br />
[<img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png" height="80" alt="Get it on IzzyOnDroid">](https://apt.izzysoft.de/fdroid/index/apk/com.prajwalch.torrentsearch)
<br />
[<img src="https://github.com/machiav3lli/oandbackupx/blob/034b226cea5c1b30eb4f6a6f313e4dadcbb0ece4/badge_github.png" alt="Get it on GitHub" height="80">](https://github.com/prajwalch/TorrentSearch/releases/latest/)
<br />
[<img src="https://github.com/ImranR98/Obtainium/blob/main/assets/graphics/badge_obtainium.png" alt="Get it on Obtainium" height="55">](https://apps.obtainium.imranr.dev/redirect?r=obtainium://add/https://github.com/prajwalch/TorrentSearch/)


The Nightly versions are also available under the artifact section of workflow run (You may require
to logging in to Github). These are created for
each commit/push done to the repository and can be used by anyone to test new features. Please note
that Nightly builds can contain bugs and may not work properly.

## Translations

**Hello and thank you for your interest** — TorrentSearch is being translated using Weblate. For more details or to get started, visit our [Weblate page](https://hosted.weblate.org/projects/torrentsearch/).

[![Translation status](https://hosted.weblate.org/widget/torrentsearch/multi-auto.svg)](https://hosted.weblate.org/engage/torrentsearch/)

## Thanks

- [IconKitchen](https://icon.kitchen/) for a platform to create an icon.

## Disclaimer

This app **does not host, store, or distribute any torrent files or copyrighted content**; it only
searches publicly available content from third-party sources.
The developer **is not responsible** for how users access or use this information.

Use at your own risk and ensure compliance with applicable laws.
