package com.prajwalch.torrentsearch.data.repository

import com.prajwalch.torrentsearch.data.database.dao.SearchHistoryDao
import com.prajwalch.torrentsearch.data.database.entities.SearchHistory

import kotlinx.coroutines.flow.Flow
import javax.inject.Inject

class SearchHistoryRepository @Inject constructor(private val dao: SearchHistoryDao) {
    /**
     * Adds the given search history otherwise does noting if the query
     * is already saved.
     */
    suspend fun add(searchHistory: SearchHistory) {
        dao.insert(searchHistory)
    }

    /** Returns all the saved search history. */
    fun getAll(): Flow<List<SearchHistory>> {
        return dao.getAll()
    }

    /** Removes the given search history. */
    suspend fun remove(searchHistory: SearchHistory) {
        dao.delete(searchHistory)
    }

    /** Clears all search history. */
    suspend fun clearAll() {
        dao.clearAll()
    }
}