"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_COMBINE_SEGMENTS_LENGTH = exports.TranscriptFormat = exports.PATTERN_LINE_SEPARATOR = void 0;
/**
 * Regular expression to detect both `\r\n` and `\n` line endings
 */
exports.PATTERN_LINE_SEPARATOR = /\r?\n/;
/**
 * Enum of all supported transcript formats
 */
var TranscriptFormat;
(function (TranscriptFormat) {
    /**
     * Data is HTML
     */
    TranscriptFormat["HTML"] = "html";
    /**
     * Data is JSON
     */
    TranscriptFormat["JSON"] = "json";
    /**
     * Data is {@link https://en.wikipedia.org/wiki/SubRip|SRT}
     */
    TranscriptFormat["SRT"] = "srt";
    /**
     * Data is {@link https://en.wikipedia.org/wiki/WebVTT|WebVTT}
     */
    TranscriptFormat["VTT"] = "vtt";
})(TranscriptFormat = exports.TranscriptFormat || (exports.TranscriptFormat = {}));
/**
 * Default length to use when combining segments with {@link Options.combineSegments}
 */
exports.DEFAULT_COMBINE_SEGMENTS_LENGTH = 32;
