"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseVTT = exports.isVTT = void 0;
const srt_1 = require("./srt");
/**
 * Required header for WebVTT/VTT files
 */
const WEBVTT_HEADER = "WEBVTT";
/**
 * Determines if the value of data is a valid VTT transcript format
 *
 * @param data The transcript data
 * @returns True: data is valid VTT transcript format
 */
const isVTT = (data) => {
    return data.startsWith("WEBVTT");
};
exports.isVTT = isVTT;
/**
 * Parse VTT data to an Array of {@link Segment}
 *
 * @param data The transcript data
 * @returns An array of Segments from the parsed data
 * @throws {TypeError} When `data` is not valid VTT format
 */
const parseVTT = (data) => {
    if (!(0, exports.isVTT)(data)) {
        throw new TypeError(`Data is not valid VTT format`);
    }
    // format is similar enough to SRT to be parsed by the same parser
    // Remove WEBVTT header first
    return (0, srt_1.parseSRT)(data.substring(WEBVTT_HEADER.length).trimStart());
};
exports.parseVTT = parseVTT;
