import { Segment } from "../types";
/**
 * Determines if the value of data is a valid VTT transcript format
 *
 * @param data The transcript data
 * @returns True: data is valid VTT transcript format
 */
export declare const isVTT: (data: string) => boolean;
/**
 * Parse VTT data to an Array of {@link Segment}
 *
 * @param data The transcript data
 * @returns An array of Segments from the parsed data
 * @throws {TypeError} When `data` is not valid VTT format
 */
export declare const parseVTT: (data: string) => Array<Segment>;
