import { Segment } from "../types";
/**
 * Define a segment/cue parsed from SRT file
 */
export type SRTSegment = {
    /**
     * Cue number
     */
    index: number;
    /**
     * Time (in seconds) when segment starts
     */
    startTime: number;
    /**
     * Time (in seconds) when segment ends
     */
    endTime: number;
    /**
     * Name of speaker for `body`
     */
    speaker: string;
    /**
     * Text of transcript for segment
     */
    body: string;
};
/**
 * Parse lines looking for data to be SRT format
 *
 * @param lines Lines containing SRT data
 * @returns Parsed segment
 * @throws {Error} When no non-empty strings in `lines`
 * @throws {Error} When the minimum required number of lines is not received
 * @throws {Error} When segment lines does not start with a number
 * @throws {Error} When second segment line does not follow the timestamp format
 */
export declare const parseSRTSegment: (lines: Array<string>) => SRTSegment;
/**
 * Determines if the value of data is a valid SRT transcript format
 *
 * @param data The transcript data
 * @returns True: data is valid SRT transcript format
 */
export declare const isSRT: (data: string) => boolean;
/**
 * Parse SRT data to an Array of {@link Segment}
 *
 * @param data The transcript data
 * @returns An array of Segments from the parsed data
 * @throws {TypeError} When `data` is not valid SRT format
 */
export declare const parseSRT: (data: string) => Array<Segment>;
