import { Segment } from "../types";
/**
 * Define a segment/cue used in the JSONTranscript format
 */
export type JSONSegment = {
    /**
     * Time (in seconds) when segment starts
     */
    startTime: number;
    /**
     * Time (in seconds) when segment ends
     */
    endTime: number;
    /**
     * Name of speaker for `body`
     */
    speaker?: string;
    /**
     * Text of transcript for segment
     */
    body: string;
};
/**
 * Define the JSON transcript format
 */
export type JSONTranscript = {
    /**
     * Version of file format
     */
    version: string;
    /**
     * Segment data
     */
    segments: Array<JSONSegment>;
};
/**
 * Define the JSON transcript Segment format
 */
export type SubtitleSegment = {
    /**
     * Time (in milliseconds) when segment starts
     */
    start: number;
    /**
     * Time (in milliseconds) when segment ends
     */
    end: number;
    /**
     * Text of transcript for segment
     */
    text: string;
};
/**
 * Determines if the value of data is a valid JSON transcript format
 *
 * @param data The transcript data
 * @returns True: data is valid JSON transcript format
 */
export declare const isJSON: (data: string) => boolean;
/**
 * Parse JSON data to an Array of {@link Segment}
 *
 * @param data The transcript data
 * @returns An array of Segments from the parsed data
 * @throws {TypeError} When `data` is not valid JSON format
 */
export declare const parseJSON: (data: string) => Array<Segment>;
