"use strict";

var _classProps = function (child, staticProps, instanceProps) {
  if (staticProps) Object.defineProperties(child, staticProps);
  if (instanceProps) Object.defineProperties(child.prototype, instanceProps);
};

var upperBound = require('boundary').upperBound;
var Position = function Position(line, column) {
  this.line = line;
  this.column = column;
};

exports.Position = Position;
var SourceLocation = function SourceLocation(start, end) {
  this.start = start;
  this.end = end;
};

exports.SourceLocation = SourceLocation;
var StructuredSource = (function () {
  var StructuredSource =
  /**
   * @constructs StructuredSource
   * @param {string} source - source code text.
   */
  function StructuredSource(source) {
    this.indice = [0];
    var regexp = /[\r\n\u2028\u2029]/g;
    var length = source.length;
    regexp.lastIndex = 0;
    while (true) {
      var result = regexp.exec(source);
      if (!result) {
        break;
      }
      var index = result.index;
      if (source.charCodeAt(index) === 13 /* '\r' */ && source.charCodeAt(index + 1) === 10 /* '\n' */) {
        index += 1;
      }
      var nextIndex = index + 1;
      // If there's a last line terminator, we push it to the indice.
      // So use < instead of <=.
      if (length < nextIndex) {
        break;
      }
      this.indice.push(nextIndex);
      regexp.lastIndex = nextIndex;
    }
  };

  StructuredSource.prototype.locationToRange = function (loc) {
    return [this.positionToIndex(loc.start), this.positionToIndex(loc.end)];
  };

  StructuredSource.prototype.rangeToLocation = function (range) {
    return new SourceLocation(this.indexToPosition(range[0]), this.indexToPosition(range[1]));
  };

  StructuredSource.prototype.positionToIndex = function (pos) {
    // Line number starts with 1.
    // Column number starts with 0.
    var start = this.indice[pos.line - 1];
    return start + pos.column;
  };

  StructuredSource.prototype.indexToPosition = function (index) {
    var startLine = upperBound(this.indice, index);
    return new Position(startLine, index - this.indice[startLine - 1]);
  };

  _classProps(StructuredSource, null, {
    line: {
      get: function () {
        return this.indice.length;
      }
    }
  });

  return StructuredSource;
})();

exports["default"] = StructuredSource;
//# sourceMappingURL=data:application/json;base64,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