import * as React from 'react';
import { Animated, View, StyleSheet } from 'react-native';
import { NavigationContext } from 'react-navigation';
import Header from './Header';
import { forSlideLeft, forSlideUp, forNoAnimation, forSlideRight } from '../../TransitionConfigs/HeaderStyleInterpolators';
import PreviousSceneContext from '../../utils/PreviousSceneContext';
export default function HeaderContainer({
  mode,
  scenes,
  layout,
  insets,
  getPreviousScene,
  getFocusedRoute,
  onContentHeightChange,
  gestureDirection,
  styleInterpolator,
  style
}) {
  const focusedRoute = getFocusedRoute();
  const parentPreviousScene = React.useContext(PreviousSceneContext);
  return /*#__PURE__*/React.createElement(Animated.View, {
    pointerEvents: "box-none",
    style: style
  }, scenes.slice(-3).map((scene, i, self) => {
    var _getPreviousScene;

    if (mode === 'screen' && i !== self.length - 1 || !scene) {
      return null;
    }

    const {
      header,
      headerShown = true,
      headerTransparent
    } = scene.descriptor.options || {};

    if (!headerShown) {
      return null;
    }

    const isFocused = focusedRoute.key === scene.route.key;
    const previous = (_getPreviousScene = getPreviousScene({
      route: scene.route
    })) !== null && _getPreviousScene !== void 0 ? _getPreviousScene : parentPreviousScene; // If the screen is next to a headerless screen, we need to make the header appear static
    // This makes the header look like it's moving with the screen

    const previousScene = self[i - 1];
    const nextScene = self[i + 1];
    const {
      headerShown: previousHeaderShown = true
    } = (previousScene === null || previousScene === void 0 ? void 0 : previousScene.descriptor.options) || {};
    const {
      headerShown: nextHeaderShown = true
    } = (nextScene === null || nextScene === void 0 ? void 0 : nextScene.descriptor.options) || {};
    const isHeaderStatic = previousHeaderShown === false && // We still need to animate when coming back from next scene
    // A hacky way to check this is if the next scene exists
    !nextScene || nextHeaderShown === false;
    const props = {
      mode,
      layout,
      insets,
      scene,
      previous,
      navigation: scene.descriptor.navigation,
      styleInterpolator: mode === 'float' ? isHeaderStatic ? gestureDirection === 'vertical' || gestureDirection === 'vertical-inverted' ? forSlideUp : gestureDirection === 'horizontal-inverted' ? forSlideRight : forSlideLeft : styleInterpolator : forNoAnimation
    };
    return /*#__PURE__*/React.createElement(NavigationContext.Provider, {
      key: scene.route.key,
      value: scene.descriptor.navigation
    }, /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(View, {
      onLayout: onContentHeightChange ? e => {
        const {
          height
        } = e.nativeEvent.layout;
        onContentHeightChange({
          route: scene.route,
          height
        });
      } : undefined,
      pointerEvents: isFocused ? 'box-none' : 'none',
      accessibilityElementsHidden: !isFocused,
      importantForAccessibility: isFocused ? 'auto' : 'no-hide-descendants',
      style: // Avoid positioning the focused header absolutely
      // Otherwise accessibility tools don't seem to be able to find it
      mode === 'float' && !isFocused || headerTransparent ? styles.header : null
    }, header !== undefined ? header(props) : /*#__PURE__*/React.createElement(Header, props))));
  }));
}
const styles = StyleSheet.create({
  header: {
    position: 'absolute',
    top: 0,
    left: 0,
    right: 0
  }
});
//# sourceMappingURL=HeaderContainer.js.map