---
sidebar_position: 7
---

# iOS Category Mode (ios-only)

All iOS Category Mode types are made available through the named export `IOSCategoryMode`:

## `Default`

The default audio session mode.

[See the Apple Docs](https://developer.apple.com/documentation/avfaudio/avaudiosession/mode/1616579-default)

## `GameChat`

A mode that the GameKit framework sets on behalf of an application that
uses GameKit’s voice chat service.

[See the Apple Docs](https://developer.apple.com/documentation/avfaudio/avaudiosession/mode/1616511-gamechat)


## `Measurement`

A mode that indicates that your app is performing measurement of audio
input or output.

[See the Apple Docs](https://developer.apple.com/documentation/avfaudio/avaudiosession/mode/1616608-measurement)

## `MoviePlayback`

A mode that indicates that your app is playing back movie content.

[See the Apple Docs](https://developer.apple.com/documentation/avfaudio/avaudiosession/mode/1616623-movieplayback)

## `SpokenAudio`

A mode used for continuous spoken audio to pause the audio when another
app plays a short audio prompt.

[See the Apple Docs](https://developer.apple.com/documentation/avfaudio/avaudiosession/mode/1616510-spokenaudio)

## `VideoChat`

A mode that indicates that your app is engaging in online video conferencing.

[See the Apple Docs](https://developer.apple.com/documentation/avfaudio/avaudiosession/mode/1616590-videochat)

## `VideoRecording`

A mode that indicates that your app is recording a movie.

[See the Apple Docs](https://developer.apple.com/documentation/avfaudio/avaudiosession/mode/1616535-videorecording)

## `VoiceChat`

A mode that indicates that your app is performing two-way voice communication,
such as using Voice over Internet Protocol (VoIP).

[See the Apple Docs](https://developer.apple.com/documentation/avfaudio/avaudiosession/mode/1616455-voicechat)


## `VoicePrompt`

A mode that indicates that your app plays audio using text-to-speech.

[See the Apple Docs](https://developer.apple.com/documentation/avfaudio/avaudiosession/mode/2962803-voiceprompt)
