"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.props2transform=props2transform;exports.transformToMatrix=transformToMatrix;exports.default=extractTransform;var _Matrix2D=require("../Matrix2D");var _transform=require("./transform");function appendTransformProps(props){var x=props.x,y=props.y,originX=props.originX,originY=props.originY,scaleX=props.scaleX,scaleY=props.scaleY,rotation=props.rotation,skewX=props.skewX,skewY=props.skewY;(0,_Matrix2D.appendTransform)(x+originX,y+originY,scaleX,scaleY,rotation,skewX,skewY,originX,originY);}function universal2axis(universal,axisX,axisY,defaultValue){var x;var y;if(typeof universal==='number'){x=y=universal;}else if(typeof universal==='string'){var coords=universal.split(/\s*,\s*/);if(coords.length===2){x=+coords[0];y=+coords[1];}else if(coords.length===1){x=y=+coords[0];}}else if(Array.isArray(universal)){if(universal.length===2){x=+universal[0];y=+universal[1];}else if(universal.length===1){x=y=+universal[0];}}axisX=+axisX;if(!isNaN(axisX)){x=axisX;}axisY=+axisY;if(!isNaN(axisY)){y=axisY;}return[x||defaultValue||0,y||defaultValue||0];}function props2transform(props){var rotation=props.rotation,translate=props.translate,translateX=props.translateX,translateY=props.translateY,origin=props.origin,originX=props.originX,originY=props.originY,scale=props.scale,scaleX=props.scaleX,scaleY=props.scaleY,skew=props.skew,skewX=props.skewX,skewY=props.skewY,x=props.x,y=props.y;if(rotation==null&&translate==null&&translateX==null&&translateY==null&&origin==null&&originX==null&&originY==null&&scale==null&&scaleX==null&&scaleY==null&&skew==null&&skewX==null&&skewY==null&&x==null&&y==null){return null;}if(Array.isArray(x)||Array.isArray(y)){console.warn('Passing SvgLengthList to x or y attribute where SvgLength expected');}var tr=universal2axis(translate,translateX||(Array.isArray(x)?x[0]:x),translateY||(Array.isArray(y)?y[0]:y));var or=universal2axis(origin,originX,originY);var sc=universal2axis(scale,scaleX,scaleY,1);var sk=universal2axis(skew,skewX,skewY);return{rotation:rotation==null?0:+rotation||0,originX:or[0],originY:or[1],scaleX:sc[0],scaleY:sc[1],skewX:sk[0],skewY:sk[1],x:tr[0],y:tr[1]};}function transformToMatrix(props,transform){if(!props&&!transform){return null;}(0,_Matrix2D.reset)();props&&appendTransformProps(props);if(transform){if(Array.isArray(transform)){if(typeof transform[0]==='number'){(0,_Matrix2D.append)(transform[0],transform[1],transform[2],transform[3],transform[4],transform[5]);}}else if(typeof transform==='string'){try{var t=(0,_transform.parse)(transform);(0,_Matrix2D.append)(t[0],t[3],t[1],t[4],t[2],t[5]);}catch(e){console.error(e);}}else{var transformProps=props2transform(transform);transformProps&&appendTransformProps(transformProps);}}return(0,_Matrix2D.toArray)();}function extractTransform(props){if(Array.isArray(props)){return props;}if(typeof props==='string'){try{var t=(0,_transform.parse)(props);return[t[0],t[3],t[1],t[4],t[2],t[5]];}catch(e){console.error(e);return _Matrix2D.identity;}}return transformToMatrix(props2transform(props),props.transform);}
//# sourceMappingURL=extractTransform.js.map