/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @emails oncall+react_native
 *
 * @format
 */
'use strict';

function _toArray(arr) {
  return (
    _arrayWithHoles(arr) ||
    _iterableToArray(arr) ||
    _unsupportedIterableToArray(arr) ||
    _nonIterableRest()
  );
}

function _nonIterableRest() {
  throw new TypeError(
    'Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.',
  );
}

function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === 'string') return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === 'Object' && o.constructor) n = o.constructor.name;
  if (n === 'Map' || n === 'Set') return Array.from(o);
  if (n === 'Arguments' || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
    return _arrayLikeToArray(o, minLen);
}

function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
  return arr2;
}

function _iterableToArray(iter) {
  if (typeof Symbol !== 'undefined' && Symbol.iterator in Object(iter))
    return Array.from(iter);
}

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

const combine = require('./combine-js-to-schema');

const fs = require('fs'); // $FlowFixMe[untyped-import] glob is untyped

const glob = require('glob');

const path = require('path');

const _process$argv$slice = process.argv.slice(2),
  _process$argv$slice2 = _toArray(_process$argv$slice),
  outfile = _process$argv$slice2[0],
  fileList = _process$argv$slice2.slice(1);

function filterJSFile(file) {
  return (
    /^(Native.+|.+NativeComponent)/.test(path.basename(file)) && // NativeUIManager will be deprecated by Fabric UIManager.
    // For now, ignore this spec completely because the types are not fully supported.
    !file.endsWith('NativeUIManager.js') && // NativeSampleTurboModule is for demo purpose. It should be added manually to the
    // app for now.
    !file.endsWith('NativeSampleTurboModule.js') &&
    !file.includes('__tests')
  );
}

const allFiles = [];
fileList.forEach(file => {
  if (fs.lstatSync(file).isDirectory()) {
    const dirFiles = glob
      .sync(`${file}/**/*.js`, {
        nodir: true,
      })
      .filter(filterJSFile);
    allFiles.push(...dirFiles);
  } else if (filterJSFile(file)) {
    allFiles.push(file);
  }
});
const formattedSchema = JSON.stringify(combine(allFiles), null, 2);

if (outfile != null) {
  fs.writeFileSync(outfile, formattedSchema);
} else {
  console.log(formattedSchema);
}
