"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isValidUrl = exports.isValidDate = exports.isOdd = exports.hasUppercase = exports.hasNumber = exports.hasMatchingStrings = exports.hasLowercase = exports.hasAtLeastXCharacters = exports.checkIfContainsStringMatch = void 0;
var checkIfContainsStringMatch = function (matchStr, currentStr) {
    var lowercaseString = matchStr ? matchStr.toLowerCase() : '';
    var regex = new RegExp("".concat(lowercaseString, "|").concat(lowercaseString, ".|.").concat(lowercaseString, ".|.").concat(lowercaseString));
    return regex.test((currentStr === null || currentStr === void 0 ? void 0 : currentStr.toLowerCase()) || '');
};
exports.checkIfContainsStringMatch = checkIfContainsStringMatch;
var hasAtLeastXCharacters = function (str, x) {
    if (x === void 0) { x = 8; }
    return str && str.match("^(?=.{".concat(x, ",})")) ? true : false;
};
exports.hasAtLeastXCharacters = hasAtLeastXCharacters;
var hasLowercase = function (str) {
    return str && str.match('^(?=.*[a-z])') ? true : false;
};
exports.hasLowercase = hasLowercase;
var hasMatchingStrings = function (str1, str2) {
    return str1 && str1 === str2 ? true : false;
};
exports.hasMatchingStrings = hasMatchingStrings;
var hasNumber = function (str) {
    return str && str.match('^(?=.*[0-9])') ? true : false;
};
exports.hasNumber = hasNumber;
var hasUppercase = function (str) {
    return str && str.match('^(?=.*[A-Z])') ? true : false;
};
exports.hasUppercase = hasUppercase;
var isOdd = function (num) { return num % 2 === 1; };
exports.isOdd = isOdd;
var isValidDate = function (date) { return date instanceof Date && !isNaN(date); };
exports.isValidDate = isValidDate;
var isValidUrl = function (str) {
    var regex = /(http|https):\/\/(\w+:{0,1}\w*)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%!\-\/]))?/;
    return str ? regex.test(str) : false;
};
exports.isValidUrl = isValidUrl;
