"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateHHMMSSString = exports.getTimeLabelText = exports.getHHMMSSMatchesInString = exports.getHHMMSSArray = exports.convertSecToHhoursMMinutes = exports.convertSecToHHMMSS = exports.convertSecToFullHHMMSS = exports.convertHoursMinutesSecondsToSeconds = exports.convertHHMMSSToSeconds = exports.convertHHMMSSToAnchorTags = void 0;
var moment_1 = __importDefault(require("moment"));
var convertHHMMSSToAnchorTags = function (html) {
    var createHHMMSSAnchorTag = function (hhmmss) {
        var sec = convertHHMMSSToSeconds(hhmmss);
        return "<a data-start-time='".concat(sec, "' href='#'>").concat(hhmmss, "</a>");
    };
    if (html) {
        var matches = (0, exports.getHHMMSSMatchesInString)(html) || [];
        var formattedHtml = html;
        for (var _i = 0, matches_1 = matches; _i < matches_1.length; _i++) {
            var match = matches_1[_i];
            var replace = match;
            var regex = new RegExp(replace, 'g');
            var anchorTag = createHHMMSSAnchorTag(match);
            formattedHtml = formattedHtml.replace(regex, anchorTag);
        }
        return formattedHtml;
    }
    return html;
};
exports.convertHHMMSSToAnchorTags = convertHHMMSSToAnchorTags;
function convertHHMMSSToSeconds(hhmmssString) {
    if (hhmmssString) {
        if (!validateHHMMSSString(hhmmssString)) {
            return -1;
        }
        var hhmmssArray = hhmmssString.split(':') || 0;
        var hours = 0;
        var minutes = 0;
        var seconds = 0;
        if (hhmmssArray.length === 3) {
            hours = parseInt(hhmmssArray[0], 10);
            minutes = parseInt(hhmmssArray[1], 10);
            seconds = parseInt(hhmmssArray[2], 10);
            if (hours < 0 || minutes > 59 || minutes < 0 || seconds > 59 || seconds < 0) {
                console.log('Invalid time provided.');
                return -1;
            }
            hours = hours * 3600;
            minutes = minutes ? minutes * 60 : 0;
        }
        else if (hhmmssArray.length === 2) {
            minutes = parseInt(hhmmssArray[0], 10);
            seconds = parseInt(hhmmssArray[1], 10);
            if (minutes > 59 || minutes < 0 || seconds > 59 || seconds < 0) {
                console.log('Invalid time provided.');
                return -1;
            }
            minutes = minutes * 60;
        }
        else if (hhmmssArray.length === 1) {
            seconds = parseInt(hhmmssArray[0], 10) || 0;
            if (seconds > 59 || seconds < 0) {
                console.log('Invalid time provided.');
                return -1;
            }
        }
        else {
            console.log('Invalid time provided.');
            return -1;
        }
        return hours + minutes + seconds;
    }
    else {
        return null;
    }
}
exports.convertHHMMSSToSeconds = convertHHMMSSToSeconds;
function convertHoursMinutesSecondsToSeconds(hours, minutes, seconds) {
    var totalSeconds = hours * 3600;
    totalSeconds += minutes * 60;
    totalSeconds += seconds;
    return totalSeconds;
}
exports.convertHoursMinutesSecondsToSeconds = convertHoursMinutesSecondsToSeconds;
var convertSecToFullHHMMSS = function (sec) {
    return moment_1.default.utc(sec * 1000).format('HH:mm:ss');
};
exports.convertSecToFullHHMMSS = convertSecToFullHHMMSS;
var convertSecToHHMMSS = function (sec) {
    var totalSec = Math.floor(sec);
    var hours = Math.floor(totalSec / 3600);
    totalSec %= 3600;
    var minutes = Math.floor(totalSec / 60);
    var seconds = Math.floor(totalSec % 60);
    var result = '';
    if (hours >= 1) {
        result += hours + ':';
    }
    if (minutes >= 10) {
        result += minutes + ':';
    }
    else if (minutes >= 1 && hours >= 1) {
        result += '0' + minutes + ':';
    }
    else if (minutes >= 1) {
        result += minutes + ':';
    }
    else if (minutes === 0 && hours >= 1) {
        result += '00:';
    }
    if (seconds >= 10) {
        result += seconds;
    }
    else if (seconds >= 1) {
        result += '0' + seconds;
    }
    else {
        result += '00';
    }
    if (result.length === 2) {
        result = '0:' + result;
    }
    if (result.length === 1) {
        result = '0:0' + result;
    }
    return result;
};
exports.convertSecToHHMMSS = convertSecToHHMMSS;
var convertSecToHhoursMMinutes = function (sec) {
    var totalSec = Math.floor(sec);
    var hours = Math.floor(totalSec / 3600);
    totalSec %= 3600;
    var minutes = Math.floor(totalSec / 60);
    var result = "".concat(minutes, " min");
    if (hours >= 1) {
        result = "".concat(hours, " hr ") + result;
    }
    return result;
};
exports.convertSecToHhoursMMinutes = convertSecToHhoursMMinutes;
var getHHMMSSArray = function (sec) {
    sec = sec > -1 ? sec : 0;
    var str = (0, exports.convertSecToHHMMSS)(sec);
    var delimitedArray = str.split(':');
    if (delimitedArray.length === 1) {
        delimitedArray.unshift('0');
        delimitedArray.unshift('0');
    }
    else if (delimitedArray.length === 2) {
        delimitedArray.unshift('0');
    }
    var parsedArray = delimitedArray.map(function (x) { return parseInt(x, 10); });
    return parsedArray;
};
exports.getHHMMSSArray = getHHMMSSArray;
var getHHMMSSMatchesInString = function (str) {
    var regex = /([0-9]?[0-9]:[0-5]?[0-9]:[0-5][0-9])|([0-5]?[0-9]:[0-5][0-9])/g;
    return str.match(regex);
};
exports.getHHMMSSMatchesInString = getHHMMSSMatchesInString;
var getTimeLabelText = function (mediaFileDuration, episodeDuration, userPlaybackPosition, completed, clipTime) {
    var hasStartedItem = !!mediaFileDuration;
    var totalTime = mediaFileDuration || episodeDuration || 0;
    var playedTime = userPlaybackPosition || 0;
    var timeLabel = '';
    if (totalTime) {
        timeLabel = (0, exports.convertSecToHhoursMMinutes)(totalTime);
        if (hasStartedItem && playedTime > 0) {
            timeLabel = (0, exports.convertSecToHhoursMMinutes)(totalTime - playedTime);
        }
    }
    if (clipTime) {
        timeLabel = clipTime;
    }
    return timeLabel;
};
exports.getTimeLabelText = getTimeLabelText;
function validateHHMMSSString(hhmmss) {
    var regex = new RegExp(
    // eslint-disable-next-line max-len
    '^(([0-9][0-9]):([0-5][0-9]):([0-5][0-9]))$|(([0-9]):([0-5][0-9]):([0-5][0-9]))$|^(([0-5][0-9]):([0-5][0-9]))$|^(([0-9]):([0-5][0-9]))$|^([0-5][0-9])$|^([0-9])');
    return regex.test(hhmmss);
}
exports.validateHHMMSSString = validateHHMMSSString;
