"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertPIValueTagToPVValueTagArray = exports.PodcastIndexAPIService = void 0;
var axios_1 = __importDefault(require("axios"));
var sha1_1 = __importDefault(require("crypto-js/sha1"));
var enc_hex_1 = __importDefault(require("crypto-js/enc-hex"));
/*
  NOTE!!!
  The episodeGuid needs to be encoded both on the client-side and server side if it is an http url guid.
  Koa will automatically decode the encoded url param, and then Podcast Index API needs it
  encoded once again before sending the request to PI API.
*/
var PodcastIndexAPIService = /** @class */ (function () {
    function PodcastIndexAPIService(_a) {
        var authKey = _a.authKey, baseUrl = _a.baseUrl, secretKey = _a.secretKey, userAgent = _a.userAgent;
        var _this = this;
        this.podcastIndexAPIRequest = function (url) { return __awaiter(_this, void 0, void 0, function () {
            var apiHeaderTime, hash;
            return __generator(this, function (_a) {
                apiHeaderTime = new Date().getTime() / 1000;
                hash = (0, sha1_1.default)(this.authKey + this.secretKey + apiHeaderTime).toString(enc_hex_1.default);
                return [2 /*return*/, (0, axios_1.default)({
                        url: url,
                        method: 'GET',
                        headers: {
                            'User-Agent': this.userAgent,
                            'X-Auth-Key': this.authKey,
                            'X-Auth-Date': apiHeaderTime,
                            Authorization: hash
                        }
                    })];
            });
        }); };
        this.getAllEpisodesFromPodcastIndexById = function (podcastIndexId) { return __awaiter(_this, void 0, void 0, function () {
            var response, allEpisodes;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getEpisodesFromPodcastIndexById(podcastIndexId)];
                    case 1:
                        response = _a.sent();
                        allEpisodes = response === null || response === void 0 ? void 0 : response.items;
                        return [2 /*return*/, allEpisodes];
                }
            });
        }); };
        this.getAllEpisodeValueTagsFromPodcastIndexById = function (podcastIndexId) { return __awaiter(_this, void 0, void 0, function () {
            var episodes, pvEpisodesValueTagsByGuid, _i, episodes_1, episode, pvValueTagArray;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getAllEpisodesFromPodcastIndexById(podcastIndexId)];
                    case 1:
                        episodes = _a.sent();
                        pvEpisodesValueTagsByGuid = {};
                        for (_i = 0, episodes_1 = episodes; _i < episodes_1.length; _i++) {
                            episode = episodes_1[_i];
                            if ((episode === null || episode === void 0 ? void 0 : episode.value) && (episode === null || episode === void 0 ? void 0 : episode.guid)) {
                                pvValueTagArray = (0, exports.convertPIValueTagToPVValueTagArray)(episode.value);
                                if ((pvValueTagArray === null || pvValueTagArray === void 0 ? void 0 : pvValueTagArray.length) > 0) {
                                    pvEpisodesValueTagsByGuid[episode.guid] = pvValueTagArray;
                                }
                            }
                        }
                        return [2 /*return*/, pvEpisodesValueTagsByGuid];
                }
            });
        }); };
        this.getEpisodesFromPodcastIndexById = function (podcastIndexId) { return __awaiter(_this, void 0, void 0, function () {
            var url, response;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        url = "".concat(this.baseUrl, "/episodes/byfeedid?id=").concat(podcastIndexId, "&max=1000");
                        return [4 /*yield*/, this.podcastIndexAPIRequest(url)];
                    case 1:
                        response = _a.sent();
                        return [2 /*return*/, response && response.data];
                }
            });
        }); };
        this.getPodcastFromPodcastIndexById = function (id) { return __awaiter(_this, void 0, void 0, function () {
            var url, response;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        url = "".concat(this.baseUrl, "/podcasts/byfeedid?id=").concat(id);
                        return [4 /*yield*/, this.podcastIndexAPIRequest(url)];
                    case 1:
                        response = _a.sent();
                        return [2 /*return*/, response && response.data];
                }
            });
        }); };
        this.getPodcastValueTagForPodcastIndexId = function (id) { return __awaiter(_this, void 0, void 0, function () {
            var podcast, pvValueTagArray;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getPodcastFromPodcastIndexById(id)];
                    case 1:
                        podcast = _a.sent();
                        pvValueTagArray = (0, exports.convertPIValueTagToPVValueTagArray)(podcast.feed.value);
                        return [2 /*return*/, pvValueTagArray];
                }
            });
        }); };
        this.authKey = authKey;
        this.baseUrl = baseUrl;
        this.secretKey = secretKey;
        this.userAgent = userAgent;
    }
    return PodcastIndexAPIService;
}());
exports.PodcastIndexAPIService = PodcastIndexAPIService;
var convertPIValueTagToPVValueTagArray = function (piValueTag) {
    return [
        {
            method: piValueTag.model.method,
            suggested: piValueTag.model.suggested,
            type: piValueTag.model.type,
            recipients: piValueTag.destinations.map(function (destination) {
                return {
                    address: destination.address,
                    customKey: destination.customKey || '',
                    customValue: destination.customValue || '',
                    fee: destination.fee || false,
                    name: destination.name || '',
                    split: destination.split || 0,
                    type: destination.type || ''
                };
            }),
            valueTimeSplits: piValueTag.valueTimeSplits
        }
    ];
};
exports.convertPIValueTagToPVValueTagArray = convertPIValueTagToPVValueTagArray;
