import { Phase6ValueTimeSplit } from 'podcast-partytime/dist/parser/phase/phase-6';
type PIValueModel = {
    type: string;
    method: string;
    suggested: string;
};
type PIValueDestination = {
    name: string;
    type: string;
    address: string;
    split: number;
    customKey?: string;
    customValue?: string;
    fee?: boolean;
};
type PIValueTag = {
    model: PIValueModel;
    destinations: PIValueDestination[];
    valueTimeSplits: Phase6ValueTimeSplit[];
};
type Constructor = {
    authKey: string;
    baseUrl: string;
    secretKey: string;
    userAgent: string;
};
export declare class PodcastIndexAPIService {
    authKey: string;
    baseUrl: string;
    secretKey: string;
    userAgent: string;
    constructor({ authKey, baseUrl, secretKey, userAgent }: Constructor);
    podcastIndexAPIRequest: (url: string) => Promise<import("axios").AxiosResponse<any, any>>;
    getAllEpisodesFromPodcastIndexById: (podcastIndexId: string) => Promise<any>;
    getAllEpisodeValueTagsFromPodcastIndexById: (podcastIndexId: string) => Promise<any>;
    getEpisodesFromPodcastIndexById: (podcastIndexId: string) => Promise<any>;
    getPodcastFromPodcastIndexById: (id: string) => Promise<any>;
    getPodcastValueTagForPodcastIndexId: (id: string) => Promise<any[]>;
}
export declare const convertPIValueTagToPVValueTagArray: (piValueTag: PIValueTag) => any[];
export {};
