"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseOpmlFile = void 0;
var parseOpmlFile = function (data, topLevel) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    if (topLevel === void 0) { topLevel = false; }
    var outlineArr = data;
    if (topLevel) {
        outlineArr = ((_b = (_a = data.opml) === null || _a === void 0 ? void 0 : _a.body[0]) === null || _b === void 0 ? void 0 : _b.outline) || [];
    }
    var resultArr = new Array();
    for (var _i = 0, outlineArr_1 = outlineArr; _i < outlineArr_1.length; _i++) {
        var item = outlineArr_1[_i];
        /*
          Exports from Podkicker don't include the type="rss" attribute,
          so if an xmlurl or xmlUrl is on item, then assume it is an rss feed url.
        */
        if (((_d = (_c = item.$) === null || _c === void 0 ? void 0 : _c.type) === null || _d === void 0 ? void 0 : _d.toLowerCase()) === 'rss' || ((_e = item.$) === null || _e === void 0 ? void 0 : _e.xmlurl) || ((_f = item.$) === null || _f === void 0 ? void 0 : _f.xmlUrl)) {
            var url = ((_g = item.$) === null || _g === void 0 ? void 0 : _g.xmlurl) || ((_h = item.$) === null || _h === void 0 ? void 0 : _h.xmlUrl);
            var decodedUrl = decodeURIComponent(url);
            if (decodedUrl) {
                resultArr.push(decodedUrl);
            }
        }
        else {
            if (item.outline) {
                resultArr.push.apply(resultArr, (0, exports.parseOpmlFile)(item.outline));
            }
        }
    }
    return resultArr;
};
exports.parseOpmlFile = parseOpmlFile;
