"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.haveNowPlayingItemsChanged = exports.checkIfVideoFileOrVideoLiveType = exports.checkIfVideoFileType = exports.checkIfSameNowPlayingItems = exports.checkIfNowPlayingItem = exports.convertToNowPlayingItem = exports.convertNowPlayingItemClipToNowPlayingItemEpisode = exports.convertNowPlayingItemToMediaRef = exports.convertNowPlayingItemToEpisode = exports.cleanNowPlayingItem = void 0;
/*
  Always call cleanNowPlayingItem before loading nowPlayingItem into player state.
*/
var cleanNowPlayingItem = function (item) {
    var cleanedItem = {};
    if (item.clipId) {
        cleanedItem = __assign(__assign({}, cleanedItem), { clipEndTime: item.clipEndTime || null, clipId: item.clipId || '', clipIsOfficialChapter: item.clipIsOfficialChapter || false, clipIsOfficialSoundBite: item.clipIsOfficialSoundBite || false, clipLinkUrl: item.clipLinkUrl || '', clipStartTime: item.clipStartTime || 0, clipTitle: item.clipTitle || '' });
    }
    if (item.ownerId) {
        cleanedItem = __assign(__assign({}, cleanedItem), { ownerId: item.ownerId || '', ownerIsPublic: item.ownerIsPublic || false, ownerName: item.ownerName || '' });
    }
    return __assign(__assign(__assign(__assign({}, cleanedItem), { addByRSSPodcastFeedUrl: item.addByRSSPodcastFeedUrl || '', episodeAlternateEnclosures: parseProp(item, 'episodeAlternateEnclosures', []), episodeAlternateEnclosureSelected: parseProp(item, 'episodeAlternateEnclosureSelected', null), episodeAuthors: item.episodeAuthors || [], episodeChaptersUrl: item.episodeChaptersUrl || '', episodeCredentialsRequired: item.episodeCredentialsRequired || false, episodeDescription: item.episodeDescription || '', episodeDuration: item.episodeDuration || null, episodeFunding: parseProp(item, 'episodeFunding', []), episodeGuid: item.episodeGuid || '', episodeId: item.episodeId || '', episodeImageUrl: item.episodeImageUrl || '', episodeLinkUrl: item.episodeLinkUrl || '', episodeMediaType: item.episodeMediaType || '', episodeMediaUrl: item.episodeMediaUrl || '' }), (item.episodePubDate ? { episodePubDate: item.episodePubDate } : {})), { episodeSocialInteraction: parseProp(item, 'episodeSocialInteraction', []), episodeSubtitle: item.episodeSubtitle || '', episodeTitle: item.episodeTitle || '', episodeTranscript: parseProp(item, 'episodeTranscript', []), episodeValue: parseProp(item, 'episodeValue', []), isPublic: item.isPublic || false, liveItem: item.liveItem || null, podcastAuthors: item.podcastAuthors || [], podcastCredentialsRequired: item.podcastCredentialsRequired || false, podcastFunding: parseProp(item, 'podcastFunding', []), podcastGuid: item.podcastGuid || '', podcastHasSeasons: item.podcastHasSeasons || false, podcastHasVideo: item.podcastHasVideo || false, podcastHideDynamicAdsWarning: item.podcastHideDynamicAdsWarning || false, podcastId: item.podcastId || '', podcastImageUrl: item.podcastImageUrl || '', podcastIndexPodcastId: item.podcastIndexPodcastId || '', podcastIsExplicit: item.podcastIsExplicit || false, podcastItunesFeedType: item.podcastItunesFeedType || '', podcastLinkUrl: item.podcastLinkUrl || '', podcastMedium: item.podcastMedium || 'podcast', podcastShrunkImageUrl: item.podcastShrunkImageUrl || '', podcastSortableTitle: item.podcastSortableTitle || '', podcastTitle: item.podcastTitle || '', podcastValue: parseProp(item, 'podcastValue', []), userPlaybackPosition: !item.userPlaybackPosition && item.userPlaybackPosition !== 0
            ? 0
            : item.userPlaybackPosition });
};
exports.cleanNowPlayingItem = cleanNowPlayingItem;
var parseProp = function (item, key, defaultValue) {
    var val = defaultValue;
    item = item || {};
    if (typeof item === 'object' && typeof item[key] === 'string') {
        try {
            val = JSON.parse(item[key]);
        }
        catch (error) {
            console.log("parseProp ".concat(key, " error"), error);
        }
    }
    else if (item[key]) {
        val = item[key];
    }
    return val;
};
var convertNowPlayingItemToEpisode = function (item) {
    return {
        alternateEnclosures: parseProp(item, 'episodeAlternateEnclosures', []),
        authors: item.episodeAuthors,
        chaptersUrl: item.episodeChaptersUrl,
        credentialsRequired: item.episodeCredentialsRequired || false,
        description: item.episodeDescription,
        duration: item.episodeDuration,
        funding: parseProp(item, 'episodeFunding', []),
        guid: item.episodeGuid,
        id: item.episodeId,
        imageUrl: item.episodeImageUrl,
        linkUrl: item.episodeLinkUrl,
        liveItem: item.liveItem,
        mediaType: item.episodeMediaType,
        mediaUrl: item.episodeMediaUrl,
        pubDate: item.episodePubDate,
        socialInteraction: item.episodeSocialInteraction,
        subtitle: item.episodeSubtitle,
        title: item.episodeTitle,
        transcript: parseProp(item, 'episodeTranscript', []),
        value: parseProp(item, 'episodeValue', []),
        podcast: {
            addByRSSPodcastFeedUrl: item.addByRSSPodcastFeedUrl,
            authors: item.podcastAuthors,
            credentialsRequired: item.podcastCredentialsRequired,
            funding: parseProp(item, 'podcastFunding', []),
            hasSeasons: item.podcastHasSeasons,
            hasVideo: item.podcastHasVideo,
            hideDynamicAdsWarning: item.podcastHideDynamicAdsWarning,
            id: item.podcastId,
            imageUrl: item.podcastImageUrl,
            isExplicit: item.podcastIsExplicit,
            itunesFeedType: item.podcastItunesFeedType,
            linkUrl: item.podcastLinkUrl,
            medium: item.podcastMedium,
            podcastGuid: item.podcastGuid,
            podcastIndexId: item.podcastIndexPodcastId,
            shrunkImageUrl: item.podcastShrunkImageUrl,
            sortableTitle: item.podcastSortableTitle,
            title: item.podcastTitle,
            value: parseProp(item, 'podcastValue', [])
        }
    };
};
exports.convertNowPlayingItemToEpisode = convertNowPlayingItemToEpisode;
var convertNowPlayingItemToMediaRef = function (item) {
    if (item === void 0) { item = {}; }
    return {
        endTime: item.clipEndTime,
        episode: (0, exports.convertNowPlayingItemToEpisode)(item),
        id: item.clipId,
        isChapterToc: item.clipIsChapterToc,
        isOfficialChapter: item.clipIsOfficialChapter,
        isOfficialSoundBite: item.clipIsOfficialSoundBite,
        isPublic: item.isPublic,
        linkUrl: item.clipLinkUrl || '',
        startTime: item.clipStartTime,
        title: item.clipTitle,
        owner: {
            id: item.ownerId,
            isPublic: item.ownerIsPublic,
            name: item.ownerName
        }
    };
};
exports.convertNowPlayingItemToMediaRef = convertNowPlayingItemToMediaRef;
var convertNowPlayingItemClipToNowPlayingItemEpisode = function (data, userPlaybackPosition) {
    if (userPlaybackPosition === void 0) { userPlaybackPosition = 0; }
    return {
        addByRSSPodcastFeedUrl: data.addByRSSPodcastFeedUrl,
        episodeAlternateEnclosures: parseProp(data, 'episodeAlternateEnclosures', []),
        episodeAlternateEnclosureSelected: parseProp(data, 'episodeAlternateEnclosureSelected', null),
        episodeAuthors: data.episodeAuthors || [],
        episodeChaptersUrl: data.episodeChaptersUrl,
        episodeCredentialsRequired: data.episodeCredentialsRequired,
        episodeDescription: data.episodeDescription,
        episodeDuration: data.episodeDuration,
        episodeFunding: parseProp(data, 'episodeFunding', []),
        episodeGuid: data.episodeGuid,
        episodeId: data.episodeId,
        episodeImageUrl: data.episodeImageUrl,
        episodeLinkUrl: data.episodeLinkUrl,
        episodeMediaType: data.episodeMediaType,
        episodeMediaUrl: data.episodeMediaUrl,
        episodePubDate: data.episodePubDate,
        episodeSocialInteraction: parseProp(data, 'episodeSocialInteraction', []),
        episodeSubtitle: data.episodeSubtitle,
        episodeTitle: data.episodeTitle,
        episodeTranscript: parseProp(data, 'episodeTranscript', []),
        episodeValue: parseProp(data, 'episodeValue', []),
        liveItem: null,
        podcastAuthors: data.podcastAuthors || [],
        podcastCredentialsRequired: data.podcastCredentialsRequired,
        podcastFunding: parseProp(data, 'podcastFunding', []),
        podcastGuid: data.podcastGuid,
        podcastHasSeasons: data.podcastHasSeasons,
        podcastHasVideo: data.podcastHasVideo,
        podcastHideDynamicAdsWarning: data.podcastHideDynamicAdsWarning,
        podcastId: data.podcastId,
        podcastImageUrl: data.podcastImageUrl,
        podcastIndexPodcastId: data.podcastIndexPodcastId,
        podcastIsExplicit: data.podcastIsExplicit,
        podcastItunesFeedType: data.podcastItunesFeedType,
        podcastLinkUrl: data.podcastLinkUrl,
        podcastMedium: data.podcastMedium,
        podcastShrunkImageUrl: data.podcastShrunkImageUrl,
        podcastSortableTitle: data.podcastSortableTitle,
        podcastTitle: data.podcastTitle,
        podcastValue: parseProp(data, 'podcastValue', []),
        userPlaybackPosition: userPlaybackPosition || 0
    };
};
exports.convertNowPlayingItemClipToNowPlayingItemEpisode = convertNowPlayingItemClipToNowPlayingItemEpisode;
var convertToNowPlayingItem = function (data, inheritedEpisode, inheritedPodcast, userPlaybackPosition) {
    if (inheritedEpisode === void 0) { inheritedEpisode = {}; }
    if (inheritedPodcast === void 0) { inheritedPodcast = {}; }
    if (userPlaybackPosition === void 0) { userPlaybackPosition = 0; }
    var nowPlayingItem = {};
    if (!data) {
        return {};
    }
    var e = (data.pubDate && data) || data.episode || inheritedEpisode;
    var p = (data.episode && data.episode.podcast) || data.podcast || inheritedPodcast;
    // If it has a podcast_id field, assume it is an Episode list item
    if (data.podcast_id) {
        nowPlayingItem.episodeAlternateEnclosures = parseProp(data, 'alternateEnclosures', []),
            nowPlayingItem.episodeAlternateEnclosureSelected = null,
            nowPlayingItem.episodeAuthors = data.authors || [];
        nowPlayingItem.episodeChaptersUrl = data.chaptersUrl;
        nowPlayingItem.episodeCredentialsRequired = data.credentialsRequired;
        nowPlayingItem.episodeDescription = data.description;
        nowPlayingItem.episodeDuration = data.duration;
        nowPlayingItem.episodeFunding = parseProp(data, 'funding', []);
        nowPlayingItem.episodeGuid = data.guid;
        nowPlayingItem.episodeId = data.id;
        nowPlayingItem.episodeImageUrl = data.imageUrl;
        nowPlayingItem.episodeLinkUrl = data.linkUrl;
        nowPlayingItem.episodeMediaType = data.mediaType;
        nowPlayingItem.episodeMediaUrl = data.mediaUrl;
        nowPlayingItem.episodePubDate = data.pubDate;
        nowPlayingItem.episodeSocialInteraction = data.socialInteraction;
        nowPlayingItem.episodeSubtitle = data.subtitle;
        nowPlayingItem.episodeTitle = data.title;
        nowPlayingItem.episodeTranscript = parseProp(data, 'transcript', []),
            nowPlayingItem.episodeValue = parseProp(data, 'value', []);
        nowPlayingItem.liveItem = data.liveItem;
        nowPlayingItem.podcastAuthors = data.podcast_authors || [];
        nowPlayingItem.podcastCredentialsRequired = data.podcast_credentialsRequired;
        nowPlayingItem.podcastFunding = parseProp(data, 'podcast_funding', []);
        nowPlayingItem.podcastGuid = data.podcast_podcastGuid;
        nowPlayingItem.podcastHasVideo = data.podcast_hasVideo;
        nowPlayingItem.podcastHideDynamicAdsWarning = data.podcast_hideDynamicAdsWarning;
        nowPlayingItem.podcastId = data.podcast_id;
        nowPlayingItem.podcastImageUrl = data.podcast_shrunkImageUrl || data.podcast_imageUrl;
        nowPlayingItem.podcastIndexPodcastId = data.podcast_podcastIndexId;
        nowPlayingItem.podcastLinkUrl = data.podcast_linkUrl;
        nowPlayingItem.podcastMedium = data.podcast_medium;
        nowPlayingItem.podcastShrunkImageUrl = data.podcast_shrunkImageUrl;
        nowPlayingItem.podcastSortableTitle = data.podcast_sortableTitle;
        nowPlayingItem.podcastTitle = data.podcast_title;
        nowPlayingItem.podcastValue = parseProp(data, 'podcast_value', []);
        nowPlayingItem.userPlaybackPosition = userPlaybackPosition || 0;
        // If it has a pubDate field, assume it is an Episode
    }
    else if (data.pubDate) {
        nowPlayingItem.episodeAlternateEnclosures = parseProp(data, 'alternateEnclosures', []);
        nowPlayingItem.episodeAlternateEnclosureSelected = null;
        nowPlayingItem.episodeAuthors = data.authors || [];
        nowPlayingItem.episodeChaptersUrl = data.chaptersUrl;
        nowPlayingItem.episodeCredentialsRequired = data.credentialsRequired;
        nowPlayingItem.episodeDescription = data.description;
        nowPlayingItem.episodeDuration = data.duration;
        nowPlayingItem.episodeFunding = parseProp(data, 'funding', []);
        nowPlayingItem.episodeGuid = data.guid;
        nowPlayingItem.episodeId = data.id;
        nowPlayingItem.episodeImageUrl = data.imageUrl;
        nowPlayingItem.episodeLinkUrl = data.linkUrl;
        nowPlayingItem.episodeMediaType = data.mediaType;
        nowPlayingItem.episodeMediaUrl = data.mediaUrl;
        nowPlayingItem.episodePubDate = data.pubDate;
        nowPlayingItem.episodeSocialInteraction = parseProp(data, 'socialInteraction', []);
        nowPlayingItem.episodeSubtitle = data.subtitle;
        nowPlayingItem.episodeTitle = data.title;
        nowPlayingItem.episodeTranscript = parseProp(data, 'transcript', []);
        nowPlayingItem.episodeValue = parseProp(data, 'value', []);
        nowPlayingItem.liveItem = data.liveItem;
        nowPlayingItem.podcastAuthors = p.authors || [];
        nowPlayingItem.podcastCredentialsRequired = p.credentialsRequired;
        nowPlayingItem.podcastFunding = parseProp(p, 'funding', []);
        nowPlayingItem.podcastGuid = p.podcastGuid;
        nowPlayingItem.podcastHasSeasons = p.hasSeasons;
        nowPlayingItem.podcastHasVideo = p.hasVideo;
        nowPlayingItem.podcastHideDynamicAdsWarning = p.hideDynamicAdsWarning;
        nowPlayingItem.podcastId = p.id;
        nowPlayingItem.podcastImageUrl = p.shrunkImageUrl || p.imageUrl;
        nowPlayingItem.podcastIndexPodcastId = p.podcastIndexId;
        nowPlayingItem.podcastIsExplicit = p.isExplicit;
        nowPlayingItem.podcastItunesFeedType = p.itunesFeedType;
        nowPlayingItem.podcastLinkUrl = p.linkUrl;
        nowPlayingItem.podcastMedium = p.medium;
        nowPlayingItem.podcastShrunkImageUrl = p.shrunkImageUrl;
        nowPlayingItem.podcastSortableTitle = p.sortableTitle;
        nowPlayingItem.podcastTitle = p.title;
        nowPlayingItem.podcastValue = parseProp(p, 'value', []);
        nowPlayingItem.userPlaybackPosition = userPlaybackPosition || 0;
        // Else assume it is a MediaRef
    }
    else {
        nowPlayingItem.clipEndTime = data.endTime;
        nowPlayingItem.clipId = data.id;
        nowPlayingItem.clipIsChapterToc = data.isChapterToc;
        nowPlayingItem.clipIsOfficialChapter = data.isOfficialChapter;
        nowPlayingItem.clipIsOfficialSoundBite = data.isOfficialSoundBite;
        nowPlayingItem.clipLinkUrl = data.linkUrl || '';
        nowPlayingItem.clipStartTime = data.startTime;
        nowPlayingItem.clipTitle = data.title;
        nowPlayingItem.episodeAlternateEnclosures = parseProp(e, 'alternateEnclosures', []);
        nowPlayingItem.episodeAlternateEnclosureSelected = null;
        nowPlayingItem.episodeAuthors = e.authors;
        nowPlayingItem.episodeChaptersUrl = e.chaptersUrl;
        nowPlayingItem.episodeCredentialsRequired = e.credentialsRequired;
        nowPlayingItem.episodeDescription = e.description;
        nowPlayingItem.episodeDuration = e.duration;
        nowPlayingItem.episodeFunding = parseProp(e, 'funding', []);
        nowPlayingItem.episodeGuid = e.guid;
        nowPlayingItem.episodeId = e.id;
        nowPlayingItem.episodeImageUrl = e.imageUrl;
        nowPlayingItem.episodeLinkUrl = e.linkUrl;
        nowPlayingItem.episodeMediaType = e.mediaType;
        nowPlayingItem.episodeMediaUrl = e.mediaUrl;
        nowPlayingItem.episodePubDate = e.pubDate;
        nowPlayingItem.episodeSocialInteraction = parseProp(e, 'socialInteraction', []);
        nowPlayingItem.episodeSubtitle = e.subtitle;
        nowPlayingItem.episodeTitle = e.title;
        nowPlayingItem.episodeTranscript = parseProp(e, 'transcript', []);
        nowPlayingItem.episodeValue = parseProp(e, 'value', []);
        nowPlayingItem.isPublic = data.isPublic;
        nowPlayingItem.liveItem = data.liveItem;
        nowPlayingItem.ownerId = data.owner && data.owner.id;
        nowPlayingItem.ownerIsPublic = data.owner && data.owner.isPublic;
        nowPlayingItem.ownerName = data.owner && data.owner.name;
        nowPlayingItem.podcastAuthors = p.authors;
        nowPlayingItem.podcastCredentialsRequired = p.credentialsRequired;
        nowPlayingItem.podcastFunding = parseProp(p, 'funding', []);
        nowPlayingItem.podcastGuid = p.podcastGuid;
        nowPlayingItem.podcastHasVideo = p.hasVideo;
        nowPlayingItem.podcastHideDynamicAdsWarning = p.hideDynamicAdsWarning;
        nowPlayingItem.podcastId = p.id;
        nowPlayingItem.podcastIsExplicit = p.isExplicit;
        nowPlayingItem.podcastImageUrl = p.shrunkImageUrl || p.imageUrl;
        nowPlayingItem.podcastIndexPodcastId = p.podcastIndexId;
        nowPlayingItem.podcastLinkUrl = p.linkUrl;
        nowPlayingItem.podcastMedium = p.medium;
        nowPlayingItem.podcastShrunkImageUrl = p.shrunkImageUrl;
        nowPlayingItem.podcastSortableTitle = p.sortableTitle;
        nowPlayingItem.podcastTitle = p.title;
        nowPlayingItem.podcastValue = parseProp(p, 'value', []);
        nowPlayingItem.userPlaybackPosition =
            userPlaybackPosition || data.clipStartTime || 0;
    }
    nowPlayingItem.addByRSSPodcastFeedUrl = data.addByRSSPodcastFeedUrl || (inheritedPodcast && inheritedPodcast.addByRSSPodcastFeedUrl);
    return nowPlayingItem;
};
exports.convertToNowPlayingItem = convertToNowPlayingItem;
var checkIfNowPlayingItem = function (item, nowPlayingItem) {
    return item && nowPlayingItem && (nowPlayingItem.clipId === item.id || nowPlayingItem.episodeId === item.id);
};
exports.checkIfNowPlayingItem = checkIfNowPlayingItem;
var checkIfSameNowPlayingItems = function (nowPlayingItem, nowPlayingItem2) {
    return nowPlayingItem
        && nowPlayingItem2
        && ((nowPlayingItem.clipId && nowPlayingItem.clipId === nowPlayingItem2.clipId)
            || (nowPlayingItem.episodeId && nowPlayingItem.episodeId === nowPlayingItem2.episodeId));
};
exports.checkIfSameNowPlayingItems = checkIfSameNowPlayingItems;
var checkIfVideoFileType = function (nowPlayingItem) {
    return !!((nowPlayingItem === null || nowPlayingItem === void 0 ? void 0 : nowPlayingItem.episodeMediaType) && nowPlayingItem.episodeMediaType.indexOf('video') >= 0);
};
exports.checkIfVideoFileType = checkIfVideoFileType;
var checkIfVideoFileOrVideoLiveType = function (mediaType) {
    return !!(typeof mediaType === 'string'
        &&
            (mediaType.indexOf('video') >= 0
                || mediaType.indexOf('application/x-mpegURL') >= 0));
};
exports.checkIfVideoFileOrVideoLiveType = checkIfVideoFileOrVideoLiveType;
var haveNowPlayingItemsChanged = function (lastItem, nextItem) {
    return (nextItem.clipId && nextItem.clipId !== lastItem.clipId) ||
        (nextItem.episodeId && nextItem.episodeId !== lastItem.episodeId);
};
exports.haveNowPlayingItemsChanged = haveNowPlayingItemsChanged;
