import { Author, EpisodeAlternateEnclosure, PodcastMedium, SocialInteraction } from '.';
import { LiveItem } from './LiveItem';
import { Transcript } from './transcript';
export type NowPlayingItem = {
    addByRSSPodcastFeedUrl?: string;
    clipEndTime?: number;
    clipId?: string;
    clipIsChapterToc?: boolean | null;
    clipIsOfficialChapter?: boolean;
    clipIsOfficialSoundBite?: boolean;
    clipLinkUrl?: string;
    clipStartTime?: number;
    clipTitle?: string;
    episodeAlternateEnclosures?: EpisodeAlternateEnclosure[];
    episodeAlternateEnclosureSelected?: EpisodeAlternateEnclosure | null;
    episodeAuthors?: Author[];
    episodeChaptersUrl?: string;
    episodeCredentialsRequired?: boolean;
    episodeDescription?: string;
    episodeDuration?: number;
    episodeFunding?: any;
    episodeGuid?: string;
    episodeId?: string;
    episodeImageUrl?: string;
    episodeLinkUrl?: string;
    episodeMediaType?: string;
    episodeMediaUrl?: string;
    episodePubDate?: string;
    episodeSocialInteraction?: SocialInteraction;
    episodeSubtitle?: string;
    episodeTitle?: string;
    episodeTranscript?: Transcript[];
    episodeValue?: any;
    isPublic?: boolean;
    liveItem?: LiveItem;
    ownerId?: string;
    ownerIsPublic?: boolean;
    ownerName?: string;
    podcastAuthors?: Author[];
    podcastCredentialsRequired?: boolean;
    podcastFunding?: any;
    podcastHasVideo?: boolean;
    podcastHideDynamicAdsWarning?: boolean;
    podcastGuid?: string;
    podcastHasSeasons?: boolean;
    podcastId?: string;
    podcastImageUrl?: string;
    podcastIndexPodcastId?: string;
    podcastIsExplicit?: boolean;
    podcastItunesFeedType?: string;
    podcastMedium?: PodcastMedium;
    podcastLinkUrl?: string;
    podcastShrunkImageUrl?: string;
    podcastSortableTitle?: string;
    podcastTitle?: string;
    podcastValue?: any;
    userPlaybackPosition?: number;
};
export declare const cleanNowPlayingItem: (item: any) => {
    episodeSocialInteraction: any;
    episodeSubtitle: any;
    episodeTitle: any;
    episodeTranscript: any;
    episodeValue: any;
    isPublic: any;
    liveItem: any;
    podcastAuthors: any;
    podcastCredentialsRequired: any;
    podcastFunding: any;
    podcastGuid: any;
    podcastHasSeasons: any;
    podcastHasVideo: any;
    podcastHideDynamicAdsWarning: any;
    podcastId: any;
    podcastImageUrl: any;
    podcastIndexPodcastId: any;
    podcastIsExplicit: any;
    podcastItunesFeedType: any;
    podcastLinkUrl: any;
    podcastMedium: any;
    podcastShrunkImageUrl: any;
    podcastSortableTitle: any;
    podcastTitle: any;
    podcastValue: any;
    userPlaybackPosition: any;
    episodePubDate?: any;
    addByRSSPodcastFeedUrl: any;
    episodeAlternateEnclosures: any;
    episodeAlternateEnclosureSelected: any;
    episodeAuthors: any;
    episodeChaptersUrl: any;
    episodeCredentialsRequired: any;
    episodeDescription: any;
    episodeDuration: any;
    episodeFunding: any;
    episodeGuid: any;
    episodeId: any;
    episodeImageUrl: any;
    episodeLinkUrl: any;
    episodeMediaType: any;
    episodeMediaUrl: any;
};
export declare const convertNowPlayingItemToEpisode: (item: NowPlayingItem) => {
    alternateEnclosures: any;
    authors: Author[] | undefined;
    chaptersUrl: string | undefined;
    credentialsRequired: boolean;
    description: string | undefined;
    duration: number | undefined;
    funding: any;
    guid: string | undefined;
    id: string | undefined;
    imageUrl: string | undefined;
    linkUrl: string | undefined;
    liveItem: LiveItem | undefined;
    mediaType: string | undefined;
    mediaUrl: string | undefined;
    pubDate: string | undefined;
    socialInteraction: SocialInteraction | undefined;
    subtitle: string | undefined;
    title: string | undefined;
    transcript: any;
    value: any;
    podcast: {
        addByRSSPodcastFeedUrl: string | undefined;
        authors: Author[] | undefined;
        credentialsRequired: boolean | undefined;
        funding: any;
        hasSeasons: boolean | undefined;
        hasVideo: boolean | undefined;
        hideDynamicAdsWarning: boolean | undefined;
        id: string | undefined;
        imageUrl: string | undefined;
        isExplicit: boolean | undefined;
        itunesFeedType: string | undefined;
        linkUrl: string | undefined;
        medium: PodcastMedium | undefined;
        podcastGuid: string | undefined;
        podcastIndexId: string | undefined;
        shrunkImageUrl: string | undefined;
        sortableTitle: string | undefined;
        title: string | undefined;
        value: any;
    };
};
export declare const convertNowPlayingItemToMediaRef: (item?: NowPlayingItem) => {
    endTime: number | undefined;
    episode: {
        alternateEnclosures: any;
        authors: Author[] | undefined;
        chaptersUrl: string | undefined;
        credentialsRequired: boolean;
        description: string | undefined;
        duration: number | undefined;
        funding: any;
        guid: string | undefined;
        id: string | undefined;
        imageUrl: string | undefined;
        linkUrl: string | undefined;
        liveItem: LiveItem | undefined;
        mediaType: string | undefined;
        mediaUrl: string | undefined;
        pubDate: string | undefined;
        socialInteraction: SocialInteraction | undefined;
        subtitle: string | undefined;
        title: string | undefined;
        transcript: any;
        value: any;
        podcast: {
            addByRSSPodcastFeedUrl: string | undefined;
            authors: Author[] | undefined;
            credentialsRequired: boolean | undefined;
            funding: any;
            hasSeasons: boolean | undefined;
            hasVideo: boolean | undefined;
            hideDynamicAdsWarning: boolean | undefined;
            id: string | undefined;
            imageUrl: string | undefined;
            isExplicit: boolean | undefined;
            itunesFeedType: string | undefined;
            linkUrl: string | undefined;
            medium: PodcastMedium | undefined;
            podcastGuid: string | undefined;
            podcastIndexId: string | undefined;
            shrunkImageUrl: string | undefined;
            sortableTitle: string | undefined;
            title: string | undefined;
            value: any;
        };
    };
    id: string | undefined;
    isChapterToc: boolean | null | undefined;
    isOfficialChapter: boolean | undefined;
    isOfficialSoundBite: boolean | undefined;
    isPublic: boolean | undefined;
    linkUrl: string;
    startTime: number | undefined;
    title: string | undefined;
    owner: {
        id: string | undefined;
        isPublic: boolean | undefined;
        name: string | undefined;
    };
};
export declare const convertNowPlayingItemClipToNowPlayingItemEpisode: (data: any, userPlaybackPosition?: number) => {
    addByRSSPodcastFeedUrl: any;
    episodeAlternateEnclosures: any;
    episodeAlternateEnclosureSelected: any;
    episodeAuthors: any;
    episodeChaptersUrl: any;
    episodeCredentialsRequired: any;
    episodeDescription: any;
    episodeDuration: any;
    episodeFunding: any;
    episodeGuid: any;
    episodeId: any;
    episodeImageUrl: any;
    episodeLinkUrl: any;
    episodeMediaType: any;
    episodeMediaUrl: any;
    episodePubDate: any;
    episodeSocialInteraction: any;
    episodeSubtitle: any;
    episodeTitle: any;
    episodeTranscript: any;
    episodeValue: any;
    liveItem: null;
    podcastAuthors: any;
    podcastCredentialsRequired: any;
    podcastFunding: any;
    podcastGuid: any;
    podcastHasSeasons: any;
    podcastHasVideo: any;
    podcastHideDynamicAdsWarning: any;
    podcastId: any;
    podcastImageUrl: any;
    podcastIndexPodcastId: any;
    podcastIsExplicit: any;
    podcastItunesFeedType: any;
    podcastLinkUrl: any;
    podcastMedium: any;
    podcastShrunkImageUrl: any;
    podcastSortableTitle: any;
    podcastTitle: any;
    podcastValue: any;
    userPlaybackPosition: number;
};
export declare const convertToNowPlayingItem: (data: any, inheritedEpisode?: any, inheritedPodcast?: any, userPlaybackPosition?: number) => NowPlayingItem;
export declare const checkIfNowPlayingItem: (item?: any, nowPlayingItem?: any) => any;
export declare const checkIfSameNowPlayingItems: (nowPlayingItem?: any, nowPlayingItem2?: any) => any;
export declare const checkIfVideoFileType: (nowPlayingItem?: NowPlayingItem) => boolean;
export declare const checkIfVideoFileOrVideoLiveType: (mediaType?: string) => boolean;
export declare const haveNowPlayingItemsChanged: (lastItem: NowPlayingItem, nextItem: NowPlayingItem) => boolean | "" | undefined;
