"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeLinebreaks = exports.replaceLinebreaksWithBrTags = exports.removeHTMLFromString = exports.removeExtraInfoFromEpisodeDescription = exports.filterHTMLElementsFromString = exports.decodeHTMLString = void 0;
var he_1 = __importDefault(require("he"));
var checkIfStringContainsHTMLTags = function (text) {
    if (text) {
        // eslint-disable-next-line max-len
        return /<(br|basefont|hr|input|source|frame|param|area|meta|!--|col|link|option|base|img|wbr|!DOCTYPE).*?>|<(a|abbr|acronym|address|applet|article|aside|audio|b|bdi|bdo|big|blockquote|body|button|canvas|caption|center|cite|code|colgroup|command|datalist|dd|del|details|dfn|dialog|dir|div|dl|dt|em|embed|fieldset|figcaption|figure|font|footer|form|frameset|head|header|hgroup|h1|h2|h3|h4|h5|h6|html|i|iframe|ins|kbd|keygen|label|legend|li|map|mark|menu|meter|nav|noframes|noscript|object|ol|optgroup|output|p|pre|progress|q|rp|rt|ruby|s|samp|script|section|select|small|span|strike|strong|style|sub|summary|sup|table|tbody|td|textarea|tfoot|th|thead|time|title|tr|track|tt|u|ul|var|video).*?<\/\2>/i.test(text);
    }
    return false;
};
var decodeHTMLString = function (text) {
    if (text) {
        var limitSingleSpaceRegex = /\s+/g;
        var newString = text.replace(limitSingleSpaceRegex, ' ');
        return he_1.default.decode(newString);
    }
    return text;
};
exports.decodeHTMLString = decodeHTMLString;
var filterHTMLElementsFromString = function (html) {
    if (html) {
        // eslint-disable-next-line max-len
        var finalHtml = html.replace(/<audio.*>.*?<\/audio>|<video.*>.*?<\/video>|<iframe.*>.*?<\/iframe>|<img.*>.*?<\/img>|<img.*?\/>|<img>/gi, '');
        return finalHtml;
    }
    return html;
};
exports.filterHTMLElementsFromString = filterHTMLElementsFromString;
var removeExtraInfoFromEpisodeDescription = function (html) {
    html = html.replace('<p>Episode Summary</p>', '');
    return html.replace(/<p>\s*<\/p>/, '');
};
exports.removeExtraInfoFromEpisodeDescription = removeExtraInfoFromEpisodeDescription;
var removeHTMLFromString = function (text) {
    if (text) {
        var htmlEntitiesRegex = /<[^>]*>?/gm;
        text = text.replace(htmlEntitiesRegex, '');
    }
    return text;
};
exports.removeHTMLFromString = removeHTMLFromString;
var replaceLinebreaksWithBrTags = function (text) {
    if (text && !checkIfStringContainsHTMLTags(text)) {
        var linebreaksRegex = /(?:\r\n|\r|\n)/g;
        text = text.replace(linebreaksRegex, '<br>');
    }
    return text;
};
exports.replaceLinebreaksWithBrTags = replaceLinebreaksWithBrTags;
var removeLinebreaks = function (text) {
    if (text) {
        var linebreaksRegex = /(?:\r\n|\r|\n)/g;
        text = text.replace(linebreaksRegex, ' ');
    }
    return text;
};
exports.removeLinebreaks = removeLinebreaks;
