"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractSelectedEnclosureSourceAndContentType = void 0;
var extractSelectedEnclosureSourceAndContentType = function (nowPlayingItem, alternateEnclosureIndexSelected, alternateEnclosureSourceIndexSelected) {
    var src = '';
    var contentType;
    if (nowPlayingItem === null || nowPlayingItem === void 0 ? void 0 : nowPlayingItem.episodeMediaUrl) {
        src = nowPlayingItem.episodeMediaUrl;
    }
    if (nowPlayingItem === null || nowPlayingItem === void 0 ? void 0 : nowPlayingItem.episodeMediaType) {
        contentType = nowPlayingItem.episodeMediaType;
    }
    if (nowPlayingItem
        && typeof alternateEnclosureIndexSelected !== 'undefined'
        && typeof alternateEnclosureSourceIndexSelected !== 'undefined'
        && typeof alternateEnclosureIndexSelected === 'number'
        && typeof alternateEnclosureSourceIndexSelected === 'number'
        && alternateEnclosureIndexSelected >= 0
        && alternateEnclosureSourceIndexSelected >= 0) {
        var alternateEnclosureSelected = nowPlayingItem.episodeAlternateEnclosures
            && nowPlayingItem.episodeAlternateEnclosures[alternateEnclosureIndexSelected];
        if (alternateEnclosureSelected) {
            var alternateEnclosureSourceSelected = alternateEnclosureSelected.source
                && alternateEnclosureSelected.source[alternateEnclosureSourceIndexSelected];
            if (alternateEnclosureSourceSelected) {
                src = alternateEnclosureSourceSelected.uri;
                contentType = alternateEnclosureSourceSelected.contentType;
            }
        }
    }
    return { contentType: contentType, src: src };
};
exports.extractSelectedEnclosureSourceAndContentType = extractSelectedEnclosureSourceAndContentType;
