"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.combineAndSortPlaylistItems = void 0;
var combineAndSortPlaylistItems = function (episodes, mediaRefs, itemsOrder) {
    var allPlaylistItems = __spreadArray(__spreadArray([], episodes, true), mediaRefs, true);
    var remainingPlaylistItems = [];
    var unsortedItems = allPlaylistItems.filter(function (x) {
        var isSortedItem = Array.isArray(itemsOrder) && itemsOrder.some(function (id) { return x.id === id; });
        if (!isSortedItem) {
            return x;
        }
        else if (x) {
            remainingPlaylistItems.push(x);
        }
    });
    var sortedItems = itemsOrder.reduce(function (results, id) {
        var items = remainingPlaylistItems.filter(function (x) { return x.id === id; });
        if (items.length > 0) {
            results.push(items[0]);
        }
        return results;
    }, []);
    return __spreadArray(__spreadArray([], sortedItems, true), unsortedItems, true);
};
exports.combineAndSortPlaylistItems = combineAndSortPlaylistItems;
