"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.parse = exports.validate = void 0;
const fast_xml_parser_1 = __importDefault(require("fast-xml-parser"));
const he_1 = __importDefault(require("he"));
const parserOptions = {
    attributeNamePrefix: "@_",
    attrNodeName: "attr",
    textNodeName: "#text",
    ignoreAttributes: false,
    ignoreNameSpace: false,
    allowBooleanAttributes: false,
    parseNodeValue: true,
    parseAttributeValue: false,
    trimValues: true,
    // cdataTagName: "__cdata", //default is 'false'
    // cdataPositionChar: "\\c",
    parseTrueNumberOnly: false,
    arrayMode: false,
    tagValueProcessor: (val) => he_1.default.decode(val),
    stopNodes: ["parse-me-as-string"],
};
function validate(xml) {
    return fast_xml_parser_1.default.validate(xml.trim());
}
exports.validate = validate;
function parse(xml) {
    // eslint-disable-next-line @typescript-eslint/no-unsafe-return
    return fast_xml_parser_1.default.parse(xml.trim(), parserOptions);
}
exports.parse = parse;
//# sourceMappingURL=xml-parser.js.map