declare const charSets: {
    default: {
        "&quot;": string;
        "&#34;": string;
        "&apos;": string;
        "&#39;": string;
        "&amp;": string;
        "&#38;": string;
        "&gt;": string;
        "&#62;": string;
        "&lt;": string;
        "&#60;": string;
    };
    extras: {
        "&cent;": string;
        "&#162;": string;
        "&copy;": string;
        "&#169;": string;
        "&euro;": string;
        "&#8364;": string;
        "&pound;": string;
        "&#163;": string;
        "&reg;": string;
        "&#174;": string;
        "&yen;": string;
        "&#165;": string;
    };
    all: {
        "&cent;": string;
        "&#162;": string;
        "&copy;": string;
        "&#169;": string;
        "&euro;": string;
        "&#8364;": string;
        "&pound;": string;
        "&#163;": string;
        "&reg;": string;
        "&#174;": string;
        "&yen;": string;
        "&#165;": string;
        "&quot;": string;
        "&#34;": string;
        "&apos;": string;
        "&#39;": string;
        "&amp;": string;
        "&#38;": string;
        "&gt;": string;
        "&#62;": string;
        "&lt;": string;
        "&#60;": string;
    };
};
/**
 * Convert HTML entities to HTML characters.
 *
 * @param  {String} `str` String with HTML entities to un-escape.
 * @return {String}
 */
export declare function unescape(str: string, type?: keyof typeof charSets): string;
export {};
