"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ItunesFeedType = exports.FeedType = void 0;
var FeedType;
(function (FeedType) {
    FeedType[FeedType["RSS"] = 0] = "RSS";
    FeedType[FeedType["ATOM"] = 1] = "ATOM";
    FeedType[FeedType["BadFormat"] = 9] = "BadFormat";
})(FeedType = exports.FeedType || (exports.FeedType = {}));
var ItunesFeedType;
(function (ItunesFeedType) {
    /**
     * Default Specify episodic when episodes are intended to be consumed without any specific order. Apple
     * Podcasts will present newest episodes first and display the publish date (required) of each episode. If
     * organized into seasons, the newest season will be presented first - otherwise, episodes will be grouped
     * by year published, newest first.
     */
    ItunesFeedType["Episodic"] = "episodic";
    /** Specify serial when episodes are intended to be consumed in sequential order. Apple Podcasts will
     * present the oldest episodes first and display the episode numbers (required) of each episode. If
     * organized into seasons, the newest season will be presented first and <itunes:episode> numbers must be
     * given for each episode.
     *
     * For new subscribers, Apple Podcasts adds the first episode to their Library, or the entire current season
     * if using seasons.
     */
    ItunesFeedType["Serial"] = "serial";
})(ItunesFeedType = exports.ItunesFeedType || (exports.ItunesFeedType = {}));
//# sourceMappingURL=types.js.map