"use strict";
/* eslint-disable @typescript-eslint/no-unsafe-assignment */
/* eslint-disable sonarjs/no-identical-functions */
/* eslint-disable @typescript-eslint/no-unsafe-member-access */
/* eslint-disable @typescript-eslint/no-unsafe-call */
/* eslint-disable sonarjs/cognitive-complexity */
/* eslint-disable @typescript-eslint/explicit-function-return-type */
/* eslint-disable @typescript-eslint/explicit-module-boundary-types */
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractOptionalFloatAttribute = exports.knownLookup = exports.lookup = exports.extractOptionalIntegerAttribute = exports.extractOptionalStringAttribute = exports.getKnownAttribute = exports.getBooleanAttribute = exports.getAttribute = exports.getNumber = exports.sanitizeText = exports.sanitizeMultipleSpaces = exports.sanitizeNewLines = exports.getText = exports.ensureArray = exports.firstWithAttributes = exports.firstWithValue = exports.firstIfArray = exports.isNotUndefined = exports.timeToSeconds = exports.guessEnclosureType = exports.pubDateToDate = exports.pubDateToTimestamp = exports.sanitizeUrl = void 0;
// import iconv from "iconv-lite";
// Make the url safe for storing
function sanitizeUrl(url) {
    let newUrl = "";
    if (typeof url !== "string")
        return "";
    if (containsNonLatinCodepoints(url)) {
        newUrl = encodeURI(url).substring(0, 768);
        if (typeof newUrl !== "string")
            return "";
        if (containsNonLatinCodepoints(newUrl)) {
            // eslint-disable-next-line no-control-regex
            newUrl = newUrl.replace(/[^\x00-\x80]/gi, " ");
        }
        return newUrl.substring(0, 768);
    }
    newUrl = url.substring(0, 768);
    if (typeof newUrl !== "string")
        return "";
    return newUrl;
}
exports.sanitizeUrl = sanitizeUrl;
// Test for non-latin
function containsNonLatinCodepoints(s) {
    // eslint-disable-next-line no-control-regex
    if (/[^\x00-\x80]/.test(s))
        return true;
    // eslint-disable-next-line no-control-regex
    return /[^\u0000-\u00ff]/.test(s);
}
// RFC date convert to unix epoch
function pubDateToTimestamp(pubDate) {
    if (typeof pubDate === "number") {
        return pubDate;
    }
    const date = new Date(pubDate);
    const pubDateParsed = Math.round(date.getTime() / 1000);
    if (Number.isNaN(pubDateParsed)) {
        return 0;
    }
    return pubDateParsed;
}
exports.pubDateToTimestamp = pubDateToTimestamp;
function pubDateToDate(pubDate) {
    if (typeof pubDate === "number") {
        if (new Date(pubDate).getFullYear() === 1970) {
            return new Date(pubDate * 1000);
        }
        return new Date(pubDate);
    }
    const dateFromString = new Date(pubDate);
    if (Number.isNaN(dateFromString.getTime())) {
        return null;
    }
    return dateFromString;
}
exports.pubDateToDate = pubDateToDate;
// Get a mime-type string for an unknown media enclosure
function guessEnclosureType(url = "") {
    if (url.includes(".m4v")) {
        return "video/mp4";
    }
    if (url.includes(".mp4")) {
        return "video/mp4";
    }
    if (url.includes(".avi")) {
        return "video/avi";
    }
    if (url.includes(".mov")) {
        return "video/quicktime";
    }
    if (url.includes(".mp3")) {
        return "audio/mpeg";
    }
    if (url.includes(".m4a")) {
        return "audio/m4a";
    }
    if (url.includes(".wav")) {
        return "audio/wav";
    }
    if (url.includes(".ogg")) {
        return "audio/ogg";
    }
    if (url.includes(".wmv")) {
        return "video/x-ms-wmv";
    }
    return "";
}
exports.guessEnclosureType = guessEnclosureType;
function timeToSeconds(timeString) {
    let seconds = 0;
    const a = timeString.split(":");
    switch (a.length - 1) {
        case 1:
            seconds = +a[0] * 60 + +a[1];
            break;
        case 2:
            seconds = +a[0] * 60 * 60 + +a[1] * 60 + +a[2];
            break;
        default:
            if (timeString !== "")
                seconds = parseInt(timeString, 10);
    }
    // Sometime we get an unparseable value which results in a Nan, in this case return
    // a default of 30 minutes
    if (Number.isNaN(seconds)) {
        seconds = 30 * 60;
    }
    return seconds;
}
exports.timeToSeconds = timeToSeconds;
function isNotUndefined(x) {
    return x !== undefined;
}
exports.isNotUndefined = isNotUndefined;
/** Returns the first value from an array, otherwise, passes the value through */
function firstIfArray(maybeArr) {
    return Array.isArray(maybeArr) ? maybeArr[0] : maybeArr;
}
exports.firstIfArray = firstIfArray;
function firstWithValue(maybeArr) {
    var _a;
    return ((_a = ensureArray(maybeArr).find((x) => typeof x !== "undefined" &&
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        (getText(x) || typeof getNumber(x) === "number" || typeof x === "boolean"))) !== null && _a !== void 0 ? _a : null);
}
exports.firstWithValue = firstWithValue;
function firstWithAttributes(maybeArr, attrs) {
    var _a;
    return (
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    (_a = ensureArray(maybeArr).find((x) => x && attrs.every((a) => hasAttribute(x, a)))) !== null && _a !== void 0 ? _a : null);
}
exports.firstWithAttributes = firstWithAttributes;
/** Will pass through the value if its an array, otherwise, will wrap the value as an array */
function ensureArray(maybeArr) {
    if (typeof maybeArr === "undefined") {
        return [];
    }
    return Array.isArray(maybeArr) ? maybeArr : [maybeArr];
}
exports.ensureArray = ensureArray;
/** Gets the value of the XML node as text */
function getText(node, { sanitize = false } = {}) {
    let text = "";
    if (typeof node === "string") {
        text = node.trim();
    }
    else if (typeof node !== "undefined" && node !== null && typeof node["#text"] === "string") {
        text = node["#text"].trim();
    }
    if (text && sanitize) {
        text = sanitizeText(text);
    }
    return text;
}
exports.getText = getText;
function sanitizeNewLines(text) {
    return text.replace(/(\r\n|\n|\r)/gm, " ");
}
exports.sanitizeNewLines = sanitizeNewLines;
function sanitizeMultipleSpaces(text) {
    return text.replace(/\s{2,}/g, " ");
}
exports.sanitizeMultipleSpaces = sanitizeMultipleSpaces;
function sanitizeText(text) {
    const HIGHEST_POSSIBLE_CHAR_VALUE = 127;
    const GENERIC_REPLACEMENT_CHAR = " ";
    const goodChars = [];
    // Swap out known offenders. Add others as needed.
    // https://unicode-table.com/en/#basic-latin
    const strippedText = text
        .replace(/[\u2014]/g, "--") // emdash
        .replace(/[\u2022]/g, "*") // bullet
        .replace(/[\u2018\u2019]/g, "'") // smart single quotes
        .replace(/[\u201C\u201D]/g, '"'); // smart double quotes
    // Strip out any other offending characters.
    for (let i = 0; i < strippedText.length; i++) {
        if (strippedText.charCodeAt(i) <= HIGHEST_POSSIBLE_CHAR_VALUE) {
            goodChars.push(strippedText.charAt(i));
        }
        else {
            goodChars.push(GENERIC_REPLACEMENT_CHAR);
        }
    }
    return goodChars.join("");
}
exports.sanitizeText = sanitizeText;
/** Gets the value of the XML node as a number */
function getNumber(node) {
    if (typeof node === "number") {
        return node;
    }
    if (typeof node !== "undefined" && node && typeof node["#text"] === "number") {
        return node["#text"];
    }
    return null;
}
exports.getNumber = getNumber;
function hasAttribute(node, name) {
    if (typeof node !== "undefined" && node && typeof node.attr === "object") {
        if (typeof node.attr[`@_${name}`] === "string") {
            return Boolean(node.attr[`@_${name}`].trim());
        }
        return typeof node.attr[`@_${name}`] === "number";
    }
    return false;
}
/** Gets the attribute value from a give node. Returns null if the attribute does not exist */
function getAttribute(node, name) {
    if (typeof node !== "undefined" &&
        node &&
        typeof node.attr === "object" &&
        typeof node.attr[`@_${name}`] === "string") {
        return node.attr[`@_${name}`].trim();
    }
    return null;
}
exports.getAttribute = getAttribute;
/** Gets the attribute value from a give node. Returns false if the attribute does not exist */
function getBooleanAttribute(node, name) {
    if (typeof node !== "undefined" &&
        typeof node.attr === "object" &&
        typeof node.attr[`@_${name}`] === "string") {
        return /^(true|yes)$/i.test(node.attr[`@_${name}`].trim());
    }
    return false;
}
exports.getBooleanAttribute = getBooleanAttribute;
/** Gets the attribute value from a give node. It will throw if the attribute does not exist */
function getKnownAttribute(node, name) {
    if (typeof node !== "undefined" &&
        typeof node.attr === "object" &&
        typeof node.attr[`@_${name}`] === "string") {
        return node.attr[`@_${name}`].trim();
    }
    throw new Error(`Known attribute ${name} was not found in the node.`);
}
exports.getKnownAttribute = getKnownAttribute;
function extractOptionalStringAttribute(node, attrName, key = attrName) {
    const val = getAttribute(node, attrName);
    if (val) {
        return { [key]: val };
    }
    return {};
}
exports.extractOptionalStringAttribute = extractOptionalStringAttribute;
function extractOptionalIntegerAttribute(node, attrName, key = attrName) {
    const val = getAttribute(node, attrName);
    if (val) {
        return { [key]: parseInt(val, 10) };
    }
    return {};
}
exports.extractOptionalIntegerAttribute = extractOptionalIntegerAttribute;
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function keysOf(o) {
    return Object.keys(o);
}
function lookup(stringEnum, s) {
    // eslint-disable-next-line no-restricted-syntax
    for (const enumKey of keysOf(stringEnum)) {
        if (stringEnum[enumKey] === s) {
            // here we have to help the compiler
            // eslint-disable-next-line @typescript-eslint/no-unnecessary-type-assertion, @typescript-eslint/no-unsafe-return
            return stringEnum[enumKey];
        }
    }
    return undefined;
}
exports.lookup = lookup;
function knownLookup(stringEnum, s) {
    const lookupValue = lookup(stringEnum, s);
    if (lookupValue) {
        // eslint-disable-next-line @typescript-eslint/no-unsafe-return
        return lookupValue;
    }
    throw new Error("Known value didn't exist, ");
}
exports.knownLookup = knownLookup;
function extractOptionalFloatAttribute(node, attrName, key = attrName) {
    const val = getAttribute(node, attrName);
    if (val) {
        return { [key]: parseFloat(val) };
    }
    return {};
}
exports.extractOptionalFloatAttribute = extractOptionalFloatAttribute;
//# sourceMappingURL=shared.js.map