"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.liveItem = exports.Phase4LiveStatus = exports.podcastImages = exports.medium = exports.Phase4Medium = exports.value = void 0;
/* eslint-disable @typescript-eslint/no-unsafe-assignment */
const logger_1 = require("../../logger");
const shared_1 = require("../shared");
const ItemParser = __importStar(require("../item"));
const types_1 = require("./types");
const phase_2_1 = require("./phase-2");
const phase_3_1 = require("./phase-3");
// eslint-disable-next-line @typescript-eslint/no-unsafe-return
const defaultNodeTransform = (x) => x;
const defaultSupportCheck = (x) => typeof x === "object";
const validRecipient = (n) => Boolean(shared_1.getAttribute(n, "type") && shared_1.getAttribute(n, "address") && shared_1.getAttribute(n, "split"));
exports.value = {
    phase: 4,
    tag: "podcast:value",
    name: "value",
    nodeTransform: shared_1.firstIfArray,
    supportCheck: (node) => Boolean(shared_1.getAttribute(node, "type")) &&
        Boolean(shared_1.getAttribute(node, "method")) &&
        // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
        shared_1.ensureArray(node["podcast:valueRecipient"]).filter(validRecipient).length > 0,
    fn(node) {
        return {
            value: {
                type: shared_1.getKnownAttribute(node, "type"),
                method: shared_1.getKnownAttribute(node, "method"),
                ...shared_1.extractOptionalFloatAttribute(node, "suggested"),
                // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
                recipients: shared_1.ensureArray(node["podcast:valueRecipient"])
                    .filter(validRecipient)
                    .map((innerNode) => ({
                    ...shared_1.extractOptionalStringAttribute(innerNode, "name"),
                    ...shared_1.extractOptionalStringAttribute(innerNode, "customKey"),
                    ...shared_1.extractOptionalStringAttribute(innerNode, "customValue"),
                    type: shared_1.getKnownAttribute(innerNode, "type"),
                    address: shared_1.getKnownAttribute(innerNode, "address"),
                    split: parseInt(shared_1.getKnownAttribute(innerNode, "split"), 10),
                    fee: shared_1.getBooleanAttribute(innerNode, "fee"),
                })),
            },
        };
    },
};
/**
 * https://github.com/Podcastindex-org/podcast-namespace/blob/main/docs/1.0.md#medium
 *
 */
var Phase4Medium;
(function (Phase4Medium) {
    /** Describes a feed for a podcast show. If no medium tag is present in the channel, this medium is assumed. */
    Phase4Medium["Podcast"] = "podcast";
    /** A feed of music organized into an "album" with each item a song within the album */
    Phase4Medium["Music"] = "music";
    /** Like a "podcast" but used in a more visual experience. Something akin to a dedicated video channel like would be found on YouTube */
    Phase4Medium["Video"] = "video";
    /** Specific types of videos with one item per feed. This is different than a video medium because the content is considered to be cinematic; like a movie or documentary */
    Phase4Medium["Film"] = "film";
    /** Specific types of audio with one item per feed, or where items represent chapters within the book */
    Phase4Medium["Audiobook"] = "audiobook";
    /** a feed of curated written articles. Newsletter articles now sometimes have an spoken version audio enclosure attached */
    Phase4Medium["Newsletter"] = "newsletter";
    /** a feed of informally written articles. Similar to newsletter but more informal as in a traditional blog platform style */
    Phase4Medium["Blog"] = "blog";
})(Phase4Medium = exports.Phase4Medium || (exports.Phase4Medium = {}));
exports.medium = {
    tag: "podcast:medium",
    name: "medium",
    phase: 4,
    nodeTransform: (node) => 
    // eslint-disable-next-line @typescript-eslint/no-unsafe-return
    shared_1.ensureArray(node).find((n) => shared_1.getText(n) && shared_1.lookup(Phase4Medium, shared_1.getText(n).toLowerCase())),
    supportCheck: (node) => Boolean(node) && Boolean(shared_1.getText(node)),
    fn(node) {
        const nodeValue = shared_1.getText(node);
        if (nodeValue) {
            const parsed = shared_1.lookup(Phase4Medium, nodeValue.toLowerCase());
            if (parsed) {
                return { medium: parsed };
            }
        }
        throw new Error("Unable to extract medium from feed, `supportCheck` needs to be updated");
    },
};
exports.podcastImages = {
    phase: 4,
    name: "images",
    tag: "podcast:images",
    nodeTransform: (node) => 
    // eslint-disable-next-line @typescript-eslint/no-unsafe-return
    shared_1.ensureArray(node).find((n) => shared_1.getAttribute(n, "srcset")),
    supportCheck: (node) => Boolean(node),
    fn(node) {
        return {
            podcastImages: shared_1.getKnownAttribute(node, "srcset")
                .split(",")
                .reduce((acc, n) => {
                const raw = n.trim();
                if (raw) {
                    const components = raw.split(/\s+/);
                    const val = { raw };
                    if (components.length === 2) {
                        if (components[1].endsWith("w")) {
                            val.parsed = {
                                url: components[0],
                                width: parseInt(components[1].replace(/w$/, ""), 10),
                            };
                        }
                        else if (components[1].endsWith("x")) {
                            val.parsed = {
                                url: components[0],
                                density: parseFloat(components[1].replace(/x$/, "")),
                            };
                        }
                        else {
                            logger_1.logger.warn(components, "Unexpected descriptor");
                            val.parsed = {
                                url: components[0],
                            };
                        }
                    }
                    else {
                        val.parsed = { url: raw };
                    }
                    return [...acc, val];
                }
                return acc;
            }, []),
        };
    },
};
function getContentLinks(node) {
    // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
    return shared_1.ensureArray(node["podcast:contentLink"]).map((cln) => {
        var _a;
        return ({
            title: shared_1.getText(cln),
            url: (_a = shared_1.getAttribute(cln, "href")) !== null && _a !== void 0 ? _a : "",
        });
    });
}
var Phase4LiveStatus;
(function (Phase4LiveStatus) {
    Phase4LiveStatus["Pending"] = "pending";
    Phase4LiveStatus["Live"] = "live";
    Phase4LiveStatus["Ended"] = "ended";
})(Phase4LiveStatus = exports.Phase4LiveStatus || (exports.Phase4LiveStatus = {}));
exports.liveItem = {
    phase: 4,
    tag: "podcast:liveItem",
    name: "liveItem",
    nodeTransform: (node) => 
    // eslint-disable-next-line @typescript-eslint/no-unsafe-return
    shared_1.ensureArray(node).filter((n) => Boolean(n &&
        shared_1.getAttribute(n, "status") &&
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        shared_1.lookup(Phase4LiveStatus, shared_1.getAttribute(n, "status").toLowerCase()) &&
        shared_1.getAttribute(n, "start"))),
    supportCheck: (node) => node.length > 0,
    fn(node) {
        const useParser = (itemUpdate, n, item) => {
            var _a, _b;
            // eslint-disable-next-line @typescript-eslint/no-unsafe-assignment, @typescript-eslint/no-unsafe-member-access
            const nodeContents = n[itemUpdate.tag];
            if (nodeContents) {
                // eslint-disable-next-line @typescript-eslint/no-unsafe-assignment
                const transformedNode = ((_a = itemUpdate.nodeTransform) !== null && _a !== void 0 ? _a : defaultNodeTransform)(nodeContents);
                if (transformedNode &&
                    ((_b = itemUpdate.supportCheck) !== null && _b !== void 0 ? _b : defaultSupportCheck)(transformedNode, types_1.XmlNodeSource.Item)) {
                    Object.assign(item, itemUpdate.fn(transformedNode, {}, types_1.XmlNodeSource.Item));
                }
            }
        };
        return {
            podcastLiveItems: node
                .map((n) => {
                const guid = ItemParser.getGuid(n);
                const title = ItemParser.getTitle(n);
                const enclosure = ItemParser.getEnclosure(n);
                if (!(guid && title && enclosure)) {
                    return {};
                }
                // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
                const transformed = exports.value.nodeTransform(n[exports.value.tag]);
                const v = transformed && exports.value.supportCheck(transformed) ? exports.value.fn(transformed) : undefined;
                const chat = shared_1.getAttribute(n, "chat");
                const item = {
                    guid,
                    enclosure,
                    ...title,
                    ...ItemParser.getDescription(n),
                    ...ItemParser.getLink(n),
                    ...ItemParser.getAuthor(n),
                    ...ItemParser.getImage(n),
                    ...(chat ? { chat } : undefined),
                    ...v,
                };
                useParser(phase_2_1.person, n, item);
                useParser(phase_3_1.liveItemAlternativeEnclosure, n, item);
                useParser(exports.podcastImages, n, item);
                return {
                    status: shared_1.knownLookup(Phase4LiveStatus, shared_1.getKnownAttribute(n, "status").toLowerCase()),
                    start: shared_1.pubDateToDate(shared_1.getKnownAttribute(n, "start")),
                    ...(shared_1.getAttribute(n, "end")
                        ? { end: shared_1.pubDateToDate(shared_1.getKnownAttribute(n, "end")) }
                        : undefined),
                    ...(Object.keys(item).length > 0 ? item : undefined),
                    contentLinks: getContentLinks(n),
                };
            })
                .filter((x) => Boolean("start" in x)),
        };
    },
};
//# sourceMappingURL=phase-4.js.map