"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.guid = exports.liveItemAlternativeEnclosure = exports.alternativeEnclosure = exports.license = exports.trailer = void 0;
/* eslint-disable @typescript-eslint/no-unsafe-member-access */
/* eslint-disable @typescript-eslint/no-unsafe-assignment */
const shared_1 = require("../shared");
const logger_1 = require("../../logger");
const licenses_1 = require("./licenses");
exports.trailer = {
    phase: 3,
    tag: "podcast:trailer",
    name: "trailer",
    supportCheck: (node) => {
        const fNode = shared_1.firstIfArray(node);
        return (Boolean(shared_1.getText(fNode)) &&
            Boolean(shared_1.getAttribute(fNode, "url")) &&
            Boolean(shared_1.getAttribute(fNode, "pubdate")));
    },
    fn(node) {
        return {
            trailers: shared_1.ensureArray(node).map((trailerNode) => ({
                title: shared_1.getText(trailerNode),
                url: shared_1.getKnownAttribute(trailerNode, "url"),
                pubdate: new Date(shared_1.getKnownAttribute(trailerNode, "pubdate")),
                ...shared_1.extractOptionalStringAttribute(trailerNode, "type"),
                ...shared_1.extractOptionalIntegerAttribute(trailerNode, "length"),
                ...shared_1.extractOptionalIntegerAttribute(trailerNode, "season"),
            })),
        };
    },
};
exports.license = {
    phase: 3,
    tag: "podcast:license",
    name: "license",
    nodeTransform: shared_1.firstIfArray,
    supportCheck: (node) => {
        var _a, _b;
        const identifier = shared_1.getText(node);
        const url = (_a = shared_1.getAttribute(node, "url")) !== null && _a !== void 0 ? _a : (_b = licenses_1.json.licenses.find((l) => l.licenseId.toLowerCase() === identifier.toLowerCase())) === null || _b === void 0 ? void 0 : _b.reference;
        return Boolean(identifier) && Boolean(url);
    },
    fn(node, feed) {
        var _a, _b;
        const identifier = shared_1.getText(node);
        const url = (_a = shared_1.getAttribute(node, "url")) !== null && _a !== void 0 ? _a : (_b = licenses_1.json.licenses.find((l) => l.licenseId.toLowerCase() === identifier.toLowerCase())) === null || _b === void 0 ? void 0 : _b.reference;
        if (!url) {
            logger_1.logger.warn(`Missing License URL for ${identifier}, originating in ${feed.rss.channel.title}`);
            return {};
        }
        logger_1.logger.debug(`license  [${identifier}](${url})`);
        return {
            license: {
                identifier,
                url,
            },
        };
    },
};
var IntegrityType;
(function (IntegrityType) {
    IntegrityType["SRI"] = "sri";
    IntegrityType["PGP"] = "pgp-signature";
})(IntegrityType || (IntegrityType = {}));
const podcastSource = "podcast:source";
exports.alternativeEnclosure = {
    phase: 3,
    tag: "podcast:alternateEnclosure",
    name: "alternateEnclosure",
    nodeTransform: shared_1.ensureArray,
    supportCheck: (node) => {
        return node.some((i) => {
            var _a;
            const type = shared_1.getAttribute(i, "type");
            const length = shared_1.getAttribute(i, "length");
            const sourceNodes = shared_1.ensureArray((_a = i === null || i === void 0 ? void 0 : i[podcastSource]) !== null && _a !== void 0 ? _a : []);
            return (Boolean(type) &&
                Boolean(length) &&
                sourceNodes.length > 0 &&
                sourceNodes.some((n) => shared_1.getAttribute(n, "uri")));
        });
    },
    fn(node, _feed) {
        const update = [];
        node
            .filter((n) => shared_1.getAttribute(n, "length") && shared_1.getAttribute(n, "type"))
            .forEach((altEncNode) => {
            var _a, _b;
            const type = shared_1.getKnownAttribute(altEncNode, "type");
            const length = shared_1.getKnownAttribute(altEncNode, "length");
            const sourceUris = shared_1.ensureArray((_a = altEncNode[podcastSource]) !== null && _a !== void 0 ? _a : [])
                .map((sourceNode) => ({
                uri: shared_1.getAttribute(sourceNode, "uri"),
                contentType: shared_1.getAttribute(sourceNode, "contentType"),
            }))
                .filter((x) => x.uri !== null && Boolean(x.uri.trim()))
                .map((x) => ({ ...x, contentType: x.contentType || type }));
            const integrityNode = altEncNode["podcast:integrity"];
            const integrity = integrityNode &&
                shared_1.getAttribute(integrityNode, "type") &&
                shared_1.getAttribute(integrityNode, "value")
                ? {
                    type: shared_1.getKnownAttribute(integrityNode, "type") === IntegrityType.PGP
                        ? IntegrityType.PGP
                        : IntegrityType.SRI,
                    value: shared_1.getKnownAttribute(integrityNode, "value"),
                }
                : null;
            if (type && length && sourceUris.length > 0) {
                update.push({
                    type,
                    length: parseInt(length, 10),
                    source: sourceUris,
                    default: /^true$/i.test((_b = shared_1.getAttribute(altEncNode, "default")) !== null && _b !== void 0 ? _b : ""),
                    ...(integrity ? { integrity } : undefined),
                    ...shared_1.extractOptionalFloatAttribute(altEncNode, "bitrate"),
                    ...shared_1.extractOptionalIntegerAttribute(altEncNode, "height"),
                    ...shared_1.extractOptionalStringAttribute(altEncNode, "lang"),
                    ...shared_1.extractOptionalStringAttribute(altEncNode, "title"),
                    ...shared_1.extractOptionalStringAttribute(altEncNode, "rel"),
                    ...shared_1.extractOptionalStringAttribute(altEncNode, "codecs"),
                });
            }
        });
        return { alternativeEnclosures: update };
    },
};
exports.liveItemAlternativeEnclosure = {
    phase: 3,
    tag: "podcast:alternateEnclosure",
    name: "alternateEnclosure",
    nodeTransform: shared_1.ensureArray,
    supportCheck: (node) => {
        return node.some((i) => {
            var _a;
            const type = shared_1.getAttribute(i, "type");
            const sourceNodes = shared_1.ensureArray((_a = i === null || i === void 0 ? void 0 : i[podcastSource]) !== null && _a !== void 0 ? _a : []);
            return (Boolean(type) && sourceNodes.length > 0 && sourceNodes.some((n) => shared_1.getAttribute(n, "uri")));
        });
    },
    fn(node, _feed) {
        const update = [];
        node
            .filter((n) => shared_1.getAttribute(n, "type"))
            .forEach((altEncNode) => {
            var _a, _b;
            const type = shared_1.getKnownAttribute(altEncNode, "type");
            const sourceUris = shared_1.ensureArray((_a = altEncNode[podcastSource]) !== null && _a !== void 0 ? _a : [])
                .map((sourceNode) => ({
                uri: shared_1.getAttribute(sourceNode, "uri"),
                contentType: shared_1.getAttribute(sourceNode, "contentType"),
            }))
                .filter((x) => x.uri !== null && Boolean(x.uri.trim()))
                .map((x) => ({ ...x, contentType: x.contentType || type }));
            const integrityNode = altEncNode["podcast:integrity"];
            const integrity = integrityNode &&
                shared_1.getAttribute(integrityNode, "type") &&
                shared_1.getAttribute(integrityNode, "value")
                ? {
                    type: shared_1.getKnownAttribute(integrityNode, "type") === IntegrityType.PGP
                        ? IntegrityType.PGP
                        : IntegrityType.SRI,
                    value: shared_1.getKnownAttribute(integrityNode, "value"),
                }
                : null;
            if (type && sourceUris.length > 0) {
                update.push({
                    type,
                    length: 0,
                    source: sourceUris,
                    default: /^true$/i.test((_b = shared_1.getAttribute(altEncNode, "default")) !== null && _b !== void 0 ? _b : ""),
                    ...(integrity ? { integrity } : undefined),
                    ...shared_1.extractOptionalFloatAttribute(altEncNode, "bitrate"),
                    ...shared_1.extractOptionalIntegerAttribute(altEncNode, "height"),
                    ...shared_1.extractOptionalStringAttribute(altEncNode, "lang"),
                    ...shared_1.extractOptionalStringAttribute(altEncNode, "title"),
                    ...shared_1.extractOptionalStringAttribute(altEncNode, "rel"),
                    ...shared_1.extractOptionalStringAttribute(altEncNode, "codecs"),
                });
            }
        });
        return { alternativeEnclosures: update };
    },
};
/**
 * https://github.com/Podcastindex-org/podcast-namespace/blob/main/docs/1.0.md#integrity
 *
 * This element is used to declare a unique, global identifier for a podcast. The value is a UUIDv5, and
 * is easily generated from the RSS feed url, with the protocol scheme and trailing slashes stripped off,
 * combined with a unique "podcast" namespace which has a UUID of ead4c236-bf58-58c6-a2c6-a6b28d128cb6.
 *
 * A podcast gets assigned a podcast:guid once in its lifetime using its current feed url (at the time of
 * assignment) as the seed value. That GUID is then meant to follow the podcast from then on, for the
 * duration of its life, even if the feed url changes. This means that when a podcast moves from one hosting
 * platform to another, its podcast:guid should be discovered by the new host and imported into the new
 * platform for inclusion into the feed.
 */
exports.guid = {
    phase: 3,
    tag: "podcast:guid",
    name: "guid",
    supportCheck: (node) => Boolean(shared_1.getText(node)),
    fn(node, _feed) {
        return {
            guid: shared_1.getText(node),
        };
    },
};
//# sourceMappingURL=phase-3.js.map