"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.episode = exports.season = exports.location = exports.person = void 0;
const shared_1 = require("../shared");
const person_enum_1 = require("../person-enum");
exports.person = {
    phase: 2,
    tag: "podcast:person",
    name: "person",
    nodeTransform: shared_1.ensureArray,
    // As long as one of the person tags has text, we'll consider it valid
    supportCheck: (node) => node.some((n) => Boolean(shared_1.getText(n))),
    fn(node) {
        const podcastPeople = [];
        const groups = Object.values(person_enum_1.PersonGroup);
        const roles = Object.values(person_enum_1.PersonRole);
        node.forEach((personNode) => {
            var _a, _b;
            const name = shared_1.getText(personNode);
            const role = (_a = roles.find((r) => { var _a; return r.toLowerCase() === ((_a = shared_1.getAttribute(personNode, "role")) === null || _a === void 0 ? void 0 : _a.toLowerCase()); })) !== null && _a !== void 0 ? _a : person_enum_1.PersonRole.Host;
            const group = (_b = groups.find((g) => { var _a; return g.toLowerCase() === ((_a = shared_1.getAttribute(personNode, "group")) === null || _a === void 0 ? void 0 : _a.toLowerCase()); })) !== null && _b !== void 0 ? _b : person_enum_1.PersonGroup.Cast;
            const img = shared_1.getAttribute(personNode, "img");
            const href = shared_1.getAttribute(personNode, "href");
            if (name) {
                const personObj = {
                    name,
                    role,
                    group,
                };
                if (img) {
                    personObj.img = img;
                }
                if (href) {
                    personObj.href = href;
                }
                podcastPeople.push(personObj);
            }
        });
        return { podcastPeople };
    },
};
exports.location = {
    phase: 2,
    tag: "podcast:location",
    name: "location",
    nodeTransform: shared_1.firstIfArray,
    supportCheck: (node) => Boolean(shared_1.getText(node)),
    fn(node) {
        const update = {
            podcastLocation: { name: shared_1.getText(node) },
        };
        const openStreetMaps = shared_1.getAttribute(node, "osm");
        const geoUri = shared_1.getAttribute(node, "geo");
        if (openStreetMaps) {
            update.podcastLocation.osm = openStreetMaps;
        }
        if (geoUri) {
            update.podcastLocation.geo = geoUri;
        }
        return update;
    },
};
exports.season = {
    phase: 2,
    tag: "podcast:season",
    name: "season",
    nodeTransform: shared_1.firstIfArray,
    supportCheck: (node) => Boolean(shared_1.getNumber(node)),
    fn(node) {
        const itemUpdate = {
            podcastSeason: {
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                number: Math.floor(shared_1.getNumber(node)),
            },
        };
        const name = shared_1.getAttribute(node, "name");
        if (name) {
            itemUpdate.podcastSeason.name = name;
        }
        return itemUpdate;
    },
};
exports.episode = {
    phase: 2,
    tag: "podcast:episode",
    name: "episode",
    nodeTransform: shared_1.firstIfArray,
    supportCheck: (node) => Boolean(shared_1.getNumber(node)),
    fn(node) {
        const itemUpdate = {
            podcastEpisode: {
                number: shared_1.getNumber(node),
            },
        };
        const display = shared_1.getAttribute(node, "display");
        if (display) {
            itemUpdate.podcastEpisode.display = display;
        }
        return itemUpdate;
    },
};
//# sourceMappingURL=phase-2.js.map