import type { FeedUpdate, ItemUpdate } from "./index";
/**
 * https://github.com/Podcastindex-org/podcast-namespace/blob/main/docs/1.0.md#locked
 *
 * This tag may be set to yes or no. The purpose is to tell other podcast platforms whether they are
 * allowed to import this feed. A value of yes means that any attempt to import this feed into a new
 * platform should be rejected.
 */
export declare const locked: FeedUpdate;
/**
 * https://github.com/Podcastindex-org/podcast-namespace/blob/main/docs/1.0.md#transcript
 *
 * This tag is used to link to a transcript or closed captions file. Multiple tags can be present for
 * multiple transcript formats.
 */
export declare type Phase1Transcript = {
    /** URL of the podcast transcript */
    url: string;
    /** Mime type of the file such as text/plain, text/html, application/srt, text/vtt, application/json */
    type: TranscriptType;
    /** The language of the linked transcript. If there is no language attribute given, the linked file is assumed to be the same language that is specified by the RSS <language> element. */
    language?: string;
    /**  If the rel="captions" attribute is present, the linked file is considered to be a closed captions file, regardless of what the mime type is. In that scenario, time codes are assumed to be present in the file in some capacity. */
    rel?: "captions";
};
export declare enum TranscriptType {
    Plain = "text/plain",
    HTML = "text/html",
    SRT = "application/srt",
    JSON = "application/json",
    UNKNOWN = "unknown"
}
export declare const transcript: ItemUpdate;
/**
 * https://github.com/Podcastindex-org/podcast-namespace/blob/main/docs/1.0.md#funding
 *
 * This tag lists possible donation/funding links for the podcast. The content of the tag is the recommended
 * string to be used with the link.
 */
export declare type Phase1Funding = {
    message: string;
    url: string;
};
export declare const funding: FeedUpdate;
/**
 * https://github.com/Podcastindex-org/podcast-namespace/blob/main/docs/1.0.md#chapters
 *
 * Links to an external file containing chapter data for the episode.
 */
export declare type Phase1Chapter = {
    /** The URL where the chapters file is located */
    url: string;
    /** Mime type of file - JSON preferred, 'application/json+chapters' */
    type: string;
};
export declare const chapters: ItemUpdate;
/**
 * https://github.com/Podcastindex-org/podcast-namespace/blob/main/docs/1.0.md#soundbite
 *
 * Points to one or more soundbites within a podcast episode. The intended use includes episodes previews,
 * discoverability, audiogram generation, episode highlights, etc. It should be assumed that the
 * audio/video source of the soundbite is the audio/video given in the item's <enclosure> element.
 */
export declare type Phase1SoundBite = {
    /**  How long is the soundbite (recommended between 15 and 120 seconds) */
    duration: number;
    /** The time where the soundbite begins */
    startTime: number;
    /** The title of the soundbite, if one isn't provided it will fallback to the title of the episode */
    title: string;
};
export declare const soundbite: ItemUpdate;
