import type { Episode, FeedObject, RSSFeed, XmlNode, PhaseUpdate, TODO } from "../types";
import { XmlNodeSource } from "./types";
declare type FeedUpdateResult = {
    feedUpdate: Partial<FeedObject>;
    phaseUpdate: PhaseUpdate;
};
declare type ItemUpdateResult = {
    itemUpdate: Partial<Episode>;
    phaseUpdate: PhaseUpdate;
};
declare type NodeTransform = (x: XmlNode) => TODO;
declare type SupportCheck = (x: TODO, type: XmlNodeSource) => boolean;
/** Describes a Feed processing object intended to provide extensible feed parsing */
export declare type FeedUpdate = {
    /** What phase was this added to the namespace */
    phase: number;
    /** What is the name of the tag, expected to "transcript" for <podcast:transcript> */
    tag: string;
    /** What is the name of feature, falls back to tag if missing */
    name?: string;
    /** Processing function to return an object to be merged with the current feed */
    fn: (node: XmlNode, feed: RSSFeed, type: XmlNodeSource) => Partial<FeedObject>;
    /** An optional function to transform the node before calling both the support and processing functions */
    nodeTransform?: NodeTransform;
    /** An optional function to determine if the tag meets the requirements for processing (eg. has required attributes or value) */
    supportCheck?: SupportCheck;
};
/** Describes an Item processing object intended to provide extensible item parsing */
export declare type ItemUpdate = {
    /** What phase was this added to the namespace */
    phase: number;
    /** What is the name of the tag, expected to "transcript" for <podcast:transcript> */
    tag: string;
    /** What is the name of feature, falls back to tag if missing */
    name?: string;
    /** Processing function to return an object to be merged with the current item */
    fn: (node: XmlNode, feed: RSSFeed, type: XmlNodeSource) => Partial<Episode>;
    /** An optional function to transform the node before calling both the support and processing functions */
    nodeTransform?: NodeTransform;
    /** An optional function to determine if the tag meets the requirements for processing (eg. has required attributes or value) */
    supportCheck?: SupportCheck;
};
export declare const defaultNodeTransform: NodeTransform;
export declare const defaultSupportCheck: SupportCheck;
export declare function updateFeed(theFeed: RSSFeed, feedUpdates?: FeedUpdate[]): FeedUpdateResult;
export declare function updateItem(item: XmlNode, feed: RSSFeed, itemUpdates?: ItemUpdate[]): ItemUpdateResult;
export {};
