"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseFeed = void 0;
/* eslint-disable @typescript-eslint/no-unsafe-call */
/* eslint-disable @typescript-eslint/no-unsafe-assignment */
/* eslint-disable @typescript-eslint/no-unsafe-member-access */
/* eslint-disable @typescript-eslint/restrict-plus-operands */
/* eslint-disable @typescript-eslint/no-unsafe-return */
/* eslint-disable @typescript-eslint/explicit-function-return-type */
const logger_1 = require("../logger");
const unified_1 = require("./unified");
const xml_parser_1 = require("./xml-parser");
const types_1 = require("./types");
function parseFeed(xml, options) {
    const parsedContent = xml_parser_1.validate(xml.trim());
    if (parsedContent === true) {
        return handleValidFeed(xml, options);
    }
    return handleInvalidFeed(xml);
}
exports.parseFeed = parseFeed;
function handleValidFeed(xml, options) {
    const theFeed = xml_parser_1.parse(xml.trim());
    let feedObj;
    if (typeof theFeed.rss === "object") {
        feedObj = unified_1.unifiedParser(theFeed, types_1.FeedType.RSS, options);
    }
    else if (typeof theFeed.feed === "object") {
        feedObj = unified_1.unifiedParser(theFeed, types_1.FeedType.ATOM, options);
    }
    else {
        // Unsupported
        return null;
    }
    if (!feedObj) {
        logger_1.logger.error("Parsing failed...");
        return null;
    }
    return feedObj;
}
function handleInvalidFeed(xml) {
    logger_1.logger.warn("invalid feed");
    logger_1.logger.warn(xml);
    return null;
}
//# sourceMappingURL=index.js.map