'use strict';var _slicedToArray = function () {function sliceIterator(arr, i) {var _arr = [];var _n = true;var _d = false;var _e = undefined;try {for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {_arr.push(_s.value);if (i && _arr.length === i) break;}} catch (err) {_d = true;_e = err;} finally {try {if (!_n && _i["return"]) _i["return"]();} finally {if (_d) throw _e;}}return _arr;}return function (arr, i) {if (Array.isArray(arr)) {return arr;} else if (Symbol.iterator in Object(arr)) {return sliceIterator(arr, i);} else {throw new TypeError("Invalid attempt to destructure non-iterable instance");}};}();var _docsUrl = require('../docsUrl');var _docsUrl2 = _interopRequireDefault(_docsUrl);function _interopRequireDefault(obj) {return obj && obj.__esModule ? obj : { 'default': obj };}

function getEmptyBlockRange(tokens, index) {
  var token = tokens[index];
  var nextToken = tokens[index + 1];
  var prevToken = tokens[index - 1];
  var start = token.range[0];
  var end = nextToken.range[1];

  // Remove block tokens and the previous comma
  if (prevToken.value === ',' || prevToken.value === 'type' || prevToken.value === 'typeof') {
    start = prevToken.range[0];
  }

  return [start, end];
}

module.exports = {
  meta: {
    type: 'suggestion',
    docs: {
      category: 'Helpful warnings',
      description: 'Forbid empty named import blocks.',
      url: (0, _docsUrl2['default'])('no-empty-named-blocks') },

    fixable: 'code',
    schema: [],
    hasSuggestions: true },


  create: function () {function create(context) {
      return {
        Program: function () {function Program(node) {
            node.tokens.forEach(function (token, idx) {
              var nextToken = node.tokens[idx + 1];

              if (nextToken && token.value === '{' && nextToken.value === '}') {
                var hasOtherIdentifiers = node.tokens.some(function (token) {return (
                    token.type === 'Identifier' &&
                    token.value !== 'from' &&
                    token.value !== 'type' &&
                    token.value !== 'typeof');});


                // If it has no other identifiers it's the only thing in the import, so we can either remove the import
                // completely or transform it in a side-effects only import
                if (!hasOtherIdentifiers) {
                  context.report({
                    node: node,
                    message: 'Unexpected empty named import block',
                    suggest: [
                    {
                      desc: 'Remove unused import',
                      fix: function () {function fix(fixer) {
                          // Remove the whole import
                          return fixer.remove(node);
                        }return fix;}() },

                    {
                      desc: 'Remove empty import block',
                      fix: function () {function fix(fixer) {
                          // Remove the empty block and the 'from' token, leaving the import only for its side
                          // effects, e.g. `import 'mod'`
                          var sourceCode = context.getSourceCode();
                          var fromToken = node.tokens.find(function (t) {return t.value === 'from';});
                          var importToken = node.tokens.find(function (t) {return t.value === 'import';});
                          var hasSpaceAfterFrom = sourceCode.isSpaceBetween(fromToken, sourceCode.getTokenAfter(fromToken));
                          var hasSpaceAfterImport = sourceCode.isSpaceBetween(importToken, sourceCode.getTokenAfter(fromToken));var _getEmptyBlockRange =

                          getEmptyBlockRange(node.tokens, idx),_getEmptyBlockRange2 = _slicedToArray(_getEmptyBlockRange, 1),start = _getEmptyBlockRange2[0];var _fromToken$range = _slicedToArray(
                          fromToken.range, 2),end = _fromToken$range[1];
                          var range = [start, hasSpaceAfterFrom ? end + 1 : end];

                          return fixer.replaceTextRange(range, hasSpaceAfterImport ? '' : ' ');
                        }return fix;}() }] });



                } else {
                  context.report({
                    node: node,
                    message: 'Unexpected empty named import block',
                    fix: function () {function fix(fixer) {
                        return fixer.removeRange(getEmptyBlockRange(node.tokens, idx));
                      }return fix;}() });

                }
              }
            });
          }return Program;}() };

    }return create;}() };
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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