"use strict";

/*
  Copyright (C) 2014 Yusuke Suzuki <utatane.tea@gmail.com>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

function compare(v1, v2) {
  return v1 < v2;
}

function upperBound(array, value, comp) {
  if (comp === undefined) comp = compare;
  return (function () {
    var len = array.length;
    var i = 0;

    while (len) {
      var diff = len >>> 1;
      var cursor = i + diff;
      if (comp(value, array[cursor])) {
        len = diff;
      } else {
        i = cursor + 1;
        len -= diff + 1;
      }
    }
    return i;
  })();
}

function lowerBound(array, value, comp) {
  if (comp === undefined) comp = compare;
  return (function () {
    var len = array.length;
    var i = 0;

    while (len) {
      var diff = len >>> 1;
      var cursor = i + diff;
      if (comp(array[cursor], value)) {
        i = cursor + 1;
        len -= diff + 1;
      } else {
        len = diff;
      }
    }
    return i;
  })();
}

function binarySearch(array, value, comp) {
  if (comp === undefined) comp = compare;
  return (function () {
    var cursor = lowerBound(array, value, comp);
    return cursor !== array.length && !comp(value, array[cursor]);
  })();
}

exports.compare = compare;
exports.lowerBound = lowerBound;
exports.upperBound = upperBound;
exports.binarySearch = binarySearch;
//# sourceMappingURL=data:application/json;base64,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