# Podverse Mobile App Translation Context Document

## About

This document is intended for Podverse translators. The purpose is to provide additional context for base language text that we've been told is unclear or confusing, so it will be easier to translate.

Each section should contain the full key and value pair as it appears in the [/podverse-rn/src/resources/i18n/translations/en.json](https://github.com/podverse/podverse-rn/blob/develop/src/resources/i18n/translations/en.json) base language file, and the sections should appear in the same order (alphabetically by key) as they appear in the en.json file.

## How to request context be added to this document

If you know how to make a Pull Request, we'd appreciate if you can add key/value pairs to the "Base language text with extra context" section for key/value pairs that you found unclear or confusing.

If you don't know how to make a Pull Request, then you can leave a comment on the confusing text in [our Weblate](https://hosted.weblate.org/projects/podverse/), or you can let us know through one of our other [contact options](https://podverse.fm/contact).

The Podverse dev team will regularly update this document with context as we're made aware of confusing text.

## Base language text with extra context

`"3 months free": "3 months free trial"`

The use of the word "free trial" here means "3 months at no charge" or "3 months at no cost". It means the user will receive a 3 month free trial period when they sign up for Podverse premium.

---

`"Boost": "Boost"`

Basically a "boost" is what Podcasting 2.0 apps call a "donation". You're in effect "boosting" the show by giving it a donation. If there isn't a good alternative term for "boost" in another language, you can fallback to "donation" for the translation.

`"Boostagram": "Boostagram",`

This is a new word in the Podcasting 2.0 world. A boostagram is a donation (aka a "boost") WITH a message attached. Another commonly known phrase that is comparable to boostagram is the YouTube "superchat". A superchat is a donation sent to livestreamers with a message attached. Superchat however might be a trademarked YouTube term (I'm not sure) that we can't use in Podverse. I'm actually not sure of what word to use here if not "boostagram" or "superchat"...any ideas would be appreciated.

Source: https://podnews.net/update/boostagrams

`"Free": "Free"`

Previously instead of saying "Free" as in "Free features accessible without a Premium membership", we had changed it to "At no cost". Kingu had recommended that "At no cost" would be clearer for translations, but on Sept 21 2022 Google Play rejected our release saying that the Membership Features page "Your offer does not clearly and accurately describe the terms of your subscription, including the cost, frequency of billing cycle, and whether a subscription is required to use the app." Since "Free vs Premium" is commonly understood as "Free Features vs Paid Features" in US English, we decided to change "At no cost" back to "Free" in the hopes that Google would consider that a more clear description.

`"Membership": "Membership"`

The word membership needs to be translated as "Membership" because it does not represent the user's membership status. It is a title to accompany the actual membership status.