# Itinerary Planner

[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0) [![build](https://github.com/pixelarry/itinerary_planner/actions/workflows/android.yml/badge.svg?branch=main)](https://github.com/pixelarry/itinerary_planner/actions/workflows/android.yml)

A modern, open-source Android application for planning and managing travel itineraries.

## Features

- **📅 Plan Management**: Create, view, and manage multiple travel itineraries
- **⏰ Task Scheduling**: Add tasks with start/end times and duration
- **💰 Cost Tracking**: Track expenses for each activity and overall trip budget

## Installation

### Manual Installation
1. Download the latest APK from the [Releases](https://github.com/pixelarry/itinerary_planner/releases) page
2. Enable "Install from unknown sources" in your Android settings
3. Install the APK file

### Building from Source
```bash
git clone https://github.com/pixelarry/itinerary_planner.git
cd itinerary_planner
./gradlew assembleDebug
```

## Contributing

We welcome contributions! Please see our [Contributing Guidelines](CONTRIBUTING.md) for details.

### Development Setup
1. Fork the repository
2. Clone your fork: `git clone https://github.com/yourusername/itinerary_planner.git`
3. Open the project in Android Studio
4. Make your changes
5. Test thoroughly
6. Submit a pull request

### Reporting Issues
Found a bug or have a feature request? Please [open an issue](https://github.com/pixelarry/itinerary_planner/issues/new) with:
- Clear description of the problem
- Steps to reproduce (for bugs)
- Expected vs actual behavior
- Device and Android version information

## License

This project is licensed under the GNU General Public License v3.0 - see the [LICENSE](LICENSE) file for details.

    Copyright (C) 2025 Pixelarry
    
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

## Support

- **Bug Reports**: [GitHub Issues](https://github.com/pixelarry/itinerary_planner/issues)
- **Feature Requests**: [GitHub Discussions](https://github.com/pixelarry/itinerary_planner/discussions)
- **General Support**: [Contact Form](https://forms.gle/qKYahftqpdnrLhZ49)

**Made with ❤️ for the open source community**
