//
//  accent.c
//
//  Created by Jeremy on 4/15/15.
//  Copyright (c) 2015 Jeremy March. All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
//


//#include <stdlib.h> // For random(), RAND_MAX
//#include <string.h>  //for strlen()
#include <assert.h>
#include <string.h>
#include "GreekUnicode.h"
#include "accent.h"

#include <android/log.h>
#define  LOG_TAG    "your-log-tag"
#define  LOGD(...)  __android_log_print(ANDROID_LOG_DEBUG, LOG_TAG, __VA_ARGS__)
#define  LOGE(...)  __android_log_print(ANDROID_LOG_ERROR, LOG_TAG, __VA_ARGS__)
// If you want you can add other log definition for info, warning etc

#define ALLOW_PRIVATE_USE_AREA 1
#define ALLOW_RHO_WITH_PSILI 0
#define MAX_COMBINING 6 //macron, breathing, accent, iota subscript || diaeresis, macron, accent, underdot

char unicode_mode = PRECOMPOSED_MODE; //set default
bool addSpacingDiacriticIfNotLegal = false;

void allowSpacingDiacritics(bool val)
{
    addSpacingDiacriticIfNotLegal = val;
}

#define NUM_COMBINING_ACCENTS 10
//this is the order they will follow after the vowel
UCS2 combiningAccents[NUM_COMBINING_ACCENTS] = { COMBINING_MACRON, COMBINING_BREVE, COMBINING_DIAERESIS, COMBINING_ROUGH_BREATHING, COMBINING_SMOOTH_BREATHING, COMBINING_ACUTE, COMBINING_GRAVE, COMBINING_CIRCUMFLEX, COMBINING_IOTA_SUBSCRIPT, COMBINING_UNDERDOT };

//precomposed indices
enum {
    NORMAL,
    TONOS,
    DIALYTIKA_AND_TONOS,
    PSILI,                                  //smooth
    DASIA,                                  //rough
    OXIA,
    PSILI_AND_OXIA,
    DASIA_AND_OXIA,
    VARIA,
    PSILI_AND_VARIA,
    DASIA_AND_VARIA,
    PERISPOMENI,
    PSILI_AND_PERISPOMENI,
    DASIA_AND_PERISPOMENI,
    YPOGEGRAMMENI,
    PSILI_AND_YPOGEGRAMMENI,
    DASIA_AND_YPOGEGRAMMENI,
    OXIA_AND_YPOGEGRAMMENI,
    PSILI_AND_OXIA_AND_YPOGEGRAMMENI,
    DASIA_AND_OXIA_AND_YPOGEGRAMMENI,
    VARIA_AND_YPOGEGRAMMENI,
    PSILI_AND_VARIA_AND_YPOGEGRAMMENI,
    DASIA_AND_VARIA_AND_YPOGEGRAMMENI,
    PERISPOMENI_AND_YPOGEGRAMMENI,
    PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI,
    DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI,
    DIALYTIKA,
    DIALYTIKA_AND_OXIA,
    DIALYTIKA_AND_VARIA,
    DIALYTIKA_AND_PERISPOMENON,
    MACRON_PRECOMPOSED,
    BREVE_PRECOMPOSED,
#ifdef ALLOW_PRIVATE_USE_AREA
    MACRON_AND_SMOOTH,
    MACRON_AND_SMOOTH_AND_ACUTE,
    MACRON_AND_SMOOTH_AND_GRAVE,
    MACRON_AND_ROUGH,
    MACRON_AND_ROUGH_AND_ACUTE,
    MACRON_AND_ROUGH_AND_GRAVE,
    MACRON_AND_ACUTE,
    MACRON_AND_GRAVE,
    BREVE_AND_SMOOTH,
    BREVE_AND_SMOOTH_AND_ACUTE,
    BREVE_AND_SMOOTH_AND_GRAVE,
    BREVE_AND_ROUGH,
    BREVE_AND_ROUGH_AND_ACUTE,
    BREVE_AND_ROUGH_AND_GRAVE,
    BREVE_AND_ACUTE,
    BREVE_AND_GRAVE,
#endif
    NUM_ACCENT_CODES
};

enum {
    NOSORT = 0,
    ALPHA_SORT,
    BETA_SORT,
    GAMMA_SORT,
    DELTA_SORT,
    EPSILON_SORT,
    ZETA_SORT,
    ETA_SORT,
    THETA_SORT,
    IOTA_SORT,
    KAPPA_SORT,
    LAMBDA_SORT,
    MU_SORT,
    NU_SORT,
    XI_SORT,
    OMICRON_SORT,
    PI_SORT,
    RHO_SORT,
    SIGMA_SORT,
    TAU_SORT,
    UPSILON_SORT,
    PHI_SORT,
    CHI_SORT,
    PSI_SORT,
    OMEGA_SORT
};

//letterIndices
enum {
    ALPHA,
    EPSILON,
    ETA,
    IOTA,
    OMICRON,
    UPSILON,
    OMEGA,
    ALPHA_CAP,
    EPSILON_CAP,
    ETA_CAP,
    IOTA_CAP,
    OMICRON_CAP,
    UPSILON_CAP,
    OMEGA_CAP,
    NUM_VOWEL_CODES
};

UCS2 letters[NUM_VOWEL_CODES][NUM_ACCENT_CODES] = {
    { GREEK_SMALL_LETTER_ALPHA, GREEK_SMALL_LETTER_ALPHA_WITH_TONOS, 0 /* DIALYTIKA_AND_TONOS */, GREEK_SMALL_LETTER_ALPHA_WITH_PSILI, GREEK_SMALL_LETTER_ALPHA_WITH_DASIA, GREEK_SMALL_LETTER_ALPHA_WITH_OXIA, GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_OXIA, GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_OXIA, GREEK_SMALL_LETTER_ALPHA_WITH_VARIA, GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_VARIA, GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_VARIA, GREEK_SMALL_LETTER_ALPHA_WITH_PERISPOMENI, GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI, GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI, GREEK_SMALL_LETTER_ALPHA_WITH_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ALPHA_WITH_OXIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_OXIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_OXIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ALPHA_WITH_VARIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_VARIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_VARIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ALPHA_WITH_PERISPOMENI_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI, 0, 0, 0, 0,
        GREEK_SMALL_LETTER_ALPHA_WITH_MACRON, GREEK_SMALL_LETTER_ALPHA_WITH_VRACHY
#ifdef ALLOW_PRIVATE_USE_AREA
        , PUA_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_OXIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_VARIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_OXIA_AND_MACRON2,
        PUA_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_VARIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_ALPHA_WITH_OXIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_ALPHA_WITH_VARIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_OXIA_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_ALPHA_WITH_PSILI_AND_VARIA_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_OXIA_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_ALPHA_WITH_DASIA_AND_VARIA_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_ALPHA_WITH_OXIA_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_ALPHA_WITH_VARIA_AND_BREVE
#endif
    },
    
    { GREEK_SMALL_LETTER_EPSILON,GREEK_SMALL_LETTER_EPSILON_WITH_TONOS, 0 /* DIALYTIKA_AND_TONOS */, GREEK_SMALL_LETTER_EPSILON_WITH_PSILI, GREEK_SMALL_LETTER_EPSILON_WITH_DASIA, GREEK_SMALL_LETTER_EPSILON_WITH_OXIA, GREEK_SMALL_LETTER_EPSILON_WITH_PSILI_AND_OXIA, GREEK_SMALL_LETTER_EPSILON_WITH_DASIA_AND_OXIA, GREEK_SMALL_LETTER_EPSILON_WITH_VARIA, GREEK_SMALL_LETTER_EPSILON_WITH_PSILI_AND_VARIA, GREEK_SMALL_LETTER_EPSILON_WITH_DASIA_AND_VARIA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
#ifdef ALLOW_PRIVATE_USE_AREA
        , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
#endif
    },
    
    { GREEK_SMALL_LETTER_ETA, GREEK_SMALL_LETTER_ETA_WITH_TONOS, 0 /* DIALYTIKA_AND_TONOS */, GREEK_SMALL_LETTER_ETA_WITH_PSILI, GREEK_SMALL_LETTER_ETA_WITH_DASIA, GREEK_SMALL_LETTER_ETA_WITH_OXIA, GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_OXIA, GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_OXIA, GREEK_SMALL_LETTER_ETA_WITH_VARIA, GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_VARIA, GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_VARIA, GREEK_SMALL_LETTER_ETA_WITH_PERISPOMENI, GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI, GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI, GREEK_SMALL_LETTER_ETA_WITH_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ETA_WITH_OXIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_OXIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_OXIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ETA_WITH_VARIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_VARIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_VARIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ETA_WITH_PERISPOMENI_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI, 0, 0, 0, 0, 0, 0
#ifdef ALLOW_PRIVATE_USE_AREA
        , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
#endif
    },
    
    { GREEK_SMALL_LETTER_IOTA, GREEK_SMALL_LETTER_IOTA_WITH_TONOS, GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_TONOS, GREEK_SMALL_LETTER_IOTA_WITH_PSILI, GREEK_SMALL_LETTER_IOTA_WITH_DASIA, GREEK_SMALL_LETTER_IOTA_WITH_OXIA, GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_OXIA, GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_OXIA, GREEK_SMALL_LETTER_IOTA_WITH_VARIA, GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_VARIA, GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_VARIA, GREEK_SMALL_LETTER_IOTA_WITH_PERISPOMENI, GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_PERISPOMENI, GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_PERISPOMENI, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA, GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_OXIA, GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_VARIA, GREEK_SMALL_LETTER_IOTA_WITH_DIALYTIKA_AND_PERISPOMENI,
        GREEK_SMALL_LETTER_IOTA_WITH_MACRON, GREEK_SMALL_LETTER_IOTA_WITH_VRACHY
#ifdef ALLOW_PRIVATE_USE_AREA
        , PUA_GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_OXIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_VARIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_OXIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_VARIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_IOTA_WITH_OXIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_IOTA_WITH_VARIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_OXIA_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_IOTA_WITH_PSILI_AND_VARIA_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_OXIA_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_IOTA_WITH_DASIA_AND_VARIA_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_IOTA_WITH_OXIA_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_IOTA_WITH_VARIA_AND_BREVE
#endif
    },
    
    { GREEK_SMALL_LETTER_OMICRON, GREEK_SMALL_LETTER_OMICRON_WITH_TONOS, 0 /* DIALYTIKA_AND_TONOS */, GREEK_SMALL_LETTER_OMICRON_WITH_PSILI, GREEK_SMALL_LETTER_OMICRON_WITH_DASIA, GREEK_SMALL_LETTER_OMICRON_WITH_OXIA, GREEK_SMALL_LETTER_OMICRON_WITH_PSILI_AND_OXIA, GREEK_SMALL_LETTER_OMICRON_WITH_DASIA_AND_OXIA, GREEK_SMALL_LETTER_OMICRON_WITH_VARIA, GREEK_SMALL_LETTER_OMICRON_WITH_PSILI_AND_VARIA, GREEK_SMALL_LETTER_OMICRON_WITH_DASIA_AND_VARIA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
#ifdef ALLOW_PRIVATE_USE_AREA
        , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
#endif
    },
    
    { GREEK_SMALL_LETTER_UPSILON, GREEK_SMALL_LETTER_UPSILON_WITH_TONOS, GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_TONOS, GREEK_SMALL_LETTER_UPSILON_WITH_PSILI, GREEK_SMALL_LETTER_UPSILON_WITH_DASIA, GREEK_SMALL_LETTER_UPSILON_WITH_OXIA, GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_OXIA, GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_OXIA, GREEK_SMALL_LETTER_UPSILON_WITH_VARIA, GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_VARIA, GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_VARIA, GREEK_SMALL_LETTER_UPSILON_WITH_PERISPOMENI, GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_PERISPOMENI, GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_PERISPOMENI, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA, GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_OXIA, GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_VARIA, GREEK_SMALL_LETTER_UPSILON_WITH_DIALYTIKA_AND_PERISPOMENI,
        GREEK_SMALL_LETTER_UPSILON_WITH_MACRON, GREEK_SMALL_LETTER_UPSILON_WITH_VRACHY
#ifdef ALLOW_PRIVATE_USE_AREA
        , PUA_GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_OXIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_VARIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_OXIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_VARIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_UPSILON_WITH_OXIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_UPSILON_WITH_VARIA_AND_MACRON,
        PUA_GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_OXIA_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_UPSILON_WITH_PSILI_AND_VARIA_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_OXIA_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_UPSILON_WITH_DASIA_AND_VARIA_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_UPSILON_WITH_OXIA_AND_BREVE,
        PUA_GREEK_SMALL_LETTER_UPSILON_WITH_VARIA_AND_BREVE
#endif
    },
    
    { GREEK_SMALL_LETTER_OMEGA, GREEK_SMALL_LETTER_OMEGA_WITH_TONOS, 0 /* DIALYTIKA_AND_TONOS */, GREEK_SMALL_LETTER_OMEGA_WITH_PSILI, GREEK_SMALL_LETTER_OMEGA_WITH_DASIA, GREEK_SMALL_LETTER_OMEGA_WITH_OXIA, GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_OXIA, GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_OXIA, GREEK_SMALL_LETTER_OMEGA_WITH_VARIA, GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_VARIA, GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_VARIA, GREEK_SMALL_LETTER_OMEGA_WITH_PERISPOMENI, GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI, GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI, GREEK_SMALL_LETTER_OMEGA_WITH_YPOGEGRAMMENI, GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_OMEGA_WITH_OXIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_OXIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_OXIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_OMEGA_WITH_VARIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_VARIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_VARIA_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_OMEGA_WITH_PERISPOMENI_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI, GREEK_SMALL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI, 0, 0, 0, 0, 0, 0
#ifdef ALLOW_PRIVATE_USE_AREA
        , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
#endif
    },
    
    /* START CAPITALS */
    { GREEK_CAPITAL_LETTER_ALPHA,GREEK_CAPITAL_LETTER_ALPHA_WITH_TONOS, 0 /* DIALYTIKA_AND_TONOS */, GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI, GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA, GREEK_CAPITAL_LETTER_ALPHA_WITH_OXIA, GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_OXIA, GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_OXIA, GREEK_CAPITAL_LETTER_ALPHA_WITH_VARIA, GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_VARIA, GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_VARIA, 0/*GREEK_CAPITAL_LETTER_ALPHA_WITH_PERISPOMENI*/, GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI, GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI, GREEK_CAPITAL_LETTER_ALPHA_WITH_PROSGEGRAMMENI, GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_PROSGEGRAMMENI, GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_PROSGEGRAMMENI, 0/*GREEK_CAPITAL_LETTER_ALPHA_WITH_OXIA_AND_PROSGEGRAMMENI*/, GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_OXIA_AND_PROSGEGRAMMENI, GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_OXIA_AND_PROSGEGRAMMENI, 0/*GREEK_CAPITAL_LETTER_ALPHA_WITH_VARIA_AND_PROSGEGRAMMENI*/, GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_VARIA_AND_PROSGEGRAMMENI, GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_VARIA_AND_PROSGEGRAMMENI, 0/*GREEK_CAPITAL_LETTER_ALPHA_WITH_PERISPOMENI_AND_PROSGEGRAMMENI*/, GREEK_CAPITAL_LETTER_ALPHA_WITH_PSILI_AND_PERISPOMENI_AND_PROSGEGRAMMENI, GREEK_CAPITAL_LETTER_ALPHA_WITH_DASIA_AND_PERISPOMENI_AND_PROSGEGRAMMENI, 0, 0, 0, 0, GREEK_CAPITAL_LETTER_ALPHA_WITH_MACRON, GREEK_CAPITAL_LETTER_ALPHA_WITH_VRACHY
#ifdef ALLOW_PRIVATE_USE_AREA
        , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
#endif
    },
    
    { GREEK_CAPITAL_LETTER_EPSILON, GREEK_CAPITAL_LETTER_EPSILON_WITH_TONOS, 0 /* DIALYTIKA_AND_TONOS */, GREEK_CAPITAL_LETTER_EPSILON_WITH_PSILI, GREEK_CAPITAL_LETTER_EPSILON_WITH_DASIA, GREEK_CAPITAL_LETTER_EPSILON_WITH_OXIA, GREEK_CAPITAL_LETTER_EPSILON_WITH_PSILI_AND_OXIA, GREEK_CAPITAL_LETTER_EPSILON_WITH_DASIA_AND_OXIA, GREEK_CAPITAL_LETTER_EPSILON_WITH_VARIA, GREEK_CAPITAL_LETTER_EPSILON_WITH_PSILI_AND_VARIA, GREEK_CAPITAL_LETTER_EPSILON_WITH_DASIA_AND_VARIA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
#ifdef ALLOW_PRIVATE_USE_AREA
        , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
#endif
    },
    
    { GREEK_CAPITAL_LETTER_ETA, GREEK_CAPITAL_LETTER_ETA_WITH_TONOS, 0 /* DIALYTIKA_AND_TONOS */, GREEK_CAPITAL_LETTER_ETA_WITH_PSILI, GREEK_CAPITAL_LETTER_ETA_WITH_DASIA, GREEK_CAPITAL_LETTER_ETA_WITH_OXIA, GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_OXIA, GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_OXIA, GREEK_CAPITAL_LETTER_ETA_WITH_VARIA, GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_VARIA, GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_VARIA, 0/*GREEK_CAPITAL_LETTER_ETA_WITH_PERISPOMENI*/, GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI, GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI, GREEK_CAPITAL_LETTER_ETA_WITH_PROSGEGRAMMENI, GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_PROSGEGRAMMENI, GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_PROSGEGRAMMENI, 0/*GREEK_CAPITAL_LETTER_ETA_WITH_OXIA_AND_PROSGEGRAMMENI*/, GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_OXIA_AND_PROSGEGRAMMENI, GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_OXIA_AND_PROSGEGRAMMENI, 0/*GREEK_CAPITAL_LETTER_ETA_WITH_VARIA_AND_PROSGEGRAMMENI*/, GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_VARIA_AND_PROSGEGRAMMENI, GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_VARIA_AND_PROSGEGRAMMENI, 0/*GREEK_CAPITAL_LETTER_ETA_WITH_PERISPOMENI_AND_PROSGEGRAMMENI*/, GREEK_CAPITAL_LETTER_ETA_WITH_PSILI_AND_PERISPOMENI_AND_PROSGEGRAMMENI, GREEK_CAPITAL_LETTER_ETA_WITH_DASIA_AND_PERISPOMENI_AND_PROSGEGRAMMENI, 0, 0, 0, 0, 0, 0
#ifdef ALLOW_PRIVATE_USE_AREA
        , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
#endif
    },
    
    { GREEK_CAPITAL_LETTER_IOTA, GREEK_CAPITAL_LETTER_IOTA_WITH_TONOS, 0 /* DIALYTIKA_AND_TONOS */, GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI, GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA, GREEK_CAPITAL_LETTER_IOTA_WITH_OXIA, GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI_AND_OXIA, GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA_AND_OXIA, GREEK_CAPITAL_LETTER_IOTA_WITH_VARIA, GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI_AND_VARIA, GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA_AND_VARIA, 0/*GREEK_CAPITAL_LETTER_IOTA_WITH_PERISPOMENI*/, GREEK_CAPITAL_LETTER_IOTA_WITH_PSILI_AND_PERISPOMENI, GREEK_CAPITAL_LETTER_IOTA_WITH_DASIA_AND_PERISPOMENI, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, GREEK_CAPITAL_LETTER_IOTA_WITH_DIALYTIKA, 0, 0, 0, GREEK_CAPITAL_LETTER_IOTA_WITH_MACRON, GREEK_CAPITAL_LETTER_IOTA_WITH_VRACHY
#ifdef ALLOW_PRIVATE_USE_AREA
        , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
#endif
    },
    { GREEK_CAPITAL_LETTER_OMICRON, GREEK_CAPITAL_LETTER_OMICRON_WITH_TONOS, 0 /* DIALYTIKA_AND_TONOS */, GREEK_CAPITAL_LETTER_OMICRON_WITH_PSILI, GREEK_CAPITAL_LETTER_OMICRON_WITH_DASIA, GREEK_CAPITAL_LETTER_OMICRON_WITH_OXIA, GREEK_CAPITAL_LETTER_OMICRON_WITH_PSILI_AND_OXIA, GREEK_CAPITAL_LETTER_OMICRON_WITH_DASIA_AND_OXIA, GREEK_CAPITAL_LETTER_OMICRON_WITH_VARIA, GREEK_CAPITAL_LETTER_OMICRON_WITH_PSILI_AND_VARIA, GREEK_CAPITAL_LETTER_OMICRON_WITH_DASIA_AND_VARIA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
#ifdef ALLOW_PRIVATE_USE_AREA
        , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
#endif
    },
    
    { GREEK_CAPITAL_LETTER_UPSILON, GREEK_CAPITAL_LETTER_UPSILON_WITH_TONOS, 0 /* DIALYTIKA_AND_TONOS */, 0/*GREEK_CAPITAL_LETTER_UPSILON_WITH_PSILI*/, GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA, GREEK_CAPITAL_LETTER_UPSILON_WITH_OXIA, 0/*GREEK_CAPITAL_LETTER_UPSILON_WITH_PSILI_AND_OXIA*/, GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA_AND_OXIA, GREEK_CAPITAL_LETTER_UPSILON_WITH_VARIA, 0/*GREEK_CAPITAL_LETTER_UPSILON_WITH_PSILI_AND_VARIA*/, GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA_AND_VARIA, 0/*GREEK_CAPITAL_LETTER_UPSILON_WITH_PERISPOMENI*/, 0/*GREEK_CAPITAL_LETTER_UPSILON_WITH_PSILI_AND_PERISPOMENI*/, GREEK_CAPITAL_LETTER_UPSILON_WITH_DASIA_AND_PERISPOMENI, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, GREEK_CAPITAL_LETTER_UPSILON_WITH_DIALYTIKA, 0, 0, 0, GREEK_CAPITAL_LETTER_UPSILON_WITH_MACRON, GREEK_CAPITAL_LETTER_UPSILON_WITH_VRACHY
#ifdef ALLOW_PRIVATE_USE_AREA
        , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
#endif
    },
    
    { GREEK_CAPITAL_LETTER_OMEGA, GREEK_CAPITAL_LETTER_OMEGA_WITH_TONOS, 0 /* DIALYTIKA_AND_TONOS */, GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI, GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA, GREEK_CAPITAL_LETTER_OMEGA_WITH_OXIA, GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_OXIA, GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_OXIA, GREEK_CAPITAL_LETTER_OMEGA_WITH_VARIA, GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_VARIA, GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_VARIA, 0/*GREEK_CAPITAL_LETTER_OMEGA_WITH_PERISPOMENI*/, GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI, GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI, GREEK_CAPITAL_LETTER_OMEGA_WITH_PROSGEGRAMMENI, GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_PROSGEGRAMMENI, GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_PROSGEGRAMMENI, 0/*GREEK_CAPITAL_LETTER_OMEGA_WITH_OXIA_AND_PROSGEGRAMMENI*/, GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_OXIA_AND_PROSGEGRAMMENI, GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_OXIA_AND_PROSGEGRAMMENI, 0/*GREEK_CAPITAL_LETTER_OMEGA_WITH_VARIA_AND_PROSGEGRAMMENI*/, GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_VARIA_AND_PROSGEGRAMMENI, GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_VARIA_AND_PROSGEGRAMMENI, 0/*GREEK_CAPITAL_LETTER_OMEGA_WITH_PERISPOMENI_AND_PROSGEGRAMMENI*/, GREEK_CAPITAL_LETTER_OMEGA_WITH_PSILI_AND_PERISPOMENI_AND_PROSGEGRAMMENI, GREEK_CAPITAL_LETTER_OMEGA_WITH_DASIA_AND_PERISPOMENI_AND_PROSGEGRAMMENI, 0, 0, 0, 0, 0, 0
#ifdef ALLOW_PRIVATE_USE_AREA
        , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
#endif
    }
};

#define NOCHAR 0

#define NOT_ACCENTABLE_CHAR 1
#define ACCENTABLE_CHAR 3



//first col will be the actual codepoint for an accenting character
//or NOT_ACCENTABLE_CHAR or NOCHAR
UCS2 basicGreekLookUp[][3] = {
    /* 0370 */ { NOCHAR, NOCHAR, NOSORT },
    /* 0371 */ { NOCHAR, NOCHAR, NOSORT },
    /* 0372 */ { NOCHAR, NOCHAR, NOSORT },
    /* 0373 */ { NOCHAR, NOCHAR, NOSORT },
    /* 0374 */ { NOCHAR, NOCHAR, NOSORT },
    /* 0375 */ { NOCHAR, NOCHAR, NOSORT },
    /* 0376 */ { NOCHAR, NOCHAR, NOSORT },
    /* 0377 */ { NOCHAR, NOCHAR, NOSORT },
    /* 0378 */ { NOCHAR, NOCHAR, NOSORT },
    /* 0379 */ { NOCHAR, NOCHAR, NOSORT },
    /* 037A */ { NOCHAR, NOCHAR, NOSORT },
    /* 037B */ { NOCHAR, NOCHAR, NOSORT },
    /* 037C */ { NOCHAR, NOCHAR, NOSORT },
    /* 037D */ { NOCHAR, NOCHAR, NOSORT },
    /* 037E */ { NOCHAR, NOCHAR, NOSORT },
    /* 037F */ { NOCHAR, NOCHAR, NOSORT },
    /* 0380 */ { NOCHAR, NOCHAR, NOSORT },
    /* 0381 */ { NOCHAR, NOCHAR, NOSORT },
    /* 0382 */ { NOCHAR, NOCHAR, NOSORT },
    /* 0383 */ { NOCHAR, NOCHAR, NOSORT },
    /* 0384 */ { NOCHAR, NOCHAR, NOSORT },
    /* 0385 */ { NOCHAR, NOCHAR, NOSORT },
    /* 0386 */ { GREEK_CAPITAL_LETTER_ALPHA, _ACUTE, ALPHA_SORT },
    /* 0387 */ { NOCHAR, NOCHAR, NOSORT },
    /* 0388 */ { GREEK_CAPITAL_LETTER_EPSILON, _ACUTE, EPSILON_SORT },
    /* 0389 */ { GREEK_CAPITAL_LETTER_ETA, _ACUTE, ETA_SORT },
    /* 038A */ { GREEK_CAPITAL_LETTER_IOTA, _ACUTE, IOTA_SORT },
    /* 038B */ { NOCHAR, NOCHAR, NOSORT },
    /* 038C */ { GREEK_CAPITAL_LETTER_OMICRON, _ACUTE, OMICRON_SORT },
    /* 038D */ { NOCHAR, NOCHAR, NOSORT },
    /* 038E */ { GREEK_CAPITAL_LETTER_UPSILON, _ACUTE, UPSILON_SORT },
    /* 038F */ { GREEK_CAPITAL_LETTER_OMEGA, _ACUTE, OMEGA_SORT },
    /* 0390 */ { GREEK_SMALL_LETTER_IOTA, _ACUTE | _DIAERESIS, IOTA_SORT },
    /* 0391 */ { GREEK_CAPITAL_LETTER_ALPHA, 0, ALPHA_SORT },
    /* 0392 */ { NOT_ACCENTABLE_CHAR, NOCHAR, BETA_SORT }, /* capital beta */
    /* 0393 */ { NOT_ACCENTABLE_CHAR, NOCHAR, GAMMA_SORT }, /* capital gamma */
    /* 0394 */ { NOT_ACCENTABLE_CHAR, NOCHAR, DELTA_SORT }, /* capital delta */
    /* 0395 */ { GREEK_CAPITAL_LETTER_EPSILON, 0 , EPSILON_SORT},
    /* 0396 */ { NOT_ACCENTABLE_CHAR, NOCHAR, ZETA_SORT }, /* capital zeta */
    /* 0397 */ { GREEK_CAPITAL_LETTER_ETA, 0, ETA_SORT },
    /* 0398 */ { NOT_ACCENTABLE_CHAR, NOCHAR, THETA_SORT }, /* capital theta */
    /* 0399 */ { GREEK_CAPITAL_LETTER_IOTA, 0, IOTA_SORT },
    /* 039A */ { NOT_ACCENTABLE_CHAR, NOCHAR, KAPPA_SORT }, /* capital kappa */
    /* 039B */ { NOT_ACCENTABLE_CHAR, NOCHAR, LAMBDA_SORT }, /* capital lambda */
    /* 039C */ { NOT_ACCENTABLE_CHAR, NOCHAR, MU_SORT }, /* capital mu */
    /* 039D */ { NOT_ACCENTABLE_CHAR, NOCHAR, NU_SORT }, /* capital nu */
    /* 039E */ { NOT_ACCENTABLE_CHAR, NOCHAR, XI_SORT }, /* capital xi */
    /* 039F */ { GREEK_CAPITAL_LETTER_OMICRON, 0, OMICRON_SORT },
    /* 03A0 */ { NOT_ACCENTABLE_CHAR, NOCHAR, PI_SORT }, /* capital pi */
    /* 03A1 */ { NOT_ACCENTABLE_CHAR, NOCHAR, RHO_SORT }, /* capital rho */
    /* 03A2 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03A3 */ { NOT_ACCENTABLE_CHAR, NOCHAR, SIGMA_SORT }, /* capital sigma */
    /* 03A4 */ { NOT_ACCENTABLE_CHAR, NOCHAR, TAU_SORT }, /* capital tau */
    /* 03A5 */ { GREEK_CAPITAL_LETTER_UPSILON, 0, UPSILON_SORT },
    /* 03A6 */ { NOT_ACCENTABLE_CHAR, NOCHAR, PHI_SORT }, /* capital phi */
    /* 03A7 */ { NOT_ACCENTABLE_CHAR, NOCHAR, CHI_SORT }, /* capital chi */
    /* 03A8 */ { NOT_ACCENTABLE_CHAR, NOCHAR, PSI_SORT }, /* capital psi */
    /* 03A9 */ { GREEK_CAPITAL_LETTER_OMEGA, 0, OMEGA_SORT },
    /* 03AA */ { GREEK_CAPITAL_LETTER_IOTA, _DIAERESIS, IOTA_SORT },
    /* 03AB */ { GREEK_CAPITAL_LETTER_UPSILON, _DIAERESIS, UPSILON_SORT },
    /* 03AC */ { GREEK_SMALL_LETTER_ALPHA, _ACUTE, ALPHA_SORT },
    /* 03AD */ { GREEK_SMALL_LETTER_EPSILON, _ACUTE, EPSILON_SORT },
    /* 03AE */ { GREEK_SMALL_LETTER_ETA, _ACUTE, ETA_SORT },
    /* 03AF */ { GREEK_SMALL_LETTER_IOTA, _ACUTE, IOTA_SORT },
    /* 03B0 */ { GREEK_SMALL_LETTER_UPSILON, _ACUTE | _DIAERESIS },
    /* 03B1 */ { GREEK_SMALL_LETTER_ALPHA, 0, ALPHA_SORT },
    /* 03B2 */ { NOT_ACCENTABLE_CHAR, NOCHAR, BETA_SORT }, /* small beta */
    /* 03B3 */ { NOT_ACCENTABLE_CHAR, NOCHAR, GAMMA_SORT }, /* small gamma */
    /* 03B4 */ { NOT_ACCENTABLE_CHAR, NOCHAR, DELTA_SORT }, /* small delta */
    /* 03B5 */ { GREEK_SMALL_LETTER_EPSILON, 0, EPSILON_SORT },
    /* 03B6 */ { NOT_ACCENTABLE_CHAR, NOCHAR, ZETA_SORT }, /* small zeta */
    /* 03B7 */ { GREEK_SMALL_LETTER_ETA, 0, ETA_SORT },
    /* 03B8 */ { NOT_ACCENTABLE_CHAR, NOCHAR, THETA_SORT }, /* small theta */
    /* 03B9 */ { GREEK_SMALL_LETTER_IOTA, 0, IOTA_SORT },
    /* 03BA */ { NOT_ACCENTABLE_CHAR, NOCHAR, KAPPA_SORT }, /* small kappa */
    /* 03BB */ { NOT_ACCENTABLE_CHAR, NOCHAR, LAMBDA_SORT }, /* small lambda */
    /* 03BC */ { NOT_ACCENTABLE_CHAR, NOCHAR, MU_SORT }, /* small mu */
    /* 03BD */ { NOT_ACCENTABLE_CHAR, NOCHAR, NU_SORT }, /* small nu */
    /* 03BE */ { NOT_ACCENTABLE_CHAR, NOCHAR, XI_SORT }, /* small xi */
    /* 03BF */ { GREEK_SMALL_LETTER_OMICRON, 0, OMICRON_SORT },
    /* 03C0 */ { NOT_ACCENTABLE_CHAR, NOCHAR, PI_SORT }, /* small pi */
    /* 03C1 */ { NOT_ACCENTABLE_CHAR, NOCHAR, RHO_SORT }, /* small rho */
    /* 03C2 */ { NOT_ACCENTABLE_CHAR, NOCHAR, SIGMA_SORT }, /* small final sigma */
    /* 03C3 */ { NOT_ACCENTABLE_CHAR, NOCHAR, SIGMA_SORT }, /* small sigma */
    /* 03C4 */ { NOT_ACCENTABLE_CHAR, NOCHAR, TAU_SORT }, /* small tau */
    /* 03C5 */ { GREEK_SMALL_LETTER_UPSILON, 0, UPSILON_SORT },
    /* 03C6 */ { NOT_ACCENTABLE_CHAR, NOCHAR, PHI_SORT }, /* small phi */
    /* 03C7 */ { NOT_ACCENTABLE_CHAR, NOCHAR, CHI_SORT }, /* small chi */
    /* 03C8 */ { NOT_ACCENTABLE_CHAR, NOCHAR, PSI_SORT }, /* small psi */
    /* 03C9 */ { GREEK_SMALL_LETTER_OMEGA, 0, OMEGA_SORT },
    /* 03CA */ { GREEK_SMALL_LETTER_IOTA, _DIAERESIS, IOTA_SORT },
    /* 03CB */ { GREEK_SMALL_LETTER_UPSILON, _DIAERESIS, UPSILON_SORT },
    /* 03CC */ { GREEK_SMALL_LETTER_OMICRON, _ACUTE, OMICRON_SORT },
    /* 03CD */ { GREEK_SMALL_LETTER_UPSILON, _ACUTE, UPSILON_SORT },
    /* 03CE */ { GREEK_SMALL_LETTER_OMEGA, _ACUTE, OMEGA_SORT },
    /* 03CF */ { NOCHAR, NOCHAR, NOSORT },
    /* 03D0 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03D1 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03D2 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03D3 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03D4 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03D5 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03D6 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03D7 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03D8 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03D9 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03DA */ { NOCHAR, NOCHAR, NOSORT },
    /* 03DB */ { NOCHAR, NOCHAR, NOSORT },
    /* 03DC */ { NOCHAR, NOCHAR, NOSORT },
    /* 03DD */ { NOCHAR, NOCHAR, NOSORT },
    /* 03DE */ { NOCHAR, NOCHAR, NOSORT },
    /* 03DF */ { NOCHAR, NOCHAR, NOSORT },
    /* 03E0 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03E1 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03E2 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03E3 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03E4 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03E5 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03E6 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03E7 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03E8 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03E9 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03EA */ { NOCHAR, NOCHAR, NOSORT },
    /* 03EB */ { NOCHAR, NOCHAR, NOSORT },
    /* 03EC */ { NOCHAR, NOCHAR, NOSORT },
    /* 03ED */ { NOCHAR, NOCHAR, NOSORT },
    /* 03EE */ { NOCHAR, NOCHAR, NOSORT },
    /* 03EF */ { NOCHAR, NOCHAR, NOSORT },
    /* 03F0 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03F1 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03F2 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03F3 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03F4 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03F5 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03F6 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03F7 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03F8 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03F9 */ { NOCHAR, NOCHAR, NOSORT },
    /* 03FA */ { NOCHAR, NOCHAR, NOSORT },
    /* 03FB */ { NOCHAR, NOCHAR, NOSORT },
    /* 03FC */ { NOCHAR, NOCHAR, NOSORT },
    /* 03FD */ { NOCHAR, NOCHAR, NOSORT },
    /* 03FE */ { NOCHAR, NOCHAR, NOSORT },
    /* 03FF */ { NOCHAR, NOCHAR, NOSORT }
};

UCS2 extendedGreekLookUp[][2] = {
    /* 1F00 */ { GREEK_SMALL_LETTER_ALPHA, _SMOOTH },
    /* 1F01 */ { GREEK_SMALL_LETTER_ALPHA, _ROUGH },
    /* 1F02 */ { GREEK_SMALL_LETTER_ALPHA, _SMOOTH | _GRAVE },
    /* 1F03 */ { GREEK_SMALL_LETTER_ALPHA, _ROUGH | _GRAVE },
    /* 1F04 */ { GREEK_SMALL_LETTER_ALPHA, _SMOOTH | _ACUTE },
    /* 1F05 */ { GREEK_SMALL_LETTER_ALPHA, _ROUGH | _ACUTE },
    /* 1F06 */ { GREEK_SMALL_LETTER_ALPHA, _SMOOTH | _CIRCUMFLEX },
    /* 1F07 */ { GREEK_SMALL_LETTER_ALPHA, _ROUGH | _CIRCUMFLEX },
    /* 1F08 */ { GREEK_CAPITAL_LETTER_ALPHA, _SMOOTH },
    /* 1F09 */ { GREEK_CAPITAL_LETTER_ALPHA, _ROUGH },
    /* 1F0A */ { GREEK_CAPITAL_LETTER_ALPHA, _SMOOTH | _GRAVE },
    /* 1F0B */ { GREEK_CAPITAL_LETTER_ALPHA, _ROUGH | _GRAVE },
    /* 1F0C */ { GREEK_CAPITAL_LETTER_ALPHA, _SMOOTH | _ACUTE },
    /* 1F0D */ { GREEK_CAPITAL_LETTER_ALPHA, _ROUGH | _ACUTE },
    /* 1F0E */ { GREEK_CAPITAL_LETTER_ALPHA, _SMOOTH | _CIRCUMFLEX },
    /* 1F0F */ { GREEK_CAPITAL_LETTER_ALPHA, _ROUGH | _CIRCUMFLEX },
    /* 1F10 */ { GREEK_SMALL_LETTER_EPSILON, _SMOOTH },
    /* 1F11 */ { GREEK_SMALL_LETTER_EPSILON, _ROUGH },
    /* 1F12 */ { GREEK_SMALL_LETTER_EPSILON, _SMOOTH | _GRAVE },
    /* 1F13 */ { GREEK_SMALL_LETTER_EPSILON, _ROUGH | _GRAVE },
    /* 1F14 */ { GREEK_SMALL_LETTER_EPSILON, _SMOOTH | _ACUTE },
    /* 1F15 */ { GREEK_SMALL_LETTER_EPSILON, _ROUGH | _ACUTE },
    /* 1F16 */ { NOCHAR, NOCHAR },
    /* 1F17 */ { NOCHAR, NOCHAR },
    /* 1F18 */ { GREEK_CAPITAL_LETTER_EPSILON, _SMOOTH },
    /* 1F19 */ { GREEK_CAPITAL_LETTER_EPSILON, _ROUGH },
    /* 1F1A */ { GREEK_CAPITAL_LETTER_EPSILON, _SMOOTH | _GRAVE },
    /* 1F1B */ { GREEK_CAPITAL_LETTER_EPSILON, _ROUGH | _GRAVE },
    /* 1F1C */ { GREEK_CAPITAL_LETTER_EPSILON, _SMOOTH | _ACUTE },
    /* 1F1D */ { GREEK_CAPITAL_LETTER_EPSILON, _ROUGH | _ACUTE },
    /* 1F1E */ { NOCHAR, NOCHAR },
    /* 1F1F */ { NOCHAR, NOCHAR },
    /* 1F20 */ { GREEK_SMALL_LETTER_ETA, _SMOOTH },
    /* 1F21 */ { GREEK_SMALL_LETTER_ETA, _ROUGH },
    /* 1F22 */ { GREEK_SMALL_LETTER_ETA, _SMOOTH | _GRAVE },
    /* 1F23 */ { GREEK_SMALL_LETTER_ETA, _ROUGH | _GRAVE },
    /* 1F24 */ { GREEK_SMALL_LETTER_ETA, _SMOOTH | _ACUTE },
    /* 1F25 */ { GREEK_SMALL_LETTER_ETA, _ROUGH | _ACUTE },
    /* 1F26 */ { GREEK_SMALL_LETTER_ETA, _SMOOTH | _CIRCUMFLEX },
    /* 1F27 */ { GREEK_SMALL_LETTER_ETA, _ROUGH | _CIRCUMFLEX },
    /* 1F28 */ { GREEK_CAPITAL_LETTER_ETA, _SMOOTH },
    /* 1F29 */ { GREEK_CAPITAL_LETTER_ETA, _ROUGH },
    /* 1F2A */ { GREEK_CAPITAL_LETTER_ETA, _SMOOTH | _GRAVE },
    /* 1F2B */ { GREEK_CAPITAL_LETTER_ETA, _ROUGH | _GRAVE },
    /* 1F2C */ { GREEK_CAPITAL_LETTER_ETA, _SMOOTH | _ACUTE },
    /* 1F2D */ { GREEK_CAPITAL_LETTER_ETA, _ROUGH | _ACUTE },
    /* 1F2E */ { GREEK_CAPITAL_LETTER_ETA, _SMOOTH | _CIRCUMFLEX },
    /* 1F2F */ { GREEK_CAPITAL_LETTER_ETA, _ROUGH | _CIRCUMFLEX },
    /* 1F30 */ { GREEK_SMALL_LETTER_IOTA, _SMOOTH },
    /* 1F31 */ { GREEK_SMALL_LETTER_IOTA, _ROUGH },
    /* 1F32 */ { GREEK_SMALL_LETTER_IOTA, _SMOOTH | _GRAVE },
    /* 1F33 */ { GREEK_SMALL_LETTER_IOTA, _ROUGH | _GRAVE },
    /* 1F34 */ { GREEK_SMALL_LETTER_IOTA, _SMOOTH | _ACUTE },
    /* 1F35 */ { GREEK_SMALL_LETTER_IOTA, _ROUGH | _ACUTE },
    /* 1F36 */ { GREEK_SMALL_LETTER_IOTA, _SMOOTH | _CIRCUMFLEX },
    /* 1F37 */ { GREEK_SMALL_LETTER_IOTA, _ROUGH | _CIRCUMFLEX },
    /* 1F38 */ { GREEK_CAPITAL_LETTER_IOTA, _SMOOTH },
    /* 1F39 */ { GREEK_CAPITAL_LETTER_IOTA, _ROUGH },
    /* 1F3A */ { GREEK_CAPITAL_LETTER_IOTA, _SMOOTH | _GRAVE },
    /* 1F3B */ { GREEK_CAPITAL_LETTER_IOTA, _ROUGH | _GRAVE },
    /* 1F3C */ { GREEK_CAPITAL_LETTER_IOTA, _SMOOTH | _ACUTE },
    /* 1F3D */ { GREEK_CAPITAL_LETTER_IOTA, _ROUGH | _ACUTE },
    /* 1F3E */ { GREEK_CAPITAL_LETTER_IOTA, _SMOOTH | _CIRCUMFLEX },
    /* 1F3F */ { GREEK_CAPITAL_LETTER_IOTA, _ROUGH | _CIRCUMFLEX },
    /* 1F40 */ { GREEK_SMALL_LETTER_OMICRON, _SMOOTH },
    /* 1F41 */ { GREEK_SMALL_LETTER_OMICRON, _ROUGH },
    /* 1F42 */ { GREEK_SMALL_LETTER_OMICRON, _SMOOTH | _GRAVE },
    /* 1F43 */ { GREEK_SMALL_LETTER_OMICRON, _ROUGH | _GRAVE },
    /* 1F44 */ { GREEK_SMALL_LETTER_OMICRON, _SMOOTH | _ACUTE },
    /* 1F45 */ { GREEK_SMALL_LETTER_OMICRON, _ROUGH | _ACUTE },
    /* 1F46 */ { NOCHAR, NOCHAR },
    /* 1F47 */ { NOCHAR, NOCHAR },
    /* 1F48 */ { GREEK_CAPITAL_LETTER_OMICRON, _SMOOTH },
    /* 1F49 */ { GREEK_CAPITAL_LETTER_OMICRON, _ROUGH },
    /* 1F4A */ { GREEK_CAPITAL_LETTER_OMICRON, _SMOOTH | _GRAVE },
    /* 1F4B */ { GREEK_CAPITAL_LETTER_OMICRON, _ROUGH | _GRAVE },
    /* 1F4C */ { GREEK_CAPITAL_LETTER_OMICRON, _SMOOTH | _ACUTE },
    /* 1F4D */ { GREEK_CAPITAL_LETTER_OMICRON, _ROUGH | _ACUTE },
    /* 1F4E */ { NOCHAR, NOCHAR },
    /* 1F4F */ { NOCHAR, NOCHAR },
    /* 1F50 */ { GREEK_SMALL_LETTER_UPSILON, _SMOOTH },
    /* 1F51 */ { GREEK_SMALL_LETTER_UPSILON, _ROUGH },
    /* 1F52 */ { GREEK_SMALL_LETTER_UPSILON, _SMOOTH | _GRAVE },
    /* 1F53 */ { GREEK_SMALL_LETTER_UPSILON, _ROUGH | _GRAVE },
    /* 1F54 */ { GREEK_SMALL_LETTER_UPSILON, _SMOOTH | _ACUTE },
    /* 1F55 */ { GREEK_SMALL_LETTER_UPSILON, _ROUGH | _ACUTE },
    /* 1F56 */ { GREEK_SMALL_LETTER_UPSILON, _SMOOTH | _CIRCUMFLEX },
    /* 1F57 */ { GREEK_SMALL_LETTER_UPSILON, _ROUGH | _CIRCUMFLEX },
    /* 1F58 */ { NOCHAR, NOCHAR },
    /* 1F59 */ { GREEK_CAPITAL_LETTER_UPSILON, _ROUGH },
    /* 1F5A */ { NOCHAR, NOCHAR },
    /* 1F5B */ { GREEK_CAPITAL_LETTER_UPSILON, _ROUGH | _GRAVE },
    /* 1F5C */ { NOCHAR, NOCHAR },
    /* 1F5D */ { GREEK_CAPITAL_LETTER_UPSILON, _ROUGH | _ACUTE },
    /* 1F5E */ { NOCHAR, NOCHAR },
    /* 1F5F */ { GREEK_CAPITAL_LETTER_UPSILON, _ROUGH | _CIRCUMFLEX },
    /* 1F60 */ { GREEK_SMALL_LETTER_OMEGA, _SMOOTH },
    /* 1F61 */ { GREEK_SMALL_LETTER_OMEGA, _ROUGH },
    /* 1F62 */ { GREEK_SMALL_LETTER_OMEGA, _SMOOTH | _GRAVE },
    /* 1F63 */ { GREEK_SMALL_LETTER_OMEGA, _ROUGH | _GRAVE },
    /* 1F64 */ { GREEK_SMALL_LETTER_OMEGA, _SMOOTH | _ACUTE },
    /* 1F65 */ { GREEK_SMALL_LETTER_OMEGA, _ROUGH | _ACUTE },
    /* 1F66 */ { GREEK_SMALL_LETTER_OMEGA, _SMOOTH | _CIRCUMFLEX },
    /* 1F67 */ { GREEK_SMALL_LETTER_OMEGA, _ROUGH | _CIRCUMFLEX },
    /* 1F68 */ { GREEK_CAPITAL_LETTER_OMEGA, _SMOOTH },
    /* 1F69 */ { GREEK_CAPITAL_LETTER_OMEGA, _ROUGH },
    /* 1F6A */ { GREEK_CAPITAL_LETTER_OMEGA, _SMOOTH | _GRAVE },
    /* 1F6B */ { GREEK_CAPITAL_LETTER_OMEGA, _ROUGH | _GRAVE },
    /* 1F6C */ { GREEK_CAPITAL_LETTER_OMEGA, _SMOOTH | _ACUTE },
    /* 1F6D */ { GREEK_CAPITAL_LETTER_OMEGA, _ROUGH | _ACUTE },
    /* 1F6E */ { GREEK_CAPITAL_LETTER_OMEGA, _SMOOTH | _CIRCUMFLEX },
    /* 1F6F */ { GREEK_CAPITAL_LETTER_OMEGA, _ROUGH | _CIRCUMFLEX },
    /* 1F70 */ { GREEK_SMALL_LETTER_ALPHA, _GRAVE },
    /* 1F71 */ { GREEK_SMALL_LETTER_ALPHA, _ACUTE },
    /* 1F72 */ { GREEK_SMALL_LETTER_EPSILON, _GRAVE },
    /* 1F73 */ { GREEK_SMALL_LETTER_EPSILON, _ACUTE },
    /* 1F74 */ { GREEK_SMALL_LETTER_ETA, _GRAVE },
    /* 1F75 */ { GREEK_SMALL_LETTER_ETA, _ACUTE },
    /* 1F76 */ { GREEK_SMALL_LETTER_IOTA, _GRAVE },
    /* 1F77 */ { GREEK_SMALL_LETTER_IOTA, _ACUTE },
    /* 1F78 */ { GREEK_SMALL_LETTER_OMICRON, _GRAVE },
    /* 1F79 */ { GREEK_SMALL_LETTER_OMICRON, _ACUTE },
    /* 1F7A */ { GREEK_SMALL_LETTER_UPSILON, _GRAVE },
    /* 1F7B */ { GREEK_SMALL_LETTER_UPSILON, _ACUTE },
    /* 1F7C */ { GREEK_SMALL_LETTER_OMEGA, _GRAVE },
    /* 1F7D */ { GREEK_SMALL_LETTER_OMEGA, _ACUTE },
    /* 1F7E */ { NOCHAR, NOCHAR },
    /* 1F7F */ { NOCHAR, NOCHAR },
    /* 1F80 */ { GREEK_SMALL_LETTER_ALPHA, _SMOOTH | _IOTA_SUB },
    /* 1F81 */ { GREEK_SMALL_LETTER_ALPHA, _ROUGH | _IOTA_SUB },
    /* 1F82 */ { GREEK_SMALL_LETTER_ALPHA, _SMOOTH | _GRAVE | _IOTA_SUB },
    /* 1F83 */ { GREEK_SMALL_LETTER_ALPHA, _ROUGH | _GRAVE | _IOTA_SUB },
    /* 1F84 */ { GREEK_SMALL_LETTER_ALPHA, _SMOOTH | _ACUTE | _IOTA_SUB },
    /* 1F85 */ { GREEK_SMALL_LETTER_ALPHA, _ROUGH | _ACUTE | _IOTA_SUB },
    /* 1F86 */ { GREEK_SMALL_LETTER_ALPHA, _SMOOTH | _CIRCUMFLEX | _IOTA_SUB },
    /* 1F87 */ { GREEK_SMALL_LETTER_ALPHA, _ROUGH | _CIRCUMFLEX | _IOTA_SUB },
    /* 1F88 */ { GREEK_CAPITAL_LETTER_ALPHA, _SMOOTH | _IOTA_SUB },
    /* 1F89 */ { GREEK_CAPITAL_LETTER_ALPHA, _ROUGH | _IOTA_SUB },
    /* 1F8A */ { GREEK_CAPITAL_LETTER_ALPHA, _SMOOTH | _GRAVE | _IOTA_SUB },
    /* 1F8B */ { GREEK_CAPITAL_LETTER_ALPHA, _ROUGH | _GRAVE | _IOTA_SUB },
    /* 1F8C */ { GREEK_CAPITAL_LETTER_ALPHA, _SMOOTH | _ACUTE | _IOTA_SUB },
    /* 1F8D */ { GREEK_CAPITAL_LETTER_ALPHA, _ROUGH | _ACUTE | _IOTA_SUB },
    /* 1F8E */ { GREEK_CAPITAL_LETTER_ALPHA, _SMOOTH | _CIRCUMFLEX | _IOTA_SUB },
    /* 1F8F */ { GREEK_CAPITAL_LETTER_ALPHA, _ROUGH | _CIRCUMFLEX | _IOTA_SUB },
    /* 1F90 */ { GREEK_SMALL_LETTER_ETA, _SMOOTH | _IOTA_SUB },
    /* 1F91 */ { GREEK_SMALL_LETTER_ETA, _ROUGH | _IOTA_SUB },
    /* 1F92 */ { GREEK_SMALL_LETTER_ETA, _SMOOTH | _GRAVE | _IOTA_SUB },
    /* 1F93 */ { GREEK_SMALL_LETTER_ETA, _ROUGH | _GRAVE | _IOTA_SUB },
    /* 1F94 */ { GREEK_SMALL_LETTER_ETA, _SMOOTH | _ACUTE | _IOTA_SUB },
    /* 1F95 */ { GREEK_SMALL_LETTER_ETA, _ROUGH | _ACUTE | _IOTA_SUB },
    /* 1F96 */ { GREEK_SMALL_LETTER_ETA, _SMOOTH | _CIRCUMFLEX | _IOTA_SUB },
    /* 1F97 */ { GREEK_SMALL_LETTER_ETA, _ROUGH | _CIRCUMFLEX | _IOTA_SUB },
    /* 1F98 */ { GREEK_CAPITAL_LETTER_ETA, _SMOOTH | _IOTA_SUB },
    /* 1F99 */ { GREEK_CAPITAL_LETTER_ETA, _ROUGH | _IOTA_SUB },
    /* 1F9A */ { GREEK_CAPITAL_LETTER_ETA, _SMOOTH | _GRAVE | _IOTA_SUB },
    /* 1F9B */ { GREEK_CAPITAL_LETTER_ETA, _ROUGH | _GRAVE | _IOTA_SUB },
    /* 1F9C */ { GREEK_CAPITAL_LETTER_ETA, _SMOOTH | _ACUTE | _IOTA_SUB },
    /* 1F9D */ { GREEK_CAPITAL_LETTER_ETA, _ROUGH | _ACUTE | _IOTA_SUB },
    /* 1F9E */ { GREEK_CAPITAL_LETTER_ETA, _SMOOTH | _CIRCUMFLEX | _IOTA_SUB },
    /* 1F9F */ { GREEK_CAPITAL_LETTER_ETA, _ROUGH | _CIRCUMFLEX | _IOTA_SUB },
    /* 1FA0 */ { GREEK_SMALL_LETTER_OMEGA, _SMOOTH | _IOTA_SUB },
    /* 1FA1 */ { GREEK_SMALL_LETTER_OMEGA, _ROUGH | _IOTA_SUB },
    /* 1FA2 */ { GREEK_SMALL_LETTER_OMEGA, _SMOOTH | _GRAVE | _IOTA_SUB },
    /* 1FA3 */ { GREEK_SMALL_LETTER_OMEGA, _ROUGH | _GRAVE | _IOTA_SUB },
    /* 1FA4 */ { GREEK_SMALL_LETTER_OMEGA, _SMOOTH | _ACUTE | _IOTA_SUB },
    /* 1FA5 */ { GREEK_SMALL_LETTER_OMEGA, _ROUGH | _ACUTE | _IOTA_SUB },
    /* 1FA6 */ { GREEK_SMALL_LETTER_OMEGA, _SMOOTH | _CIRCUMFLEX | _IOTA_SUB },
    /* 1FA7 */ { GREEK_SMALL_LETTER_OMEGA, _ROUGH | _CIRCUMFLEX | _IOTA_SUB },
    /* 1FA8 */ { GREEK_CAPITAL_LETTER_OMEGA, _SMOOTH | _IOTA_SUB },
    /* 1FA9 */ { GREEK_CAPITAL_LETTER_OMEGA, _ROUGH | _IOTA_SUB },
    /* 1FAA */ { GREEK_CAPITAL_LETTER_OMEGA, _SMOOTH | _GRAVE | _IOTA_SUB },
    /* 1FAB */ { GREEK_CAPITAL_LETTER_OMEGA, _ROUGH | _GRAVE | _IOTA_SUB },
    /* 1FAC */ { GREEK_CAPITAL_LETTER_OMEGA, _SMOOTH | _ACUTE | _IOTA_SUB },
    /* 1FAD */ { GREEK_CAPITAL_LETTER_OMEGA, _ROUGH | _ACUTE | _IOTA_SUB },
    /* 1FAE */ { GREEK_CAPITAL_LETTER_OMEGA, _SMOOTH | _CIRCUMFLEX | _IOTA_SUB },
    /* 1FAF */ { GREEK_CAPITAL_LETTER_OMEGA, _ROUGH | _CIRCUMFLEX | _IOTA_SUB },
    /* 1FB0 */ { GREEK_SMALL_LETTER_ALPHA, _BREVE }, //new
    /* 1FB1 */ { GREEK_SMALL_LETTER_ALPHA, _MACRON },
    /* 1FB2 */ { GREEK_SMALL_LETTER_ALPHA, _GRAVE | _IOTA_SUB },
    /* 1FB3 */ { GREEK_SMALL_LETTER_ALPHA, _IOTA_SUB },
    /* 1FB4 */ { GREEK_SMALL_LETTER_ALPHA, _ACUTE | _IOTA_SUB },
    /* 1FB5 */ { NOCHAR, NOCHAR },
    /* 1FB6 */ { GREEK_SMALL_LETTER_ALPHA, _CIRCUMFLEX },
    /* 1FB7 */ { GREEK_SMALL_LETTER_ALPHA, _CIRCUMFLEX | _IOTA_SUB },
    /* 1FB8 */ { GREEK_CAPITAL_LETTER_ALPHA, _BREVE },
    /* 1FB9 */ {GREEK_CAPITAL_LETTER_ALPHA, _MACRON },
    /* 1FBA */ {GREEK_CAPITAL_LETTER_ALPHA, _GRAVE },
    /* 1FBB */ {GREEK_CAPITAL_LETTER_ALPHA, _ACUTE },
    /* 1FBC */ {GREEK_CAPITAL_LETTER_ALPHA, _IOTA_SUB },
    /* 1FBD */ { NOCHAR, NOCHAR },
    /* 1FBE */ { NOCHAR, NOCHAR },
    /* 1FBF */ { NOCHAR, NOCHAR },
    /* 1FC0 */ { NOCHAR, NOCHAR },
    /* 1FC1 */ { NOCHAR, NOCHAR },
    /* 1FC2 */ { GREEK_SMALL_LETTER_ETA, _GRAVE | _IOTA_SUB },
    /* 1FC3 */ { GREEK_SMALL_LETTER_ETA, _IOTA_SUB },
    /* 1FC4 */ { GREEK_SMALL_LETTER_ETA, _ACUTE | _IOTA_SUB },
    /* 1FC5 */ { NOCHAR, NOCHAR },
    /* 1FC6 */ { GREEK_SMALL_LETTER_ETA, _CIRCUMFLEX },
    /* 1FC7 */ { GREEK_SMALL_LETTER_ETA, _CIRCUMFLEX | _IOTA_SUB },
    /* 1FC8 */ { GREEK_CAPITAL_LETTER_EPSILON, _GRAVE },
    /* 1FC9 */ { GREEK_CAPITAL_LETTER_EPSILON, _ACUTE },
    /* 1FCA */ { GREEK_CAPITAL_LETTER_ETA, _GRAVE },
    /* 1FCB */ { GREEK_CAPITAL_LETTER_ETA, _ACUTE },
    /* 1FCC */ { GREEK_CAPITAL_LETTER_ETA, _IOTA_SUB },
    /* 1FCD */ { NOCHAR, NOCHAR },
    /* 1FCE */ { NOCHAR, NOCHAR },
    /* 1FCF */ { NOCHAR, NOCHAR },
    /* 1FD0 */ { GREEK_SMALL_LETTER_IOTA, _BREVE }, //new
    /* 1FD1 */ { GREEK_SMALL_LETTER_IOTA, _MACRON },
    /* 1FD2 */ { GREEK_SMALL_LETTER_IOTA, _DIAERESIS | _GRAVE },
    /* 1FD3 */ { GREEK_SMALL_LETTER_IOTA, _DIAERESIS | _ACUTE },
    /* 1FD4 */ { NOCHAR, NOCHAR },
    /* 1FD5 */ { NOCHAR, NOCHAR },
    /* 1FD6 */ { GREEK_SMALL_LETTER_IOTA, _CIRCUMFLEX },
    /* 1FD7 */ { GREEK_SMALL_LETTER_IOTA, _DIAERESIS | _CIRCUMFLEX },
    /* 1FD8 */ { GREEK_CAPITAL_LETTER_IOTA, _BREVE },
    /* 1FD9 */ { GREEK_CAPITAL_LETTER_IOTA, _MACRON },
    /* 1FDA */ { GREEK_CAPITAL_LETTER_IOTA, _GRAVE },
    /* 1FDB */ { GREEK_CAPITAL_LETTER_IOTA, _ACUTE },
    /* 1FDC */ { NOCHAR, NOCHAR },
    /* 1FDD */ { NOCHAR, NOCHAR },
    /* 1FDE */ { NOCHAR, NOCHAR },
    /* 1FDF */ { NOCHAR, NOCHAR },
    /* 1FE0 */ { GREEK_SMALL_LETTER_UPSILON, _BREVE }, //new
    /* 1FE1 */ { GREEK_SMALL_LETTER_UPSILON, _MACRON },
    /* 1FE2 */ { GREEK_SMALL_LETTER_UPSILON, _DIAERESIS | _GRAVE },
    /* 1FE3 */ { GREEK_SMALL_LETTER_UPSILON, _DIAERESIS | _ACUTE },
    /* 1FE4 */ { GREEK_SMALL_LETTER_RHO, _SMOOTH },
    /* 1FE5 */ { GREEK_SMALL_LETTER_RHO, _ROUGH },
    /* 1FE6 */ { GREEK_SMALL_LETTER_UPSILON, _CIRCUMFLEX },
    /* 1FE7 */ { GREEK_SMALL_LETTER_UPSILON, _DIAERESIS | _CIRCUMFLEX },
    /* 1FE8 */ { GREEK_CAPITAL_LETTER_UPSILON, _BREVE },
    /* 1FE9 */ { GREEK_CAPITAL_LETTER_UPSILON, _MACRON },
    /* 1FEA */ { GREEK_CAPITAL_LETTER_UPSILON, _GRAVE },
    /* 1FEB */ { GREEK_CAPITAL_LETTER_UPSILON, _ACUTE },
    /* 1FEC */ { NOCHAR, NOCHAR },
    /* 1FED */ { NOCHAR, NOCHAR },
    /* 1FEE */ { NOCHAR, NOCHAR },
    /* 1FEF */ { NOCHAR, NOCHAR },
    /* 1FF0 */ { NOCHAR, NOCHAR },
    /* 1FF1 */ { NOCHAR, NOCHAR },
    /* 1FF2 */ { GREEK_SMALL_LETTER_OMEGA, _GRAVE | _IOTA_SUB },
    /* 1FF3 */ { GREEK_SMALL_LETTER_OMEGA, _IOTA_SUB },
    /* 1FF4 */ { GREEK_SMALL_LETTER_OMEGA, _ACUTE | _IOTA_SUB },
    /* 1FF5 */ { NOCHAR, NOCHAR },
    /* 1FF6 */ { GREEK_SMALL_LETTER_OMEGA, _CIRCUMFLEX },
    /* 1FF7 */ { GREEK_SMALL_LETTER_OMEGA, _CIRCUMFLEX | _IOTA_SUB },
    /* 1FF8 */ { GREEK_CAPITAL_LETTER_OMICRON, _GRAVE },
    /* 1FF9 */ { GREEK_CAPITAL_LETTER_OMICRON, _ACUTE },
    /* 1FFA */ { GREEK_CAPITAL_LETTER_OMEGA, _GRAVE },
    /* 1FFB */ { GREEK_CAPITAL_LETTER_OMEGA, _ACUTE },
    /* 1FFC */ { GREEK_CAPITAL_LETTER_OMEGA, _IOTA_SUB },
    /* 1FFD */ { NOCHAR, NOCHAR },
    /* 1FFE */ { NOCHAR, NOCHAR },
    /* 1FFF */ { NOCHAR, NOCHAR }
};

UCS2 puaGreekLookUp[][2] = {
    /* EAF0 */ { GREEK_SMALL_LETTER_ALPHA, _MACRON | _GRAVE },
    /* EAF1 */ { NOCHAR, NOCHAR },
    /* EAF2 */ { NOCHAR, NOCHAR },
    /* EAF3 */ { GREEK_SMALL_LETTER_ALPHA, _MACRON | _SMOOTH | _GRAVE },
    /* EAF4 */ { GREEK_SMALL_LETTER_ALPHA, _MACRON | _ROUGH | _GRAVE },
    /* EAF5 */ { NOCHAR, NOCHAR },
    /* EAF6 */ { NOCHAR, NOCHAR },
    /* EAF7 */ { NOCHAR, NOCHAR },
    /* EAF8 */ { GREEK_SMALL_LETTER_ALPHA, _BREVE | _GRAVE },
    /* EAF9 */ { GREEK_SMALL_LETTER_ALPHA, _BREVE | _SMOOTH },
    /* EAFA */ { GREEK_SMALL_LETTER_ALPHA, _BREVE | _SMOOTH | _GRAVE },
    /* EAFB */ { GREEK_SMALL_LETTER_ALPHA, _BREVE | _ROUGH | _ACUTE },
    /* EAFC */ { GREEK_SMALL_LETTER_ALPHA, _BREVE | _ROUGH | _GRAVE },
    /* EAFD */ { NOCHAR, NOCHAR },
    /* EAFE */ { NOCHAR, NOCHAR },
    /* EAFF */ { NOCHAR, NOCHAR },
    /* EB00 */ { GREEK_SMALL_LETTER_ALPHA, _MACRON | _ACUTE },
    /* EB01 */ { NOCHAR, NOCHAR },
    /* EB02 */ { NOCHAR, NOCHAR },
    /* EB03 */ { NOCHAR, NOCHAR },
    /* EB04 */ { GREEK_SMALL_LETTER_ALPHA, _MACRON | _SMOOTH },
    /* EB05 */ { GREEK_SMALL_LETTER_ALPHA, _MACRON | _ROUGH },
    /* EB06 */ { NOCHAR, NOCHAR },
    /* EB07 */ { GREEK_SMALL_LETTER_ALPHA, _MACRON | _SMOOTH | _ACUTE },
    /* EB08 */ { NOCHAR, NOCHAR },
    /* EB09 */ { GREEK_SMALL_LETTER_ALPHA, _MACRON | _ROUGH | _ACUTE },
    /* EB0A */ { GREEK_SMALL_LETTER_ALPHA, _BREVE | _ACUTE },
    /* EB0B */ { GREEK_SMALL_LETTER_ALPHA, _BREVE | _ROUGH },
    /* EB0C */ { GREEK_SMALL_LETTER_ALPHA, _BREVE | _SMOOTH | _ACUTE },
    /* EB0D */ { NOCHAR, NOCHAR },
    /* EB0E */ { NOCHAR, NOCHAR },
    /* EB0F */ { NOCHAR, NOCHAR },
    /* EB10 */ { NOCHAR, NOCHAR },
    /* EB11 */ { NOCHAR, NOCHAR },
    /* EB12 */ { NOCHAR, NOCHAR },
    /* EB13 */ { NOCHAR, NOCHAR },
    /* EB14 */ { NOCHAR, NOCHAR },
    /* EB15 */ { NOCHAR, NOCHAR },
    /* EB16 */ { NOCHAR, NOCHAR },
    /* EB17 */ { NOCHAR, NOCHAR },
    /* EB18 */ { NOCHAR, NOCHAR },
    /* EB19 */ { NOCHAR, NOCHAR },
    /* EB1A */ { NOCHAR, NOCHAR },
    /* EB1B */ { NOCHAR, NOCHAR },
    /* EB1C */ { NOCHAR, NOCHAR },
    /* EB1D */ { NOCHAR, NOCHAR },
    /* EB1E */ { NOCHAR, NOCHAR },
    /* EB1F */ { NOCHAR, NOCHAR },
    /* EB20 */ { NOCHAR, NOCHAR },
    /* EB21 */ { NOCHAR, NOCHAR },
    /* EB22 */ { NOCHAR, NOCHAR },
    /* EB23 */ { NOCHAR, NOCHAR },
    /* EB24 */ { NOCHAR, NOCHAR },
    /* EB25 */ { NOCHAR, NOCHAR },
    /* EB26 */ { NOCHAR, NOCHAR },
    /* EB27 */ { NOCHAR, NOCHAR },
    /* EB28 */ { NOCHAR, NOCHAR },
    /* EB29 */ { NOCHAR, NOCHAR },
    /* EB2A */ { NOCHAR, NOCHAR },
    /* EB2B */ { NOCHAR, NOCHAR },
    /* EB2C */ { NOCHAR, NOCHAR },
    /* EB2D */ { NOCHAR, NOCHAR },
    /* EB2E */ { NOCHAR, NOCHAR },
    /* EB2F */ { NOCHAR, NOCHAR },
    /* EB30 */ { NOCHAR, NOCHAR },
    /* EB31 */ { NOCHAR, NOCHAR },
    /* EB32 */ { NOCHAR, NOCHAR },
    /* EB33 */ { NOCHAR, NOCHAR },
    /* EB34 */ { NOCHAR, NOCHAR },
    /* EB35 */ { NOCHAR, NOCHAR },
    /* EB36 */ { NOCHAR, NOCHAR },
    /* EB37 */ { NOCHAR, NOCHAR },
    /* EB38 */ { GREEK_SMALL_LETTER_IOTA, _MACRON | _GRAVE },
    /* EB39 */ { GREEK_SMALL_LETTER_IOTA, _MACRON | _ACUTE },
    /* EB3A */ { NOCHAR, NOCHAR },
    /* EB3B */ { NOCHAR, NOCHAR },
    /* EB3C */ { GREEK_SMALL_LETTER_IOTA, _MACRON | _SMOOTH },
    /* EB3D */ { GREEK_SMALL_LETTER_IOTA, _MACRON | _SMOOTH | _ACUTE },
    /* EB3E */ { GREEK_SMALL_LETTER_IOTA, _MACRON | _ROUGH },
    /* EB3F */ { GREEK_SMALL_LETTER_IOTA, _MACRON | _ROUGH | _ACUTE },
    /* EB40 */ { GREEK_SMALL_LETTER_IOTA, _BREVE | _ACUTE },
    /* EB41 */ { GREEK_SMALL_LETTER_IOTA, _BREVE | _SMOOTH },
    /* EB42 */ { GREEK_SMALL_LETTER_IOTA, _BREVE | _SMOOTH | _ACUTE },
    /* EB43 */ { GREEK_SMALL_LETTER_IOTA, _BREVE | _ROUGH },
    /* EB44 */ { GREEK_SMALL_LETTER_IOTA, _BREVE | _GRAVE },
    /* EB45 */ { GREEK_SMALL_LETTER_IOTA, _BREVE | _SMOOTH | _GRAVE },
    /* EB46 */ { NOCHAR, NOCHAR },
    /* EB47 */ { GREEK_SMALL_LETTER_IOTA, _BREVE | _ROUGH | _ACUTE },
    /* EB48 */ { GREEK_SMALL_LETTER_IOTA, _BREVE | _ROUGH | _GRAVE },
    /* EB49 */ { NOCHAR, NOCHAR },
    /* EB4A */ { NOCHAR, NOCHAR },
    /* EB4B */ { NOCHAR, NOCHAR },
    /* EB4C */ { NOCHAR, NOCHAR },
    /* EB4D */ { NOCHAR, NOCHAR },
    /* EB4E */ { NOCHAR, NOCHAR },
    /* EB4F */ { NOCHAR, NOCHAR },
    /* EB50 */ { NOCHAR, NOCHAR },
    /* EB51 */ { NOCHAR, NOCHAR },
    /* EB52 */ { NOCHAR, NOCHAR },
    /* EB53 */ { NOCHAR, NOCHAR },
    /* EB54 */ { GREEK_SMALL_LETTER_IOTA, _MACRON | _SMOOTH | _GRAVE },
    /* EB55 */ { GREEK_SMALL_LETTER_IOTA, _MACRON | _ROUGH | _GRAVE },
    /* EB56 */ { NOCHAR, NOCHAR },
    /* EB57 */ { NOCHAR, NOCHAR },
    /* EB58 */ { NOCHAR, NOCHAR },
    /* EB59 */ { NOCHAR, NOCHAR },
    /* EB5A */ { NOCHAR, NOCHAR },
    /* EB5B */ { NOCHAR, NOCHAR },
    /* EB5C */ { NOCHAR, NOCHAR },
    /* EB5D */ { NOCHAR, NOCHAR },
    /* EB5E */ { NOCHAR, NOCHAR },
    /* EB5F */ { NOCHAR, NOCHAR },
    /* EB60 */ { NOCHAR, NOCHAR },
    /* EB61 */ { NOCHAR, NOCHAR },
    /* EB62 */ { NOCHAR, NOCHAR },
    /* EB63 */ { NOCHAR, NOCHAR },
    /* EB64 */ { NOCHAR, NOCHAR },
    /* EB65 */ { NOCHAR, NOCHAR },
    /* EB66 */ { NOCHAR, NOCHAR },
    /* EB67 */ { NOCHAR, NOCHAR },
    /* EB68 */ { NOCHAR, NOCHAR },
    /* EB69 */ { NOCHAR, NOCHAR },
    /* EB6A */ { NOCHAR, NOCHAR },
    /* EB6B */ { NOCHAR, NOCHAR },
    /* EB6C */ { NOCHAR, NOCHAR },
    /* EB6D */ { NOCHAR, NOCHAR },
    /* EB6E */ { NOCHAR, NOCHAR },
    /* EB6F */ { GREEK_SMALL_LETTER_UPSILON, _MACRON | _GRAVE },
    /* EB70 */ { NOCHAR, NOCHAR },
    /* EB71 */ { GREEK_SMALL_LETTER_UPSILON, _MACRON | _SMOOTH | _GRAVE },
    /* EB72 */ { NOCHAR, NOCHAR },
    /* EB73 */ { NOCHAR, NOCHAR },
    /* EB74 */ { NOCHAR, NOCHAR },
    /* EB75 */ { GREEK_SMALL_LETTER_UPSILON, _MACRON | _ROUGH | _GRAVE },
    /* EB76 */ { NOCHAR, NOCHAR },
    /* EB77 */ { NOCHAR, NOCHAR },
    /* EB78 */ { NOCHAR, NOCHAR },
    /* EB79 */ { NOCHAR, NOCHAR },
    /* EB7A */ { GREEK_SMALL_LETTER_UPSILON, _MACRON | _ACUTE },
    /* EB7B */ { NOCHAR, NOCHAR },
    /* EB7C */ { NOCHAR, NOCHAR },
    /* EB7D */ { GREEK_SMALL_LETTER_UPSILON, _MACRON | _SMOOTH },
    /* EB7E */ { GREEK_SMALL_LETTER_UPSILON, _MACRON | _ROUGH },
    /* EB7F */ { GREEK_SMALL_LETTER_UPSILON, _MACRON | _SMOOTH | _ACUTE },
    /* EB80 */ { GREEK_SMALL_LETTER_UPSILON, _MACRON | _ROUGH | _ACUTE },

    /* EB81 */ { GREEK_SMALL_LETTER_UPSILON, _BREVE | _ACUTE },
    /* EB82 */ { GREEK_SMALL_LETTER_UPSILON, _BREVE | _ROUGH },
    /* EB83 */ { GREEK_SMALL_LETTER_UPSILON, _BREVE | _GRAVE },
    /* EB84 */ { GREEK_SMALL_LETTER_UPSILON, _BREVE | _SMOOTH },
    /* EB85 */ { GREEK_SMALL_LETTER_UPSILON, _BREVE | _SMOOTH | _ACUTE },
    /* EB86 */ { NOCHAR, NOCHAR },
    /* EB87 */ { NOCHAR, NOCHAR },
    /* EB88 */ { GREEK_SMALL_LETTER_UPSILON, _BREVE | _SMOOTH | _GRAVE },
    /* EB89 */ { GREEK_SMALL_LETTER_UPSILON, _BREVE | _ROUGH | _ACUTE },
    /* EB8A */ { GREEK_SMALL_LETTER_UPSILON, _BREVE | _ROUGH | _GRAVE }
};
/*
bool analyzePrecomposedLetterOLD(UCS2 letter, int *l, int *a)
{
    for (*l = 0; *l < NUM_VOWEL_CODES; (*l)++)
    {
        for (*a = 0; *a < NUM_ACCENT_CODES; (*a)++)
        {
            if (letter == letters[*l][*a])
            {
                //fprintf(stderr, "letter: %d, accent: %d", *l, *a);
                return true;
            }
        }
    }
    return false;
}
*/

/*
 return NOCHAR if the character is invalid greek, NOT_ACCENTABLE_CHAR if it is a consonant,
 or ACCENTABLE_CHAR if it is a vowel.
 For ACCENTABLE_CHAR it puts the base vowel in *l and an accentBitMask in *a
 For NOT_ACCENTABLE_CHAR it puts the consonant in *l which will be the same as letterToAnalyze
 */
int analyzePrecomposedLetter(UCS2 letterToAnalyze, UCS2 *l, unsigned int *a)
{
    int offset = 0;
    UCS2 returnChar = 0; //will be NOCHAR, NOT_ACCENTABLE_CHAR, or the base vowel if ACCENTABLE_CHAR
    if (letterToAnalyze >= 0x0370 && letterToAnalyze <= 0x03FF)
    {
        offset = letterToAnalyze - 0x0370;
        //*l = basicGreekLookUp[offset][0];
        returnChar = basicGreekLookUp[offset][0];
        if (returnChar == NOCHAR)
        {
            return NOCHAR;
        }
        else if (returnChar == NOT_ACCENTABLE_CHAR)
        {
            *l = letterToAnalyze;
            return NOT_ACCENTABLE_CHAR;
        }
        else if (returnChar > NOT_ACCENTABLE_CHAR)
        {
            *l = returnChar;
            *a |= basicGreekLookUp[offset][1];
            //fprintf(stderr, "basic letter: %d, accent: %d", *l, *a);
            return ACCENTABLE_CHAR;
        }
    }
    else if (letterToAnalyze >= 0x1F00 && letterToAnalyze <= 0x1FFF)
    {
        offset = letterToAnalyze - 0x1F00;
        returnChar = extendedGreekLookUp[offset][0];
        if (returnChar == NOCHAR)
        {
            return NOCHAR;
        }
        else if (returnChar == NOT_ACCENTABLE_CHAR)
        {
            *l = letterToAnalyze;
            return NOT_ACCENTABLE_CHAR;
        }
        else if (returnChar > NOT_ACCENTABLE_CHAR)
        {
            *l = returnChar;
            *a |= extendedGreekLookUp[offset][1];
            //fprintf(stderr, "extended letter: %d, accent: %d", *l, *a);
            return ACCENTABLE_CHAR;
        }
    }
    else if (letterToAnalyze >= 0xEAF0 && letterToAnalyze <= 0xEB8A)
    {
        offset = letterToAnalyze - 0xEAF0;
        returnChar = puaGreekLookUp[offset][0];
        if (returnChar == NOCHAR)
        {
            return NOCHAR;
        }
        else if (returnChar == NOT_ACCENTABLE_CHAR)
        {
            *l = letterToAnalyze;
            return NOT_ACCENTABLE_CHAR;
        }
        else if (returnChar > NOT_ACCENTABLE_CHAR)
        {
            *l = returnChar;
            *a |= puaGreekLookUp[offset][1];
            //fprintf(stderr, "pua letter: %d, accent: %d", *l, *a);
            return ACCENTABLE_CHAR;
        }
    }
    //assert(1 == 2); //always assert if we get to here
    return NOCHAR;
}
/*
int a()
{
    while (scanLetter(<#UCS2 *ucs2String#>, <#int i#>, <#int len#>, <#UCS2 *letterCode#>, <#int *accentBitMask#>))
        ;
    
    return 0;
}

int scanLetter(UCS2 *ucs2String, int len, UCS2 *letterCode, int *accentBitMask, UCS2 *end)
{
    UCS2 l;
    int a;
    int letterLen = 0;
    int r = analyzePrecomposedLetter(*ucs2String, &l, &a);
    if (r == NOT_ACCENTABLE_CHAR)
    {
        *letterCode = l;
        letterLen = 1;
    }
    else if (r == ACCENTABLE_CHAR)
    {
        *letterCode = l;
        *accentBitMask = a;
        letterLen = 1;
        while ( isCombiningDiacritic( *(++ucs2String) ) )
        {
            //need to add this diacritic to accenBitmask
            letterLen++;
        }
    }
    else if (r == NOCHAR)
    {
        //return letterLen;
    }
    end = ucs2String;
    return letterLen;
}
*/

//this function takes a utf8 string argument a and fills
//buffer with a string representing the hex codepoints of
//each character up to bufferLen - 1.
int hcucHex(const unsigned char *a, int bufferLen, char *buffer)
{
    int uc_a = 0;
    char *p = buffer;
    int len = 0;
    for( ; *a ; )
    {
        uc_a = utf8_to_ucs2 (a, &a);
        if (uc_a == -1)
        {
            assert(uc_a > -1);
            return -1; //error
        }
        else
        {
        //https://stackoverflow.com/questions/11718573/snprintf-in-a-loop-does-not-work-on-linux
            int res = snprintf(p+len, bufferLen - len, "%04X ", uc_a);
            if (res < 0) // -1 on error
            {
                break;
            }
            else //else # chars written
            {
                len += res;
                if (len >= bufferLen)
                {
                    break;
                }
            }
        }
    }
    return 1;
}

//strip diacritics and other chars
int toAlphaSort(char *str, char *buffer, int bufferLen)
{
    
    return 1;
}

int stripAccentSQL(const unsigned char *a, int bufferLen, char *buffer)
{
    int uc_a = 0;
    char *p = buffer;
    int len = 0;
    for( ; *a ; )
    {
        uc_a = utf8_to_ucs2 (a, &a);
        if (uc_a == -1)
        {
            assert(uc_a > -1);
            return -1; //error
        }
        else
        {
        //https://stackoverflow.com/questions/11718573/snprintf-in-a-loop-does-not-work-on-linux
            int res = snprintf(p+len, bufferLen - len, "%04X ", uc_a);
            if (res < 0) // -1 on error
            {
                break;
            }
            else //else # chars written
            {
                len += res;
                if (len >= bufferLen)
                {
                    break;
                }
            }
        }
    }
    return 1;
}

//this function returns 1 if the utf8 string a contains
//any private-use area characters, 0 otherwise
int hccontainsPUA(const unsigned char *a)
{
    int uc_a = 0;
    for( ; *a ; )
    {
        uc_a = utf8_to_ucs2 (a, &a);
        if (uc_a == -1)
        {
            assert(uc_a > -1);
            return 1; //error
        }
        else
        {
            if (uc_a >= 0xEAF0 && uc_a <= 0xEB80)
            {
                int offset = uc_a - 0xEAF0;
                int returnChar = puaGreekLookUp[offset][0];
                if (returnChar != NOCHAR)
                {
                    return 1;
                }
            }
        }
    }
    return 0;
}


/*
 get a char or aend
    get b char or bend
    if both not at end compare, if same and not at end continue, else return
 if one or both at end, equal if both, else compare return
 
 if we get to the end of a, we still need to go through b one more time to see if they are the same length
 
*/
//returns -1 if a is before b, 0 if equal, 1 if b is before a
//skip everything until real greek char, then stop at first non-greek or end
//maybe only comma should cause end of lemma?
int compareSort(int len_a, const unsigned char *a, int len_b, const unsigned char *b)
{
    //take care of zero length arguments
    if (len_a < 1 && len_b < 1)
    {
        return 0;
    }
    else if (len_a < 1)
    {
        return -1;
    }
    else if (len_b < 1)
    {
        return 1;
    }
    
    int uc_a = 0; //int because UCS2 is unsigned
    int uc_b = 0; //int because UCS2 is unsigned
    int type_a = 0;
    int type_b = 0;
    UCS2 base_a = 0; //the base chars
    UCS2 base_b = 0; //the base chars
    unsigned diacritics_a = 0;
    unsigned diacritics_b = 0;
    int idx_a = 0;
    int idx_b = 0;
    const unsigned char *end_a;
    const unsigned char *end_b;
    bool seenOne_a = false;
    bool seenOne_b = false;

    for( ; idx_a < len_a ; )
    {
        uc_a = utf8_to_ucs2 (a, &end_a);
        idx_a += (end_a - a);
        a = end_a;
        if (uc_a == -1)
        {
            assert(uc_a > -1); //bad utf8
            //return -1; //error
            //continue;
            idx_a = len_a;
            break;
        }
        else
        {
            /*
            if (uc_a == 0x0020 || uc_a == 0x002C || uc_a == 0x2014 || uc_a == 0x002D || uc_a == 0x002E)
            {
                continue;
            }*/
            if (isCombiningDiacritic(uc_a))
            {
                if (idx_a >= len_a)
                {
                    goto FALLTHROUGH; //
                }
                else
                {
                    continue;
                }
                //fallThrough = true;
                
            }
            
            base_a = 0; //reset for debugging
            type_a = analyzePrecomposedLetter(uc_a, &base_a, &diacritics_a);
            if (type_a == NOCHAR)
            {
                //fprintf(stderr, "CompA: %.*s AA %04X -> %04X\n", len_a, aa, uc_a, base_a);
                if (!seenOne_a)
                {
                    continue;
                }
                else
                {
                    //stop, is end
                    idx_a = len_a;
                }
            }
            else if (!seenOne_a)
            {
                seenOne_a = true;
            }
            
            //get sort order for base characters
            int sort_a = 0;
            int sort_b = 0;
            if (type_a != NOCHAR)
            {
                if (base_a >= 0x0370 && base_a <= 0x03FF)
                {
                    sort_a = basicGreekLookUp[base_a - 0x0370][2];
                    if (sort_a < 1)
                    {
                        continue;
                    }
                }
                else
                {
                    if (!seenOne_a)
                    {
                        continue;
                    }
                    else
                    {
                        //stop, is end
                        idx_a = len_a;
                        break;
                    }
                }
            }
        FALLTHROUGH:
            for( ; idx_b < len_b ; )
            {
                uc_b = utf8_to_ucs2 (b, &end_b);
                //printf("1 index %d, %d, %04X\n", idx_b, len_b, uc_b);
                idx_b += (end_b - b);
                //printf("AAA: %d\n", (bp - b));
                b = end_b;
                if (uc_b == -1)
                {
                    assert(uc_b > -1);
                    //return -1; //error
                    //continue;
                    idx_b = len_b;
                    break;
                }
                else
                {
                    /*
                    if (uc_b == 0x0020 || uc_b == 0x002C || uc_b == 0x2014 || uc_b == 0x002D || uc_b == 0x002E)
                    {
                        if (idx_b == len_b )
                        {
                            return 1; //last char in b is one to skip
                        }
                        else
                        {
                            continue;
                        }
                    }*/
                    if (isCombiningDiacritic(uc_b))
                    {
                        continue;
                    }
                    
                    base_b = 0; //reset for debugging
                    type_b = analyzePrecomposedLetter(uc_b, &base_b, &diacritics_b);
                    if (type_b == NOCHAR)
                    {
                        //fprintf(stderr, "CompB %.*s AA %04X -> %04X\n", len_b, bb, uc_b, base_b);
                        if (!seenOne_b)
                        {
                            continue;
                        }
                        else
                        {
                            //stop is end
                            idx_b = len_b;
                            break;
                        }
                    }
                    else if (!seenOne_b)
                    {
                        seenOne_b = true;
                    }
                    
                    //get sort order for base characters
                    sort_b = 0;
                    if (base_b >= 0x0370 && base_b <= 0x03FF)
                    {
                        sort_b = basicGreekLookUp[base_b - 0x0370][2];
                        if (sort_b > 0)
                        {
                            //printf("B1: %04x\n", base_b);
                            break;
                        }
                        else
                        {
                            //stop, is end
                            idx_b = len_b;
                            //printf("B2: %04x\n", base_b);
                            break;
                        }
                    }
                    else
                    {
                        if (!seenOne_b)
                        {
                            continue;
                        }
                        else
                        {
                            //stop, is end
                            idx_b = len_b;
                            break;
                        }
                    }
                    
                }
            }
            /*
            if (sort_a < 1 || sort_b < 1 || idx_b >= len_b || idx_a >= len_a)
            {
                if ((idx_a == len_a ) && (idx_b == len_b ))
                {
                    return 0;
                }
                else if (idx_a == len_a )
                {
                    return -1;
                }
                else if (idx_b == len_b )
                {
                    return 1;
                }
            }
        */
            //compare here
            if (sort_a > sort_b)
            {
                return 1;
            }
            else if (sort_b > sort_a)
            {
                return -1;
            }
            else
            {
                continue;
                /*
                if ((idx_a == len_a ) && (idx_b == len_b ))
                {
                    printf("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX3\n");
                    return 0;
                }
                else if (idx_a == len_a )
                {
                    printf("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX4\n");
                    return -1;
                }
                else if (idx_b == len_b )
                {
                    printf("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX5\n");
                    return 1;
                }
                else
                {
                    printf("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX6\n");
                    continue;
                }*/
            }
        }
    }
    
    //we need to be sure b does not have any testable chars left; what if it has combining at end.
    bool bHasMore = false;
    for( ; idx_b < len_b ; )
    {
        uc_b = utf8_to_ucs2 (b, &end_b);
        //printf("2 index %d, %d, %04X\n", idx_b, len_b, uc_b);
        idx_b += (end_b - b);
        //printf("AAA: %d\n", (bp - b));
        b = end_b;
        if (uc_b == -1)
        {
            assert(uc_b > -1);
            //return -1; //error
            //continue;
            idx_b = len_b;
            break;
        }
        else
        {
            if (isCombiningDiacritic(uc_b))
            {
                continue;
            }
            
            base_b = 0; //reset for debugging
            type_b = analyzePrecomposedLetter(uc_b, &base_b, &diacritics_b);
            if (type_b != NOCHAR)
            {
                bHasMore = true;
                break;
            }
            else
            {
                bHasMore = false;
                 break;
            }
        }
    }
    
    
    if ((idx_a == len_a) && !bHasMore)
    {
        return 0;
    }
    else if (idx_a == len_a)
    {
        return -1;
    }
    else if (!bHasMore)
    {
        return 1;
    }
    else
    {
        assert(1 == 2); //error
        return -1;
    }
}


//return 0 for invalid letter
UCS2 getPrecomposedLetter(int letterIndex, int diacriticMask)
{
    int accentIndex = 0;
    
    switch (diacriticMask)
    {
        case 0:
            accentIndex = NORMAL;
            break;
        case (_SMOOTH):
            accentIndex = PSILI;
            break;
        case (_ROUGH):
            accentIndex = DASIA;
            break;
        case (_ACUTE):
#ifdef USE_TONOS //this is defined, or not, in GreekUnicode.h
            accentIndex = TONOS;
#else
            accentIndex = OXIA;
#endif
            break;
        case (_SMOOTH | _ACUTE):
            accentIndex = PSILI_AND_OXIA;
            break;
        case (_ROUGH | _ACUTE):
            accentIndex = DASIA_AND_OXIA;
            break;
        case  (_GRAVE):
            accentIndex = VARIA;
            break;
        case (_SMOOTH | _GRAVE):
            accentIndex = PSILI_AND_VARIA;
            break;
        case (_ROUGH | _GRAVE):
            accentIndex = DASIA_AND_VARIA;
            break;
        case (_CIRCUMFLEX):
            accentIndex = PERISPOMENI;
            break;
        case (_SMOOTH | _CIRCUMFLEX):
            accentIndex = PSILI_AND_PERISPOMENI;
            break;
        case (_ROUGH | _CIRCUMFLEX):
            accentIndex = DASIA_AND_PERISPOMENI;
            break;
        case (_IOTA_SUB):
            accentIndex = YPOGEGRAMMENI;
            break;
        case (_SMOOTH | _IOTA_SUB):
            accentIndex = PSILI_AND_YPOGEGRAMMENI;
            break;
        case (_ROUGH | _IOTA_SUB):
            accentIndex = DASIA_AND_YPOGEGRAMMENI;
            break;
        case (_ACUTE | _IOTA_SUB):
            accentIndex = OXIA_AND_YPOGEGRAMMENI;
            break;
        case (_SMOOTH | _ACUTE | _IOTA_SUB):
            accentIndex = PSILI_AND_OXIA_AND_YPOGEGRAMMENI;
            break;
        case (_ROUGH | _ACUTE | _IOTA_SUB):
            accentIndex = DASIA_AND_OXIA_AND_YPOGEGRAMMENI;
            break;
        case (_GRAVE | _IOTA_SUB):
            accentIndex = VARIA_AND_YPOGEGRAMMENI;
            break;
        case (_SMOOTH | _GRAVE | _IOTA_SUB):
            accentIndex = PSILI_AND_VARIA_AND_YPOGEGRAMMENI;
            break;
        case (_ROUGH | _GRAVE | _IOTA_SUB):
            accentIndex = DASIA_AND_VARIA_AND_YPOGEGRAMMENI;
            break;
        case (_CIRCUMFLEX | _IOTA_SUB):
            accentIndex = PERISPOMENI_AND_YPOGEGRAMMENI;
            break;
        case (_SMOOTH | _CIRCUMFLEX | _IOTA_SUB):
            accentIndex = PSILI_AND_PERISPOMENI_AND_YPOGEGRAMMENI;
            break;
        case (_ROUGH | _CIRCUMFLEX | _IOTA_SUB):
            accentIndex = DASIA_AND_PERISPOMENI_AND_YPOGEGRAMMENI;
            break;
        case (_DIAERESIS):
            accentIndex = DIALYTIKA;
            break;
        case (_ACUTE | _DIAERESIS):
#ifdef USE_TONOS //this is defined, or not, in GreekUnicode.h
            accentIndex = DIALYTIKA_AND_TONOS;
#else
            accentIndex = DIALYTIKA_AND_OXIA;
#endif
            break;
        case (_GRAVE | _DIAERESIS):
            accentIndex = DIALYTIKA_AND_VARIA;
            break;
        case (_CIRCUMFLEX | _DIAERESIS):
            accentIndex = DIALYTIKA_AND_PERISPOMENON;
            break;
        case (_MACRON):
            accentIndex = MACRON_PRECOMPOSED;
            break;
        case (_BREVE):
            accentIndex = BREVE_PRECOMPOSED;
            break;
#ifdef ALLOW_PRIVATE_USE_AREA
        case (_MACRON | _SMOOTH):
            accentIndex = MACRON_AND_SMOOTH;
            break;
        case (_MACRON | _SMOOTH | _ACUTE):
            accentIndex = MACRON_AND_SMOOTH_AND_ACUTE;
            break;
        case (_MACRON | _SMOOTH | _GRAVE):
            accentIndex = MACRON_AND_SMOOTH_AND_GRAVE;
            break;
        case (_MACRON | _ROUGH):
            accentIndex = MACRON_AND_ROUGH;
            break;
        case (_MACRON | _ROUGH | _ACUTE):
            accentIndex = MACRON_AND_ROUGH_AND_ACUTE;
            break;
        case (_MACRON | _ROUGH | _GRAVE):
            accentIndex = MACRON_AND_ROUGH_AND_GRAVE;
            break;
        case (_MACRON | _ACUTE):
            accentIndex = MACRON_AND_ACUTE;
            break;
        case (_MACRON | _GRAVE):
            accentIndex = MACRON_AND_GRAVE;
            break;
        case (_BREVE | _SMOOTH):
            accentIndex = BREVE_AND_SMOOTH;
            break;
        case (_BREVE | _SMOOTH | _ACUTE):
            accentIndex = BREVE_AND_SMOOTH_AND_ACUTE;
            break;
        case (_BREVE | _SMOOTH | _GRAVE):
            accentIndex = BREVE_AND_SMOOTH_AND_GRAVE;
            break;
        case (_BREVE | _ROUGH):
            accentIndex = BREVE_AND_ROUGH;
            break;
        case (_BREVE | _ROUGH | _ACUTE):
            accentIndex = BREVE_AND_ROUGH_AND_ACUTE;
            break;
        case (_BREVE | _ROUGH | _GRAVE):
            accentIndex = BREVE_AND_ROUGH_AND_GRAVE;
            break;
        case (_BREVE | _ACUTE):
            accentIndex = BREVE_AND_ACUTE;
            break;
        case (_BREVE | _GRAVE):
            accentIndex = BREVE_AND_GRAVE;
            break;
#endif
        default:
            return 0; //or set accent = 0 if none of these?
            break;
    }
    if (letterIndex > -1)
        return letters[letterIndex][accentIndex];
    else
        return 0;
}

bool isCombiningDiacritic(UCS2 l)
{
    switch (l)
    {
        case COMBINING_MACRON:
        case COMBINING_ACUTE:
        case COMBINING_GRAVE:
        case COMBINING_CIRCUMFLEX:
        case COMBINING_IOTA_SUBSCRIPT:
        case COMBINING_SMOOTH_BREATHING:
        case COMBINING_ROUGH_BREATHING:
        case COMBINING_DIAERESIS:
        case COMBINING_BREVE:
            return true;
    }
    
    return false;
}

bool isBareVowel(UCS2 l)
{
    switch (l)
    {
        case GREEK_SMALL_LETTER_ALPHA:
        case GREEK_SMALL_LETTER_EPSILON:
        case GREEK_SMALL_LETTER_ETA:
        case GREEK_SMALL_LETTER_IOTA:
        case GREEK_SMALL_LETTER_UPSILON:
        case GREEK_SMALL_LETTER_OMEGA:
        case GREEK_CAPITAL_LETTER_ALPHA:
        case GREEK_CAPITAL_LETTER_EPSILON:
        case GREEK_CAPITAL_LETTER_ETA:
        case GREEK_CAPITAL_LETTER_IOTA:
        case GREEK_CAPITAL_LETTER_UPSILON:
        case GREEK_CAPITAL_LETTER_OMEGA:
            return true;
    }
    
    return false;
}

int ucs2ToLetterIndex(UCS2 l)
{
    if (l == GREEK_SMALL_LETTER_ALPHA)
        return ALPHA;
    else if (l == GREEK_SMALL_LETTER_EPSILON)
        return EPSILON;
    else if (l == GREEK_SMALL_LETTER_ETA)
        return ETA;
    else if (l == GREEK_SMALL_LETTER_IOTA)
        return IOTA;
    else if (l == GREEK_SMALL_LETTER_OMICRON)
        return OMICRON;
    else if (l == GREEK_SMALL_LETTER_UPSILON)
        return UPSILON;
    else if (l == GREEK_SMALL_LETTER_OMEGA)
        return OMEGA;
    else if (l == GREEK_CAPITAL_LETTER_ALPHA)
        return ALPHA_CAP;
    else if (l == GREEK_CAPITAL_LETTER_EPSILON)
        return EPSILON_CAP;
    else if (l == GREEK_CAPITAL_LETTER_ETA)
        return ETA_CAP;
    else if (l == GREEK_CAPITAL_LETTER_IOTA)
        return IOTA_CAP;
    else if (l == GREEK_CAPITAL_LETTER_OMICRON)
        return OMICRON_CAP;
    else if (l == GREEK_CAPITAL_LETTER_UPSILON)
        return UPSILON_CAP;
    else if (l == GREEK_CAPITAL_LETTER_OMEGA)
        return OMEGA_CAP;
    else
        return -1;
}
/*
int letterIndexToUCS2(UCS2 l)
{
    if (l == ALPHA)
        return GREEK_SMALL_LETTER_ALPHA;
    else if (l == EPSILON)
        return GREEK_SMALL_LETTER_EPSILON;
    else if (l == ETA)
        return GREEK_SMALL_LETTER_ETA;
    else if (l == IOTA)
        return GREEK_SMALL_LETTER_IOTA;
    else if (l == OMICRON)
        return GREEK_SMALL_LETTER_OMICRON;
    else if (l == UPSILON)
        return GREEK_SMALL_LETTER_UPSILON;
    else if (l == OMEGA)
        return GREEK_SMALL_LETTER_OMEGA;
    else if (l == ALPHA_CAP)
        return GREEK_CAPITAL_LETTER_ALPHA;
    else if (l == EPSILON_CAP)
        return GREEK_CAPITAL_LETTER_EPSILON;
    else if (l == ETA_CAP)
        return GREEK_CAPITAL_LETTER_ETA;
    else if (l == IOTA_CAP)
        return GREEK_CAPITAL_LETTER_IOTA;
    else if (l == OMICRON_CAP)
        return GREEK_CAPITAL_LETTER_OMICRON;
    else if (l == UPSILON_CAP)
        return GREEK_CAPITAL_LETTER_UPSILON;
    else if (l == OMEGA_CAP)
        return GREEK_CAPITAL_LETTER_OMEGA;
    else
        return 0;
}
*/
bool isLegalDiacriticForLetter(UCS2 letter, int accentToAdd)
{
    switch (accentToAdd)
    {
        case CIRCUMFLEX:
            if (letter != GREEK_SMALL_LETTER_ALPHA && letter != GREEK_SMALL_LETTER_ETA && letter != GREEK_SMALL_LETTER_IOTA && letter != GREEK_SMALL_LETTER_UPSILON && letter != GREEK_SMALL_LETTER_OMEGA && letter != GREEK_CAPITAL_LETTER_ALPHA && letter != GREEK_CAPITAL_LETTER_ETA && letter != GREEK_CAPITAL_LETTER_IOTA && letter != GREEK_CAPITAL_LETTER_UPSILON && letter != GREEK_CAPITAL_LETTER_OMEGA)
            {
                return false;
            }
            break;
        case MACRON:
            if (letter != GREEK_SMALL_LETTER_ALPHA && letter != GREEK_SMALL_LETTER_IOTA && letter != GREEK_SMALL_LETTER_UPSILON && letter != GREEK_CAPITAL_LETTER_ALPHA && letter != GREEK_CAPITAL_LETTER_IOTA && letter != GREEK_CAPITAL_LETTER_UPSILON)
            {
                return false;
            }
            break;
        case BREVE:
            if (letter != GREEK_SMALL_LETTER_ALPHA && letter != GREEK_SMALL_LETTER_IOTA && letter != GREEK_SMALL_LETTER_UPSILON && letter != GREEK_CAPITAL_LETTER_ALPHA && letter != GREEK_CAPITAL_LETTER_IOTA && letter != GREEK_CAPITAL_LETTER_UPSILON)
            {
                return false;
            }
            break;
        case IOTA_SUBSCRIPT:
            if (letter != GREEK_SMALL_LETTER_ALPHA && letter != GREEK_SMALL_LETTER_ETA && letter != GREEK_SMALL_LETTER_OMEGA && letter != GREEK_CAPITAL_LETTER_ALPHA && letter != GREEK_CAPITAL_LETTER_ETA && letter != GREEK_CAPITAL_LETTER_OMEGA)
            {
                return false;
            }
            break;
        case DIAERESIS:
            if (letter != GREEK_SMALL_LETTER_IOTA && letter != GREEK_SMALL_LETTER_UPSILON && letter != GREEK_CAPITAL_LETTER_IOTA && letter != GREEK_CAPITAL_LETTER_UPSILON)
            {
                return false;
            }
            break;
    }
    return true;
}

//adjusts diacritics based on one being added
unsigned int updateDiacritics(UCS2 letter, int accentToAdd, unsigned int accentBitMask, bool toggleOff)
{
    //keep in order of enum so compiler can optimize switch
    switch (accentToAdd)
    {
        case ACUTE:
            if (toggleOff && (accentBitMask & _ACUTE) == _ACUTE)
                accentBitMask &= ~_ACUTE;
            else
                accentBitMask |= _ACUTE;
            accentBitMask &= ~(_GRAVE | _CIRCUMFLEX); //turn off...
            break;
        case CIRCUMFLEX:
            if (toggleOff && (accentBitMask & _CIRCUMFLEX) == _CIRCUMFLEX)
                accentBitMask &= ~_CIRCUMFLEX;
            else
                accentBitMask |= _CIRCUMFLEX;
            accentBitMask &= ~(_ACUTE | _GRAVE | _MACRON); //turn off
            break;
        case GRAVE:
            if (toggleOff && (accentBitMask & _GRAVE) == _GRAVE)
                accentBitMask &= ~_GRAVE;
            else
                accentBitMask |= _GRAVE;
            accentBitMask &= ~(_ACUTE | _CIRCUMFLEX);
            break;
        case MACRON:
            if (toggleOff && (accentBitMask & _MACRON) == _MACRON)
                accentBitMask &= ~_MACRON;
            else
                accentBitMask |= _MACRON;
            accentBitMask &= ~_CIRCUMFLEX;
            accentBitMask &= ~_BREVE;
            break;
        case BREVE:
            if (toggleOff && (accentBitMask & _BREVE) == _BREVE)
                accentBitMask &= ~_BREVE;
            else
                accentBitMask |= _BREVE;
            accentBitMask &= ~_CIRCUMFLEX;
            accentBitMask &= ~_MACRON;
            accentBitMask &= ~_IOTA_SUB;
            break;
        case ROUGH_BREATHING:
            if (toggleOff && (accentBitMask & _ROUGH) == _ROUGH)
                accentBitMask &= ~_ROUGH;
            else
                accentBitMask |= _ROUGH;
            accentBitMask &= ~(_SMOOTH | _DIAERESIS);
            break;
        case SMOOTH_BREATHING:
            if (toggleOff && (accentBitMask & _SMOOTH) == _SMOOTH)
                accentBitMask &= ~_SMOOTH;
            else
                accentBitMask |= _SMOOTH;
            accentBitMask &= ~(_ROUGH | _DIAERESIS);
            break;
        case IOTA_SUBSCRIPT:
            if (toggleOff && (accentBitMask & _IOTA_SUB) == _IOTA_SUB)
                accentBitMask &= ~_IOTA_SUB;
            else
                accentBitMask |= _IOTA_SUB;
            accentBitMask &= ~_BREVE;
            break;
        case UNDERDOT:
            if (toggleOff && (accentBitMask & _UNDERDOT) == _UNDERDOT)
                accentBitMask &= ~_UNDERDOT;
            else
                accentBitMask |= _UNDERDOT;
            break;
        case DIAERESIS:
            if (letter == GREEK_CAPITAL_LETTER_IOTA || letter == GREEK_CAPITAL_LETTER_UPSILON)
            {
                accentBitMask &= ~(_ACUTE | _GRAVE | _CIRCUMFLEX | _MACRON);
            }
            
            if (toggleOff && (accentBitMask & _DIAERESIS) == _DIAERESIS)
                accentBitMask &= ~_DIAERESIS;
            else
                accentBitMask |= _DIAERESIS;
            accentBitMask &= ~(_SMOOTH | _ROUGH);
            break;
        default:
            break;
    }
    return accentBitMask;
}

int analyzeCombiningChars(UCS2 *ucs2String, int i, int len, UCS2 *letter, unsigned int *accentBitMask)
{
    unsigned char letterLen = 1;

    //this needs some fixing
    if (len > 1 )
    {
        for (int j = 1; j <= MAX_COMBINING && i + j < len; j++)
        {
            if (ucs2String[i + j] == COMBINING_ROUGH_BREATHING)
            {
                letterLen++;
                *accentBitMask |= _ROUGH;
            }
            else if (ucs2String[i + j] == COMBINING_SMOOTH_BREATHING)
            {
                letterLen++;
                *accentBitMask |= _SMOOTH;
            }
            else if (ucs2String[i + j] == COMBINING_ACUTE)
            {
                letterLen++;
                *accentBitMask |= _ACUTE;
            }
            else if (ucs2String[i + j] == COMBINING_GRAVE)
            {
                letterLen++;
                *accentBitMask |= _GRAVE;
            }
            else if (ucs2String[i + j] == COMBINING_CIRCUMFLEX)
            {
                letterLen++;
                *accentBitMask |= _CIRCUMFLEX;
            }
            else if (ucs2String[i + j] == COMBINING_MACRON)
            {
                letterLen++;
                *accentBitMask |= _MACRON;
            }
            else if (ucs2String[i + j] == COMBINING_BREVE)
            {
                letterLen++;
                *accentBitMask |= _BREVE;
            }
            else if (ucs2String[i + j] == COMBINING_IOTA_SUBSCRIPT)
            {
                letterLen++;
                *accentBitMask |= _IOTA_SUB;
            }
            else if (ucs2String[i + j] == COMBINING_DIAERESIS)
            {
                letterLen++;
                *accentBitMask |= _DIAERESIS;
            }
            else if (ucs2String[i + j] == COMBINING_UNDERDOT)
            {
                letterLen++;
                *accentBitMask |= _UNDERDOT;
            }
            else
            {
                break;
            }
        }
    }
    return letterLen;
}

//passes back the letterCode and diacriticMask for this letter
//returns the number of characters or -1, if not valid or unknown
int analyzeLetter(UCS2 *ucs2String, int i, int len, UCS2 *letter, unsigned int *accentBitMask)
{
    int letterLen = analyzeCombiningChars(ucs2String, i, len, letter, accentBitMask);
    
    if (analyzePrecomposedLetter(ucs2String[i], letter, accentBitMask) != ACCENTABLE_CHAR)
    {
        return -1;
    }
    //*accentBitMask = precomposedIndexToBitMask(precomposedIndex, *accentBitMask);
    
    return letterLen;
}

bool makeLetterCombining(UCS2 *ucs2String, int *newLetterLen, UCS2 letter, unsigned int accentBitMask, int unicodeMode)
{
    int i = 0;

    if ((accentBitMask & _MACRON) == _MACRON)
        (*newLetterLen)++;
    if ((accentBitMask & _BREVE) == _BREVE)
        (*newLetterLen)++;
    if ((accentBitMask & _SMOOTH) == _SMOOTH)
        (*newLetterLen)++;
    if ((accentBitMask & _ROUGH) == _ROUGH)
        (*newLetterLen)++;
    if ((accentBitMask & _ACUTE) == _ACUTE)
        (*newLetterLen)++;
    if ((accentBitMask & _GRAVE) == _GRAVE)
        (*newLetterLen)++;
    if ((accentBitMask & _CIRCUMFLEX) == _CIRCUMFLEX)
        (*newLetterLen)++;
    if ((accentBitMask & _IOTA_SUB) == _IOTA_SUB)
        (*newLetterLen)++;
    if ((accentBitMask & _DIAERESIS) == _DIAERESIS)
        (*newLetterLen)++;
    if ((accentBitMask & _UNDERDOT) == _UNDERDOT)
        (*newLetterLen)++;

    ucs2String[i] = letter; //set base letter

    unsigned char numAccents = 1;
    //loop so that order is determined by combiningAccents array
    for (int k = 0; k < NUM_COMBINING_ACCENTS; k++)
    {
        if (combiningAccents[k] == COMBINING_MACRON && (accentBitMask & _MACRON) == _MACRON)
        {
            ucs2String[i + numAccents] = combiningAccents[k];
            numAccents++;
        }
        else if (combiningAccents[k] == COMBINING_BREVE && (accentBitMask & _BREVE) == _BREVE)
        {
            ucs2String[i + numAccents] = combiningAccents[k];
            numAccents++;
        }
        else if (combiningAccents[k] == COMBINING_ROUGH_BREATHING && (accentBitMask & _ROUGH) == _ROUGH)
        {
            ucs2String[i + numAccents] = combiningAccents[k];
            numAccents++;
        }
        else if (combiningAccents[k] == COMBINING_SMOOTH_BREATHING && (accentBitMask & _SMOOTH) == _SMOOTH)
        {
            ucs2String[i + numAccents] = combiningAccents[k];
            numAccents++;
        }
        else if (combiningAccents[k] == COMBINING_ACUTE && (accentBitMask & _ACUTE) == _ACUTE)
        {
            ucs2String[i + numAccents] = combiningAccents[k];
            numAccents++;
        }
        else if (combiningAccents[k] == COMBINING_GRAVE && (accentBitMask & _GRAVE) == _GRAVE)
        {
            ucs2String[i + numAccents] = combiningAccents[k];
            numAccents++;
        }
        else if (combiningAccents[k] == COMBINING_CIRCUMFLEX && (accentBitMask & _CIRCUMFLEX) == _CIRCUMFLEX)
        {
            ucs2String[i + numAccents] = combiningAccents[k];
            numAccents++;
        }
        else if (combiningAccents[k] == COMBINING_IOTA_SUBSCRIPT && (accentBitMask & _IOTA_SUB) == _IOTA_SUB)
        {
            ucs2String[i + numAccents] = combiningAccents[k];
            numAccents++;
        }
        else if (combiningAccents[k] == COMBINING_DIAERESIS && (accentBitMask & _DIAERESIS) == _DIAERESIS)
        {
            ucs2String[i + numAccents] = combiningAccents[k];
            numAccents++;
        }
        else if (combiningAccents[k] == COMBINING_UNDERDOT && (accentBitMask & _UNDERDOT) == _UNDERDOT)
        {
            ucs2String[i + numAccents] = combiningAccents[k];
            numAccents++;
        }
    }
    return true;
}

bool makeLetter(UCS2 *ucs2String, int *newLetterLen, UCS2 letter, unsigned int accentBitMask, int unicodeMode)
{
    //Use PUA, - almost all precomposing except alpha macron, breathing, accent, iota_sub, if iota_sub use combining
    //Use both, if macron use combining
    //Use only combining accents
    int i = 0;

    //fallback if macron + one more diacritic
    bool precomposingFallbackToComposing = false;
    if ((unicode_mode == PRECOMPOSED_MODE && (accentBitMask & _MACRON) == _MACRON) || (unicodeMode == PRECOMPOSED_WITH_PUA_MODE && (accentBitMask & (_MACRON | _DIAERESIS)) == (_MACRON | _DIAERESIS)))
    {
        if ((accentBitMask & ~_MACRON) != 0)//if any other bits set besides macron
        {
            precomposingFallbackToComposing = true;
        }
    }
    else if ((unicode_mode == PRECOMPOSED_MODE && (accentBitMask & _BREVE) == _BREVE))
    {
        if ((accentBitMask & ~_BREVE) != 0)//if any other bits set besides macron
        {
            precomposingFallbackToComposing = true;
        }
    }
    else if (unicodeMode == PRECOMPOSED_HC_MODE && (accentBitMask & _MACRON) == _MACRON)
    {
        //this is legacy for the hoplite challenge app which uses combining macron even if no other diacritics
        precomposingFallbackToComposing = true;
    }
    
    *newLetterLen = 1;
    if (unicode_mode == COMBINING_ONLY_MODE || precomposingFallbackToComposing)
    {
        return makeLetterCombining(ucs2String, newLetterLen, letter, accentBitMask, unicodeMode);
    }
    else
    {
        //fix me
        bool needToAddIotaSubscript = false;
        if (unicode_mode == PRECOMPOSED_WITH_PUA_MODE && (accentBitMask & (_IOTA_SUB | _MACRON)) == (_IOTA_SUB | _MACRON))
        {
            needToAddIotaSubscript = true;
            accentBitMask &= ~_IOTA_SUB; //so we don't get two iota subscripts
        }

        int letterIndex = ucs2ToLetterIndex(letter);
        if (letterIndex < 0)
        {
            //still add underdot even if not a vowel
            if ((accentBitMask & _UNDERDOT) == _UNDERDOT)
            {
                ucs2String[i+1] = COMBINING_UNDERDOT;
                (*newLetterLen)++;
                return true;
            }
            else
            {
                return false;
            }
        }

        bool needToAddUnderdot = false;
        if ((accentBitMask & _UNDERDOT) == _UNDERDOT)
        {
            needToAddUnderdot = true;
            accentBitMask &= ~_UNDERDOT; //turn off while we add precomposed char
        }
        UCS2 ucs2 = getPrecomposedLetter(letterIndex, accentBitMask);
        if (ucs2 != 0)
        {
            ucs2String[i] = ucs2;
            if (needToAddIotaSubscript)
            {
                (*newLetterLen)++;
                ucs2String[++i] = COMBINING_IOTA_SUBSCRIPT;
            }
            if (needToAddUnderdot)
            {
                ucs2String[++i] = COMBINING_UNDERDOT;
                (*newLetterLen)++;
            }
            return true;
        }
        else
        {
            return false;
        }
    }
}

UCS2 getSpacingDiacritic(int diacritic)
{
    switch (diacritic)
    {
        case ACUTE:
            return 0x00B4;
            break;
        case GRAVE:
            return 0x0060;
            break;
        case CIRCUMFLEX:
            return 0x005E;
            break;
        case MACRON:
            return 0x00AF;
            break;
        case BREVE:
            return 0x02D8;
            break;
        case DIAERESIS:
            return 0x00A8;
            break;
        case ROUGH_BREATHING:
            return 0x02BD;
            break;
        case SMOOTH_BREATHING:
            return 0x02BC;
            break;
        case IOTA_SUBSCRIPT:
            return 0x037A;
            break;
        default:
            return 0;
    }
}

//there should be room for a least MAX_COMBINING more characters at the end of ucs2String, in case it needs to grow
void accentSyllable(UCS2 *ucs2String, int i, int *len, int accentToAdd, bool toggleOff, int unicodeMode)
{
    /* remove?
    if (accentToAdd == UNDERDOT)
    {
        if (ucs2String[*len - 1] == COMBINING_UNDERDOT)
        {
            //ucs2String[i + *len - 1] = 0x0000;
            //--(*len);
            ucsplice(ucs2String, len, 1024, i + *len - 1, 1, NULL, 0);

        } else {
            //ucs2String[i + *len] = COMBINING_UNDERDOT;
            //++(*len);
            ucsplice(ucs2String, len, 1024, i + *len, 0, (UCS2[]){COMBINING_UNDERDOT}, 1);
        }
        return;
    }
*/
    if (unicodeMode != PRECOMPOSED_MODE && unicodeMode != PRECOMPOSED_WITH_PUA_MODE && unicodeMode != COMBINING_ONLY_MODE && unicodeMode != PRECOMPOSED_HC_MODE)
    {
        unicodeMode = PRECOMPOSED_MODE;
    }
    unicode_mode = unicodeMode;
    if (*len < 1) {
        if (addSpacingDiacriticIfNotLegal) {
            UCS2 sd = getSpacingDiacritic(accentToAdd);
            if (sd) {
                ucs2String[i] = sd;
                *len = 1;
            }
        }
        return;
    }

    //1. handle consonants
    if (ucs2String[i] == GREEK_SMALL_LETTER_RHO && accentToAdd == ROUGH_BREATHING)
    {
        ucs2String[i] = GREEK_SMALL_LETTER_RHO_WITH_DASIA;
        return;
    }
    else if (ucs2String[i] == GREEK_SMALL_LETTER_RHO_WITH_DASIA && accentToAdd == ROUGH_BREATHING)
    {
        ucs2String[i] = GREEK_SMALL_LETTER_RHO;
        return;
    }
    else if (ucs2String[i] == GREEK_CAPITAL_LETTER_RHO && accentToAdd == ROUGH_BREATHING)
    {
        ucs2String[i] = GREEK_CAPITAL_LETTER_RHO_WITH_DASIA;
        return;
    }
    else if (ucs2String[i] == GREEK_CAPITAL_LETTER_RHO_WITH_DASIA && accentToAdd == ROUGH_BREATHING)
    {
        ucs2String[i] = GREEK_CAPITAL_LETTER_RHO;
        return;
    }
    else if (ucs2String[i] == GREEK_SMALL_LETTER_RHO_WITH_PSILI && accentToAdd == ROUGH_BREATHING)
    {
        ucs2String[i] = GREEK_SMALL_LETTER_RHO_WITH_DASIA;
        return;
    }
#ifdef ALLOW_RHO_WITH_PSILI
    else if (ucs2String[i] == GREEK_SMALL_LETTER_RHO && accentToAdd == SMOOTH_BREATHING)
    {
        ucs2String[i] = GREEK_SMALL_LETTER_RHO_WITH_PSILI;
        return;
    }
    else if (ucs2String[i] == GREEK_SMALL_LETTER_RHO_WITH_PSILI && accentToAdd == SMOOTH_BREATHING)
    {
        ucs2String[i] = GREEK_SMALL_LETTER_RHO;
        return;
    }
    else if (ucs2String[i] == GREEK_SMALL_LETTER_RHO_WITH_DASIA && accentToAdd == SMOOTH_BREATHING)
    {
        ucs2String[i] = GREEK_SMALL_LETTER_RHO_WITH_PSILI;
        return;
    }
#endif
    else if (ucs2String[i] == GREEK_SMALL_LETTER_NU && accentToAdd == SURROUNDING_PARENTHESES)
    {
        /*rightShiftFromOffsetSteps(ucs2String, i, 2, len);
         ucs2String[i] = LEFT_PARENTHESIS;
         ucs2String[i+1] = GREEK_SMALL_LETTER_NU;
         ucs2String[i+2] = RIGHT_PARENTHESIS; */
        ucsplice(ucs2String, len, 1024, i, 1, (UCS2[]){LEFT_PARENTHESIS,GREEK_SMALL_LETTER_NU,RIGHT_PARENTHESIS }, 3);
        return;
    }

    //2. now analyze what is currently there
    UCS2 baseLetter = 0;
    unsigned int accentBitMask = 0;
    
    //this will be -1 on error
    int letterLen = analyzeLetter(ucs2String, i, *len, &baseLetter, &accentBitMask);

    if (letterLen < 1) {


        if (accentToAdd == UNDERDOT)
        {
            if ((accentBitMask & _UNDERDOT) == _UNDERDOT)
            {
                (*len)--;
            } else {
                ucsplice(ucs2String, len, 1024, i + *len, 0, (UCS2[]){COMBINING_UNDERDOT}, 1);
            }
        }
        else if (addSpacingDiacriticIfNotLegal) {
            UCS2 sd = getSpacingDiacritic(accentToAdd);
            if (sd) {
                ucs2String[i + 1] = sd;
                *len += 1;
            }
        }
        return;
    }

    //2.5: return if this diacritic isn't legal for the letter it's being added to
    if (!isLegalDiacriticForLetter(baseLetter, accentToAdd)) {
        if (addSpacingDiacriticIfNotLegal) {
            UCS2 sd = getSpacingDiacritic(accentToAdd);
            if (sd) {
                ucs2String[i + 1] = sd;
                *len += 1;
            }
        }
        return;
    }

    //3. this changes old letter analysis to the one we want
    accentBitMask = updateDiacritics(baseLetter, accentToAdd, accentBitMask, toggleOff);
    
    //4. this creates the new letter, either with combining or precomposed accents
    UCS2 buffer[MAX_COMBINING]; //this is letter plus max combining
    int newLetterLen = 0;
    if (!makeLetter(buffer, &newLetterLen, baseLetter, accentBitMask, unicodeMode))
        return;
    
    //5. make room for letter or decrease it if it is shrinking
    ucsplice(ucs2String, len, 1024, i, letterLen, buffer, newLetterLen);
}
/*
int compare(char *s1, char *s2)
{
    UCS2 us1[strlen(s1)*2];
    UCS2 us2[strlen(s2)*2];
    int us1len = 0;
    utf8_to_ucs2_string(s1, us1, &us1len);
    int us2len = 0;
    utf8_to_ucs2_string(s2, us2, &us2len);
    //stripaccent
    
    return 0;
}
*/

/*
 void accentSyllableUtf8(char *utf8, int accent, bool toggleOff)
 {
 
 UCS2 ucs2[20];
 unsigned long len = strlen(utf8);
 utf8_to_ucs2_string((unsigned char*)&utf8[len - 5], ucs2, (int*)&len);
 
 accentSyllable(ucs2, (int)len, (int*)&len, accent, toggleOff);
 
 ucs2_to_utf8_string(ucs2, (int)len, (unsigned char*)utf8);
 }
 */

//helper function to make it easier to import into swift
/*
 void accentSyllable16(uint16_t *ucs2String, int i, int *len, int accent, bool toggleOff, int mode)
 {
 accentSyllable2((UCS2*)ucs2String, i, len, accent, toggleOff, mode);
 }
 */
