---
title: 👋 Introduction
sidebar_position: 1
---

# Introduction to NotallyX

Welcome to the official documentation for **NotallyX**, a minimalistic yet powerful note-taking app for Android.

![NotallyX Logo](/img/logo.png)

## What is NotallyX?

NotallyX is an open-source note-taking application designed to be simple, intuitive, and feature-rich. It's an extended version of the original Notally app, with additional features and improvements.

Whether you need to jot down quick thoughts, create detailed task lists, or organize your ideas with colors and labels, NotallyX provides all the tools you need without unnecessary complexity.

## Key Features

- **Rich Text Notes**: Create notes with support for bold, italics, mono space, and strike-through formatting
- **Task Lists**: Organize your to-dos with subtasks and automatic sorting of completed items
- **Reminders**: Set notifications for important notes
- **File Attachments**: Add pictures, PDFs, and other files to your notes
- **Organization Tools**: Sort, color, pin, and label your notes for quick access
- **Security**: Lock your notes with biometric authentication or PIN
- **Backup**: Configure automatic backups to keep your notes safe
- **Widgets**: Access important notes directly from your home screen
- **Audio Notes**: Create quick audio recordings
- **Customization**: Extensive preferences to adjust the app to your liking

## Getting Started

Ready to start using NotallyX? Check out our [Quick Start Guide](quick-start.md) to learn the basics.


## Features Overview

NotallyX offers a wide range of features to help you capture, organize, and access your notes efficiently. This page provides an overview of the main features available in the app.

## Note Types

### Text Notes
Create rich text notes with formatting options:
- **Bold**, *italic*, ~~strikethrough~~, and `monospace` text
- Clickable links for websites, phone numbers, and email addresses
- Undo/redo functionality
- File attachments (images, record audios, PDFs, etc.)

### List Notes
Create structured to-do lists and checklists:
- Checkboxes for marking items as complete
- Hierarchical organization with subtasks
- Automatic sorting of completed items


## Organization Features

### Labels
Categorize your notes with labels:
- Create custom labels
- Filter notes by label
- Pin specific labels as starting page

### Colors
Visually distinguish your notes:
- Choose from preset colors
- Create custom colors
- Dark mode support for note colors

### Pinning
Keep important notes accessible:
- Pin notes to the top of the list
- Pinned notes remain visible regardless of sort order

### Sorting
Organize your notes in different ways:
- Sort by creation date
- Sort by modification date
- Sort by title
- Sort by color

## Security Features

### Note Locking
Protect sensitive notes via Biometric authentication (fingerprint or PIN)

### Auto-Backup
Keep your notes safe:
- Configurable automatic backups
- Auto backup on any note change
- Backup to device storage
- Restore from backup

### Import from other Apps
Currently you can import notes from:
- Google Keep
- Evernote
- Plain Text files
- JSON Files

## Interface Features

### View Options
Customize how your notes are displayed:
- List view
- Grid view
- Adjustable note preview size

### Home Screen Widgets
Access your notes directly from your home screen:
- Note list widgets
- Individual note widgets
- Customizable widget appearance

### Dark Mode
Reduce eye strain in low-light conditions:
- System-based dark mode
- Pure dark mode option
- Dark mode for note colors

## Additional Features

### Search
Find your notes quickly:
- Full-text search
- Search within specific labels
- Search by title or content

### Sharing
Share your notes with others:
- Text sharing
- Export as text files
- Share as images

### Reminders
Never forget important information:
- Set date and time reminders
- Notification alerts
- Recurring reminders

## Feature Details

For more detailed information about specific features, check out the following pages:
- ✏️ [Rich Text Formatting](features/rich-text.mdx)
- 📋 [Task Lists and Subtasks](features/task-lists.mdx)
- 🏷️ [Labels and Organization](features/labels.mdx)
- 🛡️ [Security and Privacy](security-privacy.mdx)
- ⚙️ [Settings](settings.mdx)
- 🔔 [Reminders](features/reminders.mdx)

## Contributing

NotallyX is an open-source project, and contributions are welcome! Check out our [Contribution Guidelines](contributing.md) to learn how you can help improve the app.
