# Security Policy

We take the security of PennyWise seriously and appreciate responsible disclosure.

## Reporting a Vulnerability

- Prefer private reports via GitHub Security Advisories: use the “Report a vulnerability” button on this repository’s Security tab.
- If that option isn't available, please contact the maintainers privately via Discord and request a private channel: [Join Discord](https://discord.gg/H3xWeMWjKQ). Do not include exploit details in public channels or issues.
- As a last resort, you may open a GitHub issue titled “Security: Request private contact” without technical details; maintainers will move the discussion to a private channel.

When reporting, include where possible:
- A clear description of the issue and potential impact
- Steps to reproduce and a minimal proof of concept
- Affected app version/build (from the latest GitHub Release preferred)
- Environment details (device model, Android version)
- Any relevant logs or screenshots

## Responsible Disclosure

- Please do not publicly disclose the vulnerability prior to a coordinated fix and release.
- We will credit reporters who wish to be acknowledged once a fix is released.
- No bug bounty program at this time.

## Our Response Targets

- Acknowledgement: within 48 hours
- Initial triage and status: within 5 business days
- Fix timeline: we aim to release a fix within 90 days, with periodic updates if it requires more time

## Supported Versions

Security fixes are provided for the latest stable release published on GitHub Releases. Pre‑releases and older versions may not receive patches.

## Scope and Out‑of‑Scope

In scope:
- Vulnerabilities in this repository’s source code and Android app behavior

Out of scope (non‑exhaustive):
- Social engineering, spam, or denial‑of‑service attacks
- Issues requiring physical access or rooted/jailbroken devices
- Third‑party service or library vulnerabilities (please report upstream)
- Findings that only affect unsupported Android versions or modified OS builds

## Safe Harbor

We will not pursue legal action for good‑faith, non‑disruptive research that respects user privacy, avoids data exfiltration, and follows this policy. Please do not access, modify, or destroy data that is not your own.
