import { performance } from 'node:perf_hooks';
import { c as createBirpc } from './vendor/index.cAUulNDf.js';
import { workerId } from 'tinypool';
import { g as getWorkerState } from './vendor/global.L7JRz1qU.js';
import { l as loadEnvironment } from './vendor/loader.zIj6SiI8.js';
import { s as startViteNode, m as moduleCache, a as mockMap } from './vendor/execute.1R_t2FPL.js';
import { s as setupInspect } from './vendor/inspector.lFAeuaAt.js';
import { r as rpcDone, c as createSafeRpc } from './vendor/rpc.Bl-ysZIr.js';
import 'pathe';
import 'vite-node/client';
import './vendor/environments.v4R4vGad.js';
import 'node:console';
import 'local-pkg';
import 'node:url';
import 'node:vm';
import 'vite-node/utils';
import '@vitest/utils/error';
import './paths.js';
import 'node:fs';
import '@vitest/utils';
import './vendor/base._79unx2z.js';
import 'node:path';
import 'node:module';
import 'vite-node/constants';

async function init(ctx) {
  var _a, _b;
  const isInitialized = typeof __vitest_worker__ !== "undefined";
  const isIsolatedThreads = ctx.config.pool === "threads" && (((_b = (_a = ctx.config.poolOptions) == null ? void 0 : _a.threads) == null ? void 0 : _b.isolate) ?? true);
  if (isInitialized && isIsolatedThreads)
    throw new Error(`worker for ${ctx.files.join(",")} already initialized by ${getWorkerState().ctx.files.join(",")}. This is probably an internal bug of Vitest.`);
  const { config, port, workerId: workerId$1, providedContext } = ctx;
  process.env.VITEST_WORKER_ID = String(workerId$1);
  process.env.VITEST_POOL_ID = String(workerId);
  let setCancel = (_reason) => {
  };
  const onCancel = new Promise((resolve) => {
    setCancel = resolve;
  });
  const rpc = createSafeRpc(createBirpc(
    {
      onCancel: setCancel
    },
    {
      eventNames: ["onUserConsoleLog", "onFinished", "onCollected", "onWorkerExit", "onCancel"],
      post(v) {
        port.postMessage(v);
      },
      on(fn) {
        port.addListener("message", fn);
      }
    }
  ));
  const environment = await loadEnvironment(ctx.environment.name, {
    root: ctx.config.root,
    fetchModule: (id) => rpc.fetch(id, "ssr"),
    resolveId: (id, importer) => rpc.resolveId(id, importer, "ssr")
  });
  if (ctx.environment.transformMode)
    environment.transformMode = ctx.environment.transformMode;
  const state = {
    ctx,
    moduleCache,
    config,
    mockMap,
    onCancel,
    environment,
    durations: {
      environment: 0,
      prepare: performance.now()
    },
    rpc,
    providedContext
  };
  Object.defineProperty(globalThis, "__vitest_worker__", {
    value: state,
    configurable: true,
    writable: true,
    enumerable: false
  });
  if (ctx.invalidates) {
    ctx.invalidates.forEach((fsPath) => {
      moduleCache.delete(fsPath);
      moduleCache.delete(`mock:${fsPath}`);
    });
  }
  ctx.files.forEach((i) => moduleCache.delete(i));
  return state;
}
async function run(ctx) {
  const inspectorCleanup = setupInspect(ctx.config);
  try {
    const state = await init(ctx);
    const { run: run2, executor } = await startViteNode({ state });
    await run2(ctx.files, ctx.config, { environment: state.environment, options: ctx.environment.options }, executor);
    await rpcDone();
  } finally {
    inspectorCleanup();
  }
}

export { run };
