import { resolve, normalize } from 'pathe';
import { ViteNodeRunner } from 'vite-node/client';
import { e as environments } from './environments.v4R4vGad.js';

function isBuiltinEnvironment(env) {
  return env in environments;
}
const _loaders = /* @__PURE__ */ new Map();
async function createEnvironmentLoader(options) {
  if (!_loaders.has(options.root)) {
    const loader = new ViteNodeRunner(options);
    await loader.executeId("/@vite/env");
    _loaders.set(options.root, loader);
  }
  return _loaders.get(options.root);
}
async function loadEnvironment(name, options) {
  var _a;
  if (isBuiltinEnvironment(name))
    return environments[name];
  const loader = await createEnvironmentLoader(options);
  const root = loader.root;
  const packageId = name[0] === "." || name[0] === "/" ? resolve(root, name) : ((_a = await options.resolveId(`vitest-environment-${name}`)) == null ? void 0 : _a.id) ?? resolve(root, name);
  const pkg = await loader.executeId(normalize(packageId));
  if (!pkg || !pkg.default || typeof pkg.default !== "object") {
    throw new TypeError(
      `Environment "${name}" is not a valid environment. Path "${packageId}" should export default object with a "setup" or/and "setupVM" method.`
    );
  }
  const environment = pkg.default;
  if (environment.transformMode !== "web" && environment.transformMode !== "ssr") {
    throw new TypeError(
      `Environment "${name}" is not a valid environment. Path "${packageId}" should export default object with a "transformMode" method equal to "ssr" or "web".`
    );
  }
  return environment;
}

export { loadEnvironment as l };
