import { performance } from 'node:perf_hooks';
import v8 from 'node:v8';
import { c as createBirpc } from './vendor/index.cAUulNDf.js';
import { parseRegexp } from '@vitest/utils';
import { workerId } from 'tinypool';
import { l as loadEnvironment } from './vendor/loader.zIj6SiI8.js';
import { s as startViteNode, m as moduleCache, a as mockMap } from './vendor/execute.1R_t2FPL.js';
import { r as rpcDone, c as createSafeRpc } from './vendor/rpc.Bl-ysZIr.js';
import { s as setupInspect } from './vendor/inspector.lFAeuaAt.js';
import 'pathe';
import 'vite-node/client';
import './vendor/environments.v4R4vGad.js';
import 'node:console';
import 'local-pkg';
import 'node:url';
import 'node:vm';
import 'vite-node/utils';
import '@vitest/utils/error';
import './paths.js';
import 'node:fs';
import './vendor/base._79unx2z.js';
import 'node:path';
import 'node:module';
import 'vite-node/constants';
import './vendor/global.L7JRz1qU.js';

try {
  process.title = `node (vitest ${workerId})`;
} catch {
}
async function init(ctx) {
  const { config, workerId: workerId$1, providedContext } = ctx;
  process.env.VITEST_WORKER_ID = String(workerId$1);
  process.env.VITEST_POOL_ID = String(workerId);
  let setCancel = (_reason) => {
  };
  const onCancel = new Promise((resolve) => {
    setCancel = resolve;
  });
  const rpc = createSafeRpc(createBirpc(
    {
      onCancel: setCancel
    },
    {
      eventNames: ["onUserConsoleLog", "onFinished", "onCollected", "onWorkerExit", "onCancel"],
      serialize: v8.serialize,
      deserialize: (v) => v8.deserialize(Buffer.from(v)),
      post(v) {
        var _a;
        (_a = process.send) == null ? void 0 : _a.call(process, v);
      },
      on(fn) {
        process.on("message", (message, ...extras) => {
          if (message == null ? void 0 : message.__tinypool_worker_message__)
            return;
          return fn(message, ...extras);
        });
      }
    }
  ));
  const environment = await loadEnvironment(ctx.environment.name, {
    root: ctx.config.root,
    fetchModule: (id) => rpc.fetch(id, "ssr"),
    resolveId: (id, importer) => rpc.resolveId(id, importer, "ssr")
  });
  if (ctx.environment.transformMode)
    environment.transformMode = ctx.environment.transformMode;
  const state = {
    ctx,
    moduleCache,
    config,
    mockMap,
    onCancel,
    environment,
    durations: {
      environment: 0,
      prepare: performance.now()
    },
    rpc,
    providedContext,
    isChildProcess: true
  };
  Object.defineProperty(globalThis, "__vitest_worker__", {
    value: state,
    configurable: true,
    writable: true,
    enumerable: false
  });
  if (ctx.invalidates) {
    ctx.invalidates.forEach((fsPath) => {
      moduleCache.delete(fsPath);
      moduleCache.delete(`mock:${fsPath}`);
    });
  }
  ctx.files.forEach((i) => moduleCache.delete(i));
  return state;
}
function parsePossibleRegexp(str) {
  const prefix = "$$vitest:";
  if (typeof str === "string" && str.startsWith(prefix))
    return parseRegexp(str.slice(prefix.length));
  return str;
}
function unwrapConfig(config) {
  if (config.testNamePattern)
    config.testNamePattern = parsePossibleRegexp(config.testNamePattern);
  return config;
}
async function run(ctx) {
  const exit = process.exit;
  ctx.config = unwrapConfig(ctx.config);
  const inspectorCleanup = setupInspect(ctx.config);
  try {
    const state = await init(ctx);
    const { run: run2, executor } = await startViteNode({
      state
    });
    await run2(ctx.files, ctx.config, { environment: state.environment, options: ctx.environment.options }, executor);
    await rpcDone();
  } finally {
    inspectorCleanup();
    process.exit = exit;
  }
}

export { run };
