import BaseStyle from 'primevue/base/style';

var css = "\n@layer primevue {\n    .p-scrolltop {\n        position: fixed;\n        bottom: 20px;\n        right: 20px;\n        display: flex;\n        align-items: center;\n        justify-content: center;\n    }\n\n    .p-scrolltop-sticky {\n        position: sticky;\n    }\n\n    .p-scrolltop-sticky.p-link {\n        margin-left: auto;\n    }\n\n    .p-scrolltop-enter-from {\n        opacity: 0;\n    }\n\n    .p-scrolltop-enter-active {\n        transition: opacity 0.15s;\n    }\n\n    .p-scrolltop.p-scrolltop-leave-to {\n        opacity: 0;\n    }\n\n    .p-scrolltop-leave-active {\n        transition: opacity 0.15s;\n    }\n}\n";
var classes = {
  root: function root(_ref) {
    var props = _ref.props;
    return ['p-scrolltop p-link p-component', {
      'p-scrolltop-sticky': props.target !== 'window'
    }];
  },
  icon: 'p-scrolltop-icon'
};
var ScrollTopStyle = BaseStyle.extend({
  name: 'scrolltop',
  css: css,
  classes: classes
});

export { ScrollTopStyle as default };
